/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;

public class CoulombCartoonGenerator {
    private static final Location origin = new Location(0.0, 0.0);
    private static final double half_pi = 1.5707963267948966;

    public static void main(String[] args) throws IOException {
        File mdDir = new File("/home/kevin/git/misc-research/coulomb_cartoons");
        Preconditions.checkState((mdDir.exists() || mdDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(mdDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        double mainX = 0.0;
        double mainY = 0.0;
        double mainLen = 10.0;
        double mainAz = 1.5707963267948966;
        double compLen = mainLen;
        double upperDepth = 0.0;
        double ddw = 10.0;
        ArrayList<Point2D.Double> compLocs = new ArrayList<Point2D.Double>();
        ArrayList<String> compLocNames = new ArrayList<String>();
        ArrayList<String> compLocPrefixes = new ArrayList<String>();
        compLocs.add(new Point2D.Double(mainLen, 0.0));
        compLocNames.add("End-to-End");
        compLocPrefixes.add("ends");
        compLocs.add(new Point2D.Double(mainLen + 5.0, 0.0));
        compLocNames.add("Offset X=5km");
        compLocPrefixes.add("offset_x_5km");
        compLocs.add(new Point2D.Double(mainLen, 5.0));
        compLocNames.add("Offset Y=5km");
        compLocPrefixes.add("offset_y_5km");
        compLocs.add(new Point2D.Double(mainLen + Math.sqrt(5.0), Math.sqrt(5.0)));
        compLocNames.add("Offset X&Y=&Sqrt;5km");
        compLocPrefixes.add("offset_xy_sqrt_5km");
        SubSectStiffnessCalculator.StiffnessType mainType = SubSectStiffnessCalculator.StiffnessType.CFF;
        SubSectStiffnessCalculator.StiffnessType[] compTypes = new SubSectStiffnessCalculator.StiffnessType[]{SubSectStiffnessCalculator.StiffnessType.TAU, SubSectStiffnessCalculator.StiffnessType.SIGMA};
        double[] compRelAzimuthsDeg = new double[]{-150.0, -120.0, -90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0, 120.0, 150.0};
        double gridSpacing = 1.0;
        double lambda = 30000.0;
        double mu = 30000.0;
        double coeffOfFriction = 0.5;
        double stiffnessCap = 1.0;
        SubSectStiffnessCalculator.PatchAlignment alignment = SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point2D : compLocs) {
            maxX = Math.max(maxX, point2D.getX() + compLen);
            maxY = Math.max(maxY, point2D.getY() + compLen);
        }
        Range xRange = new Range(-1.0, maxX + 1.0);
        Range range = new Range(-maxY, maxY);
        ArrayList<Double> rakes = new ArrayList<Double>();
        ArrayList<Double> dips = new ArrayList<Double>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        rakes.add(180.0);
        dips.add(90.0);
        names.add("Right-Lateral Strike-Slip");
        prefixes.add("rl_ss");
        rakes.add(0.0);
        dips.add(90.0);
        names.add("Left-Lateral Strike-Slip");
        prefixes.add("ll_ss");
        rakes.add(90.0);
        dips.add(45.0);
        names.add("Reverse");
        prefixes.add("rev");
        rakes.add(-90.0);
        dips.add(45.0);
        names.add("Normal");
        prefixes.add("norm");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Coulomb Cartoons");
        lines.add("");
        int summaryIndex = lines.size();
        String topLink = "*[(top)](#summary)*";
        ArrayList<MarkdownUtils.TableBuilder> summaryTables = new ArrayList<MarkdownUtils.TableBuilder>();
        for (int l = 0; l < compLocs.size(); ++l) {
            MarkdownUtils.TableBuilder summaryTable = MarkdownUtils.tableBuilder();
            summaryTables.add(summaryTable);
            summaryTable.initNewLine().addColumn("Source");
            for (int i = 0; i < names.size(); ++i) {
                summaryTable.addColumn("To " + (String)names.get(i));
            }
            summaryTable.finalizeLine();
            String locName = (String)compLocNames.get(l);
            String locPrefix = (String)compLocPrefixes.get(l);
            Point2D compLoc = (Point2D)compLocs.get(l);
            lines.add("## " + locName);
            lines.add(topLink);
            lines.add("");
            for (int i = 0; i < names.size(); ++i) {
                String sourceName = (String)names.get(i);
                String header = "### " + sourceName + ", " + locName;
                lines.add(header);
                lines.add(topLink);
                lines.add("");
                FaultSection sourceSect = CoulombCartoonGenerator.buildSect(mainX, mainY, mainAz, mainLen, upperDepth, ddw, (Double)dips.get(i), (Double)rakes.get(i));
                sourceSect.setSectionId(0);
                summaryTable.initNewLine();
                summaryTable.addColumn("[**" + sourceName + "**](#" + MarkdownUtils.getAnchorName(header) + ")");
                for (int j = 0; j < names.size(); ++j) {
                    String receiverName = (String)names.get(j);
                    lines.add("#### " + sourceName + " -> " + receiverName + ", " + locName);
                    lines.add(topLink);
                    lines.add("");
                    ArrayList<FaultSection> sectsList = new ArrayList<FaultSection>();
                    sectsList.add(sourceSect);
                    ArrayList<FaultSection> receivers = new ArrayList<FaultSection>();
                    for (double recAz : compRelAzimuthsDeg) {
                        double azimuth = mainAz + Math.toRadians(recAz);
                        FaultSection receiverSect = CoulombCartoonGenerator.buildSect(compLoc.getX(), compLoc.getY(), azimuth, compLen, upperDepth, ddw, (Double)dips.get(j), (Double)rakes.get(j));
                        receiverSect.setSectionId(sectsList.size());
                        sectsList.add(receiverSect);
                        receivers.add(receiverSect);
                    }
                    SubSectStiffnessCalculator stiffCalc = new SubSectStiffnessCalculator(sectsList, gridSpacing, lambda, mu, coeffOfFriction, alignment, stiffnessCap);
                    AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(mainType, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
                    System.out.println("Calculating from " + sourceName + " to " + receiverName);
                    String title = sourceName + " -> " + receiverName;
                    List<Double> vals = CoulombCartoonGenerator.calc(sourceSect, receivers, aggCalc);
                    double maxVal = CoulombCartoonGenerator.max(vals);
                    double maxAbsVal = CoulombCartoonGenerator.maxAbs(vals);
                    ArrayList<List<Double>> compVals = new ArrayList<List<Double>>();
                    ArrayList<Double> compMaxVals = new ArrayList<Double>();
                    if (compTypes != null && compTypes.length > 0) {
                        for (SubSectStiffnessCalculator.StiffnessType type : compTypes) {
                            AggregatedStiffnessCalculator compCalc = new AggregatedStiffnessCalculator(type, stiffCalc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
                            List<Double> comp = CoulombCartoonGenerator.calc(sourceSect, receivers, compCalc);
                            compVals.add(comp);
                            compMaxVals.add(CoulombCartoonGenerator.max(comp));
                        }
                    }
                    double cptMax = maxAbsVal > 175.0 ? 100.0 * Math.floor(maxAbsVal / 100.0) : Math.max(50.0, 50.0 * Math.floor(maxAbsVal / 50.0));
                    CPT cpt = new CPT(-cptMax, cptMax, Color.BLUE.darker().darker(), Color.BLUE, Color.WHITE, Color.RED, Color.RED.darker().darker());
                    String mainPrefix = "src_" + (String)prefixes.get(i) + "_rec_" + (String)prefixes.get(j) + "_" + mainType.name() + "_" + locPrefix;
                    CoulombCartoonGenerator.plot(resourcesDir, cpt, xRange, range, title, mainType, sourceSect, receivers, vals, mainPrefix);
                    summaryTable.addColumn("![plot](resources/" + mainPrefix + ".png)");
                    lines.add("![plot](resources/" + mainPrefix + ".png)");
                    lines.add("");
                    MarkdownUtils.TableBuilder valTable = MarkdownUtils.tableBuilder();
                    valTable.initNewLine().addColumn("Azimuth Change").addColumn(mainType.getHTML()).addColumn(mainType.getHTML() + "/Max");
                    if (compTypes != null && compTypes.length > 0) {
                        MarkdownUtils.TableBuilder compTable = MarkdownUtils.tableBuilder().initNewLine();
                        for (SubSectStiffnessCalculator.StiffnessType type : compTypes) {
                            compTable.addColumn(type.getHTML());
                            valTable.addColumn(type.getHTML());
                            valTable.addColumn(type.getHTML() + "/Max");
                        }
                        compTable.finalizeLine();
                        compTable.initNewLine();
                        for (int c = 0; c < compTypes.length; ++c) {
                            SubSectStiffnessCalculator.StiffnessType type = compTypes[c];
                            String compPrefix = "src_" + (String)prefixes.get(i) + "_rec_" + (String)prefixes.get(j) + "_" + type.name() + "_" + locPrefix;
                            CoulombCartoonGenerator.plot(resourcesDir, cpt, xRange, range, title, type, sourceSect, receivers, (List)compVals.get(c), compPrefix);
                            compTable.addColumn("![plot](resources/" + compPrefix + ".png)");
                        }
                        compTable.finalizeLine();
                        lines.addAll(compTable.build());
                        lines.add("");
                    }
                    valTable.finalizeLine();
                    for (int r = 0; r < receivers.size(); ++r) {
                        double val = vals.get(r);
                        valTable.initNewLine();
                        valTable.addColumn((int)compRelAzimuthsDeg[r]);
                        valTable.addColumn(Float.valueOf((float)val)).addColumn(Float.valueOf((float)(val / maxVal)));
                        for (int c = 0; c < compTypes.length; ++c) {
                            double compVal = (Double)((List)compVals.get(c)).get(r);
                            valTable.addColumn(Float.valueOf((float)compVal)).addColumn(Float.valueOf((float)(val / (Double)compMaxVals.get(c))));
                        }
                        valTable.finalizeLine();
                    }
                    lines.addAll(valTable.build());
                    lines.add("");
                }
                summaryTable.finalizeLine();
            }
        }
        ArrayList<Object> summaryLines = new ArrayList<Object>();
        summaryLines.add("## Summary");
        for (int l = 0; l < compLocNames.size(); ++l) {
            summaryLines.add("");
            summaryLines.add("**" + (String)compLocNames.get(l) + "**");
            summaryLines.add("");
            summaryLines.addAll(((MarkdownUtils.TableBuilder)summaryTables.get(l)).build());
        }
        summaryLines.add("");
        lines.addAll(summaryIndex, summaryLines);
        MarkdownUtils.writeReadmeAndHTML(lines, mdDir);
    }

    private static double max(List<Double> values) {
        double max = Double.NEGATIVE_INFINITY;
        for (double val : values) {
            max = Math.max(val, max);
        }
        return max;
    }

    private static double maxAbs(List<Double> values) {
        double max = 0.0;
        for (double val : values) {
            max = Math.max(Math.abs(val), max);
        }
        return max;
    }

    private static List<Double> calc(FaultSection sourceSect, List<FaultSection> receivers, AggregatedStiffnessCalculator aggCalc) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int r = 0; r < receivers.size(); ++r) {
            FaultSection receiver = receivers.get(r);
            double val = aggCalc.calc(sourceSect, receiver);
            vals.add(val);
        }
        return vals;
    }

    private static List<Double> plot(File resourcesDir, CPT cpt, Range xRange, Range yRange, String title, SubSectStiffnessCalculator.StiffnessType type, FaultSection sourceSect, List<FaultSection> receivers, List<Double> vals, String mainPrefix) throws IOException {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        CoulombCartoonGenerator.plot(sourceSect, Color.GREEN.darker(), funcs, chars);
        for (int r = 0; r < receivers.size(); ++r) {
            FaultSection receiver = receivers.get(r);
            double val = vals.get(r);
            vals.add(val);
            Color color = cpt.getColor((float)val);
            CoulombCartoonGenerator.plot(receiver, color, funcs, chars);
        }
        double cptDelta = cpt.getMaxValue() >= 200.0 ? 50.0 : (cpt.getMaxValue() >= 100.0 ? 25.0 : (cpt.getMaxValue() >= 20.0 ? 10.0 : (cpt.getMaxValue() >= 10.0 ? 5.0 : 2.0)));
        PaintScaleLegend cptLegend = GraphPanel.getLegendForCPT(cpt, type.toString(), 22, 18, cptDelta, RectangleEdge.BOTTOM);
        PlotSpec spec = new PlotSpec(funcs, chars, title, "X (km)", "Y (km)");
        spec.addSubtitle((Title)cptLegend);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setLegendFontSize(22);
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        gp.getChartPanel().setSize(1000, 1000);
        File pngFile = new File(resourcesDir, mainPrefix + ".png");
        File pdfFile = new File(resourcesDir, mainPrefix + ".pdf");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        return vals;
    }

    private static Location loc(double x, double y) {
        Location ret = origin;
        if (x != 0.0) {
            ret = LocationUtils.location(ret, 1.5707963267948966, x);
        }
        if (y != 0.0) {
            ret = LocationUtils.location(ret, 0.0, y);
        }
        return ret;
    }

    private static Point2D pt(Location loc) {
        double y;
        double x;
        if (loc.getLongitude() == origin.getLongitude()) {
            x = 0.0;
        } else {
            x = LocationUtils.horzDistanceFast(origin, new Location(origin.getLatitude(), loc.getLongitude()));
            if (loc.getLongitude() < origin.getLongitude()) {
                x = -x;
            }
        }
        if (loc.getLatitude() == origin.getLatitude()) {
            y = 0.0;
        } else {
            y = LocationUtils.horzDistanceFast(origin, new Location(loc.getLatitude(), origin.getLongitude()));
            if (loc.getLatitude() < origin.getLatitude()) {
                y = -y;
            }
        }
        return new Point2D.Double(x, y);
    }

    private static FaultSection buildSect(double x, double y, double azimuth, double len, double upperDepth, double ddw, double dip, double rake) {
        Location startLoc = CoulombCartoonGenerator.loc(x, y);
        Location endLoc = LocationUtils.location(startLoc, azimuth, len);
        FaultTrace trace = new FaultTrace(null);
        trace.add(startLoc);
        trace.add(endLoc);
        FaultSectionPrefData sect = new FaultSectionPrefData();
        sect.setAveRake(rake);
        sect.setFaultTrace(trace);
        sect.setAveDip(dip);
        sect.setAveUpperDepth(upperDepth);
        double lowerDepth = Math.sin(Math.toRadians(dip)) * ddw;
        sect.setAveLowerDepth(lowerDepth);
        sect.setDipDirection((float)(trace.getAveStrike() + 90.0));
        return sect;
    }

    private static void plot(FaultSection sect, Color color, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars) {
        FaultTrace trace = sect.getFaultTrace();
        LocationVector traceHalfVect = LocationUtils.vector(trace.first(), trace.last());
        traceHalfVect.setHorzDistance(0.5 * traceHalfVect.getHorzDistance());
        Location center = LocationUtils.location(trace.first(), traceHalfVect);
        PlotCurveCharacterstics arrowChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
        double arrowLen = 0.1 * trace.getTraceLength();
        if (sect.getAveDip() != 90.0) {
            double fwOffset;
            double hwOffset;
            RuptureSurface surf = sect.getFaultSurface(1.0, false, false);
            LocationList perim = surf.getPerimeter();
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int i = 0; i <= perim.size(); ++i) {
                xy.set(CoulombCartoonGenerator.pt((Location)perim.get(i % perim.size())));
            }
            funcs.add(0, xy);
            chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY));
            if (sect.getAveRake() > 0.0) {
                hwOffset = 0.75 * arrowLen;
                fwOffset = 0.75 * arrowLen;
            } else {
                hwOffset = 0.25 * arrowLen;
                fwOffset = 0.25 * arrowLen;
            }
            LocationVector hwSlip = CoulombCartoonGenerator.calcSlipVector(sect, false);
            Location hwCenter = LocationUtils.location(center, new LocationVector(trace.getAveStrike() + 90.0, hwOffset, 0.0));
            hwSlip.setHorzDistance(hwSlip.getHorzDistance() * arrowLen);
            Location hwTo = LocationUtils.location(hwCenter, hwSlip);
            funcs.add(CoulombCartoonGenerator.arrow(hwCenter, hwTo, arrowLen * 0.4));
            chars.add(arrowChar);
            Location fwCenter = LocationUtils.location(center, new LocationVector(trace.getAveStrike() - 90.0, fwOffset, 0.0));
            LocationVector fwSlip = CoulombCartoonGenerator.calcSlipVector(sect, true);
            fwSlip.setHorzDistance(fwSlip.getHorzDistance() * arrowLen);
            Location fwTo = LocationUtils.location(fwCenter, fwSlip);
            funcs.add(CoulombCartoonGenerator.arrow(fwCenter, fwTo, arrowLen * 0.4));
            chars.add(arrowChar);
        } else {
            double offset = 0.5 * arrowLen;
            Location hwCenter = LocationUtils.location(center, new LocationVector(trace.getAveStrike() + 90.0, offset, 0.0));
            LocationVector hwSlip = CoulombCartoonGenerator.calcSlipVector(sect, false);
            hwSlip.setHorzDistance(arrowLen);
            Location hwTo = LocationUtils.location(hwCenter, hwSlip);
            funcs.add(CoulombCartoonGenerator.arrow(hwCenter, hwTo, arrowLen * 0.4));
            chars.add(arrowChar);
            Location fwCenter = LocationUtils.location(center, new LocationVector(trace.getAveStrike() - 90.0, offset, 0.0));
            LocationVector fwSlip = CoulombCartoonGenerator.calcSlipVector(sect, true);
            fwSlip.setHorzDistance(arrowLen);
            Location fwTo = LocationUtils.location(fwCenter, fwSlip);
            funcs.add(CoulombCartoonGenerator.arrow(fwCenter, fwTo, arrowLen * 0.4));
            chars.add(arrowChar);
        }
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        for (Location loc : trace) {
            xy.set(CoulombCartoonGenerator.pt(loc));
        }
        funcs.add(xy);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color));
    }

    private static LocationVector calcSlipVector(FaultSection sect, boolean footwall) {
        double strike = sect.getFaultTrace().getAveStrike();
        double rake = sect.getAveRake();
        double dip = sect.getAveDip();
        if (footwall) {
            rake = FaultUtils.getInRakeRange(rake + 180.0);
        }
        double azimuth = strike - rake;
        if ((float)rake == -180.0f || (float)rake == 0.0f || (float)rake == 180.0f) {
            return new LocationVector(azimuth, 1.0, 0.0);
        }
        double fractInDipDir = Math.sin(Math.toRadians(rake));
        double vertical = fractInDipDir * Math.sin(Math.toRadians(dip));
        double horizontal = Math.sqrt(1.0 - vertical * vertical);
        return new LocationVector(azimuth, horizontal, vertical);
    }

    private static XY_DataSet arrow(Location from, Location to, double length) {
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        xy.set(CoulombCartoonGenerator.pt(from));
        xy.set(CoulombCartoonGenerator.pt(to));
        double arrowAz = LocationUtils.azimuth(from, to);
        double az1 = arrowAz + 135.0;
        double az2 = arrowAz - 135.0;
        Location arrow1 = LocationUtils.location(to, Math.toRadians(az1), length);
        Location arrow2 = LocationUtils.location(to, Math.toRadians(az2), length);
        xy.set(CoulombCartoonGenerator.pt(arrow1));
        xy.set(CoulombCartoonGenerator.pt(to));
        xy.set(CoulombCartoonGenerator.pt(from));
        xy.set(CoulombCartoonGenerator.pt(to));
        xy.set(CoulombCartoonGenerator.pt(arrow2));
        xy.set(CoulombCartoonGenerator.pt(to));
        return xy;
    }
}

