/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.utm.UTM;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.StiffnessCalc;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class SubSectStiffnessCalculator {
    private List<? extends FaultSection> subSects;
    private int utmZone;
    private char utmChar;
    public static final PatchAlignment alignment_default = PatchAlignment.FILL_OVERLAP;
    private PatchAlignment alignment = alignment_default;
    private transient Map<FaultSection, List<PatchLocation>> patchesMap;
    private transient double[][] selfStiffnessCache;
    private transient AggregatedStiffnessCache[] caches;
    private double gridSpacing;
    private double lameLambda;
    private double lameMu;
    private double coeffOfFriction;
    private double selfStiffnessCap;
    private static final DecimalFormat df1 = new DecimalFormat("0.0");
    private static final DecimalFormat df2 = new DecimalFormat("0.00");
    private static final DecimalFormat df3 = new DecimalFormat("0.000");
    private static final DecimalFormat dfE = new DecimalFormat("0.0E0");
    private static DecimalFormat pDF = new DecimalFormat("0.0%");

    public SubSectStiffnessCalculator(List<? extends FaultSection> subSects, double gridSpacing, double lameLambda, double lameMu, double coeffOfFriction) {
        this(subSects, gridSpacing, lameLambda, lameMu, coeffOfFriction, alignment_default, 0.0);
    }

    public SubSectStiffnessCalculator(List<? extends FaultSection> subSects, double gridSpacing, double lameLambda, double lameMu, double coeffOfFriction, PatchAlignment alignment, double selfStiffnessCap) {
        this.subSects = subSects;
        this.gridSpacing = gridSpacing;
        this.lameLambda = lameLambda;
        this.lameMu = lameMu;
        this.coeffOfFriction = coeffOfFriction;
        this.alignment = alignment;
        this.selfStiffnessCap = selfStiffnessCap;
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (FaultSection faultSection : subSects) {
            for (Location loc : faultSection.getFaultTrace()) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
        }
        double centerLat = latTrack.getMin() + 0.5 * (latTrack.getMax() - latTrack.getMin());
        double centerLon = lonTrack.getMin() + 0.5 * (lonTrack.getMax() - lonTrack.getMin());
        this.utmZone = UTM.calcZone(centerLon);
        this.utmChar = UTM.calcLetter(centerLat);
    }

    public synchronized void setPatchAlignment(PatchAlignment alignment) {
        if (this.alignment != alignment) {
            this.patchesMap = null;
            this.alignment = alignment;
            this.clearCaches();
        }
    }

    public List<? extends FaultSection> getSubSects() {
        return this.subSects;
    }

    public List<PatchLocation> getPatches(FaultSection sect) {
        this.checkInitPatches();
        return this.patchesMap.get(sect);
    }

    private List<PatchLocation> buildCenterPatches(FaultSection sect) {
        double hiResSpacing = this.gridSpacing / 10.0;
        StirlingGriddedSurface surf = new StirlingGriddedSurface(sect.getSimpleFaultData(false), hiResSpacing, hiResSpacing);
        double surfLength = surf.getAveLength();
        double surfWidth = surf.getAveWidth();
        int numAS = Integer.max(1, (int)(surfLength / this.gridSpacing));
        int numDD = Integer.max(1, (int)(surfWidth / this.gridSpacing));
        double outerSpacingAS = surfLength / (double)numAS;
        double outerSpacingDD = surfWidth / (double)numDD;
        double aveDip = surf.getAveDip();
        double aveRake = sect.getAveRake();
        ArrayList<PatchLocation> myPatches = new ArrayList<PatchLocation>();
        double halfSpacingKM = this.gridSpacing * 0.5;
        double dipRad = Math.toRadians(aveDip);
        for (int i = 0; i < numAS; ++i) {
            double das = outerSpacingAS * ((double)i + 0.5);
            for (int j = 0; j < numDD; ++j) {
                double ddw = outerSpacingDD * ((double)j + 0.5);
                PatchLocation patchLoc = this.buildPatch(surf, aveDip, aveRake, halfSpacingKM, dipRad, das, ddw);
                myPatches.add(patchLoc);
            }
        }
        return myPatches;
    }

    private List<PatchLocation> buildFillOverlapPatches(FaultSection sect) {
        double hiResSpacing = this.gridSpacing / 10.0;
        RuptureSurface surf = sect.getFaultSurface(hiResSpacing, false, false);
        if (!(surf instanceof StirlingGriddedSurface)) {
            System.err.println("WARNING: " + sect.getSectionName() + " provides a " + ClassUtils.getClassNameWithoutPackage(surf.getClass()) + " rather than a StirlingGriddedSurface; Coulomb calculations may be innacurate.");
        }
        Preconditions.checkState((boolean)(surf instanceof AbstractEvenlyGriddedSurface), (String)"Currently only support Coulomb calculations for AbstractEvenlyGriddedSurface instances, have %s for %s", (Object)ClassUtils.getClassNameWithoutPackage(surf.getClass()), (Object)sect.getSectionName());
        double surfLength = surf.getAveLength();
        double surfWidth = surf.getAveWidth();
        List<Double> dasCenters = SubSectStiffnessCalculator.calcFullOverlapCenters(surfLength, this.gridSpacing);
        List<Double> dasWidths = SubSectStiffnessCalculator.calcFullOverlapCenters(surfWidth, this.gridSpacing);
        double aveDip = surf.getAveDip();
        double aveRake = sect.getAveRake();
        ArrayList<PatchLocation> myPatches = new ArrayList<PatchLocation>();
        double halfSpacingKM = this.gridSpacing * 0.5;
        double dipRad = Math.toRadians(aveDip);
        for (double das : dasCenters) {
            for (double ddw : dasWidths) {
                PatchLocation patchLoc = this.buildPatch((AbstractEvenlyGriddedSurface)surf, aveDip, aveRake, halfSpacingKM, dipRad, das, ddw);
                myPatches.add(patchLoc);
            }
        }
        return myPatches;
    }

    private static List<Double> calcFullOverlapCenters(double length, double gridSpacing) {
        ArrayList<Double> centers = new ArrayList<Double>();
        if (length <= gridSpacing) {
            centers.add(0.5 * length);
            return centers;
        }
        double firstCenter = 0.5 * gridSpacing;
        double lastCenter = length - 0.5 * gridSpacing;
        centers.add(firstCenter);
        double residual = length - 2.0 * gridSpacing;
        if (residual > 0.0) {
            int numMiddles = (int)Math.ceil(residual / gridSpacing);
            if (numMiddles == 1) {
                centers.add(length * 0.5);
            } else {
                double subLength = length - gridSpacing;
                double subSpacing = subLength / (double)(2 + numMiddles - 1);
                for (int i = 0; i < numMiddles; ++i) {
                    centers.add(firstCenter + subSpacing * (double)(i + 1));
                }
                double lastMiddleCenter = (Double)centers.get(centers.size() - 1);
                double calcLastCenter = lastMiddleCenter + subSpacing;
                Preconditions.checkState(((float)calcLastCenter == (float)lastCenter ? 1 : 0) != 0, (String)"middle alignment is off for length=%s, spacing=%s.\n\tcalcLast=%s != last=%s\n\tresidual=%s, subLen=%s, numMiddles=%s, subSpacing=%s\n\tcenters excluding end: %s", (Object[])new Object[]{length, gridSpacing, calcLastCenter, lastCenter, residual, subLength, numMiddles, subSpacing, centers});
            }
        }
        centers.add(lastCenter);
        return centers;
    }

    private PatchLocation buildPatch(AbstractEvenlyGriddedSurface surf, double aveDip, double aveRake, double halfSpacingKM, double dipRad, double das, double ddw) {
        double lengthM;
        Location center = surf.getInterpolatedLocation(das, ddw);
        double strike = surf.getStrikeAtDAS(das);
        FocalMechanism mech = new FocalMechanism(strike, aveDip, aveRake);
        double widthM = lengthM = this.gridSpacing * 1000.0;
        StiffnessCalc.Patch patch = new StiffnessCalc.Patch(center, this.utmZone, this.utmChar, lengthM, widthM, mech);
        Location[] corners = new Location[4];
        LocationVector alongStrikeHalfForward = new LocationVector(strike, halfSpacingKM, 0.0);
        LocationVector alongStrikeHalfBackward = new LocationVector(strike, -halfSpacingKM, 0.0);
        double halfDipVert = Math.sin(dipRad) * halfSpacingKM;
        double halfDipHorz = Math.cos(dipRad) * halfSpacingKM;
        LocationVector downDipHalf = new LocationVector(strike + 90.0, halfDipHorz, halfDipVert);
        LocationVector upDipHalf = new LocationVector(strike - 90.0, halfDipHorz, -halfDipVert);
        corners[0] = LocationUtils.location(LocationUtils.location(center, upDipHalf), alongStrikeHalfBackward);
        corners[1] = LocationUtils.location(LocationUtils.location(center, upDipHalf), alongStrikeHalfForward);
        corners[2] = LocationUtils.location(LocationUtils.location(center, downDipHalf), alongStrikeHalfForward);
        corners[3] = LocationUtils.location(LocationUtils.location(center, downDipHalf), alongStrikeHalfBackward);
        PatchLocation patchLoc = new PatchLocation(patch, center, corners);
        return patchLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitPatches() {
        if (this.patchesMap == null) {
            SubSectStiffnessCalculator subSectStiffnessCalculator = this;
            synchronized (subSectStiffnessCalculator) {
                if (this.patchesMap != null) {
                    return;
                }
                System.out.println("Building source patches...");
                HashMap<FaultSection, List<PatchLocation>> patchesMap = new HashMap<FaultSection, List<PatchLocation>>();
                DataUtils.MinMaxAveTracker patchCountTrack = new DataUtils.MinMaxAveTracker();
                for (FaultSection faultSection : this.subSects) {
                    List<PatchLocation> myPatches;
                    switch (this.alignment.ordinal()) {
                        case 0: {
                            myPatches = this.buildCenterPatches(faultSection);
                            break;
                        }
                        case 1: {
                            myPatches = this.buildFillOverlapPatches(faultSection);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Patch alignment not supported: " + String.valueOf((Object)this.alignment));
                        }
                    }
                    Preconditions.checkState((myPatches.size() > 0 ? 1 : 0) != 0, (Object)"must have at least 1 patch");
                    patchCountTrack.addValue(myPatches.size());
                    patchesMap.put(faultSection, myPatches);
                }
                System.out.println("Patch stats: " + String.valueOf(patchCountTrack));
                this.patchesMap = patchesMap;
            }
        }
    }

    public StiffnessDistribution calcStiffnessDistribution(FaultSection sourceSect, FaultSection receiverSect) {
        return this.calcStiffnessDistribution(sourceSect.getSectionId(), receiverSect.getSectionId());
    }

    public StiffnessDistribution calcStiffnessDistribution(int sourceID, int receiverID) {
        this.checkInitPatches();
        List<PatchLocation> sourcePatches = this.patchesMap.get(this.subSects.get(sourceID));
        List<PatchLocation> receiverPatches = this.patchesMap.get(this.subSects.get(receiverID));
        double[][][] values = new double[StiffnessType.values().length][receiverPatches.size()][sourcePatches.size()];
        double[] selfStiffness = null;
        if (this.selfStiffnessCap > 0.0) {
            selfStiffness = this.getSelfStiffness(receiverID, receiverPatches);
        }
        for (int r = 0; r < receiverPatches.size(); ++r) {
            PatchLocation receiver = receiverPatches.get(r);
            double cap = Double.NaN;
            if (this.selfStiffnessCap > 0.0) {
                cap = Math.abs(selfStiffness[r]) * this.selfStiffnessCap;
            }
            for (int s = 0; s < sourcePatches.size(); ++s) {
                double cff;
                double tau;
                double sigma;
                PatchLocation source = sourcePatches.get(s);
                double[] stiffness = StiffnessCalc.calcStiffness(this.lameLambda, this.lameMu, source.patch, receiver.patch);
                if (stiffness == null) {
                    sigma = Double.NaN;
                    tau = Double.NaN;
                    cff = Double.NaN;
                } else {
                    sigma = stiffness[0];
                    tau = stiffness[1];
                    cff = StiffnessCalc.calcCoulombStress(tau, sigma, this.coeffOfFriction);
                    if (this.selfStiffnessCap > 0.0) {
                        if (cff > cap) {
                            cff = cap;
                        } else if (cff < -cap) {
                            cff = -cap;
                        }
                    }
                }
                values[StiffnessType.SIGMA.ordinal()][r][s] = sigma;
                values[StiffnessType.TAU.ordinal()][r][s] = tau;
                values[StiffnessType.CFF.ordinal()][r][s] = cff;
            }
        }
        return new StiffnessDistribution(sourcePatches, receiverPatches, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getSelfStiffness(int sectID, List<PatchLocation> receiverPatches) {
        if (this.selfStiffnessCache == null) {
            SubSectStiffnessCalculator subSectStiffnessCalculator = this;
            synchronized (subSectStiffnessCalculator) {
                if (this.selfStiffnessCache == null) {
                    this.selfStiffnessCache = new double[this.subSects.size()][];
                }
            }
        }
        if (this.selfStiffnessCache[sectID] == null) {
            double[] values = new double[receiverPatches.size()];
            for (int r = 0; r < values.length; ++r) {
                PatchLocation receiver = receiverPatches.get(r);
                double[] stiffness = StiffnessCalc.calcStiffness(this.lameLambda, this.lameMu, receiver.patch, receiver.patch);
                values[r] = StiffnessCalc.calcCoulombStress(stiffness[1], stiffness[0], this.coeffOfFriction);
            }
            this.selfStiffnessCache[sectID] = values;
        }
        return this.selfStiffnessCache[sectID];
    }

    public LogDistributionPlot plotDistributionHistograms(StiffnessDistribution dist, StiffnessType type, int sourceID, int receiverID) {
        double[][] vals = dist.get(type);
        int totSize = 0;
        for (double[] sub : vals) {
            totSize += sub.length;
        }
        double[] flattened = new double[totSize];
        int index = 0;
        for (double[] sub : vals) {
            System.arraycopy(sub, 0, flattened, index, sub.length);
            index += sub.length;
        }
        AggregatedStiffnessCalculator.StiffnessAggregation result = new AggregatedStiffnessCalculator.StiffnessAggregation(flattened, flattened.length);
        double maxAbsVal = Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MIN));
        maxAbsVal = (maxAbsVal = Math.max(maxAbsVal, Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MAX)))) > 10.0 ? 10.0 * Math.ceil(maxAbsVal / 2.0) : Math.ceil(maxAbsVal);
        double logMax = Math.max(Math.ceil(Math.log10(maxAbsVal)), Math.min(2.0, Math.ceil(Math.log10(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.SUM))))));
        double logMin = -1.0;
        double[][] dArray = vals;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] inner;
            for (double val : inner = dArray[i]) {
                double abs = Math.abs(val);
                if (!(val > 0.0)) continue;
                logMin = Math.min(logMin, Math.log10(abs));
            }
        }
        logMin = Math.max(-8.0, Math.floor(logMin));
        double logDelta = 0.1;
        HistogramFunction posLogVals = HistogramFunction.getEncompassingHistogram(logMin, logMax, logDelta);
        HistogramFunction negLogVals = new HistogramFunction(posLogVals.getMinX(), posLogVals.getMaxX(), posLogVals.size());
        double[][] dArray2 = vals;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            double[] innerVals;
            for (double val : innerVals = dArray2[i]) {
                int ind;
                if (val > 0.0) {
                    ind = posLogVals.getClosestXIndex(Math.log10(val));
                    posLogVals.add(ind, 1.0);
                    continue;
                }
                if (val == 0.0) {
                    posLogVals.add(0, 1.0);
                    continue;
                }
                ind = negLogVals.getClosestXIndex(Math.log10(-val));
                negLogVals.add(ind, 1.0);
            }
        }
        double d = Math.max(negLogVals.getMaxY(), posLogVals.getMaxY());
        Range xRange = new Range(Math.pow(10.0, logMin), Math.pow(10.0, logMax));
        Range yRange = new Range(0.0, d *= 1.1);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        double annOuterX = Math.pow(10.0, logMin + 0.95 * (logMax - logMin));
        double annInnerX = Math.pow(10.0, logMin + 0.05 * (logMax - logMin));
        double annY1 = 0.94 * d;
        double annY2 = 0.88 * d;
        double maxVertY = 0.87 * d;
        PlotSpec negativeSpec = null;
        PlotSpec positiveSpec = null;
        DecimalFormat pDF = new DecimalFormat("0.0%");
        for (boolean positive : new boolean[]{false, true}) {
            ArbitrarilyDiscretizedFunc hist = new ArbitrarilyDiscretizedFunc();
            if (positive) {
                for (Point2D pt : posLogVals) {
                    hist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
            } else {
                for (Point2D pt : negLogVals) {
                    hist.set(Math.pow(10.0, pt.getX()), pt.getY());
                }
            }
            ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(hist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
            ArrayList<XYTextAnnotation> anns = new ArrayList<XYTextAnnotation>();
            Font annFont = new Font("SansSerif", 1, 18);
            String percentText = positive ? pDF.format(result.get(AggregatedStiffnessCalculator.AggregationMethod.FRACT_POSITIVE)) + "\u22650" : pDF.format(1.0 - result.get(AggregatedStiffnessCalculator.AggregationMethod.FRACT_POSITIVE)) + "<0";
            XYTextAnnotation percentAnn = new XYTextAnnotation(percentText, annInnerX, annY1);
            if (positive) {
                percentAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
            } else {
                percentAnn.setTextAnchor(TextAnchor.BOTTOM_RIGHT);
            }
            percentAnn.setFont(annFont);
            percentAnn.setPaint((Paint)Color.BLACK);
            anns.add(percentAnn);
            if (!positive) {
                XYTextAnnotation meanAnn = new XYTextAnnotation("mean=" + SubSectStiffnessCalculator.getValStr(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEAN)), annOuterX, annY1);
                meanAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                meanAnn.setFont(annFont);
                meanAnn.setPaint((Paint)Color.BLACK);
                anns.add(meanAnn);
            }
            if (positive == this.isPositive(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEAN))) {
                DefaultXY_DataSet meanXY = new DefaultXY_DataSet();
                meanXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEAN)), 0.0);
                meanXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEAN)), maxVertY);
                funcs.add(meanXY);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            }
            if (!positive) {
                XYTextAnnotation medianAnn = new XYTextAnnotation("mdn.=" + SubSectStiffnessCalculator.getValStr(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEDIAN)), annOuterX, annY2);
                medianAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                medianAnn.setFont(annFont);
                medianAnn.setPaint((Paint)Color.BLUE);
                anns.add(medianAnn);
            }
            if (positive == this.isPositive(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEDIAN))) {
                DefaultXY_DataSet medianXY = new DefaultXY_DataSet();
                medianXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEDIAN)), 0.0);
                medianXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MEDIAN)), maxVertY);
                funcs.add(medianXY);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
            }
            if (positive) {
                XYTextAnnotation sumAnn = new XYTextAnnotation("sum=" + SubSectStiffnessCalculator.getValStr(result.get(AggregatedStiffnessCalculator.AggregationMethod.SUM)), annOuterX, annY2);
                sumAnn.setTextAnchor(TextAnchor.BOTTOM_RIGHT);
                sumAnn.setFont(annFont);
                sumAnn.setPaint((Paint)Color.RED);
                anns.add(sumAnn);
            }
            if (positive == this.isPositive(result.get(AggregatedStiffnessCalculator.AggregationMethod.SUM))) {
                DefaultXY_DataSet sumXY = new DefaultXY_DataSet();
                sumXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.SUM)), 0.0);
                sumXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.SUM)), maxVertY);
                funcs.add(sumXY);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
            }
            if (positive) {
                XYTextAnnotation boundsAnn = new XYTextAnnotation("[" + SubSectStiffnessCalculator.getValStr(result.get(AggregatedStiffnessCalculator.AggregationMethod.MIN)) + "," + SubSectStiffnessCalculator.getValStr(result.get(AggregatedStiffnessCalculator.AggregationMethod.MAX)) + "]", annOuterX, annY1);
                boundsAnn.setTextAnchor(TextAnchor.BOTTOM_RIGHT);
                boundsAnn.setFont(annFont);
                boundsAnn.setPaint((Paint)Color.DARK_GRAY);
                anns.add(boundsAnn);
            }
            if (positive == this.isPositive(result.get(AggregatedStiffnessCalculator.AggregationMethod.MIN))) {
                DefaultXY_DataSet lowerXY = new DefaultXY_DataSet();
                lowerXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MIN)), 0.0);
                lowerXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MIN)), maxVertY);
                funcs.add(lowerXY);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.DARK_GRAY));
            }
            if (positive == this.isPositive(result.get(AggregatedStiffnessCalculator.AggregationMethod.MAX))) {
                DefaultXY_DataSet upperXY = new DefaultXY_DataSet();
                upperXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MAX)), 0.0);
                upperXY.set(Math.abs(result.get(AggregatedStiffnessCalculator.AggregationMethod.MAX)), maxVertY);
                funcs.add(upperXY);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.DARK_GRAY));
            }
            String title = type.name + " Distribution";
            if (sourceID >= 0 && receiverID >= 0) {
                title = title + ", " + sourceID + " => " + receiverID;
            }
            String xAxisLabel = type.name + " (" + type.units + ")";
            if (!positive) {
                xAxisLabel = "-" + xAxisLabel;
            }
            PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, "Count");
            if (positive) {
                positiveSpec = spec;
            } else {
                negativeSpec = spec;
            }
            spec.setLegendVisible(false);
            spec.setPlotAnnotations(anns);
            specs.add(spec);
        }
        return new LogDistributionPlot(negativeSpec, positiveSpec, xRange, yRange);
    }

    private boolean isPositive(double value) {
        return value >= 0.0;
    }

    private static String getValStr(double val) {
        double abs = Math.abs(val);
        if (abs >= 1.0) {
            return df1.format(val);
        }
        if (abs >= 0.1) {
            return df2.format(val);
        }
        if (abs >= 0.01) {
            return df3.format(val);
        }
        return dfE.format(val).toLowerCase();
    }

    public int getUTMZone() {
        return this.utmZone;
    }

    public char getUTMLetter() {
        return this.utmChar;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public double getLameLambda() {
        return this.lameLambda;
    }

    public double getLameMu() {
        return this.lameMu;
    }

    public double getCoeffOfFriction() {
        return this.coeffOfFriction;
    }

    public double getSelfStiffnessCap() {
        return this.selfStiffnessCap;
    }

    public PatchAlignment getPatchAlignment() {
        return this.alignment;
    }

    public synchronized AggregatedStiffnessCache getAggregationCache(StiffnessType type) {
        if (this.caches == null) {
            this.caches = new AggregatedStiffnessCache[StiffnessType.values().length];
        }
        if (this.caches[type.ordinal()] == null) {
            this.caches[type.ordinal()] = new AggregatedStiffnessCache(this, type);
        }
        return this.caches[type.ordinal()];
    }

    public synchronized void clearCaches() {
        if (this.caches != null) {
            for (AggregatedStiffnessCache cache : this.caches) {
                if (cache == null) continue;
                cache.clear();
            }
        }
    }

    public static CPT getLogCPT(double maxVal, boolean positive) {
        Color maxColor;
        Color oneColor;
        Color minColor;
        if (positive) {
            minColor = new Color(255, 220, 220);
            oneColor = new Color(255, 0, 0);
            maxColor = new Color(100, 0, 0);
        } else {
            minColor = new Color(220, 220, 255);
            oneColor = new Color(0, 0, 255);
            maxColor = new Color(0, 0, 100);
        }
        CPT cpt = new CPT(-4.0, 0.0, minColor, oneColor);
        cpt.add(new CPTVal(cpt.getMaxValue(), oneColor, (float)Math.log10(maxVal), maxColor));
        cpt.setBelowMinColor(Color.WHITE);
        cpt.setAboveMaxColor(maxColor);
        return cpt;
    }

    public static CPT getPreferredPosNegCPT() {
        return SubSectStiffnessCalculator.getPreferredPosNegCPT(10.0);
    }

    public static CPT getPreferredPosNegCPT(double maxVal) {
        Color c2;
        Color c1;
        double x2;
        double x1;
        CPT posLogCPT = SubSectStiffnessCalculator.getLogCPT(maxVal, true);
        CPT negLogCPT = SubSectStiffnessCalculator.getLogCPT(maxVal, false);
        EvenlyDiscretizedFunc logDiscr = new EvenlyDiscretizedFunc(posLogCPT.getMinValue(), posLogCPT.getMaxValue(), 100);
        CPT cpt = new CPT();
        int i = logDiscr.size();
        while (--i > 0) {
            x1 = logDiscr.getX(i);
            x2 = logDiscr.getX(i - 1);
            c1 = negLogCPT.getColor((float)x1);
            c2 = negLogCPT.getColor((float)x2);
            cpt.add(new CPTVal(-((float)Math.pow(10.0, x1)), c1, -((float)Math.pow(10.0, x2)), c2));
        }
        cpt.add(new CPTVal(cpt.getMaxValue(), cpt.getMaxColor(), 0.0, Color.WHITE));
        cpt.add(new CPTVal(0.0, Color.WHITE, (float)Math.pow(10.0, posLogCPT.getMinValue()), posLogCPT.getMinColor()));
        for (i = 0; i < logDiscr.size() - 1; ++i) {
            x1 = logDiscr.getX(i);
            x2 = logDiscr.getX(i + 1);
            c1 = posLogCPT.getColor((float)x1);
            c2 = posLogCPT.getColor((float)x2);
            cpt.add(new CPTVal((float)Math.pow(10.0, x1), c1, (float)Math.pow(10.0, x2), c2));
        }
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        return cpt;
    }

    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        File fssFile = new File("/home/kevin/Simulators/catalogs/rundir4983_stitched/fss/rsqsim_sol_m6.5_skip5000_sectArea0.2.zip");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(fssFile);
        double lambda = 30000.0;
        double mu = 30000.0;
        double coeffOfFriction = 0.5;
        SubSectStiffnessCalculator calc = new SubSectStiffnessCalculator(rupSet.getFaultSectionDataList(), 1.0, lambda, mu, coeffOfFriction);
        calc.setPatchAlignment(PatchAlignment.FILL_OVERLAP);
        System.out.println(calc.utmZone + " " + calc.utmChar);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(StiffnessType.CFF, calc, false, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        List<? extends FaultSection> subSects = calc.getSubSects();
        FaultSection source = subSects.get(1398);
        ArrayList receivers = Lists.newArrayList((Object[])new FaultSection[]{subSects.get(1399), subSects.get(324), subSects.get(1979)});
        for (FaultSection receiver : receivers) {
            System.out.println(source.getSectionId() + "=>" + receiver.getSectionId() + ": " + aggCalc.calc(source, receiver));
        }
    }

    private static String getFractStr(int num, int total) {
        return pDF.format((double)num / (double)total) + "\t(" + num + "/" + total + ")";
    }

    public static enum PatchAlignment {
        CENTER,
        FILL_OVERLAP;

    }

    public static class PatchLocation {
        public final StiffnessCalc.Patch patch;
        public final Location center;
        public final Location[] corners;

        public PatchLocation(StiffnessCalc.Patch patch, Location center, Location[] corners) {
            this.patch = patch;
            this.center = center;
            this.corners = corners;
        }
    }

    public static class StiffnessDistribution {
        public final List<PatchLocation> sourcePatches;
        public final List<PatchLocation> receiverPatches;
        private final double[][][] values;

        private StiffnessDistribution(List<PatchLocation> sourcePatches, List<PatchLocation> receiverPatches, double[][][] values) {
            this.sourcePatches = sourcePatches;
            this.receiverPatches = receiverPatches;
            Preconditions.checkState((values.length == StiffnessType.values().length ? 1 : 0) != 0);
            this.values = values;
        }

        public StiffnessDistribution receiverAggregate(AggregatedStiffnessCalculator.AggregationMethod method) {
            Preconditions.checkState((boolean)method.isTerminal());
            double[][][] agg = new double[this.values.length][][];
            for (int t = 0; t < agg.length; ++t) {
                if (this.values[t] == null) continue;
                agg[t] = new double[this.values[t].length][1];
                for (int r = 0; r < agg[t].length; ++r) {
                    agg[t][r] = new double[]{method.calculate(this.values[t][r])};
                }
            }
            return new StiffnessDistribution(null, this.receiverPatches, agg);
        }

        public StiffnessDistribution add(StiffnessDistribution o) {
            double[][][] combined = new double[this.values.length][][];
            for (int t = 0; t < combined.length; ++t) {
                if (this.values[t] == null || o.values[t] == null) continue;
                combined[t] = new double[this.values[t].length + o.values[t].length][];
                int ind = 0;
                for (double[] sourceVals : this.values[t]) {
                    combined[t][ind++] = sourceVals;
                }
                for (double[] sourceVals : o.values[t]) {
                    combined[t][ind++] = sourceVals;
                }
            }
            List<PatchLocation> newSourcePatches = null;
            if (this.sourcePatches != null && this.sourcePatches.equals(o.sourcePatches)) {
                newSourcePatches = this.sourcePatches;
            }
            return new StiffnessDistribution(newSourcePatches, null, combined);
        }

        public double[][] get(StiffnessType type) {
            return this.values[type.ordinal()];
        }
    }

    public static enum StiffnessType {
        SIGMA("\u0394Sigma", "&Delta;Sigma", "MPa", 0),
        TAU("\u0394Tau", "&Delta;Tau", "MPa", 1),
        CFF("\u0394CFF", "&Delta;CFF", "MPa", 2);

        private String name;
        private String html;
        private String units;

        private StiffnessType(String name, String html, String units, int arrayIndex) {
            this.name = name;
            this.html = html;
            this.units = units;
        }

        public String toString() {
            return this.name + " (" + this.units + ")";
        }

        public String getName() {
            return this.name;
        }

        public String getHTML() {
            return this.html;
        }

        public String getUnits() {
            return this.units;
        }
    }

    public static class LogDistributionPlot {
        public final PlotSpec negativeSpec;
        public final PlotSpec positiveSpec;
        public final Range xRange;
        public final Range yRange;

        public LogDistributionPlot(PlotSpec negativeSpec, PlotSpec positiveSpec, Range xRange, Range yRange) {
            this.negativeSpec = negativeSpec;
            this.positiveSpec = positiveSpec;
            this.xRange = xRange;
            this.yRange = yRange;
        }

        public void plotInGW(GraphWindow gw) {
            GraphWidget widget = gw.getGraphWidget();
            ArrayList specs = Lists.newArrayList((Object[])new PlotSpec[]{this.negativeSpec, this.positiveSpec});
            ArrayList xRanges = Lists.newArrayList((Object[])new Range[]{this.xRange, this.xRange});
            ArrayList yRanges = Lists.newArrayList((Object[])new Range[]{this.yRange});
            widget.getGraphPanel().setxAxisInverteds(new boolean[]{true, false});
            widget.setMultiplePlotSpecs(specs, xRanges, yRanges);
            widget.setX_Log(true);
            gw.setVisible(true);
        }
    }
}

