/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.PlaneUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.InputJumpsOrDistClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.TriangularElement;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.distCalc.SimEventCumDistFuncSurface;
import org.opensha.sha.simulators.distCalc.SimRuptureDistCalcUtils;
import org.opensha.sha.simulators.iden.LogicalAndRupIden;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.iden.SkipYearsLoadIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.utils.RSQSimEqkRupture;
import org.opensha.sha.simulators.utils.RSQSimSubSectEqkRupture;
import org.opensha.sha.simulators.utils.RSQSimSubSectionMapper;
import org.opensha.sha.simulators.utils.SimulatorUtils;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.BatchPlotGen;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;

public class RSQSimUtils {
    private static SimRuptureDistCalcUtils.Scalar DIST_WEIGHT_SCALAR = SimRuptureDistCalcUtils.Scalar.MOMENT;
    private static double DIST_FRACT_THRESHOLD = 0.05;
    private static double DIST_ABS_THRESHOLD = MagUtils.magToMoment(6.0);
    private static double DIST_X_FRACT_THRESHOLD = 0.1;
    private static boolean warned = false;

    public static RSQSimSubSectEqkRupture buildSubSectBasedRupture(RSQSimSubSectionMapper mapper, RSQSimEvent event) {
        List<List<RSQSimSubSectionMapper.SubSectionMapping>> mappings = mapper.getFilteredSubSectionMappings(event);
        if (mapper.getMinFractForInclusion() > 0.0 && mappings.isEmpty()) {
            mappings = mapper.getAllSubSectionMappings(event);
        }
        double mag = event.getMagnitude();
        ArrayList<Double> rakes = new ArrayList<Double>();
        for (List<RSQSimSubSectionMapper.SubSectionMapping> bundle : mappings) {
            for (RSQSimSubSectionMapper.SubSectionMapping subSectionMapping : bundle) {
                rakes.add(subSectionMapping.getSubSect().getAveRake());
            }
        }
        double rake = FaultUtils.getAngleAverage(rakes);
        if (rake > 180.0) {
            rake -= 360.0;
        }
        ArrayList<FaultSection> rupSects = new ArrayList<FaultSection>();
        for (List<RSQSimSubSectionMapper.SubSectionMapping> list : mappings) {
            for (Object mapping : list) {
                rupSects.add(((RSQSimSubSectionMapper.SubSectionMapping)mapping).getSubSect());
            }
        }
        Preconditions.checkState((!rupSects.isEmpty() ? 1 : 0) != 0, (String)"No mapped sections! ID=%s, M=%s, %s elems", (Object)event.getID(), (Object)event.getMagnitude(), (Object)event.getAllElementIDs().length);
        double d = 1.0;
        ArrayList<RuptureSurface> rupSurfs = new ArrayList<RuptureSurface>();
        for (FaultSection sect : rupSects) {
            rupSurfs.add(sect.getFaultSurface(d, false, false));
        }
        RuptureSurface surf = rupSurfs.size() == 1 ? (RuptureSurface)rupSurfs.get(0) : new CompoundSurface(rupSurfs);
        SimulatorElement hypo = RSQSimUtils.getHypocenterElem(event);
        RSQSimSubSectEqkRupture rup = new RSQSimSubSectEqkRupture(mag, rake, surf, hypo.getCenterLocation(), event, rupSects, mapper.getMappedSection(hypo));
        return rup;
    }

    public static double getElemAvgRake(RSQSimEvent event, boolean momentWeighted) {
        double rake;
        ArrayList<SimulatorElement> elems = event.getAllElements();
        double[] slips = momentWeighted ? event.getAllElementSlips() : null;
        ArrayList<Double> rakes = new ArrayList<Double>(elems.size());
        ArrayList<Double> weights = momentWeighted ? new ArrayList<Double>(elems.size()) : null;
        for (int i = 0; i < elems.size(); ++i) {
            SimulatorElement elem = (SimulatorElement)elems.get(i);
            rakes.add(elem.getFocalMechanism().getRake());
            if (!momentWeighted) continue;
            weights.add(momentWeighted ? FaultMomentCalc.getMoment(elem.getArea(), slips[i]) : 1.0);
        }
        double d = rake = momentWeighted ? FaultUtils.getScaledAngleAverage(weights, rakes) : FaultUtils.getAngleAverage(rakes);
        if (rake > 180.0) {
            rake -= 360.0;
        }
        return rake;
    }

    public static RSQSimEqkRupture buildCumDistRupture(RSQSimEvent event) {
        return RSQSimUtils.buildCumDistRupture(event, new SimRuptureDistCalcUtils.LocationElementDistanceCacheFactory());
    }

    public static RSQSimEqkRupture buildCumDistRupture(RSQSimEvent event, SimRuptureDistCalcUtils.LocationElementDistanceCacheFactory locCacheFactory) {
        double mag = event.getMagnitude();
        double rake = RSQSimUtils.getElemAvgRake(event, true);
        SimEventCumDistFuncSurface surf = new SimEventCumDistFuncSurface(event, DIST_WEIGHT_SCALAR, DIST_FRACT_THRESHOLD, DIST_ABS_THRESHOLD, DIST_X_FRACT_THRESHOLD, locCacheFactory);
        SimulatorElement hypo = RSQSimUtils.getHypocenterElem(event);
        RSQSimEqkRupture rup = new RSQSimEqkRupture(mag, rake, surf, hypo.getCenterLocation(), event);
        return rup;
    }

    public static SimulatorElement getHypocenterElem(RSQSimEvent event) {
        SimulatorElement hypo = null;
        double earliestTime = Double.POSITIVE_INFINITY;
        for (EventRecord rec : event) {
            List<SimulatorElement> patches = rec.getElements();
            double[] patchTimes = rec.getElementTimeFirstSlips();
            for (int i = 0; i < patches.size(); ++i) {
                if (!(patchTimes[i] < earliestTime)) continue;
                earliestTime = patchTimes[i];
                hypo = patches.get(i);
            }
        }
        Preconditions.checkNotNull(hypo, (String)"Couldn't detect hypocenter for event %s.", (int)event.getID());
        return hypo;
    }

    public static Location getHypocenter(RSQSimEvent event) {
        return RSQSimUtils.getHypocenterElem(event).getCenterLocation();
    }

    public static int getSubSectIndexOffset(List<SimulatorElement> elements, List<? extends FaultSection> subSects) {
        int minElemSectID = Integer.MAX_VALUE;
        int maxElemSectID = -1;
        HashSet<Integer> sectsFound = new HashSet<Integer>();
        for (SimulatorElement elem : elements) {
            int id = elem.getSectionID();
            if (id < minElemSectID) {
                minElemSectID = id;
            }
            if (id > maxElemSectID) {
                maxElemSectID = id;
            }
            sectsFound.add(id);
        }
        int myNum = 1 + maxElemSectID - minElemSectID;
        if (!warned) {
            if (myNum != sectsFound.size()) {
                System.err.println("WARNING: Sub sect range not complete, has holes. " + sectsFound.size() + " unique, range suggests " + myNum + ". Future warnings suppressed.");
                warned = true;
            }
            if (myNum < subSects.size()) {
                System.err.println("WARNING: Sub sect count different. We have " + myNum + " (id range: " + minElemSectID + "-" + maxElemSectID + "), expected " + subSects.size() + ". Future warnings suppressed.");
                warned = true;
            }
        }
        if (myNum == subSects.size()) {
            return minElemSectID;
        }
        if (elements.get(0).getSectionName().startsWith("nn")) {
            return 0;
        }
        Preconditions.checkState((subSects.size() >= myNum ? 1 : 0) != 0, (String)"Couldn't map to subsections. Have %s sub sects, range in elems is %s to %s", (Object)subSects.size(), (Object)minElemSectID, (Object)maxElemSectID);
        return minElemSectID;
    }

    public static void populateFaultIDWithParentIDs(List<SimulatorElement> elements, List<? extends FaultSection> subSects) {
        int offset = RSQSimUtils.getSubSectIndexOffset(elements, subSects);
        for (SimulatorElement elem : elements) {
            elem.setFaultID(subSects.get(elem.getSectionID() - offset).getParentSectionId());
        }
    }

    public static void populateSubSectionNames(List<SimulatorElement> elements, List<? extends FaultSection> subSects) {
        int offset = RSQSimUtils.getSubSectIndexOffset(elements, subSects);
        for (SimulatorElement elem : elements) {
            elem.setSectionName(subSects.get(elem.getSectionID() - offset).getName());
        }
    }

    public static List<? extends FaultSection> getUCERF3SubSectsForComparison(FaultModels fm, DeformationModels dm) {
        return DeformationModels.loadSubSects(fm, dm);
    }

    public static Map<Integer, Double> calcSubSectAreas(List<SimulatorElement> elements, List<? extends FaultSection> subSects) {
        int offset = RSQSimUtils.getSubSectIndexOffset(elements, subSects);
        HashMap<Integer, Double> subSectAreas = new HashMap<Integer, Double>();
        for (SimulatorElement simulatorElement : elements) {
            Double prevArea = (Double)subSectAreas.get(simulatorElement.getSectionID());
            if (prevArea == null) {
                prevArea = 0.0;
            }
            subSectAreas.put(simulatorElement.getSectionID() - offset, prevArea + simulatorElement.getArea());
        }
        for (FaultSection faultSection : subSects) {
            Integer id = faultSection.getSectionId();
            if (!subSectAreas.containsKey(id)) continue;
            double simSectArea = (Double)subSectAreas.get(id);
            double fsdArea = faultSection.getArea(false);
            if (!(fsdArea < simSectArea)) continue;
            subSectAreas.put(id, fsdArea);
        }
        return subSectAreas;
    }

    public static FaultSystemSolution buildFaultSystemSolution(List<? extends FaultSection> subSects, List<SimulatorElement> elements, List<RSQSimEvent> events, double minMag) {
        return RSQSimUtils.buildFaultSystemSolution(subSects, elements, events, minMag, 0.0);
    }

    public static FaultSystemSolution buildFaultSystemSolution(List<? extends FaultSection> subSects, List<SimulatorElement> elements, List<RSQSimEvent> events, double minMag, double minFractForInclusion) {
        return RSQSimUtils.buildFaultSystemSolution(subSects, elements, events, minMag, new RSQSimSubSectionMapper(subSects, elements, minFractForInclusion));
    }

    public static FaultSystemSolution buildFaultSystemSolution(List<? extends FaultSection> subSects, List<SimulatorElement> elements, List<RSQSimEvent> events, double minMag, RSQSimSubSectionMapper mapper) {
        if (minMag > 0.0) {
            events = new MagRangeRuptureIdentifier(minMag, 10.0).getMatches(events);
        }
        final int minElemSectID = RSQSimUtils.getSubSectIndexOffset(elements, subSects);
        double[] mags = new double[events.size()];
        double[] rupRakes = new double[events.size()];
        double[] rupAreas = new double[events.size()];
        double[] rupLengths = new double[events.size()];
        ArrayList sectionForRups = Lists.newArrayList();
        double minFractForInclusion = mapper.getMinFractForInclusion();
        System.out.print("Building ruptures...");
        for (int i = 0; i < events.size(); ++i) {
            RSQSimEvent e = events.get(i);
            mags[i] = e.getMagnitude();
            rupAreas[i] = e.getArea();
            rupLengths[i] = 0.0;
            List<List<RSQSimSubSectionMapper.SubSectionMapping>> mappings = mapper.getFilteredSubSectionMappings(e);
            if (minFractForInclusion > 0.0 && mappings.isEmpty()) {
                mappings = mapper.getAllSubSectionMappings(e);
            }
            ArrayList rakes = Lists.newArrayList();
            ArrayList rupSectIndexes = Lists.newArrayList();
            for (List<RSQSimSubSectionMapper.SubSectionMapping> bundle : mappings) {
                for (RSQSimSubSectionMapper.SubSectionMapping mapping : bundle) {
                    FaultSection subSect = mapping.getSubSect();
                    rupSectIndexes.add(subSect.getSectionId());
                    rakes.add(subSect.getAveRake());
                    int n = i;
                    rupLengths[n] = rupLengths[n] + subSect.getTraceLength() * 1000.0;
                }
            }
            sectionForRups.add(rupSectIndexes);
            double avgRake = FaultUtils.getAngleAverage(rakes);
            if (avgRake > 180.0) {
                avgRake -= 360.0;
            }
            rupRakes[i] = avgRake;
        }
        System.out.println("DONE.");
        double[] sectSlipRates = new double[subSects.size()];
        Object sectSlipRateStdDevs = null;
        final double[] sectAreas = new double[subSects.size()];
        for (int s = 0; s < subSects.size(); ++s) {
            FaultSection sect = subSects.get(s);
            sectSlipRates[s] = sect.getReducedAveSlipRate() / 1000.0;
            sectAreas[s] = sect.getReducedDownDipWidth() * sect.getTraceLength() * 1000000.0;
        }
        String info = "Fault Simulators Solution\n# Elements: " + elements.size() + "\n# Sub Sections: " + subSects.size() + "\n# Events/Rups: " + events.size();
        final FaultSystemRupSet rupSet = FaultSystemRupSet.builder(subSects, sectionForRups).rupMags(mags).rupRakes(rupRakes).rupAreas(rupAreas).rupLengths(rupLengths).build();
        SectionDistanceAzimuthCalculator distCalc = new SectionDistanceAzimuthCalculator(subSects);
        RuptureConnectionSearch search = new RuptureConnectionSearch(rupSet, distCalc, 200.0, false);
        rupSet.addModule(ClusterRuptures.instance(rupSet, search));
        HashSet<Jump> jumps = new HashSet<Jump>();
        int maxSplays = 0;
        for (ClusterRupture rup : rupSet.getModule(ClusterRuptures.class)) {
            for (Jump jump : rup.getJumpsIterable()) {
                jumps.add(jump);
                jumps.add(jump.reverse());
            }
            maxSplays = Integer.max(maxSplays, rup.getTotalNumSplays());
        }
        InputJumpsOrDistClusterConnectionStrategy connStrat = new InputJumpsOrDistClusterConnectionStrategy(distCalc.getSubSections(), distCalc, 15.0, jumps);
        PlausibilityConfiguration config = new PlausibilityConfiguration(new ArrayList<PlausibilityFilter>(), maxSplays, connStrat, distCalc);
        rupSet.addModule(config);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<AveSlipModule.Precomputed>(){

            @Override
            public AveSlipModule.Precomputed call() throws Exception {
                SlipAlongRuptureModel slipAlong = rupSet.requireModule(SlipAlongRuptureModel.class);
                Preconditions.checkState((boolean)(slipAlong instanceof SlipAlongRuptureModel.Precomputed), (String)"Expected SlipAlongRuptureModel.Precompute instance, have %s", (Object)slipAlong.getClass().getName());
                double[] aveSlips = new double[rupSet.getNumRuptures()];
                for (int r = 0; r < aveSlips.length; ++r) {
                    List<Integer> sectionIndices = rupSet.getSectionsIndicesForRup(r);
                    int numSects = sectionIndices.size();
                    double[] sectArea = new double[numSects];
                    int index = 0;
                    for (Integer sectID : sectionIndices) {
                        sectArea[index++] = rupSet.getAreaForSection(sectID);
                    }
                    double[] slipOnSects = slipAlong.calcSlipOnSectionsForRup(rupSet, r, sectAreas, Double.NaN);
                    double avg = 0.0;
                    double areaSum = 0.0;
                    for (int i = 0; i < slipOnSects.length; ++i) {
                        avg += slipOnSects[i] * sectArea[i];
                        areaSum += sectArea[i];
                    }
                    aveSlips[r] = avg / areaSum;
                }
                return new AveSlipModule.Precomputed(rupSet, aveSlips);
            }
        }, AveSlipModule.Precomputed.class);
        final List<RSQSimEvent> finalEvents = events;
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SlipAlongRuptureModel.Precomputed>(){

            @Override
            public SlipAlongRuptureModel.Precomputed call() throws Exception {
                ArrayList<double[]> slipsAlong = new ArrayList<double[]>(rupSet.getNumRuptures());
                for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                    List<Integer> sectIndexes = rupSet.getSectionsIndicesForRup(r);
                    double[] slips = new double[sectIndexes.size()];
                    double[] slipsNotNormalized = new double[sectIndexes.size()];
                    SimulatorEvent event = (SimulatorEvent)finalEvents.get(r);
                    HashMap sectIndexToRecordMap = Maps.newHashMap();
                    for (EventRecord rec : event) {
                        Integer sectIndex = rec.getSectionID() - minElemSectID;
                        Preconditions.checkState((!sectIndexToRecordMap.containsKey(sectIndex) ? 1 : 0) != 0, (Object)"Multiple EventRecord's with the same section ID");
                        sectIndexToRecordMap.put(sectIndex, rec);
                    }
                    for (int i = 0; i < sectIndexes.size(); ++i) {
                        int sectIndex = sectIndexes.get(i);
                        EventRecord record = (EventRecord)sectIndexToRecordMap.get(sectIndex);
                        Preconditions.checkNotNull((Object)record);
                        double[] elemSlips = record.getElementSlips();
                        List<SimulatorElement> elems = record.getElements();
                        Preconditions.checkState((elemSlips.length == elems.size() ? 1 : 0) != 0);
                        double sumSlipTimesArea = 0.0;
                        for (int e = 0; e < elemSlips.length; ++e) {
                            sumSlipTimesArea += elemSlips[e] * elems.get(e).getArea();
                        }
                        double sectArea = rupSet.getAreaForSection(sectIndex);
                        slips[i] = sumSlipTimesArea / sectArea;
                        slipsNotNormalized[i] = sumSlipTimesArea / record.getArea();
                    }
                    slipsAlong.add(slipsNotNormalized);
                }
                return new SlipAlongRuptureModel.Precomputed(slipsAlong);
            }
        }, SlipAlongRuptureModel.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RSQSimRuptureSetMappings>(){

            @Override
            public RSQSimRuptureSetMappings call() throws Exception {
                return new RSQSimRuptureSetMappings(finalEvents);
            }
        }, RSQSimRuptureSetMappings.class);
        FaultSystemSolution sol = new FaultSystemSolution(rupSet, RSQSimUtils.buildRatesArray(events));
        sol.setInfoString(info);
        return sol;
    }

    private static double[] buildRatesArray(List<? extends SimulatorEvent> events) {
        double[] rates = new double[events.size()];
        double durationYears = SimulatorUtils.getSimulationDurationYears(events);
        double rateEach = 1.0 / durationYears;
        for (int i = 0; i < rates.length; ++i) {
            rates[i] = rateEach;
        }
        return rates;
    }

    @Deprecated
    public static void writeUCERF3ComparisonPlots(FaultSystemSolution sol, FaultModels fm, DeformationModels dm, File dir, String prefix) throws GMT_MapException, RuntimeException, IOException {
        System.out.println("Loading paleo/slip constraints");
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = CommandLineInversionRunner.getPaleoConstraints(fm, sol.getRupSet());
        List<U3AveSlipConstraint> aveSlipConstraints = U3AveSlipConstraint.load(sol.getRupSet().getFaultSectionDataList());
        System.out.println("Writing SAF Seg plots");
        CommandLineInversionRunner.writeSAFSegPlots(sol, fm, dir, prefix);
        System.out.println("Writing parent sect MFD plots");
        CommandLineInversionRunner.writeParentSectionMFDPlots(sol, new File(dir, "parent_sect_mfds"));
        Map<String, List<Integer>> namedFaultsMap = fm.getNamedFaultsMapAlt();
        System.out.println("Writing paleo fault based plots");
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        System.out.println("Plotting slip rates");
        FaultBasedMapGen.plotOrigNonReducedSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotOrigCreepReducedSlipRates(sol, region, dir, prefix, false);
        FaultBasedMapGen.plotTargetSlipRates(sol, region, dir, prefix, false);
        System.out.println("Plotting participation rates");
        for (double[] range : BatchPlotGen.partic_mag_ranges) {
            FaultBasedMapGen.plotParticipationRates(sol, region, dir, prefix, false, range[0], range[1]);
        }
        System.out.println("Plotting sect pair");
        FaultBasedMapGen.plotSectionPairRates(sol, region, dir, prefix, false);
        System.out.println("Plotting segmentation");
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 0.0, 10.0);
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 7.0, 10.0);
        FaultBasedMapGen.plotSegmentation(sol, region, dir, prefix, false, 7.5, 10.0);
        System.out.println("DONE");
    }

    public static void cleanVertFocalMechs(List<SimulatorElement> elems, List<? extends FaultSection> subSects) {
        int offset = RSQSimUtils.getSubSectIndexOffset(elems, subSects);
        for (SimulatorElement elem : elems) {
            FocalMechanism mech = elem.getFocalMechanism();
            if (mech.getDip() != 90.0 || mech.getRake() != -180.0 && mech.getRake() != 180.0 && mech.getRake() != 0.0) continue;
            FaultSection sect = subSects.get(elem.getSectionID() - offset);
            mech.setRake(sect.getAveRake());
            double strike = mech.getStrike();
            double sectStrike = sect.getFaultTrace().getAveStrike();
            double strikeDelta = Math.abs(strike - sectStrike);
            strikeDelta = Math.min(strikeDelta, Math.abs(360.0 + strike - sectStrike));
            strikeDelta = Math.min(strikeDelta, Math.abs(strike - (sectStrike + 360.0)));
            if (strikeDelta > 135.0) {
                strike += 180.0;
            }
            while (strike > 360.0) {
                strike -= 360.0;
            }
            mech.setStrike(strike);
        }
    }

    public static void writeSTLFile(List<SimulatorElement> elements, File file) throws IOException {
        double minLat = Double.POSITIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxDepth = 0.0;
        for (SimulatorElement e : elements) {
            Preconditions.checkState((boolean)(e instanceof TriangularElement), (Object)"STL only supports triangles");
            for (Vertex loc : e.getVertices()) {
                minLat = Math.min(minLat, loc.getLatitude());
                minLon = Math.min(minLon, loc.getLongitude());
                maxDepth = Math.max(maxDepth, loc.getDepth());
            }
        }
        Location refLoc = new Location(minLat, minLon);
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        out.write(new byte[80]);
        out.writeInt(elements.size());
        for (SimulatorElement e : elements) {
            double[] normal;
            double[][] vertices = new double[3][3];
            Vertex[] eVerts = e.getVertices();
            for (int i = 0; i < 3; ++i) {
                LocationVector locationVector = LocationUtils.vector(refLoc, eVerts[i]);
                double az = locationVector.getAzimuthRad();
                double horzDist = locationVector.getHorzDistance();
                double x = horzDist * Math.sin(az);
                double y = horzDist * Math.cos(az);
                double z = -eVerts[i].getDepth();
                vertices[i][0] = x + 0.01;
                vertices[i][1] = y + 0.01;
                vertices[i][2] = z + 0.01;
                Preconditions.checkState((x >= 0.0 ? 1 : 0) != 0, (String)"bad x=%s", (Object)x);
                Preconditions.checkState((y >= 0.0 ? 1 : 0) != 0, (String)"bad y=%s", (Object)y);
            }
            for (double val : normal = PlaneUtils.getNormalVector(vertices)) {
                out.writeFloat((float)val);
            }
            double[][] object = vertices;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                double[] vert;
                for (double val : vert = object[i]) {
                    out.writeFloat((float)val);
                }
            }
            out.writeShort(0);
        }
        out.close();
    }

    public static FaultStyle getFaultStyle(SimulatorElement elem, double rakeTolerance) {
        FocalMechanism mech = elem.getFocalMechanism();
        double rake = mech.getRake();
        Preconditions.checkState((rake >= -180.0 && rake <= 180.0 ? 1 : 0) != 0, (String)"Bad rake: %s", (Object)rake);
        Preconditions.checkState((rakeTolerance >= 0.0 ? 1 : 0) != 0);
        if (rake <= -180.0 + rakeTolerance || rake >= 180.0 - rakeTolerance) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= -rakeTolerance && rake <= rakeTolerance) {
            return FaultStyle.STRIKE_SLIP;
        }
        if (rake >= 90.0 - rakeTolerance && rake <= 90.0 + rakeTolerance) {
            return FaultStyle.REVERSE;
        }
        if (rake >= -90.0 - rakeTolerance && rake <= -90.0 + rakeTolerance) {
            return FaultStyle.NORMAL;
        }
        return FaultStyle.UNKNOWN;
    }

    public static FaultStyle calcFaultStyle(SimulatorEvent event, double rakeTolerance, double maxFractOther) {
        HashMap<FaultStyle, Integer> styleCounts = new HashMap<FaultStyle, Integer>();
        int numElems = 0;
        for (SimulatorElement elem : event.getAllElements()) {
            FaultStyle style = RSQSimUtils.getFaultStyle(elem, rakeTolerance);
            Integer prevCount = styleCounts.containsKey((Object)style) ? (Integer)styleCounts.get((Object)style) : 0;
            styleCounts.put(style, prevCount + 1);
            ++numElems;
        }
        Preconditions.checkState((!styleCounts.isEmpty() ? 1 : 0) != 0);
        if (styleCounts.size() == 1) {
            return (FaultStyle)((Object)styleCounts.keySet().iterator().next());
        }
        for (FaultStyle style : styleCounts.keySet()) {
            double fract = (double)((Integer)styleCounts.get((Object)style)).intValue() / (double)numElems;
            if (!(fract >= 1.0 - maxFractOther)) continue;
            return style;
        }
        return FaultStyle.UNKNOWN;
    }

    public static void main(String[] args) throws IOException, GMT_MapException, RuntimeException {
        int catID = 5895;
        File dir = new File("/data/kevin/simulators/catalogs/bruce/rundir" + catID);
        File geomFile = new File(dir, "zfault_Deepen.in");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'N');
        System.out.println("Loaded " + elements.size() + " elements");
        double minMag = 6.0;
        int skipYears = 10000;
        List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(dir, elements, Lists.newArrayList((Object[])new LogicalAndRupIden[]{new LogicalAndRupIden(new SkipYearsLoadIden(skipYears), new MagRangeRuptureIdentifier(minMag, 10.0))}));
        List<FaultSection> subSects = NSHM23_DeformationModels.AVERAGE.build(NSHM23_FaultModels.WUS_FM_v3);
        System.out.println("read " + subSects.size() + " sub sects");
        double sectFract = 0.5;
        FaultSystemSolution sol = RSQSimUtils.buildFaultSystemSolution(subSects, elements, events, minMag, sectFract);
        sol.write(new File(dir, "rsqsim_" + catID + "_m" + new DecimalFormat("0.#").format(minMag) + "_skip" + skipYears + "_sectArea" + (float)sectFract + ".zip"));
    }

    public static class RSQSimRuptureSetMappings
    implements CSV_BackedModule {
        private int[] eventIDs;

        private RSQSimRuptureSetMappings() {
        }

        public RSQSimRuptureSetMappings(List<? extends SimulatorEvent> events) {
            int[] eventIDs = new int[events.size()];
            for (int i = 0; i < eventIDs.length; ++i) {
                eventIDs[i] = events.get(i).getID();
            }
            this.init(eventIDs);
        }

        public RSQSimRuptureSetMappings(int[] eventIDs) {
            this.init(eventIDs);
        }

        private void init(int[] eventIDs) {
            this.eventIDs = eventIDs;
        }

        public int getEventID(int rupIndex) {
            return this.eventIDs[rupIndex];
        }

        @Override
        public String getFileName() {
            return "rsqsim_rupture_mappings.csv";
        }

        @Override
        public String getName() {
            return "RSQSim Rupture Mappings";
        }

        @Override
        public CSVFile<?> getCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Rupture Index", "RSQSim Event ID");
            for (int i = 0; i < this.eventIDs.length; ++i) {
                csv.addLine("" + i, "" + this.eventIDs[i]);
            }
            return csv;
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            int[] eventIDs = new int[csv.getNumRows() - 1];
            for (int row = 1; row < csv.getNumRows(); ++row) {
                int index = row - 1;
                int csvIndex = csv.getInt(row, 0);
                Preconditions.checkState((csvIndex == index ? 1 : 0) != 0, (String)"CSV out of order? Expected rupture %s at row %s, have %s", (Object)index, (Object)row, (Object)csvIndex);
                eventIDs[index] = csv.getInt(row, 1);
                Preconditions.checkState((eventIDs[index] >= 0 ? 1 : 0) != 0, (String)"Bad eventID=%s", (int)eventIDs[index]);
            }
            this.init(eventIDs);
        }
    }
}

