/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.AnimatedGIFRenderer;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.EventIDsRupIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.srf.RSQSimEventSlipTimeFunc;
import org.opensha.sha.simulators.utils.SimulatorUtils;

public class RupturePlotGenerator {
    public static Color RECT_COLOR = new Color(0, 70, 0);
    public static Color OTHER_SURF_COLOR = new Color(70, 70, 70);
    public static PlotLineType OTHER_SURF_STROKE = PlotLineType.DASHED;
    public static Color HYPO_COLOR = new Color(255, 0, 0, 122);
    public static double HYPO_RADIUS = 0.02;
    public static Color RECT_HYPO_COLOR = new Color(0, 255, 0, 122);
    public static Color CA_OUTLINE_COLOR = Color.DARK_GRAY;
    public static Color OTHER_ELEM_COLOR = new Color(210, 210, 210);
    private static final DecimalFormat timeDF = new DecimalFormat("0.0");
    private static final DecimalFormat keyDF = new DecimalFormat("0.000");
    private static final DecimalFormat magDF = new DecimalFormat("0.00");

    public static List<XYAnnotation> buildElementPolygons(List<SimulatorElement> elems, List<Double> scalars, CPT cpt, boolean skipNan, Color outlineColor, double outlineThickness) {
        ArrayList<XYAnnotation> anns = new ArrayList<XYAnnotation>();
        BasicStroke stroke = null;
        if (outlineColor != null && outlineThickness > 0.0) {
            stroke = new BasicStroke((float)outlineThickness);
        }
        for (int i = 0; i < elems.size(); ++i) {
            double val = scalars.get(i);
            if (skipNan && Double.isNaN(val)) continue;
            SimulatorElement elem = elems.get(i);
            Vertex[] vertexes = elem.getVertices();
            double[] points = new double[vertexes.length * 2];
            int cnt = 0;
            for (Vertex v : vertexes) {
                double das = v.getDAS();
                Preconditions.checkState((!Double.isNaN(das) ? 1 : 0) != 0, (Object)"DAS is nan");
                double depth = v.getDepth();
                points[cnt++] = das;
                points[cnt++] = depth;
            }
            Color c = cpt.getColor((float)val);
            XYPolygonAnnotation poly = new XYPolygonAnnotation(points, (Stroke)stroke, (Paint)outlineColor, (Paint)c);
            anns.add((XYAnnotation)poly);
        }
        return anns;
    }

    public static List<Double> getCumulativeSlipScalars(SimulatorEvent event) {
        return Doubles.asList((double[])event.getAllElementSlips());
    }

    public static List<Double> getTimeFirstSlipScalars(SimulatorEvent event, RSQSimEventSlipTimeFunc func) {
        ArrayList<Double> scalars = new ArrayList<Double>();
        if (func == null) {
            Preconditions.checkState((boolean)(event instanceof RSQSimEvent), (Object)"must be an RSQSim event if no slip-time func");
            RSQSimEvent rsEvent = (RSQSimEvent)event;
            double[] times = rsEvent.getAllElementTimes();
            double minTime = StatUtils.min((double[])times);
            for (double time : times) {
                scalars.add(time - minTime);
            }
        } else {
            for (SimulatorElement e : event.getAllElements()) {
                scalars.add(func.getTimeOfFirstSlip(e.getID()));
            }
        }
        return scalars;
    }

    public static List<Double> getTimeLastSlipScalars(SimulatorEvent event, RSQSimEventSlipTimeFunc func) {
        ArrayList<Double> scalars = new ArrayList<Double>();
        for (SimulatorElement e : event.getAllElements()) {
            scalars.add(func.getTimeOfLastSlip(e.getID()));
        }
        return scalars;
    }

    public static void writeSlipPlot(SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix) throws IOException {
        RupturePlotGenerator.writeSlipPlot(event, func, outputDir, prefix, null, null, null);
    }

    public static void writeSlipPlot(SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline) throws IOException {
        RupturePlotGenerator.writeSlipPlot(event, func, outputDir, prefix, rectangle, rectHypo, surfaceToOutline, false, func != null);
    }

    public static void writeSlipPlot(SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline, boolean pub, boolean includeLast) throws IOException {
        CPT timeCPT;
        double endTime;
        System.out.println("Estimating DAS");
        Location[] refFrame = rectangle == null ? SimulatorUtils.estimateVertexDAS(event) : SimulatorUtils.estimateVertexDAS(event, rectangle[0], rectangle[1]);
        System.out.println("Done estimating DAS");
        if (func != null) {
            func = func.asRelativeTimeFunc();
        }
        boolean contourTimeCPT = false;
        CPT slipCPT = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse();
        double maxSlip = StatUtils.max((double[])event.getAllElementSlips());
        slipCPT = slipCPT.rescale(0.0, Math.ceil(maxSlip));
        List<Double> firstTimes = RupturePlotGenerator.getTimeFirstSlipScalars(event, func);
        if (includeLast) {
            Preconditions.checkNotNull((Object)func, (Object)"can't include last slip if no slip-time func");
            endTime = func.getEndTime();
        } else {
            endTime = 0.0;
            for (double time : firstTimes) {
                endTime = Math.max(endTime, time);
            }
        }
        if (pub) {
            timeCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, endTime);
            double timeDiscr = endTime > 70.0 ? 10.0 : (endTime > 40.0 ? 5.0 : (endTime > 20.0 ? 2.0 : 1.0));
            timeCPT = timeCPT.asDiscrete(timeDiscr, true);
        } else {
            timeCPT = GMT_CPT_Files.GMT_WYSIWYG.instance().rescale(0.0, endTime);
        }
        timeCPT.setAboveMaxColor(timeCPT.getMaxColor());
        if (contourTimeCPT) {
            CPT contourCPT = new CPT();
            for (int i = 0; i < (int)Math.ceil(endTime); ++i) {
                Color c = timeCPT.getColor(i);
                contourCPT.add(new CPTVal(i, c, (float)i + 1.0f, c));
            }
            contourCPT.setAboveMaxColor(contourCPT.getMaxColor());
            timeCPT = contourCPT;
        }
        ArrayList<SimulatorElement> rupElems = event.getAllElements();
        List<XYAnnotation> slipPolys = RupturePlotGenerator.buildElementPolygons(rupElems, RupturePlotGenerator.getCumulativeSlipScalars(event), slipCPT, false, Color.BLACK, 0.1);
        List<XYAnnotation> firstPolys = RupturePlotGenerator.buildElementPolygons(rupElems, firstTimes, timeCPT, false, Color.BLACK, 0.1);
        List<XYAnnotation> lastPolys = null;
        if (includeLast) {
            lastPolys = RupturePlotGenerator.buildElementPolygons(rupElems, RupturePlotGenerator.getTimeLastSlipScalars(event, func), timeCPT, false, Color.BLACK, 0.1);
        }
        DefaultXY_DataSet dummyData = new DefaultXY_DataSet(new double[]{0.0}, new double[]{0.0});
        ArrayList<DefaultXY_DataSet> elems = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        elems.add(dummyData);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 0.01f, Color.WHITE));
        double firstElemTime = Double.POSITIVE_INFINITY;
        double hypoDAS = 0.0;
        double hypoDepth = 0.0;
        for (int i = 0; i < rupElems.size(); ++i) {
            SimulatorElement elem = (SimulatorElement)rupElems.get(i);
            double time = firstTimes.get(i);
            if (!(time < firstElemTime)) continue;
            firstElemTime = time;
            hypoDAS = elem.getAveDAS();
            hypoDepth = elem.getCenterLocation().getDepth();
        }
        BasicStroke hypoStroke = new BasicStroke(2.5f);
        XYPolygonAnnotation hypoPoly = new XYPolygonAnnotation(RupturePlotGenerator.star(hypoDAS, hypoDepth, 1.6), (Stroke)hypoStroke, (Paint)Color.WHITE, (Paint)(pub ? Color.BLUE : HYPO_COLOR));
        slipPolys.add((XYAnnotation)hypoPoly);
        firstPolys.add((XYAnnotation)hypoPoly);
        if (includeLast) {
            lastPolys.add((XYAnnotation)hypoPoly);
        }
        double minDAS = Double.POSITIVE_INFINITY;
        double maxDAS = 0.0;
        double maxDepth = 0.0;
        for (SimulatorElement elem : rupElems) {
            for (Vertex v : elem.getVertices()) {
                double das = v.getDAS();
                if (das < minDAS) {
                    minDAS = das;
                }
                if (das > maxDAS) {
                    maxDAS = das;
                }
                if (!(v.getDepth() > maxDepth)) continue;
                maxDepth = v.getDepth();
            }
        }
        System.out.println("Max DAS: " + maxDAS);
        if (rectangle != null) {
            int i;
            BasicStroke rectStroke = new BasicStroke(3.0f);
            double[][] rectPoints = new double[rectangle.length][2];
            for (i = 0; i < rectangle.length; ++i) {
                rectPoints[i][0] = SimulatorUtils.estimateDAS(refFrame[0], refFrame[1], rectangle[i]);
                rectPoints[i][1] = rectangle[i].getDepth();
                minDAS = Math.min(minDAS, rectPoints[i][0]);
                maxDAS = Math.max(maxDAS, rectPoints[i][0]);
                maxDepth = Math.max(maxDepth, rectPoints[i][1]);
            }
            for (i = 0; i < rectPoints.length; ++i) {
                double[] dArray = rectPoints[i];
                double[] p2 = i == rectPoints.length - 1 ? rectPoints[0] : rectPoints[i + 1];
                XYLineAnnotation line = new XYLineAnnotation(dArray[0], dArray[1], p2[0], p2[1], (Stroke)rectStroke, (Paint)RECT_COLOR);
                slipPolys.add((XYAnnotation)line);
                firstPolys.add((XYAnnotation)line);
                if (!includeLast) continue;
                lastPolys.add((XYAnnotation)line);
            }
        }
        if (rectHypo != null) {
            double rectHypoDAS = SimulatorUtils.estimateDAS(refFrame[0], refFrame[1], rectHypo);
            XYPolygonAnnotation rectHypoPoly = new XYPolygonAnnotation(RupturePlotGenerator.star(rectHypoDAS, rectHypo.getDepth(), 1.0), (Stroke)hypoStroke, (Paint)Color.WHITE, (Paint)RECT_HYPO_COLOR);
            slipPolys.add((XYAnnotation)rectHypoPoly);
            firstPolys.add((XYAnnotation)rectHypoPoly);
            if (includeLast) {
                lastPolys.add((XYAnnotation)rectHypoPoly);
            }
            minDAS = Math.min(minDAS, rectHypoDAS);
            maxDAS = Math.max(maxDAS, rectHypoDAS);
            maxDepth = Math.max(maxDepth, rectHypo.getDepth());
        }
        if (surfaceToOutline != null) {
            ArrayList<? extends RuptureSurface> surfaces = new ArrayList<RuptureSurface>();
            if (surfaceToOutline instanceof CompoundSurface) {
                surfaces.addAll(((CompoundSurface)surfaceToOutline).getSurfaceList());
            } else {
                surfaces.add(surfaceToOutline);
            }
            Stroke surfStroke = OTHER_SURF_STROKE.buildStroke(3.0f);
            for (RuptureSurface ruptureSurface : surfaces) {
                int i;
                ArrayList<Location> outline = new ArrayList<Location>(ruptureSurface.getPerimeter());
                outline.add((Location)outline.get(0));
                double[] dasVals = new double[outline.size()];
                for (i = 0; i < outline.size(); ++i) {
                    dasVals[i] = SimulatorUtils.estimateDAS(refFrame[0], refFrame[1], (Location)outline.get(i));
                }
                for (i = 1; i < dasVals.length; ++i) {
                    XYLineAnnotation line = new XYLineAnnotation(dasVals[i - 1], ((Location)outline.get(i - 1)).getDepth(), dasVals[i], ((Location)outline.get(i)).getDepth(), surfStroke, (Paint)OTHER_SURF_COLOR);
                    slipPolys.add((XYAnnotation)line);
                    firstPolys.add((XYAnnotation)line);
                    if (!includeLast) continue;
                    lastPolys.add((XYAnnotation)line);
                }
            }
        }
        Range xRange = new Range(Math.min(0.0, minDAS) - 1.0, maxDAS + 1.0);
        Range yRange = new Range(-1.0, maxDepth + 1.0);
        DefaultXY_DataSet surfFunc = new DefaultXY_DataSet();
        surfFunc.set(xRange.getLowerBound(), 0.0);
        surfFunc.set(xRange.getUpperBound(), 0.0);
        elems.add(surfFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, new Color(139, 69, 19)));
        ArrayList<PlotSpec> arrayList = new ArrayList<PlotSpec>();
        String title = pub ? "" : "Event " + event.getID() + ", M" + magDF.format(event.getMagnitude());
        PlotSpec slipSpec = new PlotSpec(elems, chars, title, "Distance Along Strike (km)", includeLast ? "Total Slip" : "Depth (km)");
        slipSpec.setPlotAnnotations(slipPolys);
        arrayList.add(slipSpec);
        PlotSpec firstSpec = new PlotSpec(elems, chars, title, "Distance Along Strike (km)", includeLast ? "Time First Slip" : "Depth (km)");
        firstSpec.setPlotAnnotations(firstPolys);
        arrayList.add(firstSpec);
        if (includeLast) {
            PlotSpec lastSpec = new PlotSpec(elems, chars, title, "Distance Along Strike (km)", "Time Last Slip");
            lastSpec.setPlotAnnotations(lastPolys);
            arrayList.add(lastSpec);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setBackgroundColor(Color.WHITE);
        PlotPreferences prefs = gp.getPlotPrefs();
        PaintScaleLegend slipCPTbar = GraphPanel.getLegendForCPT(slipCPT, "Cumulative Slip (m)", prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), 1.0, RectangleEdge.TOP);
        double timeInc = endTime > 20.0 ? 5.0 : (endTime > 10.0 ? 2.0 : 1.0);
        String timeLabel = includeLast ? "Time (s)" : "Time First Slip (s)";
        PaintScaleLegend timeCPTbar = GraphPanel.getLegendForCPT(timeCPT, timeLabel, prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), timeInc, RectangleEdge.BOTTOM);
        slipSpec.addSubtitle((Title)slipCPTbar);
        firstSpec.addSubtitle((Title)timeCPTbar);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        ArrayList<Range> yRanges = new ArrayList<Range>();
        xRanges.add(xRange);
        for (int i = 0; i < arrayList.size(); ++i) {
            yRanges.add(yRange);
        }
        gp.setyAxisInverted(true);
        gp.drawGraphPanel(arrayList, false, false, xRanges, yRanges);
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(5.0);
        tus.add((TickUnit)tu);
        CombinedDomainXYPlot combPlot = (CombinedDomainXYPlot)gp.getPlot();
        List subPlots = combPlot.getSubplots();
        for (XYPlot subPlot : subPlots) {
            subPlot.getRangeAxis().setStandardTickUnits((TickUnitSource)tus);
        }
        int bufferX = 113;
        int bufferY = 332;
        int height = 800;
        double heightEach = (double)(height - bufferY) / (double)arrayList.size();
        System.out.println("Height each: " + heightEach);
        double targetWidth = heightEach * maxDAS / maxDepth;
        System.out.println("Target Width: " + targetWidth);
        int width = (int)targetWidth + bufferX;
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(width, height);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
    }

    public static void writeSlipAnimation(SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputFile, double fps) throws IOException {
        RupturePlotGenerator.writeSlipAnimation(event, func, outputFile, fps, null, null);
    }

    public static void writeSlipAnimation(SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputFile, double fps, Location refLeftLoc, Location refRightLoc) throws IOException {
        System.out.println("Estimating DAS");
        if (refLeftLoc == null || refRightLoc == null) {
            SimulatorUtils.estimateVertexDAS(event);
        } else {
            SimulatorUtils.estimateVertexDAS(event, refLeftLoc, refRightLoc);
        }
        System.out.println("Done estimating DAS");
        func = func.asRelativeTimeFunc();
        CPT slipCPT = GMT_CPT_Files.GMT_HOT.instance().reverse().rescale(0.01, Math.ceil(func.getMaxCumulativeSlip()));
        slipCPT = slipCPT.asDiscrete(20, false);
        slipCPT.add(0, new CPTVal(0.0, Color.WHITE, slipCPT.getMinValue(), Color.WHITE));
        CPT velCPT = new CPT(0.01, func.getMaxSlipVel(), new Color(100, 100, 255), Color.RED, new Color(60, 0, 0));
        velCPT = velCPT.asDiscrete(20, true);
        velCPT.add(0, new CPTVal(0.0, Color.WHITE, velCPT.getMinValue(), Color.WHITE));
        ArrayList<SimulatorElement> rupElems = event.getAllElements();
        ArrayList<Double> emptyScalars = new ArrayList<Double>();
        for (int i = 0; i < rupElems.size(); ++i) {
            emptyScalars.add(0.0);
        }
        List<XYAnnotation> slipPolys = RupturePlotGenerator.buildElementPolygons(rupElems, emptyScalars, slipCPT, false, Color.BLACK, 0.1);
        List<XYAnnotation> velPolys = RupturePlotGenerator.buildElementPolygons(rupElems, emptyScalars, velCPT, false, Color.BLACK, 0.1);
        DefaultXY_DataSet dummyData = new DefaultXY_DataSet(new double[]{0.0}, new double[]{0.0});
        ArrayList<DefaultXY_DataSet> elems = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        elems.add(dummyData);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 0.01f, Color.WHITE));
        AnimatedGIFRenderer gifRender = new AnimatedGIFRenderer(outputFile, fps, true);
        double dt = 1.0 / fps;
        double maxTime = Math.ceil(func.getEndTime() / dt) * dt;
        String title = "Rupture Animation";
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(16);
        gp.setAxisLabelFontSize(18);
        gp.setPlotLabelFontSize(18);
        gp.setBackgroundColor(Color.WHITE);
        PlotPreferences prefs = gp.getPlotPrefs();
        PaintScaleLegend slipCPTbar = GraphPanel.getLegendForCPT(slipCPT, "Cumulative Slip (m)", prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), 1.0, RectangleEdge.TOP);
        PaintScaleLegend velCPTbar = null;
        if (func.getMaxSlipVel() != func.getMinSlipVel()) {
            velCPTbar = GraphPanel.getLegendForCPT(velCPT, "SLip Velocity (m/s)", prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), 0.5, RectangleEdge.BOTTOM);
        }
        double minDAS = Double.POSITIVE_INFINITY;
        double maxDAS = Double.NEGATIVE_INFINITY;
        double maxDepth = 0.0;
        for (SimulatorElement elem : rupElems) {
            for (Vertex v : elem.getVertices()) {
                minDAS = Math.min(minDAS, v.getDAS());
                maxDAS = Math.max(maxDAS, v.getDAS());
                maxDepth = Math.max(maxDepth, v.getDepth());
            }
        }
        Range xRange = new Range(Math.min(0.0, minDAS) - 1.0, maxDAS + 1.0);
        Range yRange = new Range(-1.0, maxDepth + 1.0);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        ArrayList<Range> yRanges = new ArrayList<Range>();
        xRanges.add(xRange);
        yRanges.add(yRange);
        yRanges.add(yRange);
        int totFrames = (int)Math.ceil(maxTime / dt);
        System.out.println("Bulding animation with " + totFrames + " frames");
        System.out.print("Frame:");
        int frameIndex = 0;
        for (double t = 0.0; t <= maxTime; t += dt) {
            if (frameIndex % 40 == 0) {
                System.out.println();
            } else {
                System.out.print(" ");
            }
            System.out.print(frameIndex++);
            ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
            for (int i = 0; i < rupElems.size(); ++i) {
                XYPolygonAnnotation slipPoly = (XYPolygonAnnotation)slipPolys.get(i);
                XYPolygonAnnotation velPoly = (XYPolygonAnnotation)velPolys.get(i);
                int patchID = ((SimulatorElement)rupElems.get(i)).getID();
                double slip = func.getCumulativeEventSlip(patchID, t);
                double vel = func.getVelocity(patchID, t);
                Color slipColor = slipCPT.getColor((float)slip);
                Color velColor = velCPT.getColor((float)vel);
                slipPoly = new XYPolygonAnnotation(slipPoly.getPolygonCoordinates(), slipPoly.getOutlineStroke(), slipPoly.getOutlinePaint(), (Paint)slipColor);
                slipPolys.set(i, (XYAnnotation)slipPoly);
                velPoly = new XYPolygonAnnotation(velPoly.getPolygonCoordinates(), velPoly.getOutlineStroke(), velPoly.getOutlinePaint(), (Paint)velColor);
                velPolys.set(i, (XYAnnotation)velPoly);
            }
            String myTitle = title + " (" + timeDF.format(t) + "s)";
            PlotSpec slipSpec = new PlotSpec(elems, chars, myTitle, "Distance Along Strike (km)", "Depth (km)");
            slipSpec.setPlotAnnotations(slipPolys);
            specs.add(slipSpec);
            slipSpec.addSubtitle((Title)slipCPTbar);
            PlotSpec velSpec = new PlotSpec(elems, chars, myTitle, "Distance Along Strike (km)", "Depth (km)");
            velSpec.setPlotAnnotations(velPolys);
            if (velCPTbar != null) {
                velSpec.addSubtitle((Title)velCPTbar);
            }
            specs.add(velSpec);
            gp.setyAxisInverted(true);
            gp.drawGraphPanel(specs, false, false, xRanges, yRanges);
            int bufferX = 60;
            int bufferY = 100;
            int height = 400;
            if (velCPTbar != null) {
                bufferY += 80;
                height += 80;
            }
            double heightEach = (double)(height - bufferY) / 3.0;
            double targetWidth = heightEach * maxDAS / maxDepth;
            int width = (int)targetWidth + bufferX;
            gp.getChartPanel().setSize(width, height);
            BufferedImage img = gp.getBufferedImage(width, height);
            gifRender.writeFrame(img);
        }
        System.out.println("\nDONE");
        gifRender.finalizeAnimation();
    }

    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix) throws IOException {
        return RupturePlotGenerator.writeMapPlot(allElems, event, func, outputDir, prefix, null, null, null);
    }

    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline) throws IOException {
        return RupturePlotGenerator.writeMapPlot(allElems, event, func, outputDir, prefix, rectangle, rectHypo, surfaceToOutline, null, null, null);
    }

    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline, double[] eventElemScalars, CPT elemCPT, String scalarLabel) throws IOException {
        return RupturePlotGenerator.writeMapPlot(allElems, event, func, outputDir, prefix, rectangle, rectHypo, surfaceToOutline, eventElemScalars, elemCPT, scalarLabel, null);
    }

    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline, double[] eventElemScalars, CPT elemCPT, String scalarLabel, List<XYAnnotation> anns) throws IOException {
        return RupturePlotGenerator.writeMapPlot(allElems, event, func, outputDir, prefix, rectangle, rectHypo, surfaceToOutline, null, eventElemScalars, elemCPT, scalarLabel, anns);
    }

    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline, List<SimulatorElement> scaledElems, double[] customElemScalars, CPT elemCPT, String scalarLabel, List<XYAnnotation> anns) throws IOException {
        String title = event == null ? null : "Event " + event.getID() + ", M" + magDF.format(event.getMagnitude());
        return RupturePlotGenerator.writeMapPlot(allElems, event, func, outputDir, prefix, rectangle, rectHypo, surfaceToOutline, scaledElems, customElemScalars, elemCPT, scalarLabel, anns, title);
    }

    /*
     * WARNING - void declaration
     */
    public static PlotSpec writeMapPlot(List<SimulatorElement> allElems, SimulatorEvent event, RSQSimEventSlipTimeFunc func, File outputDir, String prefix, Location[] rectangle, Location rectHypo, RuptureSurface surfaceToOutline, List<SimulatorElement> scaledElems, double[] customElemScalars, CPT elemCPT, String scalarLabel, List<XYAnnotation> anns, String title) throws IOException {
        Location hypoLoc;
        double firstElemTime;
        Location loc;
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        if (event != null) {
            for (SimulatorElement elem : event.getAllElements()) {
                loc = elem.getCenterLocation();
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
        }
        if (scaledElems != null) {
            for (SimulatorElement elem : scaledElems) {
                loc = elem.getCenterLocation();
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
            }
        }
        if (rectangle != null) {
            for (Location loc2 : rectangle) {
                latTrack.addValue(loc2.getLatitude());
                lonTrack.addValue(loc2.getLongitude());
            }
        }
        if (surfaceToOutline != null) {
            ArrayList surfaces = new ArrayList();
            if (surfaceToOutline instanceof CompoundSurface) {
                surfaces.addAll(((CompoundSurface)surfaceToOutline).getSurfaceList());
            } else {
                surfaces.add(surfaceToOutline);
            }
            Iterator elem = surfaces.iterator();
            while (elem.hasNext()) {
                RuptureSurface surf = (RuptureSurface)elem.next();
                LocationList outline = surf.getPerimeter();
                for (Location loc3 : outline) {
                    latTrack.addValue(loc3.getLatitude());
                    lonTrack.addValue(loc3.getLongitude());
                }
            }
        }
        if (anns != null) {
            for (XYAnnotation ann : anns) {
                if (ann instanceof XYPolygonAnnotation) {
                    double[] poly = ((XYPolygonAnnotation)ann).getPolygonCoordinates();
                    for (int i = 0; i < poly.length; ++i) {
                        if (i % 2 == 0) {
                            lonTrack.addValue(poly[i]);
                            continue;
                        }
                        latTrack.addValue(poly[i]);
                    }
                    continue;
                }
                if (!(ann instanceof XYTextAnnotation)) continue;
                lonTrack.addValue(((XYTextAnnotation)ann).getX());
                latTrack.addValue(((XYTextAnnotation)ann).getY());
            }
        }
        double centerLat = 0.5 * (latTrack.getMax() + latTrack.getMin());
        double centerLon = 0.5 * (lonTrack.getMax() + lonTrack.getMin());
        double maxDelta = Math.max(latTrack.getMax() - latTrack.getMin(), lonTrack.getMax() - lonTrack.getMin());
        maxDelta *= 1.2;
        maxDelta = Math.max(maxDelta, 0.75);
        Range xRange = new Range(centerLon - 0.5 * maxDelta, centerLon + 0.5 * maxDelta);
        Range yRange = new Range(centerLat - 0.5 * maxDelta, centerLat + 0.5 * maxDelta);
        DiscretizedFunc regThicknessFunc = RupturePlotGenerator.buildRegionSizeThicknessFunc();
        double minThickness = regThicknessFunc.getInterpolatedY(maxDelta);
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        List<SimulatorElement> rupElems = null;
        if (event != null || customElemScalars != null) {
            rupElems = event == null && customElemScalars != null ? scaledElems : event.getAllElements();
            double maxDepth = allElems != null ? RupturePlotGenerator.getMaxDepth(allElems) : RupturePlotGenerator.getMaxDepth(rupElems);
            if (customElemScalars == null) {
                double maxRupDepth = RupturePlotGenerator.getMaxDepth(rupElems);
                RupturePlotGenerator.addDepthDepOutline(funcs, chars, rupElems, Color.BLACK, maxRupDepth, minThickness, 3.0 * minThickness);
            } else {
                RupturePlotGenerator.addElementScalarOutline(funcs, chars, rupElems, customElemScalars, elemCPT, maxDepth, minThickness, 3.0 * minThickness);
            }
        }
        BasicStroke hypoStroke = new BasicStroke(1.0f);
        if (anns == null) {
            anns = new ArrayList<XYAnnotation>();
        }
        if (func != null) {
            firstElemTime = Double.POSITIVE_INFINITY;
            hypoLoc = null;
            for (SimulatorElement elem : rupElems) {
                double time = func.getTimeOfFirstSlip(elem.getID());
                if (!(time < firstElemTime)) continue;
                firstElemTime = time;
                hypoLoc = elem.getCenterLocation();
            }
            XYPolygonAnnotation xYPolygonAnnotation = new XYPolygonAnnotation(RupturePlotGenerator.star(hypoLoc.getLongitude(), hypoLoc.getLatitude(), HYPO_RADIUS), (Stroke)hypoStroke, (Paint)Color.BLACK, (Paint)HYPO_COLOR);
            anns.add((XYAnnotation)xYPolygonAnnotation);
        } else if (event != null) {
            EventRecord rec;
            double[] times;
            firstElemTime = Double.POSITIVE_INFINITY;
            hypoLoc = null;
            Iterator<EventRecord> iterator = event.iterator();
            while (iterator.hasNext() && (times = (rec = iterator.next()).getElementTimeFirstSlips()) != null) {
                List<SimulatorElement> elems = rec.getElements();
                for (int i = 0; i < times.length; ++i) {
                    if (!(times[i] < firstElemTime)) continue;
                    firstElemTime = times[i];
                    hypoLoc = elems.get(i).getCenterLocation();
                }
            }
            if (hypoLoc != null) {
                XYPolygonAnnotation xYPolygonAnnotation = new XYPolygonAnnotation(RupturePlotGenerator.star(hypoLoc.getLongitude(), hypoLoc.getLatitude(), HYPO_RADIUS), (Stroke)hypoStroke, (Paint)Color.BLACK, (Paint)HYPO_COLOR);
                anns.add((XYAnnotation)xYPolygonAnnotation);
            }
        }
        if (rectangle != null) {
            PlotCurveCharacterstics rectChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f * (float)minThickness, RECT_COLOR);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int i = 0; i <= rectangle.length; ++i) {
                void var34_69;
                if (i == rectangle.length) {
                    Location location = rectangle[0];
                } else {
                    Location location = rectangle[i];
                }
                xy.set(var34_69.getLongitude(), var34_69.getLatitude());
            }
            funcs.add(xy);
            chars.add(rectChar);
        }
        if (rectHypo != null) {
            XYPolygonAnnotation rectHypoPoly2 = new XYPolygonAnnotation(RupturePlotGenerator.star(rectHypo.getLongitude(), rectHypo.getLatitude(), HYPO_RADIUS), (Stroke)hypoStroke, (Paint)Color.BLACK, (Paint)RECT_HYPO_COLOR);
            anns.add((XYAnnotation)rectHypoPoly2);
        }
        if (surfaceToOutline != null) {
            PlotCurveCharacterstics rectChar = new PlotCurveCharacterstics(OTHER_SURF_STROKE, 2.0f * (float)minThickness, OTHER_SURF_COLOR);
            ArrayList<? extends RuptureSurface> surfaces = new ArrayList<RuptureSurface>();
            if (surfaceToOutline instanceof CompoundSurface) {
                surfaces.addAll(((CompoundSurface)surfaceToOutline).getSurfaceList());
            } else {
                surfaces.add(surfaceToOutline);
            }
            for (RuptureSurface ruptureSurface : surfaces) {
                LocationList outline = ruptureSurface.getPerimeter();
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                for (int i = 0; i <= outline.size(); ++i) {
                    Location l = i == outline.size() ? (Location)outline.get(0) : (Location)outline.get(i);
                    xy.set(l.getLongitude(), l.getLatitude());
                }
                funcs.add(xy);
                chars.add(rectChar);
            }
        }
        if (allElems != null) {
            PlotCurveCharacterstics allElemChar = new PlotCurveCharacterstics(PlotLineType.SOLID, (float)minThickness, OTHER_ELEM_COLOR);
            Region plotRegion = new Region(new Location(yRange.getLowerBound(), xRange.getLowerBound()), new Location(yRange.getUpperBound(), xRange.getUpperBound()));
            ArrayList<XY_DataSet> allElemFuncs = new ArrayList<XY_DataSet>();
            ArrayList<PlotCurveCharacterstics> arrayList = new ArrayList<PlotCurveCharacterstics>();
            RupturePlotGenerator.addElementOutline(allElemFuncs, arrayList, allElems, allElemChar, plotRegion);
            funcs.addAll(0, allElemFuncs);
            chars.addAll(0, arrayList);
        }
        if (CA_OUTLINE_COLOR != null) {
            XY_DataSet[] outlines = PoliticalBoundariesData.loadCAOutlines();
            PlotCurveCharacterstics outlineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, (float)minThickness, CA_OUTLINE_COLOR);
            for (XY_DataSet outline : outlines) {
                funcs.add(outline);
                chars.add(outlineChar);
            }
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Longitude", "Latitude");
        spec.setPlotAnnotations(anns);
        if (outputDir != null) {
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setBackgroundColor(Color.WHITE);
            gp.drawGraphPanel(spec, false, false, xRange, yRange);
            if (customElemScalars != null) {
                PaintScaleLegend cptLegend = GraphPanel.getLegendForCPT(elemCPT, scalarLabel, 24, 18, -1.0, RectangleEdge.BOTTOM);
                gp.getChartPanel().getChart().addSubtitle((Title)cptLegend);
            }
            double tick = maxDelta > 3.0 ? 1.0 : (maxDelta > 1.5 ? 0.5 : (maxDelta > 0.8 ? 0.25 : 0.1));
            TickUnits tus = new TickUnits();
            NumberTickUnit tu = new NumberTickUnit(tick);
            tus.add((TickUnit)tu);
            gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
            gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
            File file = new File(outputDir, prefix);
            gp.getChartPanel().setSize(800, 800);
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        }
        return spec;
    }

    public static void addElementOutline(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, List<SimulatorElement> elements, PlotCurveCharacterstics elemChar, Region plotRegion) {
        HashMap<String, DefaultXY_DataSet> prevElemXYs = new HashMap<String, DefaultXY_DataSet>();
        int elemsAdded = 0;
        for (SimulatorElement elem : elements) {
            Vertex[] vertexes = elem.getVertices();
            if (plotRegion != null) {
                boolean skip = true;
                for (Vertex loc : vertexes) {
                    if (!plotRegion.contains(loc)) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
            }
            ++elemsAdded;
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int i = 0; i <= vertexes.length; ++i) {
                Vertex v = i == vertexes.length ? vertexes[0] : vertexes[i];
                xy.set(v.getLongitude(), v.getLatitude());
            }
            String firstPtStr = RupturePlotGenerator.pointKey(xy.get(0));
            String lastPtStr = RupturePlotGenerator.pointKey(xy.get(xy.size() - 1));
            if (prevElemXYs.containsKey(firstPtStr)) {
                DefaultXY_DataSet oXY = (DefaultXY_DataSet)prevElemXYs.get(firstPtStr);
                for (Point2D pt : xy) {
                    oXY.set(pt);
                }
                continue;
            }
            prevElemXYs.put(lastPtStr, xy);
            funcs.add(xy);
            chars.add(elemChar);
        }
    }

    private static double getMaxDepth(List<SimulatorElement> elements) {
        double maxDepth = 0.0;
        for (SimulatorElement el : elements) {
            maxDepth = Math.max(maxDepth, el.getAveDepth());
        }
        return maxDepth;
    }

    private static DiscretizedFunc buildElemDepthThicknessFunc(double maxDepth, double thicknessSurface, double thicknessAtDepth) {
        ArbitrarilyDiscretizedFunc depthThickFunc = new ArbitrarilyDiscretizedFunc();
        depthThickFunc.set(0.0, thicknessSurface);
        depthThickFunc.set(maxDepth, thicknessAtDepth);
        return depthThickFunc;
    }

    private static DiscretizedFunc buildDepthSaturationFunc(double maxDepth) {
        ArbitrarilyDiscretizedFunc depthThickFunc = new ArbitrarilyDiscretizedFunc();
        depthThickFunc.set(0.0, 1.0);
        depthThickFunc.set(maxDepth, 0.5);
        return depthThickFunc;
    }

    private static DiscretizedFunc buildRegionSizeThicknessFunc() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(0.0, 1.0);
        func.set(1.0, 1.0);
        func.set(5.0, 0.5);
        func.set(180.0, 0.5);
        return func;
    }

    public static void addElementScalarOutline(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, List<SimulatorElement> elements, double[] scalars, CPT cpt, double maxDepth, double minThickness, double maxThickness) {
        Preconditions.checkState((elements.size() == scalars.length ? 1 : 0) != 0);
        DiscretizedFunc depthThicknessFunc = RupturePlotGenerator.buildElemDepthThicknessFunc(maxDepth, maxThickness, minThickness);
        DiscretizedFunc depthSaturationFunc = RupturePlotGenerator.buildDepthSaturationFunc(maxDepth);
        HashMap<SimulatorElement, Double> elemToScalarMap = new HashMap<SimulatorElement, Double>();
        for (int e = 0; e < elements.size(); ++e) {
            elemToScalarMap.put(elements.get(e), scalars[e]);
        }
        elements = new ArrayList<SimulatorElement>(elements);
        Collections.sort(elements, new Comparator<SimulatorElement>(){

            @Override
            public int compare(SimulatorElement o1, SimulatorElement o2) {
                return Double.compare(o2.getAveDepth(), o1.getAveDepth());
            }
        });
        for (SimulatorElement elem : elements) {
            Vertex[] vertexes = elem.getVertices();
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int i = 0; i <= vertexes.length; ++i) {
                Vertex v = i == vertexes.length ? vertexes[0] : vertexes[i];
                xy.set(v.getLongitude(), v.getLatitude());
            }
            funcs.add(xy);
            double depth = elem.getCenterLocation().getDepth();
            float lineWidth = (float)depthThicknessFunc.getInterpolatedY(depth);
            Color color = cpt.getColor(((Double)elemToScalarMap.get(elem)).floatValue());
            double saturationFactor = depthSaturationFunc.getInterpolatedY(depth);
            color = new Color((int)(saturationFactor * (double)color.getRed() + 0.5), (int)(saturationFactor * (double)color.getGreen() + 0.5), (int)(saturationFactor * (double)color.getBlue() + 0.5));
            PlotCurveCharacterstics elemChar = new PlotCurveCharacterstics(PlotLineType.SOLID, lineWidth, color);
            chars.add(elemChar);
        }
    }

    public static void addDepthDepOutline(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, List<SimulatorElement> elements, Color upperColor, double maxDepth, double minThickness, double maxThickness) {
        DiscretizedFunc depthThicknessFunc = RupturePlotGenerator.buildElemDepthThicknessFunc(maxDepth, maxThickness, minThickness);
        DiscretizedFunc depthSaturationFunc = RupturePlotGenerator.buildDepthSaturationFunc(maxDepth);
        elements = new ArrayList<SimulatorElement>(elements);
        Collections.sort(elements, new Comparator<SimulatorElement>(){

            @Override
            public int compare(SimulatorElement o1, SimulatorElement o2) {
                return Double.compare(o2.getAveDepth(), o1.getAveDepth());
            }
        });
        for (SimulatorElement elem : elements) {
            Vertex[] vertexes = elem.getVertices();
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int i = 0; i <= vertexes.length; ++i) {
                Vertex v = i == vertexes.length ? vertexes[0] : vertexes[i];
                xy.set(v.getLongitude(), v.getLatitude());
            }
            funcs.add(xy);
            double depth = elem.getCenterLocation().getDepth();
            float lineWidth = (float)depthThicknessFunc.getInterpolatedY(depth);
            double saturationFactor = depthSaturationFunc.getInterpolatedY(depth);
            Color color = new Color((int)(saturationFactor * (double)upperColor.getRed() + 0.5), (int)(saturationFactor * (double)upperColor.getGreen() + 0.5), (int)(saturationFactor * (double)upperColor.getBlue() + 0.5));
            PlotCurveCharacterstics elemChar = new PlotCurveCharacterstics(PlotLineType.SOLID, lineWidth, color);
            chars.add(elemChar);
        }
    }

    private static String pointKey(Point2D pt) {
        return keyDF.format(pt.getX()) + "_" + keyDF.format(pt.getY());
    }

    public static double[] star(double x, double y, double radius) {
        double outerRatio = 2.618;
        int num = 10;
        double radsEach = 0.6283185307179586;
        double[] poly = new double[num * 2];
        int count = 0;
        for (int i = 0; i < 10; ++i) {
            double dist = i % 2 == 1 ? radius : radius / outerRatio;
            double angle = radsEach * (double)i;
            double dx = Math.sin(angle) * dist;
            double dy = Math.cos(angle) * dist;
            poly[count++] = x + dx;
            poly[count++] = y + dy;
        }
        return poly;
    }

    public static void main(String[] args) throws IOException {
        File catalogDir = new File("/data/kevin/simulators/catalogs/rundir2585_1myr");
        File geomFile = new File(catalogDir, "zfault_Deepen.in");
        System.out.println("Loading geometry...");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'S');
        ArrayList<EventIDsRupIden> loadIdens = new ArrayList<EventIDsRupIden>();
        loadIdens.add(new EventIDsRupIden(9474557));
        List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(catalogDir, elements, loadIdens);
        for (RSQSimEvent event : events) {
            RupturePlotGenerator.writeMapPlot(elements, event, null, new File("/tmp"), "event_" + event.getID());
        }
    }
}

