/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NSHMP_Util {
    private static Map<Integer, Map<Integer, Double>> rjb_map;
    private static Map<Integer, Map<Integer, Map<Integer, Double>>> cbhw_map;
    private static Map<Integer, Map<Integer, Map<Integer, Double>>> cyhw_map;
    private static String datPath;
    private static String rjbDatPath;
    private static String cbhwDatPath;
    private static String cyhwDatPath;

    private static void readRjbDat() {
        String magID = "#Mag";
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(NSHMP_Util.class.getResourceAsStream(rjbDatPath)));
            HashMap<Integer, Double> magMap = null;
            while ((line = br.readLine()) != null) {
                String[] dVal;
                if (line.startsWith(magID)) {
                    double mag = Double.parseDouble(line.substring(magID.length() + 1).trim());
                    int magKey = (int)Math.round(mag * 100.0);
                    magMap = new HashMap<Integer, Double>();
                    rjb_map.put(magKey, magMap);
                    continue;
                }
                if (line.startsWith("#") || (dVal = StringUtils.split((String)line)).length == 0) continue;
                int distKey = Double.valueOf(dVal[0]).intValue();
                magMap.put(distKey, Double.parseDouble(dVal[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readHwDat(Map<Integer, Map<Integer, Map<Integer, Double>>> map, String path, double startMag) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(NSHMP_Util.class.getResourceAsStream(path)));
            HashMap<Integer, HashMap<Integer, Double>> periodMap = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("C")) {
                    double per = Double.parseDouble(StringUtils.split((String)line)[4]);
                    int perKey = (int)(per * 1000.0);
                    periodMap = new HashMap<Integer, HashMap<Integer, Double>>();
                    map.put(perKey, periodMap);
                    continue;
                }
                String[] values = StringUtils.split((String)line);
                if (values.length == 0) continue;
                int distKey = Integer.parseInt(values[0]);
                int magIdx = Integer.parseInt(values[1]);
                int magKey = (int)(startMag * 100.0) + (magIdx - 1) * 10;
                double hwVal = Double.parseDouble(values[2]);
                HashMap<Integer, Double> magMap = (HashMap<Integer, Double>)periodMap.get(magKey);
                if (magMap == null) {
                    magMap = new HashMap<Integer, Double>();
                    periodMap.put(magKey, magMap);
                }
                magMap.put(distKey, hwVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getMeanRJB(double M, double D) {
        int magKey = (int)Math.round(M * 100.0);
        Preconditions.checkArgument((boolean)rjb_map.containsKey(magKey), (Object)("Invalid mag value: " + M + " (key=" + magKey + ")"));
        int distKey = (int)Math.floor(D);
        return D <= 1000.0 ? rjb_map.get(magKey).get(distKey) : D;
    }

    public static double getAvgHW_CB(double M, double D, double P) {
        return NSHMP_Util.getAvgHW(cbhw_map, M, D, P);
    }

    public static double getAvgHW_CY(double M, double D, double P) {
        return NSHMP_Util.getAvgHW(cyhw_map, M, D, P);
    }

    private static double getAvgHW(Map<Integer, Map<Integer, Map<Integer, Double>>> map, double M, double D, double P) {
        int perKey = (int)(P * 1000.0);
        Preconditions.checkArgument((boolean)map.containsKey(perKey), (Object)("Invalid period: " + P));
        Map<Integer, Map<Integer, Double>> magMap = map.get(perKey);
        int magKey = Double.valueOf(M * 100.0).intValue();
        if (!magMap.containsKey(magKey)) {
            return 0.0;
        }
        int distKey = Double.valueOf(Math.floor(D)).intValue();
        return distKey > 200 ? 0.0 : magMap.get(magKey).get(distKey);
    }

    static {
        datPath = "/data/nshmp/";
        rjbDatPath = datPath + "rjbmean.dat";
        cbhwDatPath = datPath + "avghw_cb.dat";
        cyhwDatPath = datPath + "avghw_cy.dat";
        rjb_map = new HashMap<Integer, Map<Integer, Double>>();
        cbhw_map = new HashMap<Integer, Map<Integer, Map<Integer, Double>>>();
        cyhw_map = new HashMap<Integer, Map<Integer, Map<Integer, Double>>>();
        NSHMP_Util.readRjbDat();
        NSHMP_Util.readHwDat(cbhw_map, cbhwDatPath, 6.05);
        NSHMP_Util.readHwDat(cyhw_map, cyhwDatPath, 5.05);
    }
}

