/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.imr.attenRelImpl.calc.Wald_MMI_Calc;

public class ShakeMapXMLWriter {
    private static final DecimalFormat degreeDF = new DecimalFormat("0.0000");
    private static final DecimalFormat valDF = new DecimalFormat("0.00");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static void writeXML(File outputFile, double mag, String name, String eventID, GriddedGeoDataSet pga, GriddedGeoDataSet pgv, GriddedGeoDataSet sa03, GriddedGeoDataSet sa10, GriddedGeoDataSet sa30) throws IOException {
        double lonSpacing;
        Preconditions.checkState((pga.size() == pgv.size() ? 1 : 0) != 0);
        Preconditions.checkState((pga.size() == sa03.size() ? 1 : 0) != 0);
        Preconditions.checkState((pga.size() == sa10.size() ? 1 : 0) != 0);
        Preconditions.checkState((sa30 == null || pga.size() == sa30.size() ? 1 : 0) != 0);
        GriddedRegion region = pga.getRegion();
        Preconditions.checkState((boolean)region.isRectangular(), (Object)"Region must be rectangular");
        DataUtils.MinMaxAveTracker gridLatTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker gridLonTrack = new DataUtils.MinMaxAveTracker();
        for (Location loc : region.getNodeList()) {
            gridLatTrack.addValue(loc.getLatitude());
            gridLonTrack.addValue(loc.getLongitude());
        }
        double minGridLat = gridLatTrack.getMin();
        double maxGridLat = gridLatTrack.getMax();
        double latSpacing = region.getLatSpacing();
        int numLat = (int)((maxGridLat - minGridLat) / latSpacing + 1.4);
        double minGridLon = gridLonTrack.getMin();
        double maxGridLon = gridLonTrack.getMax();
        int numLon = (int)((maxGridLon - minGridLon) / (lonSpacing = region.getLonSpacing()) + 1.4);
        int expectedSize = numLon * numLat;
        Preconditions.checkState((expectedSize == pga.size() ? 1 : 0) != 0, (String)"Coudn't calculate size: %s * %s = %s != %s", (Object)numLon, (Object)numLat, (Object)expectedSize, (Object)pga.size());
        Document doc = XMLUtils.createDocumentWithRoot("shakemap_grid");
        Element root = doc.getRootElement();
        root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.addAttribute("xmlns", "http://earthquake.usgs.gov/eqcenter/shakemap");
        root.addAttribute("xsi:schemaLocation", "http://earthquake.usgs.gov http://earthquake.usgs.gov/eqcenter/shakemap/xml/schemas/shakemap.xsd");
        root.addAttribute("event_id", eventID);
        root.addAttribute("shakemap_id", eventID);
        root.addAttribute("shakemap_version", "1");
        root.addAttribute("code_version", "3.5.1543");
        root.addAttribute("process_timestamp", dateFormat.format(new Date()));
        root.addAttribute("shakemap_originator", "us");
        root.addAttribute("map_status", "RELEASED");
        root.addAttribute("shakemap_event_type", "SCENARIO");
        Element eventEl = root.addElement("event");
        eventEl.addAttribute("event_id", eventID);
        eventEl.addAttribute("magnitude", valDF.format(mag));
        eventEl.addAttribute("event_description", name);
        Element gridSpecEl = root.addElement("grid_specification");
        gridSpecEl.addAttribute("lon_min", "" + (float)pga.getMinLon());
        gridSpecEl.addAttribute("lat_min", "" + (float)pga.getMinLat());
        gridSpecEl.addAttribute("lon_max", "" + (float)pga.getMaxLon());
        gridSpecEl.addAttribute("lat_max", "" + (float)pga.getMaxLat());
        gridSpecEl.addAttribute("nominal_lon_spacing", "" + (float)region.getLonSpacing());
        gridSpecEl.addAttribute("nominal_lat_spacing", "" + (float)region.getLatSpacing());
        gridSpecEl.addAttribute("nlon", "" + numLon);
        gridSpecEl.addAttribute("nlat", "" + numLat);
        ShakeMapXMLWriter.addGridFieldEl(root, 1, "LON", "dd");
        ShakeMapXMLWriter.addGridFieldEl(root, 2, "LAT", "dd");
        ShakeMapXMLWriter.addGridFieldEl(root, 3, "PGA", "pctg");
        ShakeMapXMLWriter.addGridFieldEl(root, 4, "PGV", "cms");
        ShakeMapXMLWriter.addGridFieldEl(root, 5, "MMI", "intensity");
        ShakeMapXMLWriter.addGridFieldEl(root, 6, "PSA03", "pctg");
        ShakeMapXMLWriter.addGridFieldEl(root, 7, "PSA10", "pctg");
        ShakeMapXMLWriter.addGridFieldEl(root, 8, "PSA30", "pctg");
        StringBuilder gridText = new StringBuilder().append("\n");
        int y = numLat;
        while (--y >= 0) {
            double lat = minGridLat + (double)y * region.getLatSpacing();
            String latStr = degreeDF.format(lat);
            for (int x = 0; x < numLon; ++x) {
                double lon = minGridLon + (double)x * region.getLonSpacing();
                int index = region.indexForLocation(new Location(lat, lon));
                gridText.append(degreeDF.format(lon) + " ");
                gridText.append(latStr + " ");
                double pgaVal = pga.get(index);
                Preconditions.checkState((pgaVal >= 0.0 ? 1 : 0) != 0, (String)"Bad PGA: %s", (Object)pgaVal);
                gridText.append(valDF.format(pgaVal * 100.0) + " ");
                double pgvVal = pgv.get(index);
                Preconditions.checkState((pgvVal >= 0.0 ? 1 : 0) != 0, (String)"Bad PGV: %s", (Object)pgvVal);
                gridText.append(valDF.format(pgvVal) + " ");
                double mmi = Wald_MMI_Calc.getMMI(pga.get(index), pgv.get(index));
                Preconditions.checkState((mmi >= 0.0 && Double.isFinite(mmi) ? 1 : 0) != 0, (String)"Bad MMI=%s with pga=%s and pgv=%s", (Object)mmi, (Object)pgaVal, (Object)pgvVal);
                gridText.append(valDF.format(mmi) + " ");
                double sa03val = sa03.get(index);
                Preconditions.checkState((sa03val >= 0.0 ? 1 : 0) != 0, (String)"Bad SA03: %s", (Object)sa03val);
                gridText.append(valDF.format(sa03val * 100.0) + " ");
                double sa10val = sa10.get(index);
                Preconditions.checkState((sa10val >= 0.0 ? 1 : 0) != 0, (String)"Bad SA10: %s", (Object)sa10val);
                gridText.append(valDF.format(sa10val * 100.0) + " ");
                if (sa30 == null) {
                    gridText.append("0.0");
                } else {
                    gridText.append(valDF.format(sa30.get(index) * 100.0));
                }
                gridText.append("\n");
            }
        }
        Element gridEl = root.addElement("grid_data");
        gridEl.addText(gridText.toString());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setTrimText(false);
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(outputFile), format);
        writer.write(doc);
        writer.close();
    }

    private static void addGridFieldEl(Element root, int index, String name, String units) {
        Element el = root.addElement("grid_field");
        el.addAttribute("index", "" + index);
        el.addAttribute("name", name);
        el.addAttribute("units", units);
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/CyberShake/caloes_shakemaps/consolidated_gmpe");
        String prefix = "palos-verdes";
        String name = "Palos Verdes Scenario";
        double mag = 7.05;
        GriddedGeoDataSet pga = GriddedGeoDataSet.loadXYZFile(new File(dir, prefix + "_pga.xyz"), true);
        GriddedGeoDataSet pgv = GriddedGeoDataSet.loadXYZFile(new File(dir, prefix + "_pgv.xyz"), true);
        GriddedGeoDataSet sa03 = GriddedGeoDataSet.loadXYZFile(new File(dir, prefix + "_0.3s.xyz"), true);
        GriddedGeoDataSet sa10 = GriddedGeoDataSet.loadXYZFile(new File(dir, prefix + "_1.0s.xyz"), true);
        GriddedGeoDataSet sa30 = GriddedGeoDataSet.loadXYZFile(new File(dir, prefix + "_3.0s.xyz"), true);
        ShakeMapXMLWriter.writeXML(new File(dir, prefix + "_grid.xml"), mag, name, prefix, pga, pgv, sa03, sa10, sa30);
    }
}

