/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.opensha.sha.calc.params.NonSupportedTRT_OptionsParam;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.util.TectonicRegionType;

public class TRTUtils {
    public static Map<TectonicRegionType, ScalarIMR> wrapInHashMap(ScalarIMR imr) {
        EnumMap<TectonicRegionType, ScalarIMR> imrMap = new EnumMap<TectonicRegionType, ScalarIMR>(TectonicRegionType.class);
        imrMap.put(TectonicRegionType.ACTIVE_SHALLOW, imr);
        return imrMap;
    }

    public static ScalarIMR getIMRforTRT(Map<TectonicRegionType, ScalarIMR> imrMap, TectonicRegionType trt) {
        if (trt == null) {
            throw new IllegalArgumentException("Tectonic Region Type cannot be null!");
        }
        ScalarIMR imr = imrMap.size() > 1 ? imrMap.get(trt) : TRTUtils.getFirstIMR(imrMap);
        return imr;
    }

    public static void setTRTinIMR(ScalarIMR imr, TectonicRegionType trt, NonSupportedTRT_OptionsParam nonSupportedTRT_OptionsParam, TectonicRegionType originalTRT) {
        TectonicRegionTypeParam trtParam = (TectonicRegionTypeParam)imr.getParameter("Tectonic Region");
        if (imr.isTectonicRegionSupported(trt.toString())) {
            trtParam.setValue(trt);
        } else if (((String)nonSupportedTRT_OptionsParam.getValue()).equals("Use IMR's default TRT value")) {
            trtParam.setValueAsDefault();
        } else {
            if (((String)nonSupportedTRT_OptionsParam.getValue()).equals("Throw runtime exception")) {
                throw new RuntimeException("Tectonic Region Type from source (" + String.valueOf(trt) + ") not supported by IMR");
            }
            if (((String)nonSupportedTRT_OptionsParam.getValue()).equals("Use TRT value already set in IMR")) {
                trtParam.setValue(originalTRT);
            }
        }
    }

    public static HashMap<ScalarIMR, TectonicRegionType> getTRTsSetInIMRs(Map<TectonicRegionType, ScalarIMR> imrMap) {
        return TRTUtils.getTRTsSetInIMR(imrMap.values());
    }

    public static HashMap<ScalarIMR, TectonicRegionType> getTRTsSetInIMR(Collection<ScalarIMR> imrs) {
        HashMap<ScalarIMR, TectonicRegionType> map = new HashMap<ScalarIMR, TectonicRegionType>();
        for (ScalarIMR imr : imrs) {
            TectonicRegionTypeParam trtParam = (TectonicRegionTypeParam)imr.getParameter("Tectonic Region");
            if (trtParam.getValue() == null) {
                trtParam.setValueAsDefault();
            }
            TectonicRegionType trt = trtParam.getValueAsTRT();
            map.put(imr, trt);
        }
        return map;
    }

    public static void resetTRTsInIMRs(Map<ScalarIMR, TectonicRegionType> trtValues) {
        for (ScalarIMR imr : trtValues.keySet()) {
            TectonicRegionTypeParam trtParam = (TectonicRegionTypeParam)imr.getParameter("Tectonic Region");
            trtParam.setValue(trtValues.get(imr));
        }
    }

    public static ScalarIMR getFirstIMR(Map<TectonicRegionType, ScalarIMR> imrMap) {
        return imrMap.values().iterator().next();
    }
}

