/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc;

import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.data.function.DiscretizedFunc;

public class EALCalculator {
    private ArrayList<Double> IML = null;
    private ArrayList<Double> DF = null;
    private ArrayList<Double> MAFE = null;
    double structValue = 0.0;

    public EALCalculator() {
    }

    public EALCalculator(ArrayList<Double> IML, ArrayList<Double> DF, ArrayList<Double> MAFE, double structValue) {
        this.IML = IML;
        this.DF = DF;
        this.MAFE = MAFE;
        this.structValue = structValue;
    }

    public EALCalculator(DiscretizedFunc hazFunc, ArrayList<Double> DF, double structValue) {
        this.IML = new ArrayList();
        this.MAFE = new ArrayList();
        this.DF = DF;
        Iterator<Double> xIter = hazFunc.getXValuesIterator();
        Iterator<Double> yIter = hazFunc.getYValuesIterator();
        while (xIter.hasNext()) {
            this.IML.add(xIter.next());
        }
        while (yIter.hasNext()) {
            this.MAFE.add(yIter.next());
        }
        this.structValue = structValue;
    }

    public EALCalculator(ArrayList<Double> MAFE, DiscretizedFunc vulnFunc, double structValue) {
        this.IML = new ArrayList();
        this.MAFE = MAFE;
        this.DF = new ArrayList();
        Iterator<Double> xIter = vulnFunc.getXValuesIterator();
        Iterator<Double> yIter = vulnFunc.getYValuesIterator();
        while (xIter.hasNext()) {
            this.IML.add(xIter.next());
        }
        while (yIter.hasNext()) {
            this.DF.add(yIter.next());
        }
        this.structValue = structValue;
    }

    public EALCalculator(DiscretizedFunc hazFunc, DiscretizedFunc vulnFunc, double structValue) throws IllegalArgumentException {
        this.IML = new ArrayList();
        this.MAFE = new ArrayList();
        this.DF = new ArrayList();
        Iterator<Double> hXIter = hazFunc.getXValuesIterator();
        Iterator<Double> hYIter = hazFunc.getYValuesIterator();
        Iterator<Double> vXIter = vulnFunc.getXValuesIterator();
        Iterator<Double> vYIter = vulnFunc.getYValuesIterator();
        while (hXIter.hasNext() && hYIter.hasNext() && vXIter.hasNext() && vYIter.hasNext()) {
            double hx = hXIter.next();
            double hy = hYIter.next();
            double vx = vXIter.next();
            double vy = vYIter.next();
            if (hx != vx) {
                throw new IllegalArgumentException("IML Values for hazFunc and vulnFunc must match!");
            }
            this.IML.add(hx);
            this.MAFE.add(hy);
            this.DF.add(vy);
        }
        this.structValue = structValue;
    }

    public static double computeEAL(ArrayList<Double> IML, ArrayList<Double> DF, ArrayList<Double> MAFE, double structValue) {
        if (IML == null || DF == null || MAFE == null) {
            throw new IllegalArgumentException("Null Values are not allowed!");
        }
        EALCalculator calc = new EALCalculator(IML, DF, MAFE, structValue);
        return calc.computeEAL();
    }

    public double computeEAL() {
        if (this.IML == null || this.DF == null || this.MAFE == null) {
            throw new IllegalStateException("IML, DF, and MAFE must all be set before computing!");
        }
        if (this.IML.size() != this.DF.size() || this.IML.size() != this.MAFE.size()) {
            throw new IllegalStateException("IML, DF, and MAFE must all be the same size for computing!");
        }
        double answer = 0.0;
        double g = 0.0;
        double a = 0.0;
        double b = 0.0;
        double holder = 0.0;
        double R = 0.0;
        double V = this.structValue;
        for (int i = 1; i < this.IML.size(); ++i) {
            double iml_cur = this.IML.get(i);
            double iml_pre = this.IML.get(i - 1);
            double iml_delta = iml_cur - iml_pre;
            double df_cur = this.DF.get(i);
            double df_pre = this.DF.get(i - 1);
            double df_delta = df_cur - df_pre;
            double mafe_cur = this.MAFE.get(i);
            double mafe_pre = this.MAFE.get(i - 1);
            g = Math.log(mafe_cur / mafe_pre) / iml_delta;
            holder = df_pre * mafe_pre * (1.0 - Math.exp(g * iml_delta));
            if (Double.isNaN(holder -= df_delta / iml_delta * mafe_pre * (Math.exp(g * iml_delta) * (iml_delta - 1.0 / g) + 1.0 / g)) || Double.isInfinite(holder)) continue;
            answer += holder;
        }
        answer *= V;
        return answer += R;
    }

    public ArrayList<Double> getDF() {
        return this.DF;
    }

    public void setDF(ArrayList<Double> df) {
        this.DF = df;
    }

    public ArrayList<Double> getIML() {
        return this.IML;
    }

    public void setIML(ArrayList<Double> iml) {
        this.IML = iml;
    }

    public ArrayList<Double> getMAFE() {
        return this.MAFE;
    }

    public void setMAFE(ArrayList<Double> pe) {
        this.MAFE = pe;
    }

    public double getStructValue() {
        return this.structValue;
    }

    public void setStructValue(double structValue) {
        this.structValue = structValue;
    }

    public void setDF(DiscretizedFunc vulnFunc) {
        this.DF.clear();
        Iterator<Double> iter = vulnFunc.getYValuesIterator();
        while (iter.hasNext()) {
            this.DF.add(iter.next());
        }
    }

    public void setMAFE(DiscretizedFunc hazFunc) {
        this.MAFE.clear();
        Iterator<Double> iter = hazFunc.getYValuesIterator();
        while (iter.hasNext()) {
            this.MAFE.add(iter.next());
        }
    }

    public static double testCalc() {
        ArrayList<Double> testIML = new ArrayList<Double>(19);
        ArrayList<Double> testDF = new ArrayList<Double>(19);
        ArrayList<Double> testMAFE = new ArrayList<Double>(19);
        double[] IMLvals = new double[]{0.005, 0.007, 0.01, 0.014, 0.019, 0.027, 0.038, 0.053, 0.074, 0.103, 0.145, 0.203, 0.284, 0.397, 0.556, 0.778, 1.09, 1.52, 2.13};
        double[] DFvals = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.75, 0.8, 0.85, 0.9, 0.95};
        double[] MAFEvals = new double[]{0.803, 0.7068, 0.588, 0.455, 0.3218, 0.2068, 0.1216, 0.06583, 0.0338, 0.01681, 0.007637, 0.003092, 0.001093, 3.557E-4, 1.121E-4, 3.314E-5, 7.738E-6, 1.207E-6, 6.705E-8};
        for (int i = 0; i < 19; ++i) {
            testIML.add(IMLvals[i]);
            testDF.add(DFvals[i]);
            testMAFE.add(MAFEvals[i]);
        }
        return EALCalculator.computeEAL(testIML, testDF, testMAFE, 1.0);
    }
}

