/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import edu.usc.kmilner.mpj.taskDispatch.PostBatchHook;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.imr.AbstractIMR;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.calc.parallel.ThreadedCondLossCalc;
import org.opensha.sra.gui.portfolioeal.Asset;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;
import org.opensha.sra.gui.portfolioeal.Portfolio;
import org.opensha.sra.vulnerability.VulnerabilityFetcher;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class MPJ_CondLossCalc
extends MPJTaskCalculator
implements CalculationExceptionHandler,
PostBatchHook {
    public static final String BATCH_ELEMENT_NAME = "BatchCalculation";
    protected List<Asset> assets;
    private double[][] my_results;
    private int numRups;
    private boolean keepTractResults = false;
    private File tractMainDir;
    private File tractNodeDir;
    private Deque<TractWriteable> tractWriteQueue;
    private ThreadedCondLossCalc calc;
    private File outputFile;
    private ERF refERF;
    private boolean gzip = false;
    private static final boolean FILE_DEBUG = false;
    private ExecutorService mergeExec;
    private Deque<MergeTask> mergeDeque;
    public static final int buffer_len = 655360;

    public MPJ_CondLossCalc(CommandLine cmd, Portfolio portfolio, Element el) throws IOException, DocumentException, InvocationTargetException {
        this(cmd, portfolio, el, null);
    }

    public MPJ_CondLossCalc(CommandLine cmd, Portfolio portfolio, Element el, File outputFile) throws IOException, DocumentException, InvocationTargetException {
        super(cmd);
        this.assets = portfolio.getAssetList();
        System.gc();
        if (outputFile == null) {
            outputFile = new File(el.attributeValue("outputFile"));
        }
        this.outputFile = outputFile;
        int numThreads = this.getNumThreads();
        if (this.rank == 0) {
            this.debug("num threads: " + numThreads);
        }
        int numERFs = cmd.hasOption("mult-erfs") ? numThreads : 1;
        this.gzip = cmd.hasOption("gzip");
        this.debug("updating ERFs");
        ERF[] erfs = new ERF[numERFs];
        for (int i = 0; i < numERFs; ++i) {
            erfs[i] = this.loadERF(el);
            erfs[i].updateForecast();
        }
        this.debug("done updating ERFs");
        this.refERF = erfs[0];
        this.my_results = new double[this.refERF.getNumSources()][];
        for (int sourceID = 0; sourceID < this.refERF.getNumSources(); ++sourceID) {
            this.my_results[sourceID] = new double[this.refERF.getNumRuptures(sourceID)];
            this.numRups += this.my_results[sourceID].length;
        }
        ScalarIMR[] imrs = new ScalarIMR[numThreads];
        for (int i = 0; i < imrs.length; ++i) {
            imrs[i] = (ScalarIMR)((Object)AbstractIMR.fromXMLMetadata(el.element("IMR"), null));
        }
        this.keepTractResults = cmd.hasOption("tract-results");
        if (this.keepTractResults) {
            this.shuffle = false;
            if (this.rank == 0 && numThreads > 60) {
                numThreads -= 2;
            }
            this.postBatchHook = this;
            String prefix = this.outputFile.getName();
            if (prefix.toLowerCase().endsWith(".bin")) {
                prefix = prefix.substring(0, prefix.lastIndexOf("."));
            }
            this.tractMainDir = new File(outputFile.getParentFile(), prefix + "_tract_results");
            if (this.rank == 0) {
                if (this.tractMainDir.exists()) {
                    for (File file : this.tractMainDir.listFiles()) {
                        if (!file.getName().endsWith(".bin") && !file.getName().endsWith(".bin.gz")) continue;
                        this.debug("Deleting old stale tract file: " + file.getName());
                        Preconditions.checkState((boolean)file.delete());
                    }
                }
                Preconditions.checkState((this.tractMainDir.exists() || this.tractMainDir.mkdir() ? 1 : 0) != 0);
            }
            this.tractNodeDir = this.getTractNodeDir(this.rank);
            this.tractWriteQueue = new LinkedList<TractWriteable>();
        }
        this.calc = new ThreadedCondLossCalc(erfs, imrs, MPJ_CondLossCalc.getDefaultMagDistFunc());
        if (cmd.hasOption("vuln-file")) {
            File vulnFile = new File(cmd.getOptionValue("vuln-file"));
            System.out.println("trying to load vulnerabilities from: " + vulnFile.getAbsolutePath());
            VulnerabilityFetcher.getVulnerabilities(vulnFile);
            System.out.println("DONE loading vulns.");
        }
    }

    public static DiscretizedFunc getDefaultMagDistFunc() {
        ArbitrarilyDiscretizedFunc magThreshFunc = new ArbitrarilyDiscretizedFunc();
        magThreshFunc.set(0.0, 0.0);
        magThreshFunc.set(60.0, 5.25);
        magThreshFunc.set(200.0, 7.25);
        magThreshFunc.set(500.0, 9.0);
        return magThreshFunc;
    }

    private File getTractNodeDir(int rank) {
        return new File(this.tractMainDir, "process_" + rank);
    }

    public static String getTractName(Asset asset) {
        return asset.getParameterList().getParameter(String.class, "AssetName").getValue().trim().replaceAll("\\W+", "_");
    }

    private ERF loadERF(Element root) throws InvocationTargetException {
        Element epistemicEl = root.element("ERF_Epistemic");
        if (epistemicEl != null) {
            return (ERF)AbstractEpistemicListERF.fromXMLMetadata(epistemicEl);
        }
        return AbstractERF.fromXMLMetadata(root.element("ERF"));
    }

    protected int getNumTasks() {
        return this.assets.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        ArrayDeque<SiteResult> deque = new ArrayDeque<SiteResult>();
        for (int index : batch) {
            deque.add(new SiteResult(index, this.assets.get(index)));
        }
        this.calc.calculateBatch(deque);
        if (this.keepTractResults) {
            while (!this.tractWriteQueue.isEmpty()) {
                TractWriteable writeable = this.tractWriteQueue.pop();
                File outFile = new File(this.tractNodeDir, writeable.name + ".bin");
                Preconditions.checkState((!outFile.exists() ? 1 : 0) != 0);
                this.debug("Writing tract info to " + outFile.getName());
                MPJ_CondLossCalc.writeResults(outFile, writeable.values);
            }
        }
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        this.debug("post calc mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void registerResult(SiteResult result) {
        double[][] vals = result.results;
        Preconditions.checkState((vals.length == this.my_results.length ? 1 : 0) != 0, (Object)("Source count discrepancy. Expected " + this.my_results.length + ", was " + vals.length));
        Object tract_vals = null;
        for (int sourceID = 0; sourceID < vals.length; ++sourceID) {
            if (vals[sourceID] == null) continue;
            if (tract_vals != null && tract_vals[sourceID] == null) {
                tract_vals[sourceID] = new double[this.my_results[sourceID].length];
            }
            for (int rupID = 0; rupID < vals[sourceID].length; ++rupID) {
                double[] dArray = this.my_results[sourceID];
                int n = rupID;
                dArray[n] = dArray[n] + vals[sourceID][rupID];
                if (tract_vals == null) continue;
                void v2 = tract_vals[sourceID];
                int n2 = rupID;
                v2[n2] = v2[n2] + vals[sourceID][rupID];
            }
        }
        if (this.keepTractResults) {
            TractWriteable writeable = new TractWriteable(MPJ_CondLossCalc.getTractName(result.asset), vals);
            int numRetries = 0;
            while (!this.tractNodeDir.exists() && !this.tractNodeDir.mkdir()) {
                if (numRetries == 5) {
                    throw new IllegalStateException("Couldn't create dir: " + this.tractNodeDir.getAbsolutePath());
                }
                this.debug("Could not create dir: " + this.tractNodeDir.getAbsolutePath() + ", retrying in 5s");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++numRetries;
            }
            Preconditions.checkState((this.tractNodeDir.exists() || this.tractNodeDir.mkdir() ? 1 : 0) != 0);
            Deque<TractWriteable> deque = this.tractWriteQueue;
            synchronized (deque) {
                boolean duplicate = false;
                for (TractWriteable other : this.tractWriteQueue) {
                    if (!other.name.equals(writeable.name)) continue;
                    other.addFrom(writeable);
                    duplicate = true;
                    break;
                }
                if (!duplicate) {
                    this.tractWriteQueue.add(writeable);
                }
            }
        }
    }

    public static void addTo(double[][] values, double[][] toBeAdded) {
        for (int i = 0; i < values.length; ++i) {
            double[] oVals = toBeAdded[i];
            if (oVals == null) continue;
            double[] vals = values[i];
            if (vals == null) {
                values[i] = oVals;
                continue;
            }
            for (int j = 0; j < vals.length; ++j) {
                int n = j;
                vals[n] = vals[n] + oVals[j];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchProcessed(int[] batch, int processIndex) {
        if (batch.length == 0) {
            return;
        }
        Preconditions.checkState((boolean)this.keepTractResults);
        HashSet<String> tracts = new HashSet<String>();
        for (int index : batch) {
            tracts.add(MPJ_CondLossCalc.getTractName(this.assets.get(index)));
        }
        if (this.mergeDeque == null) {
            this.mergeDeque = new ArrayDeque<MergeTask>();
            this.mergeExec = Executors.newSingleThreadExecutor();
        }
        long stamp = System.currentTimeMillis();
        this.debug("post-batch considation for " + tracts.size() + " census tracts (" + batch.length + " assets)");
        ArrayList myTasks = Lists.newArrayList();
        for (String tract : tracts) {
            File procTractFile = new File(this.getTractNodeDir(processIndex), tract + ".bin");
            Preconditions.checkState((boolean)procTractFile.exists());
            File procDestFile = new File(procTractFile.getAbsolutePath() + "_merge_" + stamp);
            try {
                Files.move((File)procTractFile, (File)procDestFile);
            }
            catch (IOException e1) {
                MPJ_CondLossCalc.abortAndExit((Throwable)e1);
            }
            String outName = this.gzip ? tract + ".bin.gz" : tract + ".bin";
            File globalTractFile = new File(this.tractMainDir, outName);
            myTasks.add(new MergeTask(globalTractFile, procDestFile));
        }
        Deque<MergeTask> deque = this.mergeDeque;
        synchronized (deque) {
            for (MergeTask task : myTasks) {
                boolean match = false;
                for (MergeTask existing : this.mergeDeque) {
                    if (!task.desination.equals(existing.desination)) continue;
                    existing.origins.add(task.origins.get(0));
                    match = true;
                    break;
                }
                if (match) continue;
                this.mergeDeque.add(task);
                this.mergeExec.submit(new MergeRunnable(task));
            }
        }
    }

    private double[] packResults(double[][] results) {
        double[] packed_results = new double[this.numRups];
        int cnt = 0;
        int numSources = this.refERF.getNumSources();
        for (int sourceID = 0; sourceID < numSources; ++sourceID) {
            int numRups = this.refERF.getNumRuptures(sourceID);
            double[] vals = results[sourceID];
            if (vals == null) {
                vals = new double[numRups];
            }
            for (int rupID = 0; rupID < numRups; ++rupID) {
                packed_results[cnt++] = vals[rupID];
            }
        }
        return packed_results;
    }

    private double[][] unpackResults(double[] results) {
        int numSources = this.refERF.getNumSources();
        double[][] unpacked_results = new double[numSources][];
        int cnt = 0;
        for (int sourceID = 0; sourceID < numSources; ++sourceID) {
            int numRups = this.refERF.getNumRuptures(sourceID);
            unpacked_results[sourceID] = new double[numRups];
            for (int rupID = 0; rupID < numRups; ++rupID) {
                unpacked_results[sourceID][rupID] = results[cnt++];
            }
        }
        return unpacked_results;
    }

    protected void doFinalAssembly() throws Exception {
        File outputDir = this.outputFile.getParentFile();
        String prefix = this.outputFile.getName();
        if (prefix.toLowerCase().endsWith(".bin")) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        double[][] results = this.fetchResults(this.my_results);
        if (this.rank == 0) {
            this.writeAll(outputDir, prefix, results);
            if (this.keepTractResults) {
                this.debug("Waiting on any outstanding merges: " + this.mergeDeque.size());
                while (!this.mergeDeque.isEmpty()) {
                    this.debug("Merge count: " + this.mergeDeque.size());
                    Thread.sleep(10000L);
                }
                for (int i = 0; i < this.rank; ++i) {
                    this.getTractNodeDir(i).delete();
                }
            }
        }
    }

    private double[][] fetchResults(double[][] localResults) {
        int TAG_GET_RESULTS = 1;
        double[] packed_results = this.packResults(localResults);
        int rupCount = packed_results.length;
        if (this.rank == 0) {
            double[] global_results = new double[rupCount];
            for (int source = 0; source < this.size; ++source) {
                double[] srcResults;
                if (source == this.rank) {
                    srcResults = packed_results;
                } else {
                    srcResults = new double[rupCount];
                    MPI.COMM_WORLD.Recv((Object)srcResults, 0, srcResults.length, MPI.DOUBLE, source, TAG_GET_RESULTS);
                }
                for (int i = 0; i < rupCount; ++i) {
                    int n = i;
                    global_results[n] = global_results[n] + srcResults[i];
                }
            }
            double[][] unpacked_results = this.unpackResults(global_results);
            return unpacked_results;
        }
        MPI.COMM_WORLD.Send((Object)packed_results, 0, packed_results.length, MPI.DOUBLE, 0, TAG_GET_RESULTS);
        return null;
    }

    private void writeAll(File outputDir, String prefix, double[][] results) throws IOException {
        Object suffix = ".bin";
        if (this.gzip) {
            suffix = (String)suffix + ".gz";
        }
        File outputFile = new File(outputDir, prefix + (String)suffix);
        MPJ_CondLossCalc.writeResults(outputFile, results);
        if (this.refERF instanceof FaultSystemSolutionERF) {
            double[][] fssResults = MPJ_CondLossCalc.mapResultsToFSS((FaultSystemSolutionERF)this.refERF, results);
            File fssOutputFile = new File(outputFile.getParentFile(), prefix + "_fss_index" + (String)suffix);
            MPJ_CondLossCalc.writeResults(fssOutputFile, fssResults);
            File fssGridOutputFile = new File(outputFile.getParentFile(), prefix + "_fss_gridded" + (String)suffix);
            MPJ_CondLossCalc.writeFSSGridSourcesFile((FaultSystemSolutionERF)this.refERF, results, fssGridOutputFile);
        }
    }

    public static double[][] mapResultsToFSS(FaultSystemSolutionERF erf, double[][] origResults) throws IOException {
        int numFSSRups = erf.getSolution().getRupSet().getNumRuptures();
        double[][] fssResults = new double[numFSSRups][];
        for (int r = 0; r < numFSSRups; ++r) {
            int sourceIndex = erf.getSrcIndexForFltSysRup(r);
            fssResults[r] = sourceIndex < 0 ? new double[0] : origResults[sourceIndex];
        }
        return fssResults;
    }

    private static OutputStream getOutputStream(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        if (MPJ_CondLossCalc.isGZIP(file)) {
            return new GZIPOutputStream((OutputStream)fos, 655360);
        }
        return new BufferedOutputStream(fos, 655360);
    }

    private static boolean isGZIP(File file) {
        return file.getName().toLowerCase().endsWith(".gz");
    }

    public static InputStream getInputStream(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        if (MPJ_CondLossCalc.isGZIP(file)) {
            return new GZIPInputStream((InputStream)fis, 655360);
        }
        return new BufferedInputStream(fis, 655360);
    }

    public static DiscretizedFunc[] mapResultsToGridded(FaultSystemSolutionERF erf, double[][] origResults) {
        int numSources;
        int numGridded;
        int fssSources = erf.getNumFaultSystemSources();
        if (erf.getParameter("Background Seismicity").getValue() == IncludeBackgroundOption.ONLY) {
            fssSources = 0;
        }
        if ((numGridded = (numSources = erf.getNumSources()) - fssSources) <= 0) {
            return null;
        }
        BackgroundRupType bgType = (BackgroundRupType)((Object)erf.getParameter("Treat Background Seismicity As").getValue());
        GridSourceProvider prov = erf.getSolution().getGridSourceProvider();
        DiscretizedFunc[] ret = new DiscretizedFunc[numGridded];
        for (int srcIndex = fssSources; srcIndex < erf.getNumSources(); ++srcIndex) {
            int nodeIndex = srcIndex - fssSources;
            ProbEqkSource source = erf.getSource(srcIndex);
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            double fractSS = prov.getFracStrikeSlip(nodeIndex);
            double fractReverse = prov.getFracReverse(nodeIndex);
            double fractNormal = prov.getFracNormal(nodeIndex);
            ArbitrarilyDiscretizedFunc fractTrack = new ArbitrarilyDiscretizedFunc();
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rup = source.getRupture(r);
                double rake = rup.getAveRake();
                double mag = rup.getMag();
                double fract = 0.0;
                if ((float)rake == -90.0f) {
                    fract = fractNormal;
                } else if ((float)rake == 90.0f) {
                    fract = fractReverse;
                } else if ((float)rake == 0.0f) {
                    fract = fractSS;
                } else {
                    throw new IllegalStateException("Unkown rake: " + rake);
                }
                if (bgType == BackgroundRupType.CROSSHAIR) {
                    fract *= 0.5;
                } else if (bgType == BackgroundRupType.POINT && (float)rake != 0.0f) {
                    fract *= 0.5;
                }
                double loss = origResults[srcIndex] == null ? 0.0 : fract * origResults[srcIndex][r];
                int ind = func.getXIndex(mag);
                if (ind >= 0) {
                    func.set(ind, func.getY(ind) + loss);
                    fractTrack.set(ind, fractTrack.getY(ind) + fract);
                    continue;
                }
                func.set(mag, loss);
                fractTrack.set(mag, fract);
            }
            for (int i = 0; i < fractTrack.size(); ++i) {
                double diff = Math.abs(fractTrack.getY(i) - 1.0);
                Preconditions.checkState((diff <= 0.001 ? 1 : 0) != 0, (Object)("Fract for mag " + fractTrack.getX(i) + " != 1: " + (float)fractTrack.getY(i)));
            }
            ret[nodeIndex] = func;
        }
        return ret;
    }

    public static void writeFSSGridSourcesFile(FaultSystemSolutionERF erf, double[][] origResults, File file) throws IOException {
        int numSources;
        int numGridded;
        DiscretizedFunc[] griddedResults = MPJ_CondLossCalc.mapResultsToGridded(erf, origResults);
        if (griddedResults == null) {
            return;
        }
        int fssSources = erf.getNumFaultSystemSources();
        if (erf.getParameter("Background Seismicity").getValue() == IncludeBackgroundOption.ONLY) {
            fssSources = 0;
        }
        Preconditions.checkState(((numGridded = (numSources = erf.getNumSources()) - fssSources) == griddedResults.length ? 1 : 0) != 0);
        GridSourceProvider prov = erf.getSolution().getGridSourceProvider();
        DataOutputStream out = new DataOutputStream(MPJ_CondLossCalc.getOutputStream(file));
        out.writeInt(griddedResults.length);
        for (int srcIndex = fssSources; srcIndex < erf.getNumSources(); ++srcIndex) {
            int nodeIndex = srcIndex - fssSources;
            Location loc = prov.getLocation(nodeIndex);
            out.writeDouble(loc.getLatitude());
            out.writeDouble(loc.getLongitude());
            out.writeInt(griddedResults[nodeIndex].size());
            for (int i = 0; i < griddedResults[nodeIndex].size(); ++i) {
                out.writeDouble(griddedResults[nodeIndex].getX(i));
                out.writeDouble(griddedResults[nodeIndex].getY(i));
            }
        }
        out.close();
    }

    public static DiscretizedFunc[] loadGridSourcesFile(File file, GriddedRegion region) throws IOException {
        InputStream is = MPJ_CondLossCalc.getInputStream(file);
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        DataInputStream in = new DataInputStream(is);
        int numGridded = in.readInt();
        Preconditions.checkState((numGridded > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        Preconditions.checkState((region == null || region.getNodeCount() == numGridded ? 1 : 0) != 0, (Object)"Gridded location count doesn't match passed in region.");
        DiscretizedFunc[] results = new DiscretizedFunc[numGridded];
        for (int node = 0; node < numGridded; ++node) {
            int numRups;
            double lat = in.readDouble();
            double lon = in.readDouble();
            if (region != null) {
                Preconditions.checkState((boolean)region.locationForIndex(node).equals(new Location(lat, lon)));
            }
            if ((numRups = in.readInt()) == 0) continue;
            double[] mags = new double[numRups];
            double[] losses = new double[numRups];
            for (int rupID = 0; rupID < numRups; ++rupID) {
                mags[rupID] = in.readDouble();
                losses[rupID] = in.readDouble();
            }
            results[node] = new LightFixedXFunc(mags, losses);
        }
        in.close();
        return results;
    }

    public static void writeResults(File file, double[][] results) throws IOException {
        DataOutputStream out = new DataOutputStream(MPJ_CondLossCalc.getOutputStream(file));
        int numSources = results.length;
        out.writeInt(numSources);
        for (int sourceID = 0; sourceID < numSources; ++sourceID) {
            if (results[sourceID] == null) {
                out.writeInt(-1);
                continue;
            }
            int numRups = results[sourceID].length;
            out.writeInt(numRups);
            for (int rupID = 0; rupID < numRups; ++rupID) {
                out.writeDouble(results[sourceID][rupID]);
            }
        }
        out.close();
    }

    public static double[][] loadResults(File file) throws IOException {
        InputStream is = MPJ_CondLossCalc.getInputStream(file);
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        DataInputStream in = new DataInputStream(is);
        int numSources = in.readInt();
        Preconditions.checkState((numSources > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        double[][] results = new double[numSources][];
        for (int sourceID = 0; sourceID < numSources; ++sourceID) {
            int numRups = in.readInt();
            if (numRups == -1) {
                results[sourceID] = null;
                continue;
            }
            results[sourceID] = new double[numRups];
            for (int rupID = 0; rupID < numRups; ++rupID) {
                results[sourceID][rupID] = in.readDouble();
            }
        }
        in.close();
        return results;
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        Option vulnOp = new Option("v", "vuln-file", true, "VUL06 file");
        vulnOp.setRequired(false);
        ops.addOption(vulnOp);
        Option erfOp = new Option("e", "mult-erfs", false, "If set, a copy of the ERF will be instantiated for each thread.");
        erfOp.setRequired(false);
        ops.addOption(erfOp);
        Option tractOp = new Option("tract", "tract-results", false, "If set, results are stored for each census tract");
        tractOp.setRequired(false);
        ops.addOption(tractOp);
        Option gzipOp = new Option("gz", "gzip", false, "If set, results gzipped");
        gzipOp.setRequired(false);
        ops.addOption(gzipOp);
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        args = MPJTaskCalculator.initMPJ((String[])args);
        try {
            Options options = MPJ_CondLossCalc.createOptions();
            CommandLine cmd = MPJ_CondLossCalc.parse((Options)options, (String[])args, MPJ_CondLossCalc.class);
            args = cmd.getArgs();
            if (args.length < 2 || args.length > 3) {
                System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(MPJ_CondLossCalc.class) + " [options] <portfolio_file> <calculation_params_file> [<output_file>]");
                MPJ_CondLossCalc.abortAndExit((int)2);
            }
            Portfolio portfolio = Portfolio.createPortfolio(new File(args[0]));
            Document doc = XMLUtils.loadDocument(new File(args[1]));
            Element root = doc.getRootElement();
            if (args.length == 2) {
                Iterator it = root.elementIterator(BATCH_ELEMENT_NAME);
                while (it.hasNext()) {
                    MPJ_CondLossCalc driver = new MPJ_CondLossCalc(cmd, portfolio, (Element)it.next());
                    driver.run();
                }
            } else {
                File outputFile = new File(args[2]);
                MPJ_CondLossCalc driver = new MPJ_CondLossCalc(cmd, portfolio, root, outputFile);
                driver.run();
            }
            MPJ_CondLossCalc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_CondLossCalc.abortAndExit((Throwable)t);
        }
    }

    @Override
    public void calculationException(String errorMessage) {
        MPJ_CondLossCalc.abortAndExit((Throwable)new RuntimeException(errorMessage));
    }

    public class SiteResult
    implements Serializable,
    Comparable<SiteResult> {
        private int index;
        private transient Asset asset;
        private double[][] results;

        public SiteResult(int index, Asset asset) {
            this.index = index;
            this.asset = asset;
        }

        void calculate(ERF erf, ScalarIMR imr, Site initialSite, DiscretizedFunc magThreshFunc) {
            try {
                this.results = this.asset.calculateExpectedLossPerRup(imr, Double.NaN, magThreshFunc, initialSite, erf, MPJ_CondLossCalc.this);
                MPJ_CondLossCalc.this.registerResult(this);
            }
            catch (Exception e) {
                MPJTaskCalculator.abortAndExit((Throwable)e);
            }
        }

        @Override
        public int compareTo(SiteResult o) {
            return Integer.valueOf(this.index).compareTo(o.index);
        }
    }

    private class TractWriteable {
        private String name;
        private double[][] values;

        public TractWriteable(String name, double[][] values) {
            this.name = name;
            this.values = values;
        }

        public void addFrom(TractWriteable o) {
            this.add(o.values);
        }

        public void add(double[][] otherValues) {
            MPJ_CondLossCalc.addTo(this.values, otherValues);
        }
    }

    private class MergeTask {
        private File desination;
        private List<File> origins;

        public MergeTask(File destination, File origin) {
            this.desination = destination;
            this.origins = Lists.newArrayList((Object[])new File[]{origin});
        }
    }

    private class MergeRunnable
    implements Runnable {
        private MergeTask task;

        public MergeRunnable(MergeTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Deque<MergeTask> deque = MPJ_CondLossCalc.this.mergeDeque;
                synchronized (deque) {
                    Preconditions.checkState((boolean)MPJ_CondLossCalc.this.mergeDeque.remove(this.task), (Object)"MergeRunnable: task wasn't in deque");
                }
                MPJ_CondLossCalc.this.debug("Merging " + this.task.origins.size() + " files to " + this.task.desination.getName() + " (exists? " + this.task.desination.exists() + "). Queued merges: " + MPJ_CondLossCalc.this.mergeDeque.size());
                Preconditions.checkState((!this.task.origins.isEmpty() ? 1 : 0) != 0);
                if (!this.task.desination.exists()) {
                    Files.move((File)this.task.origins.remove(0), (File)this.task.desination);
                    if (this.task.origins.isEmpty()) {
                        return;
                    }
                }
                double[][] results = MPJ_CondLossCalc.loadResults(this.task.desination);
                for (File origin : this.task.origins) {
                    double[][] subResults = MPJ_CondLossCalc.loadResults(origin);
                    Preconditions.checkState((boolean)origin.delete());
                    if (results == null) {
                        results = subResults;
                        continue;
                    }
                    MPJ_CondLossCalc.addTo(results, subResults);
                }
                MPJ_CondLossCalc.writeResults(this.task.desination, results);
            }
            catch (Exception e) {
                MPJTaskCalculator.abortAndExit((Throwable)e);
            }
        }
    }
}

