/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.portfolioLEC;

import java.util.ArrayList;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sra.asset.Asset;
import org.opensha.sra.asset.Portfolio;
import org.opensha.sra.calc.portfolioLEC.AbstractPortfolioLECCalculator;
import org.opensha.sra.calc.portfolioLEC.AssetRuptureResult;
import org.opensha.sra.calc.portfolioLEC.PortfolioRuptureResults;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;

public class MomentMatchingPortfolioLECCalculator
extends AbstractPortfolioLECCalculator {
    @Override
    protected DiscretizedFunc[][] calcRuptureLECs(ScalarIMR imr, ERF erf, Portfolio portfolio, DiscretizedFunc function) {
        PortfolioRuptureResults[][] rupResults = this.calcRuptureResults(imr, erf, portfolio, function);
        return MomentMatchingPortfolioLECCalculator.RupResultsToFuncArray(rupResults);
    }

    protected static DiscretizedFunc[][] RupResultsToFuncArray(PortfolioRuptureResults[][] rupResults) {
        DiscretizedFunc[][] funcs = new DiscretizedFunc[rupResults.length][];
        for (int sourceID = 0; sourceID < rupResults.length; ++sourceID) {
            funcs[sourceID] = new DiscretizedFunc[rupResults[sourceID].length];
            for (int rupID = 0; rupID < rupResults[sourceID].length; ++rupID) {
                funcs[sourceID][rupID] = rupResults[sourceID][rupID].getExceedanceProbs();
            }
        }
        return funcs;
    }

    protected PortfolioRuptureResults[][] calcRuptureResults(ScalarIMR imr, ERF erf, Portfolio portfolio, DiscretizedFunc function) {
        int n = portfolio.size();
        double[] mValue = new double[n];
        double[] betaVJs = new double[n];
        double[] medValue = new double[n];
        double[] hValue = new double[n];
        double[] lValue = new double[n];
        double w0 = 1.0 - (6.0 + 4.0 * (double)portfolio.size()) / 8.0;
        double wi = 0.125;
        this.populateValues(portfolio, mValue, betaVJs, medValue, hValue, lValue);
        PortfolioRuptureResults[][] rupResults = new PortfolioRuptureResults[erf.getNumSources()][];
        NormalDistribution normDist = new NormalDistribution();
        for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
            Boolean[] sourceIncludes = new Boolean[n];
            ProbEqkSource src = erf.getSource(sourceID);
            rupResults[sourceID] = new PortfolioRuptureResults[src.getNumRuptures()];
            for (int rupID = 0; rupID < src.getNumRuptures(); ++rupID) {
                PortfolioRuptureResults rupResult;
                int i;
                ArrayList<AssetRuptureResult> assetRupResults = new ArrayList<AssetRuptureResult>();
                for (int k = 0; k < portfolio.size(); ++k) {
                    Asset asset = (Asset)portfolio.get(k);
                    if (sourceIncludes[k] == null) {
                        double dist = src.getMinDistance(asset.getSite());
                        sourceIncludes[k] = dist < this.getMaxSiteSourceDistance();
                    }
                    if (!sourceIncludes[k].booleanValue()) {
                        assetRupResults.add(null);
                        continue;
                    }
                    Vulnerability vuln = asset.getVulnerability();
                    String imt = vuln.getIMT();
                    imr.setIntensityMeasure(imt);
                    if (imt.equals("SA")) {
                        SA_Param.setPeriodInSA_Param(imr.getIntensityMeasure(), vuln.getPeriod());
                    }
                    imr.setIntensityMeasure(imt);
                    if (imt.equals("SA")) {
                        SA_Param.setPeriodInSA_Param(imr.getIntensityMeasure(), vuln.getPeriod());
                    }
                    imr.setSite(asset.getSite());
                    imr.setEqkRupture(src.getRupture(rupID));
                    AbstractPortfolioLECCalculator.ShakingResult imrResult = this.calcShaking(imr);
                    double mDamage_medIML = vuln.getMeanDamageFactor(imrResult.medIML);
                    AbstractDiscretizedFunc covFunc = ((SimpleVulnerability)vuln).getCOVFunction();
                    double deltaJ_medIML = covFunc.getInterpolatedY(imrResult.medIML);
                    double medDamage_medIML = mDamage_medIML / Math.sqrt(1.0 + deltaJ_medIML * deltaJ_medIML);
                    double hDamage_medIML = vuln.getMeanDamageAtExceedProb(imrResult.medIML, 0.086);
                    double lDamage_medIML = vuln.getMeanDamageAtExceedProb(imrResult.medIML, 0.914);
                    double interVal = 1.932 * imrResult.interSTD;
                    double imlHighInter = imrResult.medIML * Math.exp(interVal);
                    double imlLowInter = imrResult.medIML * Math.exp(-1.0 * interVal);
                    double mDamage_hInter = vuln.getMeanDamageFactor(imlHighInter);
                    double mDamage_lInter = vuln.getMeanDamageFactor(imlLowInter);
                    double deltaJ_imlHighInter = covFunc.getInterpolatedY(imlHighInter);
                    double deltaJ_imlLowInter = covFunc.getInterpolatedY(imlLowInter);
                    double medDamage_hInter = mDamage_hInter / Math.sqrt(1.0 + deltaJ_imlHighInter * deltaJ_imlHighInter);
                    double medDamage_lInter = mDamage_lInter / Math.sqrt(1.0 + deltaJ_imlLowInter * deltaJ_imlLowInter);
                    double intraVal = 1.932 * imrResult.intraSTD;
                    double imlHighIntra = imrResult.medIML * Math.exp(intraVal);
                    double imlLowIntra = imrResult.medIML * Math.exp(-1.0 * intraVal);
                    double mDamage_hIntra = vuln.getMeanDamageFactor(imlHighIntra);
                    double mDamage_lIntra = vuln.getMeanDamageFactor(imlLowIntra);
                    double deltaJ_imlHighIntra = covFunc.getInterpolatedY(imlHighIntra);
                    double deltaJ_imlLowIntra = covFunc.getInterpolatedY(imlLowIntra);
                    double medDamage_hIntra = mDamage_hIntra / Math.sqrt(1.0 + deltaJ_imlHighIntra * deltaJ_imlHighIntra);
                    double medDamage_lIntra = mDamage_lIntra / Math.sqrt(1.0 + deltaJ_imlLowIntra * deltaJ_imlLowIntra);
                    AssetRuptureResult assetRupResult = new AssetRuptureResult(imrResult.medIML, imrResult.mLnIML, imrResult.interSTD, imrResult.intraSTD, mDamage_medIML, deltaJ_medIML, medDamage_medIML, hDamage_medIML, lDamage_medIML, imrResult.medIML, imlHighInter, imlLowInter, mDamage_hInter, mDamage_lInter, deltaJ_imlHighInter, deltaJ_imlLowInter, medDamage_hInter, medDamage_lInter, imlHighIntra, imlLowIntra, mDamage_hIntra, mDamage_lIntra, deltaJ_imlHighIntra, deltaJ_imlLowIntra, medDamage_hIntra, medDamage_lIntra, mValue[k], betaVJs[k], medValue[k], hValue[k], lValue[k]);
                    assetRupResults.add(assetRupResult);
                }
                int numSamples = 7;
                double[][] l_indv = new double[portfolio.size()][numSamples];
                double[][] lSquared_indv = new double[portfolio.size()][numSamples];
                double[] l = new double[numSamples];
                double[] lSquared = new double[numSamples];
                for (i = 0; i < numSamples; ++i) {
                    l[i] = 0.0;
                    lSquared[i] = 0.0;
                }
                for (i = 0; i < portfolio.size(); ++i) {
                    double tempVal;
                    AssetRuptureResult assetRupResult = (AssetRuptureResult)assetRupResults.get(i);
                    if (assetRupResult == null) continue;
                    l_indv[i][0] = tempVal = medValue[i] * assetRupResult.getMedDamage_medIML();
                    l[0] = l[0] + tempVal;
                    lSquared[0] = lSquared[0] + tempVal * tempVal;
                    l_indv[i][1] = tempVal = medValue[i] * assetRupResult.getMedDamage_hInter();
                    l[1] = l[1] + tempVal;
                    lSquared[1] = lSquared[1] + tempVal * tempVal;
                    l_indv[i][2] = tempVal = medValue[i] * assetRupResult.getMedDamage_lInter();
                    l[2] = l[2] + tempVal;
                    lSquared[2] = lSquared[2] + tempVal * tempVal;
                    l_indv[i][3] = tempVal = hValue[i] * assetRupResult.getMedDamage_medIML();
                    l[3] = l[3] + tempVal;
                    lSquared[3] = lSquared[3] + tempVal * tempVal;
                    l_indv[i][4] = tempVal = lValue[i] * assetRupResult.getMedDamage_medIML();
                    l[4] = l[4] + tempVal;
                    lSquared[4] = lSquared[4] + tempVal * tempVal;
                    l_indv[i][5] = tempVal = medValue[i] * assetRupResult.getHDamage_medIML();
                    l[5] = l[5] + tempVal;
                    lSquared[5] = lSquared[5] + tempVal * tempVal;
                    l_indv[i][6] = tempVal = medValue[i] * assetRupResult.getLDamage_medIML();
                    l[6] = l[6] + tempVal;
                    lSquared[6] = lSquared[6] + tempVal * tempVal;
                }
                double sumReg = 0.0;
                double sumSquares = 0.0;
                for (int i2 = 0; i2 < portfolio.size(); ++i2) {
                    AssetRuptureResult assetRupResult = (AssetRuptureResult)assetRupResults.get(i2);
                    if (assetRupResult == null) continue;
                    double medDamage_mIML = assetRupResult.getMedDamage_medIML();
                    double medDamage_hIntra = assetRupResult.getMedDamage_hIntra();
                    double medDamage_lIntra = assetRupResult.getMedDamage_lIntra();
                    sumReg += medValue[i2] * (medDamage_hIntra + medDamage_lIntra);
                    sumSquares += Math.pow(medValue[i2] * medDamage_hIntra, 2.0) + Math.pow(medValue[i2] * medDamage_lIntra, 2.0);
                }
                double e_LgivenS = w0 * l[0] + wi * (l[1] + l[2] + l[3] + l[4] + 2.0 * l[5] + 2.0 * l[6] + (double)(4 * portfolio.size() - 4) * l[0] + sumReg);
                double e_LSuqaredGivenS = w0 * lSquared[0] + wi * (lSquared[1] + lSquared[2] + lSquared[3] + lSquared[4] + 2.0 * lSquared[5] + 2.0 * lSquared[6] + (double)(4 * portfolio.size() - 4) * lSquared[0] + sumSquares);
                double varLgivenS = e_LSuqaredGivenS - e_LgivenS * e_LgivenS;
                double deltaSquaredSubLgivenS = varLgivenS / (e_LgivenS * e_LgivenS);
                double thetaSubLgivenS = e_LgivenS / Math.sqrt(1.0 + deltaSquaredSubLgivenS);
                double betaSubLgivenS = Math.sqrt(Math.log(1.0 + deltaSquaredSubLgivenS));
                double sumMeanValues = 0.0;
                for (int i3 = 0; i3 < portfolio.size(); ++i3) {
                    sumMeanValues += mValue[i3];
                }
                ArbDiscrEmpiricalDistFunc distFunc = new ArbDiscrEmpiricalDistFunc();
                for (int k = 0; k < function.size(); ++k) {
                    double x = function.getX(k);
                    double inside = Math.log(x * sumMeanValues / thetaSubLgivenS) / betaSubLgivenS;
                    distFunc.set(x, inside);
                }
                ArbitrarilyDiscretizedFunc exceedanceProbs = new ArbitrarilyDiscretizedFunc();
                for (int k = 0; k < distFunc.size(); ++k) {
                    double x = distFunc.getX(k);
                    double y = distFunc.getY(k);
                    double val = normDist.cumulativeProbability(y);
                    exceedanceProbs.set(x, 1.0 - val);
                }
                rupResults[sourceID][rupID] = rupResult = new PortfolioRuptureResults(assetRupResults, l, lSquared, l_indv, exceedanceProbs, w0, wi, e_LgivenS, e_LSuqaredGivenS, varLgivenS, deltaSquaredSubLgivenS, thetaSubLgivenS, betaSubLgivenS);
            }
        }
        return rupResults;
    }

    private static String getArrayStr(double[] array) {
        Object str = null;
        for (double val : array) {
            str = str == null ? "" : (String)str + ",";
            str = (String)str + val;
        }
        return str;
    }
}

