/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.components;

import java.util.EventListener;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sra.gui.components.GuiBeanAPI;
import org.opensha.sra.gui.components.VulnerabilityBean;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class StructureDescriptorBean
implements GuiBeanAPI {
    private ParameterListEditor applicationEditor = null;
    private DoubleParameter replaceCost = null;
    private VulnerabilityBean vulnBean = null;
    private String descriptorName = "";
    private double replaceVal = 0.0;
    private EventListener listener = null;
    private static final String REPLACE_PARAM = "Replacement Cost";

    public StructureDescriptorBean(List<AbstractVulnerability> vulns) {
        this("", vulns);
    }

    public StructureDescriptorBean(String name, List<AbstractVulnerability> vulns) {
        this.descriptorName = name;
        this.vulnBean = new VulnerabilityBean(vulns);
        this.listener = new StructureDescriptorParameterListener();
        this.replaceCost = new DoubleParameter(REPLACE_PARAM, 0.0, 1.0E11, "$$$");
        this.replaceCost.setInfo("The cost to replace the facility excluding land and demolition");
        this.replaceCost.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.replaceCost.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
    }

    public VulnerabilityBean getVulnerabilityBean() {
        return this.vulnBean;
    }

    public AbstractVulnerability getVulnerabilityModel() {
        return this.vulnBean.getCurrentModel();
    }

    public double getReplaceCost() {
        return this.replaceVal;
    }

    @Override
    public Object getVisualization(int type) {
        if (!this.isVisualizationSupported(type)) {
            throw new IllegalArgumentException("Only the Application type is supported at this time.");
        }
        if (type == 0) {
            return this.getApplicationVisualization();
        }
        return null;
    }

    @Override
    public String getVisualizationClassName(int type) {
        String cname = null;
        if (type == 0) {
            cname = "org.opensha.commons.param.editor.ParameterListEditor";
        }
        return cname;
    }

    @Override
    public boolean isVisualizationSupported(int type) {
        return type == 0;
    }

    private ParameterListEditor getApplicationVisualization() {
        if (this.applicationEditor == null) {
            ParameterList plist = new ParameterList();
            plist.addParameterList(this.vulnBean.getDisplayParameters());
            plist.addParameter(this.replaceCost);
            this.applicationEditor = new ParameterListEditor(plist);
            this.applicationEditor.setTitle(this.descriptorName);
        }
        return this.applicationEditor;
    }

    private void handleReplaceCostChange(ParameterChangeEvent event) {
        this.replaceVal = (Double)event.getNewValue();
    }

    private class StructureDescriptorParameterListener
    implements ParameterChangeListener,
    ParameterChangeFailListener {
        private StructureDescriptorParameterListener() {
        }

        @Override
        public void parameterChange(ParameterChangeEvent event) {
            if (StructureDescriptorBean.REPLACE_PARAM.equals(event.getParameterName())) {
                StructureDescriptorBean.this.handleReplaceCostChange(event);
            }
        }

        @Override
        public void parameterChangeFailed(ParameterChangeFailEvent event) {
            JOptionPane.showMessageDialog(null, "The given value of " + String.valueOf(event.getBadValue()) + " is out of range.", "Failed to Change Value", 0);
        }
    }
}

