/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.controls.SetMinSourceSiteDistanceControlPanel;
import org.opensha.sha.gui.controls.SetSiteParamsFromWebServicesControlPanel;
import org.opensha.sra.gui.portfolioeal.gui.ERFPanel;
import org.opensha.sra.gui.portfolioeal.gui.IMRPanel;
import org.opensha.sra.gui.portfolioeal.gui.SitePanel;

public class PortfolioEALCalculatorView
extends JFrame {
    private static final long serialVersionUID = -6117101906743764287L;
    private static PortfolioEALCalculatorView view;
    private final int WIDTH = 1100;
    private final int HEIGHT = 780;
    private ERFPanel erf;
    private IMRPanel imr;
    private SitePanel site;
    private JTextArea IO;
    private JScrollPane IOContainer;
    private JTabbedPane tabbedPane;
    private JPanel bottomPane;
    private SetMinSourceSiteDistanceControlPanel distanceControlPanel;
    private SetSiteParamsFromWebServicesControlPanel cvmControlPanel;
    private Site_GuiBean siteBean = new Site_GuiBean();
    private JTextField portfolioField;
    private JButton computeButton;
    private JButton cancelButton;
    private JButton clearButton;
    private boolean progressBarChecked = false;
    private ArrayList<JComponent> componentList = new ArrayList();
    public static final boolean CHECKED_YES = true;
    public static final boolean CHECKED_NO = false;

    private PortfolioEALCalculatorView(String name) {
        super(name);
        this.erf = new ERFPanel();
        this.imr = new IMRPanel();
        this.site = new SitePanel(this.imr.getIMRBean().getSelectedIMR_Instance());
        this.distanceControlPanel = new SetMinSourceSiteDistanceControlPanel(this.getContentPane());
        this.setupIOPane();
        this.setupTabs();
        this.setupBottomPane();
        this.setupLayout(this.getContentPane());
        this.setSize(1100, 780);
    }

    public static boolean isViewInitialized() {
        return view != null;
    }

    public static PortfolioEALCalculatorView getView() {
        if (view == null) {
            view = new PortfolioEALCalculatorView("Portfolio EAL Calculator");
        }
        return view;
    }

    private void setupLayout(Container contentPane) {
        JSplitPane mainSplitPane = new JSplitPane(0);
        mainSplitPane.setDividerLocation(585);
        JSplitPane topPane = new JSplitPane(1, this.IOContainer, this.tabbedPane);
        topPane.setDividerLocation(580);
        mainSplitPane.setTopComponent(topPane);
        mainSplitPane.setBottomComponent(this.bottomPane);
        contentPane.add(mainSplitPane);
    }

    private void setupTabs() {
        this.tabbedPane = new JTabbedPane(1);
        JPanel portfolioSelectionTab = new JPanel();
        portfolioSelectionTab.setLayout(new GridBagLayout());
        this.portfolioField = new JTextField("Enter Portfolio URL");
        this.portfolioField.setPreferredSize(new Dimension(250, 22));
        this.portfolioField.setEditable(false);
        this.portfolioField.setBackground(Color.WHITE);
        JButton portfolioOpenButton = new JButton("Open Portfolio");
        this.componentList.add(portfolioOpenButton);
        portfolioSelectionTab.add(this.portfolioField);
        portfolioSelectionTab.add(portfolioOpenButton);
        JSplitPane optionsTab = new JSplitPane(1);
        JSplitPane imrSitePane = new JSplitPane(0);
        imrSitePane.add(this.imr.getPanel());
        imrSitePane.add(this.site.getPanel());
        imrSitePane.setDividerLocation(282);
        optionsTab.add(imrSitePane);
        optionsTab.add(this.erf.getPanel());
        optionsTab.setDividerLocation(248);
        this.tabbedPane.add((Component)portfolioSelectionTab, "Portfolio and Vulnerability");
        this.tabbedPane.add((Component)optionsTab, "Set Hazard Curve");
    }

    private void setupIOPane() {
        this.IO = new JTextArea();
        this.IOContainer = new JScrollPane();
        this.IOContainer.setHorizontalScrollBarPolicy(30);
        this.IOContainer.setVerticalScrollBarPolicy(20);
        this.IOContainer.setBorder(BorderFactory.createEtchedBorder());
        this.IO.setEditable(false);
        this.IO.setLineWrap(true);
        this.IO.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
        this.IOContainer.getViewport().add(this.IO);
    }

    private void setupBottomPane() {
        this.bottomPane = new JPanel();
        String[] array = new String[]{"Control Panels", "Max site-source distance", "Portfolios of interest", "Set Site Params from Web Services"};
        JComboBox<String> controlPanels = new JComboBox<String>(array);
        this.computeButton = new JButton("Compute");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setVisible(false);
        this.clearButton = new JButton("Clear Results");
        JCheckBox progressCheckBox = new JCheckBox("Show Progress Bar");
        this.componentList.add(controlPanels);
        this.componentList.add(this.computeButton);
        this.componentList.add(this.cancelButton);
        this.componentList.add(this.clearButton);
        this.componentList.add(progressCheckBox);
        this.bottomPane.add(controlPanels);
        this.bottomPane.add(this.computeButton);
        this.bottomPane.add(this.cancelButton);
        this.bottomPane.add(this.clearButton);
        this.bottomPane.add(progressCheckBox);
    }

    public IMRPanel getIMR() {
        return this.imr;
    }

    public ERFPanel getERF() {
        return this.erf;
    }

    public SitePanel getSite() {
        return this.site;
    }

    public SetMinSourceSiteDistanceControlPanel getDistanceControlPanel() {
        return this.distanceControlPanel;
    }

    public boolean getProgressBarChecked() {
        return this.progressBarChecked;
    }

    public void setProgressBarChecked(boolean checked) {
        this.progressBarChecked = checked;
    }

    public void setIO(String text) {
        this.IO.setText(text);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JScrollBar bar = this.IOContainer.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
    }

    public void registerUI(EventListener listener) {
        for (JComponent component : this.componentList) {
            if (component.getClass().toString().equals("class javax.swing.JButton")) {
                ((JButton)component).addActionListener((ActionListener)listener);
                continue;
            }
            if (component.getClass().toString().equals("class javax.swing.JComboBox")) {
                ((JComboBox)component).addActionListener((ActionListener)listener);
                continue;
            }
            if (!component.getClass().toString().equals("class javax.swing.JCheckBox")) continue;
            ((JCheckBox)component).addItemListener((ItemListener)listener);
        }
    }

    public void comboBoxSelection(String selection) {
        if (selection.equals("Max site-source distance")) {
            this.initDistanceControl();
        }
        if (selection.equals("Set Site Params from Web Services")) {
            this.initCVMControl();
        }
        if (selection.equals("Portfolios of interest")) {
            System.out.println("Portfolios of interest");
        }
    }

    public void setButtonsOnCompute() {
        this.cancelButton.setVisible(true);
        this.computeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    public void setButtonsOnCancel() {
        this.cancelButton.setVisible(false);
        this.computeButton.setEnabled(true);
        this.clearButton.setEnabled(true);
    }

    public void setPortfolioField(String fileName) {
        this.portfolioField.setText(fileName);
    }

    private void initDistanceControl() {
        SetMinSourceSiteDistanceControlPanel distanceControlPanel = new SetMinSourceSiteDistanceControlPanel(this.getGlassPane());
        distanceControlPanel.pack();
        distanceControlPanel.setVisible(true);
    }

    private void initCVMControl() {
        this.cvmControlPanel = new SetSiteParamsFromWebServicesControlPanel(this.getContentPane(), this.imr.getIMRBean(), this.siteBean);
        this.cvmControlPanel.pack();
        this.cvmControlPanel.setVisible(true);
    }
}

