/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.vulnerability.models;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;

public class VulnFileReader {
    public static ArrayList<SimpleVulnerability> readVUL06File(InputStream fileInput) throws IOException {
        SimpleVulnerability vuln;
        double period;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(fileInput));
        String line = in.readLine();
        String abbr = null;
        String displayName = null;
        String imt = null;
        String curVulnID = null;
        ArrayList<Double> curIMLVals = new ArrayList<Double>();
        ArrayList<Double> curMDFVals = new ArrayList<Double>();
        ArrayList<Double> curCOVFunc = new ArrayList<Double>();
        ArrayList<SimpleVulnerability> vulns = new ArrayList<SimpleVulnerability>();
        while (line != null) {
            if (in.getLineNumber() < 3) {
                line = in.readLine();
                continue;
            }
            if (line.trim().length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line, ",");
            tok.nextToken();
            String vulnID = tok.nextToken();
            if (curVulnID == null) {
                curVulnID = vulnID;
            } else if (!curVulnID.equals(vulnID)) {
                period = 0.0;
                if (imt.startsWith("SA") && imt.length() > 2) {
                    period = Double.parseDouble(imt.substring(2)) / 10.0;
                    imt = imt.substring(0, 2);
                }
                vuln = new SimpleVulnerability(displayName, abbr, imt, curIMLVals, curMDFVals, curCOVFunc);
                vuln.setPeriod(period);
                vulns.add(vuln);
                curIMLVals = new ArrayList();
                curMDFVals = new ArrayList();
                curCOVFunc = new ArrayList();
                curVulnID = vulnID;
            }
            abbr = tok.nextToken();
            displayName = tok.nextToken();
            if (displayName.length() == 0 || displayName.equals("*")) {
                displayName = abbr;
            }
            String height = tok.nextToken();
            String matCat = tok.nextToken();
            String lfrs = tok.nextToken();
            String dl = tok.nextToken();
            String occ = tok.nextToken();
            String lossType = tok.nextToken();
            imt = tok.nextToken();
            double iml = Double.parseDouble(tok.nextToken());
            if (curIMLVals.contains(iml)) {
                throw new IllegalStateException("Duplicate IMLs found for vuln " + vulnID + ", " + abbr + ". IML: " + iml);
            }
            curIMLVals.add(iml);
            curMDFVals.add(Double.parseDouble(tok.nextToken()));
            curCOVFunc.add(Double.parseDouble(tok.nextToken()));
            line = in.readLine();
        }
        if (curIMLVals.size() > 0) {
            period = 0.0;
            if (imt.startsWith("SA") && imt.length() > 2) {
                period = Double.parseDouble(imt.substring(2)) / 10.0;
                imt = imt.substring(0, 2);
            }
            vuln = new SimpleVulnerability(displayName, abbr, imt, curIMLVals, curMDFVals, curCOVFunc);
            vuln.setPeriod(period);
            vulns.add(vuln);
        }
        return vulns;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream file = new FileInputStream("/home/kevin/OpenSHA/portfolio_lec/2014_05_16b_VUL06.txt");
        long start = System.currentTimeMillis();
        ArrayList<SimpleVulnerability> vulns = VulnFileReader.readVUL06File(file);
        long end = System.currentTimeMillis();
        System.out.println("total time: " + (double)(end - start) / 1000.0 + " secs");
        System.out.println("vulns: " + vulns.size());
        for (int i = 0; i < 3; ++i) {
            Vulnerability vuln = vulns.get(i);
            System.out.println();
        }
    }
}

