/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.MFD_InversionConstraint;
import scratch.UCERF3.utils.OLD_UCERF3_MFD_ConstraintFetcher;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;

public class U3FaultSystemSolution
extends FaultSystemSolution
implements Serializable {
    public U3FaultSystemSolution(U3FaultSystemRupSet rupSet, double[] rates) {
        this(rupSet, rates, null);
    }

    public U3FaultSystemSolution(U3FaultSystemRupSet rupSet, double[] rates, List<? extends IncrementalMagFreqDist> subSeismoOnFaultMFDs) {
        super(rupSet, rates);
        this.init(rupSet, rates, null, subSeismoOnFaultMFDs);
    }

    @Override
    public U3FaultSystemRupSet getRupSet() {
        return (U3FaultSystemRupSet)this.rupSet;
    }

    public static U3FaultSystemSolution buildSolAsApplicable(U3FaultSystemRupSet rupSet, double[] rates) {
        if (rupSet instanceof InversionFaultSystemRupSet) {
            return new InversionFaultSystemSolution((InversionFaultSystemRupSet)rupSet, rates);
        }
        return new U3FaultSystemSolution(rupSet, rates);
    }

    protected U3FaultSystemSolution() {
    }

    protected void init(U3FaultSystemRupSet rupSet, double[] rates, String infoString, List<? extends IncrementalMagFreqDist> subSeismoOnFaultMFDs) {
        super.init(rupSet, rates);
        if (infoString != null && !infoString.isBlank()) {
            this.addModule(new InfoModule(infoString));
        }
        if (subSeismoOnFaultMFDs != null) {
            Preconditions.checkState((subSeismoOnFaultMFDs.size() == rupSet.getNumSections() ? 1 : 0) != 0, (Object)"Sub seismo MFD count and sub section count inconsistent");
            this.addModule(new SubSeismoOnFaultMFDs(subSeismoOnFaultMFDs));
        }
    }

    public void plotRuptureRates() {
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        EvenlyDiscretizedFunc ruprates = new EvenlyDiscretizedFunc(0.0, (double)this.rupSet.getNumRuptures() - 1.0, this.rupSet.getNumRuptures());
        for (int i = 0; i < this.rupSet.getNumRuptures(); ++i) {
            ruprates.set(i, this.getRateForRup(i));
        }
        funcs.add(ruprates);
        GraphWindow graph = new GraphWindow(funcs, "Solution Rupture Rates");
        graph.setX_AxisLabel("Rupture Index");
        graph.setY_AxisLabel("Rate");
    }

    public void plotPaleoObsAndPredPaleoEventRates(List<U3PaleoRateConstraint> paleoRateConstraints, PaleoProbabilityModel paleoProbModel, InversionFaultSystemRupSet rupSet) {
        int numSections = rupSet.getNumSections();
        int numRuptures = rupSet.getNumRuptures();
        ArrayList<AbstractDiscretizedFunc> funcs3 = new ArrayList<AbstractDiscretizedFunc>();
        EvenlyDiscretizedFunc finalEventRateFunc = new EvenlyDiscretizedFunc(0.0, (double)numSections - 1.0, numSections);
        EvenlyDiscretizedFunc finalPaleoVisibleEventRateFunc = new EvenlyDiscretizedFunc(0.0, (double)numSections - 1.0, numSections);
        for (int r = 0; r < numRuptures; ++r) {
            List<Integer> sectsInRup = rupSet.getSectionsIndicesForRup(r);
            for (int i = 0; i < sectsInRup.size(); ++i) {
                finalEventRateFunc.add(sectsInRup.get(i), this.getRateForRup(r));
                double paleoProb = paleoProbModel.getProbPaleoVisible(rupSet, r, (int)sectsInRup.get(i));
                finalPaleoVisibleEventRateFunc.add(sectsInRup.get(i), paleoProb * this.getRateForRup(r));
            }
        }
        finalEventRateFunc.setName("Total Event Rates oer Section");
        finalPaleoVisibleEventRateFunc.setName("Paleo Visible Event Rates oer Section");
        funcs3.add(finalEventRateFunc);
        funcs3.add(finalPaleoVisibleEventRateFunc);
        int num = paleoRateConstraints.size();
        ArrayList obs_er_funcs = new ArrayList();
        double totalError = 0.0;
        for (int c = 0; c < num; ++c) {
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            U3PaleoRateConstraint constraint = paleoRateConstraints.get(c);
            int sectIndex = constraint.getSectionIndex();
            func.set((double)sectIndex - 1.0E-4, constraint.getLower95ConfOfRate());
            func.set((double)sectIndex, constraint.getMeanRate());
            func.set((double)sectIndex + 1.0E-4, constraint.getUpper95ConfOfRate());
            func.setName(constraint.getFaultSectionName());
            funcs3.add(func);
            double r = (constraint.getMeanRate() - finalPaleoVisibleEventRateFunc.getClosestYtoX(sectIndex)) / (constraint.getUpper95ConfOfRate() - constraint.getLower95ConfOfRate());
            totalError += Math.pow(r, 2.0);
        }
        System.out.println("Event-rate constraint error = " + totalError);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        for (int c = 0; c < num; ++c) {
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        }
        GraphWindow graph3 = new GraphWindow(funcs3, "Synthetic Event Rates (total - black & paleo visible - blue) and Paleo Data (red)", plotChars);
        graph3.setX_AxisLabel("Fault Section Index");
        graph3.setY_AxisLabel("Event Rate (per year)");
    }

    public void plotMFDs(List<MFD_InversionConstraint> mfdConstraints) {
        for (int i = 0; i < mfdConstraints.size(); ++i) {
            double m;
            IncrementalMagFreqDist offFaultMFD;
            IncrementalMagFreqDist totalTargetMFD;
            MFD_InversionConstraint mfdConstraint = mfdConstraints.get(i);
            Region region = mfdConstraint.getRegion();
            boolean traceOnly = true;
            IncrementalMagFreqDist magHist = this.calcNucleationMFD_forRegion(region, 5.05, 9.05, 0.1, traceOnly);
            System.out.println("Total solution moment/yr for " + mfdConstraints.get(i).getRegion().getName() + " region = " + magHist.getTotalMomentRate());
            ArrayList<IncrementalMagFreqDist> funcs4 = new ArrayList<IncrementalMagFreqDist>();
            magHist.setName("Magnitude Distribution of SA Solution");
            magHist.setInfo("(number in each mag bin)");
            funcs4.add(magHist);
            IncrementalMagFreqDist targetMagFreqDist = mfdConstraints.get(i).getMagFreqDist();
            targetMagFreqDist.setName("Target Magnitude Distribution");
            targetMagFreqDist.setInfo(mfdConstraints.get(i).getRegion().getName());
            funcs4.add(targetMagFreqDist);
            UCERF2_MFD_ConstraintFetcher ucerf2Constraints = new UCERF2_MFD_ConstraintFetcher();
            ucerf2Constraints.setRegion(mfdConstraints.get(i).getRegion());
            SummedMagFreqDist ucerf2_OnFaultTargetMFD = ucerf2Constraints.getTargetMinusBackgroundMFD();
            ucerf2_OnFaultTargetMFD.setTolerance(0.1);
            ucerf2_OnFaultTargetMFD.setName("UCERF2 Target minus background+aftershocks");
            ucerf2_OnFaultTargetMFD.setInfo(mfdConstraints.get(i).getRegion().getName());
            SummedMagFreqDist ucerf2_OffFaultMFD = ucerf2Constraints.getBackgroundSeisMFD();
            ucerf2_OffFaultMFD.setName("UCERF2 Background Seismicity MFD");
            funcs4.add(ucerf2_OnFaultTargetMFD);
            funcs4.add(ucerf2_OffFaultMFD);
            if (mfdConstraints.get(i).getRegion().getName() == "RELM_NOCAL Region") {
                totalTargetMFD = OLD_UCERF3_MFD_ConstraintFetcher.getTargetMFDConstraint(OLD_UCERF3_MFD_ConstraintFetcher.TimeAndRegion.NO_CA_1850).getMagFreqDist();
                offFaultMFD = new IncrementalMagFreqDist(totalTargetMFD.getMinX(), totalTargetMFD.size(), totalTargetMFD.getDelta());
                for (m = totalTargetMFD.getMinX(); m <= totalTargetMFD.getMaxX(); m += totalTargetMFD.getDelta()) {
                    offFaultMFD.set(m, totalTargetMFD.getClosestYtoX(m) - magHist.getClosestYtoX(m));
                }
                offFaultMFD.setName("Implied Off-fault MFD for Solution");
                totalTargetMFD.setName("Total Seismicity Rate for Region");
                offFaultMFD.setInfo("Total Target minus on-fault solution");
                totalTargetMFD.setInfo("Northern CA 1850-2007");
                funcs4.add(totalTargetMFD);
                funcs4.add(offFaultMFD);
            }
            if (mfdConstraints.get(i).getRegion().getName() == "RELM_SOCAL Region") {
                totalTargetMFD = OLD_UCERF3_MFD_ConstraintFetcher.getTargetMFDConstraint(OLD_UCERF3_MFD_ConstraintFetcher.TimeAndRegion.SO_CA_1850).getMagFreqDist();
                offFaultMFD = new IncrementalMagFreqDist(totalTargetMFD.getMinX(), totalTargetMFD.size(), totalTargetMFD.getDelta());
                for (m = totalTargetMFD.getMinX(); m <= totalTargetMFD.getMaxX(); m += totalTargetMFD.getDelta()) {
                    offFaultMFD.set(m, totalTargetMFD.getClosestYtoX(m) - magHist.getClosestYtoX(m));
                }
                offFaultMFD.setName("Implied Off-fault MFD for Solution");
                totalTargetMFD.setName("Total Seismicity Rate for Region");
                offFaultMFD.setInfo("Total Target minus on-fault solution");
                totalTargetMFD.setInfo("Southern CA 1850-2007");
                funcs4.add(totalTargetMFD);
                funcs4.add(offFaultMFD);
            }
            if (mfdConstraints.get(i).getRegion().getName() == "RELM_TESTING Region") {
                totalTargetMFD = OLD_UCERF3_MFD_ConstraintFetcher.getTargetMFDConstraint(OLD_UCERF3_MFD_ConstraintFetcher.TimeAndRegion.ALL_CA_1850).getMagFreqDist();
                offFaultMFD = new IncrementalMagFreqDist(totalTargetMFD.getMinX(), totalTargetMFD.size(), totalTargetMFD.getDelta());
                for (m = totalTargetMFD.getMinX(); m <= totalTargetMFD.getMaxX(); m += totalTargetMFD.getDelta()) {
                    offFaultMFD.set(m, totalTargetMFD.getClosestYtoX(m) - magHist.getClosestYtoX(m));
                }
                offFaultMFD.setName("Implied Off-fault MFD for Solution");
                totalTargetMFD.setName("Total Seismicity Rate for Region");
                offFaultMFD.setInfo("Total Target minus on-fault solution");
                totalTargetMFD.setInfo("All CA 1850-2007");
                funcs4.add(totalTargetMFD);
                funcs4.add(offFaultMFD);
            }
            GraphWindow graph4 = new GraphWindow(funcs4, "Magnitude Histogram for Final Rates");
            graph4.setX_AxisLabel("Magnitude");
            graph4.setY_AxisLabel("Frequency (per bin)");
            graph4.setYLog(true);
            graph4.setY_AxisRange(1.0E-6, 1.0);
        }
    }

    public DiscretizedFunc getRupMagDist(int rupIndex) {
        RupMFDsModule rupMFDs = this.getModule(RupMFDsModule.class);
        if (rupMFDs == null) {
            return null;
        }
        return rupMFDs.getRuptureMFD(rupIndex);
    }

    public DiscretizedFunc[] getRupMagDists() {
        RupMFDsModule rupMFDs = this.getModule(RupMFDsModule.class);
        if (rupMFDs == null) {
            return null;
        }
        DiscretizedFunc[] mfds = new DiscretizedFunc[this.getRupSet().getNumRuptures()];
        for (int r = 0; r < mfds.length; ++r) {
            mfds[r] = rupMFDs.getRuptureMFD(r);
        }
        return mfds;
    }

    public void setRupMagDists(DiscretizedFunc[] rupMFDs) {
        Preconditions.checkArgument((rupMFDs == null || rupMFDs.length == this.getRupSet().getNumRuptures() ? 1 : 0) != 0);
        this.addModule(new RupMFDsModule(this, rupMFDs));
    }

    public List<? extends IncrementalMagFreqDist> getSubSeismoOnFaultMFD_List() {
        SubSeismoOnFaultMFDs subSeismoMFDs = this.getModule(SubSeismoOnFaultMFDs.class);
        if (subSeismoMFDs == null) {
            return null;
        }
        return subSeismoMFDs.getAll();
    }

    public void setSubSeismoOnFaultMFD_List(List<? extends IncrementalMagFreqDist> subSeismoOnFaultMFDs) {
        if (subSeismoOnFaultMFDs == null) {
            this.removeModuleInstances(SubSeismoOnFaultMFDs.class);
        } else {
            this.addModule(new SubSeismoOnFaultMFDs(subSeismoOnFaultMFDs));
        }
    }
}

