/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

public abstract class U3FaultSystemSolutionFetcher
implements Iterable<InversionFaultSystemSolution> {
    private boolean cacheCopying = true;
    private Map<FaultModels, U3FaultSystemRupSet> rupSetCacheMap = Maps.newHashMap();

    public abstract Collection<U3LogicTreeBranch> getBranches();

    protected abstract InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InversionFaultSystemSolution getSolution(U3LogicTreeBranch branch) {
        InversionFaultSystemSolution sol = this.fetchSolution(branch);
        if (this.cacheCopying) {
            U3FaultSystemSolutionFetcher u3FaultSystemSolutionFetcher = this;
            synchronized (u3FaultSystemSolutionFetcher) {
                FaultModels fm = sol.getRupSet().getFaultModel();
                if (this.rupSetCacheMap.containsKey(fm)) {
                    sol.getRupSet().copyCacheFrom(this.rupSetCacheMap.get(fm));
                } else {
                    this.rupSetCacheMap.put(fm, sol.getRupSet());
                }
            }
        }
        return sol;
    }

    public double[] getRates(U3LogicTreeBranch branch) {
        return this.getSolution(branch).getRateForAllRups();
    }

    public double[] getMags(U3LogicTreeBranch branch) {
        return this.getSolution(branch).getRupSet().getMagForAllRups();
    }

    public boolean isCacheCopyingEnabled() {
        return this.cacheCopying;
    }

    public void setCacheCopying(boolean cacheCopying) {
        this.cacheCopying = cacheCopying;
    }

    @Override
    public Iterator<InversionFaultSystemSolution> iterator() {
        return new Iterator<InversionFaultSystemSolution>(){
            private Iterator<U3LogicTreeBranch> branchIt;
            {
                this.branchIt = U3FaultSystemSolutionFetcher.this.getBranches().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.branchIt.hasNext();
            }

            @Override
            public InversionFaultSystemSolution next() {
                return U3FaultSystemSolutionFetcher.this.getSolution(this.branchIt.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported by this iterator");
            }
        };
    }

    public static double calcScaledAverage(double[] vals, double[] weights) {
        if (vals.length == 1) {
            return vals[0];
        }
        double tot = 0.0;
        for (double weight : weights) {
            tot += weight;
        }
        double scaledAvg = 0.0;
        for (int i = 0; i < vals.length; ++i) {
            scaledAvg += vals[i] * (weights[i] / tot);
        }
        return scaledAvg;
    }

    public static U3FaultSystemSolutionFetcher getRandomSample(final U3FaultSystemSolutionFetcher fetch, int num, U3LogicTreeBranchNode<?> ... branchNodes) {
        ArrayList origBranches = Lists.newArrayList();
        origBranches.addAll(fetch.getBranches());
        final ArrayList branches = Lists.newArrayList();
        Random r = new Random();
        U3LogicTreeBranch testBranch = null;
        if (branchNodes != null && branchNodes.length > 0) {
            testBranch = U3LogicTreeBranch.fromValues(false, branchNodes);
        }
        for (int i = 0; i < num; ++i) {
            if (testBranch == null) {
                branches.add((U3LogicTreeBranch)origBranches.get(r.nextInt(origBranches.size())));
                continue;
            }
            U3LogicTreeBranch branch = null;
            while (branch == null || !testBranch.matchesNonNulls(branch)) {
                branch = (U3LogicTreeBranch)origBranches.get(r.nextInt(origBranches.size()));
            }
            branches.add(branch);
        }
        return new U3FaultSystemSolutionFetcher(){

            @Override
            public Collection<U3LogicTreeBranch> getBranches() {
                return branches;
            }

            @Override
            protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
                return fetch.fetchSolution(branch);
            }
        };
    }

    public static U3FaultSystemSolutionFetcher getSubset(U3FaultSystemSolutionFetcher fetch, U3LogicTreeBranchNode<?> ... nodes) {
        ArrayList branches = Lists.newArrayList();
        U3LogicTreeBranch testBranch = U3LogicTreeBranch.fromValues(false, nodes);
        for (U3LogicTreeBranch branch : fetch.getBranches()) {
            if (!testBranch.matchesNonNulls(branch)) continue;
            branches.add(branch);
        }
        return U3FaultSystemSolutionFetcher.getSubsetSample(fetch, branches);
    }

    public static U3FaultSystemSolutionFetcher getSubsetSample(final U3FaultSystemSolutionFetcher fetch, final List<U3LogicTreeBranch> branches) {
        return new U3FaultSystemSolutionFetcher(){

            @Override
            public Collection<U3LogicTreeBranch> getBranches() {
                return branches;
            }

            @Override
            protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
                return fetch.fetchSolution(branch);
            }
        };
    }
}

