/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameComparator;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class U3FileBasedFSSIterator
extends U3FaultSystemSolutionFetcher {
    public static final String TAG_BUILD_MEAN = "BUILD_MEAN";
    private Map<U3LogicTreeBranch, File[]> filesMap;

    public U3FileBasedFSSIterator(Map<U3LogicTreeBranch, File[]> filesMap) {
        this.filesMap = filesMap;
    }

    public static U3FileBasedFSSIterator forDirectory(File dir) {
        return U3FileBasedFSSIterator.forDirectory(dir, Integer.MAX_VALUE);
    }

    public static U3FileBasedFSSIterator forDirectory(File dir, int maxDepth) {
        return U3FileBasedFSSIterator.forDirectory(dir, Integer.MAX_VALUE, null);
    }

    public static U3FileBasedFSSIterator forDirectory(File dir, int maxDepth, List<String> nameGreps) {
        return new U3FileBasedFSSIterator(U3FileBasedFSSIterator.solFilesForDirectory(dir, maxDepth, nameGreps));
    }

    private static Map<U3LogicTreeBranch, File[]> solFilesForDirectory(File dir, int maxDepth, List<String> nameGreps) {
        ArrayList myNameGreps;
        boolean assembleMean;
        HashMap files = Maps.newHashMap();
        boolean bl = assembleMean = nameGreps != null && nameGreps.contains(TAG_BUILD_MEAN);
        if (assembleMean) {
            myNameGreps = Lists.newArrayList(nameGreps);
            myNameGreps.remove(TAG_BUILD_MEAN);
        } else {
            myNameGreps = nameGreps;
        }
        block0: for (File file : dir.listFiles()) {
            File[] array;
            Object zipName;
            U3LogicTreeBranch branch2;
            if (file.isDirectory() && maxDepth > 0) {
                Map<U3LogicTreeBranch, File[]> subFiles = U3FileBasedFSSIterator.solFilesForDirectory(file, maxDepth - 1, nameGreps);
                for (U3LogicTreeBranch branch2 : subFiles.keySet()) {
                    if (assembleMean) {
                        File[] newFiles = subFiles.get(branch2);
                        if (files.containsKey(branch2)) {
                            File[] origFiles = (File[])files.get(branch2);
                            File[] combined = new File[newFiles.length + origFiles.length];
                            System.arraycopy(origFiles, 0, combined, 0, origFiles.length);
                            System.arraycopy(newFiles, 0, combined, origFiles.length, newFiles.length);
                            files.put(branch2, combined);
                            continue;
                        }
                        files.put(branch2, newFiles);
                        continue;
                    }
                    U3FileBasedFSSIterator.checkNoDuplicates(branch2, subFiles.get(branch2)[0], files);
                    files.put(branch2, subFiles.get(branch2));
                }
                continue;
            }
            String name = file.getName();
            boolean solFile = name.endsWith("_sol.zip");
            if (!solFile && name.endsWith(".bin") && !name.contains("noMinRates") && !new File(dir, (String)(zipName = name.replaceAll(".bin", "_sol.zip"))).exists()) {
                solFile = true;
            }
            if (!solFile) continue;
            if (myNameGreps != null && !myNameGreps.isEmpty()) {
                zipName = myNameGreps.iterator();
                while (zipName.hasNext()) {
                    String nameGrep = (String)zipName.next();
                    if (name.contains(nameGrep)) continue;
                    continue block0;
                }
            } else if (name.contains("_run") && !assembleMean) continue;
            branch2 = VariableLogicTreeBranch.fromFileName(name);
            if (assembleMean) {
                array = (File[])files.get(branch2);
                if (array == null) {
                    array = new File[]{file};
                } else {
                    File[] newArray = new File[array.length + 1];
                    System.arraycopy(array, 0, newArray, 0, array.length);
                    newArray[array.length] = file;
                }
                files.put(branch2, array);
                continue;
            }
            U3FileBasedFSSIterator.checkNoDuplicates(branch2, file, files);
            array = new File[]{file};
            files.put(branch2, array);
        }
        return files;
    }

    private static void checkNoDuplicates(U3LogicTreeBranch branch, File file, Map<U3LogicTreeBranch, File[]> files) {
        if (files.containsKey(branch)) {
            U3LogicTreeBranch origBranch = null;
            File origFile = files.get(branch)[0];
            for (U3LogicTreeBranch candidateBranch : files.keySet()) {
                if (origFile != files.get(candidateBranch)[0]) continue;
                origBranch = candidateBranch;
                break;
            }
            Object err = "Duplicate branch found!";
            err = (String)err + "\nOrig branch:\t" + String.valueOf(origBranch);
            err = (String)err + "\nOrig file:\t" + String.valueOf(files.get(branch));
            err = (String)err + "\nNew branch:\t" + String.valueOf(branch);
            err = (String)err + "\nNew file:\t" + String.valueOf(file);
            throw new IllegalStateException((String)err);
        }
    }

    @Override
    public Collection<U3LogicTreeBranch> getBranches() {
        return this.filesMap.keySet();
    }

    @Override
    protected InversionFaultSystemSolution fetchSolution(U3LogicTreeBranch branch) {
        try {
            File[] files = this.filesMap.get(branch);
            Arrays.sort(files, new FileNameComparator());
            InversionFaultSystemSolution sol = U3FaultSystemIO.loadInvSol(files[0]);
            if (files.length > 1) {
                ArrayList ratesList = Lists.newArrayList((Object[])new double[][]{sol.getRateForAllRups()});
                for (int i = 1; i < files.length; ++i) {
                    double[] rates;
                    if (files[i].getName().endsWith(".zip")) {
                        ZipFile zip = new ZipFile(files[i]);
                        ZipEntry ratesEntry = zip.getEntry("rates.bin");
                        rates = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(ratesEntry)), ratesEntry.getSize());
                    } else if (files[i].getName().endsWith(".bin")) {
                        rates = MatrixIO.doubleArrayFromFile(files[i]);
                    } else {
                        throw new RuntimeException("Wrong file type for solution: " + files[i].getName());
                    }
                    ratesList.add(rates);
                }
                sol = new U3AverageFaultSystemSolution(sol.getRupSet(), ratesList, sol.getInversionConfiguration(), sol.getMisfits());
                sol.setInfoString(sol.getInfoString());
                System.out.println("Built mean with " + ratesList.size() + " sols");
            }
            return sol;
        }
        catch (Exception e) {
            System.err.println("Error check file list dump!");
            System.err.println("\tBRANCH: " + String.valueOf(branch));
            File[] files = this.filesMap.get(branch);
            if (files == null) {
                System.err.println("\tFILES ARE NULL!");
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file == null) {
                        System.err.println("\t" + i + ". NULL");
                        continue;
                    }
                    System.err.println("\t" + i + ". " + file.getName());
                }
            }
            throw ExceptionUtils.asRuntimeException(e);
        }
    }
}

