/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import scratch.UCERF3.U3FaultSystemRupSet;

public abstract class U3SlipEnabledRupSet
extends U3FaultSystemRupSet {
    protected ConcurrentMap<Integer, double[]> rupSectionSlipsCache = Maps.newConcurrentMap();

    public abstract double getAveSlipForRup(int var1);

    public abstract double[] getAveSlipForAllRups();

    public List<double[]> getSlipOnSectionsForAllRups() {
        ArrayList<double[]> slips = new ArrayList<double[]>();
        for (int rupIndex = 0; rupIndex < this.getNumRuptures(); ++rupIndex) {
            slips.add(this.getSlipOnSectionsForRup(rupIndex));
        }
        return slips;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.rupSectionSlipsCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double[] getSlipOnSectionsForRup(int rthRup) {
        double[] slips = (double[])this.rupSectionSlipsCache.get(rthRup);
        if (slips == null) {
            ConcurrentMap<Integer, double[]> concurrentMap = this.rupSectionSlipsCache;
            synchronized (concurrentMap) {
                slips = (double[])this.rupSectionSlipsCache.get(rthRup);
                if (slips != null) {
                    return slips;
                }
                slips = this.calcSlipOnSectionsForRup(rthRup);
                this.rupSectionSlipsCache.putIfAbsent(rthRup, slips);
            }
        }
        return slips;
    }

    protected abstract double[] calcSlipOnSectionsForRup(int var1);
}

