/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import java.util.HashMap;
import java.util.List;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionSlipRates;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.U3SlipEnabledRupSet;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;

public abstract class U3SlipEnabledSolution
extends U3FaultSystemSolution {
    private HashMap<Integer, ArbDiscrEmpiricalDistFunc> slipPDFMap = new HashMap();
    private HashMap<Integer, ArbDiscrEmpiricalDistFunc> slipPaleoObsPDFMap = new HashMap();

    protected U3SlipEnabledSolution() {
    }

    public U3SlipEnabledSolution(U3SlipEnabledRupSet rupSet, double[] rates) {
        super(rupSet, rates);
    }

    public U3SlipEnabledSolution(U3SlipEnabledRupSet rupSet, double[] rates, List<? extends IncrementalMagFreqDist> subSeismoOnFaultMFDs) {
        super(rupSet, rates, subSeismoOnFaultMFDs);
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.rupSet.removeModuleInstances(SolutionSlipRates.class);
        this.slipPDFMap.clear();
        this.slipPaleoObsPDFMap.clear();
    }

    public double calcSlipRateForSect(int sectIndex) {
        return this.calcSlipRateForAllSects()[sectIndex];
    }

    public synchronized double[] calcSlipRateForAllSects() {
        return this.rupSet.requireModule(SlipAlongRuptureModel.class).calcSlipRateForSects(this, this.rupSet.requireModule(AveSlipModule.class));
    }

    @Override
    public abstract U3SlipEnabledRupSet getRupSet();

    public synchronized ArbDiscrEmpiricalDistFunc calcSlipPFD_ForSect(int sectIndex) {
        ArbDiscrEmpiricalDistFunc slipPDF = this.slipPDFMap.get(sectIndex);
        if (slipPDF != null) {
            return slipPDF;
        }
        slipPDF = new ArbDiscrEmpiricalDistFunc();
        block0: for (int r : this.getRupSet().getRupturesForSection(sectIndex)) {
            List<Integer> sectIndices = this.getRupSet().getSectionsIndicesForRup(r);
            double[] slips = this.getRupSet().getSlipOnSectionsForRup(r);
            for (int s = 0; s < sectIndices.size(); ++s) {
                if (sectIndices.get(s) != sectIndex) continue;
                slipPDF.set(slips[s], this.getRateForRup(r));
                continue block0;
            }
        }
        this.slipPDFMap.put(sectIndex, slipPDF);
        return slipPDF;
    }

    public synchronized ArbDiscrEmpiricalDistFunc calcPaleoObsSlipPFD_ForSect(int sectIndex) {
        ArbDiscrEmpiricalDistFunc slipPDF = this.slipPaleoObsPDFMap.get(sectIndex);
        if (slipPDF != null) {
            return slipPDF;
        }
        slipPDF = new ArbDiscrEmpiricalDistFunc();
        block0: for (int r : this.getRupSet().getRupturesForSection(sectIndex)) {
            List<Integer> sectIndices = this.getRupSet().getSectionsIndicesForRup(r);
            double[] slips = this.getRupSet().getSlipOnSectionsForRup(r);
            for (int s = 0; s < sectIndices.size(); ++s) {
                if (sectIndices.get(s) != sectIndex) continue;
                slipPDF.set(slips[s], this.getRateForRup(r) * U3AveSlipConstraint.getProbabilityOfObservedSlip(slips[s]));
                continue block0;
            }
        }
        this.slipPaleoObsPDFMap.put(sectIndex, slipPDF);
        return slipPDF;
    }
}

