/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.CoastAttributes;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3SlipEnabledSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.GeologicSlipRate;
import scratch.UCERF3.utils.GeologicSlipRateLoader;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class FaultBasedMapGen {
    private static GMT_MapGenerator gmt;
    public static boolean LOCAL_MAPGEN;
    public static boolean SAVE_ZIPS;
    public static boolean SAVE_PS;
    public static Integer MAP_LABEL_SIZE;
    public static Integer MAP_LABEL_TICK_SIZE;
    public static double FAULT_THICKNESS;
    private static CPT slipCPT;
    private static CPT log10_slipCPT;
    private static CPT participationCPT;
    private static CPT linearRatioCPT;
    private static CPT logRatioCPT;
    private static CPT normalizedPairRatesCPT;
    public static final double FAULT_HIGHLIGHT_VALUE = -1.23456E25;

    public static CPT getSlipRateCPT() {
        if (slipCPT == null) {
            slipCPT = new CPT();
            slipCPT.setBelowMinColor(Color.GRAY);
            slipCPT.setNanColor(Color.GRAY);
            slipCPT.add(new CPTVal(1.4E-45f, Color.BLUE, 10.0, Color.MAGENTA));
            slipCPT.add(new CPTVal(10.0, Color.MAGENTA, 20.0, Color.RED));
            slipCPT.add(new CPTVal(20.0, Color.RED, 30.0, Color.ORANGE));
            slipCPT.add(new CPTVal(30.0, Color.ORANGE, 40.0, Color.YELLOW));
            slipCPT.setAboveMaxColor(Color.YELLOW);
        }
        return slipCPT;
    }

    public static CPT getLog10_SlipRateCPT() {
        if (log10_slipCPT == null) {
            log10_slipCPT = new CPT();
            Color lightBlue = new Color(200, 200, 255);
            Color darkBlue = new Color(75, 75, 255);
            Color altOrange = new Color(255, 128, 0);
            log10_slipCPT.setNanColor(Color.GRAY);
            log10_slipCPT.setBelowMinColor(lightBlue);
            log10_slipCPT.add(new CPTVal(-3.0, lightBlue, -2.0, darkBlue));
            log10_slipCPT.add(new CPTVal(-2.0, darkBlue, -1.0, Color.GREEN));
            log10_slipCPT.add(new CPTVal(-1.0, Color.GREEN, 0.0, Color.YELLOW));
            log10_slipCPT.add(new CPTVal(0.0, Color.YELLOW, 1.0, altOrange));
            log10_slipCPT.add(new CPTVal(1.0, altOrange, 1.4f, Color.RED));
            log10_slipCPT.add(new CPTVal(1.4f, Color.RED, 1.6f, Color.MAGENTA));
            log10_slipCPT.setAboveMaxColor(Color.MAGENTA);
        }
        return log10_slipCPT;
    }

    public static CPT getParticipationCPT() {
        if (participationCPT == null) {
            try {
                participationCPT = GMT_CPT_Files.UCERF2_FIGURE_35.instance();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return participationCPT;
    }

    public static CPT getLinearRatioCPT() {
        if (linearRatioCPT == null) {
            try {
                linearRatioCPT = GMT_CPT_Files.UCERF3_RATIOS.instance();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            linearRatioCPT = linearRatioCPT.rescale(0.0, 2.0);
        }
        return linearRatioCPT;
    }

    public static CPT getLogRatioCPT() {
        if (logRatioCPT == null) {
            try {
                logRatioCPT = GMT_CPT_Files.UCERF3_RATIOS.instance();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            logRatioCPT = logRatioCPT.rescale(-3.0, 3.0);
        }
        return logRatioCPT;
    }

    private static CPT getNormalizedPairRatesCPT() {
        if (normalizedPairRatesCPT == null) {
            try {
                normalizedPairRatesCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 1.0);
                normalizedPairRatesCPT.setNanColor(Color.GRAY);
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return normalizedPairRatesCPT;
    }

    public static void plotOrigNonReducedSlipRates(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getSlipRateCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] values = new double[faults.size()];
        for (int i = 0; i < faults.size(); ++i) {
            values[i] = faults.get(i).getOrigAveSlipRate();
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, prefix + "_orig_non_reduced_slip", display, false, "Original Non Reduced Slip Rate (mm/yr)");
    }

    public static void plotOrigCreepReducedSlipRates(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getSlipRateCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] values = new double[faults.size()];
        for (int i = 0; i < faults.size(); ++i) {
            values[i] = faults.get(i).getReducedAveSlipRate();
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, prefix + "_orig_creep_reduced_slip", display, false, "Orig Creep Reduced Slip Rate (mm/yr)");
    }

    public static void plotTargetSlipRates(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getSlipRateCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] values = FaultBasedMapGen.scale(sol.getRupSet().getSlipRateForAllSections(), 1000.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, prefix + "_target_slip", display, false, "Target Slip Rate (mm/yr)");
    }

    public static void plotSolutionSlipRates(U3SlipEnabledSolution sol, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getSlipRateCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] values = FaultBasedMapGen.scale(sol.calcSlipRateForAllSects(), 1000.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, prefix + "_solution_slip", display, false, "Solution Slip Rate (mm/yr)");
    }

    private static double calcFractionalDifferentce(double target, double comparison) {
        return (comparison - target) / target;
    }

    public static void plotBulgeFromFirstGenAftershocksMap(InversionFaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display, boolean logRatio) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt;
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        List<? extends IncrementalMagFreqDist> subSeisMFD_List = sol.getFinalSubSeismoOnFaultMFD_List();
        List<IncrementalMagFreqDist> supraSeisMFD_List = sol.getFinalSupraSeismoOnFaultMFD_List(5.05, 8.95, 40);
        double[] values = new double[faults.size()];
        for (int i = 0; i < subSeisMFD_List.size(); ++i) {
            values[i] = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(supraSeisMFD_List.get(i), subSeisMFD_List.get(i), false);
        }
        prefix = (String)prefix + "_bulgeFrom1stGenAft";
        Object name = "BulgeFrom1stGenAftershocks";
        if (logRatio) {
            values = FaultBasedMapGen.log10(values);
            cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
            prefix = (String)prefix + "_log";
            name = "Log10(" + (String)name + ")";
        } else {
            cpt = FaultBasedMapGen.getLinearRatioCPT();
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, (String)prefix, display, false, (String)name);
    }

    public static void plotBulgeForM6pt7_Map(InversionFaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display, boolean logRatio) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt;
        double mag = 6.75;
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        List<? extends IncrementalMagFreqDist> subSeisMFD_List = sol.getFinalSubSeismoOnFaultMFD_List();
        List<IncrementalMagFreqDist> supraSeisMFD_List = sol.getFinalSupraSeismoOnFaultMFD_List(5.05, 8.95, 40);
        double[] values = new double[faults.size()];
        for (int i = 0; i < subSeisMFD_List.size(); ++i) {
            IncrementalMagFreqDist subSeisMFD = subSeisMFD_List.get(i);
            IncrementalMagFreqDist supraSeisMFD = supraSeisMFD_List.get(i);
            double minMag = subSeisMFD.getMinX();
            double maxMagWithNonZeroRate = supraSeisMFD.getMaxMagWithNonZeroRate();
            if (maxMagWithNonZeroRate >= mag) {
                int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / 0.1) + 1;
                GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
                gr.scaleToIncrRate(5.05, subSeisMFD.getY(5.05));
                SummedMagFreqDist sumDist = new SummedMagFreqDist(minMag, maxMagWithNonZeroRate, numMag);
                sumDist.addIncrementalMagFreqDist(subSeisMFD);
                sumDist.addIncrementalMagFreqDist(supraSeisMFD);
                values[i] = sumDist.getCumRate(mag) / gr.getCumRate(mag);
                continue;
            }
            values[i] = Double.POSITIVE_INFINITY;
        }
        prefix = (String)prefix + "_bulgeForM6pt7";
        Object name = "BulgeForM6pt7";
        if (logRatio) {
            values = FaultBasedMapGen.log10(values);
            cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
            prefix = (String)prefix + "_log";
            name = "Log10(" + (String)name + ")";
        } else {
            cpt = FaultBasedMapGen.getLinearRatioCPT();
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, (String)prefix, display, false, (String)name);
    }

    public static void plotSolutionSlipMisfit(U3SlipEnabledSolution sol, Region region, File saveDir, String prefix, boolean display, boolean logRatio) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt;
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] solSlips = sol.calcSlipRateForAllSects();
        double[] targetSlips = sol.getRupSet().getSlipRateForAllSections();
        double[] values = new double[faults.size()];
        for (int i = 0; i < faults.size(); ++i) {
            values[i] = solSlips[i] == 0.0 && targetSlips[i] == 0.0 ? 1.0 : solSlips[i] / targetSlips[i];
        }
        prefix = (String)prefix + "_slip_misfit";
        Object name = "Solution Slip / Target Slip";
        if (logRatio) {
            values = FaultBasedMapGen.log10(values);
            cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-1.0, 1.0);
            prefix = (String)prefix + "_log";
            name = "Log10(" + (String)name + ")";
        } else {
            cpt = FaultBasedMapGen.getLinearRatioCPT();
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, (String)prefix, display, false, (String)name);
    }

    public static void plotParticipationRates(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display, double minMag, double maxMag) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getParticipationCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] values = sol.calcParticRateForAllSects(minMag, maxMag);
        values = FaultBasedMapGen.log10(values);
        String name = prefix + "_partic_rates_" + (float)minMag;
        String title = "Log10(Participation Rates " + (float)minMag;
        if (maxMag < 9.0) {
            name = name + "_" + (float)maxMag;
            title = title + "=>" + (float)maxMag;
        } else {
            name = name + "+";
            title = title + "+";
        }
        title = title + ")";
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, name, display, false, title);
    }

    public static void plotParticipationStdDevs(FaultSystemRupSet rupSet, double[][] partRates, Region region, File saveDir, String prefix, boolean display, double minMag, double maxMag) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getParticipationCPT();
        List<? extends FaultSection> faults = rupSet.getFaultSectionDataList();
        double[] stdDevs = new double[partRates.length];
        double[] mean = new double[partRates.length];
        double[] sdom_over_means = new double[partRates.length];
        for (int i = 0; i < partRates.length; ++i) {
            mean[i] = StatUtils.mean((double[])partRates[i]);
            stdDevs[i] = Math.sqrt(StatUtils.variance((double[])partRates[i], (double)mean[i]));
            sdom_over_means[i] = stdDevs[i] / Math.sqrt(partRates[i].length) / mean[i];
        }
        Object name = prefix + "_partic_std_dev_" + (float)minMag;
        Object title = "Log10(Participation Rates Std. Dev. " + (float)minMag;
        if (maxMag < 9.0) {
            name = (String)name + "_" + (float)maxMag;
            title = (String)title + "=>" + (float)maxMag;
        } else {
            name = (String)name + "+";
            title = (String)title + "+";
        }
        title = (String)title + ")";
        MatrixIO.doubleArrayToFile(stdDevs, new File(saveDir, (String)name + ".bin"));
        double[] logStdDevs = FaultBasedMapGen.log10(stdDevs);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), logStdDevs, region, saveDir, (String)name, display, false, (String)title);
        title = ((String)title).replaceAll("Dev. ", "Dev. / Mean ");
        name = ((String)name).replaceAll("_dev_", "_dev_norm_");
        double[] norm = new double[mean.length];
        for (int i = 0; i < mean.length; ++i) {
            norm[i] = stdDevs[i] / mean[i];
        }
        norm = FaultBasedMapGen.log10(norm);
        cpt = cpt.rescale(-3.0, 2.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), norm, region, saveDir, (String)name, display, false, (String)title);
        double[] logSDOMOverMeans = FaultBasedMapGen.log10(sdom_over_means);
        cpt = cpt.rescale(-4.0, 0.0);
        name = prefix + "_partic_sdom_over_mean_" + (float)minMag;
        title = "Log10(Participation Rates SDOM / Mean " + (float)minMag;
        if (maxMag < 9.0) {
            name = (String)name + "_" + (float)maxMag;
            title = (String)title + "=>" + (float)maxMag;
        } else {
            name = (String)name + "+";
            title = (String)title + "+";
        }
        title = (String)title + ")";
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), logSDOMOverMeans, region, saveDir, (String)name, display, false, (String)title);
    }

    public static void plotSolutionSlipRateStdDevs(FaultSystemRupSet rupSet, double[][] slipRates, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(-4.0, 1.0);
        List<? extends FaultSection> faults = rupSet.getFaultSectionDataList();
        double[] stdDev = new double[slipRates.length];
        double[] mean = new double[slipRates.length];
        for (int i = 0; i < slipRates.length; ++i) {
            double[] rates = FaultBasedMapGen.scale(slipRates[i], 1000.0);
            mean[i] = StatUtils.mean((double[])rates);
            stdDev[i] = Math.sqrt(StatUtils.variance((double[])rates, (double)mean[i]));
        }
        MatrixIO.doubleArrayToFile(stdDev, new File(saveDir, prefix + "_solution_slip_std_dev.bin"));
        double[] logStdDev = FaultBasedMapGen.log10(stdDev);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), logStdDev, region, saveDir, prefix + "_solution_slip_std_dev", display, false, "Log10(Solution Slip Rate Std Dev (mm/yr))");
        double[] norm = new double[mean.length];
        for (int i = 0; i < mean.length; ++i) {
            norm[i] = stdDev[i] / mean[i];
        }
        norm = FaultBasedMapGen.log10(norm);
        cpt = cpt.rescale(-3.0, 2.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), norm, region, saveDir, prefix + "_solution_slip_std_dev_norm", display, false, "Log10(Solution Slip Rate Std Dev / Mean)");
    }

    public static void plotParticipationRatios(FaultSystemSolution sol, FaultSystemSolution referenceSol, Region region, File saveDir, String prefix, boolean display, double minMag, double maxMag, boolean omitInfinites) throws GMT_MapException, RuntimeException, IOException {
        double[] refVals;
        CPT cpt = FaultBasedMapGen.getLogRatioCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] newVals = sol.calcParticRateForAllSects(minMag, maxMag);
        Preconditions.checkState((newVals.length == (refVals = referenceSol.calcParticRateForAllSects(minMag, maxMag)).length ? 1 : 0) != 0, (Object)"solution rupture counts are incompatible!");
        double[] values = new double[newVals.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = newVals[i] / refVals[i];
            if (!omitInfinites || !Double.isInfinite(values[i])) continue;
            values[i] = Double.NaN;
        }
        values = FaultBasedMapGen.log10(values);
        String name = prefix + "_partic_ratio_" + (float)minMag;
        String title = "Log10(Participation Ratios " + (float)minMag;
        if (maxMag < 9.0) {
            name = name + "_" + (float)maxMag;
            title = title + "=>" + (float)maxMag;
        } else {
            name = name + "+";
            title = title + "+";
        }
        title = title + ")";
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, name, display, true, title);
    }

    public static double plotParticipationDiffs(FaultSystemSolution sol, FaultSystemSolution referenceSol, Region region, File saveDir, String prefix, boolean display, double minMag, double maxMag) throws GMT_MapException, RuntimeException, IOException {
        double[] refVals;
        CPT cpt = FaultBasedMapGen.getLinearRatioCPT().rescale(-0.005, 0.005);
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[] newVals = sol.calcParticRateForAllSects(minMag, maxMag);
        Preconditions.checkState((newVals.length == (refVals = referenceSol.calcParticRateForAllSects(minMag, maxMag)).length ? 1 : 0) != 0, (Object)"solution rupture counts are incompatible!");
        double[] values = new double[newVals.length];
        double total = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double diff = newVals[i] - refVals[i];
            if (!Double.isNaN(diff)) {
                total += diff;
            }
            values[i] = diff;
        }
        String name = prefix + "_ref_partic_diff_" + (float)minMag;
        String title = "Participation Rate Diff " + (float)minMag;
        if (maxMag < 9.0) {
            name = name + "_" + (float)maxMag;
            title = title + "=>" + (float)maxMag;
        } else {
            name = name + "+";
            title = title + "+";
        }
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, name, display, true, title);
        return total;
    }

    public static void plotSectionPairRates(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        CPT cpt = FaultBasedMapGen.getNormalizedPairRatesCPT();
        List<? extends FaultSection> faults = sol.getRupSet().getFaultSectionDataList();
        double[][] rates = sol.getSectionPairRupRates();
        ArrayList<LocationList> lines = new ArrayList<LocationList>();
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int sec1 = 0; sec1 < rates.length; ++sec1) {
            double[] secRates = rates[sec1];
            for (int sec2 = 0; sec2 < secRates.length; ++sec2) {
                double rate;
                if (sec1 >= sec2 || (rate = secRates[sec2]) <= 0.0) continue;
                double sec1Rate = sol.calcParticRateForSect(sec1, 0.0, 10.0);
                double sec2Rate = sol.calcParticRateForSect(sec2, 0.0, 10.0);
                double avg = 0.5 * (sec1Rate + sec2Rate);
                rate /= avg;
                LocationList pts = new LocationList();
                pts.add(FaultBasedMapGen.getTraceMidpoint(faults.get(sec1)));
                pts.add(FaultBasedMapGen.getTraceMidpoint(faults.get(sec2)));
                lines.add(pts);
                vals.add(rate);
            }
        }
        double[] values = new double[vals.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Double)vals.get(i);
        }
        FaultBasedMapGen.makeFaultPlot(cpt, lines, values, region, saveDir, prefix + "_sect_pairs", display, true, "Normalized Section Pair Rates");
    }

    public static void plotSegmentation(FaultSystemSolution sol, Region region, File saveDir, String prefix, boolean display, double minMag, double maxMag) throws GMT_MapException, RuntimeException, IOException {
        FaultSystemRupSet rupSet = sol.getRupSet();
        CPT cpt = FaultBasedMapGen.getNormalizedPairRatesCPT();
        ArrayList faults = new ArrayList(rupSet.getFaultSectionDataList());
        HashMap faultsMap = Maps.newHashMap();
        for (FaultSection fault : faults) {
            faultsMap.put(fault.getSectionId(), fault);
        }
        ArrayList ends = Lists.newArrayList();
        HashMap parentsMap = Maps.newHashMap();
        int prevParent = -2;
        List curSectsForParentList = null;
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            FaultSection fault = rupSet.getFaultSectionData(sectIndex);
            int parent = fault.getParentSectionId();
            if (prevParent != parent) {
                if (sectIndex > 0) {
                    ends.add(sectIndex - 1);
                }
                ends.add(sectIndex);
                curSectsForParentList = Lists.newArrayList();
                parentsMap.put(parent, curSectsForParentList);
            }
            curSectsForParentList.add(fault);
            prevParent = parent;
        }
        ArrayList visibleFaults = Lists.newArrayList();
        ArrayList visibleNanFaults = Lists.newArrayList();
        ArrayList valsList = Lists.newArrayList();
        Iterator iterator = ends.iterator();
        while (iterator.hasNext()) {
            int sect = (Integer)iterator.next();
            List<Integer> rups = rupSet.getRupturesForSection(sect);
            double totRate = 0.0;
            double endRate = 0.0;
            int cnt = 0;
            for (int rupID : rups) {
                double mag = rupSet.getMagForRup(rupID);
                if (mag < minMag || mag > maxMag) continue;
                double rate = sol.getRateForRup(rupID);
                List<Integer> sects = rupSet.getSectionsIndicesForRup(rupID);
                if (sects.get(0) == sect || sects.get(sects.size() - 1) == sect) {
                    endRate += rate;
                }
                totRate += rate;
                ++cnt;
            }
            if (cnt <= 0) continue;
            valsList.add(endRate / totRate);
            visibleFaults.add((FaultSection)faultsMap.get(sect));
            List sects = (List)parentsMap.get(rupSet.getFaultSectionData(sect).getParentSectionId());
            if (sect != ((FaultSection)sects.get(0)).getSectionId()) continue;
            for (int i = 1; i < sects.size() - 1; ++i) {
                visibleNanFaults.add((FaultSection)sects.get(i));
            }
        }
        faults = Lists.newArrayList();
        faults.addAll(visibleNanFaults);
        faults.addAll(visibleFaults);
        double[] values = new double[faults.size()];
        for (int index = 0; index < visibleNanFaults.size(); ++index) {
            values[index] = Double.NaN;
        }
        for (int i = 0; i < visibleFaults.size(); ++i) {
            values[index + i] = (Double)valsList.get(i);
        }
        Object title = "Segmentation";
        String fName = prefix + "_segmentation";
        if (minMag > 5.0) {
            title = (String)title + " (" + (float)minMag;
            fName = fName + "_" + (float)minMag;
        }
        if (maxMag < 9.0) {
            title = (String)title + "=>" + (float)maxMag;
            fName = fName + "_" + (float)maxMag;
        } else if (minMag > 5.0) {
            title = (String)title + "+";
            fName = fName + "+";
        }
        title = (String)title + ")";
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, region, saveDir, fName, display, false, (String)title);
    }

    public static void plotDeformationModelSlips(Region region, File saveDir, boolean display) throws IOException, GMT_MapException, RuntimeException {
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM2_1, DeformationModels.UCERF2_ALL, "fm2_1_ucerf2");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_1, DeformationModels.GEOLOGIC, "fm3_1_geol");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_1, DeformationModels.ABM, "fm3_1_abm");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_1, DeformationModels.NEOKINEMA, "fm3_1_neok");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_1, DeformationModels.ZENGBB, "fm3_1_zengbb");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_2, DeformationModels.GEOLOGIC, "fm3_2_geol");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_2, DeformationModels.ABM, "fm3_2_abm");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_2, DeformationModels.NEOKINEMA, "fm3_2_neok");
        FaultBasedMapGen.plotDeformationModelSlip(region, saveDir, display, FaultModels.FM3_2, DeformationModels.ZENGBB, "fm3_2_zengbb");
        CPT cpt = FaultBasedMapGen.getLog10_SlipRateCPT();
        ArrayList<GeologicSlipRate> geoRates = GeologicSlipRateLoader.loadExcelFile(new URL("http://www.wgcep.org/sites/wgcep.org/files/UCERF3_Geologic_Slip%20Rates_version%203_2012_11_01.xls"));
        ArrayList symbols = Lists.newArrayList();
        ArrayList vals = Lists.newArrayList();
        for (GeologicSlipRate geoRate : geoRates) {
            Location loc = geoRate.getLocation();
            Point2D.Double pt = new Point2D.Double(loc.getLongitude(), loc.getLatitude());
            double rate = geoRate.getValue();
            PSXYSymbol.Symbol symbol = PSXYSymbol.Symbol.CIRCLE;
            symbols.add(new PSXYSymbol(pt, symbol, 0.1));
            vals.add(Math.log10(rate));
        }
        double penWidth = 1.0;
        Color penColor = Color.BLACK;
        PSXYSymbolSet symbolSet = new PSXYSymbolSet(cpt, symbols, vals, penWidth, penColor, null);
        GMT_Map map = FaultBasedMapGen.buildMap(cpt, new ArrayList<LocationList>(), new double[0], null, 1.0, region, true, "Log10 Slip Rate (mm/yr)");
        map.setSymbolSet(symbolSet);
        FaultBasedMapGen.plotMap(saveDir, "dm_geo_sites", display, map);
    }

    public static void plotDeformationModelSlip(Region region, File saveDir, boolean display, FaultModels fm, DeformationModels dm, String prefix) throws IOException, GMT_MapException, RuntimeException {
        CPT cpt = FaultBasedMapGen.getLog10_SlipRateCPT();
        ArrayList faults = Lists.newArrayList();
        ArrayList valsList = Lists.newArrayList();
        if (fm == FaultModels.FM2_1) {
            DeformationModelFetcher dmFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
            for (FaultSection faultSection : dmFetch.getSubSectionList()) {
                faults.add(faultSection.getFaultTrace());
                valsList.add(faultSection.getOrigAveSlipRate());
            }
        } else {
            Map<Integer, DeformationModelFileParser.DeformationSection> sects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
            for (DeformationModelFileParser.DeformationSection deformationSection : sects.values()) {
                for (int i = 0; i < deformationSection.getLocs1().size(); ++i) {
                    LocationList locs = new LocationList();
                    locs.add(deformationSection.getLocs1().get(i));
                    locs.add(deformationSection.getLocs2().get(i));
                    faults.add(locs);
                    valsList.add(deformationSection.getSlips().get(i));
                }
            }
        }
        double[] values = Doubles.toArray((Collection)valsList);
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.log10(values[i]);
        }
        FaultBasedMapGen.makeFaultPlot(cpt, faults, values, region, saveDir, prefix, display, false, "Log10 Slip Rate (mm/yr)");
    }

    public static void plotDeformationModelSlipRatiosToGeol(Region region, File saveDir, boolean display) throws IOException, GMT_MapException, RuntimeException {
        FaultBasedMapGen.plotDeformationModelSlipRatio(region, saveDir, display, FaultModels.FM3_1, DeformationModels.ABM, DeformationModels.GEOLOGIC, "dm_abm_vs_geol");
        FaultBasedMapGen.plotDeformationModelSlipRatio(region, saveDir, display, FaultModels.FM3_1, DeformationModels.NEOKINEMA, DeformationModels.GEOLOGIC, "dm_neok_vs_geol");
        FaultBasedMapGen.plotDeformationModelSlipRatio(region, saveDir, display, FaultModels.FM3_1, DeformationModels.ZENG, DeformationModels.GEOLOGIC, "dm_zeng_vs_geol");
    }

    public static void plotDeformationModelSlipRatio(Region region, File saveDir, boolean display, FaultModels fm, DeformationModels dm, DeformationModels ref, String prefix) throws IOException, GMT_MapException, RuntimeException {
        CPT cpt = FaultBasedMapGen.getLogRatioCPT();
        ArrayList faults = Lists.newArrayList();
        ArrayList valsList = Lists.newArrayList();
        if (fm == FaultModels.FM2_1) {
            DeformationModelFetcher dmFetch1 = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
            DeformationModelFetcher dmFetch2 = new DeformationModelFetcher(fm, ref, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
            List<? extends FaultSection> sects1 = dmFetch1.getSubSectionList();
            List<? extends FaultSection> sects2 = dmFetch2.getSubSectionList();
            for (int i = 0; i < sects1.size(); ++i) {
                FaultSection fault1 = sects1.get(i);
                FaultSection fault2 = sects2.get(i);
                faults.add(fault1.getFaultTrace());
                valsList.add(fault1.getOrigAveSlipRate() / fault2.getOrigAveSlipRate());
            }
        } else {
            Map<Integer, DeformationModelFileParser.DeformationSection> sects1 = DeformationModelFileParser.load(dm.getDataFileURL(fm));
            Map<Integer, DeformationModelFileParser.DeformationSection> sects2 = DeformationModelFileParser.load(ref.getDataFileURL(fm));
            for (DeformationModelFileParser.DeformationSection sect : sects1.values()) {
                DeformationModelFileParser.DeformationSection sect2 = sects2.get(sect.getId());
                for (int i = 0; i < sect.getLocs1().size(); ++i) {
                    LocationList locs = new LocationList();
                    locs.add(sect.getLocs1().get(i));
                    locs.add(sect.getLocs2().get(i));
                    faults.add(locs);
                    valsList.add(sect.getSlips().get(i) / sect2.getSlips().get(i));
                }
            }
        }
        double[] values = Doubles.toArray((Collection)valsList);
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.log10(values[i]);
        }
        String str = dm.getShortName() + "/" + ref.getShortName();
        FaultBasedMapGen.makeFaultPlot(cpt, faults, values, region, saveDir, prefix, display, false, "Log10(Slip Rate Ratio, " + str + ")");
    }

    private static Location getTraceMidpoint(FaultSection fault) {
        return (Location)FaultUtils.resampleTrace(fault.getFaultTrace(), 10).get(5);
    }

    public static double[] scale(double[] values, double scalar) {
        double[] ret = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i] * scalar;
        }
        return ret;
    }

    public static double[] log10(double[] values) {
        double[] ret = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = Math.log10(values[i]);
        }
        return ret;
    }

    public static ArrayList<LocationList> getTraces(List<? extends FaultSection> faults) {
        ArrayList<LocationList> faultTraces = new ArrayList<LocationList>();
        for (FaultSection faultSection : faults) {
            faultTraces.add(faultSection.getFaultTrace());
        }
        return faultTraces;
    }

    public static synchronized void makeFaultPlot(CPT cpt, List<LocationList> faults, double[] values, Region region, File saveDir, String prefix, boolean display, boolean skipNans, String label) throws GMT_MapException, RuntimeException, IOException {
        GMT_Map map = FaultBasedMapGen.buildMap(cpt, faults, values, null, 1.0, region, skipNans, label);
        FaultBasedMapGen.plotMap(saveDir, prefix, display, map);
    }

    public static String plotMap(File saveDir, String prefix, boolean display, GMT_Map map) throws GMT_MapException, IOException {
        String baseURL;
        if (gmt == null) {
            gmt = new GMT_MapGenerator();
            gmt.getAdjustableParamsList().getParameter(Boolean.class, "Plot Log").setValue(false);
            gmt.getAdjustableParamsList().getParameter(Boolean.class, "Apply GMT Smoothing?").setValue(false);
        }
        if (LOCAL_MAPGEN) {
            FaultBasedMapGen.plotLocalMap(saveDir, prefix, display, false, map);
            baseURL = null;
        } else {
            String url = gmt.makeMapUsingServlet(map, "metadata", null);
            System.out.println(url);
            baseURL = url.substring(0, url.lastIndexOf(47) + 1);
            if (saveDir != null) {
                if (map.getPNGFileName() != null) {
                    File pngFile = new File(saveDir, prefix + ".png");
                    FaultBasedMapGen.checkLocalDownloadOpenSHA(baseURL + "map.png", pngFile);
                }
                if (map.getPDFFileName() != null) {
                    File pdfFile = new File(saveDir, prefix + ".pdf");
                    FaultBasedMapGen.checkLocalDownloadOpenSHA(baseURL + "map.pdf", pdfFile);
                }
                if (SAVE_PS) {
                    File psFile = new File(saveDir, prefix + ".ps");
                    FaultBasedMapGen.checkLocalDownloadOpenSHA(baseURL + "map.ps", psFile);
                }
                if (map.isGenerateKML()) {
                    File kmzFile = new File(saveDir, prefix + ".kmz");
                    FaultBasedMapGen.checkLocalDownloadOpenSHA(baseURL + "map.kmz", kmzFile);
                }
                if (SAVE_ZIPS) {
                    File zipFile = new File(saveDir, prefix + ".zip");
                    FaultBasedMapGen.checkLocalDownloadOpenSHA(baseURL + "allFiles.zip", zipFile);
                }
            }
            if (display) {
                String metadata = GMT_MapGuiBean.getClickHereHTML(gmt.getGMTFilesWebAddress());
                new ImageViewerWindow(url, metadata, true);
            }
        }
        return baseURL;
    }

    public static void plotLocalMap(File saveDir, String prefix, boolean display, boolean writeScript, GMT_Map map) throws GMT_MapException, IOException {
        if (gmt == null) {
            gmt = new GMT_MapGenerator();
            gmt.getAdjustableParamsList().getParameter(Boolean.class, "Plot Log").setValue(false);
            gmt.getAdjustableParamsList().getParameter(Boolean.class, "Apply GMT Smoothing?").setValue(false);
        }
        GMT_MapGenerator.clearEnv();
        GMT_MapGenerator.GMT_DATA_PATH = "/data/kevin/opensha/gmt/";
        map.setJPGFileName(null);
        File tempDir = Files.createTempDir();
        ArrayList<String> script = gmt.getGMT_ScriptLines(map, tempDir.getAbsolutePath());
        File scriptFile = new File(tempDir, "script.sh");
        if (map.getGriddedData() != null) {
            GeoDataSet griddedData = map.getGriddedData();
            griddedData.setLatitudeX(true);
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)griddedData, tempDir.getAbsolutePath() + "/" + new File(map.getXyzFileName()).getName());
        }
        FileWriter fw = new FileWriter(scriptFile);
        BufferedWriter bw = new BufferedWriter(fw);
        for (String line : script) {
            bw.write(line + "\n");
        }
        bw.close();
        if (writeScript) {
            Files.copy((File)scriptFile, (File)new File(saveDir, prefix + ".sh"));
        }
        String[] command = new String[]{"sh", "-c", "/bin/bash " + scriptFile.getAbsolutePath() + " > /dev/null 2> /dev/null"};
        RunScript.runScript(command);
        if (saveDir != null) {
            if (SAVE_ZIPS) {
                FileUtils.createZipFile(tempDir.getAbsolutePath());
                File zipFile = new File(tempDir, "allFiles.zip");
                Preconditions.checkState((boolean)zipFile.exists(), (String)"No ZIP file: %s", (Object)zipFile.getAbsolutePath());
                Files.move((File)zipFile, (File)new File(saveDir, prefix + ".zip"));
            }
            if (map.getPNGFileName() != null) {
                File pngFile = new File(tempDir, map.getPNGFileName());
                Preconditions.checkState((boolean)pngFile.exists(), (String)"No PNG file: %s", (Object)pngFile.getAbsolutePath());
                Files.move((File)pngFile, (File)new File(saveDir, prefix + ".png"));
            }
            if (map.getPDFFileName() != null) {
                File pdfFile = new File(tempDir, map.getPDFFileName());
                Preconditions.checkState((boolean)pdfFile.exists(), (String)"No PDF file: %s", (Object)pdfFile.getAbsolutePath());
                Files.move((File)pdfFile, (File)new File(saveDir, prefix + ".pdf"));
            }
            if (SAVE_PS) {
                File psFile = new File(tempDir, map.getPSFileName());
                Preconditions.checkState((boolean)psFile.exists(), (String)"No PS file: %s", (Object)psFile.getAbsolutePath());
                Files.move((File)psFile, (File)new File(saveDir, prefix + ".ps"));
            }
            if (map.isGenerateKML()) {
                Files.move((File)new File(tempDir, "map.kmz"), (File)new File(saveDir, prefix + ".kmz"));
            }
        }
        FileUtils.deleteRecursive(tempDir);
    }

    private static void checkLocalDownloadOpenSHA(String url, File destFile) throws IOException {
        File file = new File(ServerPrefUtils.SERVER_PREFS.getTempDir(), url.substring(url.indexOf("gmtData")));
        if (file.exists()) {
            Files.copy((File)file, (File)destFile);
        } else {
            FileUtils.downloadURL(url, destFile);
        }
    }

    public static void makeFaultKML(CPT cpt, List<LocationList> faults, double[] values, File saveDir, String prefix, boolean skipNans, int numColorBins, int lineWidth, String name) throws IOException {
        FaultBasedMapGen.makeFaultKML(cpt, faults, values, saveDir, prefix, skipNans, numColorBins, lineWidth, name, null);
    }

    public static void makeFaultKML(CPT cpt, List<LocationList> faults, double[] values, File saveDir, String prefix, boolean skipNans, int numColorBins, int lineWidth, String name, List<String> descriptions) throws IOException {
        Document doc = FaultBasedMapGen.getFaultKML(cpt, faults, values, skipNans, numColorBins, lineWidth, name, descriptions);
        File outputFile = new File(saveDir, prefix + ".kml");
        XMLUtils.writeDocumentToFile(outputFile, doc);
    }

    public static Document getFaultKML(CPT cpt, List<LocationList> faults, double[] values, boolean skipNans, int numColorBins, int lineWidth, String name, List<String> descriptions) {
        return FaultBasedMapGen.getFaultKML(cpt, faults, values, skipNans, numColorBins, lineWidth, name, descriptions, 0.0, -1);
    }

    public static Document getFaultKML(CPT cpt, List<LocationList> faults, double[] values, boolean skipNans, int numColorBins, int lineWidth, String name, List<String> descriptions, double bufferWidthKM, int bufferMaxPixels) {
        double cptMin = cpt.getMinValue();
        double cptMax = cpt.getMaxValue();
        double cptDelta = (cptMax - cptMin) / (double)numColorBins;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(cptMin + 0.5 * cptDelta, numColorBins, cptDelta);
        ArrayList cptColors = Lists.newArrayList();
        for (Point2D pt : func) {
            cptColors.add(cpt.getColor((float)pt.getX()));
        }
        Document doc = XMLUtils.createDocumentWithRoot("Document");
        Element docEl = doc.getRootElement();
        docEl.addElement("name").addText(name);
        for (int i = 0; i < numColorBins; ++i) {
            FaultBasedMapGen.addStyleEl(docEl, (Color)cptColors.get(i), lineWidth, "CPT_" + i);
        }
        FaultBasedMapGen.addStyleEl(docEl, cpt.getBelowMinColor(), lineWidth, "CPT_BELOW_MIN");
        FaultBasedMapGen.addStyleEl(docEl, cpt.getAboveMaxColor(), lineWidth, "CPT_ABOVE_MAX");
        if (!skipNans) {
            FaultBasedMapGen.addStyleEl(docEl, cpt.getNanColor(), lineWidth, "CPT_NAN");
        }
        Element folderEl = docEl.addElement("Folder");
        folderEl.addElement("name").addText("Faults");
        for (int i = 0; i < faults.size(); ++i) {
            LocationList fault = faults.get(i);
            double val = values[i];
            if (Double.isNaN(val) && skipNans) continue;
            Object styleID = val < cptMin ? "CPT_BELOW_MIN" : (val > cptMax ? "CPT_ABOVE_MAX" : (Double.isNaN(val) ? "CPT_NAN" : "CPT_" + func.getClosestXIndex(val)));
            Element placemarkEl = folderEl.addElement("Placemark");
            Object faultName = "Fault " + i;
            if (fault instanceof Named) {
                String tempName = ((Named)((Object)fault)).getName();
                if (name != null) {
                    faultName = tempName;
                }
            }
            placemarkEl.addElement("name").addText((String)faultName);
            if (descriptions != null) {
                placemarkEl.addElement("description").addCDATA(descriptions.get(i));
            }
            placemarkEl.addElement("styleUrl").addText("#" + (String)styleID);
            Element lineStrEl = placemarkEl.addElement("LineString");
            lineStrEl.addElement("tesselate").addText("1");
            Element coordsEl = lineStrEl.addElement("coordinates");
            Object coordsStr = "";
            for (Location loc : fault) {
                coordsStr = (String)coordsStr + loc.getLongitude() + "," + loc.getLatitude() + ",0\n";
            }
            coordsEl.addText((String)coordsStr);
            if (!(bufferWidthKM > 0.0) || bufferMaxPixels <= 0) continue;
            double bufferKM = 0.5 * bufferWidthKM;
            Location firstLoc = fault.first();
            Location lastLoc = fault.last();
            Location middleLoc = new Location(0.5 * (firstLoc.getLatitude() + lastLoc.getLatitude()), 0.5 * (firstLoc.getLongitude() + lastLoc.getLongitude()));
            Location north = LocationUtils.location(middleLoc, 0.0, bufferKM);
            Location east = LocationUtils.location(middleLoc, 1.5707963267948966, bufferKM);
            Location south = LocationUtils.location(middleLoc, Math.PI, bufferKM);
            Location west = LocationUtils.location(middleLoc, 4.71238898038469, bufferKM);
            Element regEl = placemarkEl.addElement("Region");
            Element boxEl = regEl.addElement("LatLonAltBox");
            boxEl.addElement("north").setText("" + north.getLatitude());
            boxEl.addElement("south").setText("" + south.getLatitude());
            boxEl.addElement("east").setText("" + east.getLongitude());
            boxEl.addElement("west").setText("" + west.getLongitude());
            Element lodEl = regEl.addElement("Lod");
            lodEl.addElement("minLodPixels").setText("-1");
            lodEl.addElement("maxLodPixels").setText("" + bufferMaxPixels);
            lodEl.addElement("minFadeExtent").setText("-1");
            lodEl.addElement("maxFadeExtent").setText("" + (int)((double)bufferMaxPixels * 0.9));
        }
        return doc;
    }

    private static void addStyleEl(Element parent, Color c, int lineWidth, String label) {
        Element styleEl = parent.addElement("Style");
        styleEl.addAttribute("id", label);
        Element lineEl = styleEl.addElement("LineStyle");
        Element colorEl = lineEl.addElement("color");
        String hex = String.format("#%02x%02x%02x%02x", c.getAlpha(), c.getBlue(), c.getGreen(), c.getRed());
        colorEl.addText(hex);
        lineEl.addElement("width").addText("" + lineWidth);
    }

    public static GMT_Map buildMap(CPT cpt, List<LocationList> faults, double[] values, GeoDataSet griddedData, double spacing, Region region, boolean skipNans, String label) {
        GMT_Map map = new GMT_Map(region, griddedData, spacing, cpt);
        map.setBlackBackground(false);
        map.setRescaleCPT(false);
        map.setCustomScaleMin(cpt.getMinValue());
        map.setCustomScaleMax(cpt.getMaxValue());
        map.setCoast(new CoastAttributes(Color.BLACK, 0.5));
        map.setCustomLabel(label);
        map.setUseGMTSmoothing(false);
        map.setTopoResolution(null);
        map.setLabelSize(MAP_LABEL_SIZE);
        map.setLabelTickSize(MAP_LABEL_TICK_SIZE);
        if (faults != null) {
            Preconditions.checkState((faults.size() == values.length ? 1 : 0) != 0, (Object)"faults and values are different lengths!");
            ArrayList<TraceValue> vals = new ArrayList<TraceValue>();
            for (int i = 0; i < faults.size(); ++i) {
                if (skipNans && Double.isNaN(values[i])) continue;
                LocationList fault = faults.get(i);
                vals.add(new TraceValue(fault, values[i]));
            }
            Collections.sort(vals);
            for (TraceValue val : vals) {
                Color c;
                LocationList fault = val.trace;
                double value = val.value;
                if ((float)value == -1.23456E25f) {
                    c = Color.BLACK;
                    for (PSXYPolygon poly : FaultBasedMapGen.getPolygons(fault, c, 4.0 * FAULT_THICKNESS)) {
                        map.addPolys(poly);
                    }
                    continue;
                }
                c = cpt.getColor((float)value);
                for (PSXYPolygon poly : FaultBasedMapGen.getPolygons(fault, c, FAULT_THICKNESS)) {
                    map.addPolys(poly);
                }
            }
        }
        return map;
    }

    public static ArrayList<PSXYPolygon> getPolygons(LocationList locs, Color c, double thickness) {
        return FaultBasedMapGen.getPolygons(locs, c, thickness, PlotLineType.SOLID);
    }

    public static ArrayList<PSXYPolygon> getPolygons(LocationList locs, Color c, double thickness, PlotLineType lineType) {
        ArrayList<PSXYPolygon> polys = new ArrayList<PSXYPolygon>();
        for (int i = 1; i < locs.size(); ++i) {
            Location loc1 = (Location)locs.get(i - 1);
            Location loc2 = (Location)locs.get(i);
            if (thickness > 10.0) {
                loc1 = LocationUtils.location(loc1, LocationUtils.azimuthRad(loc2, loc1), 0.1 * thickness);
                loc2 = LocationUtils.location(loc2, LocationUtils.azimuthRad(loc1, loc2), 0.1 * thickness);
            }
            PSXYPolygon poly = new PSXYPolygon(loc1, loc2);
            poly.setPenColor(c);
            poly.setPenWidth(thickness);
            poly.setLineType(lineType);
            polys.add(poly);
        }
        return polys;
    }

    public static void main(String[] args) throws IOException, DocumentException, GMT_MapException, RuntimeException {
        File invSolsDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions");
        File solFile = new File(invSolsDir, "FM3_1_NEOK_EllB_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_sol.zip");
        InversionFaultSystemSolution sol = null;
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        File saveDir = new File("/tmp");
        String prefix = solFile.getName().replaceAll(".zip", "");
        boolean display = false;
        FaultBasedMapGen.plotDeformationModelSlips(region, saveDir, display);
        System.exit(0);
        FaultBasedMapGen.plotSegmentation(sol, region, saveDir, prefix, display, 7.0, 10.0);
        FaultBasedMapGen.plotSegmentation(sol, region, saveDir, prefix, display, 7.5, 10.0);
        System.exit(0);
        FaultBasedMapGen.plotSolutionSlipMisfit(sol, region, saveDir, prefix, display, true);
        FaultBasedMapGen.plotSolutionSlipMisfit(sol, region, saveDir, prefix, display, false);
        FaultSystemSolution ucerf2Sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(sol.getRupSet());
        FaultBasedMapGen.plotParticipationRatios(sol, ucerf2Sol, region, saveDir, prefix, display, 6.0, 7.0, true);
    }

    static {
        LOCAL_MAPGEN = false;
        SAVE_ZIPS = false;
        SAVE_PS = false;
        MAP_LABEL_SIZE = null;
        MAP_LABEL_TICK_SIZE = null;
        FAULT_THICKNESS = 2.0;
        slipCPT = null;
        log10_slipCPT = null;
        participationCPT = null;
        linearRatioCPT = null;
        logRatioCPT = null;
        normalizedPairRatesCPT = null;
    }

    private static class TraceValue
    implements Comparable<TraceValue> {
        private LocationList trace;
        private double value;

        public TraceValue(LocationList trace, double value) {
            this.trace = trace;
            this.value = value;
        }

        @Override
        public int compareTo(TraceValue o) {
            if (Double.isNaN(this.value) && Double.isNaN(o.value)) {
                return 0;
            }
            if (Double.isNaN(this.value)) {
                return -1;
            }
            if (Double.isNaN(o.value)) {
                return 1;
            }
            return Double.compare(this.value, o.value);
        }
    }
}

