/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotMultiDataLayer;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class FaultSpecificSegmentationPlotGen {
    public static void plotSegmentation(List<Integer> parentSects, InversionFaultSystemSolution sol, double minMag, boolean endsOnly) {
        PlotSpec spec = FaultSpecificSegmentationPlotGen.buildSegmentationPlot(parentSects, sol, minMag, endsOnly, null);
        GraphWindow gw = new GraphWindow(spec.getPlotElems(), spec.getTitle(), spec.getChars(), false);
        gw.setX_AxisLabel(spec.getXAxisLabel());
        gw.setY_AxisLabel(spec.getYAxisLabel());
        gw.getGraphWidget().getGraphPanel().setxAxisInverted(true);
        gw.setVisible(true);
    }

    public static HeadlessGraphPanel getSegmentationHeadlessGP(List<Integer> parentSects, FaultSystemSolution sol, double minMag, boolean endsOnly) throws IOException {
        return FaultSpecificSegmentationPlotGen.getSegmentationHeadlessGP(parentSects, sol, minMag, endsOnly, null);
    }

    public static HeadlessGraphPanel getSegmentationHeadlessGP(List<Integer> parentSects, FaultSystemSolution sol, double minMag, boolean endsOnly, CSVFile<String> csv) throws IOException {
        PlotSpec spec = FaultSpecificSegmentationPlotGen.buildSegmentationPlot(parentSects, sol, minMag, endsOnly, csv);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setxAxisInverted(true);
        gp.drawGraphPanel(spec);
        return gp;
    }

    private static PlotSpec buildSegmentationPlot(List<Integer> parentSects, FaultSystemSolution sol, double minMag, boolean endsOnly, CSVFile<String> csv) {
        double x;
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashMap subSectsByParent = Maps.newHashMap();
        int prevParentID = -2;
        List curSects = null;
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            FaultSection sect = rupSet.getFaultSectionData(sectIndex);
            int parent = sect.getParentSectionId();
            if (parent != prevParentID) {
                prevParentID = parent;
                curSects = Lists.newArrayList();
                subSectsByParent.put(parent, curSects);
            }
            curSects.add(sect);
        }
        for (Integer parentID : subSectsByParent.keySet()) {
            int i;
            int numToCheck;
            List subSects = (List)subSectsByParent.get(parentID);
            int num = subSects.size();
            if (num % 2 > 0) {
                --num;
            }
            if ((numToCheck = num / 2 - 1) <= 0) continue;
            int checkNum = subSects.size();
            int connectionIndex = -1;
            for (i = 0; i < numToCheck; ++i) {
                if (!FaultSpecificSegmentationPlotGen.hasConnectionOnOtherParent(parentSects, (FaultSection)subSects.get(i), sol)) continue;
                connectionIndex = i;
                break;
            }
            if (connectionIndex > 0) {
                Preconditions.checkState(((checkNum -= connectionIndex) == (subSects = subSects.subList(connectionIndex, subSects.size())).size() ? 1 : 0) != 0);
                System.out.println("Trimming off " + connectionIndex + " sub sects for parent " + parentID);
            }
            connectionIndex = -1;
            for (i = 0; i < numToCheck; ++i) {
                if (!FaultSpecificSegmentationPlotGen.hasConnectionOnOtherParent(parentSects, (FaultSection)subSects.get(subSects.size() - 1 - i), sol)) continue;
                connectionIndex = i;
                break;
            }
            if (connectionIndex > 0) {
                Preconditions.checkState(((checkNum -= connectionIndex) == (subSects = subSects.subList(0, subSects.size() - connectionIndex)).size() ? 1 : 0) != 0, (Object)(checkNum + " != " + subSects.size()));
                System.out.println("Trimming off " + connectionIndex + " sub sects for parent " + parentID);
            }
            subSectsByParent.put(parentID, subSects);
        }
        HashMap stoppingPoints = Maps.newHashMap();
        ArrayList parentSectEnds = Lists.newArrayList();
        HashMap parentSectNamesMap = Maps.newHashMap();
        double toleranceKM = 3.0;
        boolean normalize = true;
        for (Integer parent : parentSects) {
            int i;
            List sects = (List)subSectsByParent.get(parent);
            if (sects == null) continue;
            Location parentStart = ((FaultSection)sects.get(0)).getFaultTrace().first();
            Location parentEnd = ((FaultSection)sects.get(sects.size() - 1)).getFaultTrace().last();
            Location midPt = new Location(0.5 * (parentStart.getLatitude() + parentEnd.getLatitude()), 0.5 * (parentStart.getLongitude() + parentEnd.getLongitude()));
            parentSectNamesMap.put(midPt, ((FaultSection)sects.get(0)).getParentSectionName());
            ArrayList sectStoppingPoints = Lists.newArrayList();
            for (i = 0; i < sects.size(); ++i) {
                FaultSection sect = (FaultSection)sects.get(i);
                FaultTrace trace = sect.getFaultTrace();
                sectStoppingPoints.add((Location)trace.get(0));
                if (i != sects.size() - 1) continue;
                sectStoppingPoints.add((Location)trace.get(trace.size() - 1));
            }
            for (i = 0; i < sectStoppingPoints.size(); ++i) {
                Location parentTestLoc;
                List<Integer> startSects;
                if (endsOnly && i > 0 && i < sectStoppingPoints.size() - 1) continue;
                Location loc = (Location)sectStoppingPoints.get(i);
                Location testLoc = FaultSpecificSegmentationPlotGen.searchForMatch(loc, stoppingPoints.keySet(), toleranceKM);
                if (testLoc == null) {
                    startSects = Lists.newArrayList();
                    stoppingPoints.put(loc, startSects);
                    parentTestLoc = FaultSpecificSegmentationPlotGen.searchForMatch(loc, stoppingPoints.keySet(), 5.0);
                    if (parentTestLoc == null) {
                        parentTestLoc = loc;
                    }
                } else {
                    startSects = (List)stoppingPoints.get(testLoc);
                    parentTestLoc = testLoc;
                }
                if (i == 0) {
                    startSects.add(((FaultSection)sects.get(0)).getSectionId());
                    if (testLoc != null) continue;
                    parentSectEnds.add(loc);
                    continue;
                }
                if (i == sectStoppingPoints.size() - 1) {
                    startSects.add(((FaultSection)sects.get(sects.size() - 1)).getSectionId());
                    if (testLoc != null) continue;
                    parentSectEnds.add(loc);
                    continue;
                }
                startSects.add(((FaultSection)sects.get(i - 1)).getSectionId());
                startSects.add(((FaultSection)sects.get(i)).getSectionId());
            }
        }
        ArbitrarilyDiscretizedFunc stopFunc = new ArbitrarilyDiscretizedFunc();
        stopFunc.setName("Fract of rate that stops at this point");
        ArbitrarilyDiscretizedFunc continueFunc = new ArbitrarilyDiscretizedFunc();
        continueFunc.setName("Fract of rate that continues through this point");
        Object info = null;
        ArrayList stoppingKeysSorted = Lists.newArrayList();
        stoppingKeysSorted.addAll(stoppingPoints.keySet());
        Collections.sort(stoppingKeysSorted, new Comparator<Location>(){

            @Override
            public int compare(Location o1, Location o2) {
                return -Double.compare(o1.getLatitude(), o2.getLatitude());
            }
        });
        HashMap rupStopCountMap = Maps.newHashMap();
        HashMap rupStopLocationsMap = Maps.newHashMap();
        if (csv != null) {
            Preconditions.checkState((!csv.isStrictRowSizes() ? 1 : 0) != 0, (Object)"Strict row sizes not supported");
            csv.addLine((String[])new String[]{"Latitude", "Longitude", "Stop Rate (/yr)", "Continue Rate (/yr)", "Normalized Stop Rate", "Normalized Continue Rate", "Sections"});
        }
        for (Location loc : stoppingKeysSorted) {
            List sects = (List)stoppingPoints.get(loc);
            double stopRate = 0.0;
            double continueRate = 0.0;
            HashSet<Integer> alreadyCounted = new HashSet<Integer>();
            Iterator iterator = sects.iterator();
            while (iterator.hasNext()) {
                int sectIndex = (Integer)iterator.next();
                for (int rupIndex : rupSet.getRupturesForSection(sectIndex)) {
                    if (alreadyCounted.contains(rupIndex) || rupSet.getMagForRup(rupIndex) < minMag) continue;
                    double rate = sol.getRateForRup(rupIndex);
                    List<Integer> sectsForRup = rupSet.getSectionsIndicesForRup(rupIndex);
                    boolean stoppingPoint = false;
                    if (sectsForRup.size() == 1 || sectIndex == sectsForRup.get(0) && !sects.contains(sectsForRup.get(1))) {
                        stoppingPoint = true;
                    } else if (sectIndex == sectsForRup.get(sectsForRup.size() - 1) && !sects.contains(sectsForRup.get(sectsForRup.size() - 2))) {
                        stoppingPoint = true;
                    }
                    if (stoppingPoint) {
                        List ends = (List)rupStopCountMap.get(rupIndex);
                        List endLocs = (List)rupStopLocationsMap.get(rupIndex);
                        if (ends == null) {
                            ends = Lists.newArrayList();
                            rupStopCountMap.put(rupIndex, ends);
                            endLocs = Lists.newArrayList();
                            rupStopLocationsMap.put(rupIndex, endLocs);
                        }
                        ends.add(sectIndex);
                        endLocs.add(loc);
                        if (sol instanceof InversionFaultSystemSolution && ends.size() > 2) {
                            Object endsStr = null;
                            for (int i = 0; i < ends.size(); ++i) {
                                endsStr = i == 0 ? "" : (String)endsStr + ", ";
                                endsStr = (String)endsStr + String.valueOf(ends.get(i)) + " [" + Joiner.on((String)",").join((Iterable)stoppingPoints.get(endLocs.get(i))) + "]";
                            }
                            throw new IllegalStateException("Stop count over 2 for rup " + rupIndex + ". Stops at: " + (String)endsStr);
                        }
                    }
                    if (stoppingPoint) {
                        stopRate += rate;
                    } else {
                        continueRate += rate;
                    }
                    alreadyCounted.add(rupIndex);
                }
            }
            double tot = stopRate + continueRate;
            double normStopRate = stopRate / tot;
            double normContinueRate = continueRate / tot;
            if (csv != null) {
                ArrayList line = Lists.newArrayList((Object[])new String[]{"" + loc.getLatitude(), "" + loc.getLongitude(), "" + stopRate, "" + continueRate, "" + normStopRate, "" + normContinueRate});
                Iterator iterator2 = sects.iterator();
                while (iterator2.hasNext()) {
                    int sect = (Integer)iterator2.next();
                    line.add(rupSet.getFaultSectionData(sect).getName());
                }
                csv.addLine(line);
            }
            Preconditions.checkState((stopFunc.getXIndex(x = loc.getLatitude()) == -1 ? 1 : 0) != 0, (Object)("duplicate latitude!! " + String.valueOf(loc)));
            if (normStopRate > 0.075) {
                info = info == null ? "" : (String)info + "\n";
                Object parents = null;
                Iterator iterator3 = sects.iterator();
                while (iterator3.hasNext()) {
                    int sectID = (Integer)iterator3.next();
                    String parentName = rupSet.getFaultSectionData(sectID).getParentSectionName();
                    parents = parents == null ? "" : (String)parents + ", ";
                    parents = (String)parents + parentName;
                }
                info = (String)info + "Lat=" + (float)loc.getLatitude() + "\tnumSects=" + sects.size() + "\tparents=(" + parents + ")\n\tstopRate=" + stopRate + "\tcontinueRate=" + continueRate + "\tnormStopRate=" + normStopRate;
            }
            if (normalize) {
                stopFunc.set(x, normStopRate);
                continueFunc.set(x, normContinueRate);
                continue;
            }
            stopFunc.set(x, stopRate);
            continueFunc.set(x, continueRate);
        }
        stopFunc.setInfo((String)info);
        PlotMultiDataLayer sectEnds = new PlotMultiDataLayer();
        sectEnds.setInfo("Parent Section End Points");
        for (Location loc : parentSectEnds) {
            sectEnds.addVerticalLine(loc.getLatitude(), 0.0, 1.5);
        }
        System.out.println("Parent stopping pts: " + parentSectEnds.size());
        ArrayList funcs = Lists.newArrayList();
        funcs.add(continueFunc);
        funcs.add(stopFunc);
        funcs.add(sectEnds);
        ArrayList chars = Lists.newArrayList();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 5.0f, Color.GREEN.darker()));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_SQUARE, 5.0f, Color.RED));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.GRAY));
        Object title = "Fault Segmentation";
        title = minMag > 5.0 ? (String)title + " (" + (float)minMag + "+)" : (String)title + " (All Mags)";
        PlotSpec spec = new PlotSpec(funcs, chars, (String)title, "Latitude", "Rate Ratio");
        Font font = new Font("Serif", 0, 16);
        double angle = -1.5707963267948966;
        TextAnchor rotAnchor = TextAnchor.CENTER_RIGHT;
        TextAnchor textAnchor = TextAnchor.CENTER_RIGHT;
        ArrayList annotations = Lists.newArrayList();
        for (Location loc : parentSectNamesMap.keySet()) {
            String name = (String)parentSectNamesMap.get(loc);
            if (name.contains("San Andreas")) {
                name = name.replaceAll("San Andreas", "").replaceAll("\\(", "").replaceAll("\\)", "");
            }
            name = name.replaceAll("2011 CFM", "");
            name = name.trim();
            x = loc.getLatitude();
            XYTextAnnotation a = new XYTextAnnotation(name, x, 1.5);
            a.setFont(font);
            a.setRotationAnchor(rotAnchor);
            a.setTextAnchor(textAnchor);
            a.setRotationAngle(angle);
            annotations.add(a);
        }
        spec.setPlotAnnotations(annotations);
        return spec;
    }

    private static boolean hasConnectionOnOtherParent(List<Integer> parents, FaultSection subSect, FaultSystemSolution sol) {
        Collection<Object> connections;
        FaultSystemRupSet rupSet = sol.getRupSet();
        if (rupSet instanceof InversionFaultSystemRupSet) {
            connections = ((InversionFaultSystemRupSet)rupSet).getCloseSectionsList(subSect.getSectionId());
        } else {
            connections = new HashSet();
            for (int rupIndex : rupSet.getRupturesForSection(subSect.getSectionId())) {
                for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                    connections.add(sectIndex);
                }
            }
        }
        int parentID = subSect.getParentSectionId();
        Iterator<Object> iterator = connections.iterator();
        while (iterator.hasNext()) {
            int connection = (Integer)iterator.next();
            int connectionParent = sol.getRupSet().getFaultSectionData(connection).getParentSectionId();
            if (connectionParent == parentID || !parents.contains(connectionParent)) continue;
            return true;
        }
        return false;
    }

    private static Location searchForMatch(Location loc, Collection<Location> locs, double toleranceKM) {
        double best = Double.MAX_VALUE;
        Location bestLoc = null;
        for (Location testLoc : locs) {
            double dist = LocationUtils.horzDistance(loc, testLoc);
            if (!(dist < best) || !(dist <= toleranceKM)) continue;
            best = dist;
            bestLoc = testLoc;
        }
        return bestLoc;
    }

    public static List<Integer> getSAFParents(FaultModels fm) {
        if (fm == FaultModels.FM2_1) {
            return Lists.newArrayList((Object[])new Integer[]{295, 284, 283, 119, 301, 286, 287, 300, 285, 32, 57, 56, 67, 27, 26, 13});
        }
        if (fm == FaultModels.FM3_1) {
            return Lists.newArrayList((Object[])new Integer[]{97, 170, 295, 284, 283, 282, 301, 286, 287, 300, 285, 32, 658, 657, 655, 654, 653, 13});
        }
        return Lists.newArrayList((Object[])new Integer[]{97, 171, 295, 284, 283, 282, 301, 286, 287, 300, 285, 32, 658, 657, 655, 654, 653, 13});
    }

    public static List<Integer> getHaywardParents(FaultModels fm) {
        return fm.getNamedFaultsMapAlt().get("Hayward-Rodgers Creek");
    }

    public static void main(String[] args) throws IOException, DocumentException {
        double[] minMags;
        File solFile = new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip");
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(solFile);
        List<Integer> safParentSects31 = FaultSpecificSegmentationPlotGen.getSAFParents(FaultModels.FM3_1);
        List<Integer> safParentSects21 = FaultSpecificSegmentationPlotGen.getSAFParents(FaultModels.FM2_1);
        File writeDir = new File("/tmp/branch_avg");
        Preconditions.checkState((writeDir.exists() || writeDir.mkdir() ? 1 : 0) != 0);
        FaultSystemSolution ucerf2Sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(FaultModels.FM2_1);
        for (double minMag : minMags = new double[]{0.0, 7.0, 7.5}) {
            CSVFile<String> csv = new CSVFile<String>(false);
            HeadlessGraphPanel gp = FaultSpecificSegmentationPlotGen.getSegmentationHeadlessGP(safParentSects31, sol, minMag, false, csv);
            Object prefix = "ucerf3_saf_seg";
            if (minMag > 0.0) {
                prefix = (String)prefix + (float)minMag + "+";
            }
            File file = new File(writeDir, (String)prefix);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
            csv.writeToFile(new File(file.getAbsolutePath() + ".csv"));
            csv = new CSVFile(false);
            gp = FaultSpecificSegmentationPlotGen.getSegmentationHeadlessGP(safParentSects21, ucerf2Sol, minMag, false, csv);
            prefix = "ucerf2_saf_seg";
            if (minMag > 0.0) {
                prefix = (String)prefix + (float)minMag + "+";
            }
            file = new File(writeDir, (String)prefix);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsTXT(file.getAbsolutePath() + ".txt");
            csv.writeToFile(new File(file.getAbsolutePath() + ".csv"));
        }
    }
}

