/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.griddedSeismicity.GriddedSeisUtils;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.U3InversionTargetMFDs;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.inversion.UCERF3InversionInputGenerator;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.DeformationModelOffFaultMoRateData;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3SectionMFD_constraint;
import scratch.UCERF3.utils.UCERF2_A_FaultMapper;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;

public class FaultSystemRupSetCalc {
    static final boolean D = false;

    public static double getMeanMinMag(InversionFaultSystemRupSet fltSysRupSet, boolean wtByMoRate) {
        return FaultSystemRupSetCalc.getMeanMinMag(fltSysRupSet, fltSysRupSet.getModule(ModSectMinMags.class), wtByMoRate);
    }

    public static double getMeanMinMag(FaultSystemRupSet fltSysRupSet, ModSectMinMags finalMinMags, boolean wtByMoRate) {
        double wt = 1.0;
        double totWt = 0.0;
        double sum = 0.0;
        for (int i = 0; i < fltSysRupSet.getNumSections(); ++i) {
            if (wtByMoRate && Double.isNaN(wt = fltSysRupSet.getFaultSectionData(i).calcMomentRate(true))) {
                wt = 0.0;
            }
            sum += finalMinMags.getMinMagForSection(i) * wt;
            totWt += wt;
        }
        return sum / totWt;
    }

    public static HistogramFunction getOrigMinMagHistogram(FaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag, boolean wtByMoRate) {
        HistogramFunction hist = new HistogramFunction(minMag, numMag, deltaMag);
        double wt = 1.0;
        for (int i = 0; i < faultSystemRupSet.getNumSections(); ++i) {
            if (wtByMoRate) {
                wt = faultSystemRupSet.getAreaForSection(i) * faultSystemRupSet.getSlipRateForSection(i);
            }
            double min = faultSystemRupSet.getMinMagForSection(i);
            if (Double.isNaN(wt)) continue;
            hist.add(min, wt);
        }
        hist.setName("Orig Min Mag Histogram for FaultSystemRupSet");
        hist.setInfo("(among the " + faultSystemRupSet.getNumSections() + " sections; wtByMoRate=" + wtByMoRate + ")");
        hist.normalizeBySumOfY_Vals();
        return hist;
    }

    public static HistogramFunction getFinalMinMagHistogram(InversionFaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag, boolean wtByMoRate) {
        HistogramFunction hist = new HistogramFunction(minMag, numMag, deltaMag);
        double wt = 1.0;
        for (int i = 0; i < faultSystemRupSet.getNumSections(); ++i) {
            if (wtByMoRate) {
                wt = faultSystemRupSet.getAreaForSection(i) * faultSystemRupSet.getSlipRateForSection(i);
            }
            double min = faultSystemRupSet.getFinalMinMagForSection(i);
            if (Double.isNaN(wt)) continue;
            hist.add(min, wt);
        }
        hist.setName("Final Min Mag Histogram for FaultSystemRupSet");
        hist.setInfo("(among the " + faultSystemRupSet.getNumSections() + " sections; wtByMoRate=" + wtByMoRate + ")");
        hist.normalizeBySumOfY_Vals();
        return hist;
    }

    public static HistogramFunction getMaxMagHistogram(FaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag, boolean wtByMoRate) {
        HistogramFunction hist = new HistogramFunction(minMag, numMag, deltaMag);
        double wt = 1.0;
        for (int i = 0; i < faultSystemRupSet.getNumSections(); ++i) {
            if (wtByMoRate) {
                wt = faultSystemRupSet.getAreaForSection(i) * faultSystemRupSet.getSlipRateForSection(i);
            }
            double max = faultSystemRupSet.getMaxMagForSection(i);
            if (Double.isNaN(wt)) continue;
            hist.add(max, wt);
        }
        hist.setName("Max Mag Histogram for FaultSystemRupSet");
        hist.setInfo("(among the " + faultSystemRupSet.getNumSections() + " sections)");
        hist.normalizeBySumOfY_Vals();
        return hist;
    }

    public static HistogramFunction getMagHistogram(InversionFaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag) {
        HistogramFunction hist = new HistogramFunction(minMag, numMag, deltaMag);
        for (int r = 0; r < faultSystemRupSet.getNumRuptures(); ++r) {
            if (faultSystemRupSet.isRuptureBelowSectMinMag(r)) continue;
            hist.add(faultSystemRupSet.getMagForRup(r), 1.0);
        }
        hist.setName("Mag Histogram for FaultSystemRupSet");
        hist.setInfo("(based on " + faultSystemRupSet.getNumRuptures() + " ruptures)");
        return hist;
    }

    public static HistogramFunction getLengthHistogram(FaultSystemRupSet faultSystemRupSet, double minLength, int numLengths, double deltaLength) {
        HistogramFunction hist = new HistogramFunction(minLength, numLengths, deltaLength);
        for (int r = 0; r < faultSystemRupSet.getNumRuptures(); ++r) {
            double length = 0.0;
            for (int sectID : faultSystemRupSet.getSectionsIndicesForRup(r)) {
                length += faultSystemRupSet.getFaultSectionData(sectID).getTraceLength();
            }
            hist.add(length, 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        hist.setName("Length Histogram for FaultSystemRupSet");
        hist.setInfo("(based on " + faultSystemRupSet.getNumRuptures() + " ruptures)");
        return hist;
    }

    public static void plotAllHistograms(InversionFaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag, boolean wtByMoRate) {
        ArrayList<HistogramFunction> hists = new ArrayList<HistogramFunction>();
        hists.add(FaultSystemRupSetCalc.getMagHistogram(faultSystemRupSet, minMag, numMag, deltaMag));
        hists.add(FaultSystemRupSetCalc.getMaxMagHistogram(faultSystemRupSet, minMag, numMag, deltaMag, wtByMoRate));
        hists.add(FaultSystemRupSetCalc.getOrigMinMagHistogram(faultSystemRupSet, minMag, numMag, deltaMag, wtByMoRate));
        hists.add(((HistogramFunction)hists.get(0)).getCumulativeDistFunction());
        ((HistogramFunction)hists.get(3)).setName("Cumulative " + ((HistogramFunction)hists.get(0)).getName());
        ((HistogramFunction)hists.get(3)).setInfo(((HistogramFunction)hists.get(0)).getInfo());
        hists.add(((HistogramFunction)hists.get(1)).getCumulativeDistFunction());
        ((HistogramFunction)hists.get(4)).setName("Cumulative " + ((HistogramFunction)hists.get(1)).getName());
        ((HistogramFunction)hists.get(4)).setInfo(((HistogramFunction)hists.get(1)).getInfo());
        hists.add(((HistogramFunction)hists.get(2)).getCumulativeDistFunction());
        ((HistogramFunction)hists.get(5)).setName("Cumulative " + ((HistogramFunction)hists.get(2)).getName());
        ((HistogramFunction)hists.get(5)).setInfo(((HistogramFunction)hists.get(2)).getInfo());
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        list.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        list.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        list.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        list.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        list.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        GraphWindow graph = new GraphWindow(hists, "Histograms", list);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Normalized Number");
    }

    public static HistogramFunction getMomentRateReductionHistogram(InversionFaultSystemRupSet faultSystemRupSet, boolean wtByMoRate, boolean plotResult) {
        HistogramFunction hist = new HistogramFunction(0.005, 100, 0.01);
        double wt = 1.0;
        double mean = 0.0;
        double totWt = 0.0;
        for (int i = 0; i < faultSystemRupSet.getNumSections(); ++i) {
            if (wtByMoRate) {
                wt = faultSystemRupSet.getAreaForSection(i) * faultSystemRupSet.getSlipRateForSection(i);
            }
            if (Double.isNaN(wt)) continue;
            double reduction = faultSystemRupSet.getMomentRateReductionFraction(i);
            if (Double.isNaN(reduction)) {
                System.out.println("NaN reduction for section: " + faultSystemRupSet.getFaultSectionData(i).getName() + " with slip: " + faultSystemRupSet.getSlipRateForSection(i));
                continue;
            }
            hist.add(reduction, wt);
            mean += reduction * wt;
            totWt += wt;
            if (!(reduction > 0.5)) continue;
            System.out.println(reduction + "\t" + faultSystemRupSet.getFaultSectionData(i).getName() + "\tmagLower=" + (float)faultSystemRupSet.getFinalMinMagForSection(i) + "\tmagUpper=" + (float)faultSystemRupSet.getMaxMagForSection(i));
        }
        hist.setName("Distribution of Moment Rate Reductions for FaultSystemRupSet");
        hist.setInfo("(among the " + faultSystemRupSet.getNumSections() + " sections; mean = " + (float)(mean /= totWt) + ")");
        hist.normalizeBySumOfY_Vals();
        if (plotResult) {
            GraphWindow graph = new GraphWindow(hist, "Moment Rate Reductions Histogram");
            graph.setX_AxisLabel("Reduction");
            graph.setY_AxisLabel("Normalized Number");
        }
        return hist;
    }

    public static void listAllParentSectionNames(FaultSystemRupSet faultSystemRupSet) {
        ArrayList<String> parNames = new ArrayList<String>();
        for (FaultSection faultSection : faultSystemRupSet.getFaultSectionDataList()) {
            if (parNames.contains(faultSection.getParentSectionName())) continue;
            parNames.add(faultSection.getParentSectionName());
        }
        for (String string : parNames) {
            System.out.println(string);
        }
    }

    public static void plotImpliedTotalSectGR_MFD(InversionFaultSystemRupSet faultSysRupSet, String label) {
        SummedMagFreqDist impliedGR = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(faultSysRupSet, 0.05, 90, 0.1);
        double mMax = faultSysRupSet.getMaxMag();
        double mMaxRounded = impliedGR.getX(impliedGR.getClosestXIndex(mMax));
        GutenbergRichterMagFreqDist totTargetMoMatched = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxRounded, impliedGR.getTotalMomentRate(), 1.0);
        totTargetMoMatched.setName("Perfect GR, matching def mod moment");
        totTargetMoMatched.setInfo("(up to mag of largest event in fault system; MoRate =" + (float)totTargetMoMatched.getTotalMomentRate() + "; Rate ge M5 = " + (float)totTargetMoMatched.getCumRate(5.05) + ")");
        GutenbergRichterMagFreqDist totTargetRateMatched = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxRounded, 1.0, 1.0);
        TotalMag5Rate rate = TotalMag5Rate.RATE_7p9;
        totTargetRateMatched.scaleToCumRate(0, rate.getRateMag5() * 100000.0);
        totTargetRateMatched.setName("Perfect GR, matching regional rate");
        totTargetRateMatched.setInfo("(up to mag of largest event in fault system; MoRate =" + (float)totTargetRateMatched.getTotalMomentRate() + "; Rate ge M5 = " + (float)totTargetRateMatched.getCumRate(5.05) + ")");
        double fractOn = faultSysRupSet.getInversionTargetMFDs().getFractionSeisOnFault();
        GutenbergRichterMagFreqDist totTargetOnFault = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxRounded, 1.0, 1.0);
        totTargetOnFault.scaleToCumRate(0, fractOn * rate.getRateMag5() * 100000.0);
        totTargetOnFault.setName("On Fault Target");
        totTargetOnFault.setInfo("(MoRate =" + (float)totTargetOnFault.getTotalMomentRate() + "; Rate ge M5 = " + (float)totTargetOnFault.getCumRate(5.05) + ")");
        double mMaxOff = faultSysRupSet.getInversionTargetMFDs().getMmaxOffFault();
        GutenbergRichterMagFreqDist totTargetOffFault = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxRounded, 1.0, 1.0);
        totTargetOffFault.scaleToCumRate(0, (1.0 - fractOn) * rate.getRateMag5() * 100000.0);
        totTargetOffFault.zeroAboveMag(mMaxOff);
        totTargetOffFault.setName("Off Fault Target");
        totTargetOffFault.setInfo("(MoRate =" + (float)totTargetOffFault.getTotalMomentRate() + "; Rate ge M5 = " + (float)totTargetOffFault.getCumRate(5.05) + ")");
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        funcs.add(impliedGR);
        funcs.add(totTargetMoMatched);
        funcs.add(totTargetRateMatched);
        funcs.add(totTargetOnFault);
        funcs.add(totTargetOffFault);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.LIGHT_GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.ORANGE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.GREEN));
        String morelabel = " (M>=5 rate = " + (float)Math.round(impliedGR.getCumRate(5.05) * 10.0) / 10.0f + ")";
        if (faultSysRupSet.getFaultModel() == FaultModels.FM2_1) {
            morelabel = morelabel + " -- Mendocino included!";
        }
        GraphWindow graph = new GraphWindow(funcs, label + morelabel, plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-5, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        String fileName = "TargetGR_" + label + ".pdf";
        if (fileName != null) {
            try {
                graph.saveAsPDF(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList<EvenlyDiscretizedFunc> funcsCum = new ArrayList<EvenlyDiscretizedFunc>();
        funcsCum.add(impliedGR.getCumRateDistWithOffset());
        funcsCum.add(totTargetMoMatched.getCumRateDistWithOffset());
        funcsCum.add(totTargetRateMatched.getCumRateDistWithOffset());
        funcsCum.add(totTargetOnFault.getCumRateDistWithOffset());
        funcsCum.add(totTargetOffFault.getCumRateDistWithOffset());
        GraphWindow graphCum = new GraphWindow(funcsCum, label + morelabel, plotChars);
        graphCum.setX_AxisRange(5.0, 9.0);
        graphCum.setY_AxisRange(1.0E-5, 20.0);
        graphCum.setYLog(true);
        graphCum.setX_AxisLabel("Mag");
        graphCum.setY_AxisLabel("Rate (per year)");
        graphCum.setTickLabelFontSize(14);
        graphCum.setAxisLabelFontSize(16);
        graphCum.setPlotLabelFontSize(18);
        String fileNameCum = "TargetGR_Cum_" + label + ".pdf";
        if (fileName != null) {
            try {
                graphCum.saveAsPDF(fileNameCum);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static SummedMagFreqDist calcImpliedGR_NucleationMFD(FaultSystemRupSet rupSet, double minMag, int numMag, double deltaMag) {
        ArrayList<GutenbergRichterMagFreqDist> gr_mfds = FaultSystemRupSetCalc.calcImpliedGR_NuclMFD_ForEachSection(rupSet, minMag, numMag, deltaMag);
        SummedMagFreqDist mfd = new SummedMagFreqDist(minMag, numMag, deltaMag);
        for (GutenbergRichterMagFreqDist gr : gr_mfds) {
            mfd.addIncrementalMagFreqDist(gr);
        }
        mfd.setName(rupSet.getName() + " Target GR MFD");
        mfd.setInfo("Rate ge M5 = " + (float)mfd.getCumRate(5.05) + "; totMoRate = " + (float)mfd.getTotalMomentRate());
        return mfd;
    }

    public static ArrayList<GutenbergRichterMagFreqDist> calcImpliedGR_NuclMFD_ForEachSection(FaultSystemRupSet faultSysRupSet, double minMag, int numMag, double deltaMag) {
        List<? extends FaultSection> sectDataList = faultSysRupSet.getFaultSectionDataList();
        ArrayList<GutenbergRichterMagFreqDist> mfds = new ArrayList<GutenbergRichterMagFreqDist>();
        GutenbergRichterMagFreqDist tempGR = new GutenbergRichterMagFreqDist(minMag, numMag, deltaMag);
        for (int i = 0; i < sectDataList.size(); ++i) {
            FaultSection sectData = sectDataList.get(i);
            int mMaxIndex = tempGR.getClosestXIndex(faultSysRupSet.getMaxMagForSection(i));
            double mMax = tempGR.getX(mMaxIndex);
            double moRate = sectData.calcMomentRate(true);
            if (Double.isNaN(moRate)) {
                moRate = 0.0;
            }
            GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(minMag, numMag, deltaMag, minMag, mMax, moRate, 1.0);
            mfds.add(gr);
        }
        return mfds;
    }

    public static void plotAllImpliedTotalSectGR_MFD() {
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        scalingRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scalingRelList.add(ScalingRelationships.SHAW_2009_MOD);
        ArrayList<DeformationModels> defModList = new ArrayList<DeformationModels>();
        FaultModels fm = FaultModels.FM3_1;
        defModList.add(DeformationModels.ABM);
        defModList.add(DeformationModels.GEOLOGIC);
        defModList.add(DeformationModels.NEOKINEMA);
        defModList.add(DeformationModels.ZENGBB);
        for (DeformationModels dm : defModList) {
            for (ScalingRelationships sr : scalingRelList) {
                InversionFaultSystemRupSet faultSysRupSet = InversionFaultSystemRupSetFactory.forBranch(fm, dm, sr, SlipAlongRuptureModels.TAPERED, InversionModels.GR_CONSTRAINED);
                String label = faultSysRupSet.getDeformationModel().getShortName() + "_" + sr.getShortName();
                FaultSystemRupSetCalc.plotImpliedTotalSectGR_MFD(faultSysRupSet, label);
            }
        }
    }

    public static String oldTestInversionGR_Setup(double totRegionalM5_Rate, double fractSeisOffFault, double mMaxOffFault, InversionFaultSystemRupSet faultSysRupSet) {
        FaultModels fm = faultSysRupSet.getFaultModel();
        DeformationModels dm = faultSysRupSet.getDeformationModel();
        double offFaultRate = totRegionalM5_Rate * fractSeisOffFault;
        double onFaultRate = totRegionalM5_Rate - offFaultRate;
        SummedMagFreqDist mfd = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(faultSysRupSet, 0.05, 90, 0.1);
        double onCoupCoeff = onFaultRate / mfd.getCumRate(5.05);
        double onFaultOrigMoRate = mfd.getTotalMomentRate();
        double onFaultReducedMoRate = onCoupCoeff * onFaultOrigMoRate;
        GutenbergRichterMagFreqDist offFaultGR = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxOffFault, 1.0, 1.0);
        offFaultGR.scaleToCumRate(0, offFaultRate * 100000.0);
        DeformationModelOffFaultMoRateData defModOffFaultMoRateData = DeformationModelOffFaultMoRateData.getInstance();
        double offFaultOrigMoRate = defModOffFaultMoRateData.getTotalOffFaultMomentRate(fm, dm);
        double offFaultReducedMoRate = offFaultGR.getTotalMomentRate();
        GutenbergRichterMagFreqDist tempOffFaultGR = new GutenbergRichterMagFreqDist(0.005, 900, 0.01);
        tempOffFaultGR.setAllButMagUpper(0.005, offFaultOrigMoRate, offFaultRate * 100000.0, 1.0, true);
        double maxOffMagWithFullMoment = tempOffFaultGR.getMagUpper();
        double offCoupCoeff = offFaultReducedMoRate / offFaultOrigMoRate;
        double moRateReduction = (onFaultReducedMoRate + offFaultReducedMoRate) / (onFaultOrigMoRate + offFaultOrigMoRate);
        double aveMinSeismoMag = FaultSystemRupSetCalc.getMeanMinMag(faultSysRupSet, true);
        return (float)mfd.getMaxMagWithNonZeroRate() + "\t" + (float)onCoupCoeff + "\t" + (float)offCoupCoeff + "\t" + (float)moRateReduction + "\t" + (float)onFaultOrigMoRate + "\t" + (float)onFaultReducedMoRate + "\t" + (float)offFaultOrigMoRate + "\t" + (float)offFaultReducedMoRate + "\t" + (float)maxOffMagWithFullMoment + "\t" + (float)aveMinSeismoMag;
    }

    public static String getInversionSetupInfo(FaultSystemRupSet faultSysRupSet) {
        String header = "DefMod\tM(A)\tRge5\tfrSeisOff\tmMaxOff\tmMaxOn\tonCoupCoeff\toffCoupCoeff\tfrMoRateReduct\tonFltOrigMoRate\tonFltReducMoRate\toffFltOrigMoRate\toffFltReducMoRate\tmMaxOffWithFullMo\taveMinSeismoMag";
        return header;
    }

    public static String oldTestInversionCharSetup(double totRegionalM5_Rate, double fractSeisOffFault, double mMaxOffFault, InversionFaultSystemRupSet faultSysRupSet) {
        FaultModels fm = faultSysRupSet.getFaultModel();
        DeformationModels dm = faultSysRupSet.getDeformationModel();
        double offFaultMgt5_Rate = totRegionalM5_Rate * fractSeisOffFault;
        double totOnFaultMgt5_Rate = totRegionalM5_Rate - offFaultMgt5_Rate;
        DeformationModelOffFaultMoRateData defModOffFaultMoRateData = DeformationModelOffFaultMoRateData.getInstance();
        double offFaultOrigMoRate = defModOffFaultMoRateData.getTotalOffFaultMomentRate(fm, dm);
        double onFaultOrigMoRate = 0.0;
        double mMaxInRegion = 0.0;
        List<? extends FaultSection> sectDataList = faultSysRupSet.getFaultSectionDataList();
        for (int i = 0; i < sectDataList.size(); ++i) {
            double mMax = (double)Math.round(10.0 * (faultSysRupSet.getMaxMagForSection(i) - 0.05)) / 10.0 + 0.05;
            double moRate = sectDataList.get(i).calcMomentRate(true);
            if (Double.isNaN(moRate)) {
                moRate = 0.0;
            }
            if (mMax > mMaxInRegion) {
                mMaxInRegion = mMax;
            }
            onFaultOrigMoRate += moRate;
        }
        GutenbergRichterMagFreqDist totGR = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxInRegion, 1.0, 1.0);
        totGR.scaleToCumRate(0, totRegionalM5_Rate * 100000.0);
        double moRateReduction = totGR.getTotalMomentRate() / (onFaultOrigMoRate + offFaultOrigMoRate);
        double aveMinSeismoMag = FaultSystemRupSetCalc.getMeanMinMag(faultSysRupSet, true);
        IncrementalMagFreqDist offFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(totGR, totOnFaultMgt5_Rate, aveMinSeismoMag, mMaxOffFault);
        IncrementalMagFreqDist onFaultMFD = new IncrementalMagFreqDist(totGR.getMinX(), totGR.size(), totGR.getDelta());
        for (int i = 0; i < onFaultMFD.size(); ++i) {
            onFaultMFD.set(i, totGR.getY(i) - offFaultMFD.getY(i));
        }
        IncrementalMagFreqDist testOffFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(offFaultOrigMoRate, totGR, totOnFaultMgt5_Rate, aveMinSeismoMag);
        double maxOffMagWithFullMoment = testOffFaultMFD != null ? testOffFaultMFD.getMaxMagWithNonZeroRate() : Double.NaN;
        double offFaultReducedMoRate = offFaultMFD.getTotalMomentRate();
        double offCoupCoeff = offFaultReducedMoRate / offFaultOrigMoRate;
        double onFaultReducedMoRate = onFaultMFD.getTotalMomentRate();
        double onCoupCoeff = onFaultReducedMoRate / onFaultOrigMoRate;
        return (float)mMaxInRegion + "\t" + (float)onCoupCoeff + "\t" + (float)offCoupCoeff + "\t" + (float)moRateReduction + "\t" + (float)onFaultOrigMoRate + "\t" + (float)onFaultReducedMoRate + "\t" + (float)offFaultOrigMoRate + "\t" + (float)offFaultReducedMoRate + "\t" + maxOffMagWithFullMoment + "\t" + (float)aveMinSeismoMag;
    }

    public static IncrementalMagFreqDist[] old_getCharOnFaultTargetMFD(GutenbergRichterMagFreqDist totalTargetGR, double totOnFaultMgt5_Rate, int mMaxOffFaultIndex) {
        int i;
        GutenbergRichterMagFreqDist tempGR;
        int transMagIndex = mMaxOffFaultIndex + 1;
        int mag5_Index = totalTargetGR.getXIndex(5.05);
        double onFaultRateBelowTransMag = totOnFaultMgt5_Rate - totalTargetGR.getCumRate(transMagIndex);
        ArbitrarilyDiscretizedFunc rateVsBvalueFunc = new ArbitrarilyDiscretizedFunc();
        double b_incr = 0.01;
        for (double b = -1.0; b <= 1.0; b += b_incr) {
            tempGR = new GutenbergRichterMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta(), totalTargetGR.getMagLower(), totalTargetGR.getMagUpper(), 1.0, b);
            tempGR.scaleToIncrRate(transMagIndex, totalTargetGR.getY(transMagIndex));
            double testOnFaultRateBelowTransMag = tempGR.getCumRate(mag5_Index) - tempGR.getCumRate(transMagIndex);
            rateVsBvalueFunc.set(testOnFaultRateBelowTransMag, b);
        }
        double bVal = rateVsBvalueFunc.getInterpolatedY(onFaultRateBelowTransMag);
        tempGR = new GutenbergRichterMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta(), totalTargetGR.getMagLower(), totalTargetGR.getMagUpper(), 1.0, bVal);
        tempGR.scaleToIncrRate(transMagIndex, totalTargetGR.getY(transMagIndex));
        IncrementalMagFreqDist onFaultMFD = new IncrementalMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta());
        IncrementalMagFreqDist offFaultMFD = new IncrementalMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta());
        for (i = 0; i < transMagIndex; ++i) {
            onFaultMFD.set(i, tempGR.getY(i));
            offFaultMFD.set(i, totalTargetGR.getY(i) - tempGR.getY(i));
        }
        for (i = transMagIndex; i < totalTargetGR.size(); ++i) {
            onFaultMFD.set(i, totalTargetGR.getY(i));
        }
        onFaultMFD.setName("onFaultMFD");
        onFaultMFD.setInfo("(rate(M>=5)=" + (float)onFaultMFD.getCumRate(mag5_Index) + "; transMag=" + onFaultMFD.getX(transMagIndex) + ")");
        offFaultMFD.setName("offFaultMFD");
        offFaultMFD.setInfo("(rate(M>=5)=" + (float)offFaultMFD.getCumRate(mag5_Index) + "; maxMag=" + onFaultMFD.getX(transMagIndex - 1) + ")");
        System.out.println("\nInputs:\n");
        System.out.println("\ttotOnFaultMgt5_Rate=" + (float)totOnFaultMgt5_Rate);
        double totRate = totalTargetGR.getCumRate(5.05);
        double totMoRate = totalTargetGR.getTotalMomentRate();
        System.out.println("\ttotalTargetGR.getCumRate(5.05)=" + (float)totRate);
        System.out.println("\ttotalTargetGR.getTotalMomentRate()=" + (float)totMoRate);
        System.out.println("\ttransMag=" + (float)onFaultMFD.getX(transMagIndex));
        System.out.println("\tmaxMagOff=" + (float)onFaultMFD.getX(transMagIndex - 1));
        System.out.println("\nResults:\n");
        System.out.println("\tonFaultMFD.getCumRate(5.05)=" + (float)onFaultMFD.getCumRate(5.05) + "\tfraction=" + (float)(onFaultMFD.getCumRate(5.05) / totRate));
        System.out.println("\toffFaultMFD.getCumRate(5.05)=" + (float)offFaultMFD.getCumRate(5.05) + "\tfraction=" + (float)(offFaultMFD.getCumRate(5.05) / totRate));
        System.out.println("\tonFaultMFD.getTotalMomentRate()=" + (float)onFaultMFD.getTotalMomentRate() + "\tfraction=" + (float)(onFaultMFD.getTotalMomentRate() / totMoRate));
        System.out.println("\toffFaultMFD.getTotalMomentRate()=" + (float)offFaultMFD.getTotalMomentRate() + "\tfraction=" + (float)(offFaultMFD.getTotalMomentRate() / totMoRate));
        System.out.println("\nTests (all should be close to 1.0):\n");
        System.out.println("\tTotMoRate: " + (float)(totMoRate / (onFaultMFD.getTotalMomentRate() + offFaultMFD.getTotalMomentRate())) + "\t(totMoRate/(onFaultMFD.getTotalMomentRate()+offFaultMFD.getTotalMomentRate()))");
        System.out.println("\tTotCumRate: " + (float)(totRate / (onFaultMFD.getCumRate(5.05) + offFaultMFD.getCumRate(5.05))) + "\t(totRate/(onFaultMFD.getCumRate(5.05)+offFaultMFD.getCumRate(5.05)))");
        System.out.println("\tOnFaultCumRate: " + (float)(totOnFaultMgt5_Rate / onFaultMFD.getCumRate(5.05)) + "\t(totOnFaultMgt5_Rate/onFaultMFD.getCumRate(5.05))");
        System.out.println("\tOffFaultCumRate: " + (float)((totRate - totOnFaultMgt5_Rate) / offFaultMFD.getCumRate(5.05)) + "\t((totRate-totOnFaultMgt5_Rate)/+offFaultMFD.getCumRate(5.05))");
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(totalTargetGR);
        funcs.add(offFaultMFD);
        funcs.add(onFaultMFD);
        funcs.add(totalTargetGR.getCumRateDistWithOffset());
        funcs.add(offFaultMFD.getCumRateDistWithOffset());
        funcs.add(onFaultMFD.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(funcs, "MFDs");
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-5, 10.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        IncrementalMagFreqDist[] mfds = new IncrementalMagFreqDist[]{onFaultMFD, offFaultMFD};
        return mfds;
    }

    public static IncrementalMagFreqDist[] old_getCharOnFaultTargetMFD(double moRateOffFault, GutenbergRichterMagFreqDist totalTargetGR, double totOnFaultMgt5_Rate) {
        double mMaxTest;
        double minOffFaultMag = 6.05;
        double totMoRate = totalTargetGR.getTotalMomentRate();
        double moRateOnFault = totMoRate - moRateOffFault;
        int testIndex = totalTargetGR.getXIndex(totalTargetGR.getMagUpper()) - 1;
        IncrementalMagFreqDist[] testMFDs = FaultSystemRupSetCalc.old_getCharOnFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, testIndex);
        double maxOffFaultMoRate = testMFDs[1].getTotalMomentRate();
        if (maxOffFaultMoRate < moRateOffFault) {
            System.out.println("Error - Can't satisfy given moment (given=" + moRateOffFault + " and max possible is " + maxOffFaultMoRate + ")");
            return null;
        }
        testIndex = totalTargetGR.getXIndex(minOffFaultMag) - 1;
        testMFDs = FaultSystemRupSetCalc.old_getCharOnFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, testIndex);
        double minOffFaultMoRate = testMFDs[1].getTotalMomentRate();
        if (minOffFaultMoRate > moRateOffFault) {
            System.out.println("Error - Can't satisfy given moment (given=" + moRateOffFault + " and min possible is " + minOffFaultMoRate + ")");
            return null;
        }
        double fracMoRateDiff = Double.MAX_VALUE;
        int transMagIndex = -1;
        IncrementalMagFreqDist onFaultMFD = null;
        IncrementalMagFreqDist offFaultMFD = null;
        for (int mMaxOffIndex = totalTargetGR.getXIndex(minOffFaultMag); mMaxOffIndex < totalTargetGR.getXIndex(totalTargetGR.getMagUpper()); ++mMaxOffIndex) {
            IncrementalMagFreqDist[] mfds = FaultSystemRupSetCalc.old_getCharOnFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, mMaxOffIndex);
            IncrementalMagFreqDist tempOnFaultMFD = mfds[0];
            double thisMoRateFracDiff = Math.abs(moRateOnFault - tempOnFaultMFD.getTotalMomentRate()) / moRateOnFault;
            if (!(thisMoRateFracDiff < fracMoRateDiff)) continue;
            onFaultMFD = tempOnFaultMFD;
            offFaultMFD = mfds[1];
            transMagIndex = mMaxOffIndex + 1;
            fracMoRateDiff = thisMoRateFracDiff;
        }
        double mMaxOff = offFaultMFD.getMaxMagWithNonZeroRate();
        if (mMaxOff != (mMaxTest = totalTargetGR.getX(transMagIndex - 1))) {
            throw new RuntimeException("Error: discrepancy with off-fault max mags: " + mMaxOff + " vs " + mMaxTest);
        }
        IncrementalMagFreqDist[] mfds = new IncrementalMagFreqDist[]{onFaultMFD, offFaultMFD};
        return mfds;
    }

    public static void testAllInversionSetups() {
        ArrayList<FaultModels> fltModList = new ArrayList<FaultModels>();
        fltModList.add(FaultModels.FM3_1);
        ArrayList<DeformationModels> defModList = new ArrayList<DeformationModels>();
        defModList.add(DeformationModels.GEOLOGIC);
        defModList.add(DeformationModels.ZENGBB);
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        ArrayList<InversionModels> invModList = new ArrayList<InversionModels>();
        invModList.add(InversionModels.CHAR_CONSTRAINED);
        invModList.add(InversionModels.GR_CONSTRAINED);
        ArrayList<TotalMag5Rate> mag5RateList = new ArrayList<TotalMag5Rate>();
        mag5RateList.add(TotalMag5Rate.RATE_7p9);
        mag5RateList.add(TotalMag5Rate.RATE_6p5);
        mag5RateList.add(TotalMag5Rate.RATE_9p6);
        ArrayList<MaxMagOffFault> mMaxOffList = new ArrayList<MaxMagOffFault>();
        mMaxOffList.add(MaxMagOffFault.MAG_7p3);
        mMaxOffList.add(MaxMagOffFault.MAG_7p6);
        mMaxOffList.add(MaxMagOffFault.MAG_7p9);
        ArrayList<MomentRateFixes> moRateFixList = new ArrayList<MomentRateFixes>();
        moRateFixList.add(MomentRateFixes.NONE);
        ArrayList<SpatialSeisPDF> seisPDFList = new ArrayList<SpatialSeisPDF>();
        seisPDFList.add(SpatialSeisPDF.UCERF3);
        boolean first = true;
        ArrayList<String> strings = new ArrayList<String>();
        for (FaultModels fm : fltModList) {
            for (DeformationModels dm : defModList) {
                for (ScalingRelationships sr : scalingRelList) {
                    for (InversionModels invMod : invModList) {
                        for (TotalMag5Rate r5 : mag5RateList) {
                            for (MaxMagOffFault mMaxOff : mMaxOffList) {
                                for (MomentRateFixes moRateFix : moRateFixList) {
                                    for (SpatialSeisPDF seisPDF : seisPDFList) {
                                        U3LogicTreeBranch ltb = U3LogicTreeBranch.fromValues(fm, dm, sr, invMod, r5, mMaxOff, moRateFix, seisPDF);
                                        InversionFaultSystemRupSet faultSysRupSet = InversionFaultSystemRupSetFactory.forBranch(ltb);
                                        if (first) {
                                            strings.add(faultSysRupSet.getPreInversionAnalysisData(true));
                                            first = false;
                                            continue;
                                        }
                                        strings.add(faultSysRupSet.getPreInversionAnalysisData(false));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        try {
            File dataFile = new File("PreInversionDataForAnalysis0.txt");
            FileWriter fw = new FileWriter(dataFile);
            for (String str : strings) {
                fw.write(str + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
        System.out.println("Done making PreInversionDataForAnalysis.txt");
    }

    public static void testImplGR_fracSeisOnFltAssumingSameCC() {
        ArrayList<DeformationModels> defModList = new ArrayList<DeformationModels>();
        defModList.add(DeformationModels.GEOLOGIC);
        defModList.add(DeformationModels.ABM);
        defModList.add(DeformationModels.NEOKINEMA);
        defModList.add(DeformationModels.ZENG);
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        scalingRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scalingRelList.add(ScalingRelationships.SHAW_2009_MOD);
        ArrayList<MaxMagOffFault> mMaxOffList = new ArrayList<MaxMagOffFault>();
        mMaxOffList.add(MaxMagOffFault.MAG_7p3);
        mMaxOffList.add(MaxMagOffFault.MAG_7p6);
        mMaxOffList.add(MaxMagOffFault.MAG_7p9);
        long startTime = System.currentTimeMillis();
        double MIN_MAG = 0.05;
        int NUM_MAG = 90;
        double DELTA_MAG = 0.1;
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (DeformationModels deformationModels : defModList) {
            for (ScalingRelationships sr : scalingRelList) {
                for (MaxMagOffFault mMaxOff : mMaxOffList) {
                    U3LogicTreeBranch ltb = U3LogicTreeBranch.fromValues(FaultModels.FM3_1, deformationModels, sr, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, mMaxOff, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
                    InversionFaultSystemRupSet faultSysRupSet = InversionFaultSystemRupSetFactory.forBranch(ltb);
                    double offFltDefModMoRate = DeformationModelsCalc.calcMoRateOffFaultsForDefModel(FaultModels.FM3_1, deformationModels);
                    SummedMagFreqDist impliedOnFault_GR_NuclMFD = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(faultSysRupSet, MIN_MAG, NUM_MAG, DELTA_MAG);
                    GutenbergRichterMagFreqDist trulyOffFaultMFD = new GutenbergRichterMagFreqDist(MIN_MAG, NUM_MAG, DELTA_MAG, MIN_MAG, mMaxOff.getMaxMagOffFault() - DELTA_MAG / 2.0, offFltDefModMoRate, 1.0);
                    double onFltFrac = impliedOnFault_GR_NuclMFD.getCumRate(5.05) / (impliedOnFault_GR_NuclMFD.getCumRate(5.05) + trulyOffFaultMFD.getCumRate(5.05));
                    String str = (float)onFltFrac + "\t" + String.valueOf(deformationModels) + "\t" + String.valueOf(sr) + "\t" + String.valueOf(mMaxOff);
                    strings.add((CallSite)((Object)str));
                    System.out.println(str);
                }
            }
        }
        System.out.println("runtime (min): " + (double)(System.currentTimeMillis() - startTime) / 60000.0);
        System.out.println("Implied Fractions On Fault:");
        for (String string : strings) {
            System.out.println(string);
        }
    }

    public static IncrementalMagFreqDist getTriLinearCharOffFaultTargetMFD(GutenbergRichterMagFreqDist totalTargetGR, double totOnFaultMgt5_Rate, double mMinSeismoOnFault, double mMaxOffFault) {
        int i;
        int mMinSeismoOnFaultIndex = totalTargetGR.getClosestXIndex(mMinSeismoOnFault);
        int mMaxOffFaultIndex = totalTargetGR.getClosestXIndex(mMaxOffFault);
        double offFaultMgt5_Rate = totalTargetGR.getCumRate(5.05) - totOnFaultMgt5_Rate;
        double onCorr = 0.98;
        double offCorr = 1.01;
        GutenbergRichterMagFreqDist tempOnFaultGR = new GutenbergRichterMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta(), totalTargetGR.getMagLower(), totalTargetGR.getMagUpper(), 1.0, 1.0);
        tempOnFaultGR.scaleToCumRate(5.05, totOnFaultMgt5_Rate * onCorr);
        GutenbergRichterMagFreqDist tempOffFaultGR = new GutenbergRichterMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta(), totalTargetGR.getMagLower(), totalTargetGR.getMagUpper(), 1.0, 1.0);
        tempOffFaultGR.scaleToCumRate(5.05, offFaultMgt5_Rate * offCorr);
        IncrementalMagFreqDist onFaultMFD = new IncrementalMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta());
        IncrementalMagFreqDist offFaultMFD = new IncrementalMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta());
        for (i = 0; i < mMinSeismoOnFaultIndex; ++i) {
            onFaultMFD.set(i, tempOnFaultGR.getY(i));
            offFaultMFD.set(i, tempOffFaultGR.getY(i));
        }
        for (i = mMinSeismoOnFaultIndex; i <= mMaxOffFaultIndex + 1; ++i) {
            double wtOnTotRate = (double)(i - mMinSeismoOnFaultIndex) / (double)(mMaxOffFaultIndex + 1 - mMinSeismoOnFaultIndex);
            double wtOnFaultRate = 1.0 - wtOnTotRate;
            double onFltRate = Math.pow(10.0, wtOnFaultRate * Math.log10(tempOnFaultGR.getY(i)) + wtOnTotRate * Math.log10(totalTargetGR.getY(i)));
            onFaultMFD.set(i, onFltRate);
            offFaultMFD.set(i, totalTargetGR.getY(i) - onFltRate);
            if (!(offFaultMFD.getY(i) < 0.0)) continue;
            offFaultMFD.set(i, 0.0);
        }
        for (i = mMaxOffFaultIndex + 1; i < totalTargetGR.size(); ++i) {
            onFaultMFD.set(i, totalTargetGR.getY(i));
            offFaultMFD.set(i, 0.0);
        }
        onFaultMFD.setName("onFaultMFD");
        onFaultMFD.setInfo("(rate(M>=5)=" + (float)onFaultMFD.getCumRate(5.05) + "; totMoRate=" + onFaultMFD.getTotalMomentRate() + ")");
        offFaultMFD.setName("offFaultMFD");
        offFaultMFD.setInfo("(rate(M>=5)=" + (float)offFaultMFD.getCumRate(5.05) + "; totMoRate=" + offFaultMFD.getTotalMomentRate() + ")");
        return offFaultMFD;
    }

    public static IncrementalMagFreqDist getTriLinearCharOffFaultTargetMFD(double moRateOffFault, GutenbergRichterMagFreqDist totalTargetGR, double totOnFaultMgt5_Rate, double mMinSeismoOnFault) {
        double min_mMaxOffFault = totalTargetGR.getX(totalTargetGR.getClosestXIndex(mMinSeismoOnFault) + 1);
        double magUpper = totalTargetGR.getMagUpper();
        IncrementalMagFreqDist maxOffFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, mMinSeismoOnFault, magUpper);
        double maxOffFaultMoRate = maxOffFaultMFD.getTotalMomentRate();
        if (maxOffFaultMoRate < moRateOffFault) {
            System.out.println("Error - Can't satisfy given moment (given=" + moRateOffFault + " and max possible is " + maxOffFaultMoRate + ")");
            return null;
        }
        IncrementalMagFreqDist minOffFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, mMinSeismoOnFault, min_mMaxOffFault);
        double minOffFaultMoRate = minOffFaultMFD.getTotalMomentRate();
        if (minOffFaultMoRate > moRateOffFault) {
            System.out.println("Error - Can't satisfy given moment (given=" + moRateOffFault + " and min possible is " + minOffFaultMoRate + ")");
            return null;
        }
        IncrementalMagFreqDist offFaultMFD = null;
        double fracMoRateDiff = Double.MAX_VALUE;
        double mMaxOff = 0.0;
        for (int mMaxOffIndex = totalTargetGR.getXIndex(min_mMaxOffFault); mMaxOffIndex <= totalTargetGR.getXIndex(totalTargetGR.getMagUpper()); ++mMaxOffIndex) {
            double test_mMaxOff = totalTargetGR.getX(mMaxOffIndex);
            IncrementalMagFreqDist testOffFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(totalTargetGR, totOnFaultMgt5_Rate, mMinSeismoOnFault, test_mMaxOff);
            double thisMoRateFracDiff = Math.abs(moRateOffFault - testOffFaultMFD.getTotalMomentRate()) / moRateOffFault;
            if (!(thisMoRateFracDiff < fracMoRateDiff)) continue;
            offFaultMFD = testOffFaultMFD;
            mMaxOff = test_mMaxOff;
            fracMoRateDiff = thisMoRateFracDiff;
        }
        double mMaxTest = offFaultMFD.getMaxMagWithNonZeroRate();
        if (mMaxOff != mMaxTest) {
            throw new RuntimeException("Error: discrepancy with off-fault max mags: " + mMaxOff + " vs " + mMaxTest);
        }
        return offFaultMFD;
    }

    public static SummedMagFreqDist getCharSubSeismoOnFaultMFD(InversionFaultSystemRupSet fltSysRupSet, GriddedSeisUtils gridSeisUtils, GutenbergRichterMagFreqDist totalTargetGR) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta());
        for (GutenbergRichterMagFreqDist gr : FaultSystemRupSetCalc.getCharSubSeismoOnFaultMFD_forEachSection(fltSysRupSet, gridSeisUtils, totalTargetGR)) {
            mfd.addIncrementalMagFreqDist(gr);
        }
        return mfd;
    }

    public static ArrayList<GutenbergRichterMagFreqDist> getCharSubSeismoOnFaultMFD_forEachSection(InversionFaultSystemRupSet invRupSet, GriddedSeisUtils gridSeisUtils, GutenbergRichterMagFreqDist totalTargetGR) {
        return FaultSystemRupSetCalc.getCharSubSeismoOnFaultMFD_forEachSection(invRupSet, invRupSet.getModule(ModSectMinMags.class), gridSeisUtils, totalTargetGR);
    }

    public static ArrayList<GutenbergRichterMagFreqDist> getCharSubSeismoOnFaultMFD_forEachSection(FaultSystemRupSet invRupSet, ModSectMinMags finalMinMags, GriddedSeisUtils gridSeisUtils, GutenbergRichterMagFreqDist totalTargetGR) {
        ArrayList<GutenbergRichterMagFreqDist> mfds = new ArrayList<GutenbergRichterMagFreqDist>();
        double totMgt5_rate = totalTargetGR.getCumRate(0);
        for (int s = 0; s < invRupSet.getNumSections(); ++s) {
            double sectRate = gridSeisUtils.pdfValForSection(s) * totMgt5_rate;
            double upperMag = InversionFaultSystemRupSet.getUpperMagForSubseismoRuptures(finalMinMags.getMinMagForSection(s));
            int mMaxIndex = totalTargetGR.getXIndex(upperMag);
            if (mMaxIndex == -1) {
                throw new RuntimeException("Problem Mmax: " + upperMag + "\t" + invRupSet.getFaultSectionData(s).getName() + "\tBRANCH: " + String.valueOf(invRupSet.getModule(U3LogicTreeBranch.class)));
            }
            double mMax = totalTargetGR.getX(mMaxIndex);
            GutenbergRichterMagFreqDist tempOnFaultGR = new GutenbergRichterMagFreqDist(totalTargetGR.getMinX(), totalTargetGR.size(), totalTargetGR.getDelta(), totalTargetGR.getMagLower(), mMax, 1.0, 1.0);
            tempOnFaultGR.scaleToCumRate(0, sectRate);
            if (Double.isNaN(tempOnFaultGR.getTotalIncrRate())) {
                throw new RuntimeException("Bad MFD for section:\t" + s + "\t" + invRupSet.getFaultSectionData(s).getName() + "\tsectRate=" + sectRate + "\tgridSeisUtils.pdfValForSection(s) = " + gridSeisUtils.pdfValForSection(s) + "\tmMax = " + mMax);
            }
            mfds.add(tempOnFaultGR);
        }
        return mfds;
    }

    public static void plotPreInversionMFDs(InversionFaultSystemRupSet invFltSysRupSet, boolean plotNvsScalTargets, boolean plotSumTests, boolean addUCERF2_MFDs, String pdfFileName) {
        boolean isGR = invFltSysRupSet.getLogicTreeBranch().getValue(InversionModels.class).isGR();
        System.out.println("isGR=" + isGR);
        U3InversionTargetMFDs inversionMFDs = invFltSysRupSet.getInversionTargetMFDs();
        IncrementalMagFreqDist targetOnFaultSupraSeisMFD = ((InversionTargetMFDs)inversionMFDs).getTotalOnFaultSupraSeisMFD();
        targetOnFaultSupraSeisMFD.setInfo("Rate(M>=5)=" + (float)targetOnFaultSupraSeisMFD.getCumRate(5.05) + "\tMoRate=" + (float)targetOnFaultSupraSeisMFD.getTotalMomentRate());
        IncrementalMagFreqDist trulyOffFaultMFD = ((InversionTargetMFDs)inversionMFDs).getTrulyOffFaultMFD();
        String infoString = "Rate(M>=5)=" + (float)trulyOffFaultMFD.getCumRate(5.05) + "\tMoRate=" + (float)trulyOffFaultMFD.getTotalMomentRate();
        if (trulyOffFaultMFD instanceof TaperedGR_MagFreqDist) {
            infoString = infoString + "\tCornerMag=" + (float)((TaperedGR_MagFreqDist)trulyOffFaultMFD).getMagCorner();
        }
        trulyOffFaultMFD.setInfo(infoString);
        IncrementalMagFreqDist totalSubSeismoOnFaultMFD = ((InversionTargetMFDs)inversionMFDs).getTotalOnFaultSubSeisMFD();
        totalSubSeismoOnFaultMFD.setInfo("Rate(M>=5)=" + (float)totalSubSeismoOnFaultMFD.getCumRate(5.05) + "\tMoRate=" + (float)totalSubSeismoOnFaultMFD.getTotalMomentRate());
        IncrementalMagFreqDist totalTargetGR = ((InversionTargetMFDs)inversionMFDs).getTotalRegionalMFD();
        totalTargetGR.setInfo("Rate(M>=5)=" + (float)totalTargetGR.getCumRate(5.05) + "\tMoRate=" + (float)totalTargetGR.getTotalMomentRate());
        SummedMagFreqDist totalGridSeis = new SummedMagFreqDist(totalTargetGR.getX(0), totalTargetGR.size(), totalTargetGR.getDelta());
        totalGridSeis.addIncrementalMagFreqDist(trulyOffFaultMFD);
        totalGridSeis.addIncrementalMagFreqDist(totalSubSeismoOnFaultMFD);
        totalGridSeis.setName("totalGridSeis (trulyOffFaultMFD plus totalSubSeismoOnFaultMFD)");
        totalGridSeis.setInfo("Rate(M>=5)=" + (float)totalGridSeis.getCumRate(5.05) + "\tMoRate=" + (float)totalGridSeis.getTotalMomentRate());
        ArrayList<IncrementalMagFreqDist> mfds = new ArrayList<IncrementalMagFreqDist>();
        mfds.add(targetOnFaultSupraSeisMFD);
        mfds.add(trulyOffFaultMFD);
        mfds.add(totalSubSeismoOnFaultMFD);
        mfds.add(totalTargetGR);
        mfds.add(totalGridSeis);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.PINK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
        System.out.println("targetOnFaultSupraSeisMFD R>=6.5:\t" + targetOnFaultSupraSeisMFD.getCumRate(6.55));
        System.out.println("trulyOffFaultMFD R>=6.5:\t" + trulyOffFaultMFD.getCumRate(6.55));
        System.out.println("totalSubSeismoOnFaultMFD R>=6.5:\t" + totalSubSeismoOnFaultMFD.getCumRate(6.55));
        System.out.println("totalTargetGR R>=6.5:\t" + totalTargetGR.getCumRate(6.55));
        if (isGR) {
            SummedMagFreqDist totalMFDsum = new SummedMagFreqDist(totalTargetGR.getX(0), totalTargetGR.size(), totalTargetGR.getDelta());
            totalMFDsum.addIncrementalMagFreqDist(targetOnFaultSupraSeisMFD);
            totalMFDsum.addIncrementalMagFreqDist(trulyOffFaultMFD);
            totalMFDsum.addIncrementalMagFreqDist(totalSubSeismoOnFaultMFD);
            totalMFDsum.setName("targetOnFaultSupraSeisMFD+totalSubSeismoOnFaultMFD+trulyOffFaultMFD+");
            totalMFDsum.setInfo("Rate(M>=5)=" + (float)totalMFDsum.getCumRate(5.05) + "\tMoRate=" + (float)totalMFDsum.getTotalMomentRate());
            mfds.add(totalMFDsum);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE));
        } else {
            SummedMagFreqDist totalOnFaultTarget = new SummedMagFreqDist(totalTargetGR.getX(0), totalTargetGR.size(), totalTargetGR.getDelta());
            totalOnFaultTarget.addIncrementalMagFreqDist(totalTargetGR);
            totalOnFaultTarget.subtractIncrementalMagFreqDist(trulyOffFaultMFD);
            totalOnFaultTarget.setName("totalOnFaultTarget (totalTargetGR minus trulyOffFaultMFD)");
            totalOnFaultTarget.setInfo("Rate(M>=5)=" + (float)totalOnFaultTarget.getCumRate(5.05) + "\tMoRate=" + (float)totalOnFaultTarget.getTotalMomentRate());
            mfds.add(totalOnFaultTarget);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE));
        }
        if (plotSumTests) {
            SummedMagFreqDist totalTest = new SummedMagFreqDist(totalTargetGR.getX(0), totalTargetGR.size(), totalTargetGR.getDelta());
            totalTest.addIncrementalMagFreqDist(trulyOffFaultMFD);
            totalTest.addIncrementalMagFreqDist(totalSubSeismoOnFaultMFD);
            totalTest.setName("totalTest (trulyOffFaultMFD plus totalSubSeismoOnFaultMFD plus targetOnFaultSupraSeisMFD)");
            totalTest.setInfo("Rate(M>=5)=" + (float)totalTest.getCumRate(5.05) + "\tMoRate=" + (float)totalTest.getTotalMomentRate());
            mfds.add(totalTest);
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        }
        if (plotNvsScalTargets) {
            IncrementalMagFreqDist noCalTargetFaultMFD = ((InversionTargetMFDs)inversionMFDs).getMFD_Constraints().get(0);
            noCalTargetFaultMFD.setName("noCalTargetFaultMFD");
            noCalTargetFaultMFD.setInfo("Rate(M>=5)=" + (float)noCalTargetFaultMFD.getCumRate(5.05) + "\tMoRate=" + (float)noCalTargetFaultMFD.getTotalMomentRate());
            IncrementalMagFreqDist soCalTargetFaultMFD = ((InversionTargetMFDs)inversionMFDs).getMFD_Constraints().get(1);
            soCalTargetFaultMFD.setName("soCalTargetFaultMFD");
            soCalTargetFaultMFD.setInfo("Rate(M>=5)=" + (float)soCalTargetFaultMFD.getCumRate(5.05) + "\tMoRate=" + (float)soCalTargetFaultMFD.getTotalMomentRate());
            mfds.add(noCalTargetFaultMFD);
            mfds.add(soCalTargetFaultMFD);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.YELLOW));
            if (plotSumTests) {
                SummedMagFreqDist testTarget = new SummedMagFreqDist(soCalTargetFaultMFD.getX(0), soCalTargetFaultMFD.size(), soCalTargetFaultMFD.getDelta());
                testTarget.addIncrementalMagFreqDist(noCalTargetFaultMFD);
                testTarget.addIncrementalMagFreqDist(soCalTargetFaultMFD);
                testTarget.setName("testTarget (should equal targetOnFaultSupraSeisMFD");
                testTarget.setInfo("Rate(M>=5)=" + (float)testTarget.getCumRate(5.05) + "\tMoRate=" + (float)testTarget.getTotalMomentRate());
                mfds.add(testTarget);
                plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.CYAN));
            }
        }
        if (addUCERF2_MFDs) {
            UCERF2_MFD_ConstraintFetcher u2fetcher = new UCERF2_MFD_ConstraintFetcher(RELM_RegionUtils.getGriddedRegionInstance());
            mfds.add(u2fetcher.getTotalMFD());
            mfds.add(u2fetcher.getBackgroundSeisMFD());
            mfds.add(u2fetcher.getFaultMFD());
            mfds.add(u2fetcher.getTargetMinusBackgroundMFD());
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.CYAN));
        }
        if (isGR) {
            SummedMagFreqDist impliedOnFault_GR_NuclMFD = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(invFltSysRupSet, 0.05, 90, 0.1);
            impliedOnFault_GR_NuclMFD.setName("ImpliedGR_NucleationMFD");
            impliedOnFault_GR_NuclMFD.setInfo("(if every section nucleates a GR with no implied coupling coeff)");
            mfds.add(impliedOnFault_GR_NuclMFD);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.DARK_GRAY));
        }
        GraphWindow graph = new GraphWindow(mfds, "Pre-Inversion MFDs", plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-5, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        if (pdfFileName != null) {
            try {
                graph.saveAsPDF(pdfFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String calcImplDDWvsDDW_Ratio(InversionFaultSystemRupSet invFltSysRupSet) {
        Object result = "";
        HistogramFunction hist = new HistogramFunction(0.1, 100, 0.1);
        double ave = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.NEGATIVE_INFINITY;
        int minIndex = -1;
        for (int r = 0; r < invFltSysRupSet.getNumRuptures(); ++r) {
            double moment = MagUtils.magToMoment(invFltSysRupSet.getMagForRup(r));
            double slip = invFltSysRupSet.getAveSlipForRup(r);
            double length = invFltSysRupSet.getLengthForRup(r);
            double implWidth = moment / (slip * length * 3.0E10);
            double width = invFltSysRupSet.getAveWidthForRup(r);
            double ratio = implWidth / width;
            hist.add(ratio, 1.0);
            ave += ratio;
            if (min > ratio) {
                min = ratio;
                if (ratio >= 1.01 || ratio <= 0.99) {
                    minIndex = r;
                }
            }
            if (!(max < ratio)) continue;
            max = ratio;
        }
        result = "\taveRatio=" + (float)(ave /= (double)invFltSysRupSet.getNumRuptures()) + "\tmin=" + (float)min + "\tmax=" + (float)max + "\tminIndex=" + minIndex + "\n";
        result = (String)result + "\tnon-zero bins (ratio, num rups):\n";
        for (int i = 0; i < hist.size(); ++i) {
            if (!(hist.getY(i) > 0.0)) continue;
            result = (String)result + "\t\t" + (float)hist.getX(i) + "\t" + (float)hist.getY(i) + "\n";
        }
        return result;
    }

    public static void testAllImpliedDDWs() {
        Object result = "";
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        scalingRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scalingRelList.add(ScalingRelationships.SHAW_2009_MOD);
        scalingRelList.add(ScalingRelationships.ELLB_SQRT_LENGTH);
        scalingRelList.add(ScalingRelationships.SHAW_CONST_STRESS_DROP);
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = DeformationModels.GEOLOGIC;
        result = (String)result + "RESULTS FOR:\t" + String.valueOf(fm) + "  &  " + String.valueOf(dm) + "\n";
        for (ScalingRelationships sr : scalingRelList) {
            InversionFaultSystemRupSet faultSysRupSet = InversionFaultSystemRupSetFactory.forBranch(fm, dm, sr, SlipAlongRuptureModels.TAPERED, InversionModels.GR_CONSTRAINED);
            result = (String)result + "\n" + String.valueOf(sr) + ":\n";
            result = (String)result + FaultSystemRupSetCalc.calcImplDDWvsDDW_Ratio(faultSysRupSet);
        }
        System.out.println((String)result);
    }

    public static boolean isRupMultiplyNamed(InversionFaultSystemRupSet rupSet, int rupIndex) {
        Map<Integer, List<Integer>> namedMap = rupSet.getFaultModel().getNamedFaultsMap();
        List<Integer> parents = rupSet.getParentSectionsForRup(rupIndex);
        List<Integer> named = null;
        for (Integer parent : parents) {
            if (named == null) {
                named = namedMap.get(parent);
                Preconditions.checkNotNull(named, (Object)("Parent ID '" + parent + "' not found in named faults file!"));
            }
            if (named.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static double calcTotRateMultiplyNamedFaults(InversionFaultSystemSolution sol, double minMag, PaleoProbabilityModel paleoProbModel) {
        double rate = 0.0;
        InversionFaultSystemRupSet rupSet = sol.getRupSet();
        for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
            double mag = rupSet.getMagForRup(rupIndex);
            if (mag < minMag || !FaultSystemRupSetCalc.isRupMultiplyNamed(rupSet, rupIndex)) continue;
            double rupRate = sol.getRateForRup(rupIndex);
            if (paleoProbModel != null) {
                rupRate *= paleoProbModel.getProbPaleoVisible(mag, 0.5);
            }
            rate += rupRate;
        }
        return rate;
    }

    public static double calcTotRateAboveMag(FaultSystemSolution sol, double minMag, PaleoProbabilityModel paleoProbModel) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double rate = 0.0;
        for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
            double mag = rupSet.getMagForRup(rupIndex);
            if (mag < minMag) continue;
            double rupRate = sol.getRateForRup(rupIndex);
            if (paleoProbModel != null) {
                rupRate *= paleoProbModel.getProbPaleoVisible(mag, 0.5);
            }
            rate += rupRate;
        }
        return rate;
    }

    public static void plotOffFaultTaperedGR_Comparisons(InversionFaultSystemRupSet invFltSysRupSet, String fileNamePrefix) {
        U3InversionTargetMFDs invMFDs = invFltSysRupSet.getInversionTargetMFDs();
        double totalRateOffFault = invMFDs.getOffFaultRegionRateMgt5() * 100000.0;
        ArrayList<IncrementalMagFreqDist> mfds = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<EvenlyDiscretizedFunc> cumMFDs = new ArrayList<EvenlyDiscretizedFunc>();
        for (MaxMagOffFault mMaxVals : MaxMagOffFault.values()) {
            double mMaxOff = mMaxVals.getMaxMagOffFault() - 0.05;
            GutenbergRichterMagFreqDist offFaultMFD_Truncated = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, mMaxOff, 1.0, 1.0);
            offFaultMFD_Truncated.scaleToCumRate(0, totalRateOffFault);
            offFaultMFD_Truncated.setName("Truncated GR with Mmax=" + mMaxOff);
            TaperedGR_MagFreqDist offFaultMFD_Tapered = new TaperedGR_MagFreqDist(0.05, 90, 0.1);
            offFaultMFD_Tapered.setAllButCornerMag(0.05, offFaultMFD_Truncated.getTotalMomentRate(), totalRateOffFault, 1.0);
            offFaultMFD_Tapered.setName("Tapered GR with Corner Mag =" + offFaultMFD_Tapered.getMagCorner());
            mfds.add(offFaultMFD_Truncated);
            mfds.add(offFaultMFD_Tapered);
            cumMFDs.add(offFaultMFD_Truncated.getCumRateDistWithOffset());
            cumMFDs.add(offFaultMFD_Tapered.getCumRateDistWithOffset());
        }
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        GraphWindow graph = new GraphWindow(mfds, "Incremental Off-Fault MFDs", plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-5, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(16);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        if (fileNamePrefix != null) {
            try {
                graph.saveAsPDF(fileNamePrefix + "_Incr.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GraphWindow cumGraph = new GraphWindow(cumMFDs, "Cumulative Off-Fault MFDs", plotChars);
        cumGraph.setX_AxisRange(5.0, 9.0);
        cumGraph.setY_AxisRange(1.0E-5, 20.0);
        cumGraph.setYLog(true);
        cumGraph.setX_AxisLabel("Magnitude");
        cumGraph.setY_AxisLabel("Rate (per year)");
        cumGraph.setTickLabelFontSize(16);
        cumGraph.setAxisLabelFontSize(18);
        cumGraph.setPlotLabelFontSize(18);
        if (fileNamePrefix != null) {
            try {
                cumGraph.saveAsPDF(fileNamePrefix + "_Cum.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeZeroMagBinsForEachParentSection(FaultSystemRupSet faultSystemRupSet, double minMag, int numMag, double deltaMag) {
        Object parSectName;
        Object prevParSectName = "junk";
        double minSectMag = -1.0;
        double maxSectMag = -1.0;
        double minParSectMag = -1.0;
        double maxParSectMag = -1.0;
        ArrayList<Double> sectMagList = null;
        List<? extends FaultSection> sectDataList = faultSystemRupSet.getFaultSectionDataList();
        for (int s = 0; s < sectDataList.size(); ++s) {
            Object mfd;
            parSectName = sectDataList.get(s).getParentSectionName();
            minSectMag = faultSystemRupSet.getMinMagForSection(s);
            maxSectMag = faultSystemRupSet.getMaxMagForSection(s);
            if (!((String)parSectName).equals(prevParSectName)) {
                if (!((String)prevParSectName).equals("junk")) {
                    mfd = new HistogramFunction(minMag, numMag, deltaMag);
                    Iterator iterator = sectMagList.iterator();
                    while (iterator.hasNext()) {
                        double mag = (Double)iterator.next();
                        ((EvenlyDiscretizedFunc)mfd).add(mag, 1.0);
                    }
                    ArrayList<Double> missingMagList = new ArrayList<Double>();
                    for (int m = ((EvenlyDiscretizedFunc)mfd).getClosestXIndex(minParSectMag); m <= ((EvenlyDiscretizedFunc)mfd).getClosestXIndex(maxParSectMag); ++m) {
                        if (!(((EvenlyDiscretizedFunc)mfd).getY(m) < 0.5)) continue;
                        missingMagList.add(((EvenlyDiscretizedFunc)mfd).getX(m));
                    }
                    if (missingMagList.size() > 0) {
                        System.out.print("\n" + (String)prevParSectName);
                        Iterator iterator2 = missingMagList.iterator();
                        while (iterator2.hasNext()) {
                            double mag = (Double)iterator2.next();
                            System.out.print("\t" + (float)mag);
                        }
                    }
                }
                prevParSectName = parSectName;
                sectMagList = new ArrayList<Double>();
                minParSectMag = minSectMag;
                maxParSectMag = maxSectMag;
            }
            if (minSectMag < minParSectMag) {
                minParSectMag = minSectMag;
            }
            if (maxSectMag > maxParSectMag) {
                maxParSectMag = maxSectMag;
            }
            mfd = faultSystemRupSet.getRupturesForSection(s).iterator();
            while (mfd.hasNext()) {
                int r = (Integer)mfd.next();
                sectMagList.add(faultSystemRupSet.getMagForRup(r));
            }
        }
        HistogramFunction mfd = new HistogramFunction(minMag, numMag, deltaMag);
        parSectName = sectMagList.iterator();
        while (parSectName.hasNext()) {
            double mag = (Double)parSectName.next();
            mfd.add(mag, 1.0);
        }
        ArrayList<Double> missingMagList = new ArrayList<Double>();
        for (int m = mfd.getClosestXIndex(minParSectMag); m <= mfd.getClosestXIndex(maxParSectMag); ++m) {
            if (!(mfd.getY(m) < 0.5)) continue;
            missingMagList.add(mfd.getX(m));
        }
        if (missingMagList.size() > 0) {
            System.out.print("\n" + (String)prevParSectName);
            Iterator iterator = missingMagList.iterator();
            while (iterator.hasNext()) {
                double mag = (Double)iterator.next();
                System.out.print("\t" + (float)mag);
            }
        }
    }

    public static void tempSubsectionAreaTest(FaultSystemRupSet faultSystemRupSet) {
        String prevParSectName = "junk";
        double minSectArea = 1.0E10;
        double maxSectArea = 0.0;
        double aveArea = 0.0;
        int numArea = 0;
        List<? extends FaultSection> sectDataList = faultSystemRupSet.getFaultSectionDataList();
        for (int s = 0; s < sectDataList.size(); ++s) {
            String parSectName = sectDataList.get(s).getParentSectionName();
            double area = sectDataList.get(s).getReducedDownDipWidth() * sectDataList.get(s).getTraceLength();
            if (!parSectName.equals(prevParSectName)) {
                if (!prevParSectName.equals("junk")) {
                    System.out.print("\n" + prevParSectName + "\t" + minSectArea + "\t" + maxSectArea + "\t" + (float)((maxSectArea - minSectArea) / minSectArea) + "\t" + numArea + "\t" + (aveArea /= (double)numArea));
                }
                prevParSectName = parSectName;
                minSectArea = area;
                maxSectArea = area;
                aveArea = area;
                numArea = 1;
                continue;
            }
            if (minSectArea > area) {
                minSectArea = area;
            }
            if (maxSectArea < area) {
                maxSectArea = area;
            }
            aveArea += area;
            ++numArea;
        }
        System.out.print("\n" + prevParSectName + "\t" + minSectArea + "\t" + maxSectArea + "\t" + (float)((maxSectArea - minSectArea) / minSectArea) + "\t" + numArea + "\t" + (aveArea /= (double)numArea));
    }

    public static void tempTest(InversionFaultSystemRupSet faultSystemRupSet) {
        String prevParSectName = "junk";
        double cumSectArea = 0.0;
        double firstArea = 0.0;
        double firstWidth = 0.0;
        ScalingRelationships scalingRel = faultSystemRupSet.getLogicTreeBranch().getValue(ScalingRelationships.class);
        System.out.println("scalingRel=" + String.valueOf(scalingRel));
        List<? extends FaultSection> sectDataList = faultSystemRupSet.getFaultSectionDataList();
        for (int s = 0; s < sectDataList.size(); ++s) {
            String parSectName = sectDataList.get(s).getParentSectionName();
            double width = sectDataList.get(s).getReducedDownDipWidth();
            double area = width * sectDataList.get(s).getTraceLength();
            if (!parSectName.equals(prevParSectName)) {
                System.out.print("\n" + parSectName + "\t" + (float)area + "\t" + (float)width);
                cumSectArea = area;
                firstArea = area;
                firstWidth = width;
                prevParSectName = parSectName;
                continue;
            }
            double areaDiff = Math.abs((firstArea - area) / firstArea);
            if (areaDiff > 0.01) {
                throw new RuntimeException("Areas differ: " + firstArea + "\t" + area + "; widths are:  " + firstWidth + "\t" + width);
            }
            double mag = scalingRel.getMag((cumSectArea += area) * 1000000.0, 1000.0 * cumSectArea / width, width * 1000.0, width * 1000.0, sectDataList.get(s).getAveRake());
            System.out.print("\t" + (float)mag + "\t" + (float)(cumSectArea * 1000000.0));
            prevParSectName = parSectName;
        }
    }

    public static void tempTest2(InversionFaultSystemRupSet faultSystemRupSet) {
        for (int r = 0; r < faultSystemRupSet.getNumRuptures(); ++r) {
            double mag = faultSystemRupSet.getMagForRup(r);
            if (!(mag < 6.0)) continue;
            double rupLength = faultSystemRupSet.getLengthForRup(r) * 0.001;
            double sqrtRupArea = Math.sqrt(faultSystemRupSet.getAreaForRup(r)) * 0.001;
            int numSubSect = faultSystemRupSet.getSectionsIndicesForRup(r).size();
            System.out.print("\n" + r + "\t" + mag + "\t" + rupLength + "\t" + sqrtRupArea + "\t" + numSubSect);
            ArrayList<String> parentNameList = new ArrayList<String>();
            for (int s : faultSystemRupSet.getSectionsIndicesForRup(r)) {
                String parentName = faultSystemRupSet.getFaultSectionData(s).getParentSectionName();
                if (parentNameList.contains(parentName)) continue;
                parentNameList.add(parentName);
            }
            for (String name : parentNameList) {
                System.out.print("\t" + name);
            }
        }
    }

    public static double[] computeMinSeismoMagForSections(FaultSystemRupSet fltSystRupSet, double systemWideMinSeismoMag) {
        int s;
        double[] minMagForSect = new double[fltSystRupSet.getNumSections()];
        String prevParSectName = "junk";
        List<? extends FaultSection> sectDataList = fltSystRupSet.getFaultSectionDataList();
        double aveParkfieldMag = 0.0;
        List<Integer> parkRupIndexList = UCERF3InversionInputGenerator.findParkfieldRups(fltSystRupSet);
        for (int parkRupIndex : UCERF3InversionInputGenerator.findParkfieldRups(fltSystRupSet)) {
            aveParkfieldMag += fltSystRupSet.getMagForRup(parkRupIndex) / (double)parkRupIndexList.size();
        }
        HashMap<String, Double> magForParSectMap = new HashMap<String, Double>();
        int PARKFIELD_PAR_SECT_ID = 32;
        String parkfieldParSectName = null;
        double maxMinSeismoMag = 0.0;
        double minMinSeismoMag = 0.0;
        for (s = 0; s < sectDataList.size(); ++s) {
            String parSectName = sectDataList.get(s).getParentSectionName();
            double minSeismoMag = fltSystRupSet.getMinMagForSection(s);
            if (!parSectName.equals(prevParSectName)) {
                if (!prevParSectName.equals("junk")) {
                    magForParSectMap.put(prevParSectName, maxMinSeismoMag);
                }
                maxMinSeismoMag = minSeismoMag;
                minMinSeismoMag = minSeismoMag;
                prevParSectName = parSectName;
                if (sectDataList.get(s).getParentSectionId() != PARKFIELD_PAR_SECT_ID) continue;
                parkfieldParSectName = prevParSectName;
                continue;
            }
            if (maxMinSeismoMag < minSeismoMag) {
                maxMinSeismoMag = minSeismoMag;
            }
            if (!(minMinSeismoMag > minSeismoMag)) continue;
            minMinSeismoMag = minSeismoMag;
        }
        magForParSectMap.put(prevParSectName, maxMinSeismoMag);
        for (s = 0; s < sectDataList.size(); ++s) {
            double minMag = (Double)magForParSectMap.get(sectDataList.get(s).getParentSectionName());
            minMagForSect[s] = minMag > systemWideMinSeismoMag ? minMag : systemWideMinSeismoMag;
            if (!sectDataList.get(s).getParentSectionName().equals(parkfieldParSectName) || !(aveParkfieldMag < systemWideMinSeismoMag)) continue;
            minMagForSect[s] = aveParkfieldMag;
        }
        return minMagForSect;
    }

    public static boolean[] computeWhichRupsFallBelowSectionMinMags(FaultSystemRupSet fltSystRupSet, ModSectMinMags modMinMags) {
        boolean[] rupBelowSectMinMag = new boolean[fltSystRupSet.getNumRuptures()];
        for (int r = 0; r < fltSystRupSet.getNumRuptures(); ++r) {
            rupBelowSectMinMag[r] = FaultSystemRupSetCalc.isRuptureBelowSectMinMag(fltSystRupSet, r, modMinMags);
        }
        return rupBelowSectMinMag;
    }

    public static boolean isRuptureBelowSectMinMag(FaultSystemRupSet fltSystRupSet, int rupIndex, ModSectMinMags modMinMags) {
        double rupMag = fltSystRupSet.getMagForRup(rupIndex);
        List<Integer> indicesForRup = fltSystRupSet.getSectionsIndicesForRup(rupIndex);
        boolean magTooSmall = false;
        for (int s : indicesForRup) {
            double lowerBinEdge = U3SectionMFD_constraint.getLowerEdgeOfFirstBin(modMinMags.getMinMagForSection(s));
            if (!(rupMag < lowerBinEdge)) continue;
            magTooSmall = true;
        }
        return magTooSmall;
    }

    public static ArrayList<U3SectionMFD_constraint> getGR_InversionSectMFD_Constraints(InversionFaultSystemRupSet fltSystRupSet) {
        double fractGR = 1.0;
        ArrayList<U3SectionMFD_constraint> mfdConstraintList = new ArrayList<U3SectionMFD_constraint>();
        for (int s = 0; s < fltSystRupSet.getNumSections(); ++s) {
            FaultSection data = fltSystRupSet.getFaultSectionData(s);
            double minMag = fltSystRupSet.getFinalMinMagForSection(s);
            double maxMag = fltSystRupSet.getMaxMagForSection(s);
            double moRate = fltSystRupSet.getReducedMomentRate(s);
            double lowerEdgeOfFirstBin = U3SectionMFD_constraint.getLowerEdgeOfFirstBin(minMag);
            if (maxMag > lowerEdgeOfFirstBin) {
                mfdConstraintList.add(new U3SectionMFD_constraint(minMag, maxMag, moRate, fractGR));
                continue;
            }
            mfdConstraintList.add(null);
            System.out.println("Null MFD Constraint for\t" + data.getSectionName() + "\tminMag=" + (float)minMag + "\tmaxMag=" + (float)maxMag + "\tlowerEdgeOfFirstBin=" + (float)lowerEdgeOfFirstBin);
        }
        int[] numCases = new int[10];
        for (int s = 0; s < fltSystRupSet.getNumSections(); ++s) {
            U3SectionMFD_constraint constr = (U3SectionMFD_constraint)mfdConstraintList.get(s);
            ArrayList<Integer> ithMags = new ArrayList<Integer>();
            for (int i = 0; i < constr.getNumMags(); ++i) {
                ithMags.add(i);
            }
            for (int rupID : fltSystRupSet.getRupturesForSection(s)) {
                int index = constr.getIndexForMag(fltSystRupSet.getMagForRup(rupID));
                if (!ithMags.contains(index)) continue;
                ithMags.remove((Object)index);
            }
            int n = ithMags.size();
            numCases[n] = numCases[n] + 1;
            if (ithMags.size() <= 0) continue;
            String str = "\n" + fltSystRupSet.getFaultSectionData(s).getName() + " has zero rups at " + ithMags.size() + " mags: ";
            Iterator<Object> iterator = ithMags.iterator();
            while (iterator.hasNext()) {
                int iMag = (Integer)iterator.next();
                str = str + constr.getMag(iMag) + ",  ";
            }
            if (ithMags.size() > 3) {
                str = str + "\n" + constr.toString() + "\nRupMags:";
                iterator = fltSystRupSet.getRupturesForSection(s).iterator();
                while (iterator.hasNext()) {
                    int rupID = (Integer)iterator.next();
                    str = str + "\n\t" + fltSystRupSet.getMagForRup(rupID);
                }
            }
            System.out.print(str);
        }
        System.out.print("numCases = " + String.valueOf(numCases));
        return mfdConstraintList;
    }

    public static synchronized ArrayList<U3SectionMFD_constraint> getCharInversionSectMFD_Constraints(FaultSystemRupSet fltSystRupSet) {
        LogicTreeBranch branch = fltSystRupSet.requireModule(LogicTreeBranch.class);
        AveSlipModule aveSlipModule = fltSystRupSet.requireModule(AveSlipModule.class);
        ModSectMinMags finalMinMags = fltSystRupSet.requireModule(ModSectMinMags.class);
        double fractGR = 0.33333;
        HashMap<Integer, Integer> numSectMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> moRateMap = new HashMap<Integer, Double>();
        HashMap<Integer, Double> totAreaMap = new HashMap<Integer, Double>();
        HashMap<Integer, Double> totLengthMap = new HashMap<Integer, Double>();
        ArrayList<U3SectionMFD_constraint> mfdConstraintList = new ArrayList<U3SectionMFD_constraint>();
        FaultSystemSolution UCERF2_FltSysSol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(fltSystRupSet, branch.getValue(FaultModels.class), aveSlipModule);
        int lastParentIndex = -1;
        int numSubSec = 0;
        double totalMomentRate = 0.0;
        double totalArea = 0.0;
        double totalLength = 0.0;
        for (int s = 0; s < fltSystRupSet.getNumSections(); ++s) {
            String name2;
            String name1 = fltSystRupSet.getFaultSectionData(s).getSectionName();
            if (!name1.equals(name2 = UCERF2_FltSysSol.getRupSet().getFaultSectionData(s).getSectionName())) {
                throw new RuntimeException("Problem - names differ");
            }
            FaultSection data = fltSystRupSet.getFaultSectionData(s);
            if (data.getParentSectionId() != lastParentIndex) {
                if (lastParentIndex != -1) {
                    numSectMap.put(lastParentIndex, numSubSec);
                    moRateMap.put(lastParentIndex, totalMomentRate);
                    totAreaMap.put(lastParentIndex, totalArea);
                    totLengthMap.put(lastParentIndex, totalLength);
                }
                numSubSec = 0;
                totalMomentRate = 0.0;
                totalArea = 0.0;
                totalLength = 0.0;
            }
            ++numSubSec;
            totalMomentRate += FaultSystemRupSetCalc.getReducedMomentRate(fltSystRupSet, s);
            double length = data.getTraceLength();
            totalArea += data.getReducedDownDipWidth() * length;
            totalLength += length;
            lastParentIndex = data.getParentSectionId();
        }
        numSectMap.put(lastParentIndex, numSubSec);
        moRateMap.put(lastParentIndex, totalMomentRate);
        totAreaMap.put(lastParentIndex, totalArea);
        totLengthMap.put(lastParentIndex, totalLength);
        RupSetScalingRelationship scalingRel = branch.getValue(RupSetScalingRelationship.class);
        for (int s = 0; s < fltSystRupSet.getNumSections(); ++s) {
            double length;
            double width;
            FaultSection data = fltSystRupSet.getFaultSectionData(s);
            double minMag = finalMinMags.getMinMagForSection(s);
            double lowerEdgeOfFirstBin = U3SectionMFD_constraint.getLowerEdgeOfFirstBin(minMag);
            if (UCERF2_A_FaultMapper.wasUCERF2_TypeAFault(data.getParentSectionId())) {
                mfdConstraintList.add(new U3SectionMFD_constraint(minMag, UCERF2_FltSysSol, s));
                continue;
            }
            double area = (Double)totAreaMap.get(data.getParentSectionId());
            double maxMag = scalingRel.getMag(area * 1000000.0, 1000.0 * area / (width = area / (length = ((Double)totLengthMap.get(data.getParentSectionId())).doubleValue())), width * 1000.0, width * 1000.0, data.getAveRake());
            if (maxMag > lowerEdgeOfFirstBin) {
                double moRate = (Double)moRateMap.get(data.getParentSectionId()) / (double)((Integer)numSectMap.get(data.getParentSectionId())).intValue();
                mfdConstraintList.add(new U3SectionMFD_constraint(minMag, maxMag, moRate, fractGR));
                continue;
            }
            mfdConstraintList.add(null);
            System.out.println("Null MFD Constraint for\t" + data.getSectionName() + "\tminMag=" + (float)minMag + "\tmaxMag=" + (float)maxMag + "\tlowerEdgeOfFirstBin=" + (float)lowerEdgeOfFirstBin + "\tarea=" + (float)area + "\tlength=" + (float)length + "\twidth=" + (float)width);
        }
        return mfdConstraintList;
    }

    public static void writeParkfieldMags() {
        ArrayList<DeformationModels> defModList = new ArrayList<DeformationModels>();
        defModList.add(DeformationModels.ZENG);
        defModList.add(DeformationModels.GEOLOGIC);
        defModList.add(DeformationModels.NEOKINEMA);
        defModList.add(DeformationModels.ABM);
        ArrayList<ScalingRelationships> scaleRelList = new ArrayList<ScalingRelationships>();
        scaleRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scaleRelList.add(ScalingRelationships.ELLSWORTH_B);
        scaleRelList.add(ScalingRelationships.SHAW_2009_MOD);
        Object info = "DefMod\tScRel\tRupID\tmagitude\tnumSect\t1stSect\tlastSect\n";
        Object rupsBelowMinMag = "\nRups (indices) of those that fall below section min mag:\n";
        for (DeformationModels defMod : defModList) {
            for (ScalingRelationships scaleRel : scaleRelList) {
                InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, defMod, InversionModels.CHAR_CONSTRAINED, scaleRel, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
                List<Integer> parkfileRupIndexList = UCERF3InversionInputGenerator.findParkfieldRups(rupSet);
                ArrayList<Integer> parkfileRupThatFallBelowMinMag = new ArrayList<Integer>();
                for (int index : parkfileRupIndexList) {
                    List<Integer> sectIndicesList = rupSet.getSectionsIndicesForRup(index);
                    info = (String)info + String.valueOf(defMod) + "\t" + String.valueOf(scaleRel) + "\t";
                    info = (String)info + index + "\t" + (float)rupSet.getMagForRup(index) + "\t" + sectIndicesList.size() + "\t";
                    info = (String)info + rupSet.getFaultSectionData(sectIndicesList.get(0)).getSectionName() + "\t";
                    info = (String)info + rupSet.getFaultSectionData(sectIndicesList.get(sectIndicesList.size() - 1)).getSectionName() + "\n";
                    if (!rupSet.isRuptureBelowSectMinMag(index)) continue;
                    parkfileRupThatFallBelowMinMag.add(index);
                }
                if (parkfileRupThatFallBelowMinMag.size() <= 0) continue;
                rupsBelowMinMag = (String)rupsBelowMinMag + scaleRel.getName() + "\n";
                for (int index : parkfileRupThatFallBelowMinMag) {
                    rupsBelowMinMag = (String)rupsBelowMinMag + "\t" + index + "\n";
                }
            }
        }
        System.out.println("info:");
        System.out.println((String)info);
        System.out.println("rupsBelowMinMag:");
        System.out.println((String)rupsBelowMinMag);
    }

    public static void writeParkfieldAveSlips() {
        ArrayList<ScalingRelationships> scaleRelList = new ArrayList<ScalingRelationships>();
        scaleRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scaleRelList.add(ScalingRelationships.ELLSWORTH_B);
        scaleRelList.add(ScalingRelationships.SHAW_2009_MOD);
        scaleRelList.add(ScalingRelationships.ELLB_SQRT_LENGTH);
        scaleRelList.add(ScalingRelationships.SHAW_CONST_STRESS_DROP);
        Object info = "RupID\tMagitude\tAveSlip\tArea\tLength\n";
        for (ScalingRelationships scaleRel : scaleRelList) {
            info = (String)info + scaleRel.getName() + "\n";
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, DeformationModels.ZENG, InversionModels.CHAR_CONSTRAINED, scaleRel, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
            List<Integer> parkfileRupIndexList = UCERF3InversionInputGenerator.findParkfieldRups(rupSet);
            for (int index : parkfileRupIndexList) {
                info = (String)info + "\t" + index + "\t" + (float)rupSet.getMagForRup(index) + "\t" + (float)rupSet.getAveSlipForRup(index) + "\t" + (float)rupSet.getAreaForRup(index) + "\t" + (float)rupSet.getLengthForRup(index) + "\n";
            }
        }
        System.out.println((String)info);
    }

    public static void plotSumOfCharInversionMFD_Constraints(InversionFaultSystemRupSet fltSystRupSet) {
        double minMag = 5.05;
        int numMag = 40;
        double deltaMag = 0.1;
        ArrayList<U3SectionMFD_constraint> constraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(fltSystRupSet);
        SummedMagFreqDist summedMFD = new SummedMagFreqDist(minMag, numMag, deltaMag);
        for (U3SectionMFD_constraint mfdConstr : constraints) {
            if (mfdConstr == null) continue;
            summedMFD.addIncrementalMagFreqDist(mfdConstr.getResampledToEventlyDiscrMFD(minMag, numMag, deltaMag));
        }
        summedMFD.setName("Sum of Char MFD Constraints");
        summedMFD.setInfo("Rate(M>=6.5)=" + (float)summedMFD.getCumRate(6.55));
        IncrementalMagFreqDist totalTargetGR = fltSystRupSet.getInversionTargetMFDs().getTotalRegionalMFD();
        totalTargetGR.setInfo("Rate(M>=6.5)=" + (float)totalTargetGR.getCumRate(6.55));
        IncrementalMagFreqDist targetOnFaultSupraSeisMFD = fltSystRupSet.getInversionTargetMFDs().getTotalOnFaultSupraSeisMFD();
        targetOnFaultSupraSeisMFD.setInfo("Rate(M>=6.5)=" + (float)targetOnFaultSupraSeisMFD.getCumRate(6.55));
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(summedMFD);
        funcs.add(totalTargetGR);
        funcs.add(summedMFD.getCumRateDistWithOffset());
        funcs.add(totalTargetGR.getCumRateDistWithOffset());
        funcs.add(targetOnFaultSupraSeisMFD);
        funcs.add(targetOnFaultSupraSeisMFD.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.GRAY));
        GraphWindow graph = new GraphWindow(funcs, "Sum of Char MFD Constraints", plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-6, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        String fileName = "SumOfCharMFD_Constrints.pdf";
    }

    public static void testParentCharInversionMFD_Constraint() {
        String targetName = "San Andreas (Mojave S)";
        double minMag = 5.05;
        int numMag = 40;
        double deltaMag = 0.1;
        ArrayList<DeformationModels> defModsList = new ArrayList<DeformationModels>();
        defModsList.add(DeformationModels.ABM);
        defModsList.add(DeformationModels.ZENG);
        defModsList.add(DeformationModels.GEOLOGIC);
        defModsList.add(DeformationModels.NEOKINEMA);
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.SHAW_2009_MOD);
        scalingRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        ArrayList<SummedMagFreqDist> mfdList = new ArrayList<SummedMagFreqDist>();
        ArrayList parSectNames = new ArrayList();
        int totNumBranches = 0;
        for (DeformationModels dm : defModsList) {
            for (ScalingRelationships sr : scalingRelList) {
                ++totNumBranches;
                System.out.println("Working on " + String.valueOf(dm) + " & " + String.valueOf(sr));
                InversionFaultSystemRupSet fltSystRupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, dm, InversionModels.CHAR_CONSTRAINED, sr, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
                SummedMagFreqDist mfd = new SummedMagFreqDist(minMag, numMag, deltaMag);
                ArrayList<U3SectionMFD_constraint> constraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(fltSystRupSet);
                for (int i = 0; i < constraints.size(); ++i) {
                    String parName = fltSystRupSet.getFaultSectionData(i).getParentSectionName();
                    U3SectionMFD_constraint constr = constraints.get(i);
                    if (!parName.equals(targetName) || constr == null) continue;
                    mfd.addIncrementalMagFreqDist(constr.getResampledToEventlyDiscrMFD(minMag, numMag, deltaMag));
                }
                mfdList.add(mfd);
            }
        }
        GraphWindow graph = new GraphWindow(mfdList, "Char MFD Constraint Test");
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-6, 0.01);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
    }

    public static void plotSumOfCharInversionMFD_Constraints() {
        double minMag = 5.05;
        int numMag = 40;
        double deltaMag = 0.1;
        ArrayList<DeformationModels> defModsList = new ArrayList<DeformationModels>();
        defModsList.add(DeformationModels.ABM);
        defModsList.add(DeformationModels.ZENGBB);
        defModsList.add(DeformationModels.GEOLOGIC);
        defModsList.add(DeformationModels.NEOKINEMA);
        ArrayList<ScalingRelationships> scalingRelList = new ArrayList<ScalingRelationships>();
        scalingRelList.add(ScalingRelationships.SHAW_2009_MOD);
        scalingRelList.add(ScalingRelationships.HANKS_BAKUN_08);
        scalingRelList.add(ScalingRelationships.ELLSWORTH_B);
        SummedMagFreqDist summedCharMFDs = new SummedMagFreqDist(minMag, numMag, deltaMag);
        SummedMagFreqDist totalTargetGR = new SummedMagFreqDist(minMag, numMag, deltaMag);
        SummedMagFreqDist targetOnFaultSupraSeisMFD = new SummedMagFreqDist(minMag, numMag, deltaMag);
        SummedMagFreqDist subSeisAndOffFaultTarget = new SummedMagFreqDist(minMag, numMag, deltaMag);
        int numBranches = 0;
        for (DeformationModels dm : defModsList) {
            for (ScalingRelationships sr : scalingRelList) {
                System.out.println("Working on " + String.valueOf(dm) + " & " + String.valueOf(sr));
                ++numBranches;
                InversionFaultSystemRupSet fltSystRupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, dm, InversionModels.CHAR_CONSTRAINED, sr, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
                ArrayList<U3SectionMFD_constraint> constraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(fltSystRupSet);
                for (U3SectionMFD_constraint mfdConstr : constraints) {
                    if (mfdConstr == null) continue;
                    ArbIncrementalMagFreqDist resampMFD = mfdConstr.getResampledToEventlyDiscrMFD(minMag, numMag, deltaMag);
                    if (!Double.isNaN(resampMFD.getTotalIncrRate())) {
                        summedCharMFDs.addIncrementalMagFreqDist(resampMFD);
                        continue;
                    }
                    System.out.println("Bad MFD");
                }
                totalTargetGR.addResampledMagFreqDist(fltSystRupSet.getInversionTargetMFDs().getTotalRegionalMFD(), true);
                targetOnFaultSupraSeisMFD.addResampledMagFreqDist(fltSystRupSet.getInversionTargetMFDs().getTotalOnFaultSupraSeisMFD(), true);
                subSeisAndOffFaultTarget.addResampledMagFreqDist(fltSystRupSet.getInversionTargetMFDs().getTotalGriddedSeisMFD(), true);
            }
        }
        summedCharMFDs.scale(1.0 / (double)numBranches);
        summedCharMFDs.setName("Sum of Char MFD Constraints");
        summedCharMFDs.setInfo("Rate(M>=6.5)=" + (float)summedCharMFDs.getCumRate(6.55));
        totalTargetGR.scale(1.0 / (double)numBranches);
        totalTargetGR.setName("totalTargetGR");
        totalTargetGR.setInfo("Rate(M>=6.5)=" + (float)totalTargetGR.getCumRate(6.55));
        targetOnFaultSupraSeisMFD.scale(1.0 / (double)numBranches);
        targetOnFaultSupraSeisMFD.setName("targetOnFaultSupraSeisMFD");
        targetOnFaultSupraSeisMFD.setInfo("Rate(M>=6.5)=" + (float)targetOnFaultSupraSeisMFD.getCumRate(6.55));
        subSeisAndOffFaultTarget.scale(1.0 / (double)numBranches);
        subSeisAndOffFaultTarget.setName("subSeisAndOffFaultTarget");
        subSeisAndOffFaultTarget.setInfo("Rate(M>=6.5)=" + (float)subSeisAndOffFaultTarget.getCumRate(6.55));
        SummedMagFreqDist totalImpliedMFD = new SummedMagFreqDist(minMag, numMag, deltaMag);
        totalImpliedMFD.addIncrementalMagFreqDist(summedCharMFDs);
        totalImpliedMFD.addIncrementalMagFreqDist(subSeisAndOffFaultTarget);
        totalImpliedMFD.setName("totalImpliedMFD");
        totalImpliedMFD.setInfo("Rate(M>=6.5)=" + (float)totalImpliedMFD.getCumRate(6.55));
        System.out.println("Total target rate test: " + totalTargetGR.getTotalIncrRate());
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(summedCharMFDs);
        funcs.add(totalTargetGR);
        funcs.add(targetOnFaultSupraSeisMFD);
        funcs.add(subSeisAndOffFaultTarget);
        funcs.add(totalImpliedMFD);
        funcs.add(totalTargetGR.getCumRateDistWithOffset());
        funcs.add(totalImpliedMFD.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.CYAN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.ORANGE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, null, 0.0f, Color.ORANGE));
        GraphWindow graph = new GraphWindow(funcs, "Sum of Char MFD Constraints", plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-6, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        String fileName = "SumOfAllBranchCharMFD_Constrints.pdf";
        if (fileName != null) {
            try {
                graph.saveAsPDF(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotSumOfGR_InversionMFD_Constraints(InversionFaultSystemRupSet fltSystRupSet) {
        System.out.println("Working on plotSumOfGR_InversionMFD_Constraints(*)");
        double minMag = 5.05;
        int numMag = 40;
        double deltaMag = 0.1;
        ArrayList<U3SectionMFD_constraint> constraints = FaultSystemRupSetCalc.getGR_InversionSectMFD_Constraints(fltSystRupSet);
        SummedMagFreqDist summedMFD = new SummedMagFreqDist(minMag, numMag, deltaMag);
        for (U3SectionMFD_constraint mfdConstr : constraints) {
            if (mfdConstr == null) continue;
            summedMFD.addIncrementalMagFreqDist(mfdConstr.getResampledToEventlyDiscrMFD(minMag, numMag, deltaMag));
        }
        summedMFD.setName("Sum of GR MFD Constraints");
        summedMFD.setInfo("Rate(M>=6.5)=" + (float)summedMFD.getCumRate(6.55));
        IncrementalMagFreqDist totalTargetGR = fltSystRupSet.getInversionTargetMFDs().getTotalRegionalMFD();
        totalTargetGR.setInfo("Rate(M>=6.5)=" + (float)totalTargetGR.getCumRate(6.55));
        SummedMagFreqDist altGR = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(fltSystRupSet, minMag, numMag, deltaMag);
        altGR.setName("calcImpliedGR_NucleationMFD(*)");
        altGR.setInfo("Rate(M>=6.5)=" + (float)altGR.getCumRate(6.55));
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(summedMFD);
        funcs.add(summedMFD.getCumRateDistWithOffset());
        funcs.add(totalTargetGR);
        funcs.add(totalTargetGR.getCumRateDistWithOffset());
        funcs.add(altGR);
        funcs.add(altGR.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 0.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, null, 0.0f, Color.BLUE));
        GraphWindow graph = new GraphWindow(funcs, "Sum of GR MFD Constraints", plotChars);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-6, 20.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        String fileName = "SumOfGR_MFD_Constrints.pdf";
    }

    public static double getMomentRateReductionFraction(FaultSystemRupSet rupSet, int sectIndex) {
        double origSlipRate = rupSet.getFaultSectionData(sectIndex).getReducedAveSlipRate() * 0.001;
        double reducedSlipRate = rupSet.getSlipRateForSection(sectIndex);
        return 1.0 - reducedSlipRate / origSlipRate;
    }

    public static double getTotalMomentRateReduction(FaultSystemRupSet rupSet) {
        return FaultSystemRupSetCalc.getTotalOrigMomentRate(rupSet) - FaultSystemRupSetCalc.getTotalReducedMomentRate(rupSet);
    }

    public static double getTotalMomentRateReductionFraction(FaultSystemRupSet rupSet) {
        return FaultSystemRupSetCalc.getTotalMomentRateReduction(rupSet) / FaultSystemRupSetCalc.getTotalOrigMomentRate(rupSet);
    }

    public static double getOrigMomentRate(FaultSystemRupSet rupSet, int sectIndex) {
        FaultSection sectData = rupSet.getFaultSectionData(sectIndex);
        double moRate = sectData.calcMomentRate(true);
        if (Double.isNaN(moRate)) {
            return 0.0;
        }
        return moRate;
    }

    public static double getTotalOrigMomentRate(FaultSystemRupSet rupSet) {
        return DeformationModelsCalc.calculateTotalMomentRate(rupSet.getFaultSectionDataList(), true);
    }

    public static double getReducedMomentRate(FaultSystemRupSet rupSet, int sectIndex) {
        return FaultSystemRupSetCalc.getOrigMomentRate(rupSet, sectIndex) * (1.0 - FaultSystemRupSetCalc.getMomentRateReductionFraction(rupSet, sectIndex));
    }

    public static double getTotalReducedMomentRate(FaultSystemRupSet rupSet) {
        double totMoRate = 0.0;
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            double sectMoment = FaultSystemRupSetCalc.getReducedMomentRate(rupSet, sectIndex);
            if (Double.isNaN(sectMoment)) continue;
            totMoRate += sectMoment;
        }
        return totMoRate;
    }

    public static void main(String[] args) {
        FaultSystemRupSetCalc.plotAllImpliedTotalSectGR_MFD();
        FaultSystemRupSetCalc.plotSumOfCharInversionMFD_Constraints();
    }
}

