/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FaultSystemSolutionCalc {
    static final boolean D = false;

    public static void writeRupRatesToFile(FaultSystemSolution fltSysSol) {
        FaultSystemRupSet rupSet = fltSysSol.getRupSet();
        File dataFile = new File("tempFSS_Rates.txt");
        try {
            FileWriter fw = new FileWriter(dataFile);
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                double mag = rupSet.getMagForRup(r);
                double rate = fltSysSol.getRateForRup(r);
                if (rate == 0.0) {
                    System.out.println("rup " + r + " has zero rate");
                }
                String str = r + "\t" + mag + "\t" + rate + "\t" + rate / Math.pow(10.0, -mag);
                fw.write(str + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static void plotPaleoObsSlipCOV_Histogram(InversionFaultSystemSolution fltSysSol) {
        FaultSystemSolutionCalc.plotPaleoObsSlipCOV_Histogram(fltSysSol, null);
    }

    public static void plotPaleoObsSlipCOV_Histogram(InversionFaultSystemSolution fltSysSol, File outputFile) {
        double delta = 0.05;
        int num = (int)Math.round(10.0 / delta);
        HistogramFunction covHist = new HistogramFunction(delta / 2.0, num, delta);
        double aveCOV = 0.0;
        for (int s = 0; s < fltSysSol.getRupSet().getNumSections(); ++s) {
            ArbDiscrEmpiricalDistFunc func = fltSysSol.calcPaleoObsSlipPFD_ForSect(s);
            double cov = func.getCOV();
            aveCOV += cov;
            covHist.add(cov, 1.0);
        }
        covHist.normalizeBySumOfY_Vals();
        covHist.setName("Slip COV Histogram");
        covHist.setInfo("(mean COV = " + (float)(aveCOV /= (double)fltSysSol.getRupSet().getNumSections()) + "; mode = " + covHist.getMode() + ")");
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.gray));
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(covHist);
        GraphWindow graph = new GraphWindow(funcList, "Slip COV Histogram", plotChars);
        graph.setX_AxisRange(0.0, 2.0);
        graph.setX_AxisLabel("Slip COV");
        graph.setY_AxisLabel("Fraction Per Bin");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        if (outputFile != null) {
            File dir = outputFile.getParentFile();
            String name = outputFile.getName();
            if (name.endsWith(".png")) {
                name = name.substring(0, name.indexOf(".png"));
            }
            if (name.endsWith(".pdf")) {
                name = name.substring(0, name.indexOf(".pdf"));
            }
            try {
                graph.saveAsPDF(new File(dir, name + ".pdf").getAbsolutePath());
                graph.saveAsPNG(new File(dir, name + ".png").getAbsolutePath());
                graph.saveAsTXT(new File(dir, name + ".txt").getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writePaleoObsSlipCOV_ForScalingRels(U3FaultSystemSolutionFetcher fetcher, File outputDir) {
        U3LogicTreeBranch ref = U3LogicTreeBranch.DEFAULT;
        for (ScalingRelationships scale : ScalingRelationships.values()) {
            if (scale.getRelativeWeight(null) == 0.0) continue;
            ref.setValue(scale);
            InversionFaultSystemSolution sol = fetcher.getSolution(ref);
            File file = outputDir == null ? null : new File(outputDir, "paleo_obs_slip_COV_" + scale.getShortName());
            FaultSystemSolutionCalc.plotPaleoObsSlipCOV_Histogram(sol, file);
        }
    }

    public static void plotRupLengthRateHistogram(FaultSystemSolution fss) {
        HistogramFunction hist = new HistogramFunction(5.0, 1235.0, 124);
        for (int r = 0; r < fss.getRupSet().getNumRuptures(); ++r) {
            double length = fss.getRupSet().getLengthForRup(r) / 1000.0;
            hist.add(length, fss.getRateForRup(r));
        }
        hist.normalizeBySumOfY_Vals();
        ArrayList<HistogramFunction> funcs2 = new ArrayList<HistogramFunction>();
        funcs2.add(hist);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
        GraphWindow graph2 = new GraphWindow(funcs2, "Rupture Length Histogram");
        graph2.setX_AxisLabel("Length (km)");
        graph2.setY_AxisLabel("Fraction");
    }

    public static void testHeadlessMFD_Plot(FaultSystemSolution fss) {
        IncrementalMagFreqDist mfd = fss.calcNucleationMFD_forRegion((Region)RELM_RegionUtils.getGriddedRegionInstance(), 5.05, 8.95, 0.1, true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setYLog(true);
        gp.setUserBounds(5.0, 9.0, 1.0E-6, 1.0);
        String title = "RELM REGION";
        String yAxisLabel = "Nucleation Rate (per yr)";
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        funcs.add(mfd);
        CommandLineInversionRunner.setFontSizes(gp);
        gp.drawGraphPanel("Magnitude", yAxisLabel, funcs, null, title);
        File file = new File("testRightHere");
        gp.getChartPanel().setSize(500, 400);
        try {
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SummedMagFreqDist[] getSubSeismNucleationMFD_inGridNodes(InversionFaultSystemSolution invSol, GriddedRegion griddedRegion) {
        double minMag = 2.05;
        double maxMag = 8.95;
        int numMag = 70;
        int numGridCells = griddedRegion.getNumLocations();
        SummedMagFreqDist[] mfdInCellArray = new SummedMagFreqDist[numGridCells];
        List<? extends IncrementalMagFreqDist> subSeisMFD_List = invSol.getFinalSubSeismoOnFaultMFD_List();
        for (int s = 0; s < subSeisMFD_List.size(); ++s) {
            LocationList locList = invSol.getRupSet().getFaultSectionData(s).getFaultSurface(1.0, false, true).getEvenlyDiscritizedListOfLocsOnSurface();
            IncrementalMagFreqDist sectMFD = subSeisMFD_List.get(s);
            sectMFD.scale(1.0 / (double)locList.size());
            for (Location loc : locList) {
                int regIndex = griddedRegion.indexForLocation(loc);
                if (regIndex == -1) continue;
                if (mfdInCellArray[regIndex] == null) {
                    mfdInCellArray[regIndex] = new SummedMagFreqDist(minMag, maxMag, numMag);
                }
                mfdInCellArray[regIndex].addIncrementalMagFreqDist(sectMFD);
            }
            sectMFD.scale(locList.size());
        }
        int numNonNull = 0;
        for (SummedMagFreqDist mfd : mfdInCellArray) {
            if (mfd == null) continue;
            ++numNonNull;
        }
        return mfdInCellArray;
    }

    public static SummedMagFreqDist[] getSupraSeismNucleationMFD_inGridNodes(InversionFaultSystemSolution invSol, GriddedRegion griddedRegion) {
        double minMag = 5.05;
        double maxMag = 8.95;
        int numMag = 40;
        int numGridCells = griddedRegion.getNumLocations();
        SummedMagFreqDist[] mfdInCellArray = new SummedMagFreqDist[numGridCells];
        List<IncrementalMagFreqDist> supraSeisMFD_List = invSol.getFinalSupraSeismoOnFaultMFD_List(minMag, maxMag, numMag);
        for (int s = 0; s < supraSeisMFD_List.size(); ++s) {
            LocationList locList = invSol.getRupSet().getFaultSectionData(s).getFaultSurface(1.0, false, true).getEvenlyDiscritizedListOfLocsOnSurface();
            IncrementalMagFreqDist sectMFD = supraSeisMFD_List.get(s);
            sectMFD.scale(1.0 / (double)locList.size());
            for (Location loc : locList) {
                int regIndex = griddedRegion.indexForLocation(loc);
                if (regIndex == -1) continue;
                if (mfdInCellArray[regIndex] == null) {
                    mfdInCellArray[regIndex] = new SummedMagFreqDist(minMag, maxMag, numMag);
                }
                mfdInCellArray[regIndex].addIncrementalMagFreqDist(sectMFD);
            }
            sectMFD.scale(locList.size());
        }
        int numNonNull = 0;
        for (SummedMagFreqDist mfd : mfdInCellArray) {
            if (mfd == null) continue;
            ++numNonNull;
        }
        return mfdInCellArray;
    }

    public static void checkFinalSubseisOnFaultRates(InversionFaultSystemSolution invSol) {
        System.out.println("Starting check");
        if (invSol instanceof InversionFaultSystemSolution) {
            List<? extends IncrementalMagFreqDist> grList = invSol.getFinalSubSeismoOnFaultMFD_List();
            for (int s = 0; s < grList.size(); ++s) {
                double rate = grList.get(s).getTotalIncrRate();
                System.out.println(s + "\t" + (float)rate + "\t" + invSol.getRupSet().getFaultSectionData(s).getName());
                if (!(rate < 1.0E-10)) continue;
                System.out.println(invSol.getRupSet().getFaultSectionData(s).getName());
            }
        } else {
            System.out.println("Not instance of InversionFaultSystemSolution");
        }
        System.out.println("Done with check");
    }

    public static void countNumRupsOnSubSectionForFM3pt1(int sectID) {
        String f = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        File file = new File(f);
        U3FaultSystemSolution fss = null;
        try {
            fss = U3FaultSystemIO.loadSol(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
        int num = 0;
        FaultSystemRupSet rupSet = ((FaultSystemSolution)fss).getRupSet();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            if (!rupSet.getSectionsIndicesForRup(r).contains(sectID)) continue;
            ++num;
        }
        System.out.println("sectID=" + sectID + " has " + num + " ruptures; sectName is " + rupSet.getFaultSectionData(sectID).getName());
    }

    public static void writeFM3pt1_SubSectionOutlinesWithPartRatesForGMT() {
        String fileName = "fm3pt1_forGMT.txt";
        String f = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        File file = new File(f);
        U3FaultSystemSolution fss = null;
        try {
            fss = U3FaultSystemIO.loadSol(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
        FaultSystemRupSet rupSet = ((FaultSystemSolution)fss).getRupSet();
        ArrayList<CallSite> lineList = new ArrayList<CallSite>();
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            FaultSection data = rupSet.getFaultSectionData(s);
            double partRate = fss.calcParticRateForSect(s, 0.0, 10.0);
            lineList.add((CallSite)((Object)("> -Z" + (float)Math.log10(partRate))));
            RuptureSurface surf = data.getFaultSurface(1.0, false, false);
            Preconditions.checkState((boolean)(surf instanceof EvenlyGriddedSurface));
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
            ArrayList<Location> locList = new ArrayList<Location>();
            locList.add(gridSurf.getLocation(0, 0));
            locList.add(gridSurf.getLocation(0, gridSurf.getNumCols() - 1));
            locList.add(gridSurf.getLocation(gridSurf.getNumRows() - 1, gridSurf.getNumCols() - 1));
            locList.add(gridSurf.getLocation(gridSurf.getNumRows() - 1, 0));
            for (Location loc : locList) {
                lineList.add((CallSite)((Object)((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)(-loc.getDepth()))));
            }
        }
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/" + fileName);
        try {
            FileWriter fw = new FileWriter(dataFile);
            for (String string : lineList) {
                fw.write(string + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static void main(String[] args) throws ZipException, IOException {
        FaultSystemSolutionCalc.countNumRupsOnSubSectionForFM3pt1(1935);
    }
}

