/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.util.SlipAlongRuptureModelBranchNode;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum SlipAlongRuptureModels implements U3LogicTreeBranchNode<SlipAlongRuptureModels>,
SlipAlongRuptureModelBranchNode
{
    CHAR("Characteristic", "Char", 0.0, null),
    UNIFORM("Uniform", "Uni", 0.5, new SlipAlongRuptureModel.Uniform()),
    WG02("WGCEP-2002", "WG02", 0.0, new SlipAlongRuptureModel.WG02()),
    TAPERED("Tapered Ends", "Tap", 0.5, new SlipAlongRuptureModel.Tapered()),
    MEAN_UCERF3("Mean UCERF3 Dsr", "MeanU3Dsr", 0.0, new SlipAlongRuptureModel.AVG_UCERF3());

    private final String name;
    private final String shortName;
    private final double weight;
    private final SlipAlongRuptureModel model;

    private SlipAlongRuptureModels(String name, String shortName, double weight, SlipAlongRuptureModel model) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
        this.model = model;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        return this.weight;
    }

    @Override
    public String encodeChoiceString() {
        return "Dsr" + this.getShortName();
    }

    @Override
    public String getBranchLevelName() {
        return "Slip Along Rupture Model (Dsr)";
    }

    @Override
    public String getShortBranchLevelName() {
        return "Dsr";
    }

    @Override
    public SlipAlongRuptureModel getModel() {
        if (this.model == null) {
            throw new IllegalStateException("Model not yet implemented: " + this.getName());
        }
        return this.model;
    }

    public static double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, SlipAlongRuptureModels slipModelType, double[] sectArea, double aveSlip) {
        return slipModelType.getModel().calcSlipOnSectionsForRup(rupSet, rthRup, sectArea, aveSlip);
    }
}

