/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import java.util.ArrayList;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.gui.plot.GraphWindow;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;

public class CodeTests {
    public boolean testIntegerPDF_FunctionSampler(IntegerPDF_FunctionSampler sampler) {
        int i;
        double total = sampler.calcSumOfY_Vals();
        sampler.scale(1.0 / total);
        EvenlyDiscretizedFunc testFunc = new EvenlyDiscretizedFunc(sampler.getX(0), sampler.size(), sampler.getDelta());
        int numSamples = 100000000;
        for (i = 0; i < numSamples; ++i) {
            testFunc.add(sampler.getRandomInt(), 1.0);
        }
        for (i = 0; i < testFunc.size(); ++i) {
            testFunc.set(i, testFunc.getY(i) / (double)numSamples);
        }
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(sampler);
        funcs.add(testFunc);
        GraphWindow sr_graph = new GraphWindow(funcs, "");
        double maxDiff = 0.0;
        for (int i2 = 0; i2 < testFunc.size(); ++i2) {
            double diff = Math.abs(testFunc.getY(i2) - sampler.getY(i2));
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
        }
        return maxDiff < 1.0E-4;
    }

    public boolean testGetDefaultRandomTimeOfEvent(double tMin, double tMax, double tDelta) {
        int i;
        int i2;
        ETAS_Utils utils = new ETAS_Utils();
        EvenlyDiscretizedFunc targetFunc = ETAS_Utils.getDefaultNumWithTimeFunc(5.0, tMin, tMax, tDelta);
        double sum = 0.0;
        for (i2 = 0; i2 < targetFunc.size(); ++i2) {
            sum += targetFunc.getY(i2);
        }
        for (i2 = 0; i2 < targetFunc.size(); ++i2) {
            targetFunc.set(i2, targetFunc.getY(i2) / sum);
        }
        EvenlyDiscretizedFunc histogram = new EvenlyDiscretizedFunc(tMin + tDelta / 2.0, tMax - tDelta / 2.0, (int)Math.round((tMax - tMin) / tDelta));
        histogram.setTolerance(tDelta);
        int numSamples = 10000000;
        for (i = 0; i < numSamples; ++i) {
            histogram.add(utils.getDefaultRandomTimeOfEvent(tMin, tMax), 1.0);
        }
        for (i = 0; i < histogram.size(); ++i) {
            histogram.set(i, histogram.getY(i) / (double)numSamples);
        }
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(targetFunc);
        funcs.add(histogram);
        GraphWindow sr_graph = new GraphWindow(funcs, "");
        double maxDiff = 0.0;
        for (int i3 = 0; i3 < targetFunc.size(); ++i3) {
            double diff = Math.abs(targetFunc.getY(i3) - histogram.getY(i3));
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
        }
        System.out.println("testGetDefaultRandomTimeOfEvent maxDiff=" + maxDiff);
        return maxDiff < 1.0E-4;
    }

    public boolean testGetPoissonRandomNumber(double lambda) {
        int i;
        int maxNum = 20;
        ETAS_Utils utils = new ETAS_Utils();
        EvenlyDiscretizedFunc targetFunc = new EvenlyDiscretizedFunc(0.0, maxNum, 1.0);
        for (int i2 = 0; i2 < maxNum; ++i2) {
            double y = Math.pow(lambda, i2) * Math.exp(-lambda) / (double)ArithmeticUtils.factorial((int)i2);
            targetFunc.set(i2, y);
        }
        EvenlyDiscretizedFunc histogram = new EvenlyDiscretizedFunc(0.0, maxNum, 1.0);
        histogram.setTolerance(1.0);
        int numSamples = 100000000;
        for (i = 0; i < numSamples; ++i) {
            int index = utils.getPoissonRandomNumber(lambda);
            if (index >= maxNum) continue;
            histogram.add(index, 1.0);
        }
        for (i = 0; i < histogram.size(); ++i) {
            histogram.set(i, histogram.getY(i) / (double)numSamples);
        }
        double maxDiff = 0.0;
        for (int i3 = 0; i3 < targetFunc.size(); ++i3) {
            double diff = Math.abs(targetFunc.getY(i3) - histogram.getY(i3));
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
        }
        System.out.println("testGetPoissonRandomNumber maxDiff=" + maxDiff);
        return maxDiff < 1.0E-4;
    }

    public static void main(String[] args) {
        CodeTests tests2 = new CodeTests();
    }
}

