/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameComparator;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_MultiSimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;

public class ETAS_CatalogIO {
    public static SimpleDateFormat catDateFormat = new SimpleDateFormat("yyyy\tMM\tdd\tHH\tmm\tss.SSS");
    public static final TimeZone utc = TimeZone.getTimeZone("UTC");
    public static final String EVENT_FILE_HEADER = "Year\tMonth\tDay\tHour\tMinute\tSec\tLat\tLon\tDepth\tMagnitude\tID\tparID\tGen\tOrigTime\tdistToParent\tnthERFIndex\tFSS_ID\tGridNodeIndex\tETAS_k";
    private static Map<Integer, Long> binaryVersionRuptureLengthMap;
    private static Map<Integer, Long> binaryVersionHeaderLengthMap;
    public static final int buffer_len = 0x640000;
    private static final int MAX_ITERABLE_PRELOAD_CAPACITY = 500;

    public static void writeEventDataToFile(File file, Collection<ETAS_EqkRupture> simulatedRupsQueue) throws IOException {
        FileWriter fw1 = new FileWriter(file);
        ETAS_CatalogIO.writeEventDataToWriter(fw1, simulatedRupsQueue);
        fw1.close();
    }

    public static void writeEventDataToWriter(Writer writer, Collection<ETAS_EqkRupture> simulatedRupsQueue) throws IOException {
        if (simulatedRupsQueue instanceof ETAS_Catalog && ((ETAS_Catalog)simulatedRupsQueue).getSimulationMetadata() != null) {
            ETAS_CatalogIO.writeMetadataToFile(writer, ((ETAS_Catalog)simulatedRupsQueue).getSimulationMetadata());
            writer.write("% \n");
        }
        ETAS_CatalogIO.writeEventHeaderToFile(writer);
        for (ETAS_EqkRupture rup : simulatedRupsQueue) {
            ETAS_CatalogIO.writeEventToFile(writer, rup);
        }
    }

    public static void writeEventHeaderToFile(Writer fileWriter) throws IOException {
        fileWriter.write("% Year\tMonth\tDay\tHour\tMinute\tSec\tLat\tLon\tDepth\tMagnitude\tID\tparID\tGen\tOrigTime\tdistToParent\tnthERFIndex\tFSS_ID\tGridNodeIndex\tETAS_k\n");
    }

    public static void writeMetadataToFile(Writer fw, ETAS_SimulationMetadata meta) throws IOException {
        fw.write("% ------------ METADATA -------------\n");
        fw.write("% numRuptures = " + meta.totalNumRuptures + "\n");
        fw.write("% randomSeed = " + meta.randomSeed + "\n");
        if (meta.catalogIndex >= 0) {
            fw.write("% catalogIndex = " + meta.catalogIndex + "\n");
        }
        if (meta.rangeHistCatalogIDs != null) {
            fw.write("% rangeHistCatalogIDs = [" + String.valueOf(meta.rangeHistCatalogIDs.lowerEndpoint()) + " " + String.valueOf(meta.rangeHistCatalogIDs.upperEndpoint()) + "]\n");
        }
        if (meta.rangeTriggerRupIDs != null) {
            fw.write("% triggerRupParentIDs = [" + String.valueOf(meta.rangeTriggerRupIDs.lowerEndpoint()) + " " + String.valueOf(meta.rangeTriggerRupIDs.upperEndpoint()) + "]\n");
        }
        fw.write("% simulationStartTime = " + meta.simulationStartTime + "\n");
        fw.write("% simulationEndTime = " + meta.simulationEndTime + "\n");
        fw.write("% numSpontaneousRuptures = " + meta.numSpontaneousRuptures + "\n");
        fw.write("% numSupraSeis = " + meta.numSupraSeis + "\n");
        fw.write("% minMag = " + meta.minMag + "\n");
        fw.write("% maxMag = " + meta.maxMag + "\n");
        fw.write("% -----------------------------------\n");
    }

    public static void writeEventToFile(Writer fileWriter, ETAS_EqkRupture rup) throws IOException {
        fileWriter.write(ETAS_CatalogIO.getEventFileLine(rup) + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEventFileLine(ETAS_EqkRupture rup) {
        Location hypoLoc = rup.getHypocenterLocation();
        StringBuilder sb = new StringBuilder();
        Class<ETAS_CatalogIO> clazz = ETAS_CatalogIO.class;
        synchronized (ETAS_CatalogIO.class) {
            sb.append(catDateFormat.format(rup.getOriginTimeCal().getTime())).append("\t");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (hypoLoc != null) {
                sb.append((float)hypoLoc.getLatitude()).append("\t");
                sb.append((float)hypoLoc.getLongitude()).append("\t");
                sb.append((float)hypoLoc.getDepth()).append("\t");
            } else {
                sb.append("null").append("\t");
                sb.append("null").append("\t");
                sb.append("null").append("\t");
            }
            sb.append((float)rup.getMag()).append("\t");
            sb.append(rup.getID()).append("\t");
            sb.append(rup.getParentID()).append("\t");
            sb.append(rup.getGeneration()).append("\t");
            sb.append(rup.getOriginTime()).append("\t");
            sb.append((float)rup.getDistanceToParent()).append("\t");
            sb.append(rup.getNthERF_Index()).append("\t");
            sb.append(rup.getFSSIndex()).append("\t");
            sb.append(rup.getGridNodeIndex()).append("\t");
            sb.append(rup.getETAS_k());
            return sb.toString();
        }
    }

    public static ETAS_EqkRupture loadRuptureFromFileLine(String line) {
        double k;
        int gridNodeIndex;
        int fssIndex;
        double depth;
        double lon;
        double lat;
        double mag;
        double distToParent;
        long origTime;
        int gen;
        int parentID;
        int id;
        int nthERFIndex;
        String[] split = (line = line.trim()).split("\t");
        Preconditions.checkState((split.length == 10 || split.length == 12 || split.length == 18 || split.length == 19 ? 1 : 0) != 0, (String)"Line has unexpected number of items. Expected 10/12/18/19, got %s. Line: %s", (int)split.length, (Object)line);
        if (split.length == 10 || split.length == 12) {
            nthERFIndex = Integer.parseInt(split[0]);
            id = Integer.parseInt(split[1]);
            parentID = Integer.parseInt(split[2]);
            gen = Integer.parseInt(split[3]);
            origTime = Long.parseLong(split[4]);
            distToParent = Double.parseDouble(split[5]);
            mag = Double.parseDouble(split[6]);
            lat = Double.parseDouble(split[7]);
            lon = Double.parseDouble(split[8]);
            depth = Double.parseDouble(split[9]);
            if (split.length == 12) {
                fssIndex = Integer.parseInt(split[10]);
                gridNodeIndex = Integer.parseInt(split[11]);
            } else {
                fssIndex = -1;
                gridNodeIndex = -1;
            }
            k = Double.NaN;
        } else {
            lat = Double.parseDouble(split[6]);
            lon = Double.parseDouble(split[7]);
            depth = Double.parseDouble(split[8]);
            mag = Double.parseDouble(split[9]);
            id = Integer.parseInt(split[10]);
            parentID = Integer.parseInt(split[11]);
            gen = Integer.parseInt(split[12]);
            origTime = Long.parseLong(split[13]);
            distToParent = Double.parseDouble(split[14]);
            nthERFIndex = Integer.parseInt(split[15]);
            fssIndex = Integer.parseInt(split[16]);
            gridNodeIndex = Integer.parseInt(split[17]);
            k = split.length == 19 ? Double.parseDouble(split[18]) : Double.NaN;
        }
        Location loc = new Location(lat, lon, depth);
        ETAS_EqkRupture rup = new ETAS_EqkRupture();
        rup.setNthERF_Index(nthERFIndex);
        rup.setID(id);
        rup.setParentID(parentID);
        rup.setGeneration(gen);
        rup.setOriginTime(origTime);
        rup.setDistanceToParent(distToParent);
        rup.setMag(mag);
        rup.setHypocenterLocation(loc);
        rup.setFSSIndex(fssIndex);
        rup.setGridNodeIndex(gridNodeIndex);
        rup.setETAS_k(k);
        return rup;
    }

    public static ETAS_Catalog loadCatalog(File catalogFile) throws IOException {
        return ETAS_CatalogIO.loadCatalog(catalogFile, -10.0);
    }

    private static boolean isBinary(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".bin") || name.endsWith(".gz");
    }

    public static ETAS_Catalog loadCatalog(File catalogFile, double minMag) throws IOException {
        return ETAS_CatalogIO.loadCatalog(catalogFile, minMag, false);
    }

    public static ETAS_Catalog loadCatalog(File catalogFile, double minMag, boolean ignoreFailure) throws IOException {
        if (ETAS_CatalogIO.isBinary(catalogFile)) {
            return ETAS_CatalogIO.loadCatalogBinary(catalogFile, minMag);
        }
        ETAS_Catalog catalog = new ETAS_Catalog(null);
        HashMap<String, String> metaValues = new HashMap<String, String>();
        for (String line : Files.readLines((File)catalogFile, (Charset)Charset.defaultCharset())) {
            ETAS_EqkRupture rup;
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            if (line.startsWith("%")) {
                if (!line.contains(" = ")) continue;
                String[] split = line.split(" = ");
                if (split.length != 2) {
                    System.err.println("Thought we had a metadata line but split.lengh=" + split.length + " for: " + line);
                }
                metaValues.put(split[0].replaceAll("%", "").trim(), split[1].trim());
                continue;
            }
            try {
                rup = ETAS_CatalogIO.loadRuptureFromFileLine(line);
            }
            catch (RuntimeException e) {
                if (ignoreFailure) {
                    System.err.println("Warning, skipping line: " + e.getMessage() + "\n\tFile: " + catalogFile.getAbsolutePath());
                    continue;
                }
                throw e;
            }
            if (!(rup.getMag() >= minMag)) continue;
            catalog.add(rup);
        }
        if (!metaValues.isEmpty()) {
            catalog.meta = ETAS_CatalogIO.loadMetadataASCII(metaValues);
        }
        return catalog;
    }

    private static ETAS_SimulationMetadata loadMetadataASCII(Map<String, String> metaValues) {
        int totalNumRuptures = metaValues.containsKey("totalNumRuptures") ? Integer.parseInt(metaValues.get("numRuptures")) : -1;
        long randomSeed = metaValues.containsKey("randomSeed") ? Long.parseLong(metaValues.get("randomSeed")) : -1L;
        int catalogIndex = metaValues.containsKey("catalogIndex") ? Integer.parseInt(metaValues.get("catalogIndex")) : -1;
        Range<Integer> rangeHistCatalogIDs = metaValues.containsKey("rangeHistCatalogIDs") ? ETAS_CatalogIO.loadRangeASCII(metaValues.get("rangeHistCatalogIDs")) : null;
        Range<Integer> rangeTriggerRupIDs = metaValues.containsKey("triggerRupParentIDs") ? ETAS_CatalogIO.loadRangeASCII(metaValues.get("triggerRupParentIDs")) : null;
        long simulationStartTime = metaValues.containsKey("simulationStartTime") ? Long.parseLong(metaValues.get("simulationStartTime")) : -1L;
        long simulationEndTime = metaValues.containsKey("simulationEndTime") ? Long.parseLong(metaValues.get("simulationEndTime")) : -1L;
        int numSpontaneousRuptures = metaValues.containsKey("numSpontaneousRuptures") ? Integer.parseInt(metaValues.get("numSpontaneousRuptures")) : -1;
        int numSupraSeis = metaValues.containsKey("numSupraSeis") ? Integer.parseInt(metaValues.get("numSupraSeis")) : -1;
        double minMag = metaValues.containsKey("minMag") ? Double.parseDouble(metaValues.get("minMag")) : Double.NaN;
        double maxMag = metaValues.containsKey("maxMag") ? Double.parseDouble(metaValues.get("maxMag")) : Double.NaN;
        return ETAS_SimulationMetadata.instance(totalNumRuptures, randomSeed, catalogIndex, rangeHistCatalogIDs, rangeTriggerRupIDs, simulationStartTime, simulationEndTime, numSpontaneousRuptures, numSupraSeis, minMag, maxMag);
    }

    private static Range<Integer> loadRangeASCII(String valStr) {
        Preconditions.checkState((valStr.startsWith("[") && valStr.endsWith("]") ? 1 : 0) != 0);
        valStr = valStr.substring(1, valStr.length() - 1);
        String[] split = valStr.split(" ");
        return Range.closed((Comparable)Integer.valueOf(Integer.parseInt(split[0])), (Comparable)Integer.valueOf(Integer.parseInt(split[1])));
    }

    public static List<ETAS_EqkRupture> loadCatalog(InputStream catalogStream) throws IOException {
        return ETAS_CatalogIO.loadCatalog(catalogStream, -10.0);
    }

    public static ETAS_Catalog loadCatalog(InputStream catalogStream, double minMag) throws IOException {
        return ETAS_CatalogIO.loadCatalog(catalogStream, minMag, false);
    }

    public static ETAS_Catalog loadCatalog(InputStream catalogStream, double minMag, boolean ignoreFailure) throws IOException {
        ETAS_Catalog catalog = new ETAS_Catalog(null);
        BufferedReader reader = new BufferedReader(new InputStreamReader(catalogStream));
        HashMap<String, String> metaValues = new HashMap<String, String>();
        for (String line : CharStreams.readLines((Readable)reader)) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            if (line.startsWith("%")) {
                if (!line.contains(" = ")) continue;
                String[] split = line.split(" = ");
                if (split.length != 2) {
                    System.err.println("Thought we had a metadata line but split.lengh=" + split.length + " for: " + line);
                }
                metaValues.put(split[0].replaceAll("%", "").trim(), split[1].trim());
                continue;
            }
            try {
                ETAS_EqkRupture rup = ETAS_CatalogIO.loadRuptureFromFileLine(line);
                if (!(rup.getMag() >= minMag)) continue;
                catalog.add(rup);
            }
            catch (RuntimeException e) {
                if (ignoreFailure) {
                    System.err.println("Warning, skipping line: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        if (!metaValues.isEmpty()) {
            catalog.meta = ETAS_CatalogIO.loadMetadataASCII(metaValues);
        }
        return catalog;
    }

    public static void writeCatalogBinary(File file, List<ETAS_EqkRupture> catalog) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkNotNull(catalog, (Object)"Catalog cannot be null!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 0x640000));
        ETAS_CatalogIO.writeCatalogBinary(out, catalog);
        out.close();
    }

    public static void writeCatalogsBinary(File file, List<? extends List<ETAS_EqkRupture>> catalogs) throws IOException {
        Preconditions.checkNotNull(catalogs, (Object)"Catalog cannot be null!");
        DataOutputStream out = ETAS_CatalogIO.initCatalogsBinary(file, catalogs.size());
        for (List<ETAS_EqkRupture> list : catalogs) {
            ETAS_CatalogIO.writeCatalogBinary(out, list);
        }
        out.close();
    }

    public static DataOutputStream initCatalogsBinary(File file, int numCatalogs) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((numCatalogs > 0 ? 1 : 0) != 0, (Object)"Must supply at least one catalog");
        FileOutputStream fout = new FileOutputStream(file);
        Preconditions.checkArgument((numCatalogs > 0 ? 1 : 0) != 0, (Object)"Must supply at least one catalog");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fout, 0x640000));
        out.writeInt(numCatalogs);
        return out;
    }

    public static long getCatalogLengthBytes(int numRuptures, int version, boolean includeHeader) {
        long ret = (long)numRuptures * binaryVersionRuptureLengthMap.get(version);
        if (includeHeader) {
            ret += binaryVersionHeaderLengthMap.get(version).longValue();
        }
        return ret;
    }

    public static void writeCatalogBinary(DataOutputStream out, List<ETAS_EqkRupture> catalog) throws IOException {
        if (catalog instanceof ETAS_Catalog && ((ETAS_Catalog)catalog).getSimulationMetadata() != null) {
            out.writeShort(3);
            ETAS_SimulationMetadata meta = ((ETAS_Catalog)catalog).getSimulationMetadata();
            out.writeInt(meta.totalNumRuptures);
            out.writeLong(meta.randomSeed);
            out.writeInt(meta.catalogIndex);
            if (meta.rangeHistCatalogIDs == null) {
                out.writeInt(-1);
                out.writeInt(-1);
            } else {
                out.writeInt((Integer)meta.rangeHistCatalogIDs.lowerEndpoint());
                out.writeInt((Integer)meta.rangeHistCatalogIDs.upperEndpoint());
            }
            if (meta.rangeTriggerRupIDs == null) {
                out.writeInt(-1);
                out.writeInt(-1);
            } else {
                out.writeInt((Integer)meta.rangeTriggerRupIDs.lowerEndpoint());
                out.writeInt((Integer)meta.rangeTriggerRupIDs.upperEndpoint());
            }
            out.writeLong(meta.simulationStartTime);
            out.writeLong(meta.simulationStartTime);
            out.writeInt(meta.numSpontaneousRuptures);
            out.writeInt(meta.numSupraSeis);
            out.writeDouble(meta.minMag);
            out.writeDouble(meta.maxMag);
        } else {
            out.writeShort(2);
        }
        out.writeInt(catalog.size());
        for (ETAS_EqkRupture rup : catalog) {
            out.writeInt(rup.getID());
            out.writeInt(rup.getParentID());
            out.writeShort(rup.getGeneration());
            out.writeLong(rup.getOriginTime());
            Location hypo = rup.getHypocenterLocation();
            out.writeDouble(hypo.getLatitude());
            out.writeDouble(hypo.getLongitude());
            out.writeDouble(hypo.getDepth());
            out.writeDouble(rup.getMag());
            out.writeDouble(rup.getDistanceToParent());
            out.writeInt(rup.getNthERF_Index());
            out.writeInt(rup.getFSSIndex());
            out.writeInt(rup.getGridNodeIndex());
            out.writeDouble(rup.getETAS_k());
        }
    }

    public static ETAS_Catalog loadCatalogBinary(File file) throws IOException {
        return ETAS_CatalogIO.loadCatalogBinary(file, -10.0);
    }

    public static ETAS_Catalog loadCatalogBinary(File file, double minMag) throws IOException {
        return ETAS_CatalogIO.loadCatalogBinary(ETAS_CatalogIO.getIS(file), minMag);
    }

    public static ETAS_Catalog loadCatalogBinary(InputStream is, double minMag) throws IOException {
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        ETAS_Catalog catalog = ETAS_CatalogIO.doLoadCatalogBinary(in, minMag);
        in.close();
        return catalog;
    }

    public static List<ETAS_Catalog> loadCatalogsBinary(File file) throws IOException {
        return ETAS_CatalogIO.loadCatalogsBinary(file, -10.0);
    }

    public static List<ETAS_Catalog> loadCatalogsBinary(File file, double minMag) throws IOException {
        return ETAS_CatalogIO.loadCatalogsBinary(ETAS_CatalogIO.getIS(file), minMag);
    }

    private static InputStream getIS(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        FileInputStream fis = new FileInputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            return new GZIPInputStream((InputStream)fis, 0x640000);
        }
        return new BufferedInputStream(fis, 0x640000);
    }

    public static List<ETAS_Catalog> loadCatalogsBinary(InputStream is, double minMag) throws IOException {
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream) && !(is instanceof GZIPInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        ArrayList<ETAS_Catalog> catalogs = new ArrayList<ETAS_Catalog>();
        int numCatalogs = in.readInt();
        int printMod = 1000;
        if (numCatalogs >= 100000) {
            printMod = 10000;
        }
        Preconditions.checkState((numCatalogs > 0 ? 1 : 0) != 0, (String)"Bad num catalogs: %s", (int)numCatalogs);
        for (int i = 0; i < numCatalogs; ++i) {
            catalogs.add(ETAS_CatalogIO.doLoadCatalogBinary(in, minMag));
            if ((i + 1) % printMod != 0 || i >= numCatalogs) continue;
            System.out.println("Loaded " + (i + 1) + "/" + numCatalogs + " catalogs (and counting)...");
        }
        System.out.println("Loaded " + catalogs.size() + " catalogs");
        in.close();
        return catalogs;
    }

    public static boolean isBinaryCatalogFileComplete(File eventsFile) {
        try {
            InputStream is = ETAS_CatalogIO.getIS(eventsFile);
            DataInputStream in = new DataInputStream(is);
            short version = in.readShort();
            ETAS_CatalogIO.readBinaryMetadata(in, version);
            int numRuptures = in.readInt();
            if (is instanceof GZIPInputStream) {
                return true;
            }
            long calcLen = ETAS_CatalogIO.getCatalogLengthBytes(numRuptures, version, true);
            return eventsFile.length() == calcLen;
        }
        catch (IOException e) {
            System.err.println("Error reading binary file, assuming not complete: " + e.getMessage());
            return false;
        }
    }

    public static ETAS_SimulationMetadata readBinaryMetadata(DataInput in, short version) throws IOException {
        Preconditions.checkState((version >= 1 && version <= 3 ? 1 : 0) != 0, (String)"Bad version=%s", (int)version);
        if (version == 3) {
            long simulationStartTime;
            int totalNumRuptures = in.readInt();
            Preconditions.checkState((totalNumRuptures >= -1 ? 1 : 0) != 0, (String)"Bad numRuptures=%s", (int)totalNumRuptures);
            long randomSeed = in.readLong();
            int catalogIndex = in.readInt();
            Preconditions.checkState((catalogIndex >= -1 ? 1 : 0) != 0, (String)"Bad catalogIndex=%s", (int)catalogIndex);
            Range rangeHistCatalogIDs = null;
            int startHistID = in.readInt();
            Preconditions.checkState((startHistID >= -1 ? 1 : 0) != 0, (String)"Bad startHistID=%s", (int)startHistID);
            int endHistID = in.readInt();
            Preconditions.checkState((endHistID >= startHistID ? 1 : 0) != 0, (String)"Bad endHistID=%s", (int)endHistID);
            if (startHistID >= 0) {
                rangeHistCatalogIDs = Range.closed((Comparable)Integer.valueOf(startHistID), (Comparable)Integer.valueOf(endHistID));
            }
            Range rangeTriggerRupIDs = null;
            int startTriggerID = in.readInt();
            Preconditions.checkState((startTriggerID >= -1 ? 1 : 0) != 0, (String)"Bad startTriggerID=%s", (int)startTriggerID);
            int endTriggerID = in.readInt();
            Preconditions.checkState((endTriggerID >= startTriggerID ? 1 : 0) != 0, (String)"Bad endTriggerID=%s", (int)endTriggerID);
            if (startTriggerID >= 0) {
                rangeTriggerRupIDs = Range.closed((Comparable)Integer.valueOf(startTriggerID), (Comparable)Integer.valueOf(endTriggerID));
            }
            Preconditions.checkState(((simulationStartTime = in.readLong()) >= 0L ? 1 : 0) != 0, (String)"Bad simulationStartTime=%s", (long)simulationStartTime);
            long simulationEndTime = in.readLong();
            Preconditions.checkState((simulationEndTime >= simulationStartTime ? 1 : 0) != 0, (String)"Bad simulationEndTime=%s", (long)simulationEndTime);
            int numSpontaneousRuptures = in.readInt();
            Preconditions.checkState((numSpontaneousRuptures >= 0 ? 1 : 0) != 0, (String)"Bad numSpontaneousRuptures=%s", (int)numSpontaneousRuptures);
            int numSupraSeis = in.readInt();
            Preconditions.checkState((numSupraSeis >= 0 ? 1 : 0) != 0, (String)"Bad numSupraSeis=%s", (int)numSupraSeis);
            double minMag = in.readDouble();
            double maxMag = in.readDouble();
            return ETAS_SimulationMetadata.instance(totalNumRuptures, randomSeed, catalogIndex, (Range<Integer>)rangeHistCatalogIDs, (Range<Integer>)rangeTriggerRupIDs, simulationStartTime, simulationEndTime, numSpontaneousRuptures, numSupraSeis, minMag, maxMag);
        }
        return null;
    }

    private static ETAS_Catalog doLoadCatalogBinary(DataInput in, double minMag) throws IOException {
        int numRups;
        double metaMinMag;
        short version = in.readShort();
        Preconditions.checkState((version == 1 || version == 2 || version == 3 ? 1 : 0) != 0, (Object)("Unknown binary file version: " + version));
        ETAS_SimulationMetadata meta = ETAS_CatalogIO.readBinaryMetadata(in, version);
        if (meta != null && (minMag > (metaMinMag = meta.minMag) || minMag > 0.0 && !Double.isFinite(metaMinMag))) {
            meta = meta.getModMinMag(minMag);
        }
        Preconditions.checkState(((numRups = in.readInt()) >= 0 ? 1 : 0) != 0, (Object)("Bad num rups: " + numRups));
        ETAS_Catalog catalog = new ETAS_Catalog(meta);
        for (int i = 0; i < numRups; ++i) {
            double k;
            int id = in.readInt();
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0);
            int parentID = in.readInt();
            Preconditions.checkState((id >= -1 ? 1 : 0) != 0);
            short gen = in.readShort();
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0);
            long origTime = in.readLong();
            double lat = in.readDouble();
            double lon = in.readDouble();
            double depth = in.readDouble();
            double mag = in.readDouble();
            Preconditions.checkState((mag >= 0.0 && mag < 10.0 ? 1 : 0) != 0, (String)"Bad Mag: %s", (Object)mag);
            double distToParent = in.readDouble();
            Preconditions.checkState((Double.isNaN(distToParent) || distToParent >= 0.0 ? 1 : 0) != 0, (String)"bad dist to parent: %s", (Object)distToParent);
            int nthERFIndex = in.readInt();
            Preconditions.checkState((nthERFIndex >= -1 ? 1 : 0) != 0, (String)"Bad Grid Node Index: %s", (int)nthERFIndex);
            int fssIndex = in.readInt();
            Preconditions.checkState((fssIndex >= -1 ? 1 : 0) != 0, (String)"Bad Grid Node Index: %s", (int)fssIndex);
            int gridNodeIndex = in.readInt();
            Preconditions.checkState((gridNodeIndex >= -1 ? 1 : 0) != 0, (String)"Bad Grid Node Index: %s", (int)gridNodeIndex);
            double d = k = version >= 2 ? in.readDouble() : Double.NaN;
            if (mag < minMag) continue;
            Location loc = new Location(lat, lon, depth);
            ETAS_EqkRupture rup = new ETAS_EqkRupture();
            rup.setNthERF_Index(nthERFIndex);
            rup.setID(id);
            rup.setParentID(parentID);
            rup.setGeneration(gen);
            rup.setOriginTime(origTime);
            rup.setDistanceToParent(distToParent);
            rup.setMag(mag);
            rup.setHypocenterLocation(loc);
            rup.setFSSIndex(fssIndex);
            rup.setGridNodeIndex(gridNodeIndex);
            rup.setETAS_k(k);
            catalog.add(rup);
        }
        return catalog;
    }

    public static List<ETAS_Catalog> loadCatalogs(File zipFile) throws ZipException, IOException {
        return ETAS_CatalogIO.loadCatalogs(zipFile, -10.0);
    }

    public static List<ETAS_Catalog> loadCatalogs(File zipFile, double minMag) throws ZipException, IOException {
        return ETAS_CatalogIO.loadCatalogs(zipFile, minMag, false);
    }

    public static List<ETAS_Catalog> loadCatalogs(File zipFile, double minMag, boolean ignoreFailure) throws ZipException, IOException {
        if (ETAS_CatalogIO.isBinary(zipFile)) {
            return ETAS_CatalogIO.loadCatalogsBinary(zipFile, minMag);
        }
        ZipFile zip = new ZipFile(zipFile);
        ArrayList<ETAS_Catalog> catalogs = new ArrayList<ETAS_Catalog>();
        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
            String subEntryName;
            ZipEntry catEntry;
            if (!zipEntry.isDirectory() || (catEntry = zip.getEntry(subEntryName = zipEntry.getName() + "simulatedEvents.txt")) == null) continue;
            try {
                ETAS_Catalog cat = ETAS_CatalogIO.loadCatalog(zip.getInputStream(catEntry), minMag, ignoreFailure);
                catalogs.add(cat);
            }
            catch (Exception e) {
                System.out.println("Skipping catalog " + zipEntry.getName() + ": " + e.getMessage());
            }
            if (catalogs.size() % 1000 != 0) continue;
            System.out.println("Loaded " + catalogs.size() + " catalogs (and counting)...");
        }
        zip.close();
        System.out.println("Loaded " + catalogs.size() + " catalogs");
        return catalogs;
    }

    private static void assertEquals(ETAS_EqkRupture expected, ETAS_EqkRupture actual) {
        Preconditions.checkState((expected.getID() == actual.getID() ? 1 : 0) != 0);
        Preconditions.checkState((expected.getParentID() == actual.getParentID() ? 1 : 0) != 0);
        Preconditions.checkState((expected.getGeneration() == actual.getGeneration() ? 1 : 0) != 0);
        Preconditions.checkState((expected.getOriginTime() == actual.getOriginTime() ? 1 : 0) != 0);
        if (Double.isNaN(expected.getDistanceToParent())) {
            Preconditions.checkState((boolean)Double.isNaN(actual.getDistanceToParent()));
        } else {
            Preconditions.checkState((expected.getDistanceToParent() == actual.getDistanceToParent() ? 1 : 0) != 0, (String)"%s != %s", (Object)expected.getDistanceToParent(), (Object)actual.getDistanceToParent());
        }
        Preconditions.checkState((expected.getMag() == actual.getMag() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)expected.getHypocenterLocation().equals(actual.getHypocenterLocation()));
        Preconditions.checkState((expected.getFSSIndex() == actual.getFSSIndex() ? 1 : 0) != 0);
        Preconditions.checkState((expected.getGridNodeIndex() == actual.getGridNodeIndex() ? 1 : 0) != 0);
    }

    public static BinarayCatalogsIterable getBinaryCatalogsIterable(File binFile, double minMag) {
        return new BinarayCatalogsIterable(binFile, minMag);
    }

    public static BinarayCatalogsListIterator getBinaryCatalogsIterator(File binFile, double minMag) throws IOException {
        return new BinarayCatalogsListIterator(binFile, minMag);
    }

    public static ETAS_Catalog loadIndividualCatalogBinary(File catalogsFile, int index, boolean indexInFile) throws IOException {
        BinarayCatalogsMetadataIterator metaIt = ETAS_CatalogIO.getBinaryCatalogsMetadataIterator(catalogsFile);
        ETAS_SimulationMetadata meta = null;
        long startPos = -1L;
        int curIndexInFile = 0;
        while (metaIt.hasNext()) {
            boolean match;
            ETAS_SimulationMetadata nextMeta = metaIt.peek();
            Preconditions.checkState((boolean)metaIt.isNextFullyWritten());
            if (indexInFile) {
                match = index == curIndexInFile;
            } else {
                boolean bl = match = nextMeta.catalogIndex == index;
            }
            if (match) {
                meta = nextMeta;
                startPos = metaIt.getNextMetaStartPos();
                break;
            }
            metaIt.next();
            ++curIndexInFile;
        }
        metaIt.close();
        Preconditions.checkNotNull(meta, (String)"No catalog found with index=%s", (int)index);
        System.out.println("Catalog " + index + " starts at pos=" + startPos);
        RandomAccessFile ra = new RandomAccessFile(catalogsFile, "r");
        ra.seek(startPos);
        ETAS_Catalog catalog = ETAS_CatalogIO.doLoadCatalogBinary(ra, 0.0);
        ra.close();
        return catalog;
    }

    public static BinarayCatalogsMetadataIterator getBinaryCatalogsMetadataIterator(File binFile) throws IOException {
        return new BinarayCatalogsMetadataIterator(binFile);
    }

    public static void consolidateResultsDirBinary(File resultsDir, File outputFile, double minMag) throws IOException {
        ETAS_CatalogIO.consolidateResultsDirBinary(new File[]{resultsDir}, outputFile, minMag);
    }

    public static void consolidateResultsDirBinary(File[] resultsDirs, File outputFile, double minMag) throws IOException {
        ArrayList eventsFiles = Lists.newArrayList();
        for (File resultsDir : resultsDirs) {
            File[] subDirs = resultsDir.listFiles();
            Arrays.sort(subDirs, new FileNameComparator());
            for (File subDir : subDirs) {
                if (!subDir.isDirectory() || !subDir.getName().startsWith("sim_")) continue;
                File asciiFile = new File(subDir, "simulatedEvents.txt");
                if (asciiFile.exists()) {
                    eventsFiles.add(asciiFile);
                    continue;
                }
                File binaryFile = new File(subDir, "simulatedEvents.bin");
                if (binaryFile.exists() && binaryFile.length() > 0L) {
                    eventsFiles.add(binaryFile);
                    continue;
                }
                File binaryGZipFile = new File(subDir, "simulatedEvents.bin.gz");
                if (!binaryGZipFile.exists() || binaryGZipFile.length() <= 0L) continue;
                eventsFiles.add(binaryGZipFile);
            }
        }
        System.out.println("Detected " + eventsFiles.size() + " catalogs");
        Preconditions.checkState((!eventsFiles.isEmpty() ? 1 : 0) != 0, (Object)"No catalogs detected!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x640000));
        out.writeInt(eventsFiles.size());
        for (File eventsFile : eventsFiles) {
            String name = eventsFile.getName();
            if (!eventsFile.exists() && name.endsWith(".txt")) {
                eventsFile = new File(eventsFile.getParentFile(), "simulatedEvents.bin");
                name = eventsFile.getName();
                Preconditions.checkState((boolean)eventsFile.exists(), (Object)"TXT file deleted but bin doesn't exist?");
            }
            int prevCounter = out.size();
            try {
                if (minMag < 0.0 && name.endsWith(".bin")) {
                    ByteStreams.copy((InputStream)new BufferedInputStream(new FileInputStream(eventsFile), 0x640000), (OutputStream)out);
                } else if (minMag < 0.0 && name.endsWith(".bin.gz")) {
                    ByteStreams.copy((InputStream)new GZIPInputStream((InputStream)new FileInputStream(eventsFile), 0x640000), (OutputStream)out);
                } else {
                    ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)ETAS_CatalogIO.loadCatalog(eventsFile, minMag, true));
                }
            }
            catch (IOException e) {
                System.err.println("FAILED on " + eventsFile.getAbsolutePath());
                throw e;
            }
            catch (RuntimeException e) {
                System.err.println("FAILED on " + eventsFile.getAbsolutePath());
                throw e;
            }
            int newCounter = out.size();
            Preconditions.checkState((newCounter == Integer.MAX_VALUE || newCounter > prevCounter ? 1 : 0) != 0, (String)"Didn't write anything for catalog in %s. before: %s, after %s bytes", (Object)eventsFile.getAbsolutePath(), (Object)prevCounter, (Object)newCounter);
        }
        out.close();
    }

    public static void zipToBin(File zipFile, File binFile, double minMag) throws ZipException, IOException {
        ZipEntry catEntry;
        ZipFile zip = new ZipFile(zipFile);
        ArrayList entries = Lists.newArrayList();
        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
            String subEntryName;
            if (!zipEntry.isDirectory() || (catEntry = zip.getEntry(subEntryName = zipEntry.getName() + "simulatedEvents.txt")) == null) continue;
            entries.add(catEntry);
        }
        Collections.sort(entries, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        System.out.println("Detected " + entries.size() + " catalogs");
        Preconditions.checkState((!entries.isEmpty() ? 1 : 0) != 0, (Object)"No catalogs detected!");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(binFile), 0x640000));
        out.writeInt(entries.size());
        boolean bl = true;
        for (int i = 0; i < entries.size(); ++i) {
            int n;
            catEntry = (ZipEntry)entries.get(i);
            ETAS_Catalog cat = ETAS_CatalogIO.loadCatalog(zip.getInputStream(catEntry), minMag);
            ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)cat);
            if ((i + 1) % n != 0) continue;
            System.out.println("Converted " + (i + 1) + " catalogs (and counting)...");
            if (n >= 1000) continue;
            if (i + 1 == 10) {
                n = 10;
                continue;
            }
            if (i + 1 != 100) continue;
            n = 100;
        }
        zip.close();
        out.close();
        System.out.println("Converted " + entries.size() + " catalogs");
    }

    public static void mergeBinary(File outputFile, double minDuration, File ... inputFiles) throws ZipException, IOException {
        int count = 0;
        int skipped = 0;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x640000));
        out.writeInt(-1);
        for (File inputFile : inputFiles) {
            System.out.println("Handling " + inputFile.getAbsolutePath());
            for (List catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, 0.0)) {
                double duration = 0.0;
                if (!catalog.isEmpty()) {
                    duration = ETAS_MultiSimAnalysisTools.calcDurationYears(catalog);
                }
                if (minDuration > 0.0 && duration < minDuration) {
                    ++skipped;
                    continue;
                }
                ++count;
                ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)catalog);
            }
        }
        out.close();
        System.out.println("Wrote " + count + " catalogs (skipped " + skipped + ")");
        RandomAccessFile raFile = new RandomAccessFile(outputFile, "rw");
        raFile.seek(0L);
        raFile.writeInt(count);
        raFile.close();
    }

    public static void unionBinary(File outputFile, File ... inputFiles) throws ZipException, IOException {
        Preconditions.checkArgument((inputFiles.length > 1 ? 1 : 0) != 0);
        BinarayCatalogsIterable[] iterables = new BinarayCatalogsIterable[inputFiles.length];
        ArrayList<Iterator<ETAS_Catalog>> iterators = new ArrayList<Iterator<ETAS_Catalog>>();
        for (int i = 0; i < inputFiles.length; ++i) {
            iterables[i] = ETAS_CatalogIO.getBinaryCatalogsIterable(inputFiles[i], 0.0);
            iterators.add(iterables[i].iterator());
        }
        int numCatalogs = iterables[0].getNumCatalogs();
        for (int i = 1; i < inputFiles.length; ++i) {
            Preconditions.checkState((iterables[i].getNumCatalogs() == numCatalogs ? 1 : 0) != 0);
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x640000));
        long uniqueRups = 0L;
        long totalRups = 0L;
        out.writeInt(numCatalogs);
        for (int i = 0; i < numCatalogs; ++i) {
            if (i % 1000 == 0) {
                System.out.println("Processing catalog " + i);
            }
            HashMap catalogMap = Maps.newHashMap();
            for (Iterator iterator : iterators) {
                List catalog = (List)iterator.next();
                for (ETAS_EqkRupture rup : catalog) {
                    Integer id = rup.getID();
                    if (catalogMap.containsKey(id)) {
                        Preconditions.checkState((((ETAS_EqkRupture)catalogMap.get(id)).getOriginTime() == rup.getOriginTime() ? 1 : 0) != 0, (Object)"Trying to union between different catalogs");
                        continue;
                    }
                    catalogMap.put(id, rup);
                }
                totalRups += (long)catalog.size();
            }
            uniqueRups += (long)catalogMap.size();
            ArrayList catalog = Lists.newArrayList(catalogMap.values());
            Collections.sort(catalog, ETAS_SimAnalysisTools.eventComparator);
            ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)catalog);
        }
        out.close();
        double keptPercent = 100.0 * (double)uniqueRups / (double)totalRups;
        System.out.println("Union complete. " + (float)keptPercent + "% of ruptures kept");
    }

    public static void binaryCatalogsFilterByMag(File inputFile, File outputFile, double minMag, boolean preserveChain) throws ZipException, IOException {
        int count = 0;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x640000));
        out.writeInt(-1);
        if (preserveChain) {
            BinarayCatalogsIterable it = ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, 0.0);
            System.out.println("Input has " + it.getNumCatalogs() + " catalogs");
            Iterator<ETAS_Catalog> iterator = it.iterator();
            while (iterator.hasNext()) {
                List catalog = iterator.next();
                if (count % 1000 == 0) {
                    System.out.println("Processing catalog " + count);
                }
                catalog = ETAS_SimAnalysisTools.getAboveMagPreservingChain(catalog, minMag);
                ++count;
                ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)catalog);
            }
        } else {
            for (List catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, minMag)) {
                if (count % 1000 == 0) {
                    System.out.println("Processing catalog " + count);
                }
                ++count;
                ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)catalog);
            }
        }
        out.close();
        System.out.println("Wrote " + count + " catalogs");
        RandomAccessFile raFile = new RandomAccessFile(outputFile, "rw");
        raFile.seek(0L);
        raFile.writeInt(count);
        raFile.close();
    }

    public static void main(String[] args) throws ZipException, IOException {
        if (args.length == 2 || args.length == 3) {
            File[] resultsDirs;
            if (args[0].contains(",")) {
                ArrayList dirs = Lists.newArrayList();
                for (String dir : Splitter.on((String)",").split((CharSequence)args[0])) {
                    if (dir.isEmpty()) continue;
                    File d = new File(dir);
                    Preconditions.checkState((boolean)d.exists());
                    dirs.add(d);
                }
                resultsDirs = dirs.toArray(new File[0]);
            } else {
                resultsDirs = new File[]{new File(args[0])};
            }
            File outputFile = new File(args[1]);
            double minMag = -10.0;
            if (args.length == 3) {
                minMag = Double.parseDouble(args[2]);
            }
            if (resultsDirs.length == 0 && resultsDirs[0].getName().endsWith(".zip")) {
                ETAS_CatalogIO.zipToBin(resultsDirs[0], outputFile, minMag);
            } else {
                ETAS_CatalogIO.consolidateResultsDirBinary(resultsDirs, outputFile, minMag);
            }
            System.exit(0);
        }
        File file = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2024_06_06-Start2012_500yr_kCOV1p5_Spontaneous_HistCatalog/results_m5_preserve_chain.bin");
        List<ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogsBinary(file);
        int index = 42;
        ETAS_Catalog catalog = catalogs.get(42);
        System.out.println("Catalog " + index + " is " + catalog.meta.catalogIndex);
        ETAS_Catalog indvCatalog = ETAS_CatalogIO.loadIndividualCatalogBinary(file, index, true);
        Preconditions.checkState((indvCatalog.size() == catalog.size() ? 1 : 0) != 0);
        ETAS_EqkRupture rup0 = (ETAS_EqkRupture)catalog.get(0);
        ETAS_EqkRupture indvRup0 = (ETAS_EqkRupture)catalog.get(0);
        Preconditions.checkState((rup0.getMag() == indvRup0.getMag() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)rup0.getHypocenterLocation().equals(indvRup0.getHypocenterLocation()));
    }

    static {
        catDateFormat.setTimeZone(utc);
        binaryVersionRuptureLengthMap = new HashMap<Integer, Long>();
        binaryVersionRuptureLengthMap.put(1, 70L);
        binaryVersionRuptureLengthMap.put(2, 78L);
        binaryVersionRuptureLengthMap.put(3, 78L);
        binaryVersionHeaderLengthMap = new HashMap<Integer, Long>();
        binaryVersionHeaderLengthMap.put(1, 6L);
        binaryVersionHeaderLengthMap.put(2, 6L);
        binaryVersionHeaderLengthMap.put(3, 78L);
    }

    public static class ETAS_Catalog
    extends ArrayList<ETAS_EqkRupture> {
        private ETAS_SimulationMetadata meta;

        public ETAS_Catalog(ETAS_SimulationMetadata meta) {
            this.meta = meta;
        }

        public ETAS_SimulationMetadata getSimulationMetadata() {
            return this.meta;
        }

        public void setSimulationMetadata(ETAS_SimulationMetadata meta) {
            this.meta = meta;
        }

        public void updateMetadataForCatalog() {
            this.meta = this.meta.getUpdatedForCatalog(this);
        }
    }

    public static class BinarayCatalogsIterable
    implements Iterable<ETAS_Catalog> {
        private final File binFile;
        private final double minMag;
        private int numCatalogs = -1;
        private BinarayCatalogsListIterator curIterator = null;

        private BinarayCatalogsIterable(File binFile, double minMag) {
            this.binFile = binFile;
            this.minMag = minMag;
        }

        @Override
        public Iterator<ETAS_Catalog> iterator() {
            BinarayCatalogsListIterator ret = this.getIterator();
            this.curIterator = null;
            return ret;
        }

        private BinarayCatalogsListIterator getIterator() {
            if (this.curIterator == null) {
                try {
                    this.curIterator = new BinarayCatalogsListIterator(this.binFile, this.minMag);
                    this.numCatalogs = this.curIterator.numCatalogs;
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            return this.curIterator;
        }

        public int getNumCatalogs() {
            if (this.numCatalogs < 0) {
                this.getIterator();
            }
            Preconditions.checkState((this.numCatalogs >= 0 ? 1 : 0) != 0);
            return this.numCatalogs;
        }
    }

    public static class BinarayCatalogsListIterator
    implements Iterator<ETAS_Catalog> {
        private int numCatalogs;
        private int retIndex;
        private int loadIndex;
        private Throwable exception;
        private Thread loadThread;
        private LinkedBlockingDeque<ETAS_Catalog> deque;
        private DataInputStream in;

        private BinarayCatalogsListIterator(File binFile, final double minMag) throws IOException {
            InputStream is = ETAS_CatalogIO.getIS(binFile);
            this.in = new DataInputStream(is);
            this.numCatalogs = this.in.readInt();
            this.deque = new LinkedBlockingDeque(Integer.min(500, Integer.max(2, this.numCatalogs / 1000)));
            this.loadIndex = 0;
            this.loadThread = new Thread(this){
                final /* synthetic */ BinarayCatalogsListIterator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        while (this.this$0.loadIndex < this.this$0.numCatalogs) {
                            this.this$0.deque.putLast(ETAS_CatalogIO.doLoadCatalogBinary(this.this$0.in, minMag));
                            ++this.this$0.loadIndex;
                        }
                        this.this$0.in.close();
                    }
                    catch (Exception e) {
                        this.this$0.exception = e;
                        try {
                            this.this$0.in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.loadThread.start();
            this.retIndex = 0;
        }

        @Override
        public boolean hasNext() {
            this.waitUntilReady();
            return !this.deque.isEmpty();
        }

        @Override
        public ETAS_Catalog next() {
            this.waitUntilReady();
            if (this.deque.isEmpty()) {
                if (this.exception == null) {
                    throw new IllegalStateException("No more catalogs to load (loaded " + this.retIndex + "/" + this.numCatalogs + ")");
                }
                System.err.println("Error loading catalog " + this.retIndex);
                System.err.flush();
                throw ExceptionUtils.asRuntimeException(this.exception);
            }
            ETAS_Catalog catalog = this.deque.removeFirst();
            ++this.retIndex;
            return catalog;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void waitUntilReady() {
            while (this.deque.isEmpty() && this.loadThread.isAlive()) {
            }
        }
    }

    public static class BinarayCatalogsMetadataIterator
    implements PeekingIterator<ETAS_SimulationMetadata>,
    Closeable {
        private RandomAccessFile ra;
        private int numCatalogs;
        private int curIndex = -1;
        private ETAS_SimulationMetadata current;
        private short curVersion = (short)-1;
        private long curMetaStartPos = -1L;
        private long curStartPos = -1L;
        private long curEndPos = -1L;
        private int curNumRuptures = -1;
        private long length;

        private BinarayCatalogsMetadataIterator(File binFile) throws IOException {
            this.ra = new RandomAccessFile(binFile, "r");
            this.numCatalogs = this.ra.readInt();
        }

        private void checkLoad() throws IOException {
            ETAS_SimulationMetadata meta;
            if (this.curEndPos > 0L && this.curEndPos >= this.curStartPos) {
                return;
            }
            this.current = null;
            this.curEndPos = -1L;
            this.curNumRuptures = -1;
            this.curVersion = (short)-1;
            if (this.curIndex >= this.numCatalogs - 1) {
                this.ra.close();
                return;
            }
            ++this.curIndex;
            this.curMetaStartPos = this.ra.getFilePointer();
            try {
                this.curVersion = this.ra.readShort();
                meta = ETAS_CatalogIO.readBinaryMetadata(this.ra, this.curVersion);
            }
            catch (Exception e) {
                System.err.println("Error reading metadata for catalog " + this.curIndex + " at header pos=" + this.curMetaStartPos + ", trucated? " + e.getMessage());
                this.close();
                return;
            }
            this.curNumRuptures = this.ra.readInt();
            this.curStartPos = this.ra.getFilePointer();
            this.curEndPos = this.ra.getFilePointer() + ETAS_CatalogIO.getCatalogLengthBytes(this.curNumRuptures, this.curVersion, false);
            this.current = meta;
            this.length = this.ra.length();
            if (this.curEndPos >= this.length) {
                this.close();
            } else {
                this.ra.seek(this.curEndPos);
            }
        }

        public synchronized boolean hasNext() {
            if (this.curIndex >= this.numCatalogs) {
                return false;
            }
            try {
                this.checkLoad();
            }
            catch (IOException e) {
                System.err.println("WARNING: truncated? " + e.getMessage());
                return false;
            }
            return this.curEndPos > 0L && this.curEndPos >= this.curStartPos;
        }

        public synchronized ETAS_SimulationMetadata next() {
            ETAS_SimulationMetadata ret = this.peek();
            this.current = null;
            this.curVersion = (short)-1;
            this.curEndPos = -1L;
            this.curStartPos = -1L;
            this.curNumRuptures = -1;
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long getNextMetaStartPos() {
            this.peek();
            return this.curMetaStartPos;
        }

        public long getNextStartPos() {
            this.peek();
            return this.curStartPos;
        }

        public long getNextEndPos() {
            this.peek();
            return this.curEndPos;
        }

        public int getNextNumRuptures() {
            this.peek();
            return this.curNumRuptures;
        }

        public short getNextFileVersion() {
            this.peek();
            return this.curVersion;
        }

        public boolean isNextFullyWritten() {
            return this.curEndPos > 0L && this.curEndPos <= this.length;
        }

        public synchronized ETAS_SimulationMetadata peek() {
            try {
                this.checkLoad();
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            return this.current;
        }

        @Override
        public void close() throws IOException {
            this.ra.close();
        }
    }
}

