/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.SeisDepthDistribution;

public class ETAS_LocationWeightCalculator {
    static final boolean D = false;
    int numLatLon;
    int numDepth;
    int numParDepth;
    double maxLatLonDeg;
    double maxDepthKm;
    double latLonDiscrDeg;
    double depthDiscrKm;
    double midLat;
    double maxDistKm;
    double etasDistDecay;
    double etasMinDist;
    double cosMidLat;
    ArrayList<double[][][]> pointWtList;
    double histLogMinDistKm = Double.NaN;
    double histLogMaxDistKm = 4.0;
    double histLogDeltaDistKm = 0.1;
    int histNum;
    LocationList[][][] subLocsArray;
    IntegerPDF_FunctionSampler[][][][] subLocSamplerArray;
    int[] numSubDistances = new int[]{100, 20, 10, 5, 2, 2};
    SeisDepthDistribution seisDepthDistribution;
    EvenlyDiscretizedFunc targetLogDistDecay;
    ArrayList<HistogramFunction> logDistWeightHistList;
    ArrayList<HistogramFunction> logDistNumCellHistList;
    ArrayList<HistogramFunction> finalLogDistDecayList;
    Location[] locationArray;
    IntegerPDF_FunctionSampler[] randLocSampler;

    public ETAS_LocationWeightCalculator(double maxDistKm, double maxDepthKm, double latLonDiscrDeg, double depthDiscrKm, double midLat, double etasDistDecay, double etasMinDist) {
        this.cosMidLat = Math.cos(midLat * Math.PI / 180.0);
        double aveLatLonDiscrKm = (latLonDiscrDeg + this.cosMidLat * latLonDiscrDeg) * 111.0 / 2.0;
        this.maxDistKm = maxDistKm;
        this.maxLatLonDeg = maxDistKm / (111.0 * this.cosMidLat);
        this.maxDepthKm = maxDepthKm;
        this.latLonDiscrDeg = latLonDiscrDeg;
        this.depthDiscrKm = depthDiscrKm;
        this.midLat = midLat;
        this.etasDistDecay = etasDistDecay;
        this.etasMinDist = etasMinDist;
        this.numLatLon = (int)Math.round(this.maxLatLonDeg / latLonDiscrDeg);
        this.numDepth = (int)Math.round(maxDepthKm / depthDiscrKm);
        this.numParDepth = this.numDepth + 1;
        double aveCellVolume = 111.11 * latLonDiscrDeg * (111.11 * this.cosMidLat * latLonDiscrDeg) * depthDiscrKm;
        int maxNumPtsWithSubLocs = this.numSubDistances.length;
        this.subLocsArray = new LocationList[maxNumPtsWithSubLocs][maxNumPtsWithSubLocs][maxNumPtsWithSubLocs];
        this.subLocSamplerArray = new IntegerPDF_FunctionSampler[maxNumPtsWithSubLocs][maxNumPtsWithSubLocs][maxNumPtsWithSubLocs][this.numParDepth];
        double[] distances = null;
        this.seisDepthDistribution = new SeisDepthDistribution();
        this.histLogMinDistKm = -1.5;
        this.histNum = Math.round((float)((this.histLogMaxDistKm - this.histLogMinDistKm) / this.histLogDeltaDistKm)) + 1;
        this.pointWtList = new ArrayList();
        this.logDistWeightHistList = new ArrayList();
        this.logDistNumCellHistList = new ArrayList();
        this.finalLogDistDecayList = new ArrayList();
        for (int i = 0; i < this.numParDepth; ++i) {
            this.pointWtList.add(new double[this.numLatLon][this.numLatLon][this.numDepth]);
            this.logDistWeightHistList.add(new HistogramFunction(this.histLogMinDistKm, this.histLogMaxDistKm, this.histNum));
            this.logDistNumCellHistList.add(new HistogramFunction(this.histLogMinDistKm, this.histLogMaxDistKm, this.histNum));
            this.finalLogDistDecayList.add(new HistogramFunction(this.histLogMinDistKm, this.histLogMaxDistKm, this.histNum));
        }
        this.targetLogDistDecay = ETAS_Utils.getTargetDistDecayFunc(this.histLogMinDistKm, this.histLogMaxDistKm, this.histNum, etasDistDecay, etasMinDist);
        for (int iParDep = 0; iParDep < this.numParDepth; ++iParDep) {
            double dist;
            double logDist;
            double wt;
            double dist2;
            double volume;
            int maxIndex;
            int iDepDiff;
            double wtAtDepth;
            double depth;
            int iDep;
            int iLon;
            int iLat;
            System.out.println("iParDep=" + iParDep + "; ParDepth=" + this.getParDepth(iParDep));
            HistogramFunction logDistWeightHist = this.logDistWeightHistList.get(iParDep);
            HistogramFunction logDistNumCellHist = this.logDistNumCellHistList.get(iParDep);
            HistogramFunction finalLogDistDecay = this.finalLogDistDecayList.get(iParDep);
            double[][][] pointWt = this.pointWtList.get(iParDep);
            for (iLat = 0; iLat < this.numLatLon; ++iLat) {
                for (iLon = 0; iLon < this.numLatLon; ++iLon) {
                    for (iDep = 0; iDep < this.numDepth; ++iDep) {
                        depth = this.getDepth(iDep);
                        wtAtDepth = this.seisDepthDistribution.getProbBetweenDepths(depth - depthDiscrKm / 2.0, depth + depthDiscrKm / 2.0) * (double)this.numDepth;
                        iDepDiff = iDep - iParDep;
                        if (iDepDiff < 0) {
                            iDepDiff = -iDepDiff - 1;
                        }
                        if ((maxIndex = Math.max(iDepDiff, Math.max(iLat, iLon))) < this.numSubDistances.length) {
                            distances = this.getSubDistances(iLat, iLon, iDepDiff, this.numSubDistances[maxIndex]);
                            volume = aveCellVolume / (double)distances.length;
                            for (int i = 0; i < distances.length; ++i) {
                                dist2 = distances[i];
                                wt = 4.0 * ETAS_Utils.getHardebeckDensity(dist2, etasDistDecay, etasMinDist, maxDepthKm) * volume * wtAtDepth;
                                logDist = Math.log10(dist2);
                                if (logDist < logDistWeightHist.getX(0)) {
                                    logDistWeightHist.add(0, wt);
                                    logDistNumCellHist.add(0, 1.0);
                                    continue;
                                }
                                if (!(dist2 < maxDistKm)) continue;
                                logDistWeightHist.add(logDist, wt);
                                logDistNumCellHist.add(logDist, 1.0);
                            }
                            continue;
                        }
                        dist = this.getDistance(iLat, iLon, iDepDiff);
                        if (!(dist < maxDistKm)) continue;
                        double wt2 = 4.0 * ETAS_Utils.getHardebeckDensity(dist, etasDistDecay, etasMinDist, maxDepthKm) * aveCellVolume * wtAtDepth;
                        logDistWeightHist.add(Math.log10(dist), wt2);
                        logDistNumCellHist.add(Math.log10(dist), 1.0);
                    }
                }
            }
            for (iLat = 0; iLat < this.numLatLon; ++iLat) {
                for (iLon = 0; iLon < this.numLatLon; ++iLon) {
                    for (iDep = 0; iDep < this.numDepth; ++iDep) {
                        double modWt;
                        depth = this.getDepth(iDep);
                        wtAtDepth = this.seisDepthDistribution.getProbBetweenDepths(depth - depthDiscrKm / 2.0, depth + depthDiscrKm / 2.0) * (double)this.numDepth;
                        iDepDiff = iDep - iParDep;
                        if (iDepDiff < 0) {
                            iDepDiff = -iDepDiff - 1;
                        }
                        if ((maxIndex = Math.max(iDepDiff, Math.max(iLat, iLon))) < this.numSubDistances.length) {
                            distances = this.getSubDistances(iLat, iLon, iDepDiff, this.numSubDistances[maxIndex]);
                            volume = aveCellVolume / (double)distances.length;
                            for (int i = 0; i < distances.length; ++i) {
                                double modWt2;
                                dist2 = distances[i];
                                wt = 4.0 * ETAS_Utils.getHardebeckDensity(dist2, etasDistDecay, etasMinDist, maxDepthKm) * volume * wtAtDepth;
                                logDist = Math.log10(dist2);
                                if (logDist < logDistWeightHist.getX(0)) {
                                    modWt2 = wt * this.targetLogDistDecay.getY(0) / logDistWeightHist.getY(0);
                                    double[] dArray = pointWt[iLat][iLon];
                                    int n = iDep;
                                    dArray[n] = dArray[n] + modWt2;
                                    finalLogDistDecay.add(0, modWt2);
                                    continue;
                                }
                                if (!(dist2 < maxDistKm)) continue;
                                modWt2 = wt * this.targetLogDistDecay.getY(logDist) / logDistWeightHist.getY(logDist);
                                double[] dArray = pointWt[iLat][iLon];
                                int n = iDep;
                                dArray[n] = dArray[n] + modWt2;
                                finalLogDistDecay.add(logDist, modWt2);
                            }
                            continue;
                        }
                        dist = this.getDistance(iLat, iLon, iDepDiff);
                        if (!(dist < maxDistKm)) continue;
                        double wt3 = 4.0 * ETAS_Utils.getHardebeckDensity(dist, etasDistDecay, etasMinDist, maxDepthKm) * aveCellVolume * wtAtDepth;
                        double logDist2 = Math.log10(dist);
                        pointWt[iLat][iLon][iDep] = modWt = wt3 * this.targetLogDistDecay.getY(logDist2) / logDistWeightHist.getY(logDist2);
                        finalLogDistDecay.add(Math.log10(dist), modWt);
                    }
                }
            }
            double totWtTest = 0.0;
            for (iDep = 0; iDep < this.numDepth; ++iDep) {
                for (int iLat2 = 0; iLat2 < this.numLatLon; ++iLat2) {
                    for (int iLon2 = 0; iLon2 < this.numLatLon; ++iLon2) {
                        totWtTest += pointWt[iLat2][iLon2][iDep];
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getRandomDeltaLoc(double relLat, double relLon, double depth, double parDep, ETAS_Utils etas_utils) {
        Location loc;
        double deltaDepth;
        double deltaSubLatLon;
        int maxIndex;
        int iLat = this.getLatIndex(relLat);
        int iLon = this.getLonIndex(relLon);
        int iDep = this.getDepthIndex(depth);
        int iParDep = this.getParDepthIndex(parDep);
        HistogramFunction logDistWeightHist = this.logDistWeightHistList.get(iParDep);
        int iDepDiff = iDep - iParDep;
        if (iDepDiff < 0) {
            iDepDiff = -iDepDiff - 1;
        }
        if ((maxIndex = Math.max(iDepDiff, Math.max(iLat, iLon))) < this.numSubDistances.length) {
            int numSubLoc = this.numSubDistances[maxIndex];
            deltaSubLatLon = this.latLonDiscrDeg / (double)numSubLoc;
            deltaDepth = this.depthDiscrKm / (double)numSubLoc;
            if (this.subLocsArray[iLat][iLon][iDepDiff] == null) {
                double midLat = this.getLat(iLat);
                double midLon = this.getLon(iLon);
                double midDepth = this.getDepth(iDepDiff);
                LocationList locList = new LocationList();
                for (int iSubLat = 0; iSubLat < numSubLoc; ++iSubLat) {
                    double lat = midLat - this.latLonDiscrDeg / 2.0 + (double)iSubLat * deltaSubLatLon + deltaSubLatLon / 2.0;
                    for (int iSubLon = 0; iSubLon < numSubLoc; ++iSubLon) {
                        double lon = midLon - this.latLonDiscrDeg / 2.0 + (double)iSubLon * deltaSubLatLon + deltaSubLatLon / 2.0;
                        for (int iSubDep = 0; iSubDep < numSubLoc; ++iSubDep) {
                            double dep = midDepth - this.depthDiscrKm / 2.0 + (double)iSubDep * deltaDepth + deltaDepth / 2.0;
                            locList.add(new Location(lat - midLat, lon - midLon, dep - midDepth));
                        }
                    }
                }
                LocationList[] locationListArray = this.subLocsArray[iLat][iLon];
                synchronized (locationListArray) {
                    if (this.subLocsArray[iLat][iLon][iDepDiff] == null) {
                        this.subLocsArray[iLat][iLon][iDepDiff] = locList;
                    }
                }
            }
            if (this.subLocSamplerArray[iLat][iLon][iDepDiff][iParDep] == null) {
                IntegerPDF_FunctionSampler newSampler = new IntegerPDF_FunctionSampler(numSubLoc * numSubLoc * numSubLoc);
                int index = 0;
                double midLat = this.getLat(iLat);
                double midLon = this.getLon(iLon);
                double midDepth = this.getDepth(iDepDiff);
                for (Location tempLoc : this.subLocsArray[iLat][iLon][iDepDiff]) {
                    double lat = tempLoc.getLatitude() + midLat;
                    double lon = tempLoc.getLongitude() + midLon;
                    double dep = tempLoc.getDepth() + midDepth;
                    double dist = this.getDistance(lat, lon, dep);
                    double logDist = Math.log10(dist);
                    double wt = 4.0 * ETAS_Utils.getHardebeckDensity(dist, this.etasDistDecay, this.etasMinDist, this.maxDepthKm);
                    Preconditions.checkState((boolean)Double.isFinite(wt), (String)"bad wt=%s for dist=%s, logDist=%s", (Object)wt, (Object)dist, (Object)logDist);
                    double normWt = logDist < logDistWeightHist.getX(0) ? this.targetLogDistDecay.getY(0) / logDistWeightHist.getY(0) : this.targetLogDistDecay.getY(logDist) / logDistWeightHist.getY(logDist);
                    Preconditions.checkState((boolean)Double.isFinite(normWt), (String)"bad normWt=%s", (Object)normWt);
                    newSampler.add(index, wt * normWt);
                    ++index;
                }
                IntegerPDF_FunctionSampler[] integerPDF_FunctionSamplerArray = this.subLocSamplerArray[iLat][iLon][iDepDiff];
                synchronized (integerPDF_FunctionSamplerArray) {
                    if (this.subLocSamplerArray[iLat][iLon][iDepDiff][iParDep] == null) {
                        newSampler.getSumOfY_vals();
                        this.subLocSamplerArray[iLat][iLon][iDepDiff][iParDep] = newSampler;
                    }
                }
            }
            double rand = etas_utils.getRandomDouble();
            int randLocIndex = this.subLocSamplerArray[iLat][iLon][iDepDiff][iParDep].getRandomInt(rand);
            loc = (Location)this.subLocsArray[iLat][iLon][iDepDiff].get(randLocIndex);
            if (iDep - iParDep < 0) {
                loc = new Location(loc.getLatitude(), loc.getLongitude(), -loc.getDepth());
            }
        } else {
            deltaSubLatLon = this.latLonDiscrDeg;
            deltaDepth = this.depthDiscrKm;
            loc = new Location(0.0, 0.0, 0.0);
        }
        double lat = loc.getLatitude() + deltaSubLatLon * (etas_utils.getRandomDouble() - 0.5) * 0.999;
        double lon = loc.getLongitude() + deltaSubLatLon * (etas_utils.getRandomDouble() - 0.5) * 0.999;
        depth = loc.getDepth() + deltaDepth * (etas_utils.getRandomDouble() - 0.5) * 0.999;
        return new Location(lat, lon, depth);
    }

    private double getDistance(int iLat, int iLon, int iDep) {
        return this.getDistance(this.getLat(iLat), this.getLon(iLon), this.getDepth(iDep));
    }

    private double getDistance(double relLat, double relLon, double relDep) {
        double latDistKm = relLat * 111.0;
        double lonDistKm = relLon * 111.0 * this.cosMidLat;
        return Math.sqrt(latDistKm * latDistKm + lonDistKm * lonDistKm + relDep * relDep);
    }

    public double getProbAtPoint(double relLat, double relLon, double dep, double parDep) {
        int relDepIndex = this.getDepthIndex(dep);
        int relLatIndex = this.getLatIndex(relLat);
        int relLonIndex = this.getLonIndex(relLon);
        if (relLatIndex >= this.numLatLon || relLonIndex >= this.numLatLon) {
            return 0.0;
        }
        return this.pointWtList.get(this.getParDepthIndex(parDep))[relLatIndex][relLonIndex][relDepIndex];
    }

    private double getLat(int iLat) {
        return (double)iLat * this.latLonDiscrDeg + this.latLonDiscrDeg / 2.0;
    }

    private int getLatIndex(double relLat) {
        return (int)(relLat / this.latLonDiscrDeg);
    }

    private double getLon(int iLon) {
        return (double)iLon * this.latLonDiscrDeg + this.latLonDiscrDeg / 2.0;
    }

    private int getLonIndex(double relLon) {
        return (int)(relLon / this.latLonDiscrDeg);
    }

    private double getDepth(int iDep) {
        return (double)iDep * this.depthDiscrKm + this.depthDiscrKm / 2.0;
    }

    private int getDepthIndex(double depth) {
        return (int)(depth / this.depthDiscrKm);
    }

    private double getParDepth(int iParDep) {
        return (double)iParDep * this.depthDiscrKm;
    }

    private int getParDepthIndex(double parDep) {
        int ret = (int)Math.round(parDep / this.depthDiscrKm);
        int numParDepth = this.randLocSampler == null ? this.numParDepth : this.randLocSampler.length;
        Preconditions.checkState((ret >= 0 && ret < numParDepth ? 1 : 0) != 0, (String)"Bad depth index=%s for depth=%s, depthDisr=%s", (Object)ret, (Object)parDep, (Object)this.depthDiscrKm);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getRandomLoc(double parDepth, ETAS_Utils etas_utils) {
        if (this.locationArray == null) {
            ETAS_LocationWeightCalculator eTAS_LocationWeightCalculator = this;
            synchronized (eTAS_LocationWeightCalculator) {
                if (this.locationArray == null) {
                    this.initRandomLocData();
                }
            }
        }
        int randInt = this.randLocSampler[this.getParDepthIndex(parDepth)].getRandomInt(etas_utils.getRandomDouble());
        return this.locationArray[randInt];
    }

    private void initRandomLocData() {
        int totNumPts = this.numLatLon * this.numLatLon * this.numDepth;
        Location[] locationArray = new Location[totNumPts];
        this.randLocSampler = new IntegerPDF_FunctionSampler[this.numParDepth];
        for (int iParDep = 0; iParDep < this.numParDepth; ++iParDep) {
            this.randLocSampler[iParDep] = new IntegerPDF_FunctionSampler(totNumPts);
        }
        int index = 0;
        for (int iDep = 0; iDep < this.numDepth; ++iDep) {
            for (int iLat = 0; iLat < this.numLatLon; ++iLat) {
                for (int iLon = 0; iLon < this.numLatLon; ++iLon) {
                    for (int iParDep = 0; iParDep < this.numParDepth; ++iParDep) {
                        double wt = this.getProbAtPoint(this.getLat(iLat), this.getLon(iLon), this.getDepth(iDep), this.getParDepth(iParDep));
                        this.randLocSampler[iParDep].set(index, wt);
                    }
                    locationArray[index] = new Location(this.getLat(iLat), this.getLon(iLon), this.getDepth(iDep));
                    ++index;
                }
            }
        }
        for (int iParDep = 0; iParDep < this.numParDepth; ++iParDep) {
            this.randLocSampler[iParDep].getSumOfY_vals();
        }
        this.locationArray = locationArray;
    }

    public void testRandomSamples(int numSamples, double parDepth, ETAS_Utils etas_utils) {
        int totNumPts = this.numLatLon * this.numLatLon * this.numDepth;
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(totNumPts);
        int[] iLatArray = new int[totNumPts];
        int[] iLonArray = new int[totNumPts];
        int[] iDepArray = new int[totNumPts];
        int index = 0;
        for (int iDep = 0; iDep < this.numDepth; ++iDep) {
            for (int iLat = 0; iLat < this.numLatLon; ++iLat) {
                int iLon = 0;
                while (iLon < this.numLatLon) {
                    double wt = this.getProbAtPoint(this.getLat(iLat), this.getLon(iLon), this.getDepth(iDep), parDepth);
                    sampler.set(index, wt);
                    iLatArray[index] = iLat;
                    iLonArray[index] = iLon++;
                    iDepArray[index] = iDep;
                    ++index;
                }
            }
        }
        double histLogMinDistKm = -1.3;
        double histLogMaxDistKm = this.histLogMaxDistKm;
        int histNum = Math.round((float)((histLogMaxDistKm - histLogMinDistKm) / this.histLogDeltaDistKm)) + 1;
        HistogramFunction testLogHistogram = new HistogramFunction(histLogMinDistKm, histLogMaxDistKm, histNum);
        HistogramFunction depthDistHistogram = new HistogramFunction(1.0, 12, 2.0);
        DefaultXY_DataSet epicenterLocs = new DefaultXY_DataSet();
        double[] distArray = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            double dist;
            int sampIndex = sampler.getRandomInt(etas_utils.getRandomDouble());
            double relLat = this.getLat(iLatArray[sampIndex]);
            double relLon = this.getLon(iLonArray[sampIndex]);
            double depth = this.getDepth(iDepArray[sampIndex]);
            Location deltaLoc = this.getRandomDeltaLoc(relLat, relLon, depth, parDepth, etas_utils);
            distArray[i] = dist = this.getDistance(relLat + deltaLoc.getLatitude(), relLon + deltaLoc.getLongitude(), depth + deltaLoc.getDepth() - parDepth);
            epicenterLocs.set((relLat + deltaLoc.getLatitude()) * 111.0, (relLon + deltaLoc.getLongitude()) * 111.0 * this.cosMidLat);
            depthDistHistogram.add(depth + deltaLoc.getDepth(), 1.0 / (double)numSamples);
            if (!(dist < this.maxDistKm)) continue;
            double logDist = Math.log10(dist);
            if (logDist < testLogHistogram.getX(0)) {
                testLogHistogram.add(0, 1.0 / (double)numSamples);
                continue;
            }
            if (!(logDist < histLogMaxDistKm)) continue;
            testLogHistogram.add(logDist, 1.0 / (double)numSamples);
        }
        double logBinHalfWidth = testLogHistogram.getDelta() / 2.0;
        for (int i = 0; i < testLogHistogram.size(); ++i) {
            double lowerBinEdge = 0.0;
            if (i != 0) {
                lowerBinEdge = Math.pow(10.0, testLogHistogram.getX(i) - logBinHalfWidth);
            }
            double upperBinEdge = Math.pow(10.0, testLogHistogram.getX(i) + logBinHalfWidth);
            testLogHistogram.set(i, testLogHistogram.getY(i) / (upperBinEdge - lowerBinEdge));
        }
        Arrays.sort(distArray);
        DefaultXY_DataSet nearestNeighborPrimaryData = new DefaultXY_DataSet();
        for (int i = 0; i < numSamples - 1; ++i) {
            double xVal = Math.log10((distArray[i + 1] + distArray[i]) / 2.0);
            double yVal = 1.0 / (distArray[i + 1] - distArray[i]);
            nearestNeighborPrimaryData.set(xVal, yVal / (double)distArray.length);
        }
        nearestNeighborPrimaryData.setName("Nearest neighbor distance data");
        nearestNeighborPrimaryData.setInfo("");
        EvenlyDiscretizedFunc targetLogDistDecayFunc = ETAS_Utils.getTargetDistDecayDensityFunc(histLogMinDistKm, histLogMaxDistKm, histNum, this.etasDistDecay, this.etasMinDist);
        ArrayList<AbstractXY_DataSet> funcs1 = new ArrayList<AbstractXY_DataSet>();
        funcs1.add(nearestNeighborPrimaryData);
        funcs1.add(targetLogDistDecayFunc);
        funcs1.add(testLogHistogram);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 2.0f, Color.GREEN));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 6.0f, Color.BLUE));
        GraphWindow graph = new GraphWindow(funcs1, "Distance Decay Test for Parent Depth of " + (float)parDepth + " km", chars);
        graph.setAxisRange(-1.3, 3.0, 1.0E-6, 10000.0);
        graph.setYLog(true);
        graph.setX_AxisLabel("Log10 Distance (km)");
        graph.setY_AxisLabel("Density");
        graph.setTickLabelFontSize(18);
        graph.setAxisLabelFontSize(20);
        graph.setTickLabelFontSize(22);
        PlotCurveCharacterstics plotSym = new PlotCurveCharacterstics(PlotSymbol.CROSS, 1.0f, Color.BLACK);
        GraphWindow graph3 = new GraphWindow(epicenterLocs, "epicenterLocs for ParDepth=" + (float)parDepth, plotSym);
        PlotCurveCharacterstics plotChar = new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK);
        GraphWindow graph4 = new GraphWindow(depthDistHistogram, "Depth Distibution for ParDepth=" + (float)parDepth, plotChar);
        graph4.setX_AxisLabel("Depth");
        graph4.setY_AxisLabel("Sampled Density");
        graph4.setGriddedFuncAxesTicks(true);
    }

    private double[] getSubDistances(int iLat, int iLon, int iDep, int numDiscr) {
        double[] distances = new double[numDiscr * numDiscr * numDiscr];
        double midLat = this.getLat(iLat);
        double midLon = this.getLon(iLon);
        double midDepth = this.getDepth(iDep);
        double deltaSubLatLon = this.latLonDiscrDeg / (double)numDiscr;
        double deltaDepth = this.depthDiscrKm / (double)numDiscr;
        int index = 0;
        for (int latIndex = 0; latIndex < numDiscr; ++latIndex) {
            double relLat = midLat - this.latLonDiscrDeg / 2.0 + (double)latIndex * deltaSubLatLon + deltaSubLatLon / 2.0;
            for (int lonIndex = 0; lonIndex < numDiscr; ++lonIndex) {
                double relLon = midLon - this.latLonDiscrDeg / 2.0 + (double)lonIndex * deltaSubLatLon + deltaSubLatLon / 2.0;
                for (int depIndex = 0; depIndex < numDiscr; ++depIndex) {
                    double relDep = midDepth - this.depthDiscrKm / 2.0 + (double)depIndex * deltaDepth + deltaDepth / 2.0;
                    distances[index] = this.getDistance(relLat, relLon, relDep);
                    ++index;
                }
            }
        }
        return distances;
    }

    public static void main(String[] args) {
        double maxDistKm = 1000.0;
        double maxDepthKm = 24.0;
        double latLonDiscrDeg = 0.02;
        double depthDiscrKm = 2.0;
        double midLat = 37.25;
        double etasDistDecay = ETAS_Utils.distDecay_DEFAULT;
        double etasMinDist = ETAS_Utils.minDist_DEFAULT;
        ETAS_SimAnalysisTools.writeMemoryUse("before");
        ETAS_LocationWeightCalculator calc = new ETAS_LocationWeightCalculator(maxDistKm, maxDepthKm, latLonDiscrDeg, depthDiscrKm, midLat, etasDistDecay, etasMinDist);
        ETAS_SimAnalysisTools.writeMemoryUse("after");
        calc.testRandomSamples(100000, 16.0, new ETAS_Utils());
    }
}

