/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class ETAS_LongTermMFDs {
    private SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray;
    private List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList;
    private double[] totLongTermSubSeisRateOnSectArray;
    private SummedMagFreqDist longTermTotalERF_MFD;

    public ETAS_LongTermMFDs(FaultSystemSolutionERF erf, boolean wtSupraNuclBySubSeisRates) {
        this.longTermSubSeisMFD_OnSectList = erf.getSolution().requireModule(SubSeismoOnFaultMFDs.class).getAll();
        this.totLongTermSubSeisRateOnSectArray = new double[this.longTermSubSeisMFD_OnSectList.size()];
        for (int s = 0; s < this.totLongTermSubSeisRateOnSectArray.length; ++s) {
            this.totLongTermSubSeisRateOnSectArray[s] = this.longTermSubSeisMFD_OnSectList.get(s) != null ? this.longTermSubSeisMFD_OnSectList.get(s).getCumRate(2.55) : this.longTermSubSeisMFD_OnSectList.get(s).getCumRate(2.55);
        }
        ProbabilityModelOptions probModel = (ProbabilityModelOptions)((Object)erf.getParameter("Probability Model").getValue());
        ArrayList<Object> paramValueList = new ArrayList<Object>();
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            paramValueList.add(param.getValue());
        }
        TimeSpan tsp = erf.getTimeSpan();
        double duration = tsp.getDuration();
        String startTimeString = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        paramValueList.add(startTimeString);
        paramValueList.add(duration);
        int numParams = paramValueList.size();
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        this.longTermSupraSeisMFD_OnSectArray = wtSupraNuclBySubSeisRates ? this.calcNucleationMFDForAllSectsWtedBySubSeisRates(erf, 2.55, 8.95, 65) : FaultSysSolutionERF_Calc.calcNucleationMFDForAllSects(erf, 2.55, 8.95, 65);
        this.longTermTotalERF_MFD = ERF_Calculator.getTotalMFD_ForERF(erf, 2.55, 8.45, 60, true);
        erf.getParameter("Probability Model").setValue(probModel);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        int testNum = erf.getAdjustableParameterList().size() + 2;
        if (numParams != testNum) {
            throw new RuntimeException("PROBLEM: num parameters changed:\t" + numParams + "\t" + testNum);
        }
        int i = 0;
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            if (param.getValue() != paramValueList.get(i)) {
                throw new RuntimeException("PROBLEM: " + String.valueOf(param.getValue()) + "\t" + String.valueOf(paramValueList.get(i)));
            }
            ++i;
        }
        TimeSpan tsp2 = erf.getTimeSpan();
        double duration2 = tsp2.getDuration();
        String startTimeString2 = tsp2.getStartTimeMonth() + "/" + tsp2.getStartTimeDay() + "/" + tsp2.getStartTimeYear() + "; hr=" + tsp2.getStartTimeHour() + "; min=" + tsp2.getStartTimeMinute() + "; sec=" + tsp2.getStartTimeSecond();
        if (!startTimeString2.equals(startTimeString)) {
            throw new RuntimeException("PROBLEM: " + startTimeString2 + "\t" + startTimeString2);
        }
        if (duration2 != duration) {
            throw new RuntimeException("PROBLEM Duration: " + duration2 + "\t" + duration);
        }
    }

    private SummedMagFreqDist[] calcNucleationMFDForAllSectsWtedBySubSeisRates(FaultSystemSolutionERF erf, double min, double max, int num) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        SummedMagFreqDist[] mfdArray = new SummedMagFreqDist[rupSet.getNumSections()];
        for (int i = 0; i < mfdArray.length; ++i) {
            mfdArray[i] = new SummedMagFreqDist(min, max, num);
        }
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            SummedMagFreqDist srcMFD = ERF_Calculator.getTotalMFD_ForSource(erf.getSource(s), duration, min, max, num, true);
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            List<Integer> sectIndexList = rupSet.getSectionsIndicesForRup(fssRupIndex);
            int numSubRates = 0;
            double aveSubRates = 0.0;
            for (int sectIndex : sectIndexList) {
                if (!(this.totLongTermSubSeisRateOnSectArray[sectIndex] > 0.0)) continue;
                ++numSubRates;
                aveSubRates += this.totLongTermSubSeisRateOnSectArray[sectIndex];
            }
            aveSubRates = aveSubRates == 0.0 ? 1.0 : (aveSubRates /= (double)numSubRates);
            double totWt = 0.0;
            for (int sectIndex : sectIndexList) {
                double sectWt = this.totLongTermSubSeisRateOnSectArray[sectIndex] != 0.0 ? this.totLongTermSubSeisRateOnSectArray[sectIndex] : aveSubRates;
                totWt += sectWt;
            }
            for (int sectIndex : sectIndexList) {
                double sectWt = this.totLongTermSubSeisRateOnSectArray[sectIndex] != 0.0 ? this.totLongTermSubSeisRateOnSectArray[sectIndex] : aveSubRates;
                for (int i = 0; i < num; ++i) {
                    mfdArray[sectIndex].add(i, srcMFD.getY(i) * sectWt / totWt);
                }
            }
        }
        return mfdArray;
    }

    public SummedMagFreqDist[] getLongTermSupraSeisMFD_OnSectArray() {
        return this.longTermSupraSeisMFD_OnSectArray;
    }

    public List<? extends IncrementalMagFreqDist> getLongTermSubSeisMFD_OnSectList() {
        return this.longTermSubSeisMFD_OnSectList;
    }

    public double[] getTotLongTermSubSeisRateOnSectArray() {
        return this.totLongTermSubSeisRateOnSectArray;
    }

    public SummedMagFreqDist getLongTermTotalERF_MFD() {
        return this.longTermTotalERF_MFD;
    }
}

