/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_MultiSimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class ETAS_SimAnalysisTools {
    public static final Comparator<ETAS_EqkRupture> eventComparator = new Comparator<ETAS_EqkRupture>(){

        @Override
        public int compare(ETAS_EqkRupture o1, ETAS_EqkRupture o2) {
            int ret = Long.valueOf(o1.getOriginTime()).compareTo(o2.getOriginTime());
            if (ret == 0) {
                ret = Integer.valueOf(o1.getID()).compareTo(o2.getID());
            }
            return ret;
        }
    };

    static PlotSpec getEpicenterMapSpec(String info, ObsEqkRupture mainShock, Collection<ETAS_EqkRupture> allAftershocks, LocationList regionBorder) {
        DefaultXY_DataSet epLocsGen6_Mgt65;
        DefaultXY_DataSet epLocsGen5_Mgt65;
        DefaultXY_DataSet epLocsGen4_Mgt65;
        DefaultXY_DataSet epLocsGen3_Mgt65;
        DefaultXY_DataSet epLocsGen2_Mgt65;
        DefaultXY_DataSet epLocsGen1_Mgt65;
        DefaultXY_DataSet epLocsGen0_Mgt65;
        DefaultXY_DataSet epLocsGen6_Mgt5lt65;
        DefaultXY_DataSet epLocsGen5_Mgt5lt65;
        DefaultXY_DataSet epLocsGen4_Mgt5lt65;
        DefaultXY_DataSet epLocsGen3_Mgt5lt65;
        DefaultXY_DataSet epLocsGen2_Mgt5lt65;
        DefaultXY_DataSet epLocsGen1_Mgt5lt65;
        DefaultXY_DataSet epLocsGen0_Mgt5lt65;
        DefaultXY_DataSet epLocsGen6_Mlt5;
        DefaultXY_DataSet epLocsGen5_Mlt5;
        DefaultXY_DataSet epLocsGen4_Mlt5;
        DefaultXY_DataSet epLocsGen3_Mlt5;
        DefaultXY_DataSet epLocsGen2_Mlt5;
        DefaultXY_DataSet epLocsGen1_Mlt5;
        ArrayList<Object> funcs = new ArrayList<Object>();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        DefaultXY_DataSet epLocsGen0_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 0, allAftershocks);
        if (epLocsGen0_Mlt5.size() > 0) {
            funcs.add(epLocsGen0_Mlt5);
            epLocsGen0_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.BLACK));
        }
        if ((epLocsGen1_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 1, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen1_Mlt5);
            epLocsGen1_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.RED));
        }
        if ((epLocsGen2_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 2, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen2_Mlt5);
            epLocsGen2_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.BLUE));
        }
        if ((epLocsGen3_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 3, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen3_Mlt5);
            epLocsGen3_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.GREEN));
        }
        if ((epLocsGen4_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 4, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen4_Mlt5);
            epLocsGen4_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.LIGHT_GRAY));
        }
        if ((epLocsGen5_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 5, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen5_Mlt5);
            epLocsGen5_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.ORANGE));
        }
        if ((epLocsGen6_Mlt5 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(2.0, 5.0, 6, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen6_Mlt5);
            epLocsGen6_Mlt5.setInfo("(circles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.YELLOW));
        }
        if ((epLocsGen0_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 0, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen0_Mgt5lt65);
            epLocsGen0_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.BLACK));
        }
        if ((epLocsGen1_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 1, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen1_Mgt5lt65);
            epLocsGen1_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.RED));
        }
        if ((epLocsGen2_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 2, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen2_Mgt5lt65);
            epLocsGen2_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.BLUE));
        }
        if ((epLocsGen3_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 3, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen3_Mgt5lt65);
            epLocsGen3_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.GREEN));
        }
        if ((epLocsGen4_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 4, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen4_Mgt5lt65);
            epLocsGen4_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.LIGHT_GRAY));
        }
        if ((epLocsGen5_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 5, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen5_Mgt5lt65);
            epLocsGen5_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.ORANGE));
        }
        if ((epLocsGen6_Mgt5lt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(5.0, 6.5, 6, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen6_Mgt5lt65);
            epLocsGen6_Mgt5lt65.setInfo("(triangles)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 4.0f, Color.YELLOW));
        }
        if ((epLocsGen0_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 0, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen0_Mgt65);
            epLocsGen0_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.BLACK));
        }
        if ((epLocsGen1_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 1, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen1_Mgt65);
            epLocsGen1_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.RED));
        }
        if ((epLocsGen2_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 2, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen2_Mgt65);
            epLocsGen2_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.BLUE));
        }
        if ((epLocsGen3_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 3, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen3_Mgt65);
            epLocsGen3_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.GREEN));
        }
        if ((epLocsGen4_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 4, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen4_Mgt65);
            epLocsGen4_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.LIGHT_GRAY));
        }
        if ((epLocsGen5_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 5, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen5_Mgt65);
            epLocsGen5_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.ORANGE));
        }
        if ((epLocsGen6_Mgt65 = ETAS_SimAnalysisTools.getEpicenterLocsXY_DataSet(6.5, 9.0, 6, allAftershocks)).size() > 0) {
            funcs.add(epLocsGen6_Mgt65);
            epLocsGen6_Mgt65.setInfo("(squares)");
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.SQUARE, 8.0f, Color.YELLOW));
        }
        if (mainShock != null) {
            FaultTrace trace = mainShock.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
            DefaultXY_DataSet traceFunc = new DefaultXY_DataSet();
            traceFunc.setName("Main Shock Trace");
            for (Location loc : trace) {
                traceFunc.set(loc.getLongitude(), loc.getLatitude());
            }
            funcs.add(traceFunc);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        }
        int lai = 0;
        for (ETAS_EqkRupture eTAS_EqkRupture : allAftershocks) {
            if (eTAS_EqkRupture.getRuptureSurface().isPointSurface()) continue;
            FaultTrace trace = eTAS_EqkRupture.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
            DefaultXY_DataSet traceFunc = new DefaultXY_DataSet();
            int gen = eTAS_EqkRupture.getGeneration();
            String rupType = "GridSeis";
            if (eTAS_EqkRupture.getFSSIndex() >= 0) {
                rupType = "FltSys";
            }
            traceFunc.setName("Finite " + rupType + " Rupture ID=" + eTAS_EqkRupture.getID() + ";  generation=" + gen + "; mag=" + eTAS_EqkRupture.getMag() + "hypo: " + String.valueOf(eTAS_EqkRupture.getHypocenterLocation()));
            for (Location loc : trace) {
                traceFunc.set(loc.getLongitude(), loc.getLatitude());
            }
            funcs.add(traceFunc);
            Color color = gen == 0 ? Color.BLACK : (gen == 1 ? Color.RED : (gen == 2 ? Color.BLUE : (gen == 3 ? Color.GREEN : (gen == 4 ? Color.LIGHT_GRAY : (gen == 5 ? Color.ORANGE : Color.YELLOW)))));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
            ++lai;
        }
        if (regionBorder != null) {
            DefaultXY_DataSet regBorderFunc = new DefaultXY_DataSet();
            regBorderFunc.setName("Region Border");
            for (Location loc : regionBorder) {
                regBorderFunc.set(loc.getLongitude(), loc.getLatitude());
            }
            regBorderFunc.set(regBorderFunc.get(0).getX(), regBorderFunc.get(0).getY());
            funcs.add(regBorderFunc);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        }
        String title = "Aftershock Epicenters for " + info;
        PlotSpec plotSpec = new PlotSpec(funcs, plotChars, title, "Longitude", "Latitude");
        return plotSpec;
    }

    public static EpicenterMapThread plotUpdatingEpicenterMap(String info, ObsEqkRupture mainShock, Collection<ETAS_EqkRupture> allAftershocks, LocationList regionBorder) {
        long updateInterval = 100L;
        EpicenterMapThread thread = new EpicenterMapThread(info, mainShock, allAftershocks, regionBorder, updateInterval);
        new Thread(thread).start();
        return thread;
    }

    public static void plotEpicenterMap(String info, String pdf_FileNameFullPath, ObsEqkRupture mainShock, Collection<ETAS_EqkRupture> allAftershocks, LocationList regionBorder) {
        PlotSpec spec = ETAS_SimAnalysisTools.getEpicenterMapSpec(info, mainShock, allAftershocks, regionBorder);
        double minLat = 90.0;
        double maxLat = -90.0;
        double minLon = 360.0;
        double maxLon = -360.0;
        for (PlotElement plotElement : spec.getPlotElems()) {
            if (!(plotElement instanceof XY_DataSet)) continue;
            XY_DataSet func = (XY_DataSet)plotElement;
            if (func.getMaxX() > maxLon) {
                maxLon = func.getMaxX();
            }
            if (func.getMinX() < minLon) {
                minLon = func.getMinX();
            }
            if (func.getMaxY() > maxLat) {
                maxLat = func.getMaxY();
            }
            if (!(func.getMinY() < minLat)) continue;
            minLat = func.getMinY();
        }
        GraphWindow graph = new GraphWindow(spec);
        double d = maxLat - minLat;
        double deltaLon = maxLon - minLon;
        double aveLat = (minLat + maxLat) / 2.0;
        double scaleFactor = 1.57 / Math.cos(aveLat * Math.PI / 180.0);
        if (d > deltaLon / scaleFactor) {
            double newLonMax = minLon + d * scaleFactor;
            graph.setX_AxisRange(minLon, newLonMax);
            graph.setY_AxisRange(minLat, maxLat);
        } else {
            double newMaxLat = minLat + deltaLon / scaleFactor;
            graph.setX_AxisRange(minLon, maxLon);
            graph.setY_AxisRange(minLat, newMaxLat);
        }
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileNameFullPath != null) {
            try {
                graph.saveAsPDF(pdf_FileNameFullPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotFiniteGridSeisRupMap(String info, String pdf_FileNameFullPath, Collection<ETAS_EqkRupture> allAftershocks, LocationList regionBorder) {
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        DefaultXY_DataSet hypoLocs = new DefaultXY_DataSet();
        hypoLocs.setName("Hypo Locs (Red Circles)");
        funcs.add(hypoLocs);
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 1.0f, Color.RED));
        for (ETAS_EqkRupture eTAS_EqkRupture : allAftershocks) {
            if (eTAS_EqkRupture.getFSSIndex() != -1 || eTAS_EqkRupture.getRuptureSurface().isPointSurface()) continue;
            DefaultXY_DataSet surfPoints = new DefaultXY_DataSet();
            for (Location loc : eTAS_EqkRupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface()) {
                surfPoints.set(loc.getLongitude(), loc.getLatitude());
            }
            surfPoints.setName("Points for Event with Mag=" + (float)eTAS_EqkRupture.getMag() + "; Dip=" + eTAS_EqkRupture.getRuptureSurface().getAveDip());
            surfPoints.setInfo("(crosses)");
            funcs.add(surfPoints);
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 1.0f, Color.BLACK));
            hypoLocs.set(eTAS_EqkRupture.getHypocenterLocation().getLongitude(), eTAS_EqkRupture.getHypocenterLocation().getLatitude());
            FaultTrace trace = eTAS_EqkRupture.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
            DefaultXY_DataSet traceFunc = new DefaultXY_DataSet();
            int gen = eTAS_EqkRupture.getGeneration();
            traceFunc.setName("Trace for Rupture ID=" + eTAS_EqkRupture.getID() + ";  generation=" + gen + "; mag=" + eTAS_EqkRupture.getMag() + "hypo: " + String.valueOf(eTAS_EqkRupture.getHypocenterLocation()));
            for (Location loc : trace) {
                traceFunc.set(loc.getLongitude(), loc.getLatitude());
            }
            funcs.add(traceFunc);
            Color color = gen == 0 ? Color.BLACK : (gen == 1 ? Color.RED : (gen == 2 ? Color.BLUE : (gen == 3 ? Color.GREEN : (gen == 4 ? Color.LIGHT_GRAY : (gen == 5 ? Color.ORANGE : Color.YELLOW)))));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
        }
        if (regionBorder != null) {
            DefaultXY_DataSet regBorderFunc = new DefaultXY_DataSet();
            regBorderFunc.setName("Region Border");
            for (Location loc : regionBorder) {
                regBorderFunc.set(loc.getLongitude(), loc.getLatitude());
            }
            regBorderFunc.set(regBorderFunc.get(0).getX(), regBorderFunc.get(0).getY());
            funcs.add(regBorderFunc);
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        }
        String title = "Surf for Grid Seis Finite Rups " + info;
        PlotSpec plotSpec = new PlotSpec(funcs, plotChars, title, "Longitude", "Latitude");
        double minLat = 90.0;
        double maxLat = -90.0;
        double minLon = 360.0;
        double maxLon = -360.0;
        for (PlotElement plotElement : plotSpec.getPlotElems()) {
            if (!(plotElement instanceof XY_DataSet)) continue;
            XY_DataSet func = (XY_DataSet)plotElement;
            if (func.getMaxX() > maxLon) {
                maxLon = func.getMaxX();
            }
            if (func.getMinX() < minLon) {
                minLon = func.getMinX();
            }
            if (func.getMaxY() > maxLat) {
                maxLat = func.getMaxY();
            }
            if (!(func.getMinY() < minLat)) continue;
            minLat = func.getMinY();
        }
        GraphWindow graph = new GraphWindow(plotSpec);
        double d = maxLat - minLat;
        double deltaLon = maxLon - minLon;
        double aveLat = (minLat + maxLat) / 2.0;
        double scaleFactor = 1.57 / Math.cos(aveLat * Math.PI / 180.0);
        if (d > deltaLon / scaleFactor) {
            double newLonMax = minLon + d * scaleFactor;
            graph.setX_AxisRange(minLon, newLonMax);
            graph.setY_AxisRange(minLat, maxLat);
        } else {
            double newMaxLat = minLat + deltaLon / scaleFactor;
            graph.setX_AxisRange(minLon, maxLon);
            graph.setY_AxisRange(minLat, newMaxLat);
        }
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileNameFullPath != null) {
            try {
                graph.saveAsPDF(pdf_FileNameFullPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static DefaultXY_DataSet getEpicenterLocsXY_DataSet(double magLow, double magHigh, int generation, Collection<ETAS_EqkRupture> eventsList) {
        DefaultXY_DataSet epicenterLocs = new DefaultXY_DataSet();
        for (ETAS_EqkRupture event : eventsList) {
            if (!(event.getMag() >= magLow) || !(event.getMag() < magHigh) || event.getGeneration() != generation) continue;
            epicenterLocs.set(event.getHypocenterLocation().getLongitude(), event.getHypocenterLocation().getLatitude());
        }
        epicenterLocs.setName("Generation " + generation + " Aftershock Epicenters for " + magLow + "<=Mag<" + magHigh);
        return epicenterLocs;
    }

    public static void plotMagFreqDists(String info, File resultsDir, Collection<ETAS_EqkRupture> eventsList) {
        ArbIncrementalMagFreqDist allEventsMagProbDist = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        ArbIncrementalMagFreqDist aftershockMagProbDist = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        for (ETAS_EqkRupture event : eventsList) {
            allEventsMagProbDist.addResampledMagRate(event.getMag(), 1.0, true);
            if (event.getGeneration() == 0) continue;
            aftershockMagProbDist.addResampledMagRate(event.getMag(), 1.0, true);
        }
        allEventsMagProbDist.setName("All Events MFD for simulation " + info);
        allEventsMagProbDist.setInfo("Total Num = " + allEventsMagProbDist.calcSumOfY_Vals());
        aftershockMagProbDist.setName("All Aftershocks MFD for simulation " + info);
        aftershockMagProbDist.setInfo("Total Num = " + aftershockMagProbDist.calcSumOfY_Vals());
        ArrayList<ArbIncrementalMagFreqDist> magProbDists = new ArrayList<ArbIncrementalMagFreqDist>();
        magProbDists.add(allEventsMagProbDist);
        magProbDists.add(aftershockMagProbDist);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
        GraphWindow magProbDistsGraph = new GraphWindow(magProbDists, "MFD for All Events and Aftershocks", plotChars);
        magProbDistsGraph.setX_AxisLabel("Mag");
        magProbDistsGraph.setY_AxisLabel("Number");
        magProbDistsGraph.setY_AxisRange(0.1, 1000.0);
        magProbDistsGraph.setX_AxisRange(2.0, 9.0);
        magProbDistsGraph.setYLog(true);
        magProbDistsGraph.setPlotLabelFontSize(18);
        magProbDistsGraph.setAxisLabelFontSize(16);
        magProbDistsGraph.setTickLabelFontSize(14);
        ArrayList<EvenlyDiscretizedFunc> cumMagProbDists = new ArrayList<EvenlyDiscretizedFunc>();
        cumMagProbDists.add(allEventsMagProbDist.getCumRateDistWithOffset());
        cumMagProbDists.add(aftershockMagProbDist.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotCharsCum = new ArrayList<PlotCurveCharacterstics>();
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        GraphWindow cuMagProbDistsGraph = new GraphWindow(cumMagProbDists, "Cumulative MFD for All Events and Aftershocks", plotCharsCum);
        cuMagProbDistsGraph.setX_AxisLabel("Mag");
        cuMagProbDistsGraph.setY_AxisLabel("Number");
        cuMagProbDistsGraph.setY_AxisRange(0.1, 10000.0);
        cuMagProbDistsGraph.setX_AxisRange(2.0, 9.0);
        cuMagProbDistsGraph.setYLog(true);
        cuMagProbDistsGraph.setPlotLabelFontSize(18);
        cuMagProbDistsGraph.setAxisLabelFontSize(16);
        cuMagProbDistsGraph.setTickLabelFontSize(14);
        if (resultsDir != null) {
            String pathName = new File(resultsDir, "simEventsMFD.pdf").getAbsolutePath();
            String pathNameCum = new File(resultsDir, "simEventsCumMFD.pdf").getAbsolutePath();
            try {
                magProbDistsGraph.saveAsPDF(pathName);
                cuMagProbDistsGraph.saveAsPDF(pathNameCum);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<IncrementalMagFreqDist> getAftershockMFDsForRup(Collection<ETAS_EqkRupture> eventsList, int rupID, String info) {
        ArbIncrementalMagFreqDist allAftershocksMFD = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        ArbIncrementalMagFreqDist primaryAftershocksMFD = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        for (ETAS_EqkRupture event : eventsList) {
            ETAS_EqkRupture oldestAncestor = event.getOldestAncestor();
            if (oldestAncestor == null || oldestAncestor.getID() != rupID) continue;
            allAftershocksMFD.addResampledMagRate(event.getMag(), 1.0, true);
            if (event.getGeneration() != 1) continue;
            primaryAftershocksMFD.addResampledMagRate(event.getMag(), 1.0, true);
        }
        allAftershocksMFD.setName("MFD Histogram for all aftershocks of rupture (ID=" + rupID + ") for simulation " + info);
        allAftershocksMFD.setInfo("Total Num = " + allAftershocksMFD.calcSumOfY_Vals());
        primaryAftershocksMFD.setName("MFD Histogram of primary aftershocks of input rupture (ID=" + rupID + ") for simulation " + info);
        primaryAftershocksMFD.setInfo("Total Num = " + primaryAftershocksMFD.calcSumOfY_Vals());
        ArrayList<IncrementalMagFreqDist> magProbDists = new ArrayList<IncrementalMagFreqDist>();
        magProbDists.add(allAftershocksMFD);
        magProbDists.add(primaryAftershocksMFD);
        return magProbDists;
    }

    public static IncrementalMagFreqDist getTotalAftershockMFD_ForU3_RegionalGR(double mainshockMag, double expNumForM2p5) {
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, 1.0, false);
        return ETAS_SimAnalysisTools.getTotalAftershockMFD_ForU3_RegionalGR(mainshockMag, expNumForM2p5, erf);
    }

    public static IncrementalMagFreqDist getTotalAftershockMFD_ForU3_RegionalGR(double mainshockMag, double expNumForM2p5, FaultSystemSolution fss) {
        FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF(fss, false, 1.0, 2012);
        erf.updateForecast();
        return ETAS_SimAnalysisTools.getTotalAftershockMFD_ForU3_RegionalGR(mainshockMag, expNumForM2p5, erf);
    }

    public static IncrementalMagFreqDist getTotalAftershockMFD_ForU3_RegionalGR(double mainshockMag, double expNumForM2p5, FaultSystemSolutionERF erf) {
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        SummedMagFreqDist mfd = ERF_Calculator.getTotalMFD_ForERF(erf, 2.55, 8.45, 60, true);
        System.out.println("Orig MFD");
        System.out.println(mfd);
        double totalNum = expNumForM2p5 * Math.pow(10.0, mainshockMag - 2.5);
        System.out.println("Total Num: " + totalNum);
        mfd.scaleToCumRate(0, totalNum);
        System.out.println("Scaled MFD");
        System.out.println(mfd);
        return mfd;
    }

    public static void plotMagFreqDistsForRup(String fileNamePrefix, File resultsDir, ArrayList<IncrementalMagFreqDist> mfdList) {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        GraphWindow magProbDistsGraph = new GraphWindow(mfdList, "MFD Histogram for " + fileNamePrefix, plotChars);
        magProbDistsGraph.setX_AxisLabel("Mag");
        magProbDistsGraph.setY_AxisLabel("Number");
        magProbDistsGraph.setY_AxisRange(1.0E-5, 1000.0);
        magProbDistsGraph.setX_AxisRange(2.0, 9.0);
        magProbDistsGraph.setYLog(true);
        magProbDistsGraph.setPlotLabelFontSize(18);
        magProbDistsGraph.setAxisLabelFontSize(16);
        magProbDistsGraph.setTickLabelFontSize(14);
        ArrayList<EvenlyDiscretizedFunc> cumMagProbDists = new ArrayList<EvenlyDiscretizedFunc>();
        cumMagProbDists.add(mfdList.get(0).getCumRateDistWithOffset());
        cumMagProbDists.add(mfdList.get(1).getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotCharsCum = new ArrayList<PlotCurveCharacterstics>();
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        if (mfdList.size() > 2) {
            cumMagProbDists.add(mfdList.get(2).getCumRateDistWithOffset());
            plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        }
        GraphWindow cuMagProbDistsGraph = new GraphWindow(cumMagProbDists, "Cumulative MFD Hist for " + fileNamePrefix, plotCharsCum);
        cuMagProbDistsGraph.setX_AxisLabel("Mag");
        cuMagProbDistsGraph.setY_AxisLabel("Number");
        cuMagProbDistsGraph.setY_AxisRange(1.0E-4, 10000.0);
        cuMagProbDistsGraph.setX_AxisRange(2.0, 9.0);
        cuMagProbDistsGraph.setYLog(true);
        cuMagProbDistsGraph.setPlotLabelFontSize(18);
        cuMagProbDistsGraph.setAxisLabelFontSize(16);
        cuMagProbDistsGraph.setTickLabelFontSize(14);
        if (resultsDir != null) {
            String pathName = new File(resultsDir, fileNamePrefix + ".pdf").getAbsolutePath();
            String pathNameCum = new File(resultsDir, fileNamePrefix + "_Cum.pdf").getAbsolutePath();
            try {
                magProbDistsGraph.saveAsPDF(pathName);
                cuMagProbDistsGraph.saveAsPDF(pathNameCum);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotDistDecayDensityFromParentTriggerLocHist(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, double distDecay, double minDist) {
        double histLogMin = -2.0;
        double histLogMax = 4.0;
        int histNum = 31;
        EvenlyDiscretizedFunc expectedLogDistDecay = ETAS_Utils.getTargetDistDecayDensityFunc(histLogMin, histLogMax, histNum, distDecay, minDist);
        expectedLogDistDecay.setName("Expected Primary Dist Decay Density");
        expectedLogDistDecay.setInfo("(distDecay=" + distDecay + " and minDist=" + minDist + ")");
        HistogramFunction obsLogDistDecayHist = new HistogramFunction(histLogMin, histLogMax, histNum);
        obsLogDistDecayHist.setName("Observed Primary Dist Decay Density (relative to parent) for all aftershocks in " + info);
        double numFromPrimary = 0.0;
        for (ETAS_EqkRupture event : simulatedRupsQueue) {
            if (event.getGeneration() <= 0) continue;
            double logDist = Math.log10(event.getDistanceToParent());
            if (logDist >= histLogMin && logDist < histLogMax) {
                obsLogDistDecayHist.add(logDist, 1.0);
            }
            numFromPrimary += 1.0;
        }
        obsLogDistDecayHist.scale(1.0 / numFromPrimary);
        for (int i = 0; i < obsLogDistDecayHist.size(); ++i) {
            double xLogVal = obsLogDistDecayHist.getX(i);
            double binWidthLinear = Math.pow(10.0, xLogVal + obsLogDistDecayHist.getDelta() / 2.0) - Math.pow(10.0, xLogVal - obsLogDistDecayHist.getDelta() / 2.0);
            obsLogDistDecayHist.set(i, obsLogDistDecayHist.getY(i) / binWidthLinear);
        }
        obsLogDistDecayHist.setInfo("(based on " + numFromPrimary + " aftershocks)");
        ArrayList<EvenlyDiscretizedFunc> distDecayFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        distDecayFuncs.add(expectedLogDistDecay);
        distDecayFuncs.add(obsLogDistDecayHist);
        GraphWindow graph = new GraphWindow(distDecayFuncs, "Distance Decay Density for all Primary Aftershocks " + info);
        graph.setX_AxisLabel("Log10-Distance (km)");
        graph.setY_AxisLabel("Log10 Aftershock Density (per km)");
        graph.setX_AxisRange(histLogMin, histLogMax);
        graph.setX_AxisRange(-1.5, 3.0);
        double minYaxisVal = 0.0;
        for (int i = obsLogDistDecayHist.size() - 1; i >= 0; --i) {
            if (!(obsLogDistDecayHist.getY(i) > 0.0)) continue;
            minYaxisVal = obsLogDistDecayHist.getY(i);
            break;
        }
        graph.setY_AxisRange(minYaxisVal, graph.getY_AxisRange().getUpperBound());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 3.0f, Color.RED));
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void OLDplotDistDecayHistOfAshocksForRup(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, double distDecay, double minDist, int rupID) {
        double histLogMin = -2.0;
        double histLogMax = 4.0;
        int histNum = 31;
        EvenlyDiscretizedFunc expectedLogDistDecay = ETAS_Utils.getTargetDistDecayFunc(histLogMin, histLogMax, histNum, distDecay, minDist);
        expectedLogDistDecay.setName("Expected Log-Dist Decay");
        expectedLogDistDecay.setInfo("(distDecay=" + distDecay + " and minDist=" + minDist + ")");
        EvenlyDiscretizedFunc obsLogDistDecayHist = new EvenlyDiscretizedFunc(histLogMin, histLogMax, histNum);
        obsLogDistDecayHist.setTolerance(obsLogDistDecayHist.getDelta());
        obsLogDistDecayHist.setName("Observed Dist Decay for 1st Generation Aftershocks of " + info);
        EvenlyDiscretizedFunc obsLogDistDecayFromOldestAncestor = new EvenlyDiscretizedFunc(histLogMin, histLogMax, histNum);
        obsLogDistDecayFromOldestAncestor.setName("Observed Dist Decay for All Generation Aftershocks of " + info);
        obsLogDistDecayFromOldestAncestor.setTolerance(obsLogDistDecayHist.getDelta());
        double numFromOrigSurface = 0.0;
        double numFromParent = 0.0;
        for (ETAS_EqkRupture event : simulatedRupsQueue) {
            ETAS_EqkRupture oldestAncestor = event.getOldestAncestor();
            if (oldestAncestor == null || oldestAncestor.getID() != rupID) continue;
            double logDist = Math.log10(event.getDistanceToParent());
            if (logDist < histLogMin) {
                obsLogDistDecayHist.add(0, 1.0);
            } else if (logDist < histLogMax) {
                obsLogDistDecayHist.add(logDist, 1.0);
            }
            numFromParent += 1.0;
            logDist = Math.log10(LocationUtils.distanceToSurfFast(event.getHypocenterLocation(), oldestAncestor.getRuptureSurface()));
            if (logDist < histLogMin) {
                obsLogDistDecayFromOldestAncestor.add(0, 1.0);
            } else if (logDist < histLogMax) {
                obsLogDistDecayFromOldestAncestor.add(logDist, 1.0);
            }
            numFromOrigSurface += 1.0;
        }
        obsLogDistDecayHist.scale(1.0 / numFromParent);
        obsLogDistDecayFromOldestAncestor.scale(1.0 / numFromOrigSurface);
        obsLogDistDecayHist.setInfo("(based on " + numFromParent + " aftershocks)");
        obsLogDistDecayFromOldestAncestor.setInfo("(based on " + numFromOrigSurface + " aftershocks)");
        ArrayList<EvenlyDiscretizedFunc> distDecayFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        distDecayFuncs.add(expectedLogDistDecay);
        distDecayFuncs.add(obsLogDistDecayHist);
        distDecayFuncs.add(obsLogDistDecayFromOldestAncestor);
        GraphWindow graph = new GraphWindow(distDecayFuncs, "Aftershock Dist Decay for Input Rupture");
        graph.setX_AxisLabel("Log10-Distance (km)");
        graph.setY_AxisLabel("Fraction of Aftershocks");
        graph.setX_AxisRange(histLogMin, histLogMax);
        graph.setX_AxisRange(-1.5, 3.0);
        double minYaxisVal1 = 0.0;
        for (int i = obsLogDistDecayHist.size() - 1; i >= 0; --i) {
            if (!(obsLogDistDecayHist.getY(i) > 0.0)) continue;
            minYaxisVal1 = obsLogDistDecayHist.getY(i);
            break;
        }
        double minYaxisVal2 = 0.0;
        for (int i = obsLogDistDecayFromOldestAncestor.size() - 1; i >= 0; --i) {
            if (!(obsLogDistDecayFromOldestAncestor.getY(i) > 0.0)) continue;
            minYaxisVal2 = obsLogDistDecayFromOldestAncestor.getY(i);
            break;
        }
        double minYaxisVal = Math.min(minYaxisVal1, minYaxisVal2);
        graph.setY_AxisRange(minYaxisVal, graph.getY_AxisRange().getUpperBound());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE));
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static HistogramFunction getLogTriggerDistDecayDensityHist(List<ETAS_EqkRupture> aftershockList, double firstLogDist, double lastLogDist, double deltaLogDist) {
        int numPts = (int)Math.round((lastLogDist - firstLogDist) / deltaLogDist);
        HistogramFunction logDistDensityHist = new HistogramFunction(firstLogDist + deltaLogDist / 2.0, numPts, deltaLogDist);
        int numDist = aftershockList.size();
        for (ETAS_EqkRupture event : aftershockList) {
            double logDist = Math.log10(event.getDistanceToParent());
            if (logDist <= firstLogDist) {
                logDistDensityHist.add(0, 1.0 / (double)numDist);
                continue;
            }
            if (!(logDist < lastLogDist)) continue;
            logDistDensityHist.add(logDist, 1.0 / (double)numDist);
        }
        for (int i = 0; i < logDistDensityHist.size(); ++i) {
            double xLogVal = logDistDensityHist.getX(i);
            double lowerValueLinear = 0.0;
            if (i != 0) {
                lowerValueLinear = Math.pow(10.0, xLogVal - deltaLogDist / 2.0);
            }
            double binWidthLinear = Math.pow(10.0, xLogVal + deltaLogDist / 2.0) - lowerValueLinear;
            logDistDensityHist.set(i, logDistDensityHist.getY(i) / binWidthLinear);
        }
        return logDistDensityHist;
    }

    public static HistogramFunction getLogDistDecayDensityFromRupSurfaceHist(List<ETAS_EqkRupture> aftershockList, RuptureSurface surf, double firstLogDist, double lastLogDist, double deltaLogDist) {
        int numPts = (int)Math.round((lastLogDist - firstLogDist) / deltaLogDist);
        HistogramFunction lgoDistDensityHist = new HistogramFunction(firstLogDist + deltaLogDist / 2.0, numPts, deltaLogDist);
        double minDistCutoff = Double.NEGATIVE_INFINITY;
        int numDist = aftershockList.size();
        for (ETAS_EqkRupture event : aftershockList) {
            double logDist = Math.log10(ETAS_SimAnalysisTools.quickSurfDistUseCutoff(event.getHypocenterLocation(), surf, minDistCutoff));
            if (logDist <= firstLogDist) {
                lgoDistDensityHist.add(0, 1.0 / (double)numDist);
                continue;
            }
            if (!(logDist < lastLogDist)) continue;
            lgoDistDensityHist.add(logDist, 1.0 / (double)numDist);
        }
        for (int i = 0; i < lgoDistDensityHist.size(); ++i) {
            double xLogVal = lgoDistDensityHist.getX(i);
            double lowerValueLinear = 0.0;
            if (i != 0) {
                lowerValueLinear = Math.pow(10.0, xLogVal - deltaLogDist / 2.0);
            }
            double binWidthLinear = Math.pow(10.0, xLogVal + deltaLogDist / 2.0) - lowerValueLinear;
            lgoDistDensityHist.set(i, lgoDistDensityHist.getY(i) / binWidthLinear);
        }
        return lgoDistDensityHist;
    }

    private static double quickSurfDistUseCutoff(Location hypo, RuptureSurface surf, double minDistCutoff) {
        if (surf instanceof CompoundSurface) {
            double min = Double.POSITIVE_INFINITY;
            for (RuptureSurface ruptureSurface : ((CompoundSurface)surf).getSurfaceList()) {
                if (!((min = Math.min(min, ETAS_SimAnalysisTools.quickSurfDistUseCutoff(hypo, ruptureSurface, minDistCutoff))) < minDistCutoff)) continue;
                return min;
            }
            return min;
        }
        if (surf instanceof PointSurface) {
            return LocationUtils.linearDistanceFast(hypo, ((PointSurface)surf).getLocation());
        }
        Preconditions.checkState((boolean)(surf instanceof EvenlyGriddedSurface), (Object)("Surface must be either an EvenlyGriddedSurface or CompoundSurface comprised of only EvenlyGriddedSurface's; this is " + String.valueOf(surf.getClass())));
        EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
        double minDistance = Double.MAX_VALUE;
        if (gridSurf.getAveDip() == 90.0) {
            int closestCol = -1;
            double minHorizDist = Double.POSITIVE_INFINITY;
            for (int col = 0; col < gridSurf.getNumCols(); ++col) {
                double d = LocationUtils.horzDistanceFast(hypo, (Location)gridSurf.get(0, col));
                if (!(d < minHorizDist)) continue;
                minHorizDist = d;
                closestCol = col;
            }
            double minVertDist = Double.POSITIVE_INFINITY;
            for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                minVertDist = Math.min(minVertDist, Math.abs(LocationUtils.vertDistance(hypo, (Location)gridSurf.get(row, closestCol))));
            }
            return Math.sqrt(minHorizDist * minHorizDist + minVertDist * minVertDist);
        }
        double minDistCutoffSq = minDistCutoff * minDistCutoff;
        for (int col = 0; col < gridSurf.getNumCols(); ++col) {
            for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                double vertDist;
                Location loc = (Location)gridSurf.get(row, col);
                double d = LocationUtils.horzDistanceFast(hypo, loc);
                double totalDist = d * d + (vertDist = LocationUtils.vertDistance(hypo, loc)) * vertDist;
                if (totalDist < minDistance) {
                    minDistance = totalDist;
                }
                if (!(totalDist < minDistCutoffSq)) continue;
                return Math.sqrt(totalDist);
            }
        }
        return Math.sqrt(minDistance);
    }

    public static void plotDistDecayDensityOfAshocksForRup(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, double distDecay, double minDist, ETAS_EqkRupture rupture) {
        double histLogMin = -2.0;
        double histLogMax = 4.0;
        int histNum = 30;
        double histLogDelta = 0.2;
        int rupID = rupture.getID();
        EvenlyDiscretizedFunc expectedLogDistDecay = ETAS_Utils.getTargetDistDecayDensityFunc(histLogMin, histLogMax, histNum, distDecay, minDist);
        expectedLogDistDecay.setName("Expected Log-Dist Decay Density");
        expectedLogDistDecay.setInfo("(distDecay=" + distDecay + " and minDist=" + minDist + ")");
        List<ETAS_EqkRupture> primaryAshocksList = ETAS_SimAnalysisTools.getPrimaryAftershocks(new ArrayList<ETAS_EqkRupture>(simulatedRupsQueue), rupture.getID());
        HistogramFunction obsLogTriggerDistDecayForPrimayOnly = ETAS_SimAnalysisTools.getLogTriggerDistDecayDensityHist(primaryAshocksList, histLogMin, histLogMax, histLogDelta);
        obsLogTriggerDistDecayForPrimayOnly.setName("Observed Trigger Dist Decay Density for Primary Aftershocks of " + info);
        ETAS_CatalogIO.ETAS_Catalog allAshocksList = ETAS_SimAnalysisTools.getChildrenFromCatalog(new ArrayList<ETAS_EqkRupture>(simulatedRupsQueue), rupture.getID());
        HistogramFunction obsLogDistDecayFromRupSurfaceAllAshocks = ETAS_SimAnalysisTools.getLogDistDecayDensityFromRupSurfaceHist(allAshocksList, rupture.getRuptureSurface(), histLogMin, histLogMax, histLogDelta);
        obsLogDistDecayFromRupSurfaceAllAshocks.setName("Observed Dist Decay Density from Surface for All Aftershocks of " + info);
        double[] distArrayPrimary = new double[primaryAshocksList.size()];
        for (int i = 0; i < distArrayPrimary.length; ++i) {
            distArrayPrimary[i] = primaryAshocksList.get(i).getDistanceToParent();
        }
        Arrays.sort(distArrayPrimary);
        DefaultXY_DataSet nearestNeighborPrimaryData = new DefaultXY_DataSet();
        for (int i = 0; i < distArrayPrimary.length - 1; ++i) {
            double xVal = Math.log10((distArrayPrimary[i + 1] + distArrayPrimary[i]) / 2.0);
            double yVal = 1.0 / (distArrayPrimary[i + 1] - distArrayPrimary[i]);
            nearestNeighborPrimaryData.set(xVal, yVal / (double)distArrayPrimary.length);
        }
        nearestNeighborPrimaryData.setName("Nearest neighbor distance data for primary events");
        nearestNeighborPrimaryData.setInfo("");
        ArrayList<AbstractXY_DataSet> distDecayFuncs = new ArrayList<AbstractXY_DataSet>();
        distDecayFuncs.add(nearestNeighborPrimaryData);
        distDecayFuncs.add(expectedLogDistDecay);
        distDecayFuncs.add(obsLogTriggerDistDecayForPrimayOnly);
        distDecayFuncs.add(obsLogDistDecayFromRupSurfaceAllAshocks);
        GraphWindow graph = new GraphWindow(distDecayFuncs, "Aftershock Dist Decay Density for Scenario: " + info);
        graph.setX_AxisLabel("Log10-Distance (km)");
        graph.setY_AxisLabel("Log10 Aftershock Density (per km)");
        graph.setX_AxisRange(histLogMin, histLogMax);
        graph.setX_AxisRange(-1.5, 3.0);
        double minYaxisVal1 = 0.0;
        for (int i = obsLogTriggerDistDecayForPrimayOnly.size() - 1; i >= 0; --i) {
            if (!(obsLogTriggerDistDecayForPrimayOnly.getY(i) > 0.0)) continue;
            minYaxisVal1 = obsLogTriggerDistDecayForPrimayOnly.getY(i);
            break;
        }
        double minYaxisVal2 = 0.0;
        for (int i = obsLogDistDecayFromRupSurfaceAllAshocks.size() - 1; i >= 0; --i) {
            if (!(obsLogDistDecayFromRupSurfaceAllAshocks.getY(i) > 0.0)) continue;
            minYaxisVal2 = obsLogDistDecayFromRupSurfaceAllAshocks.getY(i);
            break;
        }
        double minYaxisVal = Math.min(minYaxisVal1, minYaxisVal2);
        graph.setY_AxisRange(minYaxisVal, graph.getY_AxisRange().getUpperBound());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE));
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void oldPlotDistDecayHistForAshocks(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, EqkRupture mainShock, double distDecay, double minDist) {
        double histLogMin = -2.0;
        double histLogMax = 4.0;
        int histNum = 31;
        EvenlyDiscretizedFunc expectedLogDistDecay = ETAS_Utils.getTargetDistDecayFunc(histLogMin, histLogMax, histNum, distDecay, minDist);
        expectedLogDistDecay.setName("Expected Log-Dist Decay");
        expectedLogDistDecay.setInfo("(distDecay=" + distDecay + " and minDist=" + minDist + ")");
        EvenlyDiscretizedFunc obsLogDistDecayHist = new EvenlyDiscretizedFunc(histLogMin, histLogMax, histNum);
        obsLogDistDecayHist.setTolerance(obsLogDistDecayHist.getDelta());
        obsLogDistDecayHist.setName("Observed Log_Dist Decay Histogram");
        EvenlyDiscretizedFunc obsLogDistDecayFromMainShockHist = new EvenlyDiscretizedFunc(histLogMin, histLogMax, histNum);
        obsLogDistDecayFromMainShockHist.setName("Observed Log_Dist Decay From Specified Minshock Histogram");
        obsLogDistDecayFromMainShockHist.setTolerance(obsLogDistDecayHist.getDelta());
        double numFromMainShock = 0.0;
        double numFromPrimary = 0.0;
        for (ETAS_EqkRupture event : simulatedRupsQueue) {
            if (event.getGeneration() <= 0) continue;
            double logDist = Math.log10(event.getDistanceToParent());
            if (logDist < histLogMin) {
                obsLogDistDecayHist.add(0, 1.0);
            } else if (logDist < histLogMax) {
                obsLogDistDecayHist.add(logDist, 1.0);
            }
            numFromPrimary += 1.0;
            if (mainShock == null) continue;
            logDist = Math.log10(LocationUtils.distanceToSurfFast(event.getHypocenterLocation(), mainShock.getRuptureSurface()));
            if (logDist < histLogMin) {
                obsLogDistDecayFromMainShockHist.add(0, 1.0);
            } else if (logDist < histLogMax) {
                obsLogDistDecayFromMainShockHist.add(logDist, 1.0);
            }
            numFromMainShock += 1.0;
        }
        obsLogDistDecayHist.scale(1.0 / numFromPrimary);
        if (mainShock != null) {
            obsLogDistDecayFromMainShockHist.scale(1.0 / numFromMainShock);
            if (mainShock.getRuptureSurface().isPointSurface()) {
                System.out.println("mainShock Loc: " + String.valueOf(mainShock.getRuptureSurface().getFirstLocOnUpperEdge()));
            }
        }
        obsLogDistDecayHist.setInfo("(based on " + numFromPrimary + " aftershocks)");
        ArrayList<EvenlyDiscretizedFunc> distDecayFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        distDecayFuncs.add(expectedLogDistDecay);
        distDecayFuncs.add(obsLogDistDecayHist);
        if (mainShock != null) {
            obsLogDistDecayFromMainShockHist.setInfo("(based on " + numFromMainShock + " aftershocks)");
        }
        GraphWindow graph = new GraphWindow(distDecayFuncs, "Distance Decay for Aftershocks" + info);
        graph.setX_AxisLabel("Log10-Distance (km)");
        graph.setY_AxisLabel("Fraction of Aftershocks");
        graph.setX_AxisRange(histLogMin, histLogMax);
        graph.setY_AxisRange(1.0E-6, 1.0);
        graph.setX_AxisRange(-1.5, 3.0);
        graph.setY_AxisRange(1.0E-4, 0.3);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 3.0f, Color.RED));
        if (mainShock != null) {
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.GREEN));
        }
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<EvenlyDiscretizedFunc> getExpectedPrimaryMFDs_ForRup(String rupInfo, String pdf_FileNamePrefix, List<SummedMagFreqDist> mfdList, EqkRupture rupture, double expNum, boolean isPoisson) {
        IncrementalMagFreqDist mfdSupra = mfdList.get(1).deepClone();
        if (isPoisson) {
            mfdSupra.scale(expNum);
            mfdSupra.setName("Expected MFD for supra seis primary aftershocks of " + rupInfo);
        } else {
            double probFirstSupra = mfdSupra.calcSumOfY_Vals();
            double probSupra = 1.0 - Math.pow(1.0 - probFirstSupra, expNum);
            mfdSupra.scale(probSupra / probFirstSupra);
            mfdSupra.setName("Prob of one or more supra seis primary aftershocks of " + rupInfo);
        }
        mfdSupra.setInfo("Data:\n" + mfdSupra.getMetadataString());
        IncrementalMagFreqDist mfdSubSeis = mfdList.get(2).deepClone();
        mfdSubSeis.scale(expNum);
        SummedMagFreqDist mfd = new SummedMagFreqDist(mfdSupra.getMinX(), mfdSupra.getMaxX(), mfdSupra.size());
        mfd.addIncrementalMagFreqDist(mfdSupra);
        mfd.addIncrementalMagFreqDist(mfdSubSeis);
        mfd.setName("Expected MFD for primary aftershocks of " + rupInfo);
        mfd.setInfo("expNum=" + expNum + "Data:\n" + mfd.getMetadataString());
        EvenlyDiscretizedFunc cumMFD = mfd.getCumRateDistWithOffset();
        cumMFD.setName("Cum MFD for primary aftershocks of " + rupInfo);
        String info = "expNum=" + (float)expNum + " over forecast duration\n";
        double expNumAtMainshockMag = cumMFD.getInterpolatedY(rupture.getMag());
        info = info + "expNumAtMainshockMag=" + (float)expNumAtMainshockMag + " (at mag " + (float)rupture.getMag() + ")\n";
        info = info + "Data:\n" + cumMFD.getMetadataString();
        cumMFD.setInfo(info);
        EvenlyDiscretizedFunc cumMFDsupra = mfdSupra.getCumRateDistWithOffset();
        cumMFDsupra.setName("Cum MFD for supra seis primary aftershocks of " + rupInfo);
        cumMFDsupra.setInfo(cumMFDsupra.getMetadataString());
        ArrayList<EvenlyDiscretizedFunc> mfdListReturned = new ArrayList<EvenlyDiscretizedFunc>();
        mfdListReturned.add(mfd);
        mfdListReturned.add(cumMFD);
        mfdListReturned.add(mfdSupra);
        mfdListReturned.add(cumMFDsupra);
        return mfdListReturned;
    }

    public static void plotExpectedPrimaryMFD_ForRup(String rupInfo, String pdf_FileNamePrefix, List<EvenlyDiscretizedFunc> mfdList, EqkRupture rupture, double expNum) {
        SummedMagFreqDist incrMFD = (SummedMagFreqDist)mfdList.get(0);
        double minMag = incrMFD.getMinMagWithNonZeroRate();
        double maxMagWithNonZeroRate = incrMFD.getMaxMagWithNonZeroRate();
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / incrMFD.getDelta()) + 1;
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToIncrRate(3.05, incrMFD.getY(3.05));
        gr.setName("Perfect GR");
        gr.setInfo("Data:\n" + gr.getMetadataString());
        EvenlyDiscretizedFunc grCum = gr.getCumRateDistWithOffset();
        grCum.setInfo("Data:\n" + grCum.getMetadataString());
        ArrayList<EvenlyDiscretizedFunc> incrMFD_List = new ArrayList<EvenlyDiscretizedFunc>();
        incrMFD_List.add(gr);
        incrMFD_List.add(mfdList.get(0));
        incrMFD_List.add(mfdList.get(2));
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        GraphWindow magProbDistsGraph = new GraphWindow(incrMFD_List, "Expected Primary Aftershock MFD", plotChars);
        magProbDistsGraph.setX_AxisLabel("Mag");
        magProbDistsGraph.setY_AxisLabel("Expected Num");
        magProbDistsGraph.setYLog(true);
        magProbDistsGraph.setPlotLabelFontSize(22);
        magProbDistsGraph.setAxisLabelFontSize(20);
        magProbDistsGraph.setTickLabelFontSize(18);
        ArrayList<EvenlyDiscretizedFunc> cumMFD_List = new ArrayList<EvenlyDiscretizedFunc>();
        double ratioAtM6pt3 = mfdList.get(1).getY(mfdList.get(1).getClosestXIndex(6.3)) / grCum.getY(grCum.getClosestXIndex(6.3));
        String newInfo = "blue/gray Ratio at M 6.3=" + (float)ratioAtM6pt3 + "\n" + grCum.getInfo();
        grCum.setInfo(newInfo);
        cumMFD_List.add(grCum);
        cumMFD_List.add(mfdList.get(1));
        cumMFD_List.add(mfdList.get(3));
        GraphWindow cumDistsGraph = new GraphWindow(cumMFD_List, "Expected Cumulative Primary Aftershock MFD", plotChars);
        cumDistsGraph.setX_AxisLabel("Mag");
        cumDistsGraph.setY_AxisLabel("Expected Number");
        cumDistsGraph.setY_AxisRange(1.0E-7, 100000.0);
        cumDistsGraph.setX_AxisRange(2.0, 9.0);
        cumDistsGraph.setYLog(true);
        cumDistsGraph.setPlotLabelFontSize(22);
        cumDistsGraph.setAxisLabelFontSize(20);
        cumDistsGraph.setTickLabelFontSize(18);
        EvenlyDiscretizedFunc mfd = mfdList.get(0);
        IncrementalMagFreqDist expSecondaryNum = new IncrementalMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        for (int i = 0; i < expSecondaryNum.size(); ++i) {
            expSecondaryNum.set(i, mfd.getY(i) * Math.pow(10.0, mfd.getX(i)));
        }
        IncrementalMagFreqDist subMFD = new IncrementalMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        IncrementalMagFreqDist supraMFD = new IncrementalMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        double sum = 0.0;
        double sumSub = 0.0;
        boolean subSeisMag = true;
        int count = 0;
        int lowIndex = expSecondaryNum.getClosestXIndex(expSecondaryNum.getMinMagWithNonZeroRate());
        int hiIndex = expSecondaryNum.getClosestXIndex(expSecondaryNum.getMaxMagWithNonZeroRate());
        for (int i = lowIndex; i <= hiIndex; ++i) {
            sum += expSecondaryNum.getY(i);
            if (subSeisMag) {
                subMFD.set(i, mfd.getY(i));
            } else {
                supraMFD.set(i, mfd.getY(i));
            }
            if (subSeisMag) {
                double fractDiff;
                sumSub += expSecondaryNum.getY(i);
                if (i + 1 <= hiIndex && (fractDiff = Math.abs(1.0 - expSecondaryNum.getY(i) / expSecondaryNum.getY(i + 1))) > 0.01) {
                    subSeisMag = false;
                }
            }
            ++count;
        }
        expSecondaryNum.setName("RelNumExpSecAftershocks");
        Object info = "This is the MFD of primary aftershocks multiplied by 10^mag\n";
        double sumPerfectGR = expSecondaryNum.getY(lowIndex) * (double)count;
        info = (String)info + "sum=" + (float)sum + " (vs " + (float)sumPerfectGR + " for perfect GR; ratio=" + (float)(sum / sumPerfectGR) + ")\n";
        info = (String)info + "grCorr_numPrimary=" + (float)((sumPerfectGR - sumSub) / (sum - sumSub)) + "\n";
        info = (String)info + "grCorr_numPrimary2=" + (float)ETAS_Utils.getScalingFactorToImposeGR_numPrimary(supraMFD, subMFD, false) + "\n";
        info = (String)info + "grCorr_supraRates=" + (float)ETAS_Utils.getScalingFactorToImposeGR_supraRates(supraMFD, subMFD, false) + "\n";
        info = (String)info + "Data:\n" + expSecondaryNum.getMetadataString();
        expSecondaryNum.setInfo((String)info);
        GraphWindow expSecGraph = new GraphWindow(expSecondaryNum, "Relative Expected Num Secondary Aftershocks");
        expSecGraph.setX_AxisLabel("Mag");
        expSecGraph.setY_AxisLabel("Rel Num Secondary");
        expSecGraph.setX_AxisRange(2.0, 9.0);
        expSecGraph.setPlotLabelFontSize(22);
        expSecGraph.setAxisLabelFontSize(20);
        expSecGraph.setTickLabelFontSize(18);
        if (pdf_FileNamePrefix != null) {
            try {
                magProbDistsGraph.saveAsPDF(pdf_FileNamePrefix + "_Incr.pdf");
                magProbDistsGraph.saveAsTXT(pdf_FileNamePrefix + "_Incr.txt");
                expSecGraph.saveAsPDF(pdf_FileNamePrefix + "_ExpRelSecAft.pdf");
                expSecGraph.saveAsTXT(pdf_FileNamePrefix + "_ExpRelSecAft.txt");
                if (!Double.isNaN(expNum)) {
                    cumDistsGraph.saveAsPDF(pdf_FileNamePrefix + "_Cum.pdf");
                    cumDistsGraph.saveAsTXT(pdf_FileNamePrefix + "_Cum.txt");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int[] getNumAftershocksForEachGeneration(Collection<ETAS_EqkRupture> simulatedRupsQueue, int maxGeneration) {
        int[] numForGen = new int[maxGeneration + 1];
        for (ETAS_EqkRupture rup : simulatedRupsQueue) {
            if (rup.getGeneration() >= numForGen.length) continue;
            int n = rup.getGeneration();
            numForGen[n] = numForGen[n] + 1;
        }
        return numForGen;
    }

    public static HistogramFunction getPrimaryRateVsLogTimePDF_ForAllEvents(PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, double firstLogDay, double lastLogDay, double deltaLogDay) {
        int numPts = (int)Math.round((lastLogDay - firstLogDay) / deltaLogDay);
        HistogramFunction rateVsLogTimeHist = new HistogramFunction(firstLogDay + deltaLogDay / 2.0, numPts, deltaLogDay);
        int numMissedBeforeFirstBin = 0;
        for (ETAS_EqkRupture event : simulatedRupsQueue) {
            if (event.getParentRup() == null || event.getGeneration() != 1) continue;
            double timeMillis = event.getOriginTime() - event.getParentRup().getOriginTime();
            double logTimeDays = Math.log10(timeMillis / 8.64E7);
            if (logTimeDays <= firstLogDay) {
                ++numMissedBeforeFirstBin;
                continue;
            }
            if (!(logTimeDays < lastLogDay)) continue;
            rateVsLogTimeHist.add(logTimeDays, 1.0);
        }
        for (int i = 0; i < rateVsLogTimeHist.size(); ++i) {
            double xLogVal = rateVsLogTimeHist.getX(i);
            double binWidthLinear = Math.pow(10.0, xLogVal + deltaLogDay / 2.0) - Math.pow(10.0, xLogVal - deltaLogDay / 2.0);
            rateVsLogTimeHist.set(i, rateVsLogTimeHist.getY(i) / binWidthLinear);
        }
        rateVsLogTimeHist.normalizeBySumOfY_Vals();
        rateVsLogTimeHist.setInfo("numMissedBeforeFirstBin=" + numMissedBeforeFirstBin);
        return rateVsLogTimeHist;
    }

    public static HistogramFunction getAftershockRateVsLogTimeHistForRup(List<ETAS_EqkRupture> aftershockList, int rupID, long rupOT_millis, double firstLogDay, double lastLogDay, double deltaLogDay) {
        int numPts = (int)Math.round((lastLogDay - firstLogDay) / deltaLogDay);
        HistogramFunction rateVsLogTimeHist = new HistogramFunction(firstLogDay + deltaLogDay / 2.0, numPts, deltaLogDay);
        int numMissedBeforeFirstBin = 0;
        for (ETAS_EqkRupture event : aftershockList) {
            double timeMillis = event.getOriginTime() - rupOT_millis;
            double logTimeDays = Math.log10(timeMillis / 8.64E7);
            if (logTimeDays <= firstLogDay) {
                ++numMissedBeforeFirstBin;
                continue;
            }
            if (!(logTimeDays < lastLogDay)) continue;
            rateVsLogTimeHist.add(logTimeDays, 1.0);
        }
        for (int i = 0; i < rateVsLogTimeHist.size(); ++i) {
            double xLogVal = rateVsLogTimeHist.getX(i);
            double binWidthLinear = Math.pow(10.0, xLogVal + deltaLogDay / 2.0) - Math.pow(10.0, xLogVal - deltaLogDay / 2.0);
            rateVsLogTimeHist.set(i, rateVsLogTimeHist.getY(i) / binWidthLinear);
        }
        rateVsLogTimeHist.setInfo("numMissedBeforeFirstBin=" + numMissedBeforeFirstBin);
        return rateVsLogTimeHist;
    }

    public static void plotRateVsLogTimeForPrimaryAshocks(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, double etasProductivity_k, double etasTemporalDecay_p, double etasMinTime_c) {
        double firstLogDay = -5.0;
        double lastLogDay = 5.0;
        double deltaLogDay = 0.2;
        HistogramFunction rateVsLogTimePrimaryOnly = ETAS_SimAnalysisTools.getPrimaryRateVsLogTimePDF_ForAllEvents(simulatedRupsQueue, firstLogDay, lastLogDay, deltaLogDay);
        rateVsLogTimePrimaryOnly.setName("Aftershock Rate PDF for all primary events in the " + info + " simulation");
        HistogramFunction targetFunc = ETAS_Utils.getRateWithLogTimeFunc(etasProductivity_k, etasTemporalDecay_p, 7.0, 2.5, etasMinTime_c, firstLogDay, lastLogDay, deltaLogDay);
        targetFunc.normalizeBySumOfY_Vals();
        targetFunc.setName("Expected Rate Decay PDF for all Primary Aftershocks");
        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
        funcs.add(rateVsLogTimePrimaryOnly);
        funcs.add(targetFunc);
        GraphWindow graph = new GraphWindow(funcs, "Primary Aftershock Rate for all events");
        graph.setX_AxisLabel("Log10 Days");
        graph.setY_AxisLabel("Rate (per day)");
        graph.setX_AxisRange(-4.0, 3.0);
        double minYaxisVal = 0.0;
        for (int i = rateVsLogTimePrimaryOnly.size() - 1; i >= 0; --i) {
            if (!(rateVsLogTimePrimaryOnly.getY(i) > 0.0)) continue;
            minYaxisVal = rateVsLogTimePrimaryOnly.getY(i);
            break;
        }
        graph.setY_AxisRange(minYaxisVal, graph.getY_AxisRange().getUpperBound());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotRateVsLogTimeForPrimaryAshocksOfRup(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, ETAS_EqkRupture rup, double etasProductivity_k, double etasTemporalDecay_p, double etasMinTime_c) {
        double firstLogDay = -5.0;
        double lastLogDay = 5.0;
        double deltaLogDay = 0.2;
        List<ETAS_EqkRupture> aftershocksList = ETAS_SimAnalysisTools.getPrimaryAftershocks(new ArrayList<ETAS_EqkRupture>(simulatedRupsQueue), rup.getID());
        HistogramFunction rateVsLogTimePrimaryOnly = ETAS_SimAnalysisTools.getAftershockRateVsLogTimeHistForRup(aftershocksList, rup.getID(), rup.getOriginTime(), firstLogDay, lastLogDay, deltaLogDay);
        rateVsLogTimePrimaryOnly.setName("Primary Aftershock Rate Histogram for " + info);
        double[] relativeEventTimesDays = new double[aftershocksList.size()];
        for (int i = 0; i < aftershocksList.size(); ++i) {
            double days;
            relativeEventTimesDays[i] = days = (double)(aftershocksList.get(i).getOriginTime() - rup.getOriginTime()) / 8.64E7;
        }
        DefaultXY_DataSet interEventRatesXY_DataSet = new DefaultXY_DataSet();
        for (int i = 0; i < relativeEventTimesDays.length - 1; ++i) {
            double xVal = Math.log10((relativeEventTimesDays[i] + relativeEventTimesDays[i + 1]) / 2.0);
            double yVal = 1.0 / (relativeEventTimesDays[i + 1] - relativeEventTimesDays[i]);
            if (Double.isInfinite(yVal)) continue;
            interEventRatesXY_DataSet.set(xVal, yVal);
        }
        interEventRatesXY_DataSet.setName("Inter-event Rates for " + info);
        interEventRatesXY_DataSet.setInfo(" ");
        HistogramFunction targetFunc = ETAS_Utils.getRateWithLogTimeFunc(etasProductivity_k, etasTemporalDecay_p, rup.getMag(), 2.5, etasMinTime_c, firstLogDay, lastLogDay, deltaLogDay);
        targetFunc.setName("Expected Rate Decay for Primary Aftershocks");
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        funcs.add(interEventRatesXY_DataSet);
        funcs.add(rateVsLogTimePrimaryOnly);
        funcs.add(targetFunc);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        GraphWindow graph = new GraphWindow(funcs, "Primary Aftershock Rate for" + info, plotChars);
        graph.setX_AxisLabel("Log10 Days");
        graph.setY_AxisLabel("Rate (per day)");
        graph.setX_AxisRange(-4.0, 3.0);
        graph.setY_AxisRange(0.001, graph.getY_AxisRange().getUpperBound());
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotRateVsLogTimeForAllAshocksOfRup(String info, String pdf_FileName, PriorityQueue<ETAS_EqkRupture> simulatedRupsQueue, ETAS_EqkRupture rup, double etasProductivity_k, double etasTemporalDecay_p, double etasMinTime_c) {
        double firstLogDay = -5.0;
        double lastLogDay = 5.0;
        double deltaLogDay = 0.2;
        ETAS_CatalogIO.ETAS_Catalog aftershocksList = ETAS_SimAnalysisTools.getChildrenFromCatalog(new ArrayList<ETAS_EqkRupture>(simulatedRupsQueue), rup.getID());
        HistogramFunction rateVsLogTimePrimaryOnly = ETAS_SimAnalysisTools.getAftershockRateVsLogTimeHistForRup(aftershocksList, rup.getID(), rup.getOriginTime(), firstLogDay, lastLogDay, deltaLogDay);
        rateVsLogTimePrimaryOnly.setName("All Aftershocks Rate Histogram for " + info);
        double[] relativeEventTimesDays = new double[aftershocksList.size()];
        for (int i = 0; i < aftershocksList.size(); ++i) {
            double days;
            relativeEventTimesDays[i] = days = (double)(((ETAS_EqkRupture)aftershocksList.get(i)).getOriginTime() - rup.getOriginTime()) / 8.64E7;
        }
        DefaultXY_DataSet interEventRatesXY_DataSet = new DefaultXY_DataSet();
        for (int i = 0; i < relativeEventTimesDays.length - 1; ++i) {
            double xVal = Math.log10((relativeEventTimesDays[i] + relativeEventTimesDays[i + 1]) / 2.0);
            double yVal = 1.0 / (relativeEventTimesDays[i + 1] - relativeEventTimesDays[i]);
            if (Double.isInfinite(yVal)) continue;
            interEventRatesXY_DataSet.set(xVal, yVal);
        }
        interEventRatesXY_DataSet.setName("Inter-event Rates for " + info);
        interEventRatesXY_DataSet.setInfo(" ");
        HistogramFunction targetFunc = ETAS_Utils.getRateWithLogTimeFunc(etasProductivity_k, etasTemporalDecay_p, rup.getMag(), 2.5, etasMinTime_c, firstLogDay, lastLogDay, deltaLogDay);
        targetFunc.setName("Expected Rate Decay for All Aftershocks");
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        funcs.add(interEventRatesXY_DataSet);
        funcs.add(rateVsLogTimePrimaryOnly);
        funcs.add(targetFunc);
        GraphWindow graph = new GraphWindow(funcs, "All Aftershocks Rate for " + info);
        graph.setX_AxisLabel("Log10 Days");
        graph.setY_AxisLabel("Rate (per day)");
        graph.setX_AxisRange(-4.0, 3.0);
        graph.setY_AxisRange(0.001, graph.getY_AxisRange().getUpperBound());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        graph.setPlotChars(plotChars);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(14);
        if (pdf_FileName != null) {
            try {
                graph.saveAsPDF(pdf_FileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeMemoryUse(String info) {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        System.out.println(info);
        System.out.println("\tin use memory: " + format.format((allocatedMemory - freeMemory) / 1024L));
        System.out.println("\tfree memory: " + format.format(freeMemory / 1024L));
        System.out.println("\tallocated memory: " + format.format(allocatedMemory / 1024L));
        System.out.println("\tmax memory: " + format.format(maxMemory / 1024L));
        System.out.println("\ttotal free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
    }

    public static void plotCatalogGMT(List<? extends ObsEqkRupture> catalog, File outputDir, String outputPrefix, boolean display) throws IOException, GMT_MapException {
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(2.5, 8.5);
        ArrayList faults = Lists.newArrayList();
        ArrayList valuesList = Lists.newArrayList();
        ArrayList symbols = Lists.newArrayList();
        for (ObsEqkRupture obsEqkRupture : catalog) {
            double mag = obsEqkRupture.getMag();
            if (obsEqkRupture.getRuptureSurface() == null) {
                Location hypo = obsEqkRupture.getHypocenterLocation();
                double width = mag - 2.5;
                if (width < 0.1) {
                    width = 0.1;
                }
                symbols.add(new PSXYSymbol(new Point2D.Double(hypo.getLongitude(), hypo.getLatitude()), PSXYSymbol.Symbol.CIRCLE, width /= 50.0, 0.0, null, cpt.getColor((float)mag)));
                continue;
            }
            faults.add(obsEqkRupture.getRuptureSurface().getEvenlyDiscritizedPerimeter());
            valuesList.add(mag);
        }
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        boolean bl = false;
        String label = "Magnitude";
        System.out.println("Making map with " + faults.size() + " fault based ruptures");
        double[] values = Doubles.toArray((Collection)valuesList);
        GMT_Map map = FaultBasedMapGen.buildMap(cpt, faults, values, null, 1.0, region, bl, label);
        map.setSymbols(symbols);
        FaultBasedMapGen.plotMap(outputDir, outputPrefix, display, map);
    }

    public static int getFSSIndex(ETAS_EqkRupture rup, FaultSystemSolutionERF erf) {
        int sourceIndex;
        if (rup.getFSSIndex() >= 0) {
            return rup.getFSSIndex();
        }
        int nthIndex = rup.getNthERF_Index();
        Preconditions.checkState((nthIndex >= 0 ? 1 : 0) != 0, (Object)"No Nth rupture index!");
        try {
            sourceIndex = erf.getSrcIndexForNthRup(nthIndex);
        }
        catch (Exception e) {
            return -1;
        }
        if (sourceIndex < erf.getNumFaultSystemSources()) {
            return erf.getFltSysRupIndexForSource(sourceIndex);
        }
        return -1;
    }

    public static void loadFSSIndexesFromNth(List<ETAS_EqkRupture> catalog, FaultSystemSolutionERF erf) {
        for (ETAS_EqkRupture rup : catalog) {
            int fssIndex = ETAS_SimAnalysisTools.getFSSIndex(rup, erf);
            if (fssIndex < 0) continue;
            rup.setFSSIndex(fssIndex);
        }
    }

    public static void loadFSSRupSurfaces(List<ETAS_EqkRupture> catalog, FaultSystemSolutionERF erf) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        for (ETAS_EqkRupture rup : catalog) {
            int fssIndex = ETAS_SimAnalysisTools.getFSSIndex(rup, erf);
            if (fssIndex < 0) continue;
            Preconditions.checkState(((float)rup.getMag() == (float)rupSet.getMagForRup(fssIndex) ? 1 : 0) != 0, (Object)("Magnitude discrepancy: " + (float)rup.getMag() + " != " + (float)rupSet.getMagForRup(fssIndex)));
            rup.setRuptureSurface(rupSet.getSurfaceForRupture(fssIndex, 1.0));
        }
    }

    public static ETAS_CatalogIO.ETAS_Catalog getChildrenFromCatalog(List<ETAS_EqkRupture> catalog, int ... parentIDs) {
        ETAS_SimulationMetadata meta = catalog instanceof ETAS_CatalogIO.ETAS_Catalog ? ((ETAS_CatalogIO.ETAS_Catalog)catalog).getSimulationMetadata() : null;
        ETAS_CatalogIO.ETAS_Catalog ret = new ETAS_CatalogIO.ETAS_Catalog(meta);
        HashSet<Integer> parents = new HashSet<Integer>();
        for (int parentID : parentIDs) {
            parents.add(parentID);
        }
        Object object = catalog.iterator();
        while (object.hasNext()) {
            ETAS_EqkRupture rup = (ETAS_EqkRupture)object.next();
            if (rup.getParentID() < 0 || !parents.contains(rup.getParentID()) && !parents.contains(rup.getID())) continue;
            ret.add(rup);
            parents.add(rup.getID());
        }
        if (meta != null) {
            ret.updateMetadataForCatalog();
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static ETAS_CatalogIO.ETAS_Catalog getAboveMagPreservingChain(List<ETAS_EqkRupture> catalog, double minMag) {
        void var6_9;
        ETAS_SimulationMetadata eTAS_SimulationMetadata;
        HashMap catalogMap = Maps.newHashMap();
        int minID = Integer.MAX_VALUE;
        for (ETAS_EqkRupture eTAS_EqkRupture : catalog) {
            catalogMap.put(eTAS_EqkRupture.getID(), eTAS_EqkRupture);
            if (eTAS_EqkRupture.getID() >= minID) continue;
            minID = eTAS_EqkRupture.getID();
        }
        HashSet<Integer> idsForInclusion = new HashSet<Integer>();
        for (ETAS_EqkRupture rup : catalog) {
            Integer parentID;
            Integer id = rup.getID();
            double mag = rup.getMag();
            if (!(mag >= minMag)) continue;
            idsForInclusion.add(id);
            while (rup.getParentID() >= 0 && (parentID = Integer.valueOf(rup.getParentID())) >= minID && !idsForInclusion.contains(parentID)) {
                idsForInclusion.add(parentID);
                rup = (ETAS_EqkRupture)catalogMap.get(parentID);
                Preconditions.checkNotNull((Object)rup, (String)"Chain broken, no rup found for id=%s, filtered input catalog?", (Object)parentID);
            }
        }
        ETAS_SimulationMetadata eTAS_SimulationMetadata2 = eTAS_SimulationMetadata = catalog instanceof ETAS_CatalogIO.ETAS_Catalog ? ((ETAS_CatalogIO.ETAS_Catalog)catalog).getSimulationMetadata() : null;
        if (eTAS_SimulationMetadata != null) {
            ETAS_SimulationMetadata eTAS_SimulationMetadata3 = eTAS_SimulationMetadata.getModMinMag(minMag).getUpdatedForCatalog(catalogMap.values());
        }
        ETAS_CatalogIO.ETAS_Catalog ret = new ETAS_CatalogIO.ETAS_Catalog((ETAS_SimulationMetadata)var6_9);
        for (Integer id : idsForInclusion) {
            ret.add((ETAS_EqkRupture)catalogMap.get(id));
        }
        Collections.sort(ret, eventComparator);
        return ret;
    }

    public static List<ETAS_EqkRupture> getPrimaryAftershocks(List<ETAS_EqkRupture> catalog, int parentID) {
        ArrayList ret = Lists.newArrayList();
        for (ETAS_EqkRupture rup : catalog) {
            if (rup.getParentID() != parentID) continue;
            ret.add(rup);
        }
        return ret;
    }

    public static List<ETAS_EqkRupture> getByGeneration(List<ETAS_EqkRupture> catalog, int generation) {
        ArrayList ret = Lists.newArrayList();
        for (ETAS_EqkRupture rup : catalog) {
            if (rup.getGeneration() != generation) continue;
            ret.add(rup);
        }
        return ret;
    }

    public static List<ETAS_EqkRupture> getPrimaryAftershocks(List<ETAS_EqkRupture> catalog) {
        ArrayList ret = Lists.newArrayList();
        for (ETAS_EqkRupture rup : catalog) {
            if (rup.getGeneration() != 1) continue;
            ret.add(rup);
        }
        return ret;
    }

    public static double getMaxMag(List<ETAS_EqkRupture> catalog) {
        double maxMag = Double.NEGATIVE_INFINITY;
        for (ETAS_EqkRupture rup : catalog) {
            maxMag = Math.max(maxMag, rup.getMag());
        }
        return maxMag;
    }

    public static void plotMaxMagVsNumAftershocks(List<List<ETAS_EqkRupture>> catalogs, int parentID) {
        try {
            ETAS_SimAnalysisTools.plotMaxMagVsNumAftershocks(catalogs, parentID, 0.0, null, null);
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void plotMaxMagVsNumAftershocks(List<List<ETAS_EqkRupture>> catalogs, int parentID, double mainShockMag, File outputFile, String title) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (List<ETAS_EqkRupture> list : catalogs) {
            void var8_7;
            if (parentID >= 0) {
                ETAS_CatalogIO.ETAS_Catalog eTAS_Catalog = ETAS_SimAnalysisTools.getChildrenFromCatalog(list, parentID);
            }
            double maxMag = 0.0;
            for (ETAS_EqkRupture rup : var8_7) {
                double mag = rup.getMag();
                if (!(mag > maxMag)) continue;
                maxMag = mag;
            }
            scatter.set(maxMag, (double)var8_7.size());
        }
        ArrayList elems = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        int bufferSize = 20;
        if (scatter.getMaxY() < 300.0) {
            bufferSize = 5;
        }
        double minX = scatter.getMinX() - 0.1;
        double maxX = scatter.getMaxX() + 0.1;
        double minY = scatter.getMinY() - (double)bufferSize;
        double maxY = scatter.getMaxY() + (double)bufferSize;
        if (mainShockMag > 0.0) {
            DefaultXY_DataSet magLine = new DefaultXY_DataSet();
            magLine.setName("Mainshock Magnitude");
            magLine.set(mainShockMag, 0.0);
            magLine.set(mainShockMag, minY);
            magLine.set(mainShockMag, 0.5 * (minY + maxY));
            magLine.set(mainShockMag, maxY);
            magLine.set(mainShockMag, maxX * 5.0);
            elems.add(magLine);
            arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        }
        elems.add(scatter);
        arrayList.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        if (title == null) {
            title = "Max Aftershock Mag vs Num Afershocks";
        }
        PlotSpec spec = new PlotSpec(elems, arrayList, title, "Max Aftershock Mag", "Number of Aftershocks");
        if (mainShockMag > 0.0) {
            int numAbove = 0;
            int tot = scatter.size();
            for (Point2D pt : scatter) {
                if (!(pt.getX() > mainShockMag)) continue;
                ++numAbove;
            }
            String text = numAbove + "/" + tot + " (" + (float)(100.0 * (double)numAbove / (double)tot) + " %) above M" + (float)mainShockMag;
            if (title != null) {
                System.out.println(title + ": " + text);
            }
            ArrayList annotations = Lists.newArrayList();
            XYTextAnnotation ann = new XYTextAnnotation(text, minX + (maxX - minX) * 0.2, minY + (maxY - minY) * 0.95);
            ann.setFont(new Font("SansSerif", 0, 18));
            annotations.add(ann);
            spec.setPlotAnnotations(annotations);
        }
        if (outputFile == null) {
            GraphWindow gw = new GraphWindow(spec);
            gw.setDefaultCloseOperation(3);
            gw.setAxisRange(minX, maxX, minY, maxY);
            gw.setYLog(true);
        } else {
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(20);
            gp.setPlotLabelFontSize(21);
            gp.setBackgroundColor(Color.WHITE);
            gp.setUserBounds(minX, maxX, minY, maxY);
            gp.setYLog(true);
            gp.drawGraphPanel(spec);
            gp.getChartPanel().setSize(1000, 800);
            if (outputFile.getName().toLowerCase().endsWith(".png")) {
                gp.saveAsPNG(outputFile.getAbsolutePath());
            } else {
                gp.saveAsPDF(outputFile.getAbsolutePath());
            }
        }
    }

    public static int[] getIndicesForHighestValuesInArray(IntegerPDF_FunctionSampler sampler, int numValues) {
        return ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(sampler.getY_valuesArray(), numValues);
    }

    public static int[] getIndicesForHighestValuesInArray(double[] valsArray, int numValues) {
        double curMinProb = Double.POSITIVE_INFINITY;
        class ProbPairing
        implements Comparable<ProbPairing> {
            private double value;
            private int index;

            private ProbPairing(double prob, int index) {
                this.value = prob;
                this.index = index;
            }

            @Override
            public int compareTo(ProbPairing o) {
                return -Double.compare(this.value, o.value);
            }
        }
        ArrayList<ProbPairing> pairings = new ArrayList<ProbPairing>(numValues + 5);
        for (int i = 0; i < valsArray.length; ++i) {
            double value = valsArray[i];
            if (value < curMinProb && pairings.size() == numValues) continue;
            ProbPairing pairing = new ProbPairing(value, i);
            int index = Collections.binarySearch(pairings, pairing);
            if (index < 0) {
                index = -(index + 1);
            }
            pairings.add(index, pairing);
            if (pairings.size() > numValues) {
                pairings.remove(pairings.size() - 1);
            }
            curMinProb = ((ProbPairing)pairings.get((int)(pairings.size() - 1))).value;
        }
        double prevProb = Double.POSITIVE_INFINITY;
        for (ProbPairing pairing : pairings) {
            Preconditions.checkState((prevProb >= pairing.value ? 1 : 0) != 0, (Object)("pairing list isn't sorted?  prevProb=" + prevProb + ",  pairing.value=" + pairing.value));
            prevProb = pairing.value;
        }
        int[] indices = new int[numValues];
        int i = 0;
        for (ProbPairing pairing : pairings) {
            indices[i] = pairing.index;
            ++i;
        }
        return indices;
    }

    public static void plotRateOverTime(List<ETAS_EqkRupture> catalog, double startTimeYears, double durationYears, double binWidthDays, File outputDir, String prefix, int plotWidthPixels, double annotateMinMag, double annotateBinWidth) throws IOException {
        float symbolWidth;
        DefaultXY_DataSet ann;
        int numBins;
        Preconditions.checkState((!catalog.isEmpty() ? 1 : 0) != 0, (Object)"Empty catalog");
        long actualOT = catalog.get(0).getOriginTime();
        long actualMaxOT = catalog.get(catalog.size() - 1).getOriginTime();
        long startOT = startTimeYears > 0.0 ? actualOT + (long)(startTimeYears * 3.15576E10) : actualOT;
        Preconditions.checkState((startOT < actualMaxOT ? 1 : 0) != 0, (Object)"Start time is after end of catalog");
        long binWidth = (long)(binWidthDays * 8.64E7);
        long maxOT = (long)((double)startOT + durationYears * 3.15576E10);
        if (maxOT > actualMaxOT) {
            maxOT = actualMaxOT;
        }
        Preconditions.checkState(((numBins = (int)((maxOT - startOT) / binWidth)) > 1 ? 1 : 0) != 0, (Object)"Must have at least 2 bins!");
        boolean xAxisDays = durationYears < 2.0;
        double funcDelta = xAxisDays ? binWidthDays : binWidthDays / 365.25;
        double funcMin = funcDelta * 0.5;
        EvenlyDiscretizedFunc rateFunc = new EvenlyDiscretizedFunc(funcMin, numBins, funcDelta);
        rateFunc.setName("Catalog");
        EvenlyDiscretizedFunc poissonFunc = new EvenlyDiscretizedFunc(funcMin, numBins, funcDelta);
        poissonFunc.setName("Poisson");
        List<ETAS_EqkRupture> poissonCatalog = ETAS_SimAnalysisTools.getRandomizedCatalog(catalog);
        List<DefaultXY_DataSet> anns = ETAS_SimAnalysisTools.populateRateFunc(catalog, rateFunc, startOT, binWidth, xAxisDays, annotateMinMag, annotateBinWidth);
        List<DefaultXY_DataSet> poissonAnns = ETAS_SimAnalysisTools.populateRateFunc(poissonCatalog, poissonFunc, startOT, binWidth, xAxisDays, annotateMinMag, annotateBinWidth);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        for (int i = 0; i < rateFunc.size(); ++i) {
            if (rateFunc.getY(i) < 0.1) {
                rateFunc.set(i, 0.1);
            }
            if (!(poissonFunc.getY(i) < 0.1)) continue;
            poissonFunc.set(i, 0.1);
        }
        funcs.add(poissonFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        funcs.add(rateFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        double maxY = Math.max(rateFunc.getMaxY(), poissonFunc.getMaxY());
        double mainAnnY = maxY * 12.5;
        double poissonAnnY = maxY * 5.0;
        float minAnnSize = 10.0f;
        float scalarEach = 10.0f;
        int i = anns.size();
        while (--i >= 0) {
            ann = anns.get(i);
            if (ann == null || ann.size() == 0) continue;
            funcs.add(ann);
            symbolWidth = minAnnSize + (float)i * scalarEach;
            ann.scale(mainAnnY);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, symbolWidth, Color.RED));
        }
        i = poissonAnns.size();
        while (--i >= 0) {
            ann = poissonAnns.get(i);
            if (ann == null || ann.size() == 0) continue;
            funcs.add(ann);
            symbolWidth = minAnnSize + (float)i * scalarEach;
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, symbolWidth, Color.BLACK));
            ann.scale(poissonAnnY);
            ann.setName(null);
        }
        String xAxisLabel = xAxisDays ? "Time (Days)" : "Time (Years)";
        Object yAxisLabel = (float)binWidthDays == 1.0f ? "Daily Rate" : ((float)binWidthDays == 7.0f ? "Weekly Rate" : ((float)binWidthDays == 30.0f ? "Monthly Rate" : "Rate per " + (float)binWidthDays + " Days"));
        PlotSpec spec = new PlotSpec(funcs, chars, "Rate vs Time", xAxisLabel, (String)yAxisLabel);
        spec.setLegendVisible(true);
        Object fName = prefix == null ? "" : prefix + "_";
        fName = (String)fName + "rate_over_time_" + (int)durationYears + "yrs";
        if (startTimeYears > 0.0) {
            fName = (String)fName + "_start" + (int)startTimeYears;
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(new Range(0.0, durationYears), null);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        if (plotWidthPixels <= 0) {
            plotWidthPixels = (int)(durationYears * 2.0);
        }
        gp.getChartPanel().setSize(plotWidthPixels, 800);
        gp.saveAsPNG(new File(outputDir, (String)fName + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, (String)fName + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, (String)fName + ".txt").getAbsolutePath());
    }

    private static List<DefaultXY_DataSet> populateRateFunc(List<ETAS_EqkRupture> catalog, EvenlyDiscretizedFunc rateFunc, long startOT, long binWidth, boolean xAxisDays, double annotateMinMag, double annotateBinWidth) {
        ArrayList annotations = Lists.newArrayList();
        int catalogIndex = 0;
        for (int i = 0; i < rateFunc.size(); ++i) {
            ETAS_EqkRupture rup;
            long ot;
            int num = 0;
            long binStart = startOT + binWidth * (long)i;
            long binEnd = binStart + binWidth;
            for (int n = catalogIndex; n < catalog.size() && (ot = (rup = catalog.get(n)).getOriginTime()) < binEnd; ++n) {
                ++catalogIndex;
                if (ot < binStart) continue;
                ++num;
                if (!(annotateMinMag > 0.0) || !(rup.getMag() >= annotateMinMag)) continue;
                int annIndex = (int)((rup.getMag() - annotateMinMag) / annotateBinWidth);
                while (annIndex >= annotations.size()) {
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    int index = annotations.size();
                    float minMag = (float)(annotateMinMag + (double)index * annotateBinWidth);
                    xy.setName("M>=" + minMag);
                    annotations.add(xy);
                }
                double t = xAxisDays ? (double)(ot - startOT) / 8.64E7 : (double)(ot - startOT) / 3.15576E10;
                ((DefaultXY_DataSet)annotations.get(annIndex)).set(t, 1.0);
            }
            rateFunc.set(i, (double)num);
        }
        return annotations;
    }

    public static List<ETAS_EqkRupture> getRandomizedCatalog(List<ETAS_EqkRupture> catalog) {
        Preconditions.checkArgument((catalog.size() > 1 ? 1 : 0) != 0, (Object)"Can't randomize catalog with less than 2 ruptures");
        long ot = catalog.get(0).getOriginTime();
        long durationMillis = catalog.get(catalog.size() - 1).getOriginTime() - ot;
        ArrayList randomized = Lists.newArrayList();
        for (ETAS_EqkRupture rup : catalog) {
            long time = ot + (long)(Math.random() * (double)durationMillis);
            ETAS_EqkRupture clone = (ETAS_EqkRupture)rup.clone();
            clone.setOriginTime(time);
            randomized.add(clone);
        }
        Collections.sort(randomized, eventComparator);
        return randomized;
    }

    public static void main(String[] args) throws IOException, GMT_MapException, DocumentException {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2016_02_17-spontaneous-1000yr-scaleMFD1p14-full_td-subSeisSupraNucl-gridSeisCorr/");
        File catalogFile = new File(simDir, "individual_binary/catalog_000.bin");
        ETAS_CatalogIO.ETAS_Catalog catalog = ETAS_CatalogIO.loadCatalogBinary(catalogFile);
        File outputDir = new File(simDir, "rate_over_time");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double startTimeYears = 550.0;
        double durationYears = 100.0;
        int plotWidthPixels = 2000;
        double binWidthDays = 30.0;
        String prefix = null;
        double annotateMinMag = 0.0;
        double annotateBinWidth = 0.5;
        ETAS_SimAnalysisTools.plotRateOverTime(catalog, startTimeYears, durationYears, binWidthDays, outputDir, prefix, plotWidthPixels, annotateMinMag, annotateBinWidth);
    }

    public static class EpicenterMapThread
    implements Runnable {
        private String info;
        private ObsEqkRupture mainShock;
        private Collection<ETAS_EqkRupture> allAftershocks;
        private LocationList regionBorder;
        private long updateIntervalMillis;
        private boolean kill = false;
        private GraphWindow gw;

        public EpicenterMapThread(String info, ObsEqkRupture mainShock, Collection<ETAS_EqkRupture> allAftershocks, LocationList regionBorder, long updateIntervalMillis) {
            this.info = info;
            this.mainShock = mainShock;
            this.allAftershocks = allAftershocks;
            this.regionBorder = regionBorder;
            this.updateIntervalMillis = updateIntervalMillis;
        }

        @Override
        public void run() {
            this.kill = false;
            int prevCnt = 0;
            long eventStart = -1L;
            while (!this.kill) {
                try {
                    Thread.sleep(this.updateIntervalMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.allAftershocks.size() <= prevCnt) continue;
                ArrayList allAftershocks = Lists.newArrayList(this.allAftershocks);
                if (eventStart < 0L) {
                    eventStart = ((ETAS_EqkRupture)allAftershocks.get(0)).getOriginTime();
                }
                prevCnt = allAftershocks.size();
                PlotSpec spec = ETAS_SimAnalysisTools.getEpicenterMapSpec(this.info, this.mainShock, allAftershocks, this.regionBorder);
                long endTime = ((ETAS_EqkRupture)allAftershocks.get(allAftershocks.size() - 1)).getOriginTime();
                long duration = endTime - eventStart;
                double durationSecs = (double)duration / 1000.0;
                double durationMins = durationSecs / 60.0;
                double durationHours = durationMins / 60.0;
                double durationDays = durationHours / 24.0;
                String timeStr = durationDays > 1.0 ? (float)durationDays + " days" : (durationHours > 1.0 ? (float)durationHours + " hours" : (durationMins > 1.0 ? (float)durationMins + " mins" : (float)durationSecs + " secs"));
                double minLat = 90.0;
                double maxLat = -90.0;
                double minLon = 360.0;
                double maxLon = -360.0;
                if (this.gw == null) {
                    for (PlotElement plotElement : spec.getPlotElems()) {
                        if (!(plotElement instanceof XY_DataSet)) continue;
                        XY_DataSet func = (XY_DataSet)plotElement;
                        if (func.getMaxX() > maxLon) {
                            maxLon = func.getMaxX();
                        }
                        if (func.getMinX() < minLon) {
                            minLon = func.getMinX();
                        }
                        if (func.getMaxY() > maxLat) {
                            maxLat = func.getMaxY();
                        }
                        if (!(func.getMinY() < minLat)) continue;
                        minLat = func.getMinY();
                    }
                    double deltaLat = maxLat - minLat;
                    double deltaLon = maxLon - minLon;
                    double aveLat = (minLat + maxLat) / 2.0;
                    double scaleFactor = 1.57 / Math.cos(aveLat * Math.PI / 180.0);
                    if (deltaLat > deltaLon / scaleFactor) {
                        maxLon = minLon + deltaLat * scaleFactor;
                    } else {
                        maxLat = minLat + deltaLon / scaleFactor;
                    }
                } else {
                    minLat = this.gw.getY_AxisRange().getLowerBound();
                    maxLat = this.gw.getY_AxisRange().getUpperBound();
                    minLon = this.gw.getX_AxisRange().getLowerBound();
                    maxLon = this.gw.getX_AxisRange().getUpperBound();
                }
                double x = minLon + (maxLon - minLon) * 0.95;
                double y = minLat + (maxLat - minLat) * 0.95;
                XYTextAnnotation ann = new XYTextAnnotation(timeStr, x, y);
                ann.setTextAnchor(TextAnchor.TOP_RIGHT);
                ann.setFont(new Font("SansSerif", 1, 18));
                spec.setPlotAnnotations(Lists.newArrayList((Object[])new XYTextAnnotation[]{ann}));
                if (this.gw == null) {
                    this.gw = new GraphWindow(spec, false);
                    this.gw.setX_AxisRange(minLon, maxLon);
                    this.gw.setY_AxisRange(minLat, maxLat);
                    this.gw.setPlotLabelFontSize(18);
                    this.gw.setAxisLabelFontSize(16);
                    this.gw.setTickLabelFontSize(14);
                    this.gw.setVisible(true);
                    continue;
                }
                this.gw.setAxisRange(this.gw.getX_AxisRange(), this.gw.getY_AxisRange());
                this.gw.setPlotSpec(spec);
            }
            System.out.println("Done with map thread");
        }

        public void kill() {
            this.kill = true;
        }
    }
}

