/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;

public class ETAS_SimulationMetadata {
    public final int totalNumRuptures;
    public final long randomSeed;
    public final int catalogIndex;
    public final Range<Integer> rangeHistCatalogIDs;
    public final Range<Integer> rangeTriggerRupIDs;
    public final long simulationStartTime;
    public final long simulationEndTime;
    public final int numSpontaneousRuptures;
    public final int numSupraSeis;
    public final double minMag;
    public final double maxMag;

    private ETAS_SimulationMetadata(int totalNumRuptures, long randomSeed, int catalogIndex, Range<Integer> rangeHistCatalogIDs, Range<Integer> rangeTriggerRupIDs, long simulationStartTime, long simulationEndTime, int numSpontaneousRuptures, int numSupraSeis, double minMag, double maxMag) {
        this.totalNumRuptures = totalNumRuptures;
        this.randomSeed = randomSeed;
        this.catalogIndex = catalogIndex;
        if (rangeHistCatalogIDs != null) {
            Preconditions.checkState((rangeHistCatalogIDs.upperBoundType() == BoundType.CLOSED && rangeHistCatalogIDs.lowerBoundType() == BoundType.CLOSED ? 1 : 0) != 0, (Object)"upper and lower bounds should be closed to avoid possible confusion");
        }
        this.rangeHistCatalogIDs = rangeHistCatalogIDs;
        if (rangeTriggerRupIDs != null) {
            Preconditions.checkState((rangeTriggerRupIDs.upperBoundType() == BoundType.CLOSED && rangeTriggerRupIDs.lowerBoundType() == BoundType.CLOSED ? 1 : 0) != 0, (Object)"upper and lower bounds should be closed to avoid possible confusion");
        }
        this.rangeTriggerRupIDs = rangeTriggerRupIDs;
        this.simulationStartTime = simulationStartTime;
        this.simulationEndTime = simulationEndTime;
        this.numSpontaneousRuptures = numSpontaneousRuptures;
        this.numSupraSeis = numSupraSeis;
        this.minMag = minMag;
        this.maxMag = maxMag;
    }

    public static ETAS_SimulationMetadata instance(int totalNumRuptures, long randomSeed, int catalogIndex, Range<Integer> rangeHistCatalogIDs, Range<Integer> rangeTriggerRupIDs, long simulationStartTime, long simulationEndTime, int numSpontaneousRuptures, int numSupraSeis, double minMag, double maxMag) {
        return new ETAS_SimulationMetadata(totalNumRuptures, randomSeed, catalogIndex, rangeHistCatalogIDs, rangeTriggerRupIDs, simulationStartTime, simulationEndTime, numSpontaneousRuptures, numSupraSeis, minMag, maxMag);
    }

    public static ETAS_SimulationMetadata instance(long randomSeed, int catalogIndex, Range<Integer> rangeHistCatalogIDs, Range<Integer> rangeTriggerRupIDs, long simulationStartTime, long simulationEndTime, double minMag, Collection<ETAS_EqkRupture> catalog) {
        ETAS_SimulationMetadata meta = new ETAS_SimulationMetadata(catalog.size(), randomSeed, catalogIndex, rangeHistCatalogIDs, rangeTriggerRupIDs, simulationStartTime, simulationEndTime, -1, -1, minMag, Double.NaN);
        return meta.getUpdatedForCatalog(catalog);
    }

    public ETAS_SimulationMetadata getModMinMag(double minMag) {
        return new ETAS_SimulationMetadata(this.totalNumRuptures, this.randomSeed, this.catalogIndex, this.rangeHistCatalogIDs, this.rangeTriggerRupIDs, this.simulationStartTime, this.simulationEndTime, this.numSpontaneousRuptures, this.numSupraSeis, minMag, this.maxMag);
    }

    public ETAS_SimulationMetadata getModCatalogIndex(int catalogIndex) {
        return new ETAS_SimulationMetadata(this.totalNumRuptures, this.randomSeed, catalogIndex, this.rangeHistCatalogIDs, this.rangeTriggerRupIDs, this.simulationStartTime, this.simulationEndTime, this.numSpontaneousRuptures, this.numSupraSeis, this.minMag, this.maxMag);
    }

    public ETAS_SimulationMetadata getUpdatedForCatalog(Collection<ETAS_EqkRupture> catalog) {
        double maxMag = Double.NaN;
        int numSpontaneousRuptures = 0;
        int numSupraSeis = 0;
        for (ETAS_EqkRupture rup : catalog) {
            maxMag = Double.isNaN(maxMag) ? rup.getMag() : Math.max(maxMag, rup.getMag());
            if (rup.getFSSIndex() >= 0) {
                ++numSupraSeis;
            }
            if (rup.getGeneration() != 0) continue;
            ++numSpontaneousRuptures;
        }
        return new ETAS_SimulationMetadata(this.totalNumRuptures, this.randomSeed, this.catalogIndex, this.rangeHistCatalogIDs, this.rangeTriggerRupIDs, this.simulationStartTime, this.simulationEndTime, numSpontaneousRuptures, numSupraSeis, this.minMag, maxMag);
    }

    private static String rangeStr(Range<Integer> range) {
        if (range == null) {
            return null;
        }
        return "[" + String.valueOf(range.lowerEndpoint()) + " " + String.valueOf(range.upperEndpoint()) + "]";
    }

    public String toString() {
        return "totalNumRuptures=" + this.totalNumRuptures + ", seed=" + this.randomSeed + ", index=" + this.catalogIndex + ", rangHistCatalogIDs=" + ETAS_SimulationMetadata.rangeStr(this.rangeHistCatalogIDs) + ", rangeTriggerIDs=" + ETAS_SimulationMetadata.rangeStr(this.rangeTriggerRupIDs) + ", simStartTime=" + this.simulationEndTime + ", simEndTime=" + this.simulationEndTime + ", numSpontaneous=" + this.numSpontaneousRuptures + ", numSupraSeis=" + this.numSupraSeis + ", minMag=" + this.minMag + ", maxMag=" + this.maxMag;
    }
}

