/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupOrigTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.InterpolatedEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_DistanceDecayParam_q;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_MinDistanceParam_d;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_MinTimeParam_c;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ProductivityParam_k;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_TemporalDecayParam_p;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.MiscInfoAndPlotsCalc;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.U3_EqkCatalogStatewideCompleteness;

public class ETAS_Utils {
    public static final double magMin_DEFAULT = 2.5;
    public static final double k_DEFAULT = ETAS_ProductivityParam_k.DEFAULT_VALUE;
    public static final double p_DEFAULT = ETAS_TemporalDecayParam_p.DEFAULT_VALUE;
    public static final double c_DEFAULT = ETAS_MinTimeParam_c.DEFAULT_VALUE;
    public static final double distDecay_DEFAULT = ETAS_DistanceDecayParam_q.DEFAULT_VALUE;
    public static final double minDist_DEFAULT = ETAS_MinDistanceParam_d.DEFAULT_VALUE;
    private long randomSeed;
    RandomDataGenerator randomDataGen = new RandomDataGenerator();
    public static final SimpleDateFormat cat_df = new SimpleDateFormat("yyyy MM dd HH mm ss");
    private static final double min_spacing = 0.5;

    public ETAS_Utils() {
        this(System.currentTimeMillis());
    }

    public ETAS_Utils(long randomSeed) {
        this.randomDataGen.reSeed(randomSeed);
        this.randomSeed = randomSeed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public static final ArrayList<String> getDefaultParametersAsStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("k=" + k_DEFAULT);
        strings.add("p=" + p_DEFAULT);
        strings.add("c=" + c_DEFAULT);
        strings.add("magMin=2.5");
        return strings;
    }

    public static double getHardebeckDensity(double distance, double distDecay, double minDist, double seismoThickness) {
        double maxDist = 1000.0;
        if (distance > maxDist) {
            return 0.0;
        }
        double oneMinusDecay = 1.0 - distDecay;
        double cs = oneMinusDecay / (Math.pow(maxDist + minDist, oneMinusDecay) - Math.pow(minDist, oneMinusDecay));
        if (distance < seismoThickness / 2.0) {
            return cs * Math.pow(distance + minDist, -distDecay) / (Math.PI * 4 * distance * distance);
        }
        return cs * Math.pow(distance + minDist, -distDecay) / (Math.PI * 2 * distance * seismoThickness);
    }

    public static void testHardebeckDensity() {
        double histLogMinDistKm = -2.0;
        double histLogMaxDistKm = 3.0;
        int histNum = 31;
        EvenlyDiscretizedFunc targetLogDistDecay = ETAS_Utils.getTargetDistDecayFunc(histLogMinDistKm, histLogMaxDistKm, histNum, distDecay_DEFAULT, minDist_DEFAULT);
        EvenlyDiscretizedFunc testLogHistogram = new EvenlyDiscretizedFunc(histLogMinDistKm, histLogMaxDistKm, histNum);
        EvenlyDiscretizedFunc numLogHistogram = new EvenlyDiscretizedFunc(histLogMinDistKm, histLogMaxDistKm, histNum);
        testLogHistogram.setTolerance(testLogHistogram.getDelta());
        numLogHistogram.setTolerance(numLogHistogram.getDelta());
        double totWt = 0.0;
        double totVol = 0.0;
        double[] minXY = new double[]{0.0, 1.0, 4.0};
        double[] maxXY = new double[]{1.0, 4.0, 1000.0};
        double[] minZ = new double[]{0.0, 1.0, 4.0};
        double[] maxZ = new double[]{1.0, 4.0, 6.0};
        double[] discr = new double[]{0.005, 0.01, 0.5};
        int totNumX = 0;
        for (int i = 0; i < minXY.length; ++i) {
            totNumX = (int)((double)totNumX + (maxXY[i] - minXY[i]) / discr[i]);
        }
        CalcProgressBar progressBar = new CalcProgressBar("testDefaultHardebeckDensity()", "junk");
        progressBar.showProgress(true);
        for (int i = 0; i < minXY.length; ++i) {
            System.out.println(i);
            int numXY = (int)Math.round((maxXY[i] - minXY[i]) / discr[i]);
            int numZ = (int)Math.round((maxZ[i] - minZ[i]) / discr[i]);
            for (int x = 0; x < numXY; ++x) {
                progressBar.updateProgress(x, totNumX);
                for (int y = 0; y < numXY; ++y) {
                    for (int z = 0; z < numZ; ++z) {
                        double logDist;
                        double xDist = minXY[i] + (double)x * discr[i] + discr[i] / 2.0;
                        double yDist = minXY[i] + (double)y * discr[i] + discr[i] / 2.0;
                        double zDist = minZ[i] + (double)z * discr[i] + discr[i] / 2.0;
                        double dist = Math.pow(xDist * xDist + yDist * yDist + zDist * zDist, 0.5);
                        double vol = discr[i] * discr[i] * discr[i];
                        double wt = 8.0 * ETAS_Utils.getHardebeckDensity(dist, distDecay_DEFAULT, minDist_DEFAULT, 24.0) * vol;
                        totWt += wt;
                        if (dist <= 1000.0) {
                            totVol += vol;
                        }
                        if ((logDist = Math.log10(dist)) < testLogHistogram.getX(0)) {
                            testLogHistogram.add(0, wt);
                            numLogHistogram.add(0, 1.0);
                            continue;
                        }
                        if (!(logDist < histLogMaxDistKm)) continue;
                        testLogHistogram.add(logDist, wt);
                        numLogHistogram.add(logDist, 1.0);
                    }
                }
            }
        }
        progressBar.showProgress(false);
        System.out.println("totWt=" + totWt);
        double expVol = 3.769911184307752E7;
        System.out.println("totVol=" + totVol * 8.0 + "\texpVol=" + expVol);
        ArrayList<EvenlyDiscretizedFunc> funcs1 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs1.add(testLogHistogram);
        funcs1.add(targetLogDistDecay);
        GraphWindow graph = new GraphWindow(funcs1, "testLogHistogram");
        graph.setAxisRange(-2.0, 3.0, 1.0E-6, 1.0);
        graph.setYLog(true);
        EvenlyDiscretizedFunc testLogFunction = new EvenlyDiscretizedFunc(histLogMinDistKm, histLogMaxDistKm, histNum);
        for (int i = 0; i < testLogFunction.size(); ++i) {
            double dist = Math.pow(10.0, testLogFunction.getX(i));
            testLogFunction.set(i, ETAS_Utils.getHardebeckDensity(dist, distDecay_DEFAULT, minDist_DEFAULT, 24.0));
        }
        GraphWindow graph2 = new GraphWindow(testLogFunction, "testLogFunction");
        GraphWindow graph3 = new GraphWindow(numLogHistogram, "numLogHistogram");
    }

    public static double getDecayFractionInsideDistance(double distDecay, double minDist, double distance) {
        double oneMinus = 1.0 - distDecay;
        return -(Math.pow(distance + minDist, oneMinus) - Math.pow(minDist, oneMinus)) / Math.pow(minDist, oneMinus);
    }

    public static double getDistDecayValue(double dist, double minDist, double distDecay) {
        return Math.pow(dist + minDist, -distDecay);
    }

    public static EvenlyDiscretizedFunc getTargetDistDecayFunc(double minLogDist, double maxLogDist, int num, double distDecay, double minDist) {
        EvenlyDiscretizedFunc logTargetDecay = new EvenlyDiscretizedFunc(minLogDist, maxLogDist, num);
        logTargetDecay.setTolerance(logTargetDecay.getDelta());
        double logBinHalfWidth = logTargetDecay.getDelta() / 2.0;
        double upperBinEdge = Math.pow(10.0, logTargetDecay.getX(0) + logBinHalfWidth);
        double binWt = ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, upperBinEdge);
        logTargetDecay.set(0, binWt);
        for (int i = 1; i < logTargetDecay.size(); ++i) {
            double logLowerEdge = logTargetDecay.getX(i) - logBinHalfWidth;
            double lowerBinEdge = Math.pow(10.0, logLowerEdge);
            double logUpperEdge = logTargetDecay.getX(i) + logBinHalfWidth;
            upperBinEdge = Math.pow(10.0, logUpperEdge);
            double wtLower = ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, lowerBinEdge);
            double wtUpper = ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, upperBinEdge);
            binWt = wtUpper - wtLower;
            logTargetDecay.set(i, binWt);
        }
        return logTargetDecay;
    }

    public static EvenlyDiscretizedFunc getTargetDistDecayDensityFunc(double minLogDist, double maxLogDist, int num, double distDecay, double minDist) {
        EvenlyDiscretizedFunc logTargetDecay = new EvenlyDiscretizedFunc(minLogDist, maxLogDist, num);
        logTargetDecay.setTolerance(logTargetDecay.getDelta());
        double logBinHalfWidth = logTargetDecay.getDelta() / 2.0;
        for (int i = 0; i < logTargetDecay.size(); ++i) {
            double logLowerEdge = logTargetDecay.getX(i) - logBinHalfWidth;
            double lowerBinEdge = 0.0;
            if (i != 0) {
                lowerBinEdge = Math.pow(10.0, logLowerEdge);
            }
            double logUpperEdge = logTargetDecay.getX(i) + logBinHalfWidth;
            double upperBinEdge = Math.pow(10.0, logUpperEdge);
            double wtLower = 0.0;
            if (i != 0) {
                wtLower = ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, lowerBinEdge);
            }
            double wtUpper = ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, upperBinEdge);
            double binWt = wtUpper - wtLower;
            logTargetDecay.set(i, binWt / (upperBinEdge - lowerBinEdge));
        }
        return logTargetDecay;
    }

    public static EvenlyDiscretizedFunc getDecayFractionInsideDistFunc(double minLogDist, double maxLogDist, int num, double distDecay, double minDist) {
        EvenlyDiscretizedFunc logTargetDecay = new EvenlyDiscretizedFunc(minLogDist, maxLogDist, num);
        for (int i = 0; i < logTargetDecay.size(); ++i) {
            logTargetDecay.set(i, ETAS_Utils.getDecayFractionInsideDistance(distDecay, minDist, Math.pow(10.0, logTargetDecay.getX(i))));
        }
        logTargetDecay.setName("logTargetDecay");
        return logTargetDecay;
    }

    public static double getExpectedNumEvents(double k, double p, double magMain, double magMin, double c, double tMinDays, double tMaxDays) {
        double oneMinusP = 1.0 - p;
        double lambda = k * Math.pow(10.0, magMain - magMin) / oneMinusP;
        return lambda *= Math.pow(c + tMaxDays, oneMinusP) - Math.pow(c + tMinDays, oneMinusP);
    }

    public static double getDefaultExpectedNumEvents(double magMain, double tMinDays, double tMaxDays) {
        return ETAS_Utils.getExpectedNumEvents(k_DEFAULT, p_DEFAULT, magMain, 2.5, c_DEFAULT, tMinDays, tMaxDays);
    }

    public int getPoissonRandomNumber(double lambda) {
        Preconditions.checkState((boolean)Double.isFinite(lambda), (String)"lambda = %s", (Object)lambda);
        return (int)this.randomDataGen.nextPoisson(lambda);
    }

    public double getRandomDouble() {
        return this.randomDataGen.nextUniform(0.0, 1.0, true);
    }

    public int getRandomInt(int maxInt) {
        if (maxInt == 0) {
            return 0;
        }
        return this.randomDataGen.nextInt(0, maxInt);
    }

    public double getRandomETAS_k(double k, double cov) {
        if (cov == 0.0) {
            return k;
        }
        double sigma = Math.sqrt(Math.log(cov * cov + 1.0));
        double mean = -sigma * sigma / 2.0;
        double randGauss = this.randomDataGen.nextGaussian(mean, sigma);
        return k * Math.exp(randGauss);
    }

    public double getRandomTimeOfEvent(double c, double p, double tMin, double tMax) {
        double t;
        double r = this.getRandomDouble();
        if (p != 1.0) {
            double a1 = Math.pow(tMax + c, 1.0 - p);
            double a2 = Math.pow(tMin + c, 1.0 - p);
            double a3 = r * a1 + (1.0 - r) * a2;
            t = Math.pow(a3, 1.0 / (1.0 - p)) - c;
        } else {
            double a1 = Math.log(tMax + c);
            double a2 = Math.log(tMin + c);
            double a3 = r * a1 + (1.0 - r) * a2;
            t = Math.exp(a3) - c;
        }
        return t;
    }

    public double getDefaultRandomTimeOfEvent(double tMin, double tMax) {
        return this.getRandomTimeOfEvent(c_DEFAULT, p_DEFAULT, tMin, tMax);
    }

    public double[] getDefaultRandomEventTimes(double magMain, double tMinDays, double tMaxDays) {
        return this.getRandomEventTimes(k_DEFAULT, p_DEFAULT, magMain, 2.5, c_DEFAULT, tMinDays, tMaxDays);
    }

    public void setETAS_ParamsForRupture(ETAS_EqkRupture rup, ETAS_ParameterList etasParamList) {
        if (Double.isNaN(rup.getETAS_p())) {
            rup.setETAS_p(etasParamList.get_p());
        }
        if (Double.isNaN(rup.getETAS_c())) {
            rup.setETAS_c(etasParamList.get_c());
        }
        if (Double.isNaN(rup.getETAS_k())) {
            if (etasParamList.get_kCOV() == 0.0) {
                rup.setETAS_k(etasParamList.get_k());
            } else {
                rup.setETAS_k(this.getRandomETAS_k(etasParamList.get_k(), etasParamList.get_kCOV()));
            }
        }
    }

    public double[] getRandomEventTimes(double k, double p, double magMain, double magMin, double c, double tMinDays, double tMaxDays) {
        int numAft = this.getPoissonRandomNumber(ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, tMinDays, tMaxDays));
        double[] eventTimes = new double[numAft];
        for (int i = 0; i < numAft; ++i) {
            eventTimes[i] = this.getRandomTimeOfEvent(c, p, tMinDays, tMaxDays);
        }
        return eventTimes;
    }

    public double[] getRandomEventTimesTEMP(double k, double p, double magMain, double magMin, double c, double tMinDays, double tMaxDays) {
        int numAft = 10000;
        double[] eventTimes = new double[numAft];
        for (int i = 0; i < numAft; ++i) {
            eventTimes[i] = this.getRandomTimeOfEvent(c, p, tMinDays, tMaxDays);
        }
        return eventTimes;
    }

    public static EvenlyDiscretizedFunc getNumWithTimeFunc(double k, double p, double magMain, double magMin, double c, double tMin, double tMax, double tDelta) {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(tMin + tDelta / 2.0, tMax - tDelta / 2.0, (int)Math.round((tMax - tMin) / tDelta));
        for (int i = 0; i < func.size(); ++i) {
            double binTmin = func.getX(i) - tDelta / 2.0;
            double binTmax = func.getX(i) + tDelta / 2.0;
            double yVal = ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, binTmin, binTmax);
            func.set(i, yVal);
        }
        func.setName("Expected Number of Primary Aftershocks for " + tDelta + "-day intervals");
        func.setInfo("for k=" + k + ", p=" + p + ", c=" + c + ", magMain=" + magMain + ", magMin=" + magMin);
        return func;
    }

    public static EvenlyDiscretizedFunc getDefaultNumWithTimeFunc(double magMain, double tMin, double tMax, double tDelta) {
        return ETAS_Utils.getNumWithTimeFunc(k_DEFAULT, p_DEFAULT, magMain, 2.5, c_DEFAULT, tMin, tMax, tDelta);
    }

    public static HistogramFunction getNumWithLogTimeFunc(double k, double p, double magMain, double magMin, double c, double log_tMin, double log_tMax, double log_tDelta) {
        HistogramFunction func = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        for (int i = 0; i < func.size(); ++i) {
            double binTmin = Math.pow(10.0, func.getX(i) - log_tDelta / 2.0);
            double binTmax = Math.pow(10.0, func.getX(i) + log_tDelta / 2.0);
            double yVal = ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, binTmin, binTmax);
            func.set(i, yVal);
        }
        func.setName("Expected Number of Primary Aftershocks for log-day intervals of " + log_tDelta);
        func.setInfo("for k=" + k + ", p=" + p + ", c=" + c + ", magMain=" + magMain + ", magMin=" + magMin);
        return func;
    }

    public static HistogramFunction getRateWithLogTimeFunc(double k, double p, double magMain, double magMin, double c, double log_tMin, double log_tMax, double log_tDelta) {
        HistogramFunction func = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        for (int i = 0; i < func.size(); ++i) {
            double binTmin = Math.pow(10.0, func.getX(i) - log_tDelta / 2.0);
            double binTmax = Math.pow(10.0, func.getX(i) + log_tDelta / 2.0);
            double expNum = ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, binTmin, binTmax);
            func.set(i, expNum / (binTmax - binTmin));
        }
        func.setName("Expected Rate of Primary Aftershocks for log-day intervals of " + log_tDelta);
        func.setInfo("for k=" + k + ", p=" + p + ", c=" + c + ", magMain=" + magMain + ", magMin=" + magMin);
        return func;
    }

    public static EvenlyDiscretizedFunc getDefaultNumWithLogTimeFunc(double magMain, double log_tMin, double log_tMax, double log_tDelta) {
        return ETAS_Utils.getNumWithLogTimeFunc(k_DEFAULT, p_DEFAULT, magMain, 2.5, c_DEFAULT, log_tMin, log_tMax, log_tDelta);
    }

    public double[] JUNK_getRandomNumberForEachGeneration(double mainMag, IncrementalMagFreqDist mfd, double k, double p, double magMin, double c, double numDays, int numGen) {
        double[] numForEachGeneration = new double[numGen + 1];
        double[] mfdValsArray = new double[mfd.size()];
        double[] mfdMagsArray = new double[mfd.size()];
        for (int i = 0; i < mfd.size(); ++i) {
            mfdValsArray[i] = mfd.getY(i);
            mfdMagsArray[i] = mfd.getX(i);
        }
        IntegerPDF_FunctionSampler randMFD_Sampler = new IntegerPDF_FunctionSampler(mfdValsArray);
        double[] primaryEventTimesArray = this.getRandomEventTimes(k, p, mainMag, magMin, c, 0.0, numDays);
        ArrayList timesForCurrentGenList = Doubles.asList((double[])primaryEventTimesArray);
        numForEachGeneration[1] = timesForCurrentGenList.size();
        for (int currentGen = 2; currentGen <= 15; ++currentGen) {
            ArrayList timesForNextGeneration = new ArrayList();
            Iterator iterator = timesForCurrentGenList.iterator();
            while (iterator.hasNext()) {
                double eventTime = (Double)iterator.next();
                double mag = mfdMagsArray[randMFD_Sampler.getRandomInt()];
                double numDaysLeft = numDays - eventTime;
                double[] eventTimesArray = this.getRandomEventTimes(k, p, mag, magMin, c, 0.0, numDaysLeft);
                int j = 0;
                while (j < eventTimesArray.length) {
                    int n = j++;
                    eventTimesArray[n] = eventTimesArray[n] + eventTime;
                }
                int n = currentGen;
                numForEachGeneration[n] = numForEachGeneration[n] + (double)eventTimesArray.length;
                timesForNextGeneration.addAll(Doubles.asList((double[])eventTimesArray));
            }
            timesForCurrentGenList = timesForNextGeneration;
        }
        return numForEachGeneration;
    }

    public String listExpNumForEachGenerationAlt(double mainMag, IncrementalMagFreqDist mfd, double k, double p, double magMin, double c, double numDays, int numGen, int numRandomSamples) {
        boolean debug = true;
        double[] mfdValsArray = new double[mfd.size()];
        double[] mfdMagsArray = new double[mfd.size()];
        for (int j = 0; j < mfd.size(); ++j) {
            mfdValsArray[j] = mfd.getY(j);
            mfdMagsArray[j] = mfd.getX(j);
        }
        IntegerPDF_FunctionSampler randMFD_Sampler = new IntegerPDF_FunctionSampler(mfdValsArray);
        double[] aveNumForGen = new double[numGen + 1];
        double totNum = 0.0;
        double numPrimaryAboveMainMag = 0.0;
        double numTotalAboveMainMag = 0.0;
        double magMinusOne = mainMag - 1.0;
        boolean minMagOK = magMinusOne >= mfd.getMinX();
        double numPrimaryAtMainMagMinusOne = 0.0;
        double numTotalAtMainMagMinusOne = 0.0;
        if (!minMagOK) {
            numPrimaryAtMainMagMinusOne = Double.NaN;
            numTotalAtMainMagMinusOne = Double.NaN;
        }
        CalcProgressBar progressBar = new CalcProgressBar(mainMag + "; " + numDays, "junk");
        progressBar.showProgress(true);
        for (int i = 0; i < numRandomSamples; ++i) {
            progressBar.updateProgress(i, numRandomSamples);
            double[] numForEachGeneration = new double[numGen + 1];
            double[] primaryEventTimesArray = this.getRandomEventTimes(k, p, mainMag, magMin, c, 0.0, numDays);
            ArrayList timesForCurrentGenList = Doubles.asList((double[])primaryEventTimesArray);
            numForEachGeneration[1] = timesForCurrentGenList.size();
            for (int currentGen = 2; currentGen <= numGen; ++currentGen) {
                ArrayList timesForNextGeneration = new ArrayList();
                Iterator iterator = timesForCurrentGenList.iterator();
                while (iterator.hasNext()) {
                    double numDaysLeft;
                    double eventTime = (Double)iterator.next();
                    double mag = mfdMagsArray[randMFD_Sampler.getRandomInt()];
                    if (currentGen == 2 && mag >= mainMag) {
                        numPrimaryAboveMainMag += 1.0 / (double)numRandomSamples;
                    }
                    if (mag >= mainMag) {
                        numTotalAboveMainMag += 1.0 / (double)numRandomSamples;
                    }
                    if (minMagOK && currentGen == 2 && mag >= magMinusOne) {
                        numPrimaryAtMainMagMinusOne += 1.0 / (double)numRandomSamples;
                    }
                    if (minMagOK && mag >= magMinusOne) {
                        numTotalAtMainMagMinusOne += 1.0 / (double)numRandomSamples;
                    }
                    if ((numDaysLeft = numDays - eventTime) < 0.0) {
                        throw new RuntimeException("Problem");
                    }
                    double[] eventTimesArray = this.getRandomEventTimes(k, p, mag, magMin, c, 0.0, numDaysLeft);
                    int j = 0;
                    while (j < eventTimesArray.length) {
                        int n = j++;
                        eventTimesArray[n] = eventTimesArray[n] + eventTime;
                    }
                    int n = currentGen;
                    numForEachGeneration[n] = numForEachGeneration[n] + (double)eventTimesArray.length;
                    timesForNextGeneration.addAll(Doubles.asList((double[])eventTimesArray));
                }
                timesForCurrentGenList = timesForNextGeneration;
            }
            for (int j = 1; j < numForEachGeneration.length; ++j) {
                int n = j;
                aveNumForGen[n] = aveNumForGen[n] + numForEachGeneration[j] / (double)numRandomSamples;
                totNum += numForEachGeneration[j] / (double)numRandomSamples;
            }
        }
        progressBar.showProgress(false);
        System.out.println("numPrimaryAboveMainMag=" + numPrimaryAboveMainMag);
        Object resultString = Double.toString(mainMag);
        for (int i = 1; i <= numGen; ++i) {
            resultString = (String)resultString + "\t" + Float.toString((float)aveNumForGen[i]);
            if (!debug) continue;
            System.out.println("Gen " + (i + 1) + "\t" + (float)aveNumForGen[i] + "\t" + (double)((float)aveNumForGen[i]) / totNum);
        }
        if (debug) {
            System.out.println("Total: " + (float)totNum);
        }
        resultString = (String)resultString + "\t" + Float.toString((float)numPrimaryAboveMainMag) + "\t" + Float.toString((float)numTotalAboveMainMag);
        resultString = (String)resultString + "\t" + Float.toString((float)numPrimaryAtMainMagMinusOne) + "\t" + Float.toString((float)numTotalAtMainMagMinusOne) + "\n";
        return resultString;
    }

    public static String listExpNumForEachGenerationInfTime(double mainMag, IncrementalMagFreqDist mfd, double k, double p, double magMin, double c, int numGen) {
        double numTotalAtMainMagMinusOne;
        double numPrimaryAtMainMagMinusOne;
        double expPrimary;
        boolean debug = true;
        double[] numForGen = new double[numGen];
        double minMagCheck = Math.abs(mfd.getMinMagWithNonZeroRate() - mfd.getDelta() / 2.0 - magMin);
        if (minMagCheck > 1.0E-4) {
            throw new RuntimeException("Min mags must be the same");
        }
        IncrementalMagFreqDist normMFD = mfd.deepClone();
        normMFD.scale(1.0 / mfd.getTotalIncrRate());
        numForGen[0] = expPrimary = ETAS_Utils.getExpectedNumEvents(k, p, mainMag, magMin, c, 0.0, 1.0E15);
        IncrementalMagFreqDist expPrimaryMFD = mfd.deepClone();
        expPrimaryMFD.scale(expPrimary / mfd.getTotalIncrRate());
        int startMagIndex = mfd.getClosestXIndex(magMin + mfd.getDelta() / 2.0);
        int endMagIndex = mfd.getXIndex(mfd.getMaxMagWithNonZeroRate());
        double numForLastGen = expPrimary;
        for (int i = 1; i < numGen; ++i) {
            double expNum = 0.0;
            for (int m = startMagIndex; m <= endMagIndex; ++m) {
                double expNumAtMag = numForLastGen * normMFD.getY(m) * ETAS_Utils.getExpectedNumEvents(k, p, mfd.getX(m), magMin, c, 0.0, 1.0E15);
                expNum += expNumAtMag;
            }
            numForGen[i] = expNum;
            numForLastGen = expNum;
        }
        double totNum = 0.0;
        for (int i = 0; i < numGen; ++i) {
            totNum += numForGen[i];
        }
        IncrementalMagFreqDist expTotalMFD = mfd.deepClone();
        expTotalMFD.scale(totNum / mfd.getTotalIncrRate());
        Object resultString = Double.toString(mainMag);
        for (int i = 0; i < numGen; ++i) {
            resultString = (String)resultString + "\t" + Float.toString((float)numForGen[i]);
            if (!debug) continue;
            System.out.println("Gen " + (i + 1) + "\t" + (float)numForGen[i] + "\t" + (double)((float)numForGen[i]) / totNum);
        }
        if (debug) {
            System.out.println("Total: " + (float)totNum);
        }
        double numPrimaryAtMainMag = expPrimaryMFD.getCumRate(mainMag + mfd.getDelta() / 2.0);
        double numTotalAtMainMag = expTotalMFD.getCumRate(mainMag + mfd.getDelta() / 2.0);
        double magMinusOne = mainMag - 1.0 + mfd.getDelta() / 2.0;
        if (magMinusOne >= mfd.getMinX()) {
            numPrimaryAtMainMagMinusOne = expPrimaryMFD.getCumRate(magMinusOne);
            numTotalAtMainMagMinusOne = expTotalMFD.getCumRate(magMinusOne);
        } else {
            numPrimaryAtMainMagMinusOne = Double.NaN;
            numTotalAtMainMagMinusOne = Double.NaN;
        }
        resultString = (String)resultString + "\t" + Float.toString((float)numPrimaryAtMainMag) + "\t" + Float.toString((float)numTotalAtMainMag);
        resultString = (String)resultString + "\t" + Float.toString((float)numPrimaryAtMainMagMinusOne) + "\t" + Float.toString((float)numTotalAtMainMagMinusOne) + "\n";
        if (debug) {
            System.out.println("numPrimaryAtMainMag: " + (float)numPrimaryAtMainMag);
            System.out.println("numTotalAtMainMag: " + (float)numTotalAtMainMag);
            System.out.println("numPrimaryAtMainMagMinusOne: " + (float)numPrimaryAtMainMagMinusOne);
            System.out.println("numTotalAtMainMagMinusOne: " + (float)numTotalAtMainMagMinusOne);
            System.out.println("expPrimaryMFD.getTotalIncrRate() = " + expPrimaryMFD.getTotalIncrRate());
            System.out.println("expTotalMFD.getTotalIncrRate() = " + expTotalMFD.getTotalIncrRate());
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            expPrimaryMFD.setName("expPrimaryMFD");
            funcs.add(expPrimaryMFD);
            funcs.add(expPrimaryMFD.getCumRateDistWithOffset());
            expTotalMFD.setName("expTotalMFD");
            funcs.add(expTotalMFD);
            funcs.add(expTotalMFD.getCumRateDistWithOffset());
            GraphWindow sectGraph = new GraphWindow(funcs, "Expected MFDs");
            sectGraph.setX_AxisLabel("Mag");
            sectGraph.setY_AxisLabel("Rate");
            sectGraph.setYLog(true);
            sectGraph.setAxisLabelFontSize(20);
            sectGraph.setTickLabelFontSize(18);
            sectGraph.setPlotLabelFontSize(22);
        }
        return resultString;
    }

    public static double getBranchingRatio(IncrementalMagFreqDist mfd, double k, double p, double magMin, double c, double numDays) {
        int startMagIndex = mfd.getClosestXIndex(magMin + mfd.getDelta() / 2.0);
        int endMagIndex = mfd.getXIndex(mfd.getMaxMagWithNonZeroRate());
        double cumRate = mfd.getCumRate(startMagIndex);
        double branchRatio = 0.0;
        for (int m = startMagIndex; m <= endMagIndex; ++m) {
            branchRatio += mfd.getY(m) / cumRate * ETAS_Utils.getExpectedNumEvents(k, p, mfd.getX(m), magMin, c, 0.0, numDays);
        }
        return branchRatio;
    }

    public static void writeTriggerStatsToFiles(IncrementalMagFreqDist mfd) {
        ETAS_Utils etasUtils = new ETAS_Utils();
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        String prefix = "";
        double[] numDays = new double[]{1.0, 3.0, 7.0, 365.25, 3652.5, 36525.0, 365250.0};
        String[] filenames = new String[]{prefix + "ETAS_TriggerStats_1day.txt", prefix + "ETAS_TriggerStats_3days.txt", prefix + "ETAS_TriggerStats_1week.txt", prefix + "ETAS_TriggerStats_1year.txt", prefix + "ETAS_TriggerStats_10year.txt", prefix + "ETAS_TriggerStats_100year.txt", prefix + "ETAS_TriggerStats_1000year.txt"};
        for (int i = 0; i < numDays.length; ++i) {
            try {
                FileWriter fw = new FileWriter(new File(filenames[i]));
                fw.write("mag\tgen1\tgen2\tgen3\tgen4\tgen5\tgen6\tgen7\tgen8\tgen9\tgen10\tgen11\tgen12\tgen13\tgen14\tgen15\t");
                fw.write("gen1_AtMainMag\ttotAtMainMag\tgen1_AtMainMagMinus1\ttot_AtMainMagMinus1\n");
                for (double mainMag = 2.5; mainMag < 8.1; mainMag += 0.5) {
                    int numRandomSamples = (int)Math.pow(10000.0, 1.0 + (8.0 - mainMag) / 8.0);
                    System.out.println("Working on mag " + mainMag + "; numDays=" + numDays[i] + "; " + numRandomSamples);
                    String line = etasUtils.listExpNumForEachGenerationAlt(mainMag, mfd, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), numDays[i], 15, numRandomSamples);
                    fw.write(line);
                }
                fw.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeTimeDepTriggerStatsToFiles(IncrementalMagFreqDist mfd) {
        ETAS_Utils etasUtils = new ETAS_Utils();
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        String fileName = "ETAS_M2pt5_TriggerStatsVersusTime.txt";
        double logFirstTime = Math.log10(0.041666666666666664);
        double logLastTime = Math.log10(3.6525E7);
        int numTimes = 25;
        double deltaLogTime = (logLastTime - logFirstTime) / (double)(numTimes - 1);
        int numGen = 20;
        double mainMag = 2.5;
        int numRandomSamples = 10000000;
        System.out.println("numRandomSamples" + numRandomSamples);
        try {
            FileWriter fw = new FileWriter(new File(fileName));
            fw.write("numDays\tmag\tgen1\tgen2\tgen3\tgen4\tgen5\tgen6\tgen7\tgen8\tgen9\tgen10\tgen11\tgen12\tgen13\tgen14\tgen15\t");
            fw.write("gen1_AtMainMag\ttotAtMainMag\tgen1_AtMainMagMinus1\ttot_AtMainMagMinus1\n");
            for (int i = 0; i < numTimes; ++i) {
                double logTime = logFirstTime + deltaLogTime * (double)i;
                double numDays = Math.pow(10.0, logTime);
                System.out.println("Working on mag numDays=" + numDays + "; " + i + " of " + numTimes);
                String line = etasUtils.listExpNumForEachGenerationAlt(mainMag, mfd, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), numDays, numGen, numRandomSamples);
                System.out.println(numDays + "\t" + line);
                fw.write(numDays + "\t" + line);
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeTriggerStatsToFilesInfTime(IncrementalMagFreqDist mfd) {
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        String filename = "ETAS_TriggerStats_InfTime.txt";
        try {
            FileWriter fw = new FileWriter(new File(filename));
            fw.write("mag\tgen1\tgen2\tgen3\tgen4\tgen5\tgen6\tgen7\tgen8\tgen9\tgen10\tgen11\tgen12\tgen13\tgen14\tgen15\t");
            fw.write("gen1_AtMainMag\ttotAtMainMag\tgen1_AtMainMagMinus1\ttot_AtMainMagMinus1\n");
            for (double mainMag = 2.5; mainMag < 8.1; mainMag += 0.5) {
                System.out.println("Working on mag " + mainMag);
                String line = ETAS_Utils.listExpNumForEachGenerationInfTime(mainMag, mfd, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), 15);
                System.out.println(line);
                fw.write(line);
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static EvenlyDiscretizedFunc getSpontanousEventRateFunction(IncrementalMagFreqDist mfd, long histCatStartTime, long forecastStartTime, long forecastEndTime, int numTimeSamples, double k, double p, double magMin, double c) {
        Preconditions.checkState((numTimeSamples > 0 ? 1 : 0) != 0, (String)"numTimeSamples=%s, forecastStartTime=%s, forecastEndTime=%s", (Object)numTimeSamples, (Object)forecastStartTime, (Object)forecastEndTime);
        Preconditions.checkState((forecastEndTime > forecastStartTime ? 1 : 0) != 0, (String)"numTimeSamples=%s, forecastStartTime=%s, forecastEndTime=%s", (Object)numTimeSamples, (Object)forecastStartTime, (Object)forecastEndTime);
        double deltaTimeMillis = (double)(forecastEndTime - forecastStartTime) / (double)numTimeSamples;
        EvenlyDiscretizedFunc rateVsEpochTimeFunc = new EvenlyDiscretizedFunc((double)forecastStartTime + deltaTimeMillis / 2.0, (double)forecastEndTime - deltaTimeMillis / 2.0, numTimeSamples);
        double totalRatePerYear = mfd.getCumRate(2.55);
        int firstMagIndex = mfd.getXIndex(2.55);
        boolean warned = false;
        for (int i = 0; i < rateVsEpochTimeFunc.size(); ++i) {
            double histDurationDays = (rateVsEpochTimeFunc.getX(i) - (double)histCatStartTime) / 8.64E7;
            double aftRate = 0.0;
            if (histDurationDays > 0.0) {
                for (int m = firstMagIndex; m < mfd.size(); ++m) {
                    if (!(mfd.getY(m) > 1.0E-10)) continue;
                    double mag = mfd.getX(m);
                    aftRate += ETAS_Utils.getExpectedNumEvents(k, p, mag, magMin, c, 0.0, histDurationDays) * mfd.getY(m);
                }
            }
            if (aftRate > totalRatePerYear) {
                if (!warned) {
                    System.err.println("WARNING: ETAS parameters imply a rate of aftershocks from historical (or previous spontaneous) events larger than the long-term MFD, spontaneous rates will thus be zero from here on out");
                    System.err.println("\tepoch time: " + rateVsEpochTimeFunc.getX(i));
                    System.err.println("\taftershock rate: " + aftRate);
                    System.err.println("\tlong-term rate: " + totalRatePerYear);
                    System.err.println("Future warnings surpressed");
                    warned = true;
                }
                rateVsEpochTimeFunc.set(i, 0.0);
                continue;
            }
            rateVsEpochTimeFunc.set(i, totalRatePerYear - aftRate);
        }
        return rateVsEpochTimeFunc;
    }

    public static EvenlyDiscretizedFunc getSpontanousEventRateFunction(IncrementalMagFreqDist mfd, EvenlyDiscretizedFunc yrCompleteForMagFunc, long forecastStartTime, long forecastEndTime, int numTimeSamples, double k, double p, double magMin, double c) {
        Preconditions.checkState((numTimeSamples > 0 ? 1 : 0) != 0, (String)"numTimeSamples=%s, forecastStartTime=%s, forecastEndTime=%s", (Object)numTimeSamples, (Object)forecastStartTime, (Object)forecastEndTime);
        Preconditions.checkState((forecastEndTime > forecastStartTime ? 1 : 0) != 0, (String)"numTimeSamples=%s, forecastStartTime=%s, forecastEndTime=%s", (Object)numTimeSamples, (Object)forecastStartTime, (Object)forecastEndTime);
        double deltaTimeMillis = (double)(forecastEndTime - forecastStartTime) / (double)numTimeSamples;
        EvenlyDiscretizedFunc spRateVsEpochTimeFunc = new EvenlyDiscretizedFunc((double)forecastStartTime + deltaTimeMillis / 2.0, (double)forecastEndTime - deltaTimeMillis / 2.0, numTimeSamples);
        Preconditions.checkState((boolean)Double.isFinite(mfd.calcSumOfY_Vals()), (String)"MFD has non-finite values:\t%s", (Object)mfd);
        double totalRatePerYear = mfd.getCumRate(2.55);
        int firstMagIndex = mfd.getXIndex(2.55);
        boolean warned = false;
        for (int i = 0; i < spRateVsEpochTimeFunc.size(); ++i) {
            double aftRate = 0.0;
            for (int m = firstMagIndex; m < mfd.size(); ++m) {
                if (!(mfd.getY(m) > 1.0E-10)) continue;
                double mag = mfd.getX(m);
                double magCompleteTimeMillis = (yrCompleteForMagFunc.getY(mag) - 1970.0) * 3.15576E10;
                if (magCompleteTimeMillis > (double)forecastStartTime) {
                    magCompleteTimeMillis = forecastStartTime;
                }
                double histDurationDays = (spRateVsEpochTimeFunc.getX(i) - magCompleteTimeMillis) / 8.64E7;
                Preconditions.checkState((boolean)Double.isFinite(histDurationDays), (String)"Historical duration days not finite: %s", (Object)histDurationDays);
                double expectedNum = ETAS_Utils.getExpectedNumEvents(k, p, mag, magMin, c, 0.0, histDurationDays);
                Preconditions.checkState((boolean)Double.isFinite(expectedNum), (String)"Expected num not finite with duration=%s: %s", (Object)histDurationDays, (Object)expectedNum);
                aftRate += expectedNum * mfd.getY(m);
            }
            if (aftRate > totalRatePerYear) {
                if (!warned) {
                    System.err.println("WARNING: ETAS parameters imply a rate of aftershocks from historical (or previous spontaneous) events larger than the long-term MFD spontaneous rates will thus be zero from here on out");
                    System.err.println("\tepoch time: " + spRateVsEpochTimeFunc.getX(i));
                    System.err.println("\taftershock rate: " + aftRate);
                    System.err.println("\tlong-term rate: " + totalRatePerYear);
                    System.err.println("Future warnings surpressed");
                    warned = true;
                }
                spRateVsEpochTimeFunc.set(i, 0.0);
                continue;
            }
            spRateVsEpochTimeFunc.set(i, totalRatePerYear - aftRate);
        }
        if (warned) {
            System.err.println("Total spontaneous rate function sumY=" + spRateVsEpochTimeFunc.calcSumOfY_Vals());
        }
        return spRateVsEpochTimeFunc;
    }

    public long[] getRandomSpontanousEventTimes(IncrementalMagFreqDist mfd, long histCatStartTime, long forecastStartTime, long forecastEndTime, int numTimeSamples, double k, double p, double magMin, double c) {
        EvenlyDiscretizedFunc rateFunc = ETAS_Utils.getSpontanousEventRateFunction(mfd, histCatStartTime, forecastStartTime, forecastEndTime, numTimeSamples, k, p, magMin, c);
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(rateFunc);
        double meanRatePerYear = 0.0;
        for (int i = 0; i < rateFunc.size(); ++i) {
            meanRatePerYear += rateFunc.getY(i) / (double)rateFunc.size();
        }
        if (meanRatePerYear < 0.0) {
            throw new RuntimeException("meanRatePerYear is negative: " + meanRatePerYear + "\nrateFunc:" + String.valueOf(rateFunc));
        }
        double numYears = (rateFunc.getMaxX() - rateFunc.getMinX() + rateFunc.getDelta()) / 3.15576E10;
        int numEvents = this.getPoissonRandomNumber(meanRatePerYear * numYears);
        long[] eventTimesMillis = new long[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            int randIndex = sampler.getRandomInt(this.getRandomDouble());
            double time = rateFunc.getX(randIndex) + (this.getRandomDouble() - 0.5) * rateFunc.getDelta();
            eventTimesMillis[i] = (long)time;
        }
        return eventTimesMillis;
    }

    public long[] getRandomSpontanousEventTimes(IncrementalMagFreqDist mfd, EvenlyDiscretizedFunc yrCompleteForMagFunc, long forecastStartTime, long forecastEndTime, int numTimeSamples, double k, double p, double magMin, double c) {
        EvenlyDiscretizedFunc rateFunc = ETAS_Utils.getSpontanousEventRateFunction(mfd, yrCompleteForMagFunc, forecastStartTime, forecastEndTime, numTimeSamples, k, p, magMin, c);
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(rateFunc);
        double meanRatePerYear = 0.0;
        for (int i = 0; i < rateFunc.size(); ++i) {
            meanRatePerYear += rateFunc.getY(i) / (double)rateFunc.size();
        }
        Preconditions.checkState((Double.isFinite(meanRatePerYear) && meanRatePerYear >= 0.0 ? 1 : 0) != 0, (String)"Bad meanRatePerYear = %s, rateFunc.size() = %s, sum rateFuncY's = %s\nInput MFD:\n%s", (Object)meanRatePerYear, (Object)rateFunc.size(), (Object)rateFunc.calcSumOfY_Vals(), (Object)mfd);
        double numYears = (rateFunc.getMaxX() - rateFunc.getMinX() + rateFunc.getDelta()) / 3.15576E10;
        Preconditions.checkState((Double.isFinite(numYears) && numYears > 0.0 ? 1 : 0) != 0, (String)"Bad numYears = %s", (Object)numYears);
        int numEvents = this.getPoissonRandomNumber(meanRatePerYear * numYears);
        long[] eventTimesMillis = new long[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            int randIndex = sampler.getRandomInt(this.getRandomDouble());
            double time = rateFunc.getX(randIndex) + (this.getRandomDouble() - 0.5) * rateFunc.getDelta();
            eventTimesMillis[i] = (long)time;
        }
        return eventTimesMillis;
    }

    public static double[] getBinomialProportion95confidenceInterval(double p, double n) {
        return ETAS_Utils.getBinomialProportionConfidenceInterval(p, n, 1.96);
    }

    public static double[] getBinomialProportion68confidenceInterval(double p, double n) {
        return ETAS_Utils.getBinomialProportionConfidenceInterval(p, n, 1.0);
    }

    public static double[] getBinomialProportionConfidenceInterval(double p, double n, double z) {
        double[] conf = new double[2];
        double temp = z * Math.sqrt(z * z - 1.0 / n + 4.0 * n * p * (1.0 - p) + (4.0 * p - 2.0)) + 1.0;
        conf[0] = (2.0 * n * p + z * z - temp) / (2.0 * (n + z * z));
        if (conf[0] < 0.0 || p == 0.0) {
            conf[0] = 0.0;
        }
        temp = z * Math.sqrt(z * z - 1.0 / n + 4.0 * n * p * (1.0 - p) - (4.0 * p - 2.0)) + 1.0;
        conf[1] = (2.0 * n * p + z * z + temp) / (2.0 * (n + z * z));
        if (conf[1] > 1.0 || p == 1.0) {
            conf[1] = 1.0;
        }
        return conf;
    }

    public static void HaywiredGainVsTimeCalcs() {
        ETAS_ParameterList params = new ETAS_ParameterList();
        double k = params.get_k();
        System.out.println("k=" + k);
        double p = params.get_p();
        System.out.println("p=" + p);
        double c = params.get_c();
        System.out.println("c=" + c);
        double magMain = 7.090010114297865;
        p = 0.93;
        HistogramFunction target = ETAS_Utils.getRateWithLogTimeFunc(k *= 2.0, p, magMain, 2.5, c, -5.0, 5.0, 0.2);
        EvenlyDiscretizedFunc data = target.deepClone();
        data.set(-4.9, 35168.812);
        data.set(-4.7, 34876.2);
        data.set(-4.5, 37013.71);
        data.set(-4.3, 36061.816);
        data.set(-4.1, 35857.645);
        data.set(-3.9, 35403.047);
        data.set(-3.7, 35290.44);
        data.set(-3.5, 34594.004);
        data.set(-3.3, 33964.33);
        data.set(-3.1, 32326.615);
        data.set(-2.9, 30374.777);
        data.set(-2.7, 27741.95);
        data.set(-2.5, 24570.217);
        data.set(-2.3, 20672.906);
        data.set(-2.1, 16654.12);
        data.set(-1.9, 12845.319);
        data.set(-1.7, 9521.655);
        data.set(-1.5, 6797.2163);
        data.set(-1.3, 4724.7676);
        data.set(-1.1, 3223.443);
        data.set(-0.9, 2179.41);
        data.set(-0.7, 1456.371);
        data.set(-0.5, 965.5426);
        data.set(-0.3, 638.99805);
        data.set(-0.1, 413.92233);
        data.set(0.1, 271.74808);
        data.set(0.3, 179.2381);
        data.set(0.5, 116.87498);
        data.set(0.7, 77.475395);
        data.set(0.9, 49.832016);
        data.set(1.1, 31.630135);
        data.set(1.3, 21.39487);
        data.set(1.5, 13.848396);
        data.set(1.7, 9.093397);
        data.set(1.9, 5.835038);
        data.set(2.1, 3.8031235);
        data.set(2.3, 2.4973116);
        data.set(2.5, 1.574683);
        data.set(2.7, 1.0375878);
        data.set(2.9, 0.691435);
        data.set(3.1, 0.43251008);
        data.set(3.3, 0.29923725);
        data.set(3.5, 0.15886928);
        data.set(3.7, 0.0);
        data.set(3.9, 0.0);
        data.set(4.1, 0.0);
        data.set(4.3, 0.0);
        data.set(4.5, 0.0);
        data.set(4.7, 0.0);
        data.set(4.9, 0.0);
        ArbitrarilyDiscretizedFunc longTermRateFunc = new ArbitrarilyDiscretizedFunc();
        double longTermRate = 0.78 * Math.pow(10.0, 2.5) / 365.25;
        longTermRateFunc.set(-4.9, longTermRate);
        longTermRateFunc.set(4.9, longTermRate);
        DefaultXY_DataSet oneDayFunc = new DefaultXY_DataSet();
        oneDayFunc.set(0.0, 0.01);
        oneDayFunc.set(0.0, 100000.0);
        DefaultXY_DataSet oneHourFunc = new DefaultXY_DataSet();
        oneHourFunc.set(Math.log10(0.041666666666666664), 0.01);
        oneHourFunc.set(Math.log10(0.041666666666666664), 100000.0);
        DefaultXY_DataSet oneMinFunc = new DefaultXY_DataSet();
        oneMinFunc.set(Math.log10(6.944444444444445E-4), 0.01);
        oneMinFunc.set(Math.log10(6.944444444444445E-4), 100000.0);
        DefaultXY_DataSet oneMoFunc = new DefaultXY_DataSet();
        oneMoFunc.set(Math.log10(30.4375), 0.01);
        oneMoFunc.set(Math.log10(30.4375), 100000.0);
        DefaultXY_DataSet oneYrFunc = new DefaultXY_DataSet();
        oneYrFunc.set(Math.log10(365.25), 0.01);
        oneYrFunc.set(Math.log10(365.25), 100000.0);
        ArrayList<AbstractXY_DataSet> funcList = new ArrayList<AbstractXY_DataSet>();
        funcList.add(target);
        funcList.add(data);
        funcList.add(longTermRateFunc);
        funcList.add(oneDayFunc);
        funcList.add(oneHourFunc);
        funcList.add(oneMinFunc);
        funcList.add(oneMoFunc);
        funcList.add(oneYrFunc);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLUE));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        PlotCurveCharacterstics timeLineChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY);
        chars.add(timeLineChar);
        chars.add(timeLineChar);
        chars.add(timeLineChar);
        chars.add(timeLineChar);
        chars.add(timeLineChar);
        GraphWindow testGraph = new GraphWindow(funcList, "M 7.1 HayWired Aftershocks in SF Box", chars);
        testGraph.setYLog(true);
        testGraph.setY_AxisRange(0.01, 100000.0);
        testGraph.setX_AxisRange(-5.0, Math.log10(3652.5));
        testGraph.setY_AxisLabel("Rate Density (per day)");
        testGraph.setX_AxisLabel("Log Days");
        testGraph.setPlotLabelFontSize(24);
        testGraph.setAxisLabelFontSize(24);
        testGraph.setTickLabelFontSize(22);
        double min = 6.944444444444445E-4;
        double hour = 0.041666666666666664;
        double day = 1.0;
        double threeDays = 3.0;
        double week = 7.0;
        double month = 30.416666666666668;
        double year = 365.25;
        double tenYrs = 10.0 * year;
        double[] durations = new double[]{min, hour, day, threeDays, week, month, year, tenYrs};
        double[] latencies = new double[]{0.0, min, hour, day, threeDays, week, month, year, tenYrs};
        System.out.print("\n");
        for (double duration : durations) {
            System.out.print("\t" + (float)duration);
        }
        for (double latency : latencies) {
            System.out.print("\n" + (float)latency);
            for (double duration : durations) {
                double expNumLongTerm = 0.78 * duration * Math.pow(10.0, 2.5) / 365.25;
                double expNum = ETAS_Utils.getExpectedNumEvents(k, p, magMain, 2.5, c, latency, latency + duration);
                double gain = expNum / expNumLongTerm + 1.0;
                System.out.print("\t" + (float)gain);
            }
        }
        System.out.print("\n\n");
        for (int l = 0; l < latencies.length; ++l) {
            double latency = latencies[l];
            for (int d = 0; d < durations.length; ++d) {
                double duration = durations[d];
                double expNumLongTerm = 0.78 * duration * Math.pow(10.0, 2.5) / 365.25;
                double expNum = ETAS_Utils.getExpectedNumEvents(k, p, magMain, 2.5, c, latency, latency + duration);
                double gain = expNum / expNumLongTerm + 1.0;
                System.out.println(-l + "\t" + -d + "\t" + (float)Math.log10(gain) + "\t" + (float)Math.log10(gain));
            }
        }
    }

    public static void main(String[] args) {
        double[] valArray = new double[100000];
        double k = ETAS_ProductivityParam_k.DEFAULT_VALUE;
        ETAS_Utils utils = new ETAS_Utils();
        double mean = 0.0;
        for (int i = 0; i < valArray.length; ++i) {
            valArray[i] = utils.getRandomETAS_k(k, 1.16);
            mean += valArray[i];
        }
        StandardDeviation sd2 = new StandardDeviation();
        double stdDev = sd2.evaluate(valArray);
        System.out.println("orig=" + k + "\nmean=" + (mean /= (double)valArray.length) + "\nstdDev=" + stdDev + "\ncov=" + stdDev / mean);
        System.exit(0);
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, 1.0, false);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        SummedMagFreqDist mfd = ERF_Calculator.getTotalMFD_ForERF(erf, 2.55, 8.45, 60, true);
        try {
            U3_EqkCatalogStatewideCompleteness completeness = U3_EqkCatalogStatewideCompleteness.STRICT;
            List<ETAS_EqkRupture> histCat = null;
            histCat = ETAS_Simulator.getFilteredHistCatalog(ETAS_Simulator.getTimeInMillisFromYear(2012.0), erf, completeness);
            MiscInfoAndPlotsCalc.plotFilteredCatalogMagFreqDist(histCat, completeness, mfd, "FilteredCatalogMFD");
        }
        catch (IOException | DocumentException e) {
            e.printStackTrace();
        }
    }

    public RuptureSurface getRuptureSurfaceWithNoCreepReduction(int fssRupIndex, FaultSystemSolutionERF erf, double gridSpacing) {
        ArrayList rupSurfs = Lists.newArrayList();
        for (FaultSection fltData : erf.getSolution().getRupSet().getFaultSectionDataForRupture(fssRupIndex)) {
            RuptureSurface subSurf;
            if (gridSpacing < 0.5) {
                RuptureSurface lowRes = fltData.getFaultSurface(0.5, false, false);
                if (lowRes instanceof EvenlyGriddedSurface) {
                    EvenlyGriddedSurface gridLowRes = (EvenlyGriddedSurface)lowRes;
                    if (lowRes.getAveGridSpacing() <= gridSpacing) {
                        subSurf = lowRes;
                    } else {
                        double targetRowSpacing;
                        double targetColSpacing;
                        for (targetColSpacing = gridLowRes.getGridSpacingAlongStrike(); targetColSpacing > gridSpacing; targetColSpacing *= 0.5) {
                        }
                        for (targetRowSpacing = gridLowRes.getGridSpacingDownDip(); targetRowSpacing > gridSpacing; targetRowSpacing *= 0.5) {
                        }
                        subSurf = new InterpolatedEvenlyGriddedSurface(gridLowRes, targetRowSpacing, targetColSpacing);
                    }
                } else {
                    subSurf = fltData.getFaultSurface(gridSpacing, false, false);
                }
            } else {
                subSurf = fltData.getFaultSurface(gridSpacing, false, false);
            }
            rupSurfs.add(subSurf);
        }
        if (rupSurfs.size() == 1) {
            return (RuptureSurface)rupSurfs.get(0);
        }
        return new CompoundSurface(rupSurfs);
    }

    public Location getRandomLocationOnRupSurface(ETAS_EqkRupture parRup) {
        if (parRup.getRuptureSurface().isPointSurface()) {
            Location hypoLoc = parRup.getRuptureSurface().getFirstLocOnUpperEdge();
            if (parRup.getMag() <= 4.0) {
                return hypoLoc;
            }
            double radius = ETAS_Utils.getRuptureRadiusFromMag(parRup.getMag());
            double testRadius = radius + 1.0;
            Location loc = null;
            int count = 0;
            double minDist = Double.POSITIVE_INFINITY;
            if (hypoLoc.getDepth() > 24.0 || hypoLoc.getDepth() < 0.0) {
                System.err.println("WARNING: Temporary fix for bad input hypo depth.\nParent rup: " + ETAS_CatalogIO.getEventFileLine(parRup));
                hypoLoc = hypoLoc.getDepth() > 24.0 ? new Location(hypoLoc.getLatitude(), hypoLoc.getLongitude(), 24.0) : new Location(hypoLoc.getLatitude(), hypoLoc.getLongitude(), 0.0);
            }
            while (testRadius > radius) {
                double depthTop;
                double lat = hypoLoc.getLatitude() + (2.0 * this.getRandomDouble() - 1.0) * (radius / 111.0);
                double lon = hypoLoc.getLongitude() + (2.0 * this.getRandomDouble() - 1.0) * (radius / (111.0 * Math.cos(hypoLoc.getLatRad())));
                double depthBottom = hypoLoc.getDepth() + radius;
                if (depthBottom > 24.0) {
                    depthBottom = 24.0;
                }
                if ((depthTop = hypoLoc.getDepth() - radius) < 0.0) {
                    depthTop = 0.0;
                }
                double depth = depthTop + this.getRandomDouble() * (depthBottom - depthTop);
                loc = new Location(lat, lon, depth);
                testRadius = LocationUtils.linearDistanceFast(loc, hypoLoc);
                minDist = Math.min(minDist, testRadius);
                if (++count != 1000000) continue;
                String debug = "Stuck in loop, quitting after " + count + " tries.\nHypo loc: " + String.valueOf(hypoLoc) + "\nCur loc: " + String.valueOf(loc) + "\nRadius: " + radius + "\nCur dist: " + testRadius + "\nClosest so far: " + minDist;
                debug = debug + "\ndepthTop=" + depthTop + ", depthBottom=" + depthBottom;
                debug = debug + "\nParent rup: " + ETAS_CatalogIO.getEventFileLine(parRup);
                throw new IllegalStateException(debug);
            }
            return loc;
        }
        RuptureSurface surf = parRup.getRuptureSurface();
        int index = this.getRandomInt(surf.getEvenlyDiscretizedNumLocs() - 1);
        return surf.getEvenlyDiscretizedLocation(index);
    }

    public static double getRuptureAreaFromMag(double mag) {
        return Math.pow(10.0, mag - 4.0);
    }

    public static double getRuptureRadiusFromMag(double mag) {
        return Math.sqrt(ETAS_Utils.getRuptureAreaFromMag(mag) / Math.PI);
    }

    public static double getScalingFactorToImposeGR_numPrimary(IncrementalMagFreqDist supraSeisMFD, IncrementalMagFreqDist subSeisMFD, boolean debug) {
        if (supraSeisMFD.getMaxY() == 0.0 || subSeisMFD.getMaxY() == 0.0) {
            return 1.0;
        }
        double minMag = subSeisMFD.getMinMagWithNonZeroRate();
        double maxMagWithNonZeroRate = supraSeisMFD.getMaxMagWithNonZeroRate();
        if (Double.isNaN(maxMagWithNonZeroRate)) {
            System.out.println("ISSUE: maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            return 1.0;
        }
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / supraSeisMFD.getDelta()) + 1;
        Preconditions.checkState((numMag > 1 || minMag == maxMagWithNonZeroRate ? 1 : 0) != 0, (Object)("only have 1 bin but min != max: " + minMag + " != " + maxMagWithNonZeroRate + "\n" + String.valueOf(supraSeisMFD)));
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToIncrRate(minMag, subSeisMFD.getY(minMag));
        double expNumGR = 0.0;
        for (int i = 0; i < gr.size(); ++i) {
            double mag = gr.getX(i);
            expNumGR += gr.getY(i) * Math.pow(10.0, mag);
        }
        double expNumSubSeis = 0.0;
        for (int i = 0; i < subSeisMFD.size(); ++i) {
            double mag = subSeisMFD.getX(i);
            expNumSubSeis += subSeisMFD.getY(i) * Math.pow(10.0, mag);
        }
        double expNumSupraSeis = 0.0;
        for (int i = 0; i < supraSeisMFD.size(); ++i) {
            double mag = supraSeisMFD.getX(i);
            expNumSupraSeis += supraSeisMFD.getY(i) * Math.pow(10.0, mag);
        }
        double result = (expNumGR - expNumSubSeis) / expNumSupraSeis;
        if (debug) {
            ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
            funcs.add(supraSeisMFD);
            funcs.add(subSeisMFD);
            funcs.add(gr);
            GraphWindow graph = new GraphWindow(funcs, "getScalingFactorToImposeGR " + result);
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Incr Rate");
            System.out.println("result=" + (expNumGR - expNumSubSeis) / expNumSupraSeis);
            System.out.println("minMag=" + minMag + "\nmaxMagWithNonZeroRate=" + maxMagWithNonZeroRate + "\nexpNumGR=" + expNumGR + "\nexpNumSubSeis=" + expNumSubSeis + "\nexpNumSupraSeis=" + expNumSupraSeis);
        }
        return result;
    }

    public static double getMinMagSupra(IncrementalMagFreqDist supraSeisMFD, IncrementalMagFreqDist subSeisMFD) {
        double minMagSupra;
        if (supraSeisMFD.getMaxY() == 0.0 || subSeisMFD.getMaxY() == 0.0) {
            return Double.NaN;
        }
        double minMag = subSeisMFD.getMinMagWithNonZeroRate();
        double minMagSupraAlt1 = supraSeisMFD.getMinMagWithNonZeroRate();
        if (minMagSupraAlt1 > subSeisMFD.getMaxMagWithNonZeroRate()) {
            minMagSupra = minMagSupraAlt1;
        } else {
            double thresh = 0.9;
            minMagSupra = subSeisMFD.getMaxMagWithNonZeroRate();
            int indexForMinMagSupra = subSeisMFD.getXIndex(minMagSupra);
            double testVal = subSeisMFD.getY(indexForMinMagSupra) / (subSeisMFD.getY(minMag) * Math.pow(10.0, minMag - minMagSupra));
            while (testVal < thresh && indexForMinMagSupra > 0) {
                minMagSupra = subSeisMFD.getX(--indexForMinMagSupra);
                testVal = subSeisMFD.getY(indexForMinMagSupra) / (subSeisMFD.getY(minMag) * Math.pow(10.0, minMag - minMagSupra));
            }
            if (indexForMinMagSupra == 0) {
                throw new RuntimeException("Problem");
            }
            minMagSupra = subSeisMFD.getX(++indexForMinMagSupra);
        }
        if (minMagSupra < minMagSupraAlt1) {
            minMagSupra = minMagSupraAlt1;
        }
        if (minMagSupra > supraSeisMFD.getMaxMagWithNonZeroRate()) {
            minMagSupra = supraSeisMFD.getMaxMagWithNonZeroRate();
        }
        return minMagSupra;
    }

    public static double getScalingFactorToImposeGR_supraRates(IncrementalMagFreqDist supraSeisMFD, IncrementalMagFreqDist subSeisMFD, boolean debug) {
        if (supraSeisMFD.getMaxY() == 0.0 || subSeisMFD.getMaxY() == 0.0) {
            return 1.0;
        }
        double minMag = subSeisMFD.getMinMagWithNonZeroRate();
        double minMagSupra = ETAS_Utils.getMinMagSupra(supraSeisMFD, subSeisMFD);
        double maxMagWithNonZeroRate = supraSeisMFD.getMaxMagWithNonZeroRate();
        if (Double.isNaN(maxMagWithNonZeroRate)) {
            System.out.println("ISSUE: maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            return 1.0;
        }
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / supraSeisMFD.getDelta()) + 1;
        Preconditions.checkState((numMag > 1 || minMag == maxMagWithNonZeroRate ? 1 : 0) != 0, (Object)("only have 1 bin but min != max: " + minMag + " != " + maxMagWithNonZeroRate + "\n" + String.valueOf(supraSeisMFD)));
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToIncrRate(minMag, subSeisMFD.getY(minMag));
        double result = Double.NaN;
        try {
            result = gr.getCumRate(minMagSupra) / supraSeisMFD.getCumRate(minMagSupra);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: " + minMagSupra + "\t" + supraSeisMFD.getName());
            System.out.println(supraSeisMFD);
            System.exit(0);
        }
        if (debug) {
            supraSeisMFD.setName("supraSeisMFD");
            supraSeisMFD.setInfo("minMagSupra=" + minMagSupra + "\nminMag=" + minMag);
            subSeisMFD.setName("subSeisMFD");
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            funcs.add(supraSeisMFD);
            funcs.add(subSeisMFD);
            funcs.add(gr);
            EvenlyDiscretizedFunc cumGR = gr.getCumRateDistWithOffset();
            cumGR.setName("cumGR");
            funcs.add(cumGR);
            EvenlyDiscretizedFunc cumSupraSeisMFD = supraSeisMFD.getCumRateDistWithOffset();
            cumSupraSeisMFD.setName("cumSupraSeisMFD");
            funcs.add(cumSupraSeisMFD);
            EvenlyDiscretizedFunc cumSupraSeisMFD_scaled = cumSupraSeisMFD.deepClone();
            cumSupraSeisMFD_scaled.scale(result);
            cumSupraSeisMFD_scaled.setName("cumSupraSeisMFD_scaled");
            funcs.add(cumSupraSeisMFD_scaled);
            GraphWindow graph = new GraphWindow(funcs, "getScalingFactorToImposeGR_supraRates " + result);
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Incr Rate");
            graph.setYLog(true);
            System.out.println("minMag=" + minMag + " ;minMagSupra=" + minMagSupra + "; maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            System.out.println("result=" + result);
        }
        return result;
    }

    public static double getScalingFactorToImposeGR_supraRatesAboveMag(IncrementalMagFreqDist supraSeisMFD, IncrementalMagFreqDist subSeisMFD, double magThresh, boolean debug) {
        if (supraSeisMFD.getMaxY() == 0.0 || subSeisMFD.getMaxY() == 0.0) {
            return 1.0;
        }
        double minMag = subSeisMFD.getMinMagWithNonZeroRate();
        double maxMagWithNonZeroRate = supraSeisMFD.getMaxMagWithNonZeroRate();
        if (Double.isNaN(maxMagWithNonZeroRate)) {
            System.out.println("ISSUE: maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            return 1.0;
        }
        if (maxMagWithNonZeroRate < magThresh) {
            System.out.println("ISSUE: maxMagWithNonZeroRate<magThresh; " + maxMagWithNonZeroRate);
            return 1.0;
        }
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / supraSeisMFD.getDelta()) + 1;
        Preconditions.checkState((numMag > 1 || minMag == maxMagWithNonZeroRate ? 1 : 0) != 0, (Object)("only have 1 bin but min != max: " + minMag + " != " + maxMagWithNonZeroRate + "\n" + String.valueOf(supraSeisMFD)));
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToIncrRate(minMag, subSeisMFD.getY(minMag));
        double result = Double.NaN;
        try {
            result = gr.getCumRate(magThresh) / supraSeisMFD.getCumRate(magThresh);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: " + magThresh + "\t" + supraSeisMFD.getName());
            System.out.println(supraSeisMFD);
            System.exit(0);
        }
        if (debug) {
            supraSeisMFD.setName("supraSeisMFD");
            supraSeisMFD.setInfo("magThresh=" + magThresh + "\nminMag=" + minMag);
            subSeisMFD.setName("subSeisMFD");
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            funcs.add(supraSeisMFD);
            funcs.add(subSeisMFD);
            funcs.add(gr);
            EvenlyDiscretizedFunc cumGR = gr.getCumRateDistWithOffset();
            cumGR.setName("cumGR");
            funcs.add(cumGR);
            EvenlyDiscretizedFunc cumSupraSeisMFD = supraSeisMFD.getCumRateDistWithOffset();
            cumSupraSeisMFD.setName("cumSupraSeisMFD");
            funcs.add(cumSupraSeisMFD);
            EvenlyDiscretizedFunc cumSupraSeisMFD_scaled = cumSupraSeisMFD.deepClone();
            cumSupraSeisMFD_scaled.scale(result);
            cumSupraSeisMFD_scaled.setName("cumSupraSeisMFD_scaled");
            funcs.add(cumSupraSeisMFD_scaled);
            GraphWindow graph = new GraphWindow(funcs, "getScalingFactorToImposeGR_supraRates " + result);
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Incr Rate");
            graph.setYLog(true);
            System.out.println("minMag=" + minMag + " ;magThresh=" + magThresh + "; maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            System.out.println("result=" + result);
        }
        return result;
    }

    public static double[] getFractSubseisTriggeredBySupra(FaultSystemSolutionERF fssERF, ETAS_ParameterList etasParams) {
        double maxDays = 3652.5;
        ImmutableList<IncrementalMagFreqDist> subSeisMFD_list = fssERF.getSolution().requireModule(SubSeismoOnFaultMFDs.class).getAll();
        double duration = fssERF.getTimeSpan().getDuration();
        double[] sectionArea = new double[subSeisMFD_list.size()];
        for (int s = 0; s < subSeisMFD_list.size(); ++s) {
            FaultSection sectData = fssERF.getSolution().getRupSet().getFaultSectionData(s);
            sectionArea[s] = sectData.getTraceLength() * sectData.getReducedDownDipWidth();
        }
        double[] resultArray = new double[subSeisMFD_list.size()];
        double[] primaryFromSupraArray = new double[subSeisMFD_list.size()];
        double[] sectPartArray = new double[subSeisMFD_list.size()];
        double[] sectNuclArray = new double[subSeisMFD_list.size()];
        for (int s = 0; s < fssERF.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = fssERF.getFltSysRupIndexForSource(s);
            List<Integer> sectionList = fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssRupIndex);
            double rupArea = 0.0;
            Iterator<Serializable> iterator = sectionList.iterator();
            while (iterator.hasNext()) {
                int sectID = iterator.next();
                rupArea += sectionArea[sectID];
            }
            for (ProbEqkRupture rup : fssERF.getSource(s)) {
                double rate = rup.getMeanAnnualRate(duration);
                double numAft = ETAS_Utils.getExpectedNumEvents(etasParams.get_k(), etasParams.get_p(), rup.getMag(), 2.5, etasParams.get_c(), 0.0, maxDays);
                Iterator<Integer> iterator2 = sectionList.iterator();
                while (iterator2.hasNext()) {
                    int sectID;
                    int n = sectID = iterator2.next().intValue();
                    primaryFromSupraArray[n] = primaryFromSupraArray[n] + rate * numAft * sectionArea[sectID] / rupArea;
                    int n2 = sectID;
                    sectPartArray[n2] = sectPartArray[n2] + rate;
                    int n3 = sectID;
                    sectNuclArray[n3] = sectNuclArray[n3] + rate * sectionArea[sectID] / rupArea;
                }
            }
        }
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = FaultSysSolutionERF_Calc.calcNucleationMFDForAllSects(fssERF, 2.55, 8.95, 65);
        System.out.println("sectID\tratePrimaryFromSupraArray\tfractSubseisFromSupra\tsectPartArray\tsectNuclArray\tpartOverNuclRatio\tname");
        for (int sectID = 0; sectID < resultArray.length; ++sectID) {
            resultArray[sectID] = subSeisMFD_list.get(sectID) != null ? primaryFromSupraArray[sectID] / ((IncrementalMagFreqDist)subSeisMFD_list.get(sectID)).getCumRate(2.55) : 1.0;
            double minSupraMag = ETAS_Utils.getMinMagSupra(longTermSupraSeisMFD_OnSectArray[sectID], (IncrementalMagFreqDist)subSeisMFD_list.get(sectID));
            double impliedCharFactor = sectNuclArray[sectID] / (primaryFromSupraArray[sectID] * Math.pow(10.0, 2.5 - minSupraMag));
            System.out.println(sectID + "\t" + primaryFromSupraArray[sectID] + "\t" + resultArray[sectID] + "\t" + sectPartArray[sectID] + "\t" + sectNuclArray[sectID] + "\t" + sectPartArray[sectID] / sectNuclArray[sectID] + "\t" + impliedCharFactor + "\t" + fssERF.getSolution().getRupSet().getFaultSectionData(sectID).getName());
        }
        return resultArray;
    }

    public static void plotFractionSubseisTriggeredBySupra(File resultsDir, String nameSuffix, boolean display, FaultSystemSolutionERF fssERF, ETAS_ParameterList etasParams) throws GMT_MapException, RuntimeException, IOException {
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        List<? extends FaultSection> faults = fssERF.getSolution().getRupSet().getFaultSectionDataList();
        double[] values = ETAS_Utils.getFractSubseisTriggeredBySupra(fssERF, etasParams);
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.log10(values[i]);
        }
        String name = "FractionSubseisTriggeredBySupra_" + nameSuffix;
        String title = "Log10(FractionSubseisTriggeredBySupra)";
        CPT cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, fssERF.getGridSourceProvider().getGriddedRegion(), resultsDir, name, display, false, title);
    }

    public static double getScalingFactorToImposeGR_MoRates(IncrementalMagFreqDist supraSeisMFD, IncrementalMagFreqDist subSeisMFD, boolean debug) {
        if (supraSeisMFD.getMaxY() == 0.0 || subSeisMFD.getMaxY() == 0.0) {
            return 1.0;
        }
        double minMag = subSeisMFD.getMinMagWithNonZeroRate();
        double minMagSupra = ETAS_Utils.getMinMagSupra(supraSeisMFD, subSeisMFD);
        double maxMagWithNonZeroRate = supraSeisMFD.getMaxMagWithNonZeroRate();
        if (Double.isNaN(maxMagWithNonZeroRate)) {
            System.out.println("ISSUE: maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            return 1.0;
        }
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / supraSeisMFD.getDelta()) + 1;
        Preconditions.checkState((numMag > 1 || minMag == maxMagWithNonZeroRate ? 1 : 0) != 0, (Object)("only have 1 bin but min != max: " + minMag + " != " + maxMagWithNonZeroRate + "\n" + String.valueOf(supraSeisMFD)));
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToTotalMomentRate(supraSeisMFD.getTotalMomentRate() + subSeisMFD.getTotalMomentRate());
        double result = Double.NaN;
        try {
            result = subSeisMFD.getCumRate(minMag) / gr.getCumRate(minMag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            supraSeisMFD.setName("supraSeisMFD");
            supraSeisMFD.setInfo("minMagSupra=" + minMagSupra + "\nminMag=" + minMag);
            subSeisMFD.setName("subSeisMFD");
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            funcs.add(supraSeisMFD);
            funcs.add(subSeisMFD);
            funcs.add(gr);
            EvenlyDiscretizedFunc cumGR = gr.getCumRateDistWithOffset();
            cumGR.setName("cumGR");
            funcs.add(cumGR);
            EvenlyDiscretizedFunc cumSupraSeisMFD = supraSeisMFD.getCumRateDistWithOffset();
            cumSupraSeisMFD.setName("cumSupraSeisMFD");
            funcs.add(cumSupraSeisMFD);
            EvenlyDiscretizedFunc cumSupraSeisMFD_scaled = cumSupraSeisMFD.deepClone();
            cumSupraSeisMFD_scaled.scale(result);
            cumSupraSeisMFD_scaled.setName("cumSupraSeisMFD_scaled");
            funcs.add(cumSupraSeisMFD_scaled);
            GraphWindow graph = new GraphWindow(funcs, "getScalingFactorToImposeGR_supraRates " + result);
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Incr Rate");
            graph.setYLog(true);
            System.out.println("minMag=" + minMag + " ;minMagSupra=" + minMagSupra + "; maxMagWithNonZeroRate=" + maxMagWithNonZeroRate);
            System.out.println("result=" + result);
        }
        return result;
    }

    public static void plotExpectedNumPrimaryVsTime() {
        double magMin = 2.5;
        double log_tMin = -4.0;
        double log_tMax = 10.0;
        double log_tDelta = 0.01;
        double magMain = 7.8;
        double c = 0.00650145;
        double k = 0.00284 * Math.pow(365.25, 0.07);
        double p = 1.07;
        HistogramFunction jeanneDefaultNumPerBin = ETAS_Utils.getNumWithLogTimeFunc(k, p, magMain, magMin, c, log_tMin, log_tMax, log_tDelta);
        double totNum = jeanneDefaultNumPerBin.calcSumOfY_Vals();
        HistogramFunction jeanneDefaultNumOccurred = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        double sum = 0.0;
        for (int i = 0; i < jeanneDefaultNumPerBin.size(); ++i) {
            jeanneDefaultNumOccurred.set(i, sum += jeanneDefaultNumPerBin.getY(i));
        }
        HistogramFunction jeanneDefaultNumRemaining = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        sum = 0.0;
        for (int i = jeanneDefaultNumPerBin.size() - 1; i >= 0; --i) {
            jeanneDefaultNumRemaining.set(i, sum += jeanneDefaultNumPerBin.getY(i));
        }
        jeanneDefaultNumRemaining.setName("Num Remaining to occur for Jeanne's Table S2 Params");
        jeanneDefaultNumRemaining.setInfo("c=" + (float)c + "\tk=" + (float)k + "\tp=" + (float)p + "\nTotal Num = " + (float)totNum + "\nTest Num = " + (float)ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, 0.0, Math.pow(10.0, log_tMax)));
        jeanneDefaultNumOccurred.setName("Num that have occurred for Jeanne's Table S2 Params");
        jeanneDefaultNumOccurred.setInfo("");
        jeanneDefaultNumPerBin.setName("Num per bin for Jeanne's Table S2 Params");
        jeanneDefaultNumPerBin.setInfo("");
        c = 0.007305000000000001;
        k = 0.00269 * Math.pow(365.25, 0.08);
        p = 1.08;
        HistogramFunction jeanneAltNumPerBin = ETAS_Utils.getNumWithLogTimeFunc(k, p, magMain, magMin, c, log_tMin, log_tMax, log_tDelta);
        totNum = jeanneAltNumPerBin.calcSumOfY_Vals();
        HistogramFunction jeanneAltNumOccurred = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        sum = 0.0;
        for (int i = 0; i < jeanneAltNumPerBin.size(); ++i) {
            jeanneAltNumOccurred.set(i, sum += jeanneAltNumPerBin.getY(i));
        }
        HistogramFunction jeanneAltNumRemaining = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        sum = 0.0;
        for (int i = jeanneAltNumPerBin.size() - 1; i >= 0; --i) {
            jeanneAltNumRemaining.set(i, sum += jeanneAltNumPerBin.getY(i));
        }
        jeanneAltNumRemaining.setName("Num Remaining to occur for Jeanne's Alt Params");
        jeanneAltNumRemaining.setInfo("c=" + (float)c + "\tk=" + (float)k + "\tp=" + (float)p + "\nTotal Num = " + (float)totNum + "\nTest Num = " + (float)ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, 0.0, Math.pow(10.0, log_tMax)));
        jeanneAltNumOccurred.setName("Num that have occurred for Jeanne's Alt Params");
        jeanneAltNumOccurred.setInfo("");
        jeanneAltNumPerBin.setName("Num per bin for Jeanne's Alt Params");
        jeanneAltNumPerBin.setInfo("");
        c = 0.095;
        k = 0.008;
        p = 1.34;
        HistogramFunction karenParamsNumPerBin = ETAS_Utils.getNumWithLogTimeFunc(k, p, magMain, magMin, c, log_tMin, log_tMax, log_tDelta);
        totNum = karenParamsNumPerBin.calcSumOfY_Vals();
        HistogramFunction karenParamsNumOccurred = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        sum = 0.0;
        for (int i = 0; i < karenParamsNumPerBin.size(); ++i) {
            karenParamsNumOccurred.set(i, sum += karenParamsNumPerBin.getY(i));
        }
        HistogramFunction karenParamsNumRemaining = new HistogramFunction(log_tMin + log_tDelta / 2.0, log_tMax - log_tDelta / 2.0, (int)Math.round((log_tMax - log_tMin) / log_tDelta));
        sum = 0.0;
        for (int i = karenParamsNumPerBin.size() - 1; i >= 0; --i) {
            karenParamsNumRemaining.set(i, sum += karenParamsNumPerBin.getY(i));
        }
        karenParamsNumRemaining.setName("Num Remaining to occur for Karen's Params");
        karenParamsNumRemaining.setInfo("c=" + (float)c + "\tk=" + (float)k + "\tp=" + (float)p + "\nTotal Num = " + (float)totNum + "\nTest Num = " + (float)ETAS_Utils.getExpectedNumEvents(k, p, magMain, magMin, c, 0.0, Math.pow(10.0, log_tMax)));
        karenParamsNumOccurred.setName("Num that have occurred for Karen's Params");
        karenParamsNumOccurred.setInfo("");
        karenParamsNumPerBin.setName("Num per bin for Karen's Params");
        karenParamsNumPerBin.setInfo("");
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(jeanneDefaultNumRemaining);
        funcList.add(jeanneAltNumRemaining);
        funcList.add(karenParamsNumRemaining);
        funcList.add(jeanneDefaultNumOccurred);
        funcList.add(jeanneAltNumOccurred);
        funcList.add(karenParamsNumOccurred);
        funcList.add(jeanneDefaultNumPerBin);
        funcList.add(jeanneAltNumPerBin);
        funcList.add(karenParamsNumPerBin);
        ArrayList<PlotCurveCharacterstics> curveCharList = new ArrayList<PlotCurveCharacterstics>();
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GREEN));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.BLACK));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.BLUE));
        curveCharList.add(new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.GREEN));
        GraphWindow numVsTimeGraph = new GraphWindow(funcList, "Num Primay With Time for M = " + magMain, curveCharList);
        numVsTimeGraph.setX_AxisLabel("Log10 Days");
        numVsTimeGraph.setY_AxisLabel("Num Per Bin, Yet To Occur, or Have Occurred");
        numVsTimeGraph.setX_AxisRange(-4.0, 7.0);
        numVsTimeGraph.setYLog(true);
        numVsTimeGraph.setPlotLabelFontSize(18);
        numVsTimeGraph.setAxisLabelFontSize(16);
        numVsTimeGraph.setTickLabelFontSize(14);
        String pathName = new File("numPrimaryEventsVsTime_M7pt8.pdf").getAbsolutePath();
        try {
            numVsTimeGraph.saveAsPDF(pathName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void runMagTimeCatalogSimulation() {
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        String simulationName = "MagTimeCatalogSimulation_1000yrs_100_NoHistCat_U3MFD";
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, 1.0, false);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        SummedMagFreqDist mfd = ERF_Calculator.getTotalMFD_ForERF(erf, 2.55, 8.45, 60, true);
        SummedMagFreqDist mfd_lowCF = new SummedMagFreqDist(2.55, 8.45, 60);
        SummedMagFreqDist mfd_highCF = new SummedMagFreqDist(2.55, 8.45, 60);
        double scaleFactor = 0.35;
        double magThresh = 6.3;
        for (int i = 0; i < mfd.size(); ++i) {
            if (mfd.getX(i) < magThresh) {
                mfd_lowCF.add(i, mfd.getY(i) * (1.0 - scaleFactor));
                mfd_highCF.add(i, mfd.getY(i) * scaleFactor);
                continue;
            }
            mfd_lowCF.add(i, mfd.getY(i) * scaleFactor);
            mfd_highCF.add(i, mfd.getY(i) * (1.0 - scaleFactor));
        }
        SummedMagFreqDist trulyOffMFD = new SummedMagFreqDist(2.55, 8.45, 60);
        MFDGridSourceProvider gridProvider = erf.getSolution().requireModule(MFDGridSourceProvider.class);
        for (int n = 0; n < gridProvider.getNumLocations(); ++n) {
            ProbEqkSource src = gridProvider.getSourceUnassociated(n, 1.0, null, FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS);
            if (src == null) continue;
            for (ProbEqkRupture rup : src) {
                trulyOffMFD.add(rup.getMag(), rup.getMeanAnnualRate(1.0));
            }
        }
        System.out.println(trulyOffMFD);
        double startTimeYear = 2012.0;
        double durationYears = 1000.0;
        double numYearsBinWidth = 25.0;
        System.out.println("mfd BR = " + ETAS_Utils.getBranchingRatio(mfd, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), 365.25 * durationYears));
        System.out.println("mfd_lowCF BR = " + ETAS_Utils.getBranchingRatio(mfd_lowCF, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), 365.25 * durationYears));
        System.out.println("mfd_highCF BR = " + ETAS_Utils.getBranchingRatio(mfd_highCF, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), 365.25 * durationYears));
        System.out.println("trulyOffMFD BR = " + ETAS_Utils.getBranchingRatio(trulyOffMFD, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c(), 365.25 * durationYears));
        int numCatalogs = 100;
        List<? extends ObsEqkRupture> histCat = null;
        try {
            mfd.scaleToCumRate(2.55, trulyOffMFD.getCumRate(2.55));
            ETAS_Utils.magTimeCatalogSimulation(new File(simulationName + "_trulyOffMFD"), trulyOffMFD, histCat, simulationName, etasParams, startTimeYear, durationYears, numCatalogs, numYearsBinWidth, mfd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void magTimeCatalogSimulation(File resultsDir, IncrementalMagFreqDist mfd, List<? extends ObsEqkRupture> histQkList, String simulationName, ETAS_ParameterList etasParams, double startYear, double numYears, int numCatalogs, double binWidthYears, IncrementalMagFreqDist mfdForSpontEvents) throws IOException {
        boolean D = false;
        ETAS_Utils etas_utils = new ETAS_Utils(System.currentTimeMillis());
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        FileWriter info_fr = new FileWriter(new File(resultsDir, "infoString.txt"));
        info_fr.write(simulationName + "\n");
        if (histQkList == null) {
            info_fr.write("\nhistQkList.size()=null\n");
        } else {
            info_fr.write("\nnumCatalogs=" + numCatalogs + "\n");
        }
        info_fr.write("\nETAS Paramteres:\n\n");
        info_fr.write("\nETAS Paramteres:\n\n");
        if (D) {
            System.out.println("\nETAS Paramteres:\n\n");
        }
        for (Parameter<?> param : etasParams) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
            if (!D) continue;
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
        }
        info_fr.flush();
        ArrayList<ETAS_EqkRupture> obsEqkRuptureList = new ArrayList<ETAS_EqkRupture>();
        if (histQkList != null) {
            int id = 0;
            for (ObsEqkRupture obsEqkRupture : histQkList) {
                ETAS_EqkRupture etasRup = new ETAS_EqkRupture(obsEqkRupture);
                etasRup.setID(id);
                obsEqkRuptureList.add(etasRup);
                ++id;
            }
            if (D) {
                System.out.println("histQkList.size()=" + histQkList.size());
                System.out.println("obsEqkRuptureList.size()=" + obsEqkRuptureList.size());
            }
        }
        long simStartTimeMillis = (long)((startYear - 1970.0) * 3.15576E10);
        long l = (long)((startYear + numYears - 1970.0) * 3.15576E10);
        IntegerPDF_FunctionSampler mfdMagIndexSampler = new IntegerPDF_FunctionSampler(mfd.size());
        for (int i = 0; i < mfd.size(); ++i) {
            mfdMagIndexSampler.set(i, mfd.getY(i));
        }
        int numBins = (int)Math.round(numYears / binWidthYears);
        HistogramFunction[] histOfAveNumVsTimeArray = null;
        if (!Double.isNaN(binWidthYears)) {
            histOfAveNumVsTimeArray = new HistogramFunction[numCatalogs];
        }
        ArbIncrementalMagFreqDist allEventsMagProbDist = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        ArbIncrementalMagFreqDist spontaneousMagProbDist = new ArbIncrementalMagFreqDist(2.05, 8.95, 70);
        CalcProgressBar progressBar = null;
        try {
            progressBar = new CalcProgressBar("Num simulations to process ", "junk");
            progressBar.showProgress(true);
        }
        catch (Throwable t) {
            progressBar = null;
        }
        for (int catIndex = 0; catIndex < numCatalogs; ++catIndex) {
            if (progressBar != null) {
                progressBar.updateProgress(catIndex, numCatalogs);
            }
            if (histOfAveNumVsTimeArray != null) {
                histOfAveNumVsTimeArray[catIndex] = new HistogramFunction(binWidthYears / 2.0, numYears - binWidthYears / 2.0, numBins);
            }
            System.gc();
            ObsEqkRupOrigTimeComparator oigTimeComparator = new ObsEqkRupOrigTimeComparator();
            PriorityQueue<ObsEqkRupture> simulatedRupsQueue = new PriorityQueue<ObsEqkRupture>(1000, oigTimeComparator);
            if (D) {
                System.out.println("Making primary aftershocks from input obsEqkRuptureList, size = " + obsEqkRuptureList.size());
            }
            PriorityQueue<ObsEqkRupture> eventsToProcess = new PriorityQueue<ObsEqkRupture>(1000, oigTimeComparator);
            int testParID = 0;
            int eventID = obsEqkRuptureList.size();
            for (ETAS_EqkRupture parRup : obsEqkRuptureList) {
                int parID = parRup.getID();
                if (parID != testParID) {
                    throw new RuntimeException("problem with ID");
                }
                long rupOT = parRup.getOriginTime();
                double startDay = (double)(simStartTimeMillis - rupOT) / 8.64E7;
                double endDay = (double)(l - rupOT) / 8.64E7;
                double[] randomAftShockTimes = etas_utils.getRandomEventTimes(etasParams.get_k(), etasParams.get_p(), parRup.getMag(), 2.5, etasParams.get_c(), startDay, endDay);
                if (randomAftShockTimes.length > 0) {
                    for (int i = 0; i < randomAftShockTimes.length; ++i) {
                        long ot = rupOT + (long)(randomAftShockTimes[i] * 8.64E7);
                        ETAS_EqkRupture newRup = new ETAS_EqkRupture(parRup, eventID, ot);
                        newRup.setParentID(parID);
                        newRup.setGeneration(1);
                        eventsToProcess.add(newRup);
                        ++eventID;
                    }
                }
                ++testParID;
            }
            if (D) {
                System.out.println("The " + obsEqkRuptureList.size() + " input events produced " + eventsToProcess.size() + " primary aftershocks");
            }
            info_fr.write("\nThe " + obsEqkRuptureList.size() + " input observed events produced " + eventsToProcess.size() + " primary aftershocks\n");
            info_fr.flush();
            if (D) {
                System.out.println("Making spontaneous events and times of primary aftershocks...");
            }
            ETAS_Utils etasUtils = new ETAS_Utils();
            long histCatStartTime = simStartTimeMillis;
            long[] spontEventTimes = histQkList == null ? etasUtils.getRandomSpontanousEventTimes(mfdForSpontEvents, histCatStartTime, simStartTimeMillis, l, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c()) : etasUtils.getRandomSpontanousEventTimes(mfdForSpontEvents, etasParams.getStatewideCompletenessModel().getEvenlyDiscretizedMagYearFunc(), simStartTimeMillis, l, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c());
            for (int r = 0; r < spontEventTimes.length; ++r) {
                ETAS_EqkRupture rup = new ETAS_EqkRupture();
                rup.setOriginTime(spontEventTimes[r]);
                rup.setID(eventID);
                rup.setGeneration(0);
                eventsToProcess.add(rup);
                ++eventID;
            }
            if (D) {
                System.out.println("Looping over eventsToProcess (initial num = " + eventsToProcess.size() + ")...\n");
            }
            long st = System.currentTimeMillis();
            int numSimulatedEvents = 0;
            info_fr.flush();
            CalcProgressBar progressBar2 = null;
            try {
                progressBar2 = new CalcProgressBar("Num events to process ", "junk");
                progressBar2.showProgress(true);
            }
            catch (Throwable t) {
                progressBar2 = null;
            }
            while (eventsToProcess.size() > 0) {
                progressBar2.updateProgress(simulatedRupsQueue.size(), simulatedRupsQueue.size() + eventsToProcess.size());
                ETAS_EqkRupture rup = (ETAS_EqkRupture)eventsToProcess.poll();
                double mag = mfd.getX(mfdMagIndexSampler.getRandomInt());
                rup.setMag(mag);
                double year = (double)(rup.getOriginTime() - simStartTimeMillis) / 3.15576E10;
                if (mag >= 5.0 && histOfAveNumVsTimeArray != null) {
                    histOfAveNumVsTimeArray[catIndex].add(year, 1.0);
                }
                allEventsMagProbDist.addResampledMagRate(mag, 1.0, true);
                if (rup.getGeneration() == 0) {
                    spontaneousMagProbDist.addResampledMagRate(mag, 1.0, true);
                }
                simulatedRupsQueue.add(rup);
                ++numSimulatedEvents;
                long rupOT = rup.getOriginTime();
                int parID = rup.getID();
                int gen = rup.getGeneration() + 1;
                double startDay = 0.0;
                double endDay = (double)(l - rupOT) / 8.64E7;
                double[] eventTimes = etas_utils.getRandomEventTimes(etasParams.get_k(), etasParams.get_p(), rup.getMag(), 2.5, etasParams.get_c(), startDay, endDay);
                if (eventTimes.length <= 0) continue;
                for (int i = 0; i < eventTimes.length; ++i) {
                    long ot = rupOT + (long)(eventTimes[i] * 8.64E7);
                    ETAS_EqkRupture newRup = new ETAS_EqkRupture(rup, eventID, ot);
                    newRup.setGeneration(gen);
                    newRup.setParentID(parID);
                    eventsToProcess.add(newRup);
                    ++eventID;
                }
            }
            if (D) {
                System.out.println("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n");
            }
            info_fr.write("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n\n");
            int[] numInEachGeneration = ETAS_SimAnalysisTools.getNumAftershocksForEachGeneration(simulatedRupsQueue, 10);
            String numInfo = "Total num ruptures: " + simulatedRupsQueue.size() + "\n";
            numInfo = numInfo + "Num spontaneous: " + numInEachGeneration[0] + "\n";
            numInfo = numInfo + "Num 1st Gen: " + numInEachGeneration[1] + "\n";
            numInfo = numInfo + "Num 2nd Gen: " + numInEachGeneration[2] + "\n";
            numInfo = numInfo + "Num 3rd Gen: " + numInEachGeneration[3] + "\n";
            numInfo = numInfo + "Num 4th Gen: " + numInEachGeneration[4] + "\n";
            numInfo = numInfo + "Num 5th Gen: " + numInEachGeneration[5] + "\n";
            numInfo = numInfo + "Num 6th Gen: " + numInEachGeneration[6] + "\n";
            numInfo = numInfo + "Num 7th Gen: " + numInEachGeneration[7] + "\n";
            numInfo = numInfo + "Num 8th Gen: " + numInEachGeneration[8] + "\n";
            numInfo = numInfo + "Num 9th Gen: " + numInEachGeneration[9] + "\n";
            numInfo = numInfo + "Num 10th Gen: " + numInEachGeneration[10] + "\n";
            if (D) {
                System.out.println(numInfo);
            }
            info_fr.write(numInfo + "\n");
            if (catIndex == 0) {
                ETAS_SimAnalysisTools.plotRateVsLogTimeForPrimaryAshocks(simulationName, new File(resultsDir, "logRateDecayPDF_ForAllPrimaryEvents.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
            }
            if (progressBar2 == null) continue;
            progressBar2.showProgress(false);
        }
        if (progressBar != null) {
            progressBar.showProgress(false);
        }
        info_fr.close();
        if (histOfAveNumVsTimeArray != null) {
            HistogramFunction meanAveNumVsTime = new HistogramFunction(binWidthYears / 2.0, numYears - binWidthYears / 2.0, numBins);
            HistogramFunction meanPlus2stdomAveNumVsTime = new HistogramFunction(binWidthYears / 2.0, numYears - binWidthYears / 2.0, numBins);
            HistogramFunction meanMinus2stdomAveNumVsTime = new HistogramFunction(binWidthYears / 2.0, numYears - binWidthYears / 2.0, numBins);
            for (int i = 0; i < meanAveNumVsTime.size(); ++i) {
                double[] vals = new double[numCatalogs];
                for (int c = 0; c < numCatalogs; ++c) {
                    vals[c] = histOfAveNumVsTimeArray[c].getY(i) / binWidthYears;
                }
                double mean = StatUtils.mean((double[])vals);
                double stdom = Math.sqrt(StatUtils.variance((double[])vals) / (double)numCatalogs);
                meanAveNumVsTime.set(i, mean);
                meanPlus2stdomAveNumVsTime.set(i, mean + 2.0 * stdom);
                meanMinus2stdomAveNumVsTime.set(i, mean - 2.0 * stdom);
            }
            ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
            funcList.add(meanAveNumVsTime);
            funcList.add(meanPlus2stdomAveNumVsTime);
            funcList.add(meanMinus2stdomAveNumVsTime);
            ArrayList<PlotCurveCharacterstics> curveCharList = new ArrayList<PlotCurveCharacterstics>();
            curveCharList.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLUE));
            curveCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            curveCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            GraphWindow numVsTimeGraph = new GraphWindow(funcList, "Ave histOfAveNumVsTime", curveCharList);
            numVsTimeGraph.setX_AxisLabel("Year");
            numVsTimeGraph.setY_AxisLabel("N(M\u22655)");
            numVsTimeGraph.setPlotLabelFontSize(18);
            numVsTimeGraph.setAxisLabelFontSize(16);
            numVsTimeGraph.setTickLabelFontSize(14);
            String pathName = new File(resultsDir, "numVsTimeGraph.pdf").getAbsolutePath();
            numVsTimeGraph.saveAsPDF(pathName);
            pathName = new File(resultsDir, "numVsTimeGraph.txt").getAbsolutePath();
            numVsTimeGraph.saveAsTXT(pathName);
        }
        allEventsMagProbDist.scale(1.0 / (numYears * (double)numCatalogs));
        allEventsMagProbDist.setName("All Simulated Events MFD");
        double totNumSim = allEventsMagProbDist.calcSumOfY_Vals();
        allEventsMagProbDist.setInfo("Total Num = " + totNumSim + "; numSim/numExpected = " + totNumSim / mfd.calcSumOfY_Vals());
        spontaneousMagProbDist.scale(1.0 / (numYears * (double)numCatalogs));
        spontaneousMagProbDist.setName("Spontaneous Simulated Events MFD");
        spontaneousMagProbDist.setInfo("Total Num = " + spontaneousMagProbDist.calcSumOfY_Vals());
        mfd.setName("Target MFD");
        mfd.setInfo("Total Num = " + mfd.calcSumOfY_Vals());
        ArrayList<IncrementalMagFreqDist> magProbDists = new ArrayList<IncrementalMagFreqDist>();
        magProbDists.add(allEventsMagProbDist);
        magProbDists.add(spontaneousMagProbDist);
        magProbDists.add(mfd);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
        GraphWindow incrMFDsGraph = new GraphWindow(magProbDists, "MFDs", plotChars);
        incrMFDsGraph.setX_AxisLabel("Mag");
        incrMFDsGraph.setY_AxisLabel("Number");
        incrMFDsGraph.setY_AxisRange(1.0E-5, 1000.0);
        incrMFDsGraph.setX_AxisRange(2.5, 8.5);
        incrMFDsGraph.setYLog(true);
        incrMFDsGraph.setPlotLabelFontSize(18);
        incrMFDsGraph.setAxisLabelFontSize(16);
        incrMFDsGraph.setTickLabelFontSize(14);
        ArrayList<EvenlyDiscretizedFunc> cumMagProbDists = new ArrayList<EvenlyDiscretizedFunc>();
        cumMagProbDists.add(allEventsMagProbDist.getCumRateDistWithOffset());
        cumMagProbDists.add(spontaneousMagProbDist.getCumRateDistWithOffset());
        cumMagProbDists.add(mfd.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotCharsCum = new ArrayList<PlotCurveCharacterstics>();
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotCharsCum.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        GraphWindow cumMFDsGraph = new GraphWindow(cumMagProbDists, "Cumulative MFDs", plotCharsCum);
        cumMFDsGraph.setX_AxisLabel("Mag");
        cumMFDsGraph.setY_AxisLabel("Number");
        cumMFDsGraph.setY_AxisRange(1.0E-4, 10000.0);
        cumMFDsGraph.setX_AxisRange(2.5, 8.5);
        cumMFDsGraph.setYLog(true);
        cumMFDsGraph.setPlotLabelFontSize(18);
        cumMFDsGraph.setAxisLabelFontSize(16);
        cumMFDsGraph.setTickLabelFontSize(14);
        String pathName = new File(resultsDir, "incrMFDsGraph.pdf").getAbsolutePath();
        incrMFDsGraph.saveAsPDF(pathName);
        pathName = new File(resultsDir, "cumMFDsGraph.pdf").getAbsolutePath();
        cumMFDsGraph.saveAsPDF(pathName);
        pathName = new File(resultsDir, "incrMFDsGraph.txt").getAbsolutePath();
        incrMFDsGraph.saveAsTXT(pathName);
        pathName = new File(resultsDir, "cumMFDsGraph.txt").getAbsolutePath();
        cumMFDsGraph.saveAsTXT(pathName);
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory at end of simultation");
        }
    }

    public StirlingGriddedSurface getRandomFiniteRupSurface(double mag, Location hypLoc, double aveDip) {
        Location midTraceLoc;
        double rupBotDepth;
        double rupTopDepth;
        double rupLength;
        double defaultSeisThickness = 13.0;
        double dipRad = aveDip * GeoTools.TO_RAD;
        double rupArea = ScalingRelationships.MEAN_UCERF3.getArea(mag, defaultSeisThickness) * 1.0E-6;
        double rupSqrtArea = Math.sqrt(rupArea);
        double maxDDW = defaultSeisThickness / Math.sin(dipRad);
        if (hypLoc.getDepth() <= defaultSeisThickness) {
            if (rupSqrtArea <= maxDDW) {
                double diff;
                rupLength = rupSqrtArea;
                double rupDDW = rupSqrtArea;
                rupTopDepth = 0.5 * defaultSeisThickness - 0.5 * rupDDW * Math.sin(dipRad);
                rupBotDepth = 0.5 * defaultSeisThickness + 0.5 * rupDDW * Math.sin(dipRad);
                if (hypLoc.getDepth() > rupBotDepth) {
                    diff = hypLoc.getDepth() - rupBotDepth;
                    rupBotDepth += diff;
                    rupTopDepth += diff;
                } else if (hypLoc.getDepth() < rupTopDepth) {
                    diff = rupTopDepth - hypLoc.getDepth();
                    rupBotDepth -= diff;
                    rupTopDepth -= diff;
                }
            } else {
                rupTopDepth = 0.0;
                rupBotDepth = defaultSeisThickness;
                rupLength = rupArea / maxDDW;
                double rupDDW = maxDDW;
            }
        } else {
            rupBotDepth = hypLoc.getDepth();
            maxDDW = rupBotDepth / Math.sin(dipRad);
            if (rupSqrtArea <= maxDDW) {
                rupLength = rupSqrtArea;
                double rupDDW = rupSqrtArea;
                rupTopDepth = rupBotDepth - rupDDW * Math.sin(dipRad);
            } else {
                rupTopDepth = 0.0;
                rupLength = rupArea / maxDDW;
                double rupDDW = maxDDW;
            }
        }
        double randStrike = this.getRandomDouble() * 360.0;
        double dipDir = randStrike + 90.0;
        if (dipDir > 360.0) {
            dipDir -= 360.0;
        }
        if (aveDip < 89.0) {
            double vertDist = hypLoc.getDepth() - rupTopDepth;
            double horzDist = vertDist / Math.tan(dipRad);
            LocationVector dir = new LocationVector(dipDir, horzDist, -vertDist);
            midTraceLoc = LocationUtils.location(hypLoc, dir);
        } else {
            midTraceLoc = new Location(hypLoc.getLatitude(), hypLoc.getLongitude(), rupTopDepth);
        }
        LocationVector dirTraceLoc1 = new LocationVector(randStrike, rupLength / 2.0, 0.0);
        Location traceLoc1 = LocationUtils.location(midTraceLoc, dirTraceLoc1);
        LocationVector dirTraceLoc2 = new LocationVector(randStrike + 180.0, rupLength / 2.0, 0.0);
        Location traceLoc2 = LocationUtils.location(midTraceLoc, dirTraceLoc2);
        if (Math.abs(traceLoc1.getDepth() - rupTopDepth) > 0.05) {
            throw new RuntimeException("Error: problem with depth discrepancy");
        }
        if (Math.abs(traceLoc2.getDepth() - rupTopDepth) > 0.05) {
            throw new RuntimeException("Error: problem with depth discrepancy");
        }
        Location finalTraceLoc1 = new Location(traceLoc1.getLatitude(), traceLoc1.getLongitude(), rupTopDepth);
        Location finalTraceLoc2 = new Location(traceLoc2.getLatitude(), traceLoc2.getLongitude(), rupTopDepth);
        FaultTrace trace = new FaultTrace("trace");
        trace.add(finalTraceLoc1);
        trace.add(finalTraceLoc2);
        StirlingGriddedSurface surf = new StirlingGriddedSurface(trace, aveDip, rupTopDepth, rupBotDepth, 1.0);
        double distTest = LocationUtils.distanceToSurfFast(hypLoc, surf);
        if (distTest > 2.0) {
            System.out.println("distTest Problem: " + distTest);
            System.out.println("Mag at Problem: " + mag);
            System.out.println("Hypo Loc at Problem: " + String.valueOf(hypLoc));
            System.out.println("Trace At Problem: " + String.valueOf(trace));
            System.out.println("Ave Dip At Problem: " + aveDip);
            System.out.println("Rup Top and Bottom At Problem: " + rupTopDepth + ", " + rupBotDepth);
            throw new RuntimeException("Problem in getRandomFiniteRupSurface");
        }
        return surf;
    }
}

