/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_StatewideCatalogCompletenessParam;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3_EqkCatalogStatewideCompleteness;

public class MiscInfoAndPlotsCalc {
    public static void plotCatalogMagVsTime(ObsEqkRupList obsQkList, String fileName) {
        DefaultXY_DataSet yearVsMagXYdata = new DefaultXY_DataSet();
        for (ObsEqkRupture rup : obsQkList) {
            double otYear = (double)rup.getOriginTime() / 3.15576E10 + 1970.0;
            yearVsMagXYdata.set(rup.getMag(), otYear);
        }
        U3_EqkCatalogStatewideCompleteness magComplete = U3_EqkCatalogStatewideCompleteness.STRICT;
        U3_EqkCatalogStatewideCompleteness magCompleteRelaxed = U3_EqkCatalogStatewideCompleteness.RELAXED;
        EvenlyDiscretizedFunc yrMagCompleteFunc = magComplete.getEvenlyDiscretizedMagYearFunc();
        DefaultXY_DataSet yearVsMagCompleteXYdata = new DefaultXY_DataSet();
        double deltaMagOver2 = yrMagCompleteFunc.getDelta() / 2.0;
        for (int i = 0; i < yrMagCompleteFunc.size(); ++i) {
            yearVsMagCompleteXYdata.set(yrMagCompleteFunc.getX(i) - deltaMagOver2, yrMagCompleteFunc.getY(i));
            yearVsMagCompleteXYdata.set(yrMagCompleteFunc.getX(i) + deltaMagOver2, yrMagCompleteFunc.getY(i));
        }
        EvenlyDiscretizedFunc yrMagCompleteFuncRelaxed = magCompleteRelaxed.getEvenlyDiscretizedMagYearFunc();
        DefaultXY_DataSet yearVsMagCompleteXYdataRelaxed = new DefaultXY_DataSet();
        double deltaMagOver2_Relaxed = yrMagCompleteFuncRelaxed.getDelta() / 2.0;
        for (int i = 0; i < yrMagCompleteFuncRelaxed.size(); ++i) {
            yearVsMagCompleteXYdataRelaxed.set(yrMagCompleteFuncRelaxed.getX(i) - deltaMagOver2_Relaxed, yrMagCompleteFuncRelaxed.getY(i));
            yearVsMagCompleteXYdataRelaxed.set(yrMagCompleteFuncRelaxed.getX(i) + deltaMagOver2_Relaxed, yrMagCompleteFuncRelaxed.getY(i));
        }
        ArrayList<DefaultXY_DataSet> funcList = new ArrayList<DefaultXY_DataSet>();
        funcList.add(yearVsMagXYdata);
        funcList.add(yearVsMagCompleteXYdata);
        funcList.add(yearVsMagCompleteXYdataRelaxed);
        ArrayList<PlotCurveCharacterstics> plotCharList = new ArrayList<PlotCurveCharacterstics>();
        plotCharList.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.0f, Color.RED));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        GraphWindow graph = new GraphWindow(funcList, "Year vs Mag", plotCharList);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Year");
        graph.setY_AxisRange(1750.0, 2015.0);
        if (fileName != null) {
            try {
                graph.saveAsPDF(fileName + ".pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotHistQksRateRatesVsTime() {
        double minYear = 1933.0;
        double maxYear = 2012.0;
        double deltaYear = 1.0;
        double minMag = 4.0;
        double maxMag = 5.0;
        int numYear = (int)Math.round(maxYear - minYear);
        File file = new File("/Users/field/workspace/OpenSHA/dev/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt");
        ObsEqkRupList histQksList = null;
        try {
            histQksList = UCERF3_CatalogParser.loadCatalogGardnerKnopoffFiltered(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("numQks = " + histQksList.size());
        HistogramFunction rateVsTime = new HistogramFunction(minYear + deltaYear / 2.0, maxYear - deltaYear / 2.0, numYear);
        boolean first = true;
        double lastYear = Double.NaN;
        for (ObsEqkRupture rup : histQksList.getRupsBetweenMag(minMag, maxMag)) {
            double year = (double)rup.getOriginTime() / 3.15576E10 + 1970.0;
            if (!(year >= minYear) || !(year <= maxYear)) continue;
            rateVsTime.add(year, 1.0);
        }
        rateVsTime.scale(1.0 / deltaYear);
        GraphWindow graph = new GraphWindow(rateVsTime, "Rate vs Time");
        graph.setX_AxisLabel("Year");
        graph.setY_AxisLabel("Rate (per year)");
    }

    public static void plotFilteredCatalogMagFreqDist(List<ETAS_EqkRupture> obsQkList, U3_EqkCatalogStatewideCompleteness yrCompleteForMagFunc, SummedMagFreqDist targetMFD, String fileName) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(2.55, 8.45, 60);
        EvenlyDiscretizedFunc func = yrCompleteForMagFunc.getEvenlyDiscretizedMagYearFunc();
        for (ObsEqkRupture obsEqkRupture : obsQkList) {
            double yrs = 2012.0 - func.getClosestYtoX(obsEqkRupture.getMag());
            mfd.addResampledMagRate(obsEqkRupture.getMag(), 1.0 / yrs, true);
        }
        mfd.setName("Catalog MFD");
        mfd.setInfo("Total Rate = " + mfd.getTotalIncrRate());
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        funcList.add(mfd);
        funcList.add(mfd.getCumRateDistWithOffset());
        ((XY_DataSet)funcList.get(1)).setName("Cumulative Catalog MFD");
        ArrayList<PlotCurveCharacterstics> arrayList = new ArrayList<PlotCurveCharacterstics>();
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLUE));
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
        double expNumAftershockRatio = Double.NaN;
        if (targetMFD != null) {
            double maxMag = targetMFD.getMaxMagWithNonZeroRate();
            double sumObs = 0.0;
            double sumTarget = 0.0;
            for (double mag = 2.55; mag < maxMag + mfd.getDelta() / 2.0; mag += mfd.getDelta()) {
                sumObs += mfd.getY(mag) * Math.pow(10.0, mag);
                sumTarget += targetMFD.getY(mag) * Math.pow(10.0, mag);
            }
            expNumAftershockRatio = sumObs / sumTarget;
            targetMFD.setName("Target MFD");
            targetMFD.setInfo("Total Rate = " + targetMFD.getTotalIncrRate());
            funcList.add(targetMFD);
            funcList.add(targetMFD.getCumRateDistWithOffset());
            ((XY_DataSet)funcList.get(3)).setName("Cumulative Target MFD");
            arrayList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
            arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        }
        mfd.setInfo(mfd.getInfo() + "\nexpNumAftershockRatio = " + (float)expNumAftershockRatio);
        GraphWindow graph = new GraphWindow(funcList, "MFDs; expNumAftershockRatio = " + (float)expNumAftershockRatio, arrayList);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-5, 10000.0);
        if (fileName != null) {
            try {
                graph.saveAsPDF(fileName + ".pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeTotRateRupOccurOnTheseTwoSections(FaultSystemSolutionERF erf, int firstSectID, int secondSectID) {
        System.out.println("Looking for source...");
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double totRate = 0.0;
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            List<Integer> sectListForSrc = rupSet.getSectionsIndicesForRup(erf.getFltSysRupIndexForSource(s));
            if (!sectListForSrc.contains(firstSectID) || !sectListForSrc.contains(secondSectID)) continue;
            totRate += erf.getSource(s).computeTotalEquivMeanAnnualRate(erf.getTimeSpan().getDuration());
        }
        System.out.println("totRate=" + totRate + "\n\t" + rupSet.getFaultSectionData(firstSectID).getName() + "\n\t" + rupSet.getFaultSectionData(secondSectID).getName());
    }

    public static void writeLocationAtCenterOfSectionSurf(FaultSystemSolutionERF erf, int sectID) {
        String name = erf.getSolution().getRupSet().getFaultSectionData(sectID).getName();
        RuptureSurface surf = erf.getSolution().getRupSet().getFaultSectionData(sectID).getFaultSurface(1.0, false, true);
        if (surf instanceof EvenlyGriddedSurface) {
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
            Location loc = gridSurf.getLocation(gridSurf.getNumRows() / 2, gridSurf.getNumCols() / 2);
            System.out.println("Locationat center of " + name + "\t" + loc.getLatitude() + ", " + loc.getLongitude() + ", " + loc.getDepth());
        } else {
            System.out.println("Not evenly gridded");
        }
    }

    public static void writeInfoAboutClosestSectionToLoc(FaultSystemSolutionERF erf, Location loc) {
        List<? extends FaultSection> fltDataList = erf.getSolution().getRupSet().getFaultSectionDataList();
        double minDist = Double.MAX_VALUE;
        int index = -1;
        CalcProgressBar progressBar = new CalcProgressBar("Fault data to process", "junk");
        progressBar.showProgress(true);
        int counter = 0;
        for (FaultSection faultSection : fltDataList) {
            progressBar.updateProgress(counter, fltDataList.size());
            ++counter;
            double dist = LocationUtils.distanceToSurf(loc, faultSection.getFaultSurface(1.0, false, true));
            if (!(minDist > dist)) continue;
            minDist = dist;
            index = faultSection.getSectionId();
        }
        progressBar.showProgress(false);
        minDist = LocationUtils.distanceToSurf(loc, fltDataList.get(index).getFaultSurface(0.01, false, true));
        System.out.println(index + "\tdist=" + (float)minDist + "\tfor\t" + fltDataList.get(index).getName());
    }

    public static void writeInfoAboutSourcesThatUseSection(FaultSystemSolutionERF erf, int sectID, double minMag, double maxMag) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        System.out.println("srcIndex\tfssIndex\tprob\tmag\tname\t" + rupSet.getFaultSectionData(sectID).getName());
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            List<Integer> sectListForSrc = rupSet.getSectionsIndicesForRup(erf.getFltSysRupIndexForSource(s));
            if (!sectListForSrc.contains(sectID)) continue;
            int fssIndex = erf.getFltSysRupIndexForSource(s);
            double meanMag = erf.getSolution().getRupSet().getMagForRup(fssIndex);
            if (meanMag < minMag || meanMag > maxMag) continue;
            double prob = erf.getSource(s).computeTotalProb();
            System.out.println(s + "\t" + fssIndex + "\t" + prob + "\t" + meanMag + "\t" + erf.getSource(s).getName());
        }
    }

    public static void writeInfoAboutSourceWithThisFirstAndLastSection(FaultSystemSolutionERF erf, int firstSectID, int secondSectID) {
        System.out.println("Looking for source...");
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            boolean lastIsIt;
            List<Integer> sectListForSrc;
            FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
            boolean firstIsIt = rupSet.getFaultSectionData((sectListForSrc = rupSet.getSectionsIndicesForRup(erf.getFltSysRupIndexForSource(s))).get(0)).getSectionId() == firstSectID;
            boolean bl = lastIsIt = rupSet.getFaultSectionData(sectListForSrc.get(sectListForSrc.size() - 1)).getSectionId() == secondSectID;
            if (firstIsIt && lastIsIt) {
                int fssIndex = erf.getFltSysRupIndexForSource(s);
                System.out.println("SourceIndex=" + s + "\tfssIndex=" + fssIndex + "\t" + erf.getSource(s).getName() + "\tmag=" + erf.getSolution().getRupSet().getMagForRup(fssIndex));
                break;
            }
            firstIsIt = rupSet.getFaultSectionData(sectListForSrc.get(0)).getSectionId() == secondSectID;
            boolean bl2 = lastIsIt = rupSet.getFaultSectionData(sectListForSrc.get(sectListForSrc.size() - 1)).getSectionId() == firstSectID;
            if (!firstIsIt || !lastIsIt) continue;
            int fssIndex = erf.getFltSysRupIndexForSource(s);
            System.out.println("SourceIndex=" + s + "\tfssIndex=" + fssIndex + "\t" + erf.getSource(s).getName() + "\tmag=" + erf.getSolution().getRupSet().getMagForRup(fssIndex));
            break;
        }
    }

    public static void tempTestGainResult() {
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2014.0, 10.0, false);
        double[] td_rates = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, 6.7);
        ETAS_Simulator.buildScenarioRup(ETAS_Simulator.TestScenario.MOJAVE_M7, erf, erf.getTimeSpan().getStartTimeInMillis());
        double[] td_postScen_rates = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, 6.7);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        double[] ti_rates = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, 6.7);
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        for (int i = 0; i < ti_rates.length; ++i) {
            System.out.println(td_rates[i] + "\t" + td_postScen_rates[i] + "\t" + ti_rates[i] + "\t" + rupSet.getFaultSectionData(i).getName());
        }
    }

    public static Location getMojaveTestLoc(double horzDist) {
        Location loc = new Location(34.698495, -118.508948, 6.550000191);
        if (horzDist == 0.0) {
            return loc;
        }
        LocationVector vect = new LocationVector(25.036999999999978, horzDist, 0.0);
        return LocationUtils.location(loc, vect);
    }

    public static void plotElMayorAndLagunaSalada(FaultSystemSolutionERF_ETAS erf) {
        List<ETAS_EqkRupture> histCat = null;
        try {
            histCat = ETAS_Simulator.getFilteredHistCatalog(ETAS_Simulator.getTimeInMillisFromYear(2012.0), erf, U3ETAS_StatewideCatalogCompletenessParam.DEFAULT_VALUE);
        }
        catch (IOException | DocumentException e) {
            e.printStackTrace();
        }
        LocationList locListForElMayor = histCat.get(54751).getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
        DefaultXY_DataSet elMayorXYdata = new DefaultXY_DataSet();
        for (Location loc : locListForElMayor) {
            elMayorXYdata.set(loc.getLongitude(), loc.getLatitude());
        }
        ArrayList<DefaultXY_DataSet> funcList = new ArrayList<DefaultXY_DataSet>();
        funcList.add(elMayorXYdata);
        ArrayList<PlotCurveCharacterstics> plotCharList = new ArrayList<PlotCurveCharacterstics>();
        plotCharList.add(new PlotCurveCharacterstics(PlotSymbol.BOLD_CROSS, 1.0f, Color.RED));
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        FaultPolyMgr faultPolyMgr = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        for (int i = 1042; i <= 1056; ++i) {
            DefaultXY_DataSet lagunaSaladaPolygonsXYdata = new DefaultXY_DataSet();
            FaultSection fltData = rupSet.getFaultSectionData(i);
            System.out.println(fltData.getName());
            Region polyReg = faultPolyMgr.getPoly(i);
            for (Location loc : polyReg.getBorder()) {
                lagunaSaladaPolygonsXYdata.set(loc.getLongitude(), loc.getLatitude());
            }
            funcList.add(lagunaSaladaPolygonsXYdata);
            plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE));
        }
        GraphWindow graph = new GraphWindow(funcList, "El Mayor and Laguna Salada", plotCharList);
        graph.setX_AxisLabel("Longitude");
        graph.setY_AxisLabel("Latitude");
    }

    public static void plotERF_RatesMap(FaultSystemSolutionERF_ETAS erf, String dirName) {
        CaliforniaRegions.RELM_TESTING_GRIDDED mapGriddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        GriddedGeoDataSet xyzDataSet = ERF_Calculator.getNucleationRatesInRegion(erf, mapGriddedRegion, 0.0, 10.0);
        System.out.println("OrigERF_RatesMap: min=" + xyzDataSet.getMinZ() + "; max=" + xyzDataSet.getMaxZ());
        String metadata = "Map from calling plotOrigERF_RatesMap() method";
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -3.5);
        gmt_MapGenerator.setParameter("Color-Scale Max", 1.5);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        try {
            GMT_CA_Maps.makeMap(xyzDataSet, "OrigERF_RatesMap", metadata, dirName, gmt_MapGenerator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testERF_ParamChanges(FaultSystemSolutionERF_ETAS erf) {
        ArrayList<Object> paramValueList = new ArrayList<Object>();
        System.out.println("\nOrig ERF Adjustable Paramteres:\n");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
            paramValueList.add(param.getValue());
        }
        TimeSpan tsp = erf.getTimeSpan();
        String startTimeString = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        double duration = erf.getTimeSpan().getDuration();
        System.out.println("\tERF StartTime: " + startTimeString);
        System.out.println("\tERF TimeSpan Duration: " + duration + " years");
        paramValueList.add(startTimeString);
        paramValueList.add(duration);
        int numParams = paramValueList.size();
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        System.out.println("\nPois ERF Adjustable Paramteres:\n");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
        }
        tsp = erf.getTimeSpan();
        startTimeString = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        System.out.println("\tERF StartTime: " + startTimeString);
        System.out.println("\tERF TimeSpan Duration: " + erf.getTimeSpan().getDuration() + " years");
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.updateForecast();
        System.out.println("\nFinal ERF Adjustable Paramteres:\n");
        int testNum = erf.getAdjustableParameterList().size() + 2;
        if (numParams != testNum) {
            System.out.println("PROBLEM: num parameters changed:\t" + numParams + "\t" + testNum);
        }
        int i = 0;
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
            if (param.getValue() != paramValueList.get(i)) {
                System.out.println("PROBLEM: " + String.valueOf(param.getValue()) + "\t" + String.valueOf(paramValueList.get(i)));
            }
            ++i;
        }
        tsp = erf.getTimeSpan();
        double duration2 = erf.getTimeSpan().getDuration();
        String startTimeString2 = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        System.out.println("\tERF StartTime: " + startTimeString2);
        System.out.println("\tERF TimeSpan Duration: " + duration2 + " years");
        if (!startTimeString2.equals(startTimeString)) {
            System.out.println("PROBLEM: " + startTimeString2 + "\t" + startTimeString2);
        }
        if (duration2 != duration) {
            System.out.println("PROBLEM Duration: " + duration2 + "\t" + duration);
        }
    }

    public static void main(String[] args) {
        File catFile = new File("src/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt");
        try {
            ObsEqkRupList loadedRups = UCERF3_CatalogParser.loadCatalog(catFile);
            MiscInfoAndPlotsCalc.plotCatalogMagVsTime(loadedRups, "FullU3_CatMagVsTime");
            U3_EqkCatalogStatewideCompleteness magComplete = U3_EqkCatalogStatewideCompleteness.STRICT;
            ObsEqkRupList filteredCat = magComplete.getFilteredCatalog(loadedRups);
            MiscInfoAndPlotsCalc.plotCatalogMagVsTime(filteredCat, "Filtered_CatMagVsTime");
            U3_EqkCatalogStatewideCompleteness magCompleteRelaxed = U3_EqkCatalogStatewideCompleteness.RELAXED;
            ObsEqkRupList filteredCatRelaxed = magCompleteRelaxed.getFilteredCatalog(loadedRups);
            MiscInfoAndPlotsCalc.plotCatalogMagVsTime(filteredCatRelaxed, "RelaxedFiltered_FullU3_CatMagVsTimeFiltered");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

