/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_ComcatComparePlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_FaultParticipationPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_GriddedNucleationPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_HazardChangePlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_LongTermRateVariabilityPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_MFD_Plot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_SimulatedCatalogPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_StationarityPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_TriggerRuptureFaultDistancesPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ComcatEventFetcher;

public class SimulationMarkdownGenerator {
    private static DecimalFormat timeDF = new DecimalFormat("0.00");
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    public static final Comparator<ETAS_Config.BinaryFilteredOutputConfig> binaryOutputComparator;

    private static Options createOptions() {
        Options ops = new Options();
        Option noMapsOption = new Option("nm", "no-maps", false, "Flag to disable map plots (useful it no internet connection or map server down");
        noMapsOption.setRequired(false);
        ops.addOption(noMapsOption);
        Option numCatalogsOption = new Option("num", "num-catalogs", true, "Only process the given number of catalogs (optional)");
        numCatalogsOption.setRequired(false);
        ops.addOption(numCatalogsOption);
        Option forceUpdateOption = new Option("f", "force-update", false, "Force update of all plots, otherwise will only update on new plot versions or if the previous plots were done on an incomplete simulation");
        forceUpdateOption.setRequired(false);
        ops.addOption(forceUpdateOption);
        Option threadsOption = new Option("t", "threads", true, "Number of calculation threads. Default is the number of available processors (in this case: " + SimulationMarkdownGenerator.defaultNumThreads() + ")");
        threadsOption.setRequired(false);
        ops.addOption(threadsOption);
        Option parentDirOption = new Option("jd", "json-dir", false, "Use directory which contains JSON input file as output dir (instead of output dir defined in JSON file)");
        parentDirOption.setRequired(false);
        ops.addOption(parentDirOption);
        Option catalogFileOption = new Option("cc", "comcat-catalog", true, "Path to ComCat catalog file generated with u3etas_comcat_catalog_fetcher.sh for ComCat plots, useful when plotting on a compute node that can't access outside web services");
        catalogFileOption.setRequired(false);
        ops.addOption(catalogFileOption);
        return ops;
    }

    public static int defaultNumThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2023_09_20-NewportInglewood7p2");
            File configFile = new File(simDir, "config.json");
            args = new String[]{"--force-update", configFile.getAbsolutePath()};
        }
        try {
            File outputDir;
            File inputFile;
            CommandLine cmd;
            Options options = SimulationMarkdownGenerator.createOptions();
            DefaultParser parser = new DefaultParser();
            String syntax = ClassUtils.getClassNameWithoutPackage(SimulationMarkdownGenerator.class) + " [options] <etas-config.json> [<binary-catalogs-file.bin OR results directory>]";
            try {
                cmd = parser.parse(options, args);
            }
            catch (ParseException e) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(syntax, options, true);
                System.exit(2);
                return;
            }
            args = cmd.getArgs();
            if (args.length < 1 || args.length > 2) {
                System.err.println("USAGE: " + syntax);
                System.exit(2);
            }
            File configFile = new File(args[0]);
            Preconditions.checkState((boolean)configFile.exists(), (Object)("ETAS config file doesn't exist: " + configFile.getAbsolutePath()));
            ETAS_Config config = ETAS_Config.readJSON(configFile);
            if (args.length == 2) {
                inputFile = new File(args[1]);
            } else {
                System.out.println("Catalogs file/dir not specififed, searching for catalogs...");
                inputFile = SimulationMarkdownGenerator.locateInputFile(config);
            }
            boolean jsonDir = cmd.hasOption("json-dir");
            if (jsonDir) {
                outputDir = configFile.getParentFile();
                System.out.println("Using parent directory of JSON configuration file for output dir: " + outputDir.getAbsolutePath());
            } else {
                outputDir = config.getOutputDir();
                if (!outputDir.exists() && !outputDir.mkdir()) {
                    System.out.println("Output dir doesn't exist and can't be created, assuming that it was computed remotely: " + outputDir.getAbsolutePath());
                    outputDir = inputFile.getParentFile();
                    System.out.println("Using parent directory of input file as output dir: " + outputDir.getAbsolutePath());
                }
            }
            boolean skipMaps = cmd.hasOption("no-maps");
            int maxCatalogs = cmd.hasOption("num-catalogs") ? Integer.parseInt(cmd.getOptionValue("num-catalogs")) : 0;
            int threads = cmd.hasOption("threads") ? Integer.parseInt(cmd.getOptionValue("threads")) : SimulationMarkdownGenerator.defaultNumThreads();
            boolean forcePlot = cmd.hasOption("force-update");
            ObsEqkRupList comcatCatalog = null;
            if (cmd.hasOption("comcat-catalog")) {
                File comcatFile = new File(cmd.getOptionValue("comcat-catalog"));
                System.out.println("Loading ComCat file from: " + comcatFile.getAbsolutePath());
                comcatCatalog = ETAS_ComcatEventFetcher.loadCatalogFile(comcatFile);
            }
            SimulationMarkdownGenerator.generateMarkdown(configFile, inputFile, config, outputDir, skipMaps, maxCatalogs, threads, forcePlot, true, null, comcatCatalog);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    public static double getPreferredMinMag(ETAS_Config config) {
        if (config.getDuration() >= 200.0) {
            return 5.0;
        }
        if (config.getDuration() >= 50.0) {
            return 4.0;
        }
        return 0.0;
    }

    public static File locateInputFile(ETAS_Config config) {
        List<ETAS_Config.BinaryFilteredOutputConfig> binaryFilters = config.getBinaryOutputFilters();
        File inputFile = null;
        if (binaryFilters != null) {
            binaryFilters = new ArrayList<ETAS_Config.BinaryFilteredOutputConfig>(binaryFilters);
            binaryFilters.sort(binaryOutputComparator);
            double minMag = SimulationMarkdownGenerator.getPreferredMinMag(config);
            if (minMag > 0.0) {
                ArrayList<ETAS_Config.BinaryFilteredOutputConfig> filtered = new ArrayList<ETAS_Config.BinaryFilteredOutputConfig>();
                for (ETAS_Config.BinaryFilteredOutputConfig bin : binaryFilters) {
                    if (bin.getMinMag() == null || !(bin.getMinMag().floatValue() >= (float)minMag)) continue;
                    filtered.add(bin);
                }
                if (!filtered.isEmpty()) {
                    System.out.println("Skipping binary files below M=" + (float)minMag + " as catalog duration is long. Override by explicitly specifying input binary file.");
                    binaryFilters = filtered;
                }
            }
            for (ETAS_Config.BinaryFilteredOutputConfig bin : binaryFilters) {
                System.out.println("Looking for binary input files with prerfix: " + bin.getPrefix());
                File binFile = new File(config.getOutputDir(), bin.getPrefix() + ".bin");
                if (binFile.exists()) {
                    inputFile = binFile;
                    break;
                }
                if ((binFile = new File(binFile.getParentFile(), binFile.getName() + ".gz")).exists()) {
                    inputFile = binFile;
                    break;
                }
                binFile = new File(config.getOutputDir(), bin.getPrefix() + "_partial.bin");
                if (!binFile.exists()) continue;
                inputFile = binFile;
                break;
            }
        }
        if (inputFile != null) {
            System.out.println("Using binary catalogs file: " + inputFile.getAbsolutePath());
        } else {
            inputFile = new File(config.getOutputDir(), "results");
            Preconditions.checkState((boolean)inputFile.exists(), (String)"Couldn't locate results binary files and results dir doesn't exist: %s", (Object)inputFile.getAbsolutePath());
            System.out.println("Using results dir: " + inputFile.getAbsolutePath());
        }
        return inputFile;
    }

    private static double seconds(long milliseconds) {
        return (double)milliseconds / 1000.0;
    }

    public static PlotMetadata generateMarkdown(File configFile, File inputFile, final ETAS_Config config, File outputDir, boolean skipMaps, int maxCatalogs, int threads, boolean forceUpdateAll, boolean forceUpdateEvaluation, PlotMetadata meta, ObsEqkRupList comcatCatalog) throws IOException {
        File metadataFile;
        HashMap<Object, PlotResult> prevDoneResults;
        HashMap<Object, PlotResult> allPrevResults;
        ETAS_Launcher launcher;
        ArrayList<ETAS_AbstractPlot> plots;
        File plotsDir;
        long plotStartTime;
        block41: {
            plotStartTime = System.currentTimeMillis();
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0, (String)"Output dir doesn't exist and couldn't be created: %s", (Object)outputDir.getAbsolutePath());
            plotsDir = new File(outputDir, "plots");
            Preconditions.checkState((plotsDir.exists() || plotsDir.mkdir() ? 1 : 0) != 0, (String)"Plot dir doesn't exist and couldn't be created: %s", (Object)plotsDir.getAbsolutePath());
            plots = new ArrayList<ETAS_AbstractPlot>();
            launcher = new ETAS_Launcher(config, false);
            boolean hasAnyTriggers = config.hasTriggers();
            boolean hasNonHistCatalogTriggers = config.getTriggerRuptures() != null && !config.getTriggerRuptures().isEmpty();
            boolean annualizeMFDs = !hasAnyTriggers || config.getDuration() > 10.0 && !hasNonHistCatalogTriggers;
            System.out.println("Has any triggers? " + hasAnyTriggers + "\tHas non-hist triggers? " + hasNonHistCatalogTriggers + "\tAnnualize MFD? " + annualizeMFDs);
            if (annualizeMFDs) {
                plots.add(new ETAS_MFD_Plot(config, launcher, "mfd", annualizeMFDs, true));
                if (config.getDuration() > 50.0) {
                    plots.add(new ETAS_LongTermRateVariabilityPlot(config, launcher, "long_term_var"));
                }
                if (config.getDuration() >= 99.0) {
                    plots.add(new ETAS_StationarityPlot(config, launcher, "stationarity"));
                }
            } else {
                plots.add(new ETAS_MFD_Plot(config, launcher, "mag_num_cumulative", annualizeMFDs, true));
            }
            if (hasNonHistCatalogTriggers) {
                plots.add(new ETAS_HazardChangePlot(config, launcher, "hazard_change_100km", 100.0));
                plots.add(new ETAS_TriggerRuptureFaultDistancesPlot(config, launcher, 20.0));
                ArrayList<Double> percentiles = new ArrayList<Double>();
                percentiles.add(0.0);
                percentiles.add(25.0);
                percentiles.add(50.0);
                percentiles.add(75.0);
                if (config.getNumSimulations() > 100) {
                    percentiles.add(90.0);
                    percentiles.add(95.0);
                }
                if (config.getNumSimulations() >= 1000) {
                    percentiles.add(97.5);
                }
                if (config.getNumSimulations() >= 10000) {
                    percentiles.add(98.0);
                    percentiles.add(99.0);
                }
                if (config.getNumSimulations() >= 100000) {
                    percentiles.add(99.5);
                    percentiles.add(99.9);
                }
                percentiles.add(100.0);
                plots.add(new ETAS_SimulatedCatalogPlot(config, launcher, "sim_catalog_map", Doubles.toArray(percentiles)));
                try {
                    if (config.getComcatMetadata() != null) {
                        plots.add(new ETAS_ComcatComparePlot(config, launcher, comcatCatalog));
                    }
                }
                catch (Exception e) {
                    System.err.println("Error building ComCat plot, skipping");
                    e.printStackTrace();
                }
            }
            if (!config.isGriddedOnly()) {
                plots.add(new ETAS_FaultParticipationPlot(config, launcher, "fault_participation", annualizeMFDs, skipMaps));
            }
            if (!skipMaps) {
                plots.add(new ETAS_GriddedNucleationPlot(config, launcher, "gridded_nucleation", annualizeMFDs));
            }
            allPrevResults = new HashMap<Object, PlotResult>();
            prevDoneResults = new HashMap<Object, PlotResult>();
            metadataFile = new File(plotsDir, "metadata.json");
            if (!forceUpdateAll && (meta != null || metadataFile.exists())) {
                try {
                    long gitTime;
                    String gitHash;
                    if (meta == null) {
                        meta = SimulationMarkdownGenerator.readPlotMetadata(metadataFile);
                    }
                    int compNumSims = config.getNumSimulations();
                    if (maxCatalogs > 0 && maxCatalogs < compNumSims) {
                        compNumSims = maxCatalogs;
                    }
                    if (meta.simulationsProcessed < compNumSims) {
                        System.out.println("Reprocessing all plots as previous version was on incomplete simulation");
                        break block41;
                    }
                    if (meta.plots == null) break block41;
                    HashMap plotClassNameMap = new HashMap();
                    for (ETAS_AbstractPlot plot : plots) {
                        plotClassNameMap.put(plot.getClass().getName(), plot);
                    }
                    System.out.println("Looking for plots we can skip (override with --force-update option)...");
                    for (PlotResult result : meta.plots) {
                        boolean evalUpdate;
                        ETAS_AbstractPlot plot = (ETAS_AbstractPlot)plotClassNameMap.get(result.className);
                        if (plot != null) {
                            allPrevResults.put(plot, result);
                        }
                        boolean bl = evalUpdate = plot != null && forceUpdateEvaluation && plot.isEvaluationPlot();
                        if (plot != null && !evalUpdate && !plot.shouldReplot(result)) {
                            System.out.println("\tSkipping plot (already done): " + ClassUtils.getClassNameWithoutPackage(plot.getClass()));
                            prevDoneResults.put(plot, result);
                            continue;
                        }
                        System.out.println("\tWill update plot: " + ClassUtils.getClassNameWithoutPackage(plot.getClass()));
                    }
                    if (plots.size() != prevDoneResults.size()) break block41;
                    System.out.println("No plots left to update.");
                    try {
                        gitHash = SimulationMarkdownGenerator.getGitHash();
                        gitTime = SimulationMarkdownGenerator.getGitCommitTime(gitHash);
                    }
                    catch (Exception e) {
                        System.err.println("Couldn't locate git hash, won't update metadata file");
                        e.printStackTrace();
                        gitHash = meta.launcherGitHash;
                        gitTime = meta.launcherGitTime;
                    }
                    if (gitTime > meta.launcherGitTime) {
                        System.out.println("Uploading plot metadata file with new git time");
                        meta = new PlotMetadata(plotStartTime, System.currentTimeMillis(), meta.simulationsProcessed, meta.dataFile, gitHash, gitTime, meta.plots);
                        SimulationMarkdownGenerator.writePlotMetadata(meta, metadataFile);
                    }
                    return meta;
                }
                catch (Exception e) {
                    System.out.println("Error reading previous plot metadata");
                }
            }
        }
        boolean filterSpontaneous = false;
        for (ETAS_AbstractPlot plot : plots) {
            filterSpontaneous = filterSpontaneous || plot.isFilterSpontaneous();
        }
        final boolean isFilterSpontaneous = filterSpontaneous;
        final FaultSystemSolution fss = launcher.checkOutFSS();
        final HashSet<ETAS_AbstractPlot> plotsToProcess = new HashSet<ETAS_AbstractPlot>();
        for (ETAS_AbstractPlot plot : plots) {
            if (prevDoneResults.containsKey(plot)) continue;
            plotsToProcess.add(plot);
        }
        Preconditions.checkState((!plotsToProcess.isEmpty() ? 1 : 0) != 0, (Object)"No plots to process?");
        Stopwatch totalProcessWatch = Stopwatch.createStarted();
        double loadMag = inputFile.isDirectory() && !config.hasTriggers() ? SimulationMarkdownGenerator.getPreferredMinMag(config) : 0.0;
        System.out.println("Processing " + config.getSimulationName());
        int numProcessed = ETAS_CatalogIteration.processCatalogs(inputFile, new ETAS_CatalogIteration.Callback(){

            @Override
            public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
                ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog = null;
                if (isFilterSpontaneous) {
                    triggeredOnlyCatalog = ETAS_Launcher.getFilteredNoSpontaneous(config, catalog);
                }
                for (ETAS_AbstractPlot plot : plots) {
                    try {
                        if (!plotsToProcess.contains(plot)) continue;
                        plot.processCatalog(catalog, triggeredOnlyCatalog, fss);
                    }
                    catch (Exception e) {
                        System.err.println("Error processing catalog with plot " + ClassUtils.getClassNameWithoutPackage(plot.getClass()) + ", disabling plot");
                        e.printStackTrace();
                        plotsToProcess.remove(plot);
                    }
                }
            }
        }, maxCatalogs, loadMag);
        totalProcessWatch.stop();
        double totProcessSeconds = SimulationMarkdownGenerator.seconds(totalProcessWatch.elapsed(TimeUnit.MILLISECONDS));
        System.out.println("Processed " + numProcessed + " catalogs in " + SimulationMarkdownGenerator.timeStr(totProcessSeconds));
        if (numProcessed == 0) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String simName = config.getSimulationName();
        if (simName == null || simName.isEmpty()) {
            simName = "ETAS Simulation";
        }
        lines.add("# " + simName + " Results");
        lines.add("");
        List<ETAS_EqkRupture> triggerRups = launcher.getTriggerRuptures();
        List<ETAS_EqkRupture> histRups = launcher.getHistQkList();
        lines.addAll(SimulationMarkdownGenerator.getCatalogSummarytable(config, numProcessed, triggerRups, histRups));
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "*[(top)](#table-of-contents)*";
        lines.add("");
        HashMap<ETAS_AbstractPlot, Double> finalizeTimes = new HashMap<ETAS_AbstractPlot, Double>();
        Stopwatch finalizeWatch = Stopwatch.createStarted();
        System.out.println("Finalizing plots with " + threads + " threads");
        double sumProcessTimes = 0.0;
        HashMap<ETAS_AbstractPlot, PlotFinalizeCallable> plotCallables = new HashMap<ETAS_AbstractPlot, PlotFinalizeCallable>();
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        HashMap<ETAS_AbstractPlot, Future<PlotMarkdownBuilder>> futures = threads > 1 ? new HashMap<ETAS_AbstractPlot, Future<PlotMarkdownBuilder>>() : null;
        ArrayList<PlotResult> plotResults = new ArrayList<PlotResult>();
        for (ETAS_AbstractPlot plot : plotsToProcess) {
            sumProcessTimes += SimulationMarkdownGenerator.seconds(plot.getProcessTimeMS());
            PlotFinalizeCallable call = new PlotFinalizeCallable(plot, plotsDir, fss, exec);
            plotCallables.put(plot, call);
            if (futures == null) continue;
            futures.put(plot, exec.submit(call));
        }
        for (ETAS_AbstractPlot plot : plots) {
            PlotResult result = null;
            Double finalizeTime = null;
            if (plotCallables.containsKey(plot)) {
                try {
                    Object plotLines;
                    PlotMarkdownBuilder builder = futures == null ? ((PlotFinalizeCallable)plotCallables.get(plot)).call() : (PlotMarkdownBuilder)((Future)futures.get(plot)).get();
                    if (builder != null && (plotLines = builder.buildMarkdown(plotsDir.getName(), "##", topLink)) != null && !plotLines.isEmpty()) {
                        result = new PlotResult(plot.getClass(), plot.getVersion(), plotStartTime, (List<String>)plotLines);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (result == null) {
                    result = (PlotResult)allPrevResults.get(plot);
                }
                finalizeTime = SimulationMarkdownGenerator.seconds(((PlotFinalizeCallable)plotCallables.get((Object)plot)).finalizeSubWatch.elapsed(TimeUnit.MILLISECONDS));
            }
            if (result == null && prevDoneResults.containsKey(plot)) {
                result = (PlotResult)prevDoneResults.get(plot);
                finalizeTime = 0.0;
            }
            if (result == null) continue;
            lines.addAll(result.markdown);
            lines.add("");
            plotResults.add(result);
            finalizeTimes.put(plot, finalizeTime);
        }
        finalizeWatch.stop();
        exec.shutdown();
        double totFinalizeTime = SimulationMarkdownGenerator.seconds(finalizeWatch.elapsed(TimeUnit.MILLISECONDS));
        System.out.println("Total catalog processing time: " + SimulationMarkdownGenerator.timeStr(totProcessSeconds));
        DecimalFormat percentDF = new DecimalFormat("0.00 %");
        double overhead = totProcessSeconds - sumProcessTimes;
        System.out.println("\tI/O overhead: " + SimulationMarkdownGenerator.timeStr(overhead) + " (" + percentDF.format(overhead / totProcessSeconds) + ")");
        for (ETAS_AbstractPlot plot : plots) {
            if (prevDoneResults.containsKey(plot)) continue;
            double plotSecs = SimulationMarkdownGenerator.seconds(plot.getProcessTimeMS());
            System.out.println("\t" + ClassUtils.getClassNameWithoutPackage(plot.getClass()) + " " + SimulationMarkdownGenerator.timeStr(plotSecs) + " (" + percentDF.format(plotSecs / totProcessSeconds) + ")");
        }
        System.out.println();
        System.out.println("Total finalize time: " + SimulationMarkdownGenerator.timeStr(totFinalizeTime));
        for (int i = 0; i < plots.size(); ++i) {
            Double finalizeSecs;
            ETAS_AbstractPlot plot;
            plot = (ETAS_AbstractPlot)plots.get(i);
            if (prevDoneResults.containsKey(plot) || (finalizeSecs = (Double)finalizeTimes.get(plot)) == null) continue;
            System.out.println("\t" + ClassUtils.getClassNameWithoutPackage(((ETAS_AbstractPlot)plots.get(i)).getClass()) + " " + SimulationMarkdownGenerator.timeStr(finalizeSecs) + " (" + percentDF.format(finalizeSecs / totFinalizeTime) + ")");
        }
        lines.add("");
        lines.add("## JSON Input File");
        lines.add(topLink);
        lines.add("");
        SimulationMarkdownGenerator.addConfigLines(config, configFile, lines);
        lines.add("");
        launcher.checkInFSS(fss);
        ArrayList<String> tocLines = new ArrayList<String>();
        tocLines.add("## Table Of Contents");
        tocLines.add("");
        tocLines.addAll(MarkdownUtils.buildTOC(lines, 2));
        lines.addAll(tocIndex, tocLines);
        System.out.println("Writing markdown and HTML");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
        System.out.println("DONE");
        String gitHash = SimulationMarkdownGenerator.getGitHash();
        Long gitTime = SimulationMarkdownGenerator.getGitCommitTime(gitHash);
        meta = new PlotMetadata(plotStartTime, System.currentTimeMillis(), numProcessed, inputFile, gitHash, gitTime, plotResults);
        SimulationMarkdownGenerator.writePlotMetadata(meta, metadataFile);
        return meta;
    }

    public static void addConfigLines(ETAS_Config config, File configFile, List<String> lines) throws IOException {
        String line;
        int maxLines;
        lines.add("```");
        BufferedReader jsonReader = new BufferedReader(new FileReader(configFile));
        ArrayList<String> configLines = new ArrayList<String>();
        int n = maxLines = config.getTriggerRuptures() != null && !config.getTriggerRuptures().isEmpty() ? 1000 : Integer.MAX_VALUE;
        while ((line = jsonReader.readLine()) != null) {
            configLines.add(line);
            if (configLines.size() != maxLines) continue;
            jsonReader.close();
            configLines = null;
            break;
        }
        if (configLines == null) {
            String json = config.toJSON(true);
            lines.add(json);
        } else {
            lines.addAll(configLines);
        }
        lines.add("```");
    }

    private static String timeStr(long millis) {
        return SimulationMarkdownGenerator.timeStr((double)millis / 1000.0);
    }

    private static String timeStr(double seconds) {
        if (seconds < 60.0) {
            return timeDF.format(seconds) + " s";
        }
        double mins = seconds / 60.0;
        return timeDF.format(mins) + " m";
    }

    public static List<String> getCatalogSummarytable(ETAS_Config config, int numProcessed, List<ETAS_EqkRupture> triggerRups, List<ETAS_EqkRupture> histRups) {
        MarkdownUtils.TableBuilder builder = MarkdownUtils.tableBuilder();
        builder.addLine(" ", config.getSimulationName() == null ? "ETAS Simulation" : config.getSimulationName());
        if (numProcessed < config.getNumSimulations()) {
            builder.addLine("Num Simulations", numProcessed + " (incomplete)");
        } else {
            builder.addLine("Num Simulations", "" + numProcessed);
        }
        builder.addLine("Start Time", df.format(new Date(config.getSimulationStartTimeMillis())));
        builder.addLine("Start Time Epoch Milliseconds", "" + config.getSimulationStartTimeMillis());
        builder.addLine("Duration", ETAS_AbstractPlot.getTimeLabel(config.getDuration(), true));
        builder.addLine("Includes Spontaneous?", "" + config.isIncludeSpontaneous());
        SimulationMarkdownGenerator.addTriggerLines(builder, "Trigger Ruptures", triggerRups);
        if (config.isTreatTriggerCatalogAsSpontaneous()) {
            SimulationMarkdownGenerator.addTriggerLines(builder, "Historical Ruptures", histRups);
        } else {
            SimulationMarkdownGenerator.addTriggerLines(builder, "Trigger Ruptures", histRups);
        }
        if (config.getConfigCommand() != null && !config.getConfigCommand().isEmpty()) {
            builder.addLine("Config Generated With", config.getConfigCommand());
        }
        return builder.build();
    }

    private static void addTriggerLines(MarkdownUtils.TableBuilder builder, String name, List<ETAS_EqkRupture> triggerRups) {
        if (triggerRups == null || triggerRups.isEmpty()) {
            builder.addLine(name, "*(none)*");
        } else if (triggerRups.size() > 10) {
            double firstMag = 0.0;
            long firstOT = Long.MAX_VALUE;
            double lastMag = 0.0;
            long lastOT = Long.MIN_VALUE;
            long biggestOT = Long.MIN_VALUE;
            double maxMag = 0.0;
            for (ETAS_EqkRupture rup : triggerRups) {
                double mag = rup.getMag();
                long ot = rup.getOriginTime();
                if (mag > maxMag) {
                    maxMag = mag;
                    biggestOT = ot;
                }
                if (ot < firstOT) {
                    firstOT = ot;
                    firstMag = mag;
                }
                if (ot <= lastOT) continue;
                lastOT = ot;
                lastMag = mag;
            }
            builder.addLine(name, triggerRups.size() + " Trigger Ruptures");
            builder.addLine(" ", "First: M" + ETAS_AbstractPlot.optionalDigitDF.format(firstMag) + " at " + df.format(new Date(firstOT)));
            builder.addLine(" ", "Last: M" + ETAS_AbstractPlot.optionalDigitDF.format(lastMag) + " at " + df.format(new Date(lastOT)));
            builder.addLine(" ", "Largest: M" + ETAS_AbstractPlot.optionalDigitDF.format(maxMag) + " at " + df.format(new Date(biggestOT)));
        }
    }

    private static Gson buildGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        return gson;
    }

    public static void writePlotMetadata(PlotMetadata meta, File outputFile) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        fw.write(meta.toJSON() + "\n");
        fw.close();
    }

    public static PlotMetadata readPlotMetadata(File jsonFile) throws IOException {
        return SimulationMarkdownGenerator.readPlotMetadata(new BufferedReader(new FileReader(jsonFile)));
    }

    public static PlotMetadata readPlotMetadata(Reader json) {
        Gson gson = SimulationMarkdownGenerator.buildGson();
        PlotMetadata conf = (PlotMetadata)gson.fromJson(json, PlotMetadata.class);
        return conf;
    }

    public static String getGitHash() {
        File dir;
        String var = System.getenv("ETAS_LAUNCHER");
        if (var != null && var.trim().length() > 0 && (dir = new File(var)).exists()) {
            return SimulationMarkdownGenerator.getGitHash(dir);
        }
        return null;
    }

    public static String getGitHash(File launcherDir) {
        String[] command = new String[]{"/bin/bash", "-c", "cd " + launcherDir.getAbsolutePath() + "; git log -n 1 --pretty='%H' opensha/opensha-all.jar"};
        try {
            String line;
            int exit;
            Process p = Runtime.getRuntime().exec(command);
            try {
                exit = p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
            if (exit != 0) {
                return null;
            }
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = b.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                return line;
            }
        }
        catch (Exception e) {
            System.err.println("Exception detecting ETAS_LAUNCHER git hash");
            e.printStackTrace();
        }
        return null;
    }

    public static Long getGitCommitTime(String gitHash) {
        File dir;
        String var = System.getenv("ETAS_LAUNCHER");
        if (var != null && var.trim().length() > 0 && (dir = new File(var)).exists()) {
            return SimulationMarkdownGenerator.getGitCommitTime(dir, gitHash);
        }
        return null;
    }

    public static Long getGitCommitTime(File launcherDir, String gitHash) {
        String[] command = new String[]{"/bin/bash", "-c", "cd " + launcherDir.getAbsolutePath() + "; git show --no-patch --no-notes --pretty='%ct' " + gitHash};
        try {
            String line;
            int exit;
            Process p = Runtime.getRuntime().exec(command);
            try {
                exit = p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
            if (exit != 0) {
                return null;
            }
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = b.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                return Long.parseLong(line) * 1000L;
            }
        }
        catch (Exception e) {
            System.err.println("Exception detecting ETAS_LAUNCHER git hash");
            e.printStackTrace();
        }
        return null;
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        binaryOutputComparator = new Comparator<ETAS_Config.BinaryFilteredOutputConfig>(){

            @Override
            public int compare(ETAS_Config.BinaryFilteredOutputConfig o1, ETAS_Config.BinaryFilteredOutputConfig o2) {
                if (o1.isDescendantsOnly() != o2.isDescendantsOnly()) {
                    if (o1.isDescendantsOnly()) {
                        return 1;
                    }
                    return -1;
                }
                Double mag1 = o1.getMinMag();
                Double mag2 = o2.getMinMag();
                if (mag1 == null) {
                    mag1 = Double.NEGATIVE_INFINITY;
                }
                if (mag2 == null) {
                    mag2 = Double.NEGATIVE_INFINITY;
                }
                if (mag1 != mag2) {
                    return Double.compare(mag1, mag2);
                }
                return 0;
            }
        };
    }

    public static class PlotMetadata {
        public final long plotStartTime;
        public final long plotEndTime;
        public final int simulationsProcessed;
        public final File dataFile;
        public final String launcherGitHash;
        public final Long launcherGitTime;
        public final List<PlotResult> plots;

        public PlotMetadata(long plotStartTime, long plotEndTime, int simulationsProcessed, File dataFile, String launcherGitHash, Long launcherGitTime, List<PlotResult> plots) {
            this.plotStartTime = plotStartTime;
            this.plotEndTime = plotEndTime;
            this.simulationsProcessed = simulationsProcessed;
            this.dataFile = dataFile;
            this.launcherGitHash = launcherGitHash;
            this.launcherGitTime = launcherGitTime;
            this.plots = plots;
        }

        public String toJSON() {
            Gson gson = SimulationMarkdownGenerator.buildGson();
            return gson.toJson((Object)this);
        }
    }

    public static class PlotResult {
        public final String className;
        public final int version;
        public final long time;
        public final List<String> markdown;

        public PlotResult(Class<? extends ETAS_AbstractPlot> clazz, int version, long time, List<String> markdown) {
            this(clazz.getName(), version, time, markdown);
        }

        public PlotResult(String className, int version, long time, List<String> markdown) {
            this.className = className;
            this.version = version;
            this.time = time;
            this.markdown = markdown;
        }
    }

    private static class PlotFinalizeCallable
    implements Callable<PlotMarkdownBuilder> {
        private ETAS_AbstractPlot plot;
        private File plotsDir;
        private FaultSystemSolution fss;
        private Stopwatch finalizeSubWatch;
        private ExecutorService exec;
        private List<Future<?>> finalizeFutures;

        public PlotFinalizeCallable(ETAS_AbstractPlot plot, File plotsDir, FaultSystemSolution fss, ExecutorService exec) {
            this.plot = plot;
            this.plotsDir = plotsDir;
            this.fss = fss;
            this.exec = exec;
        }

        @Override
        public PlotMarkdownBuilder call() throws Exception {
            String cName = ClassUtils.getClassNameWithoutPackage(this.plot.getClass());
            System.out.println("Finalizing " + cName);
            this.finalizeSubWatch = Stopwatch.createStarted();
            List<? extends Runnable> runnables = this.plot.finalize(this.plotsDir, this.fss, this.exec);
            this.finalizeSubWatch.stop();
            String finalStr = "Done finalizing " + cName + " in " + SimulationMarkdownGenerator.timeStr(this.finalizeSubWatch.elapsed(TimeUnit.MILLISECONDS));
            if (runnables != null && !runnables.isEmpty()) {
                this.finalizeFutures = new ArrayList();
                for (Runnable runnable : runnables) {
                    this.finalizeFutures.add(this.exec.submit(runnable));
                }
                System.out.println(finalStr + " (but must process " + this.finalizeFutures.size() + " runnables)");
            } else {
                System.out.println(finalStr);
            }
            return new PlotMarkdownBuilder(this.plot, this.finalizeFutures, this.finalizeSubWatch);
        }
    }

    private static class PlotMarkdownBuilder {
        private ETAS_AbstractPlot plot;
        private List<Future<?>> finalizeFutures;
        private Stopwatch finalizeSubWatch;

        PlotMarkdownBuilder(ETAS_AbstractPlot plot, List<Future<?>> finalizeFutures, Stopwatch finalizeSubWatch) {
            this.plot = plot;
            this.finalizeFutures = finalizeFutures;
            this.finalizeSubWatch = finalizeSubWatch;
        }

        public List<String> buildMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) {
            this.finalizeSubWatch.start();
            try {
                if (this.finalizeFutures != null) {
                    for (Future<?> future : this.finalizeFutures) {
                        future.get();
                    }
                }
                List<String> lines = this.plot.generateMarkdown(relativePathToOutputDir, topLevelHeading, topLink);
                this.finalizeSubWatch.stop();
                return lines;
            }
            catch (Exception e) {
                System.out.flush();
                System.err.println("Exception finalizing plot, it won't be included in the output page");
                e.printStackTrace();
                System.err.flush();
                this.finalizeSubWatch.stop();
                return null;
            }
        }
    }
}

