/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.erf.ETAS.association.JeanneFileLoader;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FiniteFaultMapper {
    private static final boolean D = true;
    private FaultSystemRupSet rupSet;
    private static final double maxLengthDiff = 50.0;
    private static final double maxCenterDist = 30.0;
    private static final double maxAnyDist = 50.0;
    private static final double maxMedianDist = 100.0;
    private static final double minDistThresh = 5.0;
    private static final int numSurfLocsToCheck = 500;
    private static final double surfSpacing = 5.0;
    private RuptureSurface[] surfs;
    private Location[] centers;
    private double[] lengths;
    private boolean filterLastEventParents = true;
    private boolean matchLastEventExactly = true;
    private static final boolean use_sq_dist = true;
    private Map<Integer, List<FaultSection>> parentSectsMap;
    private List<FaultSection> sectsWithDate;
    private List<Long> dates;
    private Map<String, Integer> sectHashes = null;
    private static final Joiner j = Joiner.on((String)",");

    public FiniteFaultMapper(FaultSystemRupSet rupSet, boolean filterLastEventParents, boolean matchLastEventExactly) {
        this.rupSet = rupSet;
        this.filterLastEventParents = filterLastEventParents;
        this.matchLastEventExactly = matchLastEventExactly;
        this.surfs = new RuptureSurface[rupSet.getNumRuptures()];
        this.centers = new Location[rupSet.getNumRuptures()];
        this.lengths = new double[rupSet.getNumRuptures()];
        for (int i = 0; i < rupSet.getNumRuptures(); ++i) {
            this.lengths[i] = rupSet.getLengthForRup(i) / 1000.0;
            this.surfs[i] = rupSet.getSurfaceForRupture(i, 5.0);
            this.centers[i] = FiniteFaultMapper.calcCenter(this.surfs[i]);
        }
        this.parentSectsMap = Maps.newHashMap();
        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            ArrayList sects = this.parentSectsMap.get(faultSection.getParentSectionId());
            if (sects == null) {
                sects = Lists.newArrayList();
                this.parentSectsMap.put(faultSection.getParentSectionId(), sects);
            }
            sects.add(faultSection);
        }
    }

    private static Location calcCenter(RuptureSurface surf) {
        double lat = 0.0;
        double lon = 0.0;
        double depth = 0.0;
        int num = 0;
        for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
            lat += loc.getLatitude();
            lon += loc.getLongitude();
            depth += loc.getDepth();
            ++num;
        }
        return new Location(lat /= (double)num, lon /= (double)num, depth /= (double)num);
    }

    private void initSectsWithDate() {
        this.sectsWithDate = Lists.newArrayList();
        this.dates = Lists.newArrayList();
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            long date = faultSection.getDateOfLastEvent();
            if (date == Long.MIN_VALUE) continue;
            this.sectsWithDate.add(faultSection);
            this.dates.add(date);
        }
        List<ComparablePairing<Long, FaultSection>> comps = ComparablePairing.build(this.dates, this.sectsWithDate);
        Collections.sort(comps);
        Collections.reverse(comps);
        this.sectsWithDate = Lists.newArrayList();
        this.dates = Lists.newArrayList();
        for (ComparablePairing<Long, FaultSection> comp : comps) {
            this.sectsWithDate.add(comp.getData());
            this.dates.add(comp.getComparable());
        }
    }

    private HashSet<Integer> getViableParentIDs(long eventDate) {
        long sectDate;
        if (this.sectsWithDate == null) {
            this.initSectsWithDate();
        }
        eventDate = (long)((double)eventDate - 3.15576E10);
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (int i = 0; i < this.sectsWithDate.size() && (sectDate = this.dates.get(i).longValue()) >= eventDate; ++i) {
            parentIDs.add(this.sectsWithDate.get(i).getParentSectionId());
        }
        return parentIDs;
    }

    public int getMappedRup(ObsEqkRupture rup) {
        ComparablePairing pairing;
        double median;
        ArrayList surfLocsToCheck;
        Stopwatch watch = null;
        watch = Stopwatch.createStarted();
        RuptureSurface surf = rup.getRuptureSurface();
        Preconditions.checkNotNull((Object)surf);
        double length = surf.getAveLength();
        Location center = FiniteFaultMapper.calcCenter(surf);
        System.out.println("**********************************");
        System.out.println("Loading cadidate for " + JeanneFileLoader.getRupStr(rup) + ". Len=" + length + ". Center: " + String.valueOf(center));
        HashSet<Integer> parentIDs = null;
        if (this.filterLastEventParents && (parentIDs = this.getViableParentIDs(rup.getOriginTime())).isEmpty()) {
            System.out.println("No viable parents for M" + rup.getMag() + " at " + String.valueOf(rup.getOriginTimeCal().getTime()));
            return -1;
        }
        ArrayList candidates = Lists.newArrayList();
        int numFilteredParents = 0;
        block0: for (int i = 0; i < this.rupSet.getNumRuptures(); ++i) {
            double hDist;
            double lengthDiff = Math.abs(this.lengths[i] - length);
            if (lengthDiff > 50.0 || (hDist = LocationUtils.horzDistance(center, this.centers[i])) > 30.0) continue;
            if (parentIDs != null) {
                for (int parentID : this.rupSet.getParentSectionsForRup(i)) {
                    if (parentIDs.contains(parentID)) continue;
                    ++numFilteredParents;
                    continue block0;
                }
            }
            candidates.add(i);
        }
        System.out.println("Found " + candidates.size() + " candidates (" + numFilteredParents + " filtered due to parents)");
        ArrayList surfLocs = Lists.newArrayList();
        if (surf instanceof EvenlyGriddedSurface) {
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
            for (int col = 0; col < gridSurf.getNumCols(); ++col) {
                for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                    surfLocs.add((Location)gridSurf.get(row, col));
                }
            }
        } else {
            double lonDelta;
            Location loc1 = surf.getFirstLocOnUpperEdge();
            Location loc2 = surf.getFirstLocOnUpperEdge();
            double latDelta = Math.abs(loc1.getLatitude() - loc2.getLatitude());
            JeanneFileLoader.LocComparator comp = new JeanneFileLoader.LocComparator(latDelta > (lonDelta = Math.abs(loc1.getLongitude() - loc2.getLongitude())));
            surfLocs.addAll(surf.getEvenlyDiscritizedListOfLocsOnSurface());
            Collections.sort(surfLocs, comp);
        }
        if (500 >= surfLocs.size()) {
            surfLocsToCheck = surfLocs;
        } else {
            surfLocsToCheck = Lists.newArrayList();
            int mod = (int)((double)surfLocs.size() / 500.0);
            for (int i = 0; i < surfLocs.size(); ++i) {
                if (i % mod != 0) continue;
                surfLocsToCheck.add((Location)surfLocs.get(i));
            }
        }
        System.out.println("Checking distance of " + surfLocsToCheck.size() + "/" + surfLocs.size() + " surf pts");
        ArrayList means = Lists.newArrayList();
        ArrayList squaredMeans = Lists.newArrayList();
        ArrayList medians = Lists.newArrayList();
        ArrayList allDists = Lists.newArrayList();
        ArrayList sortIndexes = Lists.newArrayList();
        block5: for (int i = 0; i < candidates.size(); ++i) {
            int j;
            ArrayList candidateDistsToCheck;
            int rupIndex = (Integer)candidates.get(i);
            RuptureSurface candidate = this.surfs[rupIndex];
            double[] surfToCandidateDistances = new double[surfLocsToCheck.size()];
            for (int j2 = 0; j2 < surfLocsToCheck.size(); ++j2) {
                surfToCandidateDistances[j2] = candidate.getDistanceRup((Location)surfLocsToCheck.get(j2));
                if (!(surfToCandidateDistances[j2] > 50.0)) continue;
                means.add(Double.POSITIVE_INFINITY);
                squaredMeans.add(Double.POSITIVE_INFINITY);
                medians.add(Double.POSITIVE_INFINITY);
                allDists.add(null);
                sortIndexes.add(i);
                continue block5;
            }
            FaultTrace candidateUpperEdge = candidate.getEvenlyDiscritizedUpperEdge();
            if (candidateUpperEdge.size() < 500) {
                candidateDistsToCheck = candidateUpperEdge;
            } else {
                candidateDistsToCheck = Lists.newArrayList();
                int mod = (int)((double)candidateUpperEdge.size() / 500.0);
                for (j = 0; j < candidateUpperEdge.size(); ++j) {
                    if (j % mod != 0) continue;
                    surfLocsToCheck.add((Location)candidateUpperEdge.get(j));
                }
            }
            double[] candidateToSurfDistances = new double[candidateDistsToCheck.size()];
            for (j = 0; j < candidateDistsToCheck.size(); ++j) {
                candidateToSurfDistances[j] = surf.getDistanceRup((Location)candidateDistsToCheck.get(j));
                if (!(candidateToSurfDistances[j] > 50.0)) continue;
                means.add(Double.POSITIVE_INFINITY);
                squaredMeans.add(Double.POSITIVE_INFINITY);
                medians.add(Double.POSITIVE_INFINITY);
                allDists.add(null);
                sortIndexes.add(i);
                continue block5;
            }
            double[] combDists = new double[surfToCandidateDistances.length + candidateToSurfDistances.length];
            System.arraycopy(surfToCandidateDistances, 0, combDists, 0, surfToCandidateDistances.length);
            System.arraycopy(candidateToSurfDistances, 0, combDists, surfToCandidateDistances.length, candidateToSurfDistances.length);
            median = DataUtils.median(combDists);
            if (StatUtils.min((double[])combDists) > 5.0 || median > 100.0) {
                means.add(Double.POSITIVE_INFINITY);
                squaredMeans.add(Double.POSITIVE_INFINITY);
                medians.add(Double.POSITIVE_INFINITY);
                allDists.add(null);
                sortIndexes.add(i);
                continue;
            }
            means.add(0.5 * StatUtils.mean((double[])surfToCandidateDistances) + 0.5 * StatUtils.mean((double[])candidateToSurfDistances));
            squaredMeans.add(0.5 * FiniteFaultMapper.sq_mean(surfToCandidateDistances) + 0.5 * FiniteFaultMapper.sq_mean(candidateToSurfDistances));
            medians.add(median);
            allDists.add(combDists);
            sortIndexes.add(i);
        }
        List pairings = ComparablePairing.build(squaredMeans, sortIndexes);
        Collections.sort(pairings);
        for (int i = 0; i < 5 && i < pairings.size() && !Double.isInfinite((Double)(pairing = pairings.get(i)).getComparable()); ++i) {
            int index = (Integer)pairing.getData();
            double mean = (Double)means.get(index);
            double sqMean = (Double)squaredMeans.get(index);
            median = (Double)medians.get(index);
            double[] dArray = (double[])allDists.get(index);
            double min = StatUtils.min((double[])dArray);
            double max = StatUtils.max((double[])dArray);
            int rupIndex = (Integer)candidates.get(index);
            ArrayList parents = Lists.newArrayList();
            for (FaultSection sect : this.rupSet.getFaultSectionDataForRupture(rupIndex)) {
                String parentName = sect.getParentSectionName();
                if (!parents.isEmpty() && ((String)parents.get(parents.size() - 1)).equals(parentName)) continue;
                parents.add(parentName);
            }
            String parStr = Joiner.on((String)"; ").join((Iterable)parents);
            System.out.println("Match " + i + ". Mean=" + (float)mean + ". Sq Mean=" + (float)sqMean + ". Median=" + (float)median + ". Range=[" + (float)min + " " + (float)max + "]. Mag=" + this.rupSet.getMagForRup(rupIndex) + ". Len=" + this.lengths[rupIndex] + ". Center: " + String.valueOf(this.centers[rupIndex]) + ". Parents: " + parStr);
        }
        watch.stop();
        System.out.println("Took " + watch.elapsed(TimeUnit.SECONDS) + " seconds to find match");
        if (pairings.isEmpty()) {
            return -1;
        }
        ComparablePairing pairing2 = pairings.get(0);
        if (((Double)pairing2.getComparable()).isInfinite()) {
            return -1;
        }
        int rupIndex = (Integer)candidates.get((Integer)pairing2.getData());
        if (this.matchLastEventExactly) {
            System.out.println("Adjusting to match date of last event data exactly");
            ArrayList subSectsWithData = Lists.newArrayList();
            long closestDateToEvent = -1L;
            long closestDelta = Long.MAX_VALUE;
            List<FaultSection> sectsForRup = this.rupSet.getFaultSectionDataForRupture(rupIndex);
            for (FaultSection faultSection : sectsForRup) {
                if (faultSection.getDateOfLastEvent() == Long.MIN_VALUE) continue;
                long delta = rup.getOriginTime() - faultSection.getDateOfLastEvent();
                if (delta < 0L) {
                    delta = -delta;
                }
                if (delta >= closestDelta) continue;
                closestDateToEvent = faultSection.getDateOfLastEvent();
                closestDelta = delta;
            }
            for (FaultSection faultSection : sectsForRup) {
                if (faultSection.getDateOfLastEvent() < closestDateToEvent) continue;
                subSectsWithData.add(faultSection);
            }
            System.out.println("Removing " + (sectsForRup.size() - subSectsWithData.size()) + " sects without data (or with earlier date). Date: " + String.valueOf(new Date(closestDateToEvent)));
            HashSet<Integer> sectsToInclude = new HashSet<Integer>();
            for (FaultSection sect : subSectsWithData) {
                sectsToInclude.add(sect.getSectionId());
            }
            if ((double)closestDelta < 6.31152E10) {
                ArrayList arrayList = Lists.newArrayList();
                for (FaultSection sect : subSectsWithData) {
                    for (FaultSection oSect : this.parentSectsMap.get(sect.getParentSectionId())) {
                        if (sectsToInclude.contains(oSect.getSectionId()) || oSect.getDateOfLastEvent() != closestDateToEvent) continue;
                        sectsToInclude.add(oSect.getSectionId());
                        arrayList.add(oSect.getName());
                    }
                }
                System.out.println("Adding " + (sectsToInclude.size() - subSectsWithData.size()) + " sects that match date but were excluded: " + j.join((Iterable)arrayList));
            } else {
                System.out.println("Not adding any more as rupture is masked in last event data");
            }
            if (sectsToInclude.size() < 2) {
                System.out.println("Too few subsections, skipping");
                rupIndex = -1;
            } else {
                rupIndex = this.getRuptureForSects(sectsToInclude);
            }
        }
        if (rupIndex >= 0) {
            double fssMag = this.rupSet.getMagForRup(rupIndex);
            double magDelta = fssMag - rup.getMag();
            if (fssMag > 7.0 && magDelta > 0.5) {
                System.out.println("Throwing out match as this is likely a smaller aftershock. Mag Delta: " + fssMag + " - " + rup.getMag() + " = " + magDelta);
                rupIndex = -1;
            }
        }
        System.out.println("**********************************");
        return rupIndex;
    }

    private int getRuptureForSects(HashSet<Integer> sects) {
        String key;
        Integer rupIndex;
        if (this.sectHashes == null) {
            this.sectHashes = Maps.newHashMap();
            for (int i = 0; i < this.rupSet.getNumRuptures(); ++i) {
                this.sectHashes.put(FiniteFaultMapper.getSectsKey(this.rupSet.getSectionsIndicesForRup(i)), i);
            }
        }
        if ((rupIndex = this.sectHashes.get(key = FiniteFaultMapper.getSectsKey(sects))) == null) {
            System.out.println("Rupture doesn't exist, trying subsets");
            HashSet<Integer> parents = new HashSet<Integer>();
            for (int sect : sects) {
                parents.add(this.rupSet.getFaultSectionData(sect).getParentSectionId());
            }
            HashSet<Integer> candidateRups = new HashSet<Integer>();
            Iterator sect = parents.iterator();
            while (sect.hasNext()) {
                int parentID = (Integer)sect.next();
                candidateRups.addAll(this.rupSet.getRupturesForParentSection(parentID));
            }
            int mostSects = 0;
            int matchIndex = -1;
            Iterator iterator = candidateRups.iterator();
            block3: while (iterator.hasNext()) {
                int rup = (Integer)iterator.next();
                List<Integer> oSects = this.rupSet.getSectionsIndicesForRup(rup);
                if (oSects.size() > sects.size() || oSects.size() <= mostSects) continue;
                for (int sectIndex : oSects) {
                    if (sects.contains(sectIndex)) continue;
                    continue block3;
                }
                mostSects = oSects.size();
                matchIndex = rup;
            }
            Preconditions.checkState((matchIndex > 0 ? 1 : 0) != 0, (Object)"No subset match either!");
            ArrayList excludedNames = Lists.newArrayList();
            HashSet<Integer> newSects = new HashSet<Integer>(this.rupSet.getSectionsIndicesForRup(matchIndex));
            for (int sect2 : sects) {
                if (newSects.contains(sect2)) continue;
                excludedNames.add(this.rupSet.getFaultSectionData(sect2).getName());
            }
            System.out.println("Found match by removing: " + j.join((Iterable)excludedNames));
            rupIndex = matchIndex;
        }
        Preconditions.checkNotNull((Object)rupIndex, (Object)("No match for rupture: " + key));
        return rupIndex;
    }

    private static String getSectsKey(Collection<Integer> sects) {
        ArrayList sorted = Lists.newArrayList(sects);
        Collections.sort(sorted);
        return j.join((Iterable)sorted);
    }

    private static double sq_mean(double[] array) {
        double mean = 0.0;
        for (double val : array) {
            mean += val * val;
        }
        return mean /= (double)array.length;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File finiteFile = new File("/home/kevin/OpenSHA/UCERF3/historical_finite_fault_mapping/UCERF3_finite.dat");
        ObsEqkRupList inputRups = UCERF3_CatalogParser.loadCatalog(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt"));
        for (ObsEqkRupture rup : inputRups) {
            if (!(rup.getHypocenterLocation().getDepth() > 24.0) || !(rup.getMag() >= 4.0)) continue;
            System.out.println(String.valueOf(rup.getHypocenterLocation()) + ", mag=" + rup.getMag());
        }
        List<ObsEqkRupture> finiteRups = JeanneFileLoader.loadFiniteRups(finiteFile, inputRups);
        System.out.println("Loaded " + finiteRups.size() + " finite rups");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        FiniteFaultMapper mapper = new FiniteFaultMapper(rupSet, true, true);
        for (ObsEqkRupture rup : finiteRups) {
            mapper.getMappedRup(rup);
        }
    }
}

