/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultMappingData;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FiniteFaultSectionResetCalc {
    private FaultSystemRupSet rupSet;
    private PolygonFaultGridAssociations polyManager;
    private double minFractionalAreaInPolygon;
    private boolean removeOverlapsWithDist;
    private Region[] polygons;
    private double[] sectAreas;
    private RuptureSurface[] sectSurfaces;
    private XY_DataSet[] sectPolygonXYs;
    private Table<EvenlyGriddedSurface, Region, Double> rupSetAreaInPolysCache = HashBasedTable.create();
    static final DateFormat printDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    static final DateFormat fileDateFormat = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss-z");
    private static final DecimalFormat optionalDigitDF = new DecimalFormat("0.##");
    public static final Color COLOR_MATCH = Color.GREEN.darker();
    public static final Color COLOR_NO_MATCH_EXTERNAL_MATCH = Color.RED.darker();
    public static final Color COLOR_MATCH_EXTERNAL_NO_MATCH = Color.BLUE.darker();
    public static final Color COLOR_HAS_AREA_NO_MATCH = Color.LIGHT_GRAY.darker();
    public static final Color COLOR_NO_AREA = new Color(240, 240, 240);
    public static final Color COLOR_RUP_SURFACE = Color.ORANGE.darker();
    public static final Color COLOR_CA_OUTLINE = Color.DARK_GRAY;
    private static final float POINT_THICKNESS = 1.5f;
    private static final float LINE_THICKNESS = 2.0f;
    private static final float LINE_THICKNESS_ORIG_POLY = 1.0f;
    private static final double REGION_BUFFER_DEGREES = 0.2;

    public FiniteFaultSectionResetCalc(FaultSystemRupSet rupSet, PolygonFaultGridAssociations polygons, double minFractionalAreaInPolygon, boolean removeOverlapsWithDist) {
        this.rupSet = rupSet;
        Preconditions.checkArgument((minFractionalAreaInPolygon > 0.0 && minFractionalAreaInPolygon <= 1.0 ? 1 : 0) != 0, (Object)"Min Fractional Area in Polygon must be in range (0 1]");
        this.minFractionalAreaInPolygon = minFractionalAreaInPolygon;
        this.removeOverlapsWithDist = removeOverlapsWithDist;
        this.setPolygons(polygons);
    }

    public void setPolygons(PolygonFaultGridAssociations polyManager) {
        Preconditions.checkNotNull((Object)polyManager, (Object)"Must supply polygons");
        this.polyManager = polyManager;
        this.polygons = new Region[this.rupSet.getNumSections()];
        this.sectAreas = new double[this.rupSet.getNumSections()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            this.polygons[s] = polyManager.getPoly(s);
            this.sectAreas[s] = this.rupSet.getAreaForSection(s) * 1.0E-6;
        }
    }

    public void setRemoveOverlapsWithDist(boolean removeOverlapsWithDist) {
        this.removeOverlapsWithDist = removeOverlapsWithDist;
    }

    public void setMinFractionalAreaInPolygon(double minFractionalAreaInPolygon) {
        this.minFractionalAreaInPolygon = minFractionalAreaInPolygon;
    }

    private synchronized RuptureSurface getSectSurface(int index) {
        if (this.sectSurfaces == null) {
            this.sectSurfaces = new EvenlyGriddedSurface[this.rupSet.getNumSections()];
        }
        if (this.sectSurfaces[index] == null) {
            this.sectSurfaces[index] = this.rupSet.getFaultSectionData(index).getFaultSurface(1.0);
        }
        return this.sectSurfaces[index];
    }

    public double[] getAreaInSectionPolygons(RuptureSurface surf) {
        double[] areas = new double[this.rupSet.getNumRuptures()];
        boolean any = false;
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            areas[s] = this.getAreaInPoly(surf, this.getPolygon(s));
            any = any || areas[s] > 0.0;
        }
        if (!any) {
            return null;
        }
        return areas;
    }

    private double getAreaInPoly(RuptureSurface surf, Region polygon) {
        if (surf instanceof CompoundSurface) {
            double area = 0.0;
            for (RuptureSurface ruptureSurface : ((CompoundSurface)surf).getSurfaceList()) {
                if (ruptureSurface instanceof EvenlyGriddedSurface) {
                    Double myArea = (Double)this.rupSetAreaInPolysCache.get((Object)surf, (Object)polygon);
                    if (myArea == null) {
                        myArea = ruptureSurface.getAreaInsideRegion(polygon);
                        this.rupSetAreaInPolysCache.put((Object)((EvenlyGriddedSurface)ruptureSurface), (Object)polygon, (Object)myArea);
                    }
                    area += myArea.doubleValue();
                    continue;
                }
                area += ruptureSurface.getAreaInsideRegion(polygon);
            }
            return area;
        }
        return surf.getAreaInsideRegion(polygon);
    }

    public SectRupDistances[] getSectRupDistances(RuptureSurface surf, double[] areas) {
        return this.getSectRupDistances(surf, areas, false);
    }

    public SectRupDistances[] getSectRupDistances(RuptureSurface surf, double[] areas, boolean force) {
        if (areas == null) {
            return null;
        }
        SectRupDistances[] dists = new SectRupDistances[this.rupSet.getNumRuptures()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            if (!force && !(areas[s] > 0.0)) continue;
            dists[s] = new SectRupDistances(this.getSectSurface(s), surf);
        }
        return dists;
    }

    public List<FaultSection> getMatchingSections(RuptureSurface surf) {
        double[] areas = this.getAreaInSectionPolygons(surf);
        SectRupDistances[] dists = this.removeOverlapsWithDist ? this.getSectRupDistances(surf, areas) : null;
        return this.getMatchingSections(surf, areas, dists);
    }

    public List<FaultSection> getMatchingSections(RuptureSurface surf, double[] areas, SectRupDistances[] dists) {
        if (areas == null) {
            return null;
        }
        FaultSectionDataMappingResult[] results = this.getMappingResults(surf, areas, dists);
        return this.getMatchingSections(results);
    }

    public FaultSectionDataMappingResult[] getMappingResults(RuptureSurface surf, double[] areas, SectRupDistances[] dists) {
        if (areas == null) {
            return null;
        }
        if (this.removeOverlapsWithDist) {
            List<DistSortableSections> sects = this.removeOverlaps(surf, areas, dists);
            double[] modAreas = new double[areas.length];
            for (DistSortableSections sect : sects) {
                modAreas[sect.index] = sect.area;
            }
            areas = modAreas;
        }
        FaultSectionDataMappingResult[] ret = new FaultSectionDataMappingResult[this.rupSet.getNumSections()];
        for (int s = 0; s < ret.length; ++s) {
            ret[s] = new FaultSectionDataMappingResult(this.rupSet.getFaultSectionData(s), dists == null ? null : dists[s], areas[s], this.sectAreas[s]);
        }
        return ret;
    }

    private List<FaultSection> getMatchingSections(FaultSectionDataMappingResult[] results) {
        ArrayList<FaultSection> sects = new ArrayList<FaultSection>();
        for (FaultSectionDataMappingResult result : results) {
            if (!result.match) continue;
            sects.add(result.sect);
        }
        if (sects.isEmpty()) {
            return null;
        }
        return sects;
    }

    private List<DistSortableSections> removeOverlaps(RuptureSurface surf, double[] areas, SectRupDistances[] dists) {
        if (areas == null) {
            return null;
        }
        boolean D = false;
        Preconditions.checkNotNull((Object)dists, (Object)"distances not calculated but removeOverlapsWithDist=true");
        ArrayList<DistSortableSections> sects = new ArrayList<DistSortableSections>();
        for (int s = 0; s < areas.length; ++s) {
            if (!(areas[s] > 0.0)) continue;
            Preconditions.checkNotNull((Object)dists[s]);
            sects.add(new DistSortableSections(s, this.rupSet.getFaultSectionData(s), dists[s], this.getPolygon(s), areas[s]));
        }
        Collections.sort(sects);
        for (int i = 0; i < sects.size(); ++i) {
            DistSortableSections s1 = (DistSortableSections)sects.get(i);
            if (s1.polygons == null) continue;
            for (int j = i + 1; j < sects.size(); ++j) {
                DistSortableSections s2 = (DistSortableSections)sects.get(j);
                if (s2.polygons == null) continue;
                boolean modified = false;
                ArrayList<Region> newRegions = new ArrayList<Region>();
                for (int k = 0; k < s2.polygons.size(); ++k) {
                    Region p2 = s2.polygons.get(k);
                    boolean any = false;
                    for (int l = 0; l < s1.polygons.size(); ++l) {
                        Region p1 = s1.polygons.get(l);
                        Region[] subtracted = Region.subtract(p2, p1);
                        if (subtracted == null) continue;
                        any = true;
                        for (Region newRegion : subtracted) {
                            newRegions.add(newRegion);
                        }
                    }
                    if (any) {
                        modified = true;
                        continue;
                    }
                    newRegions.add(p2);
                }
                if (!modified) continue;
                s2.polygons = newRegions.isEmpty() ? null : newRegions;
                s2.area = 0.0;
                for (Region region : newRegions) {
                    s2.area += surf.getAreaInsideRegion(region);
                }
            }
        }
        return sects;
    }

    private static void printRegionCode(Region region, String varName) {
        System.out.println("LocationList " + varName + "Border = new LocationList();");
        for (Location loc : region.getBorder()) {
            System.out.println(varName + "Border.add(new Location(" + loc.getLatitude() + ", " + loc.getLongitude() + "));");
        }
        System.out.println("Region " + varName + " = new Region(" + varName + "Border, null);");
        List<LocationList> interiors = region.getInteriors();
        if (interiors != null) {
            for (int i = 0; i < interiors.size(); ++i) {
                String lName = varName + "Int" + i;
                System.out.println("LocationList " + lName + " = new LocationList();");
                for (Location loc : interiors.get(i)) {
                    System.out.println(lName + ".add(new Location(" + loc.getLatitude() + ", " + loc.getLongitude() + "));");
                }
                System.out.println(varName + ".addInterior(new Region(" + lName + ", name));");
            }
        }
    }

    public Region getPolygon(int sectIndex) {
        return this.polygons[sectIndex];
    }

    /*
     * WARNING - void declaration
     */
    public void writeMatchMarkdown(File markdownDir, List<? extends ObsEqkRupture> ruptures, boolean replot) throws IOException {
        void var9_12;
        Preconditions.checkState((markdownDir.exists() || markdownDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(markdownDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Finite Fault Section Reset Results");
        lines.add("");
        ArrayList<ObsEqkRupture> finiteRups = new ArrayList<ObsEqkRupture>();
        boolean hasFSS = false;
        for (ObsEqkRupture obsEqkRupture : ruptures) {
            RuptureSurface surf = obsEqkRupture.getRuptureSurface();
            if (surf == null || surf instanceof PointSurface) continue;
            finiteRups.add(obsEqkRupture);
            hasFSS = hasFSS || obsEqkRupture instanceof ETAS_EqkRupture && ((ETAS_EqkRupture)obsEqkRupture).getFSSIndex() > 0;
        }
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (finiteRups.size() == ruptures.size()) {
            table.addLine("**# Ruptures**", ruptures.size());
        } else {
            table.addLine("**Input # Ruptures**", ruptures.size());
            table.addLine("**Ruptures w/ Finite Surfaces**", finiteRups.size());
        }
        table.addLine("**Min Area Fraction**&ast;", optionalDigitDF.format(this.minFractionalAreaInPolygon));
        Object var9_10 = null;
        if (this.polyManager instanceof FaultPolyMgr) {
            Double d = ((FaultPolyMgr)this.polyManager).getBuffer();
        }
        if (var9_12 != null) {
            table.addLine("**Fault Polygon Buffer**", optionalDigitDF.format(var9_12) + " [km]");
        }
        table.addLine("**Remove Polygon Overlap?**", this.removeOverlapsWithDist ? "Yes (sorted by mean section distance)" : "No");
        lines.addAll(table.build());
        lines.add("");
        lines.add("*&ast; Ruptures are considered to reset a fault section if at least this fraction of the section's area ruptures inside its polygon*");
        lines.add("");
        int u3ResultIndex = lines.size();
        int totNumU3 = 0;
        int totMatchesU3 = 0;
        if (finiteRups.isEmpty()) {
            lines.add("**No ruptures with finite surfaces!**");
        } else {
            int tocIndex = lines.size();
            String topLink = "*[(top)](#table-of-contents)*";
            String yes = "**YES**";
            String no = "*NO*";
            for (ObsEqkRupture rup : finiteRups) {
                RuptureSurface surf = rup.getRuptureSurface();
                int fssIndex = -1;
                if (rup instanceof ETAS_EqkRupture) {
                    fssIndex = ((ETAS_EqkRupture)rup).getFSSIndex();
                }
                Date date = new Date(rup.getOriginTime());
                String name = "M" + optionalDigitDF.format(rup.getMag()) + " on " + printDateFormat.format(date);
                System.out.println("Processing " + name);
                double[] areas = this.getAreaInSectionPolygons(surf);
                SectRupDistances[] dists = this.getSectRupDistances(surf, areas);
                double[] noOverlapAreas = null;
                FaultSectionDataMappingResult[] results = this.getMappingResults(surf, areas, dists);
                List<DistSortableSections> sectsNoOverlap = null;
                if (this.removeOverlapsWithDist && (sectsNoOverlap = this.removeOverlaps(surf, areas, dists)) != null) {
                    noOverlapAreas = new double[areas.length];
                    for (DistSortableSections sect : sectsNoOverlap) {
                        noOverlapAreas[sect.index] = sect.area;
                    }
                }
                List<FaultSection> matches = this.getMatchingSections(surf, areas, dists);
                List<FaultSection> fssSects = fssIndex < 0 ? null : this.rupSet.getFaultSectionDataForRupture(fssIndex);
                String prefix = fileDateFormat.format(date) + "_m" + optionalDigitDF.format(rup.getMag());
                if (replot || !new File(resourcesDir, prefix + ".png").exists()) {
                    this.plotMatchingSections(resourcesDir, prefix, surf, name, fssSects, "UCERF3-Mapped", results, sectsNoOverlap, null, false);
                }
                table = MarkdownUtils.tableBuilder();
                boolean any = false;
                table.initNewLine();
                table.addColumn("Section Index");
                table.addColumn("Section Name");
                table.addColumn("Match?");
                table.addColumn("Section Area");
                if (this.removeOverlapsWithDist) {
                    table.addColumn("Rup Area in Raw Poly");
                    table.addColumn("Rup Area in No-Overlap Poly");
                } else {
                    table.addColumn("Rup Area in Poly");
                }
                table.addColumn("Area Fraction");
                table.addColumn("Sect Distance To Rup");
                if (hasFSS) {
                    table.addColumn("UCERF3 Rupture Section?");
                }
                table.finalizeLine();
                boolean matchesU3 = true;
                for (int index = 0; index < this.rupSet.getNumSections(); ++index) {
                    double fract;
                    FaultSection sect = this.rupSet.getFaultSectionData(index);
                    double area = areas == null ? 0.0 : areas[index];
                    boolean match = matches != null && matches.contains(sect);
                    boolean fssMatch = fssSects != null && fssSects.contains(sect);
                    boolean bl = matchesU3 = matchesU3 && match == fssMatch;
                    if (area == 0.0 && !match && !fssMatch) continue;
                    any = true;
                    table.initNewLine();
                    table.addColumn(sect.getSectionId());
                    table.addColumn(sect.getSectionName());
                    table.addColumn(match ? yes : no);
                    table.addColumn(optionalDigitDF.format(this.sectAreas[index]) + " [km^2]");
                    table.addColumn(optionalDigitDF.format(area) + " [km^2]");
                    if (this.removeOverlapsWithDist) {
                        double noOverlapArea = noOverlapAreas == null ? 0.0 : noOverlapAreas[index];
                        table.addColumn(optionalDigitDF.format(noOverlapArea) + " [km^2]");
                        fract = noOverlapArea / this.sectAreas[index];
                    } else {
                        fract = area / this.sectAreas[index];
                    }
                    table.addColumn(optionalDigitDF.format(fract));
                    SectRupDistances dist = dists != null && dists[index] != null ? dists[index] : new SectRupDistances(this.getSectSurface(index), surf);
                    table.addColumn("mean=" + optionalDigitDF.format(dist.getMeanDist()) + " [" + optionalDigitDF.format(dist.getMinDist()) + " " + optionalDigitDF.format(dist.getMaxDist()) + "] [km]");
                    if (hasFSS) {
                        table.addColumn(fssMatch ? yes : no);
                    }
                    table.finalizeLine();
                }
                if (hasFSS && fssIndex >= 0) {
                    ++totNumU3;
                    name = name + ", UCERF3-mapped, match: ";
                    if (matchesU3) {
                        name = name + "YES";
                        ++totMatchesU3;
                    } else {
                        name = name + "NO";
                    }
                }
                lines.add("## " + name);
                lines.add(topLink);
                lines.add("");
                lines.add("![Map Plot](resources/" + prefix + ".png)");
                lines.add("");
                if (any) {
                    lines.add("");
                    lines.addAll(table.build());
                }
                lines.add("");
            }
            if (totNumU3 > 0) {
                ArrayList<String> u3Lines = new ArrayList<String>();
                u3Lines.add("### UCERF3 Mappings Summary");
                u3Lines.add("");
                u3Lines.add("This catalog contains UCERF3-mapped ruptures where we can compare this algorithm against the external UCERF3 mapping");
                u3Lines.add("");
                table = MarkdownUtils.tableBuilder();
                table.addLine("**# With UCERF3 Mappings**", totNumU3);
                double percent = (double)totMatchesU3 * 100.0 / (double)totNumU3;
                table.addLine("**Perfect Matches**", totMatchesU3 + " (" + optionalDigitDF.format(percent) + " %)");
                u3Lines.addAll(table.build());
                u3Lines.add("");
                lines.addAll(u3ResultIndex, u3Lines);
                tocIndex += u3Lines.size();
            }
            lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 4));
            lines.add(tocIndex, "## Table Of Contents");
        }
        MarkdownUtils.writeReadmeAndHTML(lines, markdownDir);
    }

    public void plotMatchingSections(File outputDir, String prefix, RuptureSurface surf, String title, Collection<FaultSectionPrefData> externalMatches, String externalName) throws IOException {
        double[] areas = this.getAreaInSectionPolygons(surf);
        SectRupDistances[] dists = this.getSectRupDistances(surf, areas);
        FaultSectionDataMappingResult[] results = this.getMappingResults(surf, areas, dists);
        List<DistSortableSections> sectsNoOverlap = this.removeOverlapsWithDist ? this.removeOverlaps(surf, areas, dists) : null;
        this.plotMatchingSections(outputDir, prefix, surf, title, externalMatches, externalName, results, sectsNoOverlap, null, false);
    }

    private void plotMatchingSections(File outputDir, String prefix, RuptureSurface surf, String title, Collection<? extends FaultSection> externalMatches, String externalName, FaultSectionDataMappingResult[] results, List<DistSortableSections> sectsNoOverlap, Location hypocenter, boolean annotateIndices) throws IOException {
        FaultSection sect;
        ArrayList<XYTextAnnotation> anns;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        DefaultXY_DataSet rupSurfXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics rupSurfChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.125f, COLOR_RUP_SURFACE);
        for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
            rupSurfXY.set(loc.getLongitude(), loc.getLatitude());
        }
        if (hypocenter != null) {
            DefaultXY_DataSet hypoXY = new DefaultXY_DataSet();
            hypoXY.setName("Hypocenter");
            hypoXY.set(hypocenter.getLongitude(), hypocenter.getLatitude());
            funcs.add(hypoXY);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, Color.RED));
        }
        rupSurfXY.setName("Rupture Surface");
        funcs.add(rupSurfXY);
        chars.add(rupSurfChar);
        DefaultXY_DataSet matchXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics matchPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.5f, COLOR_MATCH);
        PlotCurveCharacterstics matchPolyOrigChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, COLOR_MATCH);
        PlotCurveCharacterstics matchPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COLOR_MATCH);
        DefaultXY_DataSet noMatch_externalMatchXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics noMatch_externalMatchPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.5f, COLOR_NO_MATCH_EXTERNAL_MATCH);
        PlotCurveCharacterstics noMatch_externalMatchPolyOrigChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, COLOR_NO_MATCH_EXTERNAL_MATCH);
        PlotCurveCharacterstics noMatch_externalMatchPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COLOR_NO_MATCH_EXTERNAL_MATCH);
        DefaultXY_DataSet match_noExternalXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics match_noExternalPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.5f, COLOR_MATCH_EXTERNAL_NO_MATCH);
        PlotCurveCharacterstics match_noExternalPolyOrigChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, COLOR_MATCH_EXTERNAL_NO_MATCH);
        PlotCurveCharacterstics match_noExternalPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COLOR_MATCH_EXTERNAL_NO_MATCH);
        DefaultXY_DataSet hasAreaXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics hasAreaPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 1.5f, COLOR_HAS_AREA_NO_MATCH);
        PlotCurveCharacterstics hasAreaPolyOrigChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, COLOR_HAS_AREA_NO_MATCH);
        PlotCurveCharacterstics hasAreaPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COLOR_HAS_AREA_NO_MATCH);
        DefaultXY_DataSet noAreaXY = new DefaultXY_DataSet();
        PlotCurveCharacterstics noAreaPointChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, Math.min(1.0f, 1.5f), COLOR_NO_AREA);
        PlotCurveCharacterstics noAreaPolyChar = new PlotCurveCharacterstics(PlotLineType.SOLID, Math.min(1.0f, 2.0f), COLOR_NO_AREA);
        ArrayList<XYTextAnnotation> arrayList = anns = annotateIndices ? new ArrayList<XYTextAnnotation>() : null;
        if (sectsNoOverlap != null) {
            for (DistSortableSections sectNoOverlap : sectsNoOverlap) {
                sect = sectNoOverlap.sect;
                int index = sectNoOverlap.index;
                boolean hasArea = results != null && results[index].areaInPoly > 0.0;
                boolean match = results != null && results[index].match;
                RuptureSurface sectSurface = this.getSectSurface(index);
                if (annotateIndices && hasArea) {
                    Location center;
                    if (sectSurface instanceof EvenlyGriddedSurface) {
                        EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)sectSurface;
                        center = (Location)gridSurf.get(gridSurf.getNumRows() / 2, gridSurf.getNumCols() / 2);
                    } else {
                        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
                        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
                        for (Object loc : sectSurface.getEvenlyDiscritizedListOfLocsOnSurface()) {
                            latTrack.addValue(((Location)loc).getLatitude());
                            lonTrack.addValue(((Location)loc).getLongitude());
                        }
                        center = new Location(latTrack.getAverage(), lonTrack.getAverage());
                    }
                    double x = center.getLongitude();
                    double y = center.getLatitude();
                    XYTextAnnotation ann = new XYTextAnnotation("" + index, x, y);
                    ann.setFont(new Font("SansSerif", 1, 12));
                    ann.setTextAnchor(TextAnchor.CENTER);
                    ann.setBackgroundPaint((Paint)new Color(255, 255, 255, 200));
                    anns.add(ann);
                }
                PlotCurveCharacterstics polyChar = null;
                if (externalMatches != null) {
                    Preconditions.checkNotNull((Object)externalName);
                    boolean externalMatch = externalMatches.contains(sect);
                    if (match) {
                        polyChar = externalMatch ? matchPolyChar : match_noExternalPolyChar;
                    } else if (externalMatch) {
                        polyChar = noMatch_externalMatchPolyChar;
                    }
                } else if (match) {
                    polyChar = matchPolyChar;
                }
                if (polyChar == null && hasArea) {
                    polyChar = hasAreaPolyChar;
                }
                if (polyChar == null || sectNoOverlap.polygons == null) continue;
                for (Region poly : sectNoOverlap.polygons) {
                    Object loc;
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    loc = poly.getBorder().iterator();
                    while (loc.hasNext()) {
                        Location loc2 = (Location)loc.next();
                        xy.set(loc2.getLongitude(), loc2.getLatitude());
                    }
                    xy.set(xy.get(0));
                    funcs.add(xy);
                    chars.add(polyChar);
                    List<LocationList> interiors = poly.getInteriors();
                    if (interiors == null) continue;
                    for (LocationList locationList : interiors) {
                        xy = new DefaultXY_DataSet();
                        for (Location loc3 : locationList) {
                            xy.set(loc3.getLongitude(), loc3.getLatitude());
                        }
                        xy.set(xy.get(0));
                        funcs.add(xy);
                        chars.add(polyChar);
                    }
                }
            }
        }
        ArrayList<Integer> noAreaIndexes = new ArrayList<Integer>();
        for (int index = 0; index < this.rupSet.getNumSections(); ++index) {
            sect = this.rupSet.getFaultSectionData(index);
            boolean hasArea = results != null && results[index].areaInPoly > 0.0;
            boolean match = results != null && results[index].match;
            boolean added = false;
            if (externalMatches != null) {
                Preconditions.checkNotNull((Object)externalName);
                boolean externalMatch = externalMatches.contains(sect);
                if (match) {
                    if (externalMatch) {
                        FiniteFaultSectionResetCalc.addSurface(this.getSectSurface(index), matchXY);
                        funcs.add(this.getSectPolygonXY(index));
                        chars.add(sectsNoOverlap == null ? matchPolyChar : matchPolyOrigChar);
                    } else {
                        FiniteFaultSectionResetCalc.addSurface(this.getSectSurface(index), match_noExternalXY);
                        funcs.add(this.getSectPolygonXY(index));
                        chars.add(sectsNoOverlap == null ? match_noExternalPolyChar : match_noExternalPolyOrigChar);
                    }
                    added = true;
                } else if (externalMatch) {
                    FiniteFaultSectionResetCalc.addSurface(this.getSectSurface(index), noMatch_externalMatchXY);
                    funcs.add(this.getSectPolygonXY(index));
                    chars.add(sectsNoOverlap == null ? noMatch_externalMatchPolyChar : noMatch_externalMatchPolyOrigChar);
                    added = true;
                }
            } else if (match) {
                FiniteFaultSectionResetCalc.addSurface(this.getSectSurface(index), matchXY);
                funcs.add(this.getSectPolygonXY(index));
                chars.add(sectsNoOverlap == null ? matchPolyChar : matchPolyOrigChar);
                added = true;
            }
            if (added) continue;
            if (hasArea) {
                FiniteFaultSectionResetCalc.addSurface(this.getSectSurface(index), hasAreaXY);
                funcs.add(this.getSectPolygonXY(index));
                chars.add(sectsNoOverlap == null ? hasAreaPolyChar : hasAreaPolyOrigChar);
                continue;
            }
            noAreaIndexes.add(index);
        }
        if (matchXY.size() > 0) {
            if (externalMatches != null && externalName != null) {
                matchXY.setName("Match & " + externalName);
            } else {
                matchXY.setName("Match");
            }
            funcs.add(matchXY);
            chars.add(matchPointChar);
        }
        if (match_noExternalXY.size() > 0) {
            match_noExternalXY.setName("Match, but not " + externalName);
            funcs.add(match_noExternalXY);
            chars.add(match_noExternalPointChar);
        }
        if (noMatch_externalMatchXY.size() > 0) {
            noMatch_externalMatchXY.setName("No Match, but " + externalName);
            funcs.add(noMatch_externalMatchXY);
            chars.add(noMatch_externalMatchPointChar);
        }
        if (hasAreaXY.size() > 0) {
            hasAreaXY.setName("Has Area");
            funcs.add(hasAreaXY);
            chars.add(hasAreaPointChar);
        }
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (XY_DataSet func : funcs) {
            latTrack.addValue(func.getMinY());
            latTrack.addValue(func.getMaxY());
            lonTrack.addValue(func.getMinX());
            lonTrack.addValue(func.getMaxX());
        }
        double centerLat = 0.5 * (latTrack.getMin() + latTrack.getMax());
        double centerLon = 0.5 * (lonTrack.getMin() + lonTrack.getMax());
        double maxSpan = Math.max(latTrack.getMax() - latTrack.getMin(), lonTrack.getMax() - lonTrack.getMin());
        double centerBuffer = 0.5 * maxSpan + 0.2;
        if (centerBuffer < 0.5) {
            centerBuffer = 0.5;
        }
        Region plotReg = new Region(new Location(centerLat - centerBuffer, centerLon - centerBuffer), new Location(centerLat + centerBuffer, centerLon + centerBuffer));
        PlotCurveCharacterstics caChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COLOR_CA_OUTLINE);
        for (XY_DataSet xy : PoliticalBoundariesData.loadCAOutlines()) {
            funcs.add(xy);
            chars.add(caChar);
        }
        Iterator iterator = noAreaIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            RuptureSurface sectSurface = this.getSectSurface(index);
            if (sectSurface.getAveDip() == 90.0) {
                FiniteFaultSectionResetCalc.addSurface(sectSurface.getEvenlyDiscritizedUpperEdge(), noAreaXY, plotReg);
            } else {
                FiniteFaultSectionResetCalc.addSurface(sectSurface.getEvenlyDiscritizedPerimeter(), noAreaXY, plotReg);
            }
            XY_DataSet polygon = this.getSectPolygonXY(index);
            boolean inside = false;
            for (Point2D pt : polygon) {
                if (!plotReg.contains(new Location(pt.getY(), pt.getX()))) continue;
                inside = true;
            }
            if (!inside) continue;
            funcs.add(this.getSectPolygonXY(index));
            chars.add(noAreaPolyChar);
        }
        if (noAreaXY.size() > 0) {
            noAreaXY.setName("No Area");
            funcs.add(noAreaXY);
            chars.add(noAreaPointChar);
        }
        PlotSpec plotSpec = new PlotSpec(funcs, chars, title, "Longitude", "Latitude");
        plotSpec.setLegendVisible(true);
        plotSpec.setPlotAnnotations(anns);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setBackgroundColor(Color.WHITE);
        Range xRange = new Range(plotReg.getMinLon(), plotReg.getMaxLon());
        Range yRange = new Range(plotReg.getMinLat(), plotReg.getMaxLat());
        gp.drawGraphPanel(plotSpec, false, false, xRange, yRange);
        double tick = maxSpan > 3.0 ? 1.0 : (maxSpan > 1.5 ? 0.5 : (maxSpan > 0.8 ? 0.25 : 0.1));
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(tick);
        tus.add((TickUnit)tu);
        gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
        gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(800, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
    }

    private static void addSurface(RuptureSurface surf, XY_DataSet xy) {
        if (surf instanceof EvenlyGriddedSurface) {
            FiniteFaultSectionResetCalc.addSurface(surf.getEvenlyDiscritizedPerimeter(), xy, null);
        } else {
            FiniteFaultSectionResetCalc.addSurface(surf.getEvenlyDiscritizedListOfLocsOnSurface(), xy, null);
        }
    }

    private static void addSurface(LocationList surfLocs, XY_DataSet xy, Region plotReg) {
        for (Location loc : surfLocs) {
            if (plotReg != null && !plotReg.contains(loc)) continue;
            xy.set(loc.getLongitude(), loc.getLatitude());
        }
    }

    private synchronized XY_DataSet getSectPolygonXY(int index) {
        if (this.sectPolygonXYs == null) {
            this.sectPolygonXYs = new DefaultXY_DataSet[this.rupSet.getNumSections()];
        }
        if (this.sectPolygonXYs[index] == null) {
            this.sectPolygonXYs[index] = new DefaultXY_DataSet();
            for (Location loc : this.getPolygon(index).getBorder()) {
                this.sectPolygonXYs[index].set(loc.getLongitude(), loc.getLatitude());
            }
            this.sectPolygonXYs[index].set(this.sectPolygonXYs[index].get(0));
        }
        return this.sectPolygonXYs[index];
    }

    public List<String> writeSectionResetMarkdown(File outputDir, String relativePathToOutputDir, String topLevelHeading, String topLink, RuptureSurface surf, Location hypocenter) throws IOException {
        return this.writeSectionResetMarkdown(outputDir, relativePathToOutputDir, topLevelHeading, topLink, surf, hypocenter, null);
    }

    public List<String> writeSectionResetMarkdown(File outputDir, String relativePathToOutputDir, String topLevelHeading, String topLink, RuptureSurface surf, Location hypocenter, String eventID) throws IOException {
        double[] areas;
        ArrayList<String> lines = new ArrayList<String>();
        if (eventID == null || eventID.isEmpty()) {
            lines.add(topLevelHeading + " Possible Finite Rupture Subsection Mappings");
        } else {
            lines.add(topLevelHeading + " " + eventID + " Possible Finite Rupture Subsection Mappings");
        }
        lines.add(topLink);
        lines.add("");
        lines.add("This gives any possible finite rupture surface subsection mappings. In the plot below, potentially suggested subsections are outlined in green, and all subsections for which any of this rupture is within the fault polygon are in gray. Suggested sections are those for which the area of the input rupture within the polygon is at least " + (float)(this.minFractionalAreaInPolygon * 100.0) + " % of the sub section area");
        lines.add("");
        if (this.removeOverlapsWithDist) {
            lines.add("Overlapping polygons are removed according to the mean distance of the actual subsection surface, with the polygons of closer sections masking out the polygons of further sections");
        }
        lines.add("");
        boolean pointSource = surf.isPointSurface();
        if (pointSource) {
            lines.add("As this is a point source, there will be no matches, but sections within 25km will be listed");
            lines.add("");
        }
        Object prefix = "finite_rup_subsection_mappings";
        if (eventID != null && !eventID.isEmpty()) {
            prefix = (String)prefix + "_" + eventID;
        }
        if ((areas = this.getAreaInSectionPolygons(surf)) == null) {
            areas = new double[this.rupSet.getNumSections()];
        }
        SectRupDistances[] dists = this.getSectRupDistances(surf, areas, pointSource);
        List<DistSortableSections> sectsNoOverlap = this.removeOverlapsWithDist ? this.removeOverlaps(surf, areas, dists) : null;
        FaultSectionDataMappingResult[] results = this.getMappingResults(surf, areas, dists);
        this.plotMatchingSections(outputDir, (String)prefix, surf, "Subsection Mappings", null, null, results, sectsNoOverlap, hypocenter, true);
        lines.add("![Map](" + relativePathToOutputDir + "/" + (String)prefix + ".png)");
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Section Index");
        table.addColumn("Section Name");
        table.addColumn("Suggested Match?");
        table.addColumn("Section Area");
        if (!pointSource) {
            if (this.removeOverlapsWithDist) {
                table.addColumn("Rup Area in Raw Poly");
                table.addColumn("Rup Area in No-Overlap Poly");
            } else {
                table.addColumn("Rup Area in Poly");
            }
            table.addColumn("Area Fraction");
        }
        table.addColumn("Sect Distance To Rup");
        table.addColumn("Hypocenter in Polygon?");
        table.finalizeLine();
        for (int s = 0; s < results.length; ++s) {
            boolean include;
            FaultSectionDataMappingResult result = results[s];
            boolean containsHypo = this.polygons[s].contains(hypocenter);
            boolean bl = include = containsHypo || result.areaInPoly > 0.0 || result.match || areas[s] > 0.0 || pointSource && result.dist != null && result.dist.minDist < 25.0;
            if (!include) continue;
            FaultSection sect = this.rupSet.getFaultSectionData(s);
            table.initNewLine();
            table.addColumn(s);
            table.addColumn(sect.getSectionName());
            table.addColumn(result.match ? "*yes*" : "no");
            table.addColumn(optionalDigitDF.format(result.sectArea));
            if (!pointSource) {
                if (this.removeOverlapsWithDist) {
                    table.addColumn(optionalDigitDF.format(areas[s]));
                }
                table.addColumn(optionalDigitDF.format(result.areaInPoly));
                table.addColumn(optionalDigitDF.format(result.fractOfSurfInPoly));
            }
            SectRupDistances dist = result.dist;
            table.addColumn("mean=" + optionalDigitDF.format(dist.getMeanDist()) + " [" + optionalDigitDF.format(dist.getMinDist()) + " " + optionalDigitDF.format(dist.getMaxDist()) + "] [km]");
            table.addColumn(containsHypo ? "*yes*" : "no");
            table.finalizeLine();
        }
        lines.addAll(table.build());
        return lines;
    }

    public static void writeParamSweepMarkdown(File markdownDir, FaultSystemSolution sol, int threads) throws IOException {
        Preconditions.checkState((markdownDir.exists() || markdownDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(markdownDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Finite Fault Section Reset Parameter Sweep");
        lines.add("");
        EvenlyDiscretizedFunc faultBufferFunc = new EvenlyDiscretizedFunc(1.0, 12.0, 12);
        EvenlyDiscretizedFunc fractAreaFunc = new EvenlyDiscretizedFunc(0.1, 1.0, 10);
        FaultSystemRupSet rupSet = sol.getRupSet();
        RuptureSurface[] surfs = new RuptureSurface[rupSet.getNumRuptures()];
        double totRate = sol.getTotalRateForAllFaultSystemRups();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            surfs[r] = rupSet.getSurfaceForRupture(r, 1.0);
        }
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        for (boolean removeOverlap : new boolean[]{false, true}) {
            if (removeOverlap) {
                lines.add("## Removing Overlap from Polygons (rupture distance sorted)");
            } else {
                lines.add("## Retaining All Overlapping Polygons");
            }
            lines.add("");
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Fault Buffer", "Min Area Fraction", "Match Count", "Match Fraction", "Match Rate", "Match Rate Fraction");
            double[][] matchRates = new double[faultBufferFunc.size()][fractAreaFunc.size()];
            int[][] matchCounts = new int[faultBufferFunc.size()][fractAreaFunc.size()];
            ArrayList<Future<ParamSweepCallable>> futures = new ArrayList<Future<ParamSweepCallable>>();
            for (int i = 0; i < faultBufferFunc.size(); ++i) {
                double d = faultBufferFunc.getX(i);
                futures.add(exec.submit(new ParamSweepCallable(sol, surfs, i, d, fractAreaFunc, removeOverlap)));
            }
            System.out.println("Waiting on " + futures.size() + " futures");
            for (Future future : futures) {
                try {
                    ParamSweepCallable result = (ParamSweepCallable)future.get();
                    for (int i = 0; i < fractAreaFunc.size(); ++i) {
                        ArrayList<CallSite> line = new ArrayList<CallSite>();
                        line.add((CallSite)((Object)("" + (float)result.faultBuffer)));
                        line.add((CallSite)((Object)("" + (float)result.fractAreas.getClosestXIndex(i))));
                        line.add((CallSite)((Object)("" + result.matchCounts[i])));
                        line.add((CallSite)((Object)("" + (float)((double)result.matchCounts[i] / (double)rupSet.getNumRuptures()))));
                        line.add((CallSite)((Object)("" + (float)result.matchRates[i])));
                        line.add((CallSite)((Object)("" + (float)(result.matchRates[i] / totRate))));
                        csv.addLine((List<String>)line);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            String csvName = removeOverlap ? "results_remove_overlap.csv" : "results_retain_overlap.csv";
            csv.writeToFile(new File(resourcesDir, csvName));
        }
        MarkdownUtils.writeReadmeAndHTML(lines, markdownDir);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File etasInputDir = new File("/home/kevin/git/ucerf3-etas-launcher/inputs");
        boolean doSweep = true;
        boolean doHistorical = false;
        if (doSweep) {
            System.out.println("Doing sweep");
            U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(new File(etasInputDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip"));
            File markdownDir = new File("/home/kevin/git/misc-research/ucerf3_etas/finite_section_mapping/param_sweep");
            Preconditions.checkState((markdownDir.exists() || markdownDir.mkdir() ? 1 : 0) != 0);
            int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 6);
            FiniteFaultSectionResetCalc.writeParamSweepMarkdown(markdownDir, sol, threads);
        }
        if (doHistorical) {
            System.out.println("Doing historical");
            File catFile = new File(etasInputDir, "u3_historical_catalog.txt");
            File xmlFile = new File(etasInputDir, "u3_historical_catalog_finite_fault_mappings.xml");
            File mainOutputDir = new File("/home/kevin/git/misc-research/ucerf3_etas/finite_section_mapping");
            HashMap<FaultModels, U3FaultSystemRupSet> rupSetMap = new HashMap<FaultModels, U3FaultSystemRupSet>();
            U3FaultSystemRupSet rupSet31 = U3FaultSystemIO.loadRupSet(new File(etasInputDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip"));
            rupSetMap.put(FaultModels.FM3_1, rupSet31);
            double[] minFracts = new double[]{0.5};
            double[] faultBuffers = new double[]{12.0, 1.0};
            boolean[] removeOverlaps = new boolean[]{true, false};
            boolean replot = true;
            for (FaultModels fm : rupSetMap.keySet()) {
                System.out.println("Doing " + String.valueOf(fm));
                FaultSystemRupSet rupSet = (FaultSystemRupSet)rupSetMap.get(fm);
                ObsEqkRupList inputRups = UCERF3_CatalogParser.loadCatalog(catFile);
                FiniteFaultMappingData.loadRuptureSurfaces(xmlFile, inputRups, fm, rupSet);
                for (double faultBuffer : faultBuffers) {
                    for (double minFract : minFracts) {
                        for (boolean removeOverlap : removeOverlaps) {
                            String dirName = "u3_catalog-" + fm.encodeChoiceString() + "-minFract" + (float)minFract + "-polyBuffer" + (float)faultBuffer;
                            if (removeOverlap) {
                                dirName = dirName + "-removeOverlap";
                            }
                            File markdownDir = new File(mainOutputDir, dirName);
                            System.out.println("Fault buffer: " + faultBuffer);
                            System.out.println("Minimum fract inside polygon: " + minFract);
                            System.out.println("Remove overlap? " + removeOverlap);
                            FaultPolyMgr polyManager = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), faultBuffer);
                            FiniteFaultSectionResetCalc calc = new FiniteFaultSectionResetCalc(rupSet, polyManager, minFract, removeOverlap);
                            calc.writeMatchMarkdown(markdownDir, inputRups, replot);
                        }
                    }
                }
            }
        }
    }

    public class SectRupDistances {
        final double minDist;
        final double maxDist;
        final double meanDist;

        private SectRupDistances(RuptureSurface sectSurf, RuptureSurface rupSurf) {
            double minDist = Double.POSITIVE_INFINITY;
            double maxDist = 0.0;
            double meanDist = 0.0;
            int numPoints = 0;
            LocationList rupLocs = rupSurf.getEvenlyDiscritizedListOfLocsOnSurface();
            for (Location loc : sectSurf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                double dist = Double.POSITIVE_INFINITY;
                for (Location loc2 : rupLocs) {
                    dist = Math.min(dist, LocationUtils.linearDistanceFast(loc, loc2));
                }
                minDist = Math.min(minDist, dist);
                maxDist = Math.max(maxDist, dist);
                meanDist += dist;
                ++numPoints;
            }
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.meanDist = meanDist /= (double)numPoints;
        }

        public double getMinDist() {
            return this.minDist;
        }

        public double getMaxDist() {
            return this.maxDist;
        }

        public double getMeanDist() {
            return this.meanDist;
        }
    }

    public class FaultSectionDataMappingResult {
        public final FaultSection sect;
        public final SectRupDistances dist;
        public final double areaInPoly;
        public final double sectArea;
        public final double fractOfSurfInPoly;
        public final boolean match;

        public FaultSectionDataMappingResult(FaultSection sect, SectRupDistances dist, double areaInPoly, double sectArea) {
            this.sect = sect;
            this.dist = dist;
            this.areaInPoly = areaInPoly;
            this.sectArea = sectArea;
            this.fractOfSurfInPoly = areaInPoly / sectArea;
            this.match = this.fractOfSurfInPoly >= FiniteFaultSectionResetCalc.this.minFractionalAreaInPolygon;
        }
    }

    private class DistSortableSections
    implements Comparable<DistSortableSections> {
        private final int index;
        private final FaultSection sect;
        private final SectRupDistances dist;
        private List<Region> polygons;
        private double area;

        public DistSortableSections(int index, FaultSection sect, SectRupDistances dist, Region polygon, double area) {
            this.index = index;
            this.sect = sect;
            this.dist = dist;
            this.polygons = new ArrayList<Region>();
            this.polygons.add(polygon);
            this.area = area;
        }

        @Override
        public int compareTo(DistSortableSections o) {
            return Double.compare(this.dist.getMeanDist(), o.dist.getMeanDist());
        }
    }

    private static class ParamSweepCallable
    implements Callable<ParamSweepCallable> {
        private final FaultSystemSolution sol;
        private final RuptureSurface[] surfs;
        private final int bufferIndex;
        private final double faultBuffer;
        private final EvenlyDiscretizedFunc fractAreas;
        private final boolean removeOverlap;
        private double[] matchRates;
        private int[] matchCounts;

        public ParamSweepCallable(FaultSystemSolution sol, RuptureSurface[] surfs, int bufferIndex, double faultBuffer, EvenlyDiscretizedFunc fractAreas, boolean removeOverlap) {
            this.sol = sol;
            this.surfs = surfs;
            this.bufferIndex = bufferIndex;
            this.faultBuffer = faultBuffer;
            this.fractAreas = fractAreas;
            this.removeOverlap = removeOverlap;
        }

        @Override
        public ParamSweepCallable call() throws Exception {
            Double buf;
            FaultSystemRupSet rupSet = this.sol.getRupSet();
            FaultPolyMgr polyManager = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), this.faultBuffer);
            FiniteFaultSectionResetCalc calc = new FiniteFaultSectionResetCalc(rupSet, polyManager, this.fractAreas.getX(0), this.removeOverlap);
            this.matchRates = new double[this.fractAreas.size()];
            this.matchCounts = new int[this.fractAreas.size()];
            for (int r = 0; r < this.surfs.length; ++r) {
                double[] areas;
                if (r % 1000 == 0) {
                    System.out.println("Rupture " + r);
                }
                if ((areas = calc.getAreaInSectionPolygons(this.surfs[r])) == null) continue;
                SectRupDistances[] dists = this.removeOverlap ? calc.getSectRupDistances(this.surfs[r], areas) : null;
                FaultSectionDataMappingResult[] results = calc.getMappingResults(this.surfs[r], areas, dists);
                List<FaultSection> sects = rupSet.getFaultSectionDataForRupture(r);
                for (int i = 0; i < this.matchRates.length; ++i) {
                    calc.minFractionalAreaInPolygon = this.fractAreas.getX(i);
                    List<FaultSection> matches = calc.getMatchingSections(results);
                    if (matches == null || matches.size() != sects.size()) continue;
                    boolean match = true;
                    for (FaultSection sect : sects) {
                        if (matches.contains(sect)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    int n = i;
                    this.matchCounts[n] = this.matchCounts[n] + 1;
                    int n2 = i;
                    this.matchRates[n2] = this.matchRates[n2] + this.sol.getRateForRup(r);
                }
            }
            Float faultBuffer = null;
            if (polyManager instanceof FaultPolyMgr && (buf = polyManager.getBuffer()) != null) {
                faultBuffer = Float.valueOf(buf.floatValue());
            }
            System.out.println("buffer=" + faultBuffer + "\tremoveOverlap=" + this.removeOverlap);
            for (int i = 0; i < this.matchCounts.length; ++i) {
                System.out.println("\tfractArea=" + (float)this.fractAreas.getX(i));
                System.out.println("\t" + this.matchCounts[i] + "/" + rupSet.getNumRuptures() + " matches (" + optionalDigitDF.format(100.0 * (double)this.matchCounts[i] / (double)rupSet.getNumRuptures()) + " %)");
                double totRate = this.sol.getTotalRateForAllFaultSystemRups();
                System.out.println("\t" + (float)this.matchRates[i] + "/" + (float)totRate + " matches (" + optionalDigitDF.format(100.0 * this.matchRates[i] / totRate) + " %)");
            }
            return this;
        }
    }
}

