/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Shaw_2009_ModifiedMagAreaRel;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSurfaceImpl;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.erf.ETAS.association.ArbitrarilyDiscretizedSurface;

public class JeanneFileLoader {
    private static final boolean D = true;
    private static DateFormat printDateFormat = new SimpleDateFormat("yyyy/MM/dd kk:mm");
    private static DateFormat idDateFormat = new SimpleDateFormat("yyyyMMddkkmm");
    public static final TimeZone utc = TimeZone.getTimeZone("UTC");
    private static MagAreaRelationship magArea;

    public static List<ObsEqkRupture> loadFiniteRups(File finiteFile, List<? extends ObsEqkRupture> inputRups) throws IOException {
        String line;
        HashMap finiteLocs = Maps.newHashMap();
        BufferedReader read = new BufferedReader(new FileReader(finiteFile));
        while ((line = read.readLine()) != null) {
            if ((line = line.trim()).startsWith("UCERF3") || line.isEmpty()) continue;
            while (line.contains("  ")) {
                line = line.replaceAll("  ", " ");
            }
            String[] split = line.split(" ");
            Preconditions.checkState((split.length == 4 ? 1 : 0) != 0);
            double depth = Double.parseDouble(split[2]);
            if (depth == 0.0) {
                depth = 0.0;
            }
            depth = (double)Math.round(depth * 1000.0) / 1000.0;
            Location loc = new Location(Double.parseDouble(split[0]), Double.parseDouble(split[1]), depth);
            String id = split[3];
            List locs = (List)finiteLocs.get(id);
            if (locs == null) {
                locs = Lists.newArrayList();
                finiteLocs.put(id, locs);
            }
            locs.add(loc);
        }
        read.close();
        ArrayList matches = Lists.newArrayList();
        for (String id : finiteLocs.keySet()) {
            RuptureSurface surf;
            System.out.println("Processing " + id);
            try {
                surf = JeanneFileLoader.buildSurf((List)finiteLocs.get(id));
            }
            catch (Exception e) {
                System.err.println("Failed to create evenly gridded, doing arbitrary: " + e.getMessage());
                LocationList locList = new LocationList();
                locList.addAll((Collection)finiteLocs.get(id));
                surf = new ArbitrarilyDiscretizedSurface(locList);
            }
            ObsEqkRupture rup = JeanneFileLoader.getForID(id, inputRups, surf);
            if (rup != null) {
                rup.setRuptureSurface(surf);
                matches.add(rup);
            }
            System.out.println("Match: " + JeanneFileLoader.getRupStr(rup));
            System.out.println("***********************************");
        }
        return matches;
    }

    public static String getRupStr(ObsEqkRupture rup) {
        if (rup == null) {
            return "(None)";
        }
        return printDateFormat.format(new Date(rup.getOriginTime())) + ": M" + rup.getMag();
    }

    private static ObsEqkRupture getForID(String id, List<? extends ObsEqkRupture> inputRups, RuptureSurface surf) {
        Date date;
        for (ObsEqkRupture obsEqkRupture : inputRups) {
            if (!obsEqkRupture.getEventId().equals(id)) continue;
            return obsEqkRupture;
        }
        if (id.length() != 12) {
            return null;
        }
        try {
            date = idDateFormat.parse(id);
        }
        catch (ParseException parseException) {
            System.err.println("Date parse error: " + parseException.getMessage());
            return null;
        }
        long l = date.getTime();
        long minDelta = Long.MAX_VALUE;
        ArrayList deltas = Lists.newArrayList();
        ArrayList rups = Lists.newArrayList();
        rups.addAll(inputRups);
        for (ObsEqkRupture rup : rups) {
            long delta = l - rup.getOriginTime();
            if (delta < 0L) {
                delta = -delta;
            }
            if (delta == 0L) {
                return rup;
            }
            if (delta < minDelta) {
                minDelta = delta;
            }
            deltas.add(delta);
        }
        double estMag = magArea.getMedianMag(surf.getArea());
        System.out.println("No exact match. Min delta: " + minDelta + ". Date: " + printDateFormat.format(date) + " Est Mag: " + estMag);
        List pairings = ComparablePairing.build(deltas, rups);
        Collections.sort(pairings);
        double closestMag = Double.POSITIVE_INFINITY;
        ObsEqkRupture match = null;
        for (ComparablePairing pairing : pairings) {
            long delta = (Long)pairing.getComparable();
            ObsEqkRupture rup = (ObsEqkRupture)pairing.getData();
            if (delta > 86400000L) break;
            double magDelta = Math.abs(estMag - rup.getMag());
            System.out.println("\tCandidate: " + JeanneFileLoader.getRupStr(rup) + " (Time delta=" + delta + ", Mag delta: " + magDelta + ")");
            if (delta < 100000L && magDelta < 0.5 && !id.equals("187203261406")) {
                return rup;
            }
            if (!(magDelta < closestMag)) continue;
            closestMag = magDelta;
            match = rup;
        }
        System.out.println("\tMatching to rupture by mag: " + JeanneFileLoader.getRupStr(match));
        return match;
    }

    private static EvenlyGriddedSurface buildSurf(List<Location> locs) {
        HashMap depthBinned = Maps.newHashMap();
        for (Location loc : locs) {
            Double depth = loc.getDepth();
            List depthLocs = (List)depthBinned.get(depth);
            if (depthLocs == null) {
                depthLocs = Lists.newArrayList();
                depthBinned.put(depth, depthLocs);
            }
            depthLocs.add(loc);
        }
        int rows = depthBinned.size();
        System.out.println("Found " + rows + " unique depths");
        int cols = -1;
        ArrayList depths = Lists.newArrayList(depthBinned.keySet());
        Collections.sort(depths);
        ArrayList locsByRow = Lists.newArrayList();
        for (int row = 0; row < rows; ++row) {
            Double depth = (Double)depths.get(row);
            List locsAtDepth = (List)depthBinned.get(depth);
            if (cols < 0) {
                cols = locsAtDepth.size();
            } else {
                Preconditions.checkState((cols == locsAtDepth.size() ? 1 : 0) != 0, (String)"Gridding columns mismatch. Expected %s got %s, r=%s, d=%s", (Object)cols, (Object)locsAtDepth.size(), (Object)row, (Object)depth);
            }
            locsByRow.add(locsAtDepth);
        }
        Preconditions.checkState((locsByRow.size() == rows ? 1 : 0) != 0);
        Preconditions.checkState((cols > 1 ? 1 : 0) != 0, (Object)"Must have at least 2 columns per row");
        double latDelta = 0.0;
        double lonDelta = 0.0;
        List firstRow = (List)locsByRow.get(0);
        for (int i = 0; i < cols; ++i) {
            Location l1 = (Location)firstRow.get(i);
            for (int j = i + 1; j < cols; ++j) {
                Location l2 = (Location)firstRow.get(j);
                latDelta = Math.max(latDelta, Math.abs(l1.getLatitude() - l2.getLatitude()));
                lonDelta = Math.max(lonDelta, Math.abs(l1.getLongitude() - l2.getLongitude()));
            }
        }
        LocComparator comp = new LocComparator(latDelta > lonDelta);
        for (List rowLocs : locsByRow) {
            Collections.sort(rowLocs, comp);
        }
        double gridSpacing = LocationUtils.horzDistanceFast((Location)firstRow.get(0), (Location)firstRow.get(1));
        System.out.println("Surface size: " + rows + " x " + cols + ". Spacing: " + gridSpacing);
        GriddedSurfaceImpl surf = new GriddedSurfaceImpl(rows, cols, gridSpacing);
        for (int row = 0; row < rows; ++row) {
            List rowLocs = (List)locsByRow.get(row);
            for (int col = 0; col < cols; ++col) {
                surf.set(row, col, (Location)rowLocs.get(col));
            }
        }
        return surf;
    }

    public static void main(String[] args) throws IOException {
        File finiteFile = new File("/home/kevin/OpenSHA/UCERF3/historical_finite_fault_mapping/UCERF3_finite.dat");
        ObsEqkRupList inputRups = UCERF3_CatalogParser.loadCatalog(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt"));
        JeanneFileLoader.loadFiniteRups(finiteFile, inputRups);
    }

    static {
        idDateFormat.setTimeZone(utc);
        magArea = new Shaw_2009_ModifiedMagAreaRel();
    }

    public static class LocComparator
    implements Comparator<Location> {
        private boolean latSort;

        public LocComparator(boolean latSort) {
            this.latSort = latSort;
        }

        @Override
        public int compare(Location o1, Location o2) {
            Double v2;
            Double v1;
            if (this.latSort) {
                v1 = o1.getLatitude();
                v2 = o2.getLatitude();
            } else {
                v1 = o1.getLongitude();
                v2 = o2.getLongitude();
            }
            return v1.compareTo(v2);
        }
    }
}

