/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.opensha.commons.data.comcat.ComcatRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_StatewideCatalogCompletenessParam;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.utils.U3_EqkCatalogStatewideCompleteness;

public class ETAS_Config {
    private final int numSimulations;
    private final double duration;
    private Integer startYear = null;
    private Long startTimeMillis = null;
    private final boolean includeSpontaneous;
    private Long randomSeed = null;
    private boolean binaryOutput;
    private List<BinaryFilteredOutputConfig> binaryOutputFilters;
    private boolean forceRecalc = false;
    private Boolean reuseERFs = null;
    private String simulationName = null;
    private int numRetries = 3;
    private File outputDir;
    private File triggerCatalog = null;
    private File triggerCatalogSurfaceMappings = null;
    private Boolean treatTriggerCatalogAsSpontaneous = null;
    private List<TriggerRupture> triggerRuptures = null;
    private final File cacheDir;
    private final File fssFile;
    private U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
    private boolean applySubSeisForSupraNucl = true;
    private double totRateScaleFactor = 1.14;
    private boolean gridSeisCorr = true;
    private boolean timeIndependentERF = false;
    private boolean griddedOnly = false;
    private boolean imposeGR = false;
    private boolean includeIndirectTriggering = true;
    private double gridSeisDiscr = 0.1;
    private U3_EqkCatalogStatewideCompleteness catalogCompletenessModel = U3ETAS_StatewideCatalogCompletenessParam.DEFAULT_VALUE;
    private Double etas_p = null;
    private Double etas_c = null;
    private Double etas_log10_k = null;
    private Double etas_k_cov = null;
    private Double maxPointSourceMag = null;
    private String configCommand = null;
    private Long configTime = null;
    private ComcatMetadata comcatMetadata = null;
    private static HashSet<String> resolvedVars = new HashSet();
    private transient FaultSystemSolution fss;

    public ETAS_Config(int numSimulations, double duration, boolean includeSpontaneous, File cacheDir, File fssFile, File outputDir) {
        this(numSimulations, duration, includeSpontaneous, cacheDir, fssFile, outputDir, null, null, new TriggerRupture[0]);
    }

    public ETAS_Config(int numSimulations, double duration, boolean includeSpontaneous, File cacheDir, File fssFile, File outputDir, File triggerCatalog, File triggerCatalogSurfaceMappings, TriggerRupture ... triggerRuptures) {
        this(numSimulations, duration, includeSpontaneous, cacheDir, fssFile, outputDir, triggerCatalog, triggerCatalogSurfaceMappings, ETAS_Config.toList(triggerRuptures));
    }

    private static List<TriggerRupture> toList(TriggerRupture[] triggerRuptures) {
        if (triggerRuptures == null || triggerRuptures.length == 0) {
            return null;
        }
        ArrayList<TriggerRupture> list = new ArrayList<TriggerRupture>();
        for (TriggerRupture rup : triggerRuptures) {
            list.add(rup);
        }
        return list;
    }

    ETAS_Config(int numSimulations, double duration, boolean includeSpontaneous, File cacheDir, File fssFile, File outputDir, File triggerCatalog, File triggerCatalogSurfaceMappings, List<TriggerRupture> triggerRuptures) {
        this.numSimulations = numSimulations;
        this.duration = duration;
        this.includeSpontaneous = includeSpontaneous;
        this.cacheDir = cacheDir;
        this.fssFile = fssFile;
        this.outputDir = outputDir;
        this.triggerCatalog = triggerCatalog;
        this.triggerCatalogSurfaceMappings = triggerCatalogSurfaceMappings;
        this.triggerRuptures = triggerRuptures;
        double simulatedYears = (double)numSimulations * duration;
        boolean bl = this.binaryOutput = simulatedYears > 1000.0;
        if (triggerCatalog != null) {
            this.treatTriggerCatalogAsSpontaneous = false;
        }
        this.buildDefaultBinaryOutputFilters();
    }

    public void buildDefaultBinaryOutputFilters() {
        if (this.binaryOutput) {
            this.binaryOutputFilters = new ArrayList<BinaryFilteredOutputConfig>();
            this.binaryOutputFilters.add(new BinaryFilteredOutputConfig("results_complete", null, null, false));
            this.binaryOutputFilters.add(new BinaryFilteredOutputConfig("results_m5_preserve_chain", 5.0, true, false));
            if (this.includeSpontaneous && this.hasTriggers()) {
                this.binaryOutputFilters.add(new BinaryFilteredOutputConfig("results_triggered_descendants", null, null, true));
            }
        } else {
            this.binaryOutputFilters = null;
        }
    }

    private static Gson buildGson(boolean resolvePaths, boolean skipTriggers) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(File.class, (Object)new FileTypeAdapter(resolvePaths).nullSafe());
        builder.registerTypeAdapter(Location.class, (Object)new LocationTypeAdapter().nullSafe());
        if (skipTriggers) {
            builder.registerTypeAdapter(TriggerRupture.class, (Object)new SkipTriggerRuptureTypeAdapter().nullSafe());
        } else {
            builder.registerTypeAdapter(TriggerRupture.class, (Object)new TriggerRuptureTypeAdapter().nullSafe());
        }
        builder.registerTypeAdapter(Region.class, (Object)new RegionTypeAdapter().nullSafe());
        Gson gson = builder.create();
        return gson;
    }

    public static File resolvePath(File file) {
        if (file == null) {
            return null;
        }
        return ETAS_Config.resolvePath(file.getPath());
    }

    public static File resolvePath(String path) {
        return ETAS_Config.resolvePath(path, System.getenv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File resolvePath(String path, Map<String, String> env) {
        while (path.contains("$")) {
            boolean firstTime;
            String var;
            int index = path.indexOf("$");
            Preconditions.checkState((index < path.length() - 1 ? 1 : 0) != 0, (Object)"path cannot end with a '$'");
            String replaceStr = path.substring(index);
            if (replaceStr.charAt(1) == '{') {
                Preconditions.checkState((boolean)replaceStr.contains("}"));
                replaceStr = replaceStr.substring(0, replaceStr.indexOf("}") + 1);
                var = replaceStr.substring(2, replaceStr.length() - 1);
            } else {
                if (replaceStr.contains(File.separator)) {
                    replaceStr = replaceStr.substring(0, replaceStr.indexOf(File.separator));
                }
                var = replaceStr.substring(1);
            }
            String value = env.get(var);
            boolean bl = firstTime = !resolvedVars.contains(var);
            if (value == null || firstTime) {
                System.out.println("Path ('" + path + "') contains environmental variable ('" + var + "')");
            }
            Preconditions.checkNotNull((Object)value, (String)"Environmental variable %s not found! Can't build path", (Object)var);
            path = path.replace(replaceStr, value);
            if (!firstTime) continue;
            System.out.println("\treplacing '" + replaceStr + "' with '" + value + "': " + path);
            HashSet<String> hashSet = resolvedVars;
            synchronized (hashSet) {
                resolvedVars.add(var);
            }
        }
        return new File(path);
    }

    private static Location readLocation(JsonReader in, boolean allowNullDepth) throws IOException {
        Double lat = null;
        Double lon = null;
        Double depth = null;
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "latitude": {
                    lat = in.nextDouble();
                    break;
                }
                case "longitude": {
                    lon = in.nextDouble();
                    break;
                }
                case "depth": {
                    depth = in.nextDouble();
                }
            }
        }
        Preconditions.checkNotNull(lat, (Object)"trace point latitude not specified");
        Preconditions.checkNotNull(lon, (Object)"trace point longitude not specified");
        if (!allowNullDepth) {
            Preconditions.checkNotNull(depth, (Object)"trace point depth not specified");
        }
        if (depth == null) {
            return new Location(lat, lon);
        }
        return new Location(lat, lon, depth);
    }

    public void setStartYear(Integer startYear) {
        this.startYear = startYear;
        this.startTimeMillis = null;
    }

    public void setStartTimeMillis(Long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
        this.startYear = null;
    }

    public void setTriggerCatalog(File triggerCatalog) {
        this.triggerCatalog = triggerCatalog;
    }

    public void setTriggerCatalogSurfaceMappings(File triggerCatalogSurfaceMappings) {
        this.triggerCatalogSurfaceMappings = triggerCatalogSurfaceMappings;
    }

    public void addTriggerRupture(TriggerRupture rup) {
        if (this.triggerRuptures == null) {
            this.triggerRuptures = new ArrayList<TriggerRupture>();
        }
        this.triggerRuptures.add(rup);
    }

    public List<TriggerRupture> getTriggerRuptures() {
        return this.triggerRuptures;
    }

    public boolean hasTriggers() {
        return this.getTriggerRuptures() != null && !this.getTriggerRuptures().isEmpty() || this.getTriggerCatalogFile() != null && !this.isTreatTriggerCatalogAsSpontaneous();
    }

    public long getSimulationStartTimeMillis() {
        if (this.startTimeMillis != null) {
            Preconditions.checkState((this.startYear == null ? 1 : 0) != 0, (Object)"Cannon specify both start year and time in milliseconds");
            return this.startTimeMillis;
        }
        Preconditions.checkNotNull((Object)this.startYear, (Object)"Must specify either start year or time in milliseconds");
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(this.startYear, 0, 1);
        return cal.getTimeInMillis();
    }

    public int getNumSimulations() {
        return this.numSimulations;
    }

    public double getDuration() {
        return this.duration;
    }

    public boolean isIncludeSpontaneous() {
        return this.includeSpontaneous;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public boolean isBinaryOutput() {
        return this.binaryOutput;
    }

    public void setBinaryOutput(boolean binaryOutput) {
        this.binaryOutput = binaryOutput;
    }

    public void setBinaryOutputFilters(List<BinaryFilteredOutputConfig> binaryOutputFilters) {
        this.binaryOutputFilters = binaryOutputFilters;
    }

    public List<BinaryFilteredOutputConfig> getBinaryOutputFilters() {
        return this.binaryOutputFilters;
    }

    public boolean hasBinaryOutputFilters() {
        return this.getBinaryOutputFilters() != null && !this.getBinaryOutputFilters().isEmpty();
    }

    public boolean isForceRecalc() {
        return this.forceRecalc;
    }

    public void setReuseERFs(Boolean reuseERFs) {
        this.reuseERFs = reuseERFs;
    }

    public boolean isReuseERFs() {
        return this.reuseERFs == null ? true : this.reuseERFs;
    }

    public void setSimulationName(String simulationName) {
        this.simulationName = simulationName;
    }

    public String getSimulationName() {
        return this.simulationName;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public File getTriggerCatalogFile() {
        return this.triggerCatalog;
    }

    public File getTriggerCatalogSurfaceMappingsFile() {
        return this.triggerCatalogSurfaceMappings;
    }

    public void setTreatTriggerCatalogAsSpontaneous(boolean treatTriggerCatalogAsSpontaneous) {
        this.treatTriggerCatalogAsSpontaneous = treatTriggerCatalogAsSpontaneous;
    }

    public boolean isTreatTriggerCatalogAsSpontaneous() {
        if (this.treatTriggerCatalogAsSpontaneous == null) {
            return false;
        }
        return this.treatTriggerCatalogAsSpontaneous;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getFSS_File() {
        return this.fssFile;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setProbModel(U3ETAS_ProbabilityModelOptions probModel) {
        this.probModel = probModel;
    }

    public U3ETAS_ProbabilityModelOptions getProbModel() {
        return this.probModel;
    }

    public void setETAS_P(Double p) {
        this.etas_p = p;
    }

    public Double getETAS_P() {
        return this.etas_p;
    }

    public void setETAS_C(Double c) {
        this.etas_c = c;
    }

    public Double getETAS_C() {
        return this.etas_c;
    }

    public void setETAS_Log10_K(Double log10_k) {
        this.etas_log10_k = log10_k;
    }

    public Double getETAS_Log10_K() {
        return this.etas_log10_k;
    }

    public void setETAS_K_COV(Double kCOV) {
        this.etas_k_cov = kCOV;
    }

    public Double getETAS_K_COV() {
        return this.etas_k_cov;
    }

    public Double getMaxPointSourceMag() {
        return this.maxPointSourceMag;
    }

    public void setMaxPointSourceMag(Double maxPointSourceMag) {
        this.maxPointSourceMag = maxPointSourceMag;
    }

    public boolean isApplySubSeisForSupraNucl() {
        return this.applySubSeisForSupraNucl;
    }

    public void setTotRateScaleFactor(double totRateScaleFactor) {
        this.totRateScaleFactor = totRateScaleFactor;
    }

    public double getTotRateScaleFactor() {
        return this.totRateScaleFactor;
    }

    public void setGridSeisCorr(boolean gridSeisCorr) {
        this.gridSeisCorr = gridSeisCorr;
    }

    public boolean isGridSeisCorr() {
        return this.gridSeisCorr;
    }

    public boolean isTimeIndependentERF() {
        return this.timeIndependentERF;
    }

    public boolean isGriddedOnly() {
        return this.griddedOnly;
    }

    public void setGriddedOnly(boolean griddedOnly) {
        this.griddedOnly = griddedOnly;
    }

    public void setImposeGR(boolean imposeGR) {
        this.imposeGR = imposeGR;
    }

    public boolean isImposeGR() {
        return this.imposeGR;
    }

    public boolean isIncludeIndirectTriggering() {
        return this.includeIndirectTriggering;
    }

    public double getGridSeisDiscr() {
        return this.gridSeisDiscr;
    }

    public U3_EqkCatalogStatewideCompleteness getCompletenessModel() {
        return this.catalogCompletenessModel;
    }

    public void setCompletenessModel(U3_EqkCatalogStatewideCompleteness catalogCompletenessModel) {
        this.catalogCompletenessModel = catalogCompletenessModel;
    }

    public void setComcatMetadata(ComcatMetadata comcatMetadata) {
        this.comcatMetadata = comcatMetadata;
    }

    public ComcatMetadata getComcatMetadata() {
        return this.comcatMetadata;
    }

    public String getConfigCommand() {
        return this.configCommand;
    }

    public void setConfigCommand(String configCommand) {
        this.configCommand = configCommand;
    }

    public Long getConfigTime() {
        return this.configTime;
    }

    public void setConfigTime(Long configTime) {
        this.configTime = configTime;
    }

    public synchronized FaultSystemSolution loadFSS() {
        if (this.fss == null) {
            Preconditions.checkNotNull((Object)this.fssFile, (Object)"Must specify fault system solution file");
            Preconditions.checkState((boolean)this.fssFile.exists(), (Object)"FSS file doesn't exist");
            try {
                this.fss = FaultSystemSolution.load(this.fssFile);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        return this.fss;
    }

    public String toJSON() {
        return this.toJSON(false);
    }

    public String toJSON(boolean skipTriggers) {
        Gson gson = ETAS_Config.buildGson(true, skipTriggers);
        return gson.toJson((Object)this);
    }

    public void writeJSON(File jsonFile) throws IOException {
        jsonFile = ETAS_Config.resolvePath(jsonFile);
        FileWriter fw = new FileWriter(jsonFile);
        fw.write(this.toJSON());
        fw.write("\n");
        fw.close();
    }

    public static ETAS_Config readJSON(File jsonFile) throws IOException {
        return ETAS_Config.readJSON(jsonFile, true);
    }

    public static ETAS_Config readJSON(File jsonFile, boolean resolvePaths) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return ETAS_Config.readJSON(reader, resolvePaths);
    }

    public static ETAS_Config readJSON(String json) {
        return ETAS_Config.readJSON(json, true);
    }

    public static ETAS_Config readJSON(String json, boolean resolvePaths) {
        return ETAS_Config.readJSON(new StringReader(json), resolvePaths);
    }

    public static ETAS_Config readJSON(Reader json, boolean resolvePaths) {
        Gson gson = ETAS_Config.buildGson(resolvePaths, false);
        ETAS_Config conf = (ETAS_Config)gson.fromJson(json, ETAS_Config.class);
        try {
            json.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return conf;
    }

    public static void updateComcatMagComplete(File jsonFile, Double magComplete) throws IOException {
        ETAS_Config config = ETAS_Config.readJSON(jsonFile);
        ComcatMetadata meta = config.comcatMetadata;
        Preconditions.checkNotNull((Object)meta);
        meta.magComplete = magComplete;
        Map<String, String> env = System.getenv();
        String json = config.toJSON();
        for (String var : env.keySet()) {
            String val = env.get(var);
            if (!var.startsWith("ETAS") || !json.contains(val) || var.equals("ETAS_MEM_GB")) continue;
            System.out.println("\tReplacing path '" + val + "' with ${" + var + "}");
            json = json.replaceAll(val, Matcher.quoteReplacement("${" + var + "}"));
        }
        FileWriter fw = new FileWriter(jsonFile);
        fw.write(json + "\n");
        fw.close();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            File jsonFile = new File(args[0]);
            try {
                if (!jsonFile.isDirectory()) {
                    System.out.println("Loading JSON from " + String.valueOf(jsonFile));
                    ETAS_Config config = ETAS_Config.readJSON(jsonFile);
                    System.out.println("================");
                    System.out.println(config.toJSON());
                    System.out.println("================");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        System.exit(0);
        int numSimulations = 1000;
        double duration = 10.0;
        boolean includeSpontaneous = true;
        File cacheDir = new File("/auto/scec-02/kmilner/ucerf3/etas_sim/cache_fm3p1_ba");
        File fssFile = new File("/home/scec-02/kmilner/ucerf3/inversion_compound_plots/2013_05_10-ucerf3p3-production-10runs/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
        File outputDir = new File("/tmp");
        FaultTrace trace1 = new FaultTrace("asdf");
        trace1.add(new Location(34.0, -118.0));
        trace1.add(new Location(34.0, -119.0));
        FaultTrace trace2 = new FaultTrace("asdf");
        trace2.add(new Location(35.0, -118.0));
        trace2.add(new Location(35.0, -119.0));
        trace2.add(new Location(35.0, -120.0));
        SimpleFaultData[] sfds = new SimpleFaultData[]{new SimpleFaultData(90.0, 10.0, 0.0, trace1, Double.NaN), new SimpleFaultData(60.0, 12.0, 2.0, trace2, Double.NaN)};
        ETAS_Config conf = new ETAS_Config(numSimulations, duration, includeSpontaneous, cacheDir, fssFile, outputDir, null, null, new TriggerRupture.FSS(1234, 11111243L, 6.5), new TriggerRupture.FSS(12345, null, null), new TriggerRupture.SectionBased(new int[]{0, 5, 10}, null, 7.2), new TriggerRupture.Point(new Location(34.0, -118.0, 5.5), 12321L, 5.7), new TriggerRupture.SimpleFault((Long)123456L, null, 8.0, sfds));
        String json1 = conf.toJSON();
        System.out.println("Orig JSON");
        System.out.println(json1);
        ETAS_Config conf2 = ETAS_Config.readJSON(json1);
        System.out.println();
        System.out.println("Re-serialized JSON");
        System.out.println(conf2.toJSON());
    }

    public static class ComcatMetadata {
        @JsonAdapter(value=RegionTypeAdapter.class)
        public final Region region;
        public final String eventID;
        public final double minDepth;
        public final double maxDepth;
        public final double minMag;
        public final long startTime;
        public final long endTime;
        public Double magComplete;

        public ComcatMetadata(Region region, String eventID, double minDepth, double maxDepth, double minMag, long startTime, long endTime) {
            this.region = region;
            this.eventID = eventID;
            this.minDepth = minDepth;
            this.maxDepth = maxDepth;
            this.minMag = minMag;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    public class BinaryFilteredOutputConfig {
        private final String prefix;
        private final Double minMag;
        private final Boolean preserveChainBelowMag;
        private final boolean descendantsOnly;

        private BinaryFilteredOutputConfig(String prefix, Double minMag, Boolean preserveChainBelowMag, boolean descendantsOnly) {
            this.prefix = prefix;
            this.minMag = minMag;
            this.preserveChainBelowMag = minMag != null ? preserveChainBelowMag : null;
            this.descendantsOnly = descendantsOnly;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Double getMinMag() {
            return this.minMag;
        }

        public boolean isPreserveChainBelowMag() {
            if (this.preserveChainBelowMag == null) {
                return true;
            }
            return this.preserveChainBelowMag;
        }

        public boolean isDescendantsOnly() {
            return this.descendantsOnly;
        }

        public File getPreStagedCatalogFile(File catalogDir) {
            if (!this.isDescendantsOnly() && this.getMinMag() == null) {
                return new File(catalogDir, "simulatedEvents.bin");
            }
            return new File(catalogDir, "filtered_for_" + this.getPrefix() + ".bin");
        }

        public ETAS_CatalogIO.ETAS_Catalog filter(ETAS_Config config, ETAS_CatalogIO.ETAS_Catalog catalog) {
            if (this.isDescendantsOnly() && !catalog.isEmpty()) {
                catalog = ETAS_Launcher.getFilteredNoSpontaneous(config, catalog);
            }
            ETAS_SimulationMetadata meta = catalog.getSimulationMetadata();
            Double minMag = this.getMinMag();
            if (minMag != null && minMag > 0.0 && !catalog.isEmpty()) {
                if (this.isPreserveChainBelowMag()) {
                    catalog = ETAS_SimAnalysisTools.getAboveMagPreservingChain(catalog, minMag);
                } else {
                    ETAS_CatalogIO.ETAS_Catalog filteredCatalog = new ETAS_CatalogIO.ETAS_Catalog(meta == null ? null : meta.getModMinMag(minMag));
                    for (ETAS_EqkRupture rup : catalog) {
                        if (!(rup.getMag() >= this.getMinMag())) continue;
                        filteredCatalog.add(rup);
                    }
                    if (filteredCatalog.getSimulationMetadata() != null) {
                        filteredCatalog.updateMetadataForCatalog();
                    }
                    catalog = filteredCatalog;
                }
            }
            return catalog;
        }
    }

    private static class FileTypeAdapter
    extends TypeAdapter<File> {
        private Map<String, String> env;
        private boolean resolvePaths;

        private FileTypeAdapter(boolean resolvePaths) {
            this.resolvePaths = resolvePaths;
            this.env = System.getenv();
        }

        public void write(JsonWriter out, File value) throws IOException {
            out.value(value.getPath());
        }

        public File read(JsonReader in) throws IOException {
            String path = in.nextString();
            if (this.resolvePaths) {
                return ETAS_Config.resolvePath(path, this.env);
            }
            return new File(path);
        }
    }

    private static class LocationTypeAdapter
    extends TypeAdapter<Location> {
        private LocationTypeAdapter() {
        }

        public void write(JsonWriter out, Location value) throws IOException {
            out.beginObject();
            out.name("latitude").value(value.getLatitude());
            out.name("longitude").value(value.getLongitude());
            out.name("depth").value(value.getDepth());
            out.endObject();
        }

        public Location read(JsonReader in) throws IOException {
            in.beginObject();
            double lat = Double.NaN;
            double lon = Double.NaN;
            double depth = Double.NaN;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "latitude": {
                        lat = in.nextDouble();
                        break;
                    }
                    case "longitude": {
                        lon = in.nextDouble();
                        break;
                    }
                    case "depth": {
                        depth = in.nextDouble();
                    }
                }
            }
            in.endObject();
            return new Location(lat, lon, depth);
        }
    }

    private static class SkipTriggerRuptureTypeAdapter
    extends TypeAdapter<TriggerRupture> {
        private boolean first = true;

        private SkipTriggerRuptureTypeAdapter() {
        }

        public void write(JsonWriter out, TriggerRupture value) throws IOException {
            if (this.first) {
                out.value("omitted due to length, see original input file");
            }
            this.first = false;
        }

        public TriggerRupture read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class TriggerRuptureTypeAdapter
    extends TypeAdapter<TriggerRupture> {
        public void write(JsonWriter out, TriggerRupture value) throws IOException {
            out.beginObject();
            if (value.customOccurrenceTime != null && value.customOccurrenceTime > Long.MIN_VALUE) {
                out.name("occurrenceTimeMillis").value((Number)value.customOccurrenceTime);
            }
            if (value.getComcatEventID() != null && value.getComcatEventID().length() > 0) {
                out.name("comcatEventID").value(value.getComcatEventID());
            }
            if (value.getETAS_log10_k() != null) {
                out.name("etas_log10_k").value((Number)value.getETAS_log10_k());
            }
            if (value.getETAS_p() != null) {
                out.name("etas_p").value((Number)value.getETAS_p());
            }
            if (value.getETAS_c() != null) {
                out.name("etas_c").value((Number)value.getETAS_c());
            }
            if (value instanceof TriggerRupture.FSS) {
                TriggerRupture.FSS fssRup = (TriggerRupture.FSS)value;
                out.name("fssIndex").value((long)fssRup.fssIndex);
                if (fssRup.overrideMag != null && fssRup.overrideMag > 0.0) {
                    out.name("mag").value((Number)fssRup.overrideMag);
                }
            } else if (value instanceof TriggerRupture.SectionBased) {
                TriggerRupture.SectionBased sectRup = (TriggerRupture.SectionBased)value;
                out.name("mag").value(sectRup.mag);
                out.name("subSectIndexes").beginArray();
                for (int index : sectRup.subSects) {
                    out.value((long)index);
                }
                out.endArray();
            } else if (value instanceof TriggerRupture.Point) {
                TriggerRupture.Point ptRup = (TriggerRupture.Point)value;
                out.name("mag").value(ptRup.mag);
                Location location = ptRup.hypocenter;
                out.name("latitude").value(location.getLatitude());
                out.name("longitude").value(location.getLongitude());
                out.name("depth").value(location.getDepth());
                if (ptRup.sectsReset != null && ptRup.sectsReset.length > 0) {
                    out.name("subSectResetIndexes").beginArray();
                    for (int index : ptRup.sectsReset) {
                        out.value((long)index);
                    }
                    out.endArray();
                }
            } else if (value instanceof TriggerRupture.SimpleFault) {
                TriggerRupture.SimpleFault sfdRup = (TriggerRupture.SimpleFault)value;
                out.name("mag").value(sfdRup.mag);
                if (sfdRup.hypo != null) {
                    out.name("latitude").value(sfdRup.hypo.getLatitude());
                    out.name("longitude").value(sfdRup.hypo.getLongitude());
                    out.name("depth").value(sfdRup.hypo.getDepth());
                }
                out.name("ruptureSurfaces").beginArray();
                for (SimpleFaultData sfd : sfdRup.sfds) {
                    out.beginObject();
                    out.name("dip").value(sfd.getAveDip());
                    if (Double.isFinite(sfd.getAveDipDir())) {
                        out.name("dipDir").value(sfd.getAveDipDir());
                    }
                    out.name("upperDepth").value(sfd.getUpperSeismogenicDepth());
                    out.name("lowerDepth").value(sfd.getLowerSeismogenicDepth());
                    out.name("trace").beginArray();
                    for (Location loc : sfd.getFaultTrace()) {
                        out.beginObject();
                        out.name("latitude").value(loc.getLatitude());
                        out.name("longitude").value(loc.getLongitude());
                        out.name("depth").value(loc.getDepth());
                        out.endObject();
                    }
                    out.endArray();
                    out.endObject();
                }
                out.endArray();
                if (sfdRup.sectsReset != null && sfdRup.sectsReset.length > 0) {
                    out.name("subSectResetIndexes").beginArray();
                    for (int index : sfdRup.sectsReset) {
                        out.value((long)index);
                    }
                    out.endArray();
                }
            } else if (value instanceof TriggerRupture.EdgeFault) {
                TriggerRupture.EdgeFault edgeRup = (TriggerRupture.EdgeFault)value;
                out.name("mag").value(edgeRup.mag);
                if (edgeRup.hypo != null) {
                    out.name("latitude").value(edgeRup.hypo.getLatitude());
                    out.name("longitude").value(edgeRup.hypo.getLongitude());
                    out.name("depth").value(edgeRup.hypo.getDepth());
                }
                out.name("ruptureSurfaces").beginArray();
                for (LocationList outline : edgeRup.outlines) {
                    out.beginObject();
                    out.name("outline").beginArray();
                    for (Location loc : outline) {
                        out.beginObject();
                        out.name("latitude").value(loc.getLatitude());
                        out.name("longitude").value(loc.getLongitude());
                        out.name("depth").value(loc.getDepth());
                        out.endObject();
                    }
                    out.endArray();
                    out.endObject();
                }
                out.endArray();
                if (edgeRup.sectsReset != null && edgeRup.sectsReset.length > 0) {
                    out.name("subSectResetIndexes").beginArray();
                    for (int index : edgeRup.sectsReset) {
                        out.value((long)index);
                    }
                    out.endArray();
                }
            } else {
                throw new IllegalStateException("Not yet implemented for subcalss " + value.getClass().getName());
            }
            out.endObject();
        }

        public TriggerRupture read(JsonReader in) throws IOException {
            TriggerRupture trigger;
            Long customOccurrenceTime = null;
            Double mag = null;
            Integer fssIndex = null;
            int[] subSects = null;
            Double lat = null;
            Double lon = null;
            Double depth = null;
            SimpleFaultData[] sfds = null;
            LocationList[] outlines = null;
            int[] resetSubSects = null;
            String comcatEventID = null;
            Double log10_k = null;
            Double p = null;
            Double c = null;
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "occurrenceTimeMillis": {
                        customOccurrenceTime = in.nextLong();
                        break;
                    }
                    case "comcatEventID": {
                        comcatEventID = in.nextString();
                        break;
                    }
                    case "mag": {
                        mag = in.nextDouble();
                        break;
                    }
                    case "fssIndex": {
                        fssIndex = in.nextInt();
                        break;
                    }
                    case "subSectIndexes": {
                        in.beginArray();
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        while (in.hasNext()) {
                            int index = in.nextInt();
                            indexes.add(index);
                        }
                        in.endArray();
                        subSects = Ints.toArray(indexes);
                        break;
                    }
                    case "latitude": {
                        lat = in.nextDouble();
                        break;
                    }
                    case "longitude": {
                        lon = in.nextDouble();
                        break;
                    }
                    case "depth": {
                        depth = in.nextDouble();
                        break;
                    }
                    case "ruptureSurfaces": {
                        ArrayList<SimpleFaultData> sfdList = new ArrayList<SimpleFaultData>();
                        ArrayList<LocationList> outlineList = new ArrayList<LocationList>();
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            Double dip = null;
                            double dipDir = Double.NaN;
                            Double upperDepth = null;
                            Double lowerDepth = null;
                            FaultTrace trace = null;
                            LocationList outline = null;
                            while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "dip": {
                                        dip = in.nextDouble();
                                        break;
                                    }
                                    case "dipDir": {
                                        dipDir = in.nextDouble();
                                        break;
                                    }
                                    case "upperDepth": {
                                        upperDepth = in.nextDouble();
                                        break;
                                    }
                                    case "lowerDepth": {
                                        lowerDepth = in.nextDouble();
                                        break;
                                    }
                                    case "trace": {
                                        in.beginArray();
                                        trace = new FaultTrace("Custom Fault");
                                        while (in.hasNext()) {
                                            in.beginObject();
                                            trace.add(ETAS_Config.readLocation(in, true));
                                            in.endObject();
                                        }
                                        in.endArray();
                                        break;
                                    }
                                    case "outline": {
                                        in.beginArray();
                                        outline = new LocationList();
                                        while (in.hasNext()) {
                                            in.beginObject();
                                            outline.add(ETAS_Config.readLocation(in, false));
                                            in.endObject();
                                        }
                                        in.endArray();
                                    }
                                }
                            }
                            in.endObject();
                            if (outline == null) {
                                Preconditions.checkNotNull(dip, (Object)"surface dip not specified");
                                Preconditions.checkNotNull(upperDepth, (Object)"surface upper depth not specified");
                                Preconditions.checkNotNull((Object)lowerDepth, (Object)"surface lower depth not specified");
                                Preconditions.checkNotNull((Object)trace, (Object)"surface trace not specified");
                                sfdList.add(new SimpleFaultData(dip, lowerDepth, upperDepth, trace, dipDir));
                                continue;
                            }
                            Preconditions.checkState((dip == null ? 1 : 0) != 0, (Object)"surface dip cannot be specified with outline");
                            Preconditions.checkState((upperDepth == null ? 1 : 0) != 0, (Object)"surface upper depth cannot be specified with outline");
                            Preconditions.checkState((lowerDepth == null ? 1 : 0) != 0, (Object)"surface lower depth cannot be specified with outline");
                            Preconditions.checkState((trace == null ? 1 : 0) != 0, (Object)"surface trace cannot be specified with outline");
                            outlineList.add(outline);
                        }
                        in.endArray();
                        if (sfdList.size() > 0) {
                            Preconditions.checkState((boolean)outlineList.isEmpty(), (Object)"Can't mix simple faults and outlines");
                            sfds = sfdList.toArray(new SimpleFaultData[0]);
                            break;
                        }
                        Preconditions.checkState((outlineList.size() > 0 ? 1 : 0) != 0, (Object)"No rupture surfaces specified");
                        outlines = outlineList.toArray(new LocationList[0]);
                        break;
                    }
                    case "subSectResetIndexes": {
                        in.beginArray();
                        ArrayList<Integer> myIndexes = new ArrayList<Integer>();
                        while (in.hasNext()) {
                            int index = in.nextInt();
                            myIndexes.add(index);
                        }
                        in.endArray();
                        resetSubSects = Ints.toArray(myIndexes);
                        break;
                    }
                    case "etas_log10_k": {
                        log10_k = in.nextDouble();
                        break;
                    }
                    case "etas_p": {
                        p = in.nextDouble();
                        break;
                    }
                    case "etas_c": {
                        c = in.nextDouble();
                    }
                }
            }
            in.endObject();
            if (fssIndex != null) {
                Preconditions.checkState((lat == null && lon == null && depth == null ? 1 : 0) != 0, (Object)"Cannot specify point source location for FSS rupture");
                Preconditions.checkState((subSects == null ? 1 : 0) != 0, (Object)"Cannot specify sub sections for FSS rupture");
                trigger = new TriggerRupture.FSS(fssIndex, customOccurrenceTime, mag);
            } else if (sfds != null) {
                Location hypo = null;
                if (lat != null && lon != null) {
                    hypo = new Location(lat, lon, depth);
                }
                Preconditions.checkNotNull(mag, (Object)"Must specify magnitude for simple fault rupture");
                trigger = new TriggerRupture.SimpleFault(customOccurrenceTime, hypo, (double)mag, resetSubSects, sfds);
            } else if (outlines != null) {
                Location hypo = null;
                if (lat != null && lon != null) {
                    hypo = new Location(lat, lon, depth);
                }
                Preconditions.checkNotNull((Object)mag, (Object)"Must specify magnitude for edge rupture");
                trigger = new TriggerRupture.EdgeFault(customOccurrenceTime, hypo, (double)mag, resetSubSects, outlines);
            } else if (subSects != null) {
                Preconditions.checkState((lat == null && lon == null && depth == null ? 1 : 0) != 0, (Object)"Cannot specify point source location for sub sect rupture");
                Preconditions.checkNotNull((Object)mag, (Object)"Must specify magnitude for sub sect rupture");
                trigger = new TriggerRupture.SectionBased(subSects, customOccurrenceTime, mag);
            } else {
                Preconditions.checkNotNull(lat, (Object)"Must specify latitude for point source rupture");
                Preconditions.checkNotNull((Object)lon, (Object)"Must specify longitude for point source rupture");
                Preconditions.checkNotNull((Object)depth, (Object)"Must specify depth for point source rupture");
                Preconditions.checkNotNull((Object)mag, (Object)"Must specify magnitude for point source rupture");
                Location hypocenter = new Location(lat, lon, depth);
                trigger = new TriggerRupture.Point(hypocenter, customOccurrenceTime, mag, resetSubSects);
            }
            trigger.setComcatEventID(comcatEventID);
            trigger.setETAS_Params(log10_k, p, c);
            return trigger;
        }
    }

    private static class RegionTypeAdapter
    extends TypeAdapter<Region> {
        private RegionTypeAdapter() {
        }

        public void write(JsonWriter out, Region value) throws IOException {
            out.beginObject();
            if (value.isRectangular()) {
                out.name("minLatitude").value(value.getMinLat());
                out.name("maxLatitude").value(value.getMaxLat());
                out.name("minLongitude").value(value.getMinLon());
                out.name("maxLongitude").value(value.getMaxLon());
            } else if (value instanceof CircularRegion) {
                CircularRegion circle = (CircularRegion)value;
                out.name("centerLatitude").value(circle.center.getLatitude());
                out.name("centerLongitude").value(circle.center.getLongitude());
                out.name("radius").value(circle.radius);
            } else {
                out.name("border").beginArray();
                for (Location loc : value.getBorder()) {
                    out.beginObject();
                    out.name("latitude").value(loc.getLatitude());
                    out.name("longitude").value(loc.getLongitude());
                    out.endObject();
                }
                out.endArray();
            }
            out.endObject();
        }

        public Region read(JsonReader in) throws IOException {
            in.beginObject();
            Double minLat = null;
            Double maxLat = null;
            Double minLon = null;
            Double maxLon = null;
            Double centerLat = null;
            Double centerLon = null;
            Double radius = null;
            LocationList border = null;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "minLatitude": {
                        minLat = in.nextDouble();
                        break;
                    }
                    case "maxLatitude": {
                        maxLat = in.nextDouble();
                        break;
                    }
                    case "minLongitude": {
                        minLon = in.nextDouble();
                        break;
                    }
                    case "maxLongitude": {
                        maxLon = in.nextDouble();
                        break;
                    }
                    case "centerLatitude": {
                        centerLat = in.nextDouble();
                        break;
                    }
                    case "centerLongitude": {
                        centerLon = in.nextDouble();
                        break;
                    }
                    case "radius": {
                        radius = in.nextDouble();
                        break;
                    }
                    case "border": {
                        border = new LocationList();
                        in.beginArray();
                        while (in.hasNext()) {
                            Double lat = null;
                            Double lon = null;
                            in.beginObject();
                            while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "latitude": {
                                        lat = in.nextDouble();
                                        break;
                                    }
                                    case "longitude": {
                                        lon = in.nextDouble();
                                    }
                                }
                            }
                            in.endObject();
                            Preconditions.checkNotNull(lat, (Object)"Border latitude not supplied");
                            Preconditions.checkNotNull(lon, (Object)"Border longtiude not supplied");
                            border.add(new Location(lat, lon));
                        }
                        in.endArray();
                    }
                }
            }
            in.endObject();
            if (minLat != null) {
                Preconditions.checkNotNull(maxLat, (Object)"maxLatitude not specified");
                Preconditions.checkNotNull(minLon, (Object)"minLongitude not specified");
                Preconditions.checkNotNull((Object)maxLon, (Object)"maxLongitude not specified");
                return new Region(new Location(minLat, minLon), new Location(maxLat, maxLon));
            }
            if (centerLat != null) {
                Preconditions.checkNotNull(centerLon, (Object)"centerLatitude not specified");
                Preconditions.checkNotNull(radius, (Object)"circle radius not specified");
                return new CircularRegion(new Location(centerLat, centerLon), (double)radius);
            }
            Preconditions.checkNotNull(border, (Object)"Must specify either rectangular region, circular region, or supply border");
            return new Region(border, null);
        }
    }

    public static class CircularRegion
    extends Region
    implements ComcatRegion {
        private Location center;
        private double radius;

        public CircularRegion(Location center, double radius) {
            super(center, radius);
            this.center = center;
            this.radius = radius;
        }

        @Override
        public boolean contains(double lat, double lon) {
            return this.contains(new Location(lat, lon));
        }

        @Override
        public boolean isCircular() {
            return false;
        }
    }
}

