/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameComparator;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_CatalogIteration {
    public static int processCatalogs(File catalogsFile, Callback callback) {
        return ETAS_CatalogIteration.processCatalogs(catalogsFile, callback, -1, 0.0);
    }

    public static int processCatalogs(File catalogsFile, Callback callback, int numToProcess, double minMag) {
        int totalNum;
        Iterator<ETAS_CatalogIO.ETAS_Catalog> catalogsIterator;
        if (catalogsFile.isDirectory()) {
            catalogsIterator = new ETAS_ResultsDirIterator(catalogsFile, minMag);
            totalNum = ((ETAS_ResultsDirIterator)catalogsIterator).files.size();
        } else {
            ETAS_CatalogIO.BinarayCatalogsIterable iterable = ETAS_CatalogIO.getBinaryCatalogsIterable(catalogsFile, minMag);
            totalNum = iterable.getNumCatalogs();
            catalogsIterator = iterable.iterator();
        }
        int numProcessed = 0;
        int modulus = 10;
        Stopwatch watch = Stopwatch.createStarted();
        DecimalFormat timeDF = new DecimalFormat("0.00");
        DecimalFormat percentDF = new DecimalFormat("0.0%");
        while (catalogsIterator.hasNext()) {
            ETAS_CatalogIO.ETAS_Catalog catalog;
            if (numProcessed % modulus == 0) {
                double fractProcessed = (double)numProcessed / (double)totalNum;
                if (numProcessed > 0 && totalNum >= numProcessed && (numProcessed >= 100 || fractProcessed >= 0.01)) {
                    long elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
                    double secsElapsed = (double)elapsed / 1000.0;
                    double catsPerSec = (double)numProcessed / secsElapsed;
                    double seconds = (double)(totalNum - numProcessed) / catsPerSec;
                    double mins = seconds / 60.0;
                    double hours = mins / 60.0;
                    String timeStr = hours > 1.0 ? timeDF.format(hours) + " h" : (mins > 1.0 ? timeDF.format(mins) + " m" : timeDF.format(seconds) + " s");
                    System.out.println("Processing catalog " + numProcessed + " (" + percentDF.format(fractProcessed) + " done, approx " + timeStr + " left)");
                } else {
                    System.out.println("Processing catalog " + numProcessed);
                }
                if (numProcessed == modulus * 10) {
                    modulus *= 10;
                }
            }
            try {
                catalog = catalogsIterator.next();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.flush();
                System.out.println("Partial catalog detected or other error, stopping with " + numProcessed + " catalogs");
                break;
            }
            callback.processCatalog(catalog, numProcessed);
            if (++numProcessed != numToProcess) continue;
            break;
        }
        watch.stop();
        return numProcessed;
    }

    public static interface Callback {
        public void processCatalog(ETAS_CatalogIO.ETAS_Catalog var1, int var2);
    }

    static class ETAS_ResultsDirIterator
    implements Iterator<ETAS_CatalogIO.ETAS_Catalog> {
        private LinkedList<File> files;
        private double minMag;

        public ETAS_ResultsDirIterator(File dir, double minMag) {
            this.minMag = minMag;
            this.files = new LinkedList();
            File[] subDirs = dir.listFiles();
            Arrays.sort(subDirs, new FileNameComparator());
            for (File subDir : subDirs) {
                if (!ETAS_Launcher.isAlreadyDone(subDir)) continue;
                this.files.add(subDir);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.files.isEmpty();
        }

        @Override
        public ETAS_CatalogIO.ETAS_Catalog next() {
            File simFile = this.getSimFile(this.files.removeFirst());
            try {
                return ETAS_CatalogIO.loadCatalog(simFile, this.minMag);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        private File getSimFile(File dir) {
            File eventsFile = new File(dir, "simulatedEvents.txt");
            if (!eventsFile.exists()) {
                eventsFile = new File(dir, "simulatedEvents.bin");
            }
            if (!eventsFile.exists()) {
                eventsFile = new File(dir, "simulatedEvents.bin.gz");
            }
            if (eventsFile.exists()) {
                return eventsFile;
            }
            throw new IllegalStateException("No events files found in " + dir.getAbsolutePath());
        }
    }
}

