/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_AbstractComcatConfigBuilder;

public class ETAS_ComcatConfigBuilder
extends ETAS_AbstractComcatConfigBuilder {
    private Long comcatStartTime;
    private Long comcatEndTime;
    private ObsEqkRupture startAtEvent;
    private ObsEqkRupture endAfterEvent;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            Object argz = "";
            argz = (String)argz + " --start-after-historical";
            argz = (String)argz + " --end-now";
            argz = (String)argz + " --num-simulations 1000";
            argz = (String)argz + " --include-spontaneous";
            argz = (String)argz + " --duration 1.0";
            argz = (String)argz + " --finite-surf-shakemap";
            argz = (String)argz + " --finite-surf-shakemap-min-mag 6";
            argz = (String)argz + " --hpc-site USC_CARC";
            argz = (String)argz + " --nodes 32";
            argz = (String)argz + " --hours 24";
            argz = (String)argz + " --queue scec";
            args = ((String)argz).trim().split(" ");
        }
        System.setProperty("java.awt.headless", "true");
        Options options = ETAS_ComcatConfigBuilder.createOptions();
        try {
            ETAS_ComcatConfigBuilder builder = new ETAS_ComcatConfigBuilder(args, options);
            builder.buildConfiguration();
            builder.buildInputPlots();
            System.out.println("DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Options createOptions() {
        Options ops = ETAS_ComcatConfigBuilder.getCommonOptions();
        Option startTimeOption = new Option("st", "start-time", true, "ComCat data start time in epoch milliseconds");
        startTimeOption.setRequired(false);
        ops.addOption(startTimeOption);
        Option startDateOption = new Option("sd", "start-date", true, "ComCat data start date in the format 'yyyy-MM-dd' (e.g. 2019-01-01) or 'yyyy-MM-ddTHH:mm:ss' (e.g. 2019-01-01T01:23:45). All dates and times in UTC");
        startDateOption.setRequired(false);
        ops.addOption(startDateOption);
        Option startAtOption = new Option("sa", "start-at", true, "ComCat data starting with the given event ID");
        startAtOption.setRequired(false);
        ops.addOption(startAtOption);
        Option startDaysBeforeOption = new Option("sdb", "start-days-before", true, "Defines the ComCat data start time as this many days before the end time.");
        startDaysBeforeOption.setRequired(false);
        ops.addOption(startDaysBeforeOption);
        Option startAfterHistoricalOption = new Option("sah", "start-after-historical", false, "ComCat data starting after the end of the UCERF3 historical catalog");
        startAfterHistoricalOption.setRequired(false);
        ops.addOption(startAfterHistoricalOption);
        Option endTimeOption = new Option("et", "end-time", true, "ComCat data end time in epoch milliseconds");
        endTimeOption.setRequired(false);
        ops.addOption(endTimeOption);
        Option endYearOption = new Option("eyr", "end-year", true, "ComCat data end time expressed as a calendar year");
        endYearOption.setRequired(false);
        ops.addOption(endYearOption);
        Option endDateOption = new Option("ed", "end-date", true, "ComCat data end date in the format 'yyyy-MM-dd' (e.g. 2019-01-01) or 'yyyy-MM-ddTHH:mm:ss' (e.g. 2019-01-01T01:23:45). All dates and times in UTC.");
        endDateOption.setRequired(false);
        ops.addOption(endDateOption);
        Option endAfterOption = new Option("ea", "end-after", true, "ComCat data ending just after the given event ID");
        endAfterOption.setRequired(false);
        ops.addOption(endAfterOption);
        Option endDaysAfterOption = new Option("eda", "end-days-after", true, "Defines the ComCat data end time as this many days after the end time.");
        endDaysAfterOption.setRequired(false);
        ops.addOption(endDaysAfterOption);
        Option nowOption = new Option("now", "end-now", false, "Include all aftershocks of primary event (which is specified with --event-id <id>) up to the current instant");
        nowOption.setRequired(false);
        ops.addOption(nowOption);
        Option regionOption = new Option("reg", "region", true, "Region to fetch events in the format lat1,lon1[,lat2,lon2]. If only one location is supplied, then a circular region is built and you must also supply the --radius argument. Otherwise, a rectangular region is defined between the two points. If omitted, the entire California model region is used");
        regionOption.setRequired(false);
        ops.addOption(regionOption);
        Option radiusOption = new Option("r", "radius", true, "Radius for a circular region");
        radiusOption.setRequired(false);
        ops.addOption(radiusOption);
        return ops;
    }

    public ETAS_ComcatConfigBuilder(String[] args, Options options) {
        super(args, options);
    }

    @Override
    protected String getPrimaryEventID() {
        return null;
    }

    @Override
    protected Region buildRegion(ObsEqkRupture primaryRupture, TriggerRupture primaryTrigger) {
        if (this.cmd.hasOption("region")) {
            String regStr = this.cmd.getOptionValue("region");
            String[] regSplit = regStr.split(",");
            Preconditions.checkArgument((regSplit.length == 2 || regSplit.length == 4 ? 1 : 0) != 0, (Object)"--region format: lat1,lon1[,lat2,lon2]");
            double lat1 = Double.parseDouble(regSplit[0]);
            double lon1 = Double.parseDouble(regSplit[1]);
            Location loc1 = new Location(lat1, lon1);
            if (regSplit.length == 2) {
                Preconditions.checkState((boolean)this.cmd.hasOption("radius"), (Object)"you only supplied one location for a region, but didn't supply a radius");
                double radius = Double.parseDouble(this.cmd.getOptionValue("radius"));
                return new ETAS_Config.CircularRegion(loc1, radius);
            }
            double lat2 = Double.parseDouble(regSplit[2]);
            double lon2 = Double.parseDouble(regSplit[3]);
            Location loc2 = new Location(lat2, lon2);
            return new Region(loc1, loc2);
        }
        return new CaliforniaRegions.RELM_TESTING();
    }

    private boolean hasFiniteStartTime() {
        return this.cmd.hasOption("start-time") || this.cmd.hasOption("start-date") || this.cmd.hasOption("start-at") || this.cmd.hasOption("start-after-historical");
    }

    private boolean hasFiniteEndTime() {
        return this.cmd.hasOption("end-time") || this.cmd.hasOption("end-date") || this.cmd.hasOption("end-now") || this.cmd.hasOption("end-after");
    }

    @Override
    protected long getComCatStartTime() {
        if (this.comcatStartTime == null) {
            if (this.cmd.hasOption("start-time")) {
                this.comcatStartTime = Long.parseLong(this.cmd.getOptionValue("start-time"));
                System.out.println("Will start ComCat data fetch at " + this.comcatStartTime);
            } else if (this.cmd.hasOption("start-date")) {
                String dateStr = this.cmd.getOptionValue("start-date");
                this.comcatStartTime = this.parseDateString(dateStr);
                System.out.println("Will start ComCat data fetch at " + this.comcatStartTime + ", from date: " + dateStr);
            } else if (this.cmd.hasOption("start-at")) {
                String eventID = this.cmd.getOptionValue("start-at");
                System.out.println("Fetching start-at event: " + eventID);
                this.startAtEvent = this.accessor.fetchEvent(eventID, false);
                Preconditions.checkNotNull((Object)this.startAtEvent, (String)"Couldn't locate start-at event %s", (Object)eventID);
                this.comcatStartTime = this.startAtEvent.getOriginTime() - 1000L;
                System.out.println("Will start ComCat data fetch at " + this.comcatStartTime + " (1s before event " + eventID + ")");
            } else if (this.cmd.hasOption("start-after-historical")) {
                this.comcatStartTime = this.parseDateString(historicalEndDate) + 1000L;
                System.out.println("Will start ComCat data fetch at " + this.comcatStartTime + ", 1s after historical catalog end date: " + historicalEndDate);
            } else {
                Preconditions.checkArgument((boolean)this.cmd.hasOption("start-days-before"), (Object)"Must supply start time!");
                Preconditions.checkState((boolean)this.hasFiniteEndTime(), (Object)"Cannot have both relative start and end times");
                double days = Double.parseDouble(this.cmd.getOptionValue("start-days-before"));
                long endTime = this.getComCatEndTime();
                this.comcatStartTime = endTime - (long)(8.64E7 * days);
                System.out.println("Will start ComCat data fetch at " + this.comcatStartTime + ", " + (float)days + " before the end time of " + endTime);
            }
        }
        return this.comcatStartTime;
    }

    @Override
    protected long getComCatEndTime() {
        if (this.comcatEndTime == null) {
            if (this.cmd.hasOption("end-time")) {
                this.comcatEndTime = Long.parseLong(this.cmd.getOptionValue("end-time"));
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime);
            } else if (this.cmd.hasOption("end-year")) {
                int year = Integer.parseInt(this.cmd.getOptionValue("end-year"));
                GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                cal.clear();
                cal.set(year, 0, 1);
                this.comcatEndTime = cal.getTimeInMillis();
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime + ", from year: " + year);
            } else if (this.cmd.hasOption("end-date")) {
                String dateStr = this.cmd.getOptionValue("end-date");
                this.comcatEndTime = this.parseDateString(dateStr);
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime + ", from date: " + dateStr);
            } else if (this.cmd.hasOption("end-now")) {
                this.comcatEndTime = System.currentTimeMillis();
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime + " (current time)");
            } else if (this.cmd.hasOption("end-after")) {
                String eventID = this.cmd.getOptionValue("end-after");
                System.out.println("Fetching end-after event: " + eventID);
                this.endAfterEvent = this.accessor.fetchEvent(eventID, false);
                Preconditions.checkNotNull((Object)this.endAfterEvent, (String)"Couldn't locate end-after event %s", (Object)eventID);
                this.comcatEndTime = this.endAfterEvent.getOriginTime() + 1000L;
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime + " (1s after event " + eventID + ")");
            } else {
                Preconditions.checkArgument((boolean)this.cmd.hasOption("end-days-after"), (Object)"Must supply end time!");
                Preconditions.checkState((boolean)this.hasFiniteStartTime(), (Object)"Cannot have both relative start and end times");
                double days = Double.parseDouble(this.cmd.getOptionValue("end-days-after"));
                long startTime = this.getComCatStartTime();
                this.comcatEndTime = startTime + (long)(8.64E7 * days);
                System.out.println("Will end ComCat data fetch at " + this.comcatEndTime + ", " + (float)days + " after the start time of " + startTime);
            }
        }
        return this.comcatEndTime;
    }

    @Override
    protected long getSimulationStartTime(long comcatStartTime, long comcatEndTime) {
        return comcatEndTime + 1000L;
    }

    @Override
    protected String getBaseSimName() {
        long comcatStartTime = this.getComCatStartTime();
        long comcatEndTime = this.getComCatEndTime();
        Preconditions.checkNotNull((Object)comcatStartTime);
        Preconditions.checkNotNull((Object)comcatEndTime);
        long len = comcatEndTime - comcatStartTime;
        double years = (double)len / 3.15576E10;
        String name = "ComCat data " + ETAS_AbstractPlot.getTimeShortLabel(years);
        name = this.startAtEvent != null ? (this.endAfterEvent == null ? name + " after " + this.startAtEvent.getEventId() : name + " between " + this.startAtEvent.getEventId() + " and " + this.endAfterEvent.getEventId()) : (this.endAfterEvent != null ? name + " before " + this.endAfterEvent.getEventId() : (this.cmd.hasOption("start-after-historical") ? name + " between historical and " + argDateFormat.format(new Date(comcatEndTime)) : (this.cmd.hasOption("end-date") || this.cmd.hasOption("end-time") || this.cmd.hasOption("end-now") ? name + " before " + argDateFormat.format(new Date(comcatEndTime)) : name + " after " + argDateFormat.format(new Date(comcatStartTime)))));
        name = this.cmd.hasOption("region") ? name + ", Custom Region" : name + ", Statewide";
        return name;
    }

    @Override
    protected String getScriptName() {
        return "u3etas_comcat_config_builder.sh";
    }

    @Override
    public void buildConfiguration() throws IOException {
        boolean found;
        super.buildConfiguration();
        List<TriggerRupture> triggers = this.config.getTriggerRuptures();
        if (this.startAtEvent != null) {
            found = false;
            for (TriggerRupture trigger : triggers) {
                if (!this.startAtEvent.getEventId().equals(trigger.getComcatEventID())) continue;
                found = true;
                break;
            }
            if (this.startAtEvent.getMag() < this.minMag) {
                Preconditions.checkState((!found ? 1 : 0) != 0, (Object)"Start-at event should have been excluded due to min mag?");
                System.err.println("WARNING: Start-at event was excluded due to M" + (float)this.startAtEvent.getMag() + " less than MinMag=" + this.minMag.floatValue());
            } else {
                Preconditions.checkState((boolean)found, (Object)"Start-at event was supplied, but not present in final trigger list. Maybe it's not contained in the region or depth range?");
            }
        }
        if (this.endAfterEvent != null) {
            found = false;
            int i = triggers.size();
            while (--i >= 0) {
                TriggerRupture trigger;
                trigger = triggers.get(i);
                if (!this.endAfterEvent.getEventId().equals(trigger.getComcatEventID())) continue;
                found = true;
                break;
            }
            if (this.endAfterEvent.getMag() < this.minMag) {
                Preconditions.checkState((!found ? 1 : 0) != 0, (Object)"End-after event should have been excluded due to min mag?");
                System.err.println("WARNING: End-after event was excluded due to M" + (float)this.endAfterEvent.getMag() + " less than MinMag=" + this.minMag.floatValue());
            } else {
                Preconditions.checkState((boolean)found, (Object)"End-after event was supplied, but not present in final trigger list. Maybe it's not contained in the region or depth/magnitude range?");
            }
        }
    }
}

