/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.FileNameComparator;
import org.opensha.commons.util.MarkdownUtils;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_ComcatComparePlot;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ConfigBuilder;

public class ETAS_MarkdownIndexWriter {
    private static DateFormat outDateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private static DecimalFormat percentDF = new DecimalFormat("0.#%");

    private static Options createOptions() {
        Options ops = new Options();
        Option updateOption = new Option("u", "update-plots", false, "Flag to update plots for any catalog that might be stale due to a new version of the plotting code");
        updateOption.setRequired(false);
        ops.addOption(updateOption);
        Option dryRunOption = new Option("dry", "dry-run", false, "Don't actually replot any simulation dirs, but print if it would");
        dryRunOption.setRequired(false);
        ops.addOption(dryRunOption);
        Option forceUpdateOption = new Option("f", "force-update", false, "Force update of all plots (does not supercede --dry-run flag)");
        forceUpdateOption.setRequired(false);
        ops.addOption(forceUpdateOption);
        Option updateAfterOption = new Option("ua", "update-after", true, "Force update of all plots for simulations with configuration dates on or after the given date, specified as yyyy_mm_dd");
        updateAfterOption.setRequired(false);
        ops.addOption(updateAfterOption);
        Option updateIntevalOption = new Option("ui", "update-interval", true, "Update interval in minutes. If this is being run on a cron job, you can supply this optional hint argument to tell how often. It will attempt to exit and not process any more older simulations if within 20% of the interval of the next update.");
        updateIntevalOption.setRequired(false);
        ops.addOption(updateIntevalOption);
        Option threadsOption = new Option("t", "threads", true, "Number of calculation threads. Default is the number of available processors (in this case: " + SimulationMarkdownGenerator.defaultNumThreads() + ")");
        threadsOption.setRequired(false);
        ops.addOption(threadsOption);
        Option updateFileOption = new Option("uf", "update-file", true, "Path to an update file which lists the name of a sub-directory on each line for which to force update. You can optionally append the class name(s) (need not be fully qualified) of plots to update after the sub-directory name (space delimited) to only update certain plots. Will not throw and error if the file doesn't exist. After a successful update, all updated directories will be commented out in the update file.");
        updateFileOption.setRequired(false);
        ops.addOption(updateFileOption);
        return ops;
    }

    public static void main(String[] args) throws IOException {
        CommandLine cmd;
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            File gitDir = new File("/home/kevin/git/ucerf3-etas-results/");
            Object argz = "--update-plots";
            argz = (String)argz + " --dry-run";
            argz = (String)argz + " " + gitDir.getAbsolutePath();
            args = ((String)argz).split(" ");
        }
        Options options = ETAS_MarkdownIndexWriter.createOptions();
        Stopwatch runningWatch = Stopwatch.createStarted();
        DefaultParser parser = new DefaultParser();
        String syntax = ClassUtils.getClassNameWithoutPackage(SimulationMarkdownGenerator.class) + " [options] <etas-config.json> [<binary-catalogs-file.bin OR results directory>]";
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(syntax, options, true);
            System.exit(2);
            return;
        }
        args = cmd.getArgs();
        double updateInterval = cmd.hasOption("update-interval") ? Double.parseDouble(cmd.getOptionValue("update-interval")) : 0.0;
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)("Usage: " + ClassUtils.getClassNameWithoutPackage(ETAS_MarkdownIndexWriter.class) + " <dir>"));
        File mainDir = new File(args[0]);
        Preconditions.checkState((boolean)mainDir.exists());
        System.out.println("Scanning directory for ETAS subdirectories: " + mainDir.getAbsolutePath());
        File[] subDirArray = mainDir.listFiles();
        Arrays.sort(subDirArray, new FileNameComparator());
        ArrayList<SimulationDir> sims = new ArrayList<SimulationDir>();
        for (File subDir : subDirArray) {
            SimulationDir sim;
            if (!subDir.isDirectory() || (sim = ETAS_MarkdownIndexWriter.loadSimDir(subDir)) == null) continue;
            sims.add(sim);
        }
        if (sims.isEmpty()) {
            System.out.println("No ETAS subdirectories of " + mainDir.getAbsolutePath() + " found.");
            System.exit(0);
        }
        System.out.println("Found " + sims.size() + " ETAS subdirectories");
        Collections.sort(sims);
        boolean updatePlots = cmd.hasOption("update-plots");
        boolean forceUpdate = cmd.hasOption("force-update");
        if (updatePlots || forceUpdate) {
            String gitHash;
            boolean dryRun = cmd.hasOption("dry-run");
            long forceBeforeTime = Long.MAX_VALUE;
            if (cmd.hasOption("update-after")) {
                String dateStr = cmd.getOptionValue("update-after");
                try {
                    forceBeforeTime = ETAS_ConfigBuilder.df.parse(dateStr).getTime();
                }
                catch (Exception e) {
                    System.err.println("Expected date in the format: yyyy_mm_dd");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            int threads = cmd.hasOption("threads") ? Integer.parseInt(cmd.getOptionValue("threads")) : SimulationMarkdownGenerator.defaultNumThreads();
            Long gitTime = null;
            if (!forceUpdate && (gitTime = SimulationMarkdownGenerator.getGitCommitTime(gitHash = SimulationMarkdownGenerator.getGitHash())) == null) {
                System.out.println("Couldn't determine time associated with current ETAS_LAUNCHER git version, check $ETAS_LAUNCHER environmental variable or use --force-update to update plots");
            }
            File updateFile = cmd.hasOption("update-file") ? new File(cmd.getOptionValue("update-file")) : null;
            HashSet<String> updatedNames = new HashSet<String>();
            ArrayList<SimulationDir> plotSims = sims;
            if (updateFile != null && updateFile.exists()) {
                System.out.println("Reading update file: " + updateFile.getAbsolutePath());
                plotSims = new ArrayList(sims);
                for (String line : com.google.common.io.Files.readLines((File)updateFile, (Charset)Charset.defaultCharset())) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    String[] split = line.split(" ");
                    String dirName = split[0];
                    while (dirName.endsWith("/")) {
                        dirName = dirName.substring(0, dirName.length() - 1);
                    }
                    System.out.println("Looking to force-update: " + dirName);
                    for (int i = 0; i < plotSims.size(); ++i) {
                        SimulationDir dir = (SimulationDir)plotSims.get(i);
                        if (!dir.simDir.getName().equals(dirName)) continue;
                        System.out.println("Found a match! Will update");
                        dir.forceUpdate = true;
                        if (dir.plotMetadata != null && dir.plotMetadata.plots != null) {
                            List<SimulationMarkdownGenerator.PlotResult> plots = dir.plotMetadata.plots;
                            if (split.length == 1) {
                                plots.clear();
                            } else {
                                for (int j = 1; j < split.length; ++j) {
                                    String className = split[j].trim();
                                    int k = plots.size();
                                    while (--k >= 0) {
                                        if (!plots.get((int)k).className.endsWith(className)) continue;
                                        System.out.println("Will redo plot: " + plots.get((int)k).className);
                                        plots.remove(k);
                                    }
                                }
                            }
                        }
                        if (i <= 0) continue;
                        System.out.println("Moving to front of processing stack");
                        plotSims.remove(i);
                        plotSims.add(0, dir);
                    }
                }
            }
            System.out.println("Updating plots...");
            for (SimulationDir sim : plotSims) {
                File inputFile;
                System.out.println(sim.simDir.getName() + ": " + sim.config.getSimulationName());
                boolean update = false;
                if (forceUpdate) {
                    System.out.println("\tupdating due to --force-update");
                    update = true;
                }
                if (sim.forceUpdate) {
                    System.out.println("\tupdating due to --update-file");
                    update = true;
                }
                if (sim.plotMetadata == null) {
                    System.out.println("\tupdating due to missing plot metadata");
                    update = true;
                }
                if (sim.configDate != null && sim.configDate.getTime() >= forceBeforeTime) {
                    System.out.println("\tupdating due to configuration date on or after --update-after option");
                    update = true;
                }
                if (sim.plotMetadata != null && sim.plotMetadata.simulationsProcessed < sim.config.getNumSimulations()) {
                    File inputFile2;
                    try {
                        inputFile2 = SimulationMarkdownGenerator.locateInputFile(sim.config);
                    }
                    catch (Exception e) {
                        System.err.println("Couldn't locate input file, skipping");
                        continue;
                    }
                    Path file = inputFile2.toPath();
                    BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                    long modifyDate = attr.lastModifiedTime().toMillis();
                    double daysOld = (double)(System.currentTimeMillis() - modifyDate) / 8.64E7;
                    if (sim.plotMetadata != null && sim.plotMetadata.plotStartTime < modifyDate) {
                        System.out.println("\tupdating because the simulation was not complete when last plotted and input file modified " + ETAS_AbstractPlot.getTimeShortLabel(daysOld / 365.25) + " ago");
                        update = true;
                    } else {
                        System.out.println("\tsimulation was not complete when last plotted, but results file has not been modified since");
                    }
                }
                if (!update && updateInterval > 0.0) {
                    double curInterval = (double)runningWatch.elapsed(TimeUnit.SECONDS) / 60.0;
                    double fractInterval = curInterval / updateInterval;
                    int numMissed = (int)fractInterval;
                    if (fractInterval > 1.0) {
                        fractInterval -= Math.floor(fractInterval);
                    }
                    double minsUntilNext = (1.0 - fractInterval) * updateInterval;
                    double threshold = 1.0 - 0.1 * (double)(numMissed + 2);
                    if (fractInterval > threshold) {
                        System.out.println("\tskipping update checks on old sim as we're " + (float)minsUntilNext + " minutes away from the next automated plot update, will try again next time");
                        continue;
                    }
                }
                if (sim.plotMetadata != null && sim.plotMetadata.launcherGitTime != null && gitTime != null) {
                    long curDiff = gitTime - sim.plotMetadata.launcherGitTime;
                    double curDiffDays = (double)curDiff / 8.64E7;
                    if (curDiff > 0L) {
                        System.out.println("\tupdating due to new jar file (" + (float)curDiffDays + " days newer)");
                        update = true;
                    }
                }
                if (sim.config.getComcatMetadata() != null) {
                    SimulationMarkdownGenerator.PlotResult prevComcatResult = null;
                    if (sim.plotMetadata != null && sim.plotMetadata.plots != null) {
                        for (SimulationMarkdownGenerator.PlotResult result : sim.plotMetadata.plots) {
                            if (!result.className.equals(ETAS_ComcatComparePlot.class.getName())) continue;
                            prevComcatResult = result;
                        }
                    }
                    if (prevComcatResult == null) {
                        System.out.println("\tupdating because no metadata from previous ComCat plot");
                        update = true;
                    } else if (ETAS_ComcatComparePlot.shouldReplot(prevComcatResult, sim.config)) {
                        System.out.println("\tupdating ComCat plots");
                        update = true;
                    }
                }
                if (!update || dryRun) continue;
                try {
                    inputFile = SimulationMarkdownGenerator.locateInputFile(sim.config);
                }
                catch (Exception e) {
                    System.err.println("Couldn't locate input file, skipping");
                    continue;
                }
                try {
                    sim.plotMetadata = SimulationMarkdownGenerator.generateMarkdown(sim.configFile, inputFile, sim.config, sim.simDir, false, -1, threads, forceUpdate, false, sim.plotMetadata, null);
                    updatedNames.add(sim.simDir.getName());
                }
                catch (Exception e) {
                    System.err.println("Error updating plots for " + sim.simDir.getName());
                    e.printStackTrace();
                }
            }
            if (updateFile != null && updateFile.exists() && !updatedNames.isEmpty()) {
                System.out.println("Updating update-file to comment out updated simulations");
                File newUpdateFile = new File(updateFile.getAbsolutePath() + ".tmp");
                try {
                    FileWriter fw = new FileWriter(newUpdateFile);
                    for (Object line : com.google.common.io.Files.readLines((File)updateFile, (Charset)Charset.defaultCharset())) {
                        if (!((String)line).startsWith("#") && !((String)line).isEmpty()) {
                            String trimmed = ((String)line).trim();
                            if (((String)line).contains(" ")) {
                                trimmed = trimmed.substring(0, trimmed.indexOf(" "));
                            }
                            if (updatedNames.contains(trimmed)) {
                                line = "#" + (String)line;
                            }
                        }
                        fw.write((String)line + "\n");
                    }
                    fw.close();
                    com.google.common.io.Files.move((File)newUpdateFile, (File)updateFile);
                }
                catch (Exception e) {
                    System.err.println("WARNING: error updating update-file");
                    e.printStackTrace();
                }
            }
        }
        MarkdownUtils.TableBuilder simsTable = MarkdownUtils.tableBuilder();
        simsTable.addLine("Config Date", "Name", "Sim Start Date", "# Simulations", "Progress", "Plot Date");
        for (SimulationDir sim : sims) {
            int numDone;
            boolean hasResults;
            Date date = sim.configDate;
            File subDir = sim.simDir;
            ETAS_Config config = sim.config;
            System.out.println("Processing " + subDir.getName() + ": " + config.getSimulationName() + (String)(date == null ? "" : " (" + date.getTime() + ")"));
            File subMD = new File(subDir, "README.md");
            String name = config.getSimulationName() == null ? subDir.getName() : config.getSimulationName();
            File plotsDir = new File(subDir, "plots");
            boolean bl = hasResults = subMD.exists() && plotsDir.exists();
            if (!subMD.exists()) {
                System.out.println("\tREADME.md doesn't yet exist, building");
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("# " + name);
                lines.add("");
                File inputsDir = new File(subDir, "config_input_plots");
                if (inputsDir.exists()) {
                    lines.add("No simulation results are yet available, but pre-simulation analysis plots are available [here](" + inputsDir.getName() + "/README.md).");
                } else {
                    lines.add("No simulation results are yet available.");
                }
                lines.add("");
                lines.add("## JSON Input File");
                lines.add("```");
                for (String line : com.google.common.io.Files.readLines((File)sim.configFile, (Charset)Charset.defaultCharset())) {
                    lines.add(line);
                }
                lines.add("```");
                lines.add("");
                MarkdownUtils.writeReadmeAndHTML(lines, subDir);
            }
            simsTable.initNewLine();
            if (date == null) {
                simsTable.addColumn("*Unknown*");
            } else {
                simsTable.addColumn(outDateFormat.format(date));
            }
            simsTable.addColumn("[" + name + "](" + subDir.getName() + "/README.md)");
            simsTable.addColumn(outDateFormat.format(new Date(config.getSimulationStartTimeMillis())));
            simsTable.addColumn(config.getNumSimulations());
            String progressStr = sim.plotMetadata != null ? ((numDone = sim.plotMetadata.simulationsProcessed) == config.getNumSimulations() ? "Done" : percentDF.format((double)numDone / (double)config.getNumSimulations())) : "Unknown";
            simsTable.addColumn(progressStr);
            if (sim.plotMetadata == null) {
                simsTable.addColumn("Unknown");
            } else {
                simsTable.addColumn(outDateFormat.format(new Date(sim.plotMetadata.plotEndTime)));
            }
            simsTable.finalizeLine();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# ETAS Simulations List");
        lines.add("");
        lines.addAll(simsTable.build());
        lines.add("");
        MarkdownUtils.writeReadmeAndHTML(lines, mainDir);
        runningWatch.stop();
        double secs = (double)runningWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        double mins = secs / 60.0;
        if (mins > 1.0) {
            System.out.println("Took " + (float)mins + " minutes to rebuild index");
        } else {
            System.out.println("Took " + (float)secs + " seconds to rebuild index");
        }
        System.exit(0);
    }

    private static SimulationDir loadSimDir(File simDir) throws IOException {
        ETAS_Config config = null;
        File configFile = null;
        for (File file : simDir.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                config = ETAS_Config.readJSON(file);
                configFile = file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config != null) {
            String dateStr;
            File metadataFile;
            File plotsDir = new File(simDir, "plots");
            SimulationMarkdownGenerator.PlotMetadata plotMetadata = null;
            if (plotsDir.exists() && (metadataFile = new File(plotsDir, "metadata.json")).exists()) {
                plotMetadata = SimulationMarkdownGenerator.readPlotMetadata(metadataFile);
            }
            Date configDate = null;
            if (config.getConfigTime() != null) {
                configDate = new Date(config.getConfigTime());
            }
            String dirName = simDir.getName();
            if (configDate == null && dirName.contains("-") && (dateStr = dirName.substring(0, dirName.indexOf("-"))).contains("_")) {
                try {
                    configDate = ETAS_ConfigBuilder.df.parse(dateStr);
                }
                catch (Exception e) {
                    System.out.println("Couldn't parse date from dirName: " + dateStr);
                }
            }
            if (configDate == null) {
                try {
                    Path file = configFile.toPath();
                    BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                    configDate = new Date(attr.creationTime().toMillis());
                }
                catch (Exception e) {
                    System.out.println("Error determining config file creation date: " + e.getMessage());
                }
            }
            return new SimulationDir(simDir, configFile, config, plotsDir, plotMetadata, configDate);
        }
        return null;
    }

    private static class SimulationDir
    implements Comparable<SimulationDir> {
        File simDir;
        File configFile;
        ETAS_Config config;
        File plotsDir;
        SimulationMarkdownGenerator.PlotMetadata plotMetadata;
        Date configDate;
        boolean forceUpdate = false;

        public SimulationDir(File simDir, File configFile, ETAS_Config config, File plotsDir, SimulationMarkdownGenerator.PlotMetadata plotMetadata, Date configDate) {
            this.simDir = simDir;
            this.configFile = configFile;
            this.config = config;
            this.plotsDir = plotsDir;
            this.plotMetadata = plotMetadata;
            this.configDate = configDate;
        }

        @Override
        public int compareTo(SimulationDir o) {
            if (this.configDate == null) {
                if (o.configDate == null) {
                    return 0;
                }
                return -1;
            }
            if (o.configDate == null) {
                return 1;
            }
            int ret = -Long.compare(this.configDate.getTime(), o.configDate.getTime());
            return ret;
        }
    }
}

