/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskLogStatsGen;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.FileNameComparator;
import org.opensha.commons.util.cpt.CPT;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;

class LogFileBenchmark {
    private static final double[] fractiles = new double[]{0.0, 0.025, 0.25, 0.5, 0.75, 0.975, 1.0};
    private DiscretizedFunc meanFunc;
    private DiscretizedFunc timeToSolFunc;
    private DiscretizedFunc[] fractileFuncs;
    private String title;
    private String xValName;
    private String yValName;
    private static double seconds_to_years = 3.168808781402895E-8;

    public LogFileBenchmark(String title, String xValName, String yValName) {
        this.title = title;
        this.xValName = xValName;
        this.yValName = yValName;
        this.meanFunc = new ArbitrarilyDiscretizedFunc();
        this.timeToSolFunc = new ArbitrarilyDiscretizedFunc();
        this.fractileFuncs = new DiscretizedFunc[fractiles.length];
        for (int f = 0; f < fractiles.length; ++f) {
            this.fractileFuncs[f] = new ArbitrarilyDiscretizedFunc();
        }
    }

    public void addLog(double xVal, File logFile, boolean first) throws IOException {
        if (logFile.isDirectory()) {
            File[] files = logFile.listFiles();
            Arrays.sort(files, new FileNameComparator());
            for (File file : files) {
                if (!file.getName().contains(".slurm.o")) continue;
                logFile = file;
                if (first) break;
            }
            Preconditions.checkState((!logFile.isDirectory() ? 1 : 0) != 0, (Object)("No slurm output files found in " + logFile.getAbsolutePath()));
        }
        System.out.println("Processing " + logFile.getAbsolutePath());
        Object firstStart = null;
        Object lastEnd = null;
        Date latestDate = null;
        HashMap<Integer, Object> startDates = new HashMap<Integer, Object>();
        HashMap<Integer, Object> endDates = new HashMap<Integer, Object>();
        BufferedReader read = new BufferedReader(new FileReader(logFile), 81920);
        for (String line : new MPJTaskLogStatsGen.LogFileIterable(read)) {
            Integer index;
            String indexStr;
            Object date;
            if (!line.startsWith("[") || !line.contains("]:") || (date = MPJTaskLogStatsGen.parseDate((String)line, latestDate)) == null) continue;
            latestDate = date;
            if ((line = line.trim()).contains("calculating") && !line.contains("batch")) {
                indexStr = line.substring(line.indexOf("calculating") + "calculating".length()).trim();
                index = Integer.parseInt(indexStr);
                if (startDates.containsKey(index)) {
                    System.out.println("WARNING: duplicate start found for index " + index);
                }
                startDates.put(index, date);
                if (firstStart == null) {
                    firstStart = date;
                }
            }
            if (!line.contains("completed") || line.contains("binary")) continue;
            indexStr = line.substring(line.indexOf("completed") + "completed".length()).trim();
            index = Integer.parseInt(indexStr);
            if (endDates.containsKey(index)) {
                System.out.println("WARNING: duplicate end found for index " + index);
            }
            endDates.put(index, date);
            lastEnd = date;
        }
        System.out.println("Found " + startDates.size() + " start times");
        System.out.println("Found " + endDates.size() + " end times");
        ArrayList<Double> durations = new ArrayList<Double>();
        int numMissing = 0;
        for (Integer index : endDates.keySet()) {
            Date start = (Date)startDates.get(index);
            if (start == null) {
                System.out.println("Start date not found for " + index);
                ++numMissing;
                continue;
            }
            Date end = (Date)endDates.get(index);
            long deltaMillis = end.getTime() - start.getTime();
            Preconditions.checkState((deltaMillis >= 0L ? 1 : 0) != 0);
            double durationSecs = (double)deltaMillis / 1000.0;
            durations.add(durationSecs);
        }
        if (numMissing > 0) {
            System.out.println(numMissing + " were missing");
        }
        long wallDurationMillis = ((Date)lastEnd).getTime() - ((Date)firstStart).getTime();
        double wallDuration = (double)wallDurationMillis / 1000.0;
        System.out.println("\tTotal duration: " + ETAS_AbstractPlot.getTimeShortLabel(wallDuration * seconds_to_years));
        double[] durationsArray = Doubles.toArray(durations);
        double mean = StatUtils.mean((double[])durationsArray);
        double max = StatUtils.max((double[])durationsArray);
        double min = StatUtils.min((double[])durationsArray);
        double sum = StatUtils.sum((double[])durationsArray);
        System.out.println("\tMean sim duration: " + ETAS_AbstractPlot.getTimeShortLabel(mean * seconds_to_years));
        System.out.println("\tMin sim duration: " + ETAS_AbstractPlot.getTimeShortLabel(min * seconds_to_years));
        System.out.println("\tMax sim duration: " + ETAS_AbstractPlot.getTimeShortLabel(max * seconds_to_years));
        System.out.println("\tTotal sim duration: " + ETAS_AbstractPlot.getTimeShortLabel(sum * seconds_to_years));
        this.timeToSolFunc.set(xVal, wallDuration / 3600.0);
        this.meanFunc.set(xVal, mean / 60.0);
        for (int f = 0; f < fractiles.length; ++f) {
            double val = fractiles[f] == 0.0 ? min : (fractiles[f] == 1.0 ? max : StatUtils.percentile((double[])durationsArray, (double)(fractiles[f] * 100.0)));
            System.out.println("\t\tFractile " + fractiles[f] + " => " + ETAS_AbstractPlot.getTimeShortLabel(val * seconds_to_years));
            this.fractileFuncs[f].set(xVal, val / 60.0);
        }
    }

    public void plot() throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        funcs.add(this.timeToSolFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, this.title, this.xValName, this.yValName);
        PlotPreferences plotPrefs = PlotPreferences.getDefault();
        plotPrefs.setTickLabelFontSize(18);
        plotPrefs.setAxisLabelFontSize(20);
        plotPrefs.setPlotLabelFontSize(21);
        plotPrefs.setBackgroundColor(Color.WHITE);
        HeadlessGraphPanel gp = new HeadlessGraphPanel(plotPrefs);
        gp.drawGraphPanel(spec);
        gp.getChartPanel().setSize(800, 600);
        gp.saveAsPNG("/tmp/scaling.png");
        gp.saveAsPDF("/tmp/scaling.pdf");
        GraphWindow gw = new GraphWindow(spec);
        gw.setDefaultCloseOperation(3);
        funcs = new ArrayList();
        chars = new ArrayList();
        funcs.add(this.meanFunc);
        this.meanFunc.setName("Mean");
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        CPT fractileCPT = new CPT(0.0, 1.0, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.LIGHT_GRAY);
        for (int f = 0; f < fractiles.length; ++f) {
            double percentile = fractiles[f] * 100.0;
            this.fractileFuncs[f].setName((float)percentile + " %-ile");
            funcs.add(this.fractileFuncs[f]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, fractileCPT.getColor((float)fractiles[f])));
        }
        spec = new PlotSpec(funcs, chars, "Time Per Sim", this.xValName, "Time (minutes)");
        spec.setLegendVisible(true);
        gw = new GraphWindow(spec);
        gw.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) throws IOException {
        File outputDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations");
        String prefix = "2019_06_08-Spontaneous-includeSpont-historicalCatalog-full_td-10yr-noReuse-5nodes_";
        int[] threads = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        boolean first = false;
        LogFileBenchmark benchmark = new LogFileBenchmark("OpenSHA UCERF3-ETAS Stampede2 SKX Scaling", "# Threads per SKX Node", "Time To Solution (hours)");
        for (int thread : threads) {
            File dir = new File(outputDir, prefix + thread + "threads");
            try {
                benchmark.addLog(thread, dir, first);
            }
            catch (Exception e) {
                System.out.println("Skipping " + dir.getName());
                e.printStackTrace();
            }
        }
        benchmark.plot();
    }
}

