/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.UCERF2_Mapped;

import java.util.ArrayList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis.NSHMP_GridSourceGenerator;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2_FM2pt1_wOutAftershocks;

public class UCERF2_FM2pt1_FaultSysSolERF
extends FaultSystemSolutionERF {
    private static final boolean D = false;
    NSHMP_GridSourceGenerator nshmp_gridSrcGen;
    protected ArrayList<ProbEqkSource> fixedStrikeSources;
    protected int numGridSources;

    public UCERF2_FM2pt1_FaultSysSolERF() {
        super(UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(FaultModels.FM2_1));
        this.nshmp_gridSrcGen = new NSHMP_GridSourceGenerator(this.bgSettings.distanceCorrections);
        this.setParameter("Aleatory Mag-Area StdDev", 0.12);
        this.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
    }

    @Override
    protected ProbEqkSource getOtherSource(int iSource) {
        if (iSource < this.numGridSources) {
            if (this.bgSettings.surfaceType.equals((Object)BackgroundRupType.CROSSHAIR)) {
                return this.nshmp_gridSrcGen.getCrosshairGriddedSource(iSource, this.timeSpan.getDuration());
            }
            return this.nshmp_gridSrcGen.getRandomStrikeGriddedSource(iSource, this.timeSpan.getDuration());
        }
        return this.fixedStrikeSources.get(iSource - this.numGridSources);
    }

    @Override
    protected boolean initOtherSources() {
        if (this.bgSettings.surfaceType.equals((Object)BackgroundRupType.POINT)) {
            this.nshmp_gridSrcGen.setAsPointSources(true);
        } else {
            this.nshmp_gridSrcGen.setAsPointSources(false);
        }
        this.fixedStrikeSources = new ArrayList();
        this.fixedStrikeSources.addAll(this.nshmp_gridSrcGen.getAllFixedStrikeSources(this.timeSpan.getDuration()));
        this.numGridSources = this.nshmp_gridSrcGen.getNumSources();
        this.numOtherSources = this.numGridSources + this.fixedStrikeSources.size();
        return true;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        if (event.getParameter() == this.bgSettingsParam) {
            this.nshmp_gridSrcGen.setDistanceCorrections(this.bgSettings.distanceCorrections);
        }
    }

    public static void main(String[] args) {
        ModMeanUCERF2_FM2pt1_wOutAftershocks testERF = new ModMeanUCERF2_FM2pt1_wOutAftershocks();
        testERF.updateForecast();
        for (int s = 0; s < testERF.getNumSources(); ++s) {
            System.out.println(s + "\t" + testERF.getSource(s).getName());
        }
    }
}

