/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.mean;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.mean.RakeBasisWriter;
import scratch.UCERF3.erf.mean.RuptureCombiner;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.UCERF3_Downloader;

public class MeanUCERF3
extends FaultSystemSolutionERF {
    private static final boolean D = false;
    public static final String NAME = "Mean UCERF3";
    static final String RAKE_BASIS_FILE_NAME = "rake_basis.zip";
    static final String TRUE_MEAN_FILE_NAME = "mean_ucerf3_sol.zip";
    private EnumParameter<Presets> presetsParam;
    public static final String UPPER_DEPTH_TOL_PARAM_NAME = "Sect Upper Depth Averaging Tolerance";
    public static final double UPPER_DEPTH_TOL_MIN = 0.0;
    public static final double UPPER_DEPTH_TOL_MAX = 100.0;
    private DoubleParameter upperDepthTolParam;
    private double upperDepthTol;
    private BooleanParameter upperDepthUseMeanParam;
    private boolean upperDepthUseMean;
    private DoubleParameter magTolParam;
    private double magTol;
    private StringParameter rakeBasisParam;
    private String rakeBasisStr;
    public static final String RAKE_BASIS_NONE = "Do Not Combine";
    public static final String RAKE_BASIS_MEAN = "Def. Model Mean";
    private Map<Set<String>, Double> rakeBasis;
    public static final String FAULT_MODEL_PARAM_NAME = "Fault Model(s)";
    private StringParameter faultModelParam;
    private String faultModelStr;
    public static final String FAULT_MODEL_BOTH = "Both";
    private BooleanParameter ignoreCacheParam;
    private boolean ignoreCache;
    private File storeDir;
    private FaultSystemSolution meanTotalSol;
    private DiscretizedFunc[] meanTotalMFDs;
    private Map<Integer, List<LastEventData>> lastEventData;
    public static boolean show_progress = true;

    @Deprecated
    public static File getStoreDir() {
        File uc3Dir;
        String path = System.getProperty("uc3.store");
        if (path != null) {
            File file = new File(path);
            if (!file.exists()) {
                Preconditions.checkState((boolean)file.mkdir(), (Object)("Couldn't create uc3.store location: " + file.getAbsolutePath()));
            }
            return file;
        }
        File scratchDir = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR;
        if (scratchDir.exists()) {
            File meanDir = new File(scratchDir, "UCERF3_ERF");
            if (!meanDir.exists()) {
                Preconditions.checkState((boolean)meanDir.mkdir(), (Object)("Couldn't create UCERF3 ERF eclipse location: " + meanDir.getAbsolutePath()));
            }
            return meanDir;
        }
        path = System.getProperty("user.home");
        File homeDir = new File(path);
        Preconditions.checkState((boolean)homeDir.exists(), (Object)("user.home dir doesn't exist: " + path));
        File openSHADir = new File(homeDir, ".opensha");
        if (!openSHADir.exists()) {
            Preconditions.checkState((boolean)openSHADir.mkdir(), (Object)("Couldn't create OpenSHA store location: " + openSHADir.getAbsolutePath()));
        }
        if (!(uc3Dir = new File(openSHADir, "ucerf3_erf")).exists()) {
            Preconditions.checkState((boolean)uc3Dir.mkdir(), (Object)("Couldn't create UCERF3 ERF store location: " + uc3Dir.getAbsolutePath()));
        }
        return uc3Dir;
    }

    public MeanUCERF3() {
        this(UCERF3_Downloader.getStoreDir());
    }

    public MeanUCERF3(File storeDir) {
        this(null, storeDir);
    }

    public MeanUCERF3(FaultSystemSolution meanTotalSol) {
        this(meanTotalSol, UCERF3_Downloader.getStoreDir());
    }

    public MeanUCERF3(FaultSystemSolution meanTotalSol, File storeDir) {
        this.fileParamChanged = false;
        this.meanTotalSol = meanTotalSol;
        this.storeDir = storeDir;
        System.out.println("MeanUCERF3 store dir: " + String.valueOf(storeDir));
        Preconditions.checkState((boolean)storeDir.exists(), (Object)("Store dir doesn't exist: " + storeDir.getAbsolutePath()));
        this.presetsParam = new EnumParameter<Presets>("Mean UCERF3 Presets", EnumSet.allOf(Presets.class), Presets.FM3_1_BRANCH_AVG, "(custom)");
        this.presetsParam.addParameterChangeListener(this);
        this.upperDepthTolParam = new DoubleParameter(UPPER_DEPTH_TOL_PARAM_NAME, 0.0, 100.0);
        this.upperDepthTolParam.setValue(0.0);
        this.upperDepthTolParam.setUnits("km");
        this.upperDepthTolParam.setInfo("Some fault sections have different aseismicity values across UCERF3\nlogic tree branches. These values change the upper depth of the fault section. If > 0,\nsections with upper depths within the given tolerance of the mean will be combined in order\nto reduce the overall section and rupture count.");
        this.upperDepthTolParam.addParameterChangeListener(this);
        this.upperDepthTol = (Double)this.upperDepthTolParam.getValue();
        this.upperDepthUseMeanParam = new BooleanParameter("Use Mean Upper Depth", true);
        this.upperDepthUseMeanParam.setInfo("If true and upper depth combine tolerance is > 0, mean upper\ndepth will be used, else the shallowest upper depth will be used when averaging.\nNote that averaging does not incorporate participation rates, it is an unweighted mean\nand may not be representative.");
        this.upperDepthUseMeanParam.addParameterChangeListener(this);
        this.upperDepthUseMean = (Boolean)this.upperDepthUseMeanParam.getValue();
        this.magTolParam = new DoubleParameter("Rup Mag Averaging Tolerance", 0.0, 1.0);
        this.magTolParam.setValue(0.0);
        this.magTolParam.setInfo("Each rupture has a suite of magnitudes from the different scaling relationships.\nThese magnitudes can be averaged (within a tolerance) in order to reduce the total rupture\ncount. Magnitudes are averaged weighted by their rate. Set to '1' to average all mags\nfor each rupture.");
        this.magTolParam.addParameterChangeListener(this);
        this.magTol = (Double)this.magTolParam.getValue();
        ArrayList rakeBasisStrs = Lists.newArrayList((Object[])new String[]{RAKE_BASIS_NONE, RAKE_BASIS_MEAN});
        for (DeformationModels dm : DeformationModels.values()) {
            if (!(dm.getRelativeWeight(null) > 0.0)) continue;
            rakeBasisStrs.add(dm.name());
        }
        this.rakeBasisParam = new StringParameter("Rupture Rake To Use", rakeBasisStrs, RAKE_BASIS_NONE);
        this.rakeBasisParam.setInfo("Each deformation model supplies rake values for each fault section\n(and thus each rupture). Invididual rakes can be used, or the rupture count can\nbe reduced by either using the rate-averaged rake or rakes from a specific\ndeformation model.");
        this.rakeBasisParam.addParameterChangeListener(this);
        this.rakeBasisStr = (String)this.rakeBasisParam.getValue();
        ArrayList faultModelStrs = Lists.newArrayList((Object[])new String[]{FAULT_MODEL_BOTH});
        for (FaultModels fm : FaultModels.values()) {
            if (!(fm.getRelativeWeight(null) > 0.0)) continue;
            faultModelStrs.add(fm.name());
        }
        this.faultModelParam = new StringParameter(FAULT_MODEL_PARAM_NAME, faultModelStrs, FAULT_MODEL_BOTH);
        this.faultModelParam.setInfo("There are two equally weighted Fault Models in UCERF3. You can optionally\nselect a single fault model with this parameter.");
        this.faultModelParam.addParameterChangeListener(this);
        this.faultModelStr = (String)this.faultModelParam.getValue();
        this.ignoreCacheParam = new BooleanParameter("Ignore Cache", false);
        this.ignoreCacheParam.setInfo("MeanUCERF3 caches reduced solutions to save time. Setting this to\ntrue will disable loading cached versions.");
        this.ignoreCacheParam.addParameterChangeListener(this);
        this.ignoreCache = (Boolean)this.ignoreCacheParam.getValue();
        this.aleatoryMagAreaStdDevParam.setValue(0.0);
        this.doSetPreset((Presets)((Object)this.presetsParam.getValue()));
        this.loadRakeBasis();
        this.createParamList();
    }

    @Override
    protected void createParamList() {
        super.createParamList();
        if (this.upperDepthTolParam == null) {
            return;
        }
        this.adjustableParams.addParameter(0, this.presetsParam);
        this.adjustableParams.addParameter(this.upperDepthTolParam);
        this.adjustableParams.addParameter(this.upperDepthUseMeanParam);
        this.adjustableParams.addParameter(this.magTolParam);
        this.adjustableParams.addParameter(this.rakeBasisParam);
        this.adjustableParams.addParameter(this.faultModelParam);
        this.adjustableParams.addParameter(this.ignoreCacheParam);
        if (this.adjustableParams.containsParameter("Solution Input File")) {
            this.adjustableParams.removeParameter(this.fileParam);
        }
    }

    @Override
    public void updateForecast() {
        if (this.getSolution() == null) {
            this.fetchSolution();
        }
        this.checkTimeDepCompatibility(true);
        if (this.getParameter("Probability Model").getValue() != ProbabilityModelOptions.POISSON) {
            Preconditions.checkState((boolean)this.isTimeDepCompatible(), (Object)"The given parameterization is not compatible with time dependence. When multiple fault models are used, or upper depth tolerance < 10, MeanUCERF3 creates multiple instances of each subsection, each of which has a portion of the rate, and thus a longer recurrence interval. This throws off the BPT calculations which use the subsection recurrence interval.");
            if (this.lastEventData == null) {
                try {
                    this.lastEventData = LastEventData.load();
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
            LastEventData.populateSubSects(this.getSolution().getRupSet().getFaultSectionDataList(), this.lastEventData);
        }
        super.updateForecast();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        Parameter param;
        Presets preset = null;
        if (this.presetsParam != null) {
            preset = (Presets)((Object)this.presetsParam.getValue());
        }
        if ((param = event.getParameter()) == this.upperDepthTolParam) {
            this.upperDepthTol = (Double)this.upperDepthTolParam.getValue();
            if (preset != null && this.upperDepthTol != preset.upperDepthTol) {
                this.setPreset(null);
            }
            this.setSolution(null);
            this.checkTimeDepCompatibility(false);
        } else if (param == this.upperDepthUseMeanParam) {
            this.upperDepthUseMean = (Boolean)this.upperDepthUseMeanParam.getValue();
            if (preset != null && this.upperDepthUseMean != preset.upperDepthUseMean) {
                this.setPreset(null);
            }
            this.setSolution(null);
        } else if (param == this.magTolParam) {
            this.magTol = (Double)this.magTolParam.getValue();
            if (preset != null && this.magTol != preset.magTol) {
                this.setPreset(null);
            }
            this.setSolution(null);
        } else if (param == this.rakeBasisParam) {
            this.rakeBasisStr = (String)this.rakeBasisParam.getValue();
            if (preset != null && !this.rakeBasisStr.equals(preset.rakeBasisStr)) {
                this.setPreset(null);
            }
            this.loadRakeBasis();
            this.setSolution(null);
        } else if (param == this.faultModelParam) {
            this.faultModelStr = (String)this.faultModelParam.getValue();
            if (preset != null) {
                if (preset.fm == null) {
                    if (!this.faultModelStr.equals(FAULT_MODEL_BOTH)) {
                        this.setPreset(null);
                    }
                } else if (!preset.fm.name().equals(this.faultModelStr)) {
                    this.setPreset(null);
                }
            }
            this.setTrueMeanSol(null);
            this.setSolution(null);
            this.checkTimeDepCompatibility(false);
        } else if (param == this.ignoreCacheParam) {
            this.ignoreCache = (Boolean)this.ignoreCacheParam.getValue();
            this.setSolution(null);
        } else if (param == this.presetsParam) {
            this.doSetPreset(preset);
        } else {
            super.parameterChange(event);
        }
    }

    public void setPreset(Presets preset) {
        this.presetsParam.setValue(preset);
        this.presetsParam.getEditor().refreshParamEditor();
    }

    private void doSetPreset(Presets preset) {
        if (preset == null) {
            return;
        }
        this.upperDepthTolParam.setValue(preset.upperDepthTol);
        this.upperDepthTolParam.getEditor().refreshParamEditor();
        this.upperDepthUseMeanParam.setValue(preset.upperDepthUseMean);
        this.upperDepthUseMeanParam.getEditor().refreshParamEditor();
        this.magTolParam.setValue(preset.magTol);
        this.magTolParam.getEditor().refreshParamEditor();
        this.rakeBasisParam.setValue(preset.rakeBasisStr);
        this.rakeBasisParam.getEditor().refreshParamEditor();
        FaultModels fm = preset.fm;
        if (fm == null) {
            this.faultModelParam.setValue(FAULT_MODEL_BOTH);
        } else {
            this.faultModelParam.setValue(fm.name());
        }
        this.faultModelParam.getEditor().refreshParamEditor();
    }

    private void checkTimeDepCompatibility(boolean warn) {
        if (!this.isTimeDepCompatible() && !this.isPoisson()) {
            if (warn) {
                String title = "Setting Probability Model to Poisson";
                String message = "The given parameterization is not compatible with time dependence.\nWhen multiple fault models are used, or upper depth tolerance < 10,\nMeanUCERF3 creates multiple instances of each subsection, each of which\nhas a portion of the rate, and thus a longer recurrence interval. This throws\noff the BPT calculations which use the subsection recurrence interval.\n\nIt has now been set to Poisson.";
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
            this.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            this.getParameter("Probability Model").getEditor().refreshParamEditor();
        }
    }

    private boolean isTimeDepCompatible() {
        if (this.faultModelStr.equals(FAULT_MODEL_BOTH)) {
            return false;
        }
        return !(this.upperDepthTol < 10.0);
    }

    private void loadRakeBasis() {
        if (this.rakeBasisStr.equals(RAKE_BASIS_NONE) || this.rakeBasisStr.equals(RAKE_BASIS_MEAN)) {
            this.rakeBasis = null;
            return;
        }
        this.checkDownload(RAKE_BASIS_FILE_NAME).thenAccept(rakeBasisFile -> {
            if (rakeBasisFile == null || !rakeBasisFile.exists()) {
                return;
            }
            DeformationModels dm = null;
            for (DeformationModels testDM : DeformationModels.values()) {
                if (!testDM.name().equals(this.rakeBasisStr)) continue;
                dm = testDM;
                break;
            }
            Preconditions.checkState((dm != null ? 1 : 0) != 0, (Object)("Couldn't find DM: " + this.rakeBasisStr));
            try {
                ZipFile zip = new ZipFile((File)rakeBasisFile);
                this.rakeBasis = RakeBasisWriter.loadRakeBasis(zip, dm);
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        });
    }

    public boolean isTrueMean() {
        return this.upperDepthTol == 0.0 && this.magTol == 0.0 && this.rakeBasisStr.equals(RAKE_BASIS_NONE);
    }

    public void setTrueMeanSol(FaultSystemSolution meanTotalSol) {
        this.meanTotalSol = meanTotalSol;
        this.meanTotalMFDs = meanTotalSol == null ? null : (meanTotalSol.hasModule(RupMFDsModule.class) ? meanTotalSol.getModule(RupMFDsModule.class).getRuptureMFDs() : null);
    }

    private void fetchSolution() {
        FaultSystemSolution reducedSol;
        boolean combineRakes;
        String fName = "dep" + (float)this.upperDepthTol;
        fName = this.upperDepthUseMean && this.upperDepthTol > 0.0 ? fName + "_depMean" : fName + "_depShallow";
        fName = this.rakeBasisStr.equals(RAKE_BASIS_MEAN) ? fName + "_rakeMean" : (this.rakeBasisStr.equals(RAKE_BASIS_NONE) ? fName + "_rakeAll" : fName + "_rake" + this.rakeBasisStr);
        Object prefix = this.faultModelStr.equals(FAULT_MODEL_BOTH) ? "" : this.faultModelStr + "_";
        fName = (String)prefix + fName;
        File solFile = new File(this.storeDir, "cached_" + fName + ".zip");
        if (!this.ignoreCache) {
            File solutionFile;
            try {
                CompletableFuture<File> solFileDownloader = this.checkDownload(solFile.getName());
                solutionFile = solFileDownloader.join();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                solutionFile = solFile;
            }
            try {
                FaultSystemSolution sol = FaultSystemSolution.load(solutionFile);
                this.checkCombineMags(sol);
                this.setSolution(sol);
                return;
            }
            catch (Exception sol) {
                // empty catch block
            }
        }
        if (this.meanTotalSol == null) {
            // empty if block
        }
        try {
            File meanSolFile = this.checkDownload((String)prefix + TRUE_MEAN_FILE_NAME).get();
            if (meanSolFile == null || !meanSolFile.exists()) {
                JOptionPane.showMessageDialog(null, "Failed to download " + (String)prefix + "mean_ucerf3_sol.zip. Verify internet connection and restart. Server may be down.", "MeanUCERF3", 0);
            } else {
                this.setTrueMeanSol(FaultSystemSolution.load(meanSolFile));
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
            ExceptionUtils.throwAsRuntimeException(e);
        }
        if (this.isTrueMean()) {
            this.setSolution(this.meanTotalSol);
            return;
        }
        boolean bl = combineRakes = !this.rakeBasisStr.equals(RAKE_BASIS_NONE);
        if (this.upperDepthTol > 0.0 || combineRakes) {
            reducedSol = RuptureCombiner.getCombinedSolution(this.meanTotalSol, this.upperDepthTol, this.upperDepthUseMean, combineRakes, this.rakeBasis);
            try {
                reducedSol.getArchive().write(solFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            reducedSol = new FaultSystemSolution(this.meanTotalSol.getRupSet(), this.meanTotalSol.getRateForAllRups());
            reducedSol.addModule(new RupMFDsModule(reducedSol, this.meanTotalMFDs));
            reducedSol.setGridSourceProvider(this.meanTotalSol.getGridSourceProvider());
        }
        this.checkCombineMags(reducedSol);
        this.setSolution(reducedSol);
    }

    public void setMeanParams(double upperDepthTol, boolean upperDepthUseMean, double magTol, String rakeBasisStr) {
        this.upperDepthTolParam.setValue(upperDepthTol);
        this.upperDepthUseMeanParam.setValue(upperDepthUseMean);
        this.magTolParam.setValue(magTol);
        this.rakeBasisParam.setValue(rakeBasisStr);
    }

    public void setCachingEnabled(boolean enabled) {
        this.ignoreCacheParam.setValue(!enabled);
    }

    private void checkCombineMags(FaultSystemSolution sol) {
        if (this.magTol > 0.0) {
            if (this.magTol >= 10.0) {
                sol.removeModuleInstances(RupMFDsModule.class);
            } else if (sol.hasModule(RupMFDsModule.class)) {
                sol.addModule(new RupMFDsModule(sol, RuptureCombiner.combineMFDs(this.magTol, sol.getModule(RupMFDsModule.class).getRuptureMFDs())));
            }
        }
    }

    private CompletableFuture<File> checkDownload(String fName) {
        File file = new File(this.storeDir, fName);
        return MeanUCERF3.checkDownload(file);
    }

    public static CompletableFuture<File> checkDownload(File file) {
        return MeanUCERF3.checkDownload(file, true);
    }

    public static CompletableFuture<File> checkDownload(File file, boolean showProgress) {
        String fileKey = FilenameUtils.getBaseName((String)file.getName());
        return new UCERF3_Downloader(showProgress).updateFile(fileKey);
    }

    public static void main(String[] args) {
        ((CompletableFuture)MeanUCERF3.checkDownload(new File(UCERF3_Downloader.getStoreDir(), TRUE_MEAN_FILE_NAME)).thenAccept(solFile -> {
            FaultSystemSolution sol;
            try {
                sol = FaultSystemSolution.load(solFile);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            MeanUCERF3 muc3 = new MeanUCERF3(sol);
        })).join();
    }

    public static enum Presets {
        FM3_1_BRANCH_AVG("FM3.1 Branch Averaged", FaultModels.FM3_1, 100.0, true, 1.0, "Def. Model Mean"),
        FM3_1_MAG_VAR("FM3.1 BA w/ Alt Mags", FaultModels.FM3_1, 100.0, true, 0.0, "Def. Model Mean"),
        FM3_2_BRANCH_AVG("FM3.2 Branch Averaged", FaultModels.FM3_2, 100.0, true, 1.0, "Def. Model Mean"),
        FM3_2_MAG_VAR("FM3.2 BA w/ Alt Mags", FaultModels.FM3_2, 100.0, true, 0.0, "Def. Model Mean"),
        BOTH_FM_BRANCH_AVG("(POISSON ONLY) Both FM Branch Averaged", null, 100.0, true, 1.0, "Def. Model Mean"),
        BOTH_FM_MAG_VAR("(POISSON ONLY) Both FM BA w/ Alt Mags", null, 100.0, true, 0.0, "Def. Model Mean"),
        COMPLETE_MODEL("(POISSON ONLY LARGE MEM) Complete Model", null, 0.0, true, 0.0, "Do Not Combine");

        private String name;
        private FaultModels fm;
        private double upperDepthTol;
        private boolean upperDepthUseMean;
        private double magTol;
        private String rakeBasisStr;

        private Presets(String name, FaultModels fm, double upperDepthTol, boolean upperDepthUseMean, double magTol, String rakeBasisStr) {
            this.name = name;
            this.fm = fm;
            this.upperDepthTol = upperDepthTol;
            this.upperDepthUseMean = upperDepthUseMean;
            this.magTol = magTol;
            this.rakeBasisStr = rakeBasisStr;
        }

        public String toString() {
            return this.name;
        }
    }
}

