/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.mean;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_Downloader;

public class RuptureCombiner {
    private static final Comparator<FaultSection> upperDepthCompare = new Comparator<FaultSection>(){

        @Override
        public int compare(FaultSection o1, FaultSection o2) {
            return Double.compare(o1.getReducedAveUpperDepth(), o2.getReducedAveUpperDepth());
        }
    };

    /*
     * WARNING - void declaration
     */
    public static FaultSystemSolution getCombinedSolution(FaultSystemSolution meanSol, double upperDepthTol, boolean useAvgUpperDepth, boolean combineRakes, Map<Set<String>, Double> rakesBasis) {
        Object sectIDs;
        ArrayList mappedSectionsForRups;
        ArrayList combinedSects;
        boolean D = true;
        FaultSystemRupSet origRupSet = meanSol.getRupSet();
        HashMap sectIndexMapping = null;
        if (upperDepthTol <= 0.0) {
            System.out.println("Skipping upper depth combine");
            combinedSects = origRupSet.getFaultSectionDataList();
            mappedSectionsForRups = origRupSet.getSectionIndicesForAllRups();
        } else {
            void var16_36;
            void var13_19;
            Object sectsToCombine;
            Object sects;
            System.out.println("Combining upper depths with tol=" + upperDepthTol);
            HashMap origSectsMap = Maps.newHashMap();
            for (FaultSection faultSection : origRupSet.getFaultSectionDataList()) {
                String name = RuptureCombiner.getStrippedName(faultSection.getName());
                sects = (List)origSectsMap.get(name);
                if (sects == null) {
                    sects = Lists.newArrayList();
                    origSectsMap.put(name, sects);
                }
                sects.add(faultSection);
            }
            System.out.println("Found " + origSectsMap.size() + "/" + origRupSet.getNumSections() + " unique sections");
            HashMap sectMapping = Maps.newHashMap();
            for (String name : origSectsMap.keySet()) {
                sects = (List)origSectsMap.get(name);
                int n = sects.size();
                ArrayList newCombinedSects = Lists.newArrayList();
                Collections.sort(sects, upperDepthCompare);
                while (sects.size() > 1) {
                    Object myIndexes;
                    Object indexes = null;
                    block3: for (int i = 0; i < sects.size() - 1; ++i) {
                        myIndexes = Lists.newArrayList();
                        myIndexes.add(i);
                        if (indexes == null) {
                            indexes = myIndexes;
                        }
                        for (int j = i + 1; j < sects.size(); ++j) {
                            myIndexes.add(j);
                            if (RuptureCombiner.areAllUpperDepthsWithinTolOfMean((List<FaultSection>)sects, (List<Integer>)myIndexes, upperDepthTol)) {
                                if (myIndexes.size() <= indexes.size()) continue;
                                indexes = myIndexes;
                                continue;
                            }
                            myIndexes.remove(myIndexes.size() - 1);
                            continue block3;
                        }
                    }
                    sectsToCombine = Lists.newArrayList();
                    if (upperDepthTol > 30.0 && indexes.size() != sects.size()) {
                        System.out.println("Weird...depth huge but not all within!");
                    }
                    Collections.reverse(indexes);
                    myIndexes = indexes.iterator();
                    while (myIndexes.hasNext()) {
                        int i = (Integer)myIndexes.next();
                        sectsToCombine.add((FaultSection)sects.remove(i));
                    }
                    if (sectsToCombine.size() == 1) {
                        FaultSection newSect = ((FaultSection)sectsToCombine.get(0)).clone();
                        sectMapping.put((FaultSection)sectsToCombine.get(0), newSect);
                        newCombinedSects.add(newSect);
                        continue;
                    }
                    FaultSection combined = ((FaultSection)sectsToCombine.get(0)).clone();
                    double[] aseisVals = new double[sectsToCombine.size()];
                    for (int i = 0; i < sectsToCombine.size(); ++i) {
                        FaultSection sect = (FaultSection)sectsToCombine.get(i);
                        aseisVals[i] = sect.getAseismicSlipFactor();
                        sectMapping.put(sect, combined);
                    }
                    double myAseis = useAvgUpperDepth ? StatUtils.mean((double[])aseisVals) : StatUtils.max((double[])aseisVals);
                    Preconditions.checkState((!Double.isNaN(myAseis) && !Double.isInfinite(myAseis) ? 1 : 0) != 0);
                    combined.setAseismicSlipFactor(myAseis);
                    newCombinedSects.add(combined);
                }
                if (!sects.isEmpty()) {
                    FaultSection newSect = ((FaultSection)sects.get(0)).clone();
                    sectMapping.put((FaultSection)sects.get(0), newSect);
                    newCombinedSects.add(newSect);
                }
                Preconditions.checkState((newCombinedSects.size() > 0 ? 1 : 0) != 0);
                Preconditions.checkState((newCombinedSects.size() <= n ? 1 : 0) != 0);
                if (newCombinedSects.size() == 1) {
                    ((FaultSection)newCombinedSects.get(0)).setSectionName(name);
                    continue;
                }
                for (int i = 0; i < newCombinedSects.size(); ++i) {
                    ((FaultSection)newCombinedSects.get(i)).setSectionName(name + " (instance " + i + ")");
                }
            }
            Preconditions.checkState((sectMapping.size() == origRupSet.getNumSections() ? 1 : 0) != 0);
            combinedSects = Lists.newArrayList(new HashSet(sectMapping.values()));
            boolean bl = false;
            while (var13_19 < combinedSects.size()) {
                ((FaultSection)combinedSects.get((int)var13_19)).setSectionId((int)var13_19);
                ++var13_19;
            }
            sectIndexMapping = Maps.newHashMap();
            for (FaultSection key : sectMapping.keySet()) {
                sectIndexMapping.put(key.getSectionId(), ((FaultSection)sectMapping.get(key)).getSectionId());
            }
            List<? extends FaultSection> list = origRupSet.getFaultSectionDataList();
            HashMap sectIDsMap = Maps.newHashMap();
            for (FaultSection faultSection : list) {
                FaultSection mappedSect = (FaultSection)sectMapping.get(faultSection);
                Preconditions.checkNotNull((Object)mappedSect);
                sectIDsMap.put(faultSection.getSectionId(), mappedSect.getSectionId());
            }
            List<List<Integer>> sectionForRupsOrig = origRupSet.getSectionIndicesForAllRups();
            mappedSectionsForRups = Lists.newArrayList();
            boolean bl2 = false;
            while (var16_36 < sectionForRupsOrig.size()) {
                List<Integer> origIDs = sectionForRupsOrig.get((int)var16_36);
                ArrayList newIDs = Lists.newArrayList();
                sectsToCombine = origIDs.iterator();
                while (sectsToCombine.hasNext()) {
                    int s = (Integer)sectsToCombine.next();
                    newIDs.add((Integer)sectIDsMap.get(s));
                }
                mappedSectionsForRups.add(newIDs);
                ++var16_36;
            }
        }
        System.out.println("Precombine we have " + mappedSectionsForRups.size() + " rups");
        HashBasedTable combinedRupsMap = HashBasedTable.create();
        System.out.println("Finding identical rups to combine");
        for (int r = 0; r < mappedSectionsForRups.size(); ++r) {
            void var16_39;
            List<Integer> list = mappedSectionsForRups.get(r);
            sectIDs = new IntHashSet(list);
            Preconditions.checkState((((IntHashSet)sectIDs).size() == list.size() ? 1 : 0) != 0, (Object)"Duplicate sect IDs in rup!");
            Double rake = origRupSet.getAveRakeForRup(r);
            List list2 = (List)combinedRupsMap.get(sectIDs, (Object)rake);
            if (list2 == null) {
                ArrayList arrayList = Lists.newArrayList();
                combinedRupsMap.put(sectIDs, (Object)rake, (Object)arrayList);
            }
            var16_39.add(r);
        }
        System.out.println("Done finding identical rups (now have " + combinedRupsMap.size() + " rups pre rakes)");
        if (!combineRakes && upperDepthTol <= 0.0) {
            System.out.println("Doing none-changed sanity check!");
            for (List list : combinedRupsMap.values()) {
                if (list.size() <= 1) continue;
                System.out.println("Found a match, there shouldn't be one!");
                sectIDs = list.iterator();
                while (sectIDs.hasNext()) {
                    int rupID = (Integer)sectIDs.next();
                    System.out.println("\trup " + rupID + ": " + Joiner.on((String)",").join((Iterable)mappedSectionsForRups.get(rupID)) + "\trake=" + origRupSet.getAveRakeForRup(rupID) + "\tmag=" + origRupSet.getMagForRup(rupID) + "\trate=" + meanSol.getRateForRup(rupID) + "\tarea=" + origRupSet.getAreaForRup(rupID));
                }
                HashSet subSectNamesSet = new HashSet();
                Iterator rupID = list.iterator();
                while (rupID.hasNext()) {
                    int n = (Integer)rupID.next();
                    HashSet<String> subSectNames = new HashSet<String>();
                    Iterator newIDs = ((List)mappedSectionsForRups.get(n)).iterator();
                    while (newIDs.hasNext()) {
                        int s = (Integer)newIDs.next();
                        subSectNames.add(((FaultSection)combinedSects.get(s)).getName());
                    }
                    if (subSectNamesSet.isEmpty()) {
                        subSectNamesSet.add(subSectNames);
                        continue;
                    }
                    if (subSectNamesSet.contains(subSectNames)) continue;
                    System.out.println("Weird, string sets not equal!");
                    ArrayList alreadyIn = Lists.newArrayList((Object[])new String[]{(String)subSectNames.iterator().next()});
                    ArrayList newNames = Lists.newArrayList(subSectNames);
                    System.out.print("OLD: " + Joiner.on((char)',').join((Iterable)alreadyIn));
                    System.out.print("NEW: " + Joiner.on((char)',').join((Iterable)newNames));
                    System.exit(0);
                }
            }
            System.out.println("Done with sanity check");
        }
        if (combineRakes) {
            System.out.println("Combining rakes");
            HashBasedTable rakeCombinedRupsMap = HashBasedTable.create();
            Map map = combinedRupsMap.rowMap();
            for (IntHashSet sectIDs2 : map.keySet()) {
                double newRake;
                Object ratesList;
                Map map2 = (Map)map.get(sectIDs2);
                if (rakesBasis == null) {
                    ArrayList rakesList = Lists.newArrayList(map2.keySet());
                    ratesList = Lists.newArrayList();
                    for (int i = 0; i < rakesList.size(); ++i) {
                        double rate = 0.0;
                        Iterator iterator = ((List)map2.get(rakesList.get(i))).iterator();
                        while (iterator.hasNext()) {
                            int r = (Integer)iterator.next();
                            rate += meanSol.getRateForRup(r);
                        }
                        ratesList.add(rate);
                    }
                    newRake = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage((List<Double>)ratesList, rakesList));
                } else {
                    HashSet<String> subsectNames = new HashSet<String>();
                    ratesList = sectIDs2.iterator();
                    while (ratesList.hasNext()) {
                        int s = (Integer)ratesList.next();
                        subsectNames.add(RuptureCombiner.getStrippedName(((FaultSection)combinedSects.get(s)).getName()));
                    }
                    Double suppliedRake = rakesBasis.get(subsectNames);
                    Preconditions.checkNotNull((Object)suppliedRake, (Object)"Rake not found!");
                    newRake = suppliedRake;
                }
                ArrayList rupIDsList = Lists.newArrayList();
                for (List rupIDs : map2.values()) {
                    rupIDsList.addAll(rupIDs);
                }
                rakeCombinedRupsMap.put((Object)sectIDs2, (Object)newRake, (Object)rupIDsList);
            }
            combinedRupsMap = rakeCombinedRupsMap;
            System.out.println("Done combining rakes");
        }
        System.out.println("Building combined sol with " + combinedRupsMap.size() + " rups");
        ArrayList combinedMappedSectionsForRups = Lists.newArrayList();
        int n = combinedRupsMap.size();
        double[] mags = new double[n];
        double[] rakes = new double[n];
        double[] dArray = new double[n];
        double[] rates = new double[n];
        RupMFDsModule meanMFDsModule = meanSol.requireModule(RupMFDsModule.class);
        DiscretizedFunc[] mfds = new DiscretizedFunc[n];
        int runningRupIndex = 0;
        for (Table.Cell cell : combinedRupsMap.cellSet()) {
            List<Object> sects;
            void var26_79;
            double rate;
            double area;
            double mag;
            double rake = (Double)cell.getColumnKey();
            List combinedRups = (List)cell.getValue();
            if (combinedRups.size() == 1) {
                int myRupIndex = (Integer)combinedRups.get(0);
                mag = origRupSet.getMagForRup(myRupIndex);
                area = origRupSet.getAreaForRup(myRupIndex);
                rate = meanSol.getRateForRup(myRupIndex);
                DiscretizedFunc discretizedFunc = meanMFDsModule.getRuptureMFD(myRupIndex);
            } else {
                double[] myRates = new double[combinedRups.size()];
                double[] myAreas = new double[combinedRups.size()];
                DiscretizedFunc[] funcs = new DiscretizedFunc[combinedRups.size()];
                for (int i = 0; i < combinedRups.size(); ++i) {
                    int r = (Integer)combinedRups.get(i);
                    myRates[i] = meanSol.getRateForRup(r);
                    myAreas[i] = origRupSet.getAreaForRup(r);
                    DiscretizedFunc func = meanMFDsModule.getRuptureMFD(r);
                    if (func == null) {
                        double[] xVals = new double[]{origRupSet.getMagForRup(r)};
                        double[] yVals = new double[]{meanSol.getRateForRup(r)};
                        func = new LightFixedXFunc(xVals, yVals);
                    }
                    funcs[i] = func;
                }
                area = RuptureCombiner.calcScaledAverage(myRates, myAreas);
                rate = StatUtils.sum((double[])myRates);
                ArbitrarilyDiscretizedFunc totFunc = new ArbitrarilyDiscretizedFunc();
                for (DiscretizedFunc func : funcs) {
                    for (Point2D pt : func) {
                        if (pt.getY() == 0.0) continue;
                        int ind = totFunc.getIndex(pt);
                        if (ind < 0) {
                            totFunc.set(pt);
                            continue;
                        }
                        totFunc.set(ind, pt.getY() + totFunc.getY(ind));
                    }
                }
                double[] allMags = new double[totFunc.size()];
                double[] allRates = new double[totFunc.size()];
                for (int i = 0; i < totFunc.size(); ++i) {
                    allMags[i] = totFunc.getX(i);
                    allRates[i] = totFunc.getY(i);
                }
                Preconditions.checkState(((float)StatUtils.sum((double[])allRates) == (float)rate ? 1 : 0) != 0);
                mag = RuptureCombiner.calcScaledAverage(allRates, allMags);
                LightFixedXFunc lightFixedXFunc = new LightFixedXFunc(totFunc);
            }
            mags[runningRupIndex] = mag;
            rates[runningRupIndex] = rate;
            dArray[runningRupIndex] = area;
            mfds[runningRupIndex] = var26_79;
            rakes[runningRupIndex] = rake;
            ArrayList origSects = origRupSet.getSectionsIndicesForRup((Integer)combinedRups.get(0));
            if (sectIndexMapping == null) {
                sects = origSects;
            } else {
                sects = Lists.newArrayList();
                Iterator iterator = origSects.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    sects.add((Integer)sectIndexMapping.get(id));
                }
                sects = MatrixIO.getMemoryEfficientIntArray((List<Integer>)sects);
            }
            combinedMappedSectionsForRups.add(sects);
            ++runningRupIndex;
        }
        String info = "Combined Solution";
        FaultSystemRupSet rupSet = new FaultSystemRupSet(combinedSects, combinedMappedSectionsForRups, mags, rakes, dArray, null);
        FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
        sol.setGridSourceProvider(meanSol.getGridSourceProvider());
        sol.addModule(new RupMFDsModule(sol, mfds));
        double origTotRate = 0.0;
        for (double rate : meanSol.getRateForAllRups()) {
            origTotRate += rate;
        }
        double d = 0.0;
        for (double rate : sol.getRateForAllRups()) {
            d += rate;
        }
        Preconditions.checkState(((float)origTotRate == (float)d ? 1 : 0) != 0, (Object)("rates don't match! " + origTotRate + " != " + d));
        return sol;
    }

    private static boolean areAllUpperDepthsWithinTolOfMean(List<FaultSection> fsd, List<Integer> indexes, double upperDepthTol) {
        double mean = 0.0;
        for (int i : indexes) {
            mean += fsd.get(i).getReducedAveUpperDepth();
        }
        mean /= (double)indexes.size();
        for (int i : indexes) {
            if (!(Math.abs(mean - fsd.get(i).getReducedAveUpperDepth()) > upperDepthTol)) continue;
            return false;
        }
        return true;
    }

    private static boolean arePointsWithinTolOfMean(List<Point2D> points, List<Integer> indexes, double tol) {
        double mean = 0.0;
        for (int i : indexes) {
            mean += points.get(i).getX();
        }
        mean /= (double)indexes.size();
        for (int i : indexes) {
            if (!(Math.abs(mean - points.get(i).getX()) > tol)) continue;
            return false;
        }
        return true;
    }

    public static double calcScaledAverage(double[] scalars, double[] vals) {
        double totScale = 0.0;
        for (double scale : scalars) {
            totScale += scale;
        }
        double scaledAvg = 0.0;
        for (int i = 0; i < scalars.length; ++i) {
            double relative = scalars[i] / totScale;
            scaledAvg += relative * vals[i];
        }
        return scaledAvg;
    }

    public static String getStrippedName(String name) {
        if (name.contains("(instance ")) {
            name = name.substring(0, name.indexOf("(instance "));
        }
        return name.trim();
    }

    public static Map<Set<String>, Double> loadRakeBasis(DeformationModels dm) {
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        HashMap rakeBasis = Maps.newHashMap();
        for (FaultModels fm : fms) {
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(fm, dm);
            for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
                HashSet<String> sectNames = new HashSet<String>();
                for (FaultSection sect : rupSet.getFaultSectionDataForRupture(rupIndex)) {
                    sectNames.add(sect.getName());
                }
                if (rakeBasis.containsKey(sectNames)) continue;
                rakeBasis.put(sectNames, rupSet.getAveRakeForRup(rupIndex));
            }
        }
        return rakeBasis;
    }

    public static DiscretizedFunc[] combineMFDs(double magTol, DiscretizedFunc[] origMFDs) {
        if (magTol <= 0.0) {
            return origMFDs;
        }
        DiscretizedFunc[] combinedMFDs = new DiscretizedFunc[origMFDs.length];
        for (int r = 0; r < origMFDs.length; ++r) {
            DiscretizedFunc origMFD = origMFDs[r];
            if (origMFD.size() <= 1) {
                combinedMFDs[r] = origMFD;
                continue;
            }
            ArrayList pts = Lists.newArrayList((Iterable)origMFD);
            ArbitrarilyDiscretizedFunc newMFD = new ArbitrarilyDiscretizedFunc();
            while (pts.size() > 1) {
                Point2D combinedPt;
                Object myIndexes;
                Object indexes = null;
                block2: for (int i = 0; i < pts.size() - 1; ++i) {
                    myIndexes = Lists.newArrayList();
                    myIndexes.add(i);
                    if (indexes == null) {
                        indexes = myIndexes;
                    }
                    for (int j = i + 1; j < pts.size(); ++j) {
                        myIndexes.add(j);
                        if (RuptureCombiner.arePointsWithinTolOfMean(pts, (List<Integer>)myIndexes, magTol)) {
                            if (myIndexes.size() <= indexes.size()) continue;
                            indexes = myIndexes;
                            continue;
                        }
                        myIndexes.remove(myIndexes.size() - 1);
                        continue block2;
                    }
                }
                ArrayList ptsToCombine = Lists.newArrayList();
                if (magTol > 5.0 && indexes.size() != pts.size()) {
                    System.out.println("Weird...depth huge but not all within!");
                }
                Collections.reverse(indexes);
                myIndexes = indexes.iterator();
                while (myIndexes.hasNext()) {
                    int i = (Integer)myIndexes.next();
                    ptsToCombine.add((Point2D)pts.remove(i));
                }
                if (ptsToCombine.size() == 1) {
                    combinedPt = (Point2D)ptsToCombine.get(0);
                } else {
                    double[] mags = new double[ptsToCombine.size()];
                    double[] rates = new double[ptsToCombine.size()];
                    for (int i = 0; i < ptsToCombine.size(); ++i) {
                        Point2D pt = (Point2D)ptsToCombine.get(i);
                        mags[i] = pt.getX();
                        rates[i] = pt.getY();
                    }
                    double meanMag = RuptureCombiner.calcScaledAverage(rates, mags);
                    combinedPt = new Point2D.Double(meanMag, StatUtils.sum((double[])rates));
                }
                Preconditions.checkState((!newMFD.hasX(combinedPt.getX()) ? 1 : 0) != 0, (Object)"Duplicate!");
                newMFD.set(combinedPt);
            }
            combinedMFDs[r] = new LightFixedXFunc(newMFD);
        }
        return combinedMFDs;
    }

    static void checkIdentical(FaultSystemSolution sol1, FaultSystemSolution sol2, boolean checkERF) {
        int s;
        System.out.println("Doing Identical Check");
        FaultSystemRupSet rupSet1 = sol1.getRupSet();
        FaultSystemRupSet rupSet2 = sol2.getRupSet();
        Preconditions.checkState((rupSet1.getNumRuptures() == rupSet2.getNumRuptures() ? 1 : 0) != 0, (Object)"Rup count wrong");
        Preconditions.checkState((rupSet1.getNumSections() == rupSet2.getNumSections() ? 1 : 0) != 0, (Object)"Sect count wrong");
        HashBasedTable rupSet2RupsToIndexesMap = HashBasedTable.create();
        for (int r = 0; r < rupSet2.getNumRuptures(); ++r) {
            System.out.println(Joiner.on((String)",").join(rupSet2.getSectionsIndicesForRup(r)));
            IntHashSet rupSects = new IntHashSet(rupSet2.getSectionsIndicesForRup(r));
            Double rake = rupSet2.getAveRakeForRup(r);
            if (rupSet2RupsToIndexesMap.contains((Object)rupSects, (Object)rake)) {
                int prevIndex = (Integer)rupSet2RupsToIndexesMap.get((Object)rupSects, (Object)rake);
                Joiner j = Joiner.on((String)",");
                Object message = "Duplicate rup found in rups2!";
                message = (String)message + "\n\t" + prevIndex + " mag=" + rupSet2.getMagForRup(prevIndex) + " area=" + rupSet2.getAreaForRup(prevIndex) + " rake=" + rupSet2.getAveRakeForRup(prevIndex) + "\n\tsects: " + j.join(rupSet2.getSectionsIndicesForRup(prevIndex));
                message = (String)message + "\n\t" + r + " mag=" + rupSet2.getMagForRup(r) + " area=" + rupSet2.getAreaForRup(r) + " rake=" + rupSet2.getAveRakeForRup(r) + "\n\tsects: " + j.join(rupSet2.getSectionsIndicesForRup(r));
                throw new IllegalStateException((String)message);
            }
            rupSet2RupsToIndexesMap.put((Object)rupSects, (Object)rake, (Object)r);
        }
        HashMap rupIDMapping = Maps.newHashMap();
        boolean idsIdentical = true;
        RupMFDsModule mfds1 = sol1.requireModule(RupMFDsModule.class);
        RupMFDsModule mfds2 = sol2.requireModule(RupMFDsModule.class);
        for (int r = 0; r < rupSet1.getNumRuptures(); ++r) {
            boolean sectsEqual;
            IntHashSet rupSects = new IntHashSet(rupSet1.getSectionsIndicesForRup(r));
            Double rake = rupSet1.getAveRakeForRup(r);
            Integer index = (Integer)rupSet2RupsToIndexesMap.get((Object)rupSects, (Object)rake);
            Preconditions.checkNotNull((Object)index, (Object)("No mapping for rup " + r + " found in sol2"));
            idsIdentical = idsIdentical && r == index;
            rupIDMapping.put(r, index);
            ArrayList mySects = rupSet1.getSectionsIndicesForRup(r);
            List<Integer> otherSects = rupSet2.getSectionsIndicesForRup(index);
            Preconditions.checkState((mySects.size() == otherSects.size() ? 1 : 0) != 0, (Object)("Sect count wrong for rup " + r + "/" + index));
            if (mySects.get(0).intValue() != otherSects.get(0).intValue()) {
                mySects = Lists.newArrayList(mySects);
                Collections.reverse(mySects);
            }
            if (!(sectsEqual = mySects.equals(otherSects))) {
                Joiner j = Joiner.on((String)",");
                throw new IllegalStateException("Sect ordering wrong for rup " + r + "/" + index + "\n\trup 1: " + j.join((Iterable)mySects) + "\n\trup 2: " + j.join(otherSects));
            }
            RuptureCombiner.checkFloatTolerance(sol1.getRateForRup(r), sol2.getRateForRup(index), "Rates wrong for rup " + r + "/" + index);
            RuptureCombiner.checkFloatTolerance(rupSet1.getMagForRup(r), rupSet2.getMagForRup(index), "Mags wrong for rup " + r + "/" + index);
            RuptureCombiner.checkFloatTolerance(rupSet1.getAreaForRup(r), rupSet2.getAreaForRup(index), "Areas wrong for rup " + r + "/" + index);
            DiscretizedFunc mfd1 = mfds1.getRuptureMFD(r);
            DiscretizedFunc mfd2 = mfds2.getRuptureMFD(index);
            Preconditions.checkState((mfd1.size() == mfd2.size() ? 1 : 0) != 0, (Object)"MFD sizes inconsistant");
            for (int i = 0; i < mfd1.size(); ++i) {
                RuptureCombiner.checkFloatTolerance(mfd1.getX(i), mfd2.getX(i), "Mags wrong for rup " + r + "/" + index + " mfd " + i);
                RuptureCombiner.checkFloatTolerance(mfd1.getY(i), mfd2.getY(i), "Rates wrong for rup " + r + "/" + index + " mfd " + i);
            }
            RuptureCombiner.checkFloatTolerance(rupSet1.getAveRakeForRup(r), rupSet2.getAveRakeForRup(index), "Rakes wrong for rup " + r + "/" + index);
        }
        rupSet2RupsToIndexesMap = null;
        System.gc();
        HashMap rupSet2SectsToIndexesMap = Maps.newHashMap();
        for (s = 0; s < rupSet2.getNumSections(); ++s) {
            String name = rupSet2.getFaultSectionData(s).getName();
            Preconditions.checkState((!rupSet2SectsToIndexesMap.containsKey(name) ? 1 : 0) != 0, (Object)"Duplicate sect found in rups2!");
            rupSet2SectsToIndexesMap.put(name, s);
        }
        for (s = 0; s < rupSet1.getNumSections(); ++s) {
            FaultSection sect1 = rupSet1.getFaultSectionData(s);
            String name = sect1.getName();
            Integer index = (Integer)rupSet2SectsToIndexesMap.get(name);
            Preconditions.checkNotNull((Object)index, (Object)("No mapping for sect " + s + " (" + name + ") found in sol2"));
            FaultSection sect2 = rupSet2.getFaultSectionData(index);
            RuptureCombiner.checkFloatTolerance(sect1.getOrigAveUpperDepth(), sect2.getOrigAveUpperDepth(), "Orig upper depth wrong for sect " + s + "/" + index);
            RuptureCombiner.checkFloatTolerance(sect1.getReducedAveUpperDepth(), sect2.getReducedAveUpperDepth(), "Reduced upper depth wrong for sect " + s + "/" + index);
            RuptureCombiner.checkFloatTolerance(sect1.getAveLowerDepth(), sect2.getAveLowerDepth(), "Lower depth wrong for sect " + s + "/" + index);
            if (Double.isNaN(sect1.getAveRake())) {
                Preconditions.checkState((boolean)Double.isNaN(sect2.getAveRake()));
            } else {
                RuptureCombiner.checkFloatTolerance(sect1.getAveRake(), sect2.getAveRake(), "Rake wrong for sect " + s + "/" + index);
            }
            RuptureCombiner.checkFloatTolerance(sect1.getAveDip(), sect2.getAveDip(), "Dip wrong for sect " + s + "/" + index);
            RuptureCombiner.checkFloatTolerance(sect1.getDipDirection(), sect2.getDipDirection(), "Dip direction wrong for sect " + s + "/" + index);
        }
        rupSet2SectsToIndexesMap = null;
        System.gc();
        if (checkERF) {
            System.out.println("Doing ERF check");
            int erfBinSize = 100000;
            for (int i = 0; i < rupSet1.getNumRuptures(); i += erfBinSize) {
                System.gc();
                System.out.println("ERF subset " + i);
                ArrayList rups1 = Lists.newArrayList();
                ArrayList rups2 = Lists.newArrayList();
                for (int r = i; r < rupSet1.getNumRuptures() && r < i + erfBinSize; ++r) {
                    rups1.add(r);
                    rups2.add((Integer)rupIDMapping.get(r));
                }
                FaultSystemSolutionERF erf1 = new FaultSystemSolutionERF(new SubsetSolution(sol1, rups1));
                FaultSystemSolutionERF erf2 = new FaultSystemSolutionERF(new SubsetSolution(sol2, rups2));
                erf1.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf2.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf1.updateForecast();
                erf2.updateForecast();
                Preconditions.checkState((erf1.getNumSources() == erf2.getNumSources() ? 1 : 0) != 0, (Object)"Source count wrong!");
                for (int s2 = 0; s2 < erf1.getNumSources(); ++s2) {
                    ProbEqkSource source1 = erf1.getSource(s2);
                    ProbEqkSource source2 = erf2.getSource(s2);
                    Preconditions.checkState((source1.getNumRuptures() == source2.getNumRuptures() ? 1 : 0) != 0, (Object)("Rup count wrong for source " + (s2 + i)));
                    RuptureCombiner.checkFloatTolerance(source1.computeTotalProb(), source2.computeTotalProb(), "Probs wrong for source " + (s2 + i));
                    for (int r = 0; r < source1.getNumRuptures(); ++r) {
                        ProbEqkRupture rup1 = source1.getRupture(r);
                        ProbEqkRupture rup2 = source2.getRupture(r);
                        RuptureCombiner.checkFloatTolerance(rup1.getProbability(), rup2.getProbability(), "Probs wrong for source " + (s2 + i) + " rup " + r);
                        RuptureCombiner.checkFloatTolerance(rup1.getMag(), rup2.getMag(), "Mags wrong for source " + (s2 + i) + " rup " + r);
                        RuptureCombiner.checkFloatTolerance(rup1.getAveRake(), rup2.getAveRake(), "Rakes wrong for source " + (s2 + i) + " rup " + r);
                        RuptureCombiner.checkFloatTolerance(rup1.getRuptureSurface().getArea(), rup2.getRuptureSurface().getArea(), "Areas wrong for source " + (s2 + i) + " rup " + r);
                    }
                }
            }
        }
    }

    private static void checkFloatTolerance(double val1, double val2, String message) {
        Preconditions.checkState(((float)val1 == (float)val2 ? 1 : 0) != 0, (Object)(message + " (" + (float)val1 + " != " + (float)val2 + ")"));
    }

    private static <E> List<List<E>> getSubList(List<List<E>> fullList, List<Integer> indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int index : indexes) {
            ret.add(fullList.get(index));
        }
        return ret;
    }

    private static double[] getSubArray(double[] fullArray, List<Integer> indexes) {
        if (fullArray == null) {
            return null;
        }
        double[] ret = new double[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            ret[i] = fullArray[indexes.get(i)];
        }
        return ret;
    }

    private static <E> E[] getSubArray(E[] fullArray, List<Integer> indexes) {
        if (fullArray == null) {
            return null;
        }
        E[] ret = Arrays.copyOf(fullArray, indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            ret[i] = fullArray[indexes.get(i)];
        }
        return ret;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File cacheDir = UCERF3_Downloader.getStoreDir();
        U3FaultSystemSolution trueMean = U3FaultSystemIO.loadSol(new File(cacheDir, "mean_ucerf3_sol.zip"));
        FaultSystemSolution reduced = RuptureCombiner.getCombinedSolution(trueMean, 1.0E-10, true, false, null);
        RuptureCombiner.checkIdentical(trueMean, reduced, true);
    }

    public static class IntHashSet
    extends AbstractSet<Integer> {
        private int[] vals;

        public IntHashSet(Collection<Integer> vals) {
            this(Ints.toArray(vals), false);
        }

        public IntHashSet(int[] vals, boolean alreadySorted) {
            if (!alreadySorted) {
                Arrays.sort(vals);
            }
            ArrayList dupIndexes = Lists.newArrayList();
            for (int i = 1; i < vals.length; ++i) {
                if (vals[i] != vals[i - 1]) continue;
                dupIndexes.add(i);
            }
            if (!dupIndexes.isEmpty()) {
                int[] newvals = new int[vals.length - dupIndexes.size()];
                int newIndex = 0;
                int curDup = (Integer)dupIndexes.get(0);
                for (int oldIndex = 0; oldIndex < vals.length; ++oldIndex) {
                    if (oldIndex == curDup) {
                        dupIndexes.remove(0);
                        if (dupIndexes.isEmpty()) {
                            curDup = -1;
                            continue;
                        }
                        curDup = (Integer)dupIndexes.get(0);
                        continue;
                    }
                    newvals[newIndex++] = vals[oldIndex];
                }
                Preconditions.checkState((newIndex == newvals.length ? 1 : 0) != 0);
                Preconditions.checkState((boolean)dupIndexes.isEmpty());
                vals = newvals;
            }
            this.vals = vals;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < vals.length;
                }

                @Override
                public Integer next() {
                    return vals[this.index++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported by this iterator");
                }
            };
        }

        @Override
        public int size() {
            return this.vals.length;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.vals);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() == obj.getClass()) {
                IntHashSet other = (IntHashSet)obj;
                if (!Arrays.equals(this.vals, other.vals)) {
                    return false;
                }
            } else if (!super.equals(obj)) {
                return false;
            }
            return true;
        }
    }

    public static class SubsetSolution
    extends FaultSystemSolution {
        public SubsetSolution(FaultSystemSolution sol, List<Integer> rups) {
            super(new SubsetRupSet(sol.getRupSet(), rups), RuptureCombiner.getSubArray(sol.getRateForAllRups(), rups));
            this.addModule(new RupMFDsModule(this, RuptureCombiner.getSubArray(sol.getModule(RupMFDsModule.class).getRuptureMFDs(), rups)));
        }
    }

    public static class SubsetRupSet
    extends FaultSystemRupSet {
        public SubsetRupSet(FaultSystemRupSet rupSet, List<Integer> rups) {
            super(rupSet.getFaultSectionDataList(), RuptureCombiner.getSubList(rupSet.getSectionIndicesForAllRups(), rups), RuptureCombiner.getSubArray(rupSet.getMagForAllRups(), rups), RuptureCombiner.getSubArray(rupSet.getAveRakeForAllRups(), rups), RuptureCombiner.getSubArray(rupSet.getAreaForAllRups(), rups), RuptureCombiner.getSubArray(rupSet.getLengthForAllRups(), rups));
            Preconditions.checkState((this.getNumRuptures() == rups.size() ? 1 : 0) != 0);
        }
    }
}

