/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class GridReader {
    protected static final CaliforniaRegions.RELM_TESTING_GRIDDED region = new CaliforniaRegions.RELM_TESTING_GRIDDED();
    protected static final String DATA_DIR = "seismicityGrids";
    protected static final Splitter SPLIT = Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings();
    protected static final Function<String, Double> FN_STR_TO_DBL = new FnStrToDbl();
    protected static final Function<Double, Integer> FN_DBL_TO_KEY = new FnDblToKey();
    protected static final Function<String, Integer> FN_STR_TO_KEY = Functions.compose(FN_DBL_TO_KEY, FN_STR_TO_DBL);
    protected Table<Integer, Integer, Double> table;
    protected String filename;

    public GridReader(String filename) {
        this.filename = filename;
        this.table = this.initTable();
    }

    public Double getValue(Location loc) {
        return (Double)this.table.get(FN_DBL_TO_KEY.apply((Object)loc.getLatitude()), FN_DBL_TO_KEY.apply((Object)loc.getLongitude()));
    }

    public double[] getValues() {
        double[] values = new double[region.getNodeCount()];
        int i = 0;
        for (Location loc : region) {
            Double value = this.getValue(loc);
            values[i++] = value == null ? Double.NaN : value;
        }
        return values;
    }

    protected Table<Integer, Integer, Double> initTable() {
        HashBasedTable table = HashBasedTable.create();
        try {
            BufferedReader br = new BufferedReader(UCERF3_DataUtils.getReader(DATA_DIR, this.filename));
            String line = br.readLine();
            while (line != null) {
                Iterator dat = SPLIT.split((CharSequence)line).iterator();
                table.put((Object)((Integer)FN_STR_TO_KEY.apply((Object)((String)dat.next()))), (Object)((Integer)FN_STR_TO_KEY.apply((Object)((String)dat.next()))), (Object)((Double)FN_STR_TO_DBL.apply((Object)((String)dat.next()))));
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        return table;
    }

    public static void main(String[] args) {
        double[] pdf = SpatialSeisPDF.UCERF3.getPDF();
        System.out.println("U3 " + DataUtils.sum(pdf));
        pdf = SpatialSeisPDF.UCERF2.getPDF();
        System.out.println("U2 " + DataUtils.sum(pdf));
        pdf = SpatialSeisPDF.UNSMOOTHED_GRIDDED.getPDF();
        System.out.println("UNSMOOTHED_GRIDDED " + DataUtils.sum(pdf));
        pdf = SpatialSeisPDF.AVG_DEF_MODEL_ALL.getPDF();
        System.out.println("AVG_DEF_MODEL_ALL " + DataUtils.sum(pdf));
        pdf = SpatialSeisPDF.AVG_DEF_MODEL_OFF.getPDF();
        System.out.println("AVG_DEF_MODEL_OFF " + DataUtils.sum(pdf));
        double fir = SpatialSeisPDF.UCERF3.getFractionInRegion(region);
        System.out.println("U3 FractionInRegion" + fir);
    }

    private static class FnStrToDbl
    implements Function<String, Double> {
        private FnStrToDbl() {
        }

        public Double apply(String s) {
            return Double.valueOf(s);
        }
    }

    private static class FnDblToKey
    implements Function<Double, Integer> {
        private FnDblToKey() {
        }

        public Integer apply(Double d) {
            return (int)Math.round(d * 10.0);
        }
    }

    private static class FnStrToInt
    implements Function<String, Integer> {
        private FnStrToInt() {
        }

        public Integer apply(String s) {
            return Integer.valueOf(s);
        }
    }
}

