/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import java.util.List;
import java.util.Map;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;

public class GriddedSeisUtils {
    private PolygonFaultGridAssociations polyMgr;
    private double[] pdf;

    public GriddedSeisUtils(List<? extends FaultSection> fltSectList, double[] pdf, PolygonFaultGridAssociations polyMgr) {
        this.polyMgr = polyMgr;
        this.pdf = (double[])pdf.clone();
    }

    public GriddedSeisUtils(List<? extends FaultSection> fltSectList, SpatialSeisPDF pdf, PolygonFaultGridAssociations polyMgr) {
        this.polyMgr = polyMgr;
        this.pdf = pdf.getPDF();
    }

    public PolygonFaultGridAssociations getPolyMgr() {
        return this.polyMgr;
    }

    public double pdfInPolys() {
        double fraction = 0.0;
        Map<Integer, Double> nodeMap = this.polyMgr.getNodeExtents();
        for (int idx = 0; idx < this.pdf.length; ++idx) {
            if (!nodeMap.containsKey(idx)) continue;
            fraction += nodeMap.get(idx) * this.pdf[idx];
        }
        return fraction;
    }

    public double pdfValForSection(int idx) {
        Map<Integer, Double> nodeMap = this.polyMgr.getScaledNodeFractions(idx);
        double sum = 0.0;
        for (int iNode = 0; iNode < this.pdf.length; ++iNode) {
            if (!nodeMap.containsKey(iNode)) continue;
            sum += this.pdf[iNode] * nodeMap.get(iNode);
        }
        return sum;
    }

    public static void main(String[] args) {
    }
}

