/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import java.util.Map;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.griddedSeismicity.GridReader;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class UCERF3_NoFaultsGridSourceGenerator
extends AbstractGridSourceProvider {
    private final CaliforniaRegions.RELM_TESTING_GRIDDED region = RELM_RegionUtils.getGriddedRegionInstance();
    private double[] fracStrikeSlip;
    private double[] fracNormal;
    private double[] fracReverse;
    private double[] srcSpatialPDF;
    private double totalMgt5_Rate;
    private double maxMag;
    private IncrementalMagFreqDist realOffFaultMFD;
    private Map<Integer, SummedMagFreqDist> nodeSubSeisMFDs;

    public UCERF3_NoFaultsGridSourceGenerator(double[] srcSpatialPDF, double totalMgt5_Rate, double maxMag) {
        this.initFocalMechGrids();
        this.srcSpatialPDF = srcSpatialPDF;
        this.totalMgt5_Rate = totalMgt5_Rate;
        this.maxMag = maxMag;
        double mfdMin = 2.55;
        double mfdMax = (double)Math.round(maxMag * 10.0) / 10.0 - 0.05;
        int mfdNum = (int)Math.round((maxMag - mfdMin) / 0.1);
        GutenbergRichterMagFreqDist mfd = new GutenbergRichterMagFreqDist(1.0, 1.0, mfdMin, mfdMax, mfdNum);
        mfd.scaleToCumRate(5.05, totalMgt5_Rate);
        this.realOffFaultMFD = mfd;
    }

    public IncrementalMagFreqDist getNodeUnassociatedMFD() {
        this.realOffFaultMFD.setInfo("Same as " + this.realOffFaultMFD.getName());
        this.realOffFaultMFD.setName("Unassociated MFD for all nodes");
        return this.realOffFaultMFD;
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int idx) {
        return null;
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(int idx) {
        IncrementalMagFreqDist mfd = this.realOffFaultMFD.deepClone();
        if (this.srcSpatialPDF != null) {
            mfd.scale(this.srcSpatialPDF[idx]);
        } else {
            mfd.scale(1.0 / (double)this.region.getNodeCount());
        }
        return mfd;
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.region;
    }

    public IncrementalMagFreqDist getNodeSubSeisMFD() {
        return null;
    }

    public static void main(String[] args) {
    }

    @Override
    public double getFracStrikeSlip(int idx) {
        return this.fracStrikeSlip[idx];
    }

    @Override
    public double getFracReverse(int idx) {
        return this.fracReverse[idx];
    }

    @Override
    public double getFracNormal(int idx) {
        return this.fracNormal[idx];
    }

    private void initFocalMechGrids() {
        GridReader gRead = new GridReader("StrikeSlipWts.txt");
        this.fracStrikeSlip = gRead.getValues();
        gRead = new GridReader("ReverseWts.txt");
        this.fracReverse = gRead.getValues();
        gRead = new GridReader("NormalWts.txt");
        this.fracNormal = gRead.getValues();
    }

    @Override
    public MFDGridSourceProvider newInstance(Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
        return new AbstractGridSourceProvider.Precomputed(this.getGriddedRegion(), nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
    }
}

