/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.dom4j.DocumentException;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3SlipEnabledSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.griddedSeismicity.UCERF3_GridSourceGenerator;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.U3InversionTargetMFDs;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;

public class InversionFaultSystemSolution
extends U3SlipEnabledSolution {
    private InversionFaultSystemRupSet rupSet;
    private InversionModels invModel;
    private U3LogicTreeBranch branch;
    private UCERF3InversionConfiguration inversionConfiguration;
    private Map<String, Double> energies;
    private Map<String, Double> misfits;

    public InversionFaultSystemSolution(InversionFaultSystemRupSet rupSet, double[] rates) {
        this(rupSet, rates, null, null);
    }

    public InversionFaultSystemSolution(InversionFaultSystemRupSet rupSet, double[] rates, UCERF3InversionConfiguration config, Map<String, Double> energies) {
        this.init(rupSet, rates, config, energies);
    }

    protected InversionFaultSystemSolution() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public InversionFaultSystemSolution(InversionFaultSystemRupSet rupSet, String infoString, double[] rates) {
        super(rupSet, rates);
        this.rupSet = rupSet;
        ArrayList infoLines = Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)infoString));
        try {
            Map<String, String> invProps = this.loadProperties(this.getMetedataSection(infoLines, "Inversion Configuration Metadata"));
            this.loadInvParams(invProps);
        }
        catch (Exception e1) {
            System.err.println("Couldn't load in Legacy Inversion Properties: " + String.valueOf(e1));
        }
        try {
            Map<String, String> branchProps = this.loadProperties(this.getMetedataSection(infoLines, "Logic Tree Branch"));
            this.branch = this.loadBranch(branchProps);
        }
        catch (Exception e1) {
            System.err.println("Couldn't load in Legacy Inversion Logic Tree: " + String.valueOf(e1));
        }
        finally {
            if (this.branch == null) {
                this.branch = rupSet.getLogicTreeBranch();
            } else {
                U3LogicTreeBranch rBranch = rupSet.getLogicTreeBranch();
                for (int i = 0; i < this.branch.size(); ++i) {
                    if (this.branch.getValue(i) != null || rBranch.getValue(i) == null) continue;
                    this.branch.setValue((U3LogicTreeBranchNode)rBranch.getValue(i));
                }
            }
        }
        this.invModel = this.branch.getValue(InversionModels.class);
        try {
            ArrayList saMetadata = this.getMetedataSection(infoLines, "Simulated Annealing Metadata");
            if (saMetadata == null) {
                saMetadata = Lists.newArrayList();
            }
            Map<String, String> saProps = this.loadProperties(saMetadata);
            this.loadEnergies(saProps);
        }
        catch (Exception e1) {
            System.err.println("Couldn't load in Legacy SA Properties: " + String.valueOf(e1));
        }
    }

    protected void init(InversionFaultSystemRupSet rupSet, double[] rates, UCERF3InversionConfiguration config, Map<String, Double> energies) {
        super.init(rupSet, rates, rupSet.getInfoString(), null);
        this.rupSet = rupSet;
        this.branch = rupSet.getLogicTreeBranch();
        this.invModel = this.branch.getValue(InversionModels.class);
        this.inversionConfiguration = config;
        this.energies = energies;
        this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SubSeismoOnFaultMFDs>(){

            @Override
            public SubSeismoOnFaultMFDs call() throws Exception {
                return new SubSeismoOnFaultMFDs(InversionFaultSystemSolution.this.getFinalSubSeismoOnFaultMFD_List());
            }
        }, SubSeismoOnFaultMFDs.class);
        this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<GridSourceProvider>(){

            @Override
            public GridSourceProvider call() throws Exception {
                return new UCERF3_GridSourceGenerator(InversionFaultSystemSolution.this);
            }
        }, GridSourceProvider.class);
    }

    @Override
    public InversionFaultSystemRupSet getRupSet() {
        return this.rupSet;
    }

    private Map<String, String> loadProperties(ArrayList<String> section) {
        HashMap props = Maps.newHashMap();
        for (String line : section) {
            String value;
            int ind = (line = line.trim()).indexOf(58);
            if (ind < 0) continue;
            Object key = line.substring(0, ind);
            if (((String)key).startsWith("relative")) {
                if (((String)(key = ((String)key).substring(8))).startsWith("MFD")) {
                    key = "mfd" + ((String)key).substring(3);
                } else if (Character.isUpperCase(((String)key).charAt(0))) {
                    key = new String("" + ((String)key).charAt(0)).toLowerCase() + ((String)key).substring(1);
                }
            }
            if ((value = line.substring(ind + 1).trim()).contains("weightSlipRates:")) {
                int badInd = value.indexOf("weightSlipRates:");
                String weightSlipsStr = value.substring(badInd);
                String weightVal = weightSlipsStr.substring(weightSlipsStr.indexOf(":") + 1).trim();
                props.put("weightSlipRates", weightVal);
                value = value.substring(0, badInd);
            }
            props.put(key, value);
        }
        return props;
    }

    private ArrayList<String> getMetedataSection(ArrayList<String> lines, String title) {
        ArrayList<String> section = null;
        for (String line : lines) {
            if (section == null) {
                if (!line.contains("*") || !line.contains(title)) continue;
                section = new ArrayList<String>();
                continue;
            }
            if (line.contains("*")) break;
            section.add(line);
        }
        return section;
    }

    private U3LogicTreeBranch loadBranch(Map<String, String> props) {
        List<Class<U3LogicTreeBranchNode<?>>> classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
        ArrayList values = Lists.newArrayList();
        for (String key : props.keySet()) {
            Class<U3LogicTreeBranchNode<?>> clazz = null;
            for (Class<U3LogicTreeBranchNode<?>> testClass : classes) {
                String className = ClassUtils.getClassNameWithoutPackage(testClass);
                if (!className.startsWith(key)) continue;
                clazz = testClass;
                break;
            }
            Preconditions.checkNotNull(clazz, (Object)("Couldn't find class for logic tree branch: " + key));
            String valueName = props.get(key);
            if (valueName.equals("RATE_10p6")) {
                valueName = "RATE_10p0";
            }
            U3LogicTreeBranchNode<?> value = null;
            for (U3LogicTreeBranchNode<?> testValue : clazz.getEnumConstants()) {
                if (!testValue.name().equals(valueName)) continue;
                value = testValue;
                break;
            }
            Preconditions.checkNotNull(value, (Object)("Couldn't find matching constant for logic tree value " + key + " (node=" + ClassUtils.getClassNameWithoutPackage(clazz) + ") (val=" + props.get(key) + ")"));
            values.add(value);
        }
        return U3LogicTreeBranch.fromValues(values);
    }

    private void loadInvParams(Map<String, String> props) {
        double MFDTransitionMag = Double.NaN;
        double slipRateConstraintWt_normalized = Double.NaN;
        double slipRateConstraintWt_unnormalized = Double.NaN;
        double paleoRateConstraintWt = Double.NaN;
        double paleoSlipConstraintWt = Double.NaN;
        double magnitudeEqualityConstraintWt = Double.NaN;
        double magnitudeInequalityConstraintWt = Double.NaN;
        double rupRateConstraintWt = Double.NaN;
        double rupRateSmoothingConstraintWt = Double.NaN;
        double participationSmoothnessConstraintWt = Double.NaN;
        double participationConstraintMagBinSize = Double.NaN;
        double nucleationMFDConstraintWt = Double.NaN;
        double mfdSmoothnessConstraintWt = Double.NaN;
        double mfdSmoothnessConstraintWtForPaleoParents = Double.NaN;
        double minimizationConstraintWt = Double.NaN;
        double momentConstraintWt = Double.NaN;
        double parkfieldConstraintWt = Double.NaN;
        double smoothnessWt = Double.NaN;
        double eventRateSmoothnessWt = Double.NaN;
        double minimumRuptureRateFraction = Double.NaN;
        if (props.containsKey("MFDTransitionMag")) {
            MFDTransitionMag = Double.parseDouble(props.get("MFDTransitionMag"));
        }
        if (props.containsKey("slipRateConstraintWt_normalized")) {
            slipRateConstraintWt_normalized = Double.parseDouble(props.get("slipRateConstraintWt_normalized"));
        }
        if (props.containsKey("slipRateConstraintWt_unnormalized")) {
            slipRateConstraintWt_unnormalized = Double.parseDouble(props.get("slipRateConstraintWt_unnormalized"));
        }
        if (props.containsKey("paleoRateConstraintWt")) {
            paleoRateConstraintWt = Double.parseDouble(props.get("paleoRateConstraintWt"));
        } else if (props.containsKey("paleoRateWt")) {
            paleoRateConstraintWt = Double.parseDouble(props.get("paleoRateWt"));
        }
        if (props.containsKey("paleoSlipConstraintWt")) {
            paleoSlipConstraintWt = Double.parseDouble(props.get("paleoSlipConstraintWt"));
        } else if (props.containsKey("paleoSlipWt")) {
            paleoSlipConstraintWt = Double.parseDouble(props.get("paleoSlipWt"));
        }
        if (props.containsKey("magnitudeEqualityConstraintWt")) {
            magnitudeEqualityConstraintWt = Double.parseDouble(props.get("magnitudeEqualityConstraintWt"));
        }
        if (props.containsKey("magnitudeInequalityConstraintWt")) {
            magnitudeInequalityConstraintWt = Double.parseDouble(props.get("magnitudeInequalityConstraintWt"));
        }
        if (props.containsKey("rupRateConstraintWt")) {
            rupRateConstraintWt = Double.parseDouble(props.get("rupRateConstraintWt"));
        }
        if (props.containsKey("rupRateSmoothingConstraintWt")) {
            rupRateSmoothingConstraintWt = Double.parseDouble(props.get("rupRateSmoothingConstraintWt"));
        }
        if (props.containsKey("participationSmoothnessConstraintWt")) {
            participationSmoothnessConstraintWt = Double.parseDouble(props.get("participationSmoothnessConstraintWt"));
        }
        if (props.containsKey("participationConstraintMagBinSize")) {
            participationConstraintMagBinSize = Double.parseDouble(props.get("participationConstraintMagBinSize"));
        }
        if (props.containsKey("nucleationMFDConstraintWt")) {
            nucleationMFDConstraintWt = Double.parseDouble(props.get("nucleationMFDConstraintWt"));
        }
        if (props.containsKey("mfdSmoothnessConstraintWt")) {
            mfdSmoothnessConstraintWt = Double.parseDouble(props.get("mfdSmoothnessConstraintWt"));
        }
        if (props.containsKey("mfdSmoothnessConstraintWtForPaleoParents")) {
            mfdSmoothnessConstraintWtForPaleoParents = Double.parseDouble(props.get("mfdSmoothnessConstraintWtForPaleoParents"));
        }
        if (props.containsKey("minimizationConstraintWt")) {
            minimizationConstraintWt = Double.parseDouble(props.get("minimizationConstraintWt"));
        }
        if (props.containsKey("momentConstraintWt")) {
            momentConstraintWt = Double.parseDouble(props.get("momentConstraintWt"));
        }
        if (props.containsKey("parkfieldConstraintWt")) {
            parkfieldConstraintWt = Double.parseDouble(props.get("parkfieldConstraintWt"));
        }
        if (props.containsKey("smoothnessWt")) {
            smoothnessWt = Double.parseDouble(props.get("smoothnessWt"));
        }
        if (props.containsKey("eventRateSmoothnessWt")) {
            eventRateSmoothnessWt = Double.parseDouble(props.get("eventRateSmoothnessWt"));
        }
        if (props.containsKey("minimumRuptureRateFraction")) {
            minimumRuptureRateFraction = Double.parseDouble(props.get("minimumRuptureRateFraction"));
        }
        this.inversionConfiguration = new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, magnitudeEqualityConstraintWt, magnitudeInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, null, null, null, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, null, null, minimumRuptureRateFraction, null);
    }

    private void loadEnergies(Map<String, String> props) {
        this.energies = Maps.newHashMap();
        for (String key : props.keySet()) {
            if (!key.contains("energy") || key.contains("Best") || key.contains("breakdown")) continue;
            double val = Double.parseDouble(props.get(key));
            key = key.trim();
            this.energies.put(key, val);
        }
    }

    public Map<String, Double> getEnergies() {
        return this.energies;
    }

    public synchronized Map<String, Double> getMisfits() {
        if (this.misfits == null) {
            this.misfits = InversionFaultSystemSolution.getMisfits(this.energies, this.inversionConfiguration);
        }
        return this.misfits;
    }

    public static Map<String, Double> getMisfits(Map<String, Double> energies, UCERF3InversionConfiguration inversionConfiguration) {
        HashMap misfits = Maps.newHashMap();
        if (energies == null) {
            return misfits;
        }
        for (String energyStr : energies.keySet()) {
            double wt;
            double eVal = energies.get(energyStr);
            if (energyStr.contains("energy")) {
                energyStr = energyStr.substring(0, energyStr.indexOf("energy")).trim();
            }
            if (energyStr.equals("Slip Rate")) {
                double wtNorm = inversionConfiguration.getSlipRateConstraintWt_normalized();
                double wtUnorm = inversionConfiguration.getSlipRateConstraintWt_unnormalized();
                if (wtNorm > 0.0 && wtUnorm > 0.0) {
                    System.out.println("WARNING: misfits inaccurate for slip rate since both weights used");
                    wt = Math.max(wtNorm, wtUnorm);
                } else {
                    wt = wtNorm > 0.0 ? wtNorm : wtUnorm;
                }
            } else if (energyStr.equals("Paleo Event Rates")) {
                wt = inversionConfiguration.getPaleoRateConstraintWt();
            } else if (energyStr.equals("Paleo Slips")) {
                wt = inversionConfiguration.getPaleoSlipConstraintWt();
            } else if (energyStr.equals("Rupture Rates")) {
                wt = inversionConfiguration.getRupRateConstraintWt();
            } else if (energyStr.equals("Rupture Rate Smoothing")) {
                wt = inversionConfiguration.getRupRateSmoothingConstraintWt();
            } else if (energyStr.equals("Minimization")) {
                wt = inversionConfiguration.getMinimizationConstraintWt();
            } else if (energyStr.equals("MFD Equality")) {
                wt = inversionConfiguration.getMagnitudeEqualityConstraintWt();
            } else if (energyStr.equals("MFD Participation")) {
                wt = inversionConfiguration.getParticipationSmoothnessConstraintWt();
            } else if (energyStr.equals("MFD Nucleation")) {
                wt = inversionConfiguration.getNucleationMFDConstraintWt();
            } else if (energyStr.equals("MFD Smoothness")) {
                wt = inversionConfiguration.getMFDSmoothnessConstraintWt() > 0.0 && inversionConfiguration.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0 ? Double.NaN : (inversionConfiguration.getMFDSmoothnessConstraintWt() > 0.0 ? inversionConfiguration.getMFDSmoothnessConstraintWt() : (inversionConfiguration.getMFDSmoothnessConstraintWtForPaleoParents() > 0.0 ? inversionConfiguration.getMFDSmoothnessConstraintWtForPaleoParents() : 0.0));
            } else if (energyStr.equals("Moment")) {
                wt = inversionConfiguration.getMomentConstraintWt();
            } else if (energyStr.equals("Parkfield")) {
                wt = inversionConfiguration.getParkfieldConstraintWt();
            } else if (energyStr.equals("Event-Rate Smoothness")) {
                wt = inversionConfiguration.getEventRateSmoothnessWt();
            } else {
                throw new IllegalStateException("Unknown Energy Type: " + energyStr);
            }
            double misfit = eVal / (wt * wt);
            System.out.println(energyStr + ": " + eVal + " / (" + wt + ")^2 = " + misfit);
            misfits.put(energyStr, misfit);
        }
        return misfits;
    }

    public InversionModels getInvModel() {
        return this.invModel;
    }

    public U3LogicTreeBranch getLogicTreeBranch() {
        return this.branch;
    }

    public UCERF3InversionConfiguration getInversionConfiguration() {
        return this.inversionConfiguration;
    }

    public void plotMFDs() {
        UCERF2_MFD_ConstraintFetcher ucerf2Fetch = new UCERF2_MFD_ConstraintFetcher();
        U3InversionTargetMFDs inversionTargetMFDs = this.rupSet.getInversionTargetMFDs();
        GraphWindow gw = this.getMFDPlotWindow(inversionTargetMFDs.getTotalRegionalMFD(), inversionTargetMFDs.getTotalOnFaultSupraSeisMFD(), RELM_RegionUtils.getGriddedRegionInstance(), ucerf2Fetch);
        gw.setVisible(true);
        gw = this.getMFDPlotWindow(inversionTargetMFDs.getTotalTargetGR_NoCal(), inversionTargetMFDs.noCalTargetSupraMFD, RELM_RegionUtils.getNoCalGriddedRegionInstance(), ucerf2Fetch);
        gw.setVisible(true);
        gw = this.getMFDPlotWindow(inversionTargetMFDs.getTotalTargetGR_SoCal(), inversionTargetMFDs.soCalTargetSupraMFD, RELM_RegionUtils.getSoCalGriddedRegionInstance(), ucerf2Fetch);
        gw.setVisible(true);
    }

    private boolean isStatewideDM() {
        return this.rupSet.getDeformationModel() != DeformationModels.UCERF2_BAYAREA && this.rupSet.getDeformationModel() != DeformationModels.UCERF2_NCAL;
    }

    public GraphWindow getMFDPlotWindow(IncrementalMagFreqDist totalMFD, IncrementalMagFreqDist targetMFD, Region region, UCERF2_MFD_ConstraintFetcher ucerf2Fetch) {
        PlotSpec spec = this.getMFDPlots(totalMFD, targetMFD, region, ucerf2Fetch);
        GraphWindow gw = new GraphWindow(spec.getPlotElems(), spec.getTitle(), spec.getChars(), true);
        gw.setTickLabelFontSize(14);
        gw.setAxisLabelFontSize(16);
        gw.setPlotLabelFontSize(18);
        gw.setX_AxisLabel(spec.getXAxisLabel());
        gw.setY_AxisLabel(spec.getYAxisLabel());
        gw.setYLog(true);
        gw.setY_AxisRange(1.0E-6, 1.0);
        gw.getGraphWidget().setPlottingOrder(DatasetRenderingOrder.FORWARD);
        return gw;
    }

    public HeadlessGraphPanel getHeadlessMFDPlot(PlotSpec spec, IncrementalMagFreqDist totalMFD) {
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setYLog(true);
        gp.setRenderingOrder(DatasetRenderingOrder.FORWARD);
        double minX = totalMFD.getMinX();
        if (minX < 5.0) {
            minX = 5.0;
        }
        gp.setUserBounds(minX, totalMFD.getMaxX(), 1.0E-6, 1.0);
        gp.drawGraphPanel(spec);
        return gp;
    }

    public PlotSpec getMFDPlots(IncrementalMagFreqDist totalMFD, IncrementalMagFreqDist targetMFD, Region region, UCERF2_MFD_ConstraintFetcher ucerf2Fetch) {
        String plotTitle;
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        boolean statewide = region.getName().startsWith("RELM_TESTING");
        IncrementalMagFreqDist solMFD = this.calcNucleationMFD_forRegion(region, totalMFD.getMinX(), 9.05, 0.1, true);
        solMFD.setName("Solution Supra-Seis MFD");
        solMFD.setInfo("Inversion Solution MFD");
        funcs.add(solMFD);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        funcs.add(totalMFD);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        funcs.add(targetMFD);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN));
        IncrementalMagFreqDist solGriddedMFD = null;
        if (statewide) {
            solGriddedMFD = this.getFinalTotalGriddedSeisMFD();
            funcs.add(solGriddedMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
        }
        ucerf2Fetch.setRegion(region);
        SummedMagFreqDist ucerf2_OffFaultMFD = ucerf2Fetch.getBackgroundSeisMFD();
        ucerf2_OffFaultMFD.setName("UCERF2 Background Seismicity MFD");
        funcs.add(0, ucerf2_OffFaultMFD);
        chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.MAGENTA));
        if (solGriddedMFD != null) {
            SummedMagFreqDist totalModelMFD = new SummedMagFreqDist(solMFD.getMinX(), solMFD.getMaxX(), solMFD.size());
            totalModelMFD.addIncrementalMagFreqDist(solMFD);
            totalModelMFD.addIncrementalMagFreqDist(solGriddedMFD);
            totalModelMFD.setName("Total Model Solution MFD");
            funcs.add(totalModelMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        }
        if ((plotTitle = region.getName()) == null || plotTitle.isEmpty()) {
            plotTitle = "Unnamed Region";
        }
        return new PlotSpec(funcs, chars, plotTitle, "Magnitude", "Incremental Rate (per yr)");
    }

    public List<? extends IncrementalMagFreqDist> getFinalSubSeismoOnFaultMFD_List() {
        boolean noFix = this.branch.getValue(MomentRateFixes.class) == MomentRateFixes.NONE;
        boolean gr = this.branch.getValue(InversionModels.class).isGR();
        ArrayList<IncrementalMagFreqDist> subSeisMFD_list = noFix && gr ? this.getImpliedSubSeisGR_MFD_List() : this.rupSet.getInversionTargetMFDs().getOnFaultSubSeisMFDs().getAll();
        return subSeisMFD_list;
    }

    public List<IncrementalMagFreqDist> getFinalSupraSeismoOnFaultMFD_List(double minMag, double maxMag, int numMag) {
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            mfdList.add(this.calcNucleationMFD_forSect(s, minMag, maxMag, numMag));
        }
        return mfdList;
    }

    public IncrementalMagFreqDist getFinalTotalNucleationMFD_forSect(int sectIndex, double minMag, double maxMag, int numMag) {
        IncrementalMagFreqDist supraMFD = this.calcNucleationMFD_forSect(sectIndex, minMag, maxMag, numMag);
        IncrementalMagFreqDist subSeisMFD = this.getFinalSubSeismoOnFaultMFD_List().get(sectIndex);
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        for (int i = 0; i < numMag; ++i) {
            double mag = mfd.getX(i);
            mfd.set(i, supraMFD.getY(mag) + subSeisMFD.getY(mag));
        }
        return mfd;
    }

    public SummedMagFreqDist getFinalTotalSubSeismoOnFaultMFD() {
        SummedMagFreqDist totalSubSeismoOnFaultMFD = new SummedMagFreqDist(0.05, 90, 0.1);
        for (IncrementalMagFreqDist incrementalMagFreqDist : this.getFinalSubSeismoOnFaultMFD_List()) {
            totalSubSeismoOnFaultMFD.addIncrementalMagFreqDist(incrementalMagFreqDist);
        }
        totalSubSeismoOnFaultMFD.setName("InversionFaultSystemSolution.getFinalTotalSubSeismoOnFaultMFD()");
        return totalSubSeismoOnFaultMFD;
    }

    public SummedMagFreqDist getFinalSubSeismoOnFaultMFDForParent(int parentSectionID) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(0.05, 90, 0.1);
        List<? extends IncrementalMagFreqDist> subSeismoMFDs = this.getFinalSubSeismoOnFaultMFD_List();
        for (int sectIndex = 0; sectIndex < this.rupSet.getNumSections(); ++sectIndex) {
            if (this.rupSet.getFaultSectionData(sectIndex).getParentSectionId() != parentSectionID) continue;
            mfd.addIncrementalMagFreqDist(subSeismoMFDs.get(sectIndex));
        }
        return mfd;
    }

    private ArrayList<GutenbergRichterMagFreqDist> getImpliedSubSeisGR_MFD_List() {
        double minMag = 0.05;
        double deltaMag = 0.1;
        int numMag = 90;
        ArrayList<GutenbergRichterMagFreqDist> grNuclMFD_List = new ArrayList<GutenbergRichterMagFreqDist>();
        GutenbergRichterMagFreqDist tempGR = new GutenbergRichterMagFreqDist(minMag, numMag, deltaMag);
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            double slipRate;
            double area = this.rupSet.getAreaForSection(s);
            double newMoRate = FaultMomentCalc.getMoment(area, slipRate = this.calcSlipRateForSect(s));
            if (Double.isNaN(newMoRate)) {
                newMoRate = 0.0;
            }
            int mMaxIndex = tempGR.getClosestXIndex(this.rupSet.getMaxMagForSection(s));
            double mMax = tempGR.getX(mMaxIndex);
            GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(minMag, numMag, deltaMag, minMag, mMax, newMoRate, 1.0);
            double minSeismoMag = this.rupSet.getUpperMagForSubseismoRuptures(s) + deltaMag / 2.0;
            if (Double.isNaN(minSeismoMag)) {
                gr.scaleToCumRate(0, 0.0);
            } else {
                double closestMag = gr.getX(gr.getClosestXIndex(minSeismoMag));
                gr.zeroAtAndAboveMag(closestMag);
            }
            grNuclMFD_List.add(gr);
        }
        return grNuclMFD_List;
    }

    public static IncrementalMagFreqDist getFinalTrulyOffFaultMFD(InversionTargetMFDs inversionTargetMFDs, MomentRateFixes momRateFixes, double mMaxOffFault, IncrementalMagFreqDist totalSubSeismoMFD, IncrementalMagFreqDist totalSupraSeismoRegionalMFD) {
        if (momRateFixes == MomentRateFixes.NONE || momRateFixes == MomentRateFixes.APPLY_IMPLIED_CC) {
            SummedMagFreqDist finalTrulyOffMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            finalTrulyOffMFD.addIncrementalMagFreqDist(inversionTargetMFDs.getTotalRegionalMFD());
            finalTrulyOffMFD.subtractIncrementalMagFreqDist(totalSubSeismoMFD);
            finalTrulyOffMFD.subtractIncrementalMagFreqDist(totalSupraSeismoRegionalMFD);
            IncrementalMagFreqDist truncatedMFD = new IncrementalMagFreqDist(finalTrulyOffMFD.getMinX(), finalTrulyOffMFD.size(), finalTrulyOffMFD.getDelta());
            int startZeroIndex = finalTrulyOffMFD.getClosestXIndex(mMaxOffFault -= 0.05) + 1;
            for (int i = 0; i < startZeroIndex && i < finalTrulyOffMFD.size(); ++i) {
                truncatedMFD.set(i, finalTrulyOffMFD.getY(i));
            }
            finalTrulyOffMFD.setName("InversionFaultSystemSolution.getFinalTrulyOffFaultMFD()");
            return truncatedMFD;
        }
        IncrementalMagFreqDist finalTrulyOffMFD = inversionTargetMFDs.getTrulyOffFaultMFD().deepClone();
        finalTrulyOffMFD.setName("InversionFaultSystemSolution.getFinalTrulyOffFaultMFD()");
        finalTrulyOffMFD.setInfo("identical to inversionTargetMFDs.getTrulyOffFaultMFD() in this case");
        return finalTrulyOffMFD;
    }

    public IncrementalMagFreqDist getFinalTrulyOffFaultMFD() {
        IncrementalMagFreqDist totalSupraSeismoRegionalMFD = this.calcNucleationMFD_forRegion((Region)RELM_RegionUtils.getGriddedRegionInstance(), 0.05, 8.95, 0.1, true);
        SummedMagFreqDist totalSubSeismoMFD = this.getFinalTotalSubSeismoOnFaultMFD();
        return InversionFaultSystemSolution.getFinalTrulyOffFaultMFD(this.getRupSet().getInversionTargetMFDs(), this.getLogicTreeBranch().getValue(MomentRateFixes.class), this.getLogicTreeBranch().getValue(MaxMagOffFault.class).getMaxMagOffFault(), totalSubSeismoMFD, totalSupraSeismoRegionalMFD);
    }

    public IncrementalMagFreqDist getFinalTotalGriddedSeisMFD() {
        SummedMagFreqDist totGridSeisMFD = new SummedMagFreqDist(0.05, 90, 0.1);
        totGridSeisMFD.addIncrementalMagFreqDist(this.getFinalTrulyOffFaultMFD());
        totGridSeisMFD.addIncrementalMagFreqDist(this.getFinalTotalSubSeismoOnFaultMFD());
        totGridSeisMFD.setName("InversionFaultSystemSolution.getFinalTotalGriddedSeisMFD()");
        return totGridSeisMFD;
    }

    @Override
    public MFDGridSourceProvider getGridSourceProvider() {
        GridSourceProvider gridSourceProvider = super.requireModule(GridSourceProvider.class);
        if (gridSourceProvider == null) {
            gridSourceProvider = new UCERF3_GridSourceGenerator(this);
            super.setGridSourceProvider(gridSourceProvider);
        }
        return (MFDGridSourceProvider)gridSourceProvider;
    }

    public void plotSlipRates() {
        int i;
        int numSections = this.rupSet.getNumSections();
        int numRuptures = this.rupSet.getNumRuptures();
        List<? extends FaultSection> faultSectionData = this.rupSet.getFaultSectionDataList();
        ArrayList<EvenlyDiscretizedFunc> funcs2 = new ArrayList<EvenlyDiscretizedFunc>();
        EvenlyDiscretizedFunc syn = new EvenlyDiscretizedFunc(0.0, (double)numSections - 1.0, numSections);
        EvenlyDiscretizedFunc data = new EvenlyDiscretizedFunc(0.0, (double)numSections - 1.0, numSections);
        for (i = 0; i < numSections; ++i) {
            data.set(i, this.rupSet.getSlipRateForSection(i));
            syn.set(i, 0.0);
        }
        for (int rup = 0; rup < numRuptures; ++rup) {
            double[] slips = this.rupSet.getSlipOnSectionsForRup(rup);
            List<Integer> sects = this.rupSet.getSectionsIndicesForRup(rup);
            for (int i2 = 0; i2 < slips.length; ++i2) {
                int row = sects.get(i2);
                syn.add(row, slips[i2] * this.getRateForRup(rup));
            }
        }
        for (i = 0; i < numSections; ++i) {
            data.set(i, this.rupSet.getSlipRateForSection(i));
        }
        funcs2.add(syn);
        funcs2.add(data);
        GraphWindow graph2 = new GraphWindow(funcs2, "Slip Rate Synthetics (blue) & Data (black)");
        graph2.setX_AxisLabel("Fault Section Index");
        graph2.setY_AxisLabel("Slip Rate");
        Object info = "index\tratio\tpredSR\tdataSR\tParentSectionName\n";
        String parentSectName = "";
        double aveData = 0.0;
        double aveSyn = 0.0;
        double numSubSect = 0.0;
        ArrayList<Double> aveDataList = new ArrayList<Double>();
        ArrayList<Double> aveSynList = new ArrayList<Double>();
        for (int i3 = 0; i3 < numSections; ++i3) {
            if (!faultSectionData.get(i3).getParentSectionName().equals(parentSectName)) {
                if (i3 != 0) {
                    double ratio = aveSyn / aveData;
                    info = (String)info + aveSynList.size() + "\t" + (float)ratio + "\t" + (float)(aveSyn /= numSubSect) + "\t" + (float)(aveData /= numSubSect) + "\t" + faultSectionData.get(i3 - 1).getParentSectionName() + "\n";
                    aveSynList.add(aveSyn);
                    aveDataList.add(aveData);
                }
                aveSyn = 0.0;
                aveData = 0.0;
                numSubSect = 0.0;
                parentSectName = faultSectionData.get(i3).getParentSectionName();
            }
            aveSyn += syn.getY(i3);
            aveData += data.getY(i3);
            numSubSect += 1.0;
        }
        ArrayList<EvenlyDiscretizedFunc> funcs5 = new ArrayList<EvenlyDiscretizedFunc>();
        EvenlyDiscretizedFunc aveSynFunc = new EvenlyDiscretizedFunc(0.0, (double)aveSynList.size() - 1.0, aveSynList.size());
        EvenlyDiscretizedFunc aveDataFunc = new EvenlyDiscretizedFunc(0.0, (double)aveSynList.size() - 1.0, aveSynList.size());
        for (int i4 = 0; i4 < aveSynList.size(); ++i4) {
            aveSynFunc.set(i4, (double)((Double)aveSynList.get(i4)));
            aveDataFunc.set(i4, (double)((Double)aveDataList.get(i4)));
        }
        aveSynFunc.setName("Predicted ave slip rates on parent section");
        aveDataFunc.setName("Original (Data) ave slip rates on parent section");
        aveSynFunc.setInfo((String)info);
        funcs5.add(aveSynFunc);
        funcs5.add(aveDataFunc);
        GraphWindow graph5 = new GraphWindow(funcs5, "Average Slip Rates on Parent Sections");
        graph5.setX_AxisLabel("Parent Section Index");
        graph5.setY_AxisLabel("Slip Rate");
    }

    public static void main(String[] args) throws IOException, DocumentException {
        InversionFaultSystemSolution inv = U3FaultSystemIO.loadInvSol(new File("/tmp/FM2_1_UC2ALL_ShConStrDrp_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU2_VarPaleo0.1_VarSectNuclMFDWt0.01_VarParkfield10000_sol.zip"));
        Map<String, Double> misfits = inv.getMisfits();
        for (String name : misfits.keySet()) {
            System.out.println(name + ": " + String.valueOf(misfits.get(name)));
        }
    }
}

