/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.OldSectionConnectionStrategy;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;
import scratch.UCERF3.inversion.laughTest.OldPlausibilityConfiguration;

public class SectionCluster
extends ArrayList<Integer> {
    public static boolean D = false;
    private List<? extends FaultSection> sectionDataList;
    private ArrayList<Integer> allSectionsIdList = null;
    private int duplicateRups;
    private HashSet<UniqueRupture> processedRuptures;
    private List<List<Integer>> rupListIndices;
    private int numRupsAdded;
    private OldPlausibilityConfiguration plausibility;
    private Map<IDPairing, Double> sectionAzimuths;
    private Map<IDPairing, Double> subSectionDistances;
    private List<List<Integer>> sectionConnectionsListList;
    private OldSectionConnectionStrategy connStrategy;
    int rupCounterProgress = 100000;
    int rupCounterProgressIncrement = 100000;
    int maxRupsPerCluster = 1000000;
    private FailureHandler failHandle;

    public SectionCluster(OldPlausibilityConfiguration plausibility, List<? extends FaultSection> sectionDataList, OldSectionConnectionStrategy connStrategy, List<List<Integer>> sectionConnectionsListList, Map<IDPairing, Double> subSectionAzimuths, Map<IDPairing, Double> subSectionDistances) {
        this.sectionDataList = sectionDataList;
        this.plausibility = plausibility;
        this.connStrategy = connStrategy;
        this.sectionAzimuths = subSectionAzimuths;
        this.subSectionDistances = subSectionDistances;
        this.sectionConnectionsListList = sectionConnectionsListList;
    }

    public int getNumSections() {
        return this.size();
    }

    public List<Integer> getAllSectionsIdList() {
        if (this.allSectionsIdList == null) {
            this.computeAllSectionsIdList();
        }
        return this.allSectionsIdList;
    }

    private void computeAllSectionsIdList() {
        this.allSectionsIdList = new ArrayList();
        for (int i = 0; i < this.size(); ++i) {
            this.allSectionsIdList.add(this.sectionDataList.get((Integer)this.get(i)).getSectionId());
        }
    }

    public int getNumRuptures() {
        if (this.rupListIndices == null) {
            this.computeRupList();
        }
        return this.numRupsAdded;
    }

    public List<List<Integer>> getSectionIndicesForRuptures() {
        if (this.rupListIndices == null) {
            this.computeRupList();
        }
        return this.rupListIndices;
    }

    public List<Integer> getSectionIndicesForRupture(int rthRup) {
        if (this.rupListIndices == null) {
            this.computeRupList();
        }
        return this.rupListIndices.get(rthRup);
    }

    private void addRuptures(FaultSection sect, List<AbstractPlausibilityFilter> laughTests) {
        ArrayList rupture = Lists.newArrayList((Object[])new FaultSection[]{sect});
        ArrayList junctionIndexes = Lists.newArrayList();
        ArrayList pairings = Lists.newArrayList();
        HashSet<Integer> idsSet = new HashSet<Integer>();
        idsSet.add(sect.getSectionId());
        ArrayList idsList = Lists.newArrayList(idsSet);
        this.addRuptures(rupture, pairings, junctionIndexes, laughTests, new UniqueRupture(idsList), idsSet);
    }

    public void setFailureHandler(FailureHandler failHandle) {
        this.failHandle = failHandle;
    }

    private void addRuptures(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes, List<AbstractPlausibilityFilter> tests2, UniqueRupture uniqueRupture, HashSet<Integer> idsSet) {
        boolean debugMatch = false;
        block0: for (List<FaultSection> possibleRupture : this.connStrategy.getNextPossibleRuptures(rupture, idsSet, this.sectionConnectionsListList.get(rupture.get(rupture.size() - 1).getSectionId()), this.sectionDataList)) {
            Preconditions.checkState((possibleRupture.size() > rupture.size() ? 1 : 0) != 0);
            UniqueRupture candidateUnique = uniqueRupture;
            ArrayList<FaultSection> candidateRupture = new ArrayList<FaultSection>(rupture);
            ArrayList<Integer> candidateJunctionIndexes = new ArrayList<Integer>(junctionIndexes);
            ArrayList candidatePairings = Lists.newArrayList(pairings);
            PlausibilityResult candidateResult = null;
            for (int i = rupture.size(); i < possibleRupture.size(); ++i) {
                boolean junction;
                FaultSection currentLastSect = (FaultSection)candidateRupture.get(candidateRupture.size() - 1);
                FaultSection candidateLastSect = possibleRupture.get(i);
                int candidateIndex = candidateLastSect.getSectionId();
                candidateUnique = candidateUnique.takeBranch(candidateIndex);
                candidateRupture.add(candidateLastSect);
                boolean bl = junction = currentLastSect.getParentSectionId() != candidateLastSect.getParentSectionId();
                if (junction) {
                    candidateJunctionIndexes.add(rupture.size());
                }
                candidatePairings.add(new IDPairing(currentLastSect.getSectionId(), candidateIndex));
                candidateResult = PlausibilityResult.PASS;
                for (AbstractPlausibilityFilter test : tests2) {
                    PlausibilityResult result;
                    if (!junction && test.isApplyJunctionsOnly() || (candidateResult = candidateResult.logicalAnd(result = test.applyLastSection(candidateRupture, candidatePairings, candidateJunctionIndexes))).canContinue()) continue;
                    break;
                }
                if (this.failHandle != null && !candidateResult.isPass()) {
                    this.failHandle.ruptureFailed(candidateRupture, candidateResult.canContinue());
                }
                if (!candidateResult.canContinue()) continue block0;
            }
            List<Integer> candidateIDList = candidateUnique.sectIndexes;
            HashSet<Integer> candidateIDSet = new HashSet<Integer>(candidateIDList);
            if (this.processedRuptures.contains(candidateUnique)) {
                ++this.duplicateRups;
            } else if (candidateResult.isPass()) {
                this.processedRuptures.add(candidateUnique);
                this.rupListIndices.add(candidateIDList);
                if (this.numRupsAdded > this.maxRupsPerCluster) {
                    System.out.println("WARNING: Bailing on a cluster after " + this.maxRupsPerCluster + " ruptures!");
                    return;
                }
                ++this.numRupsAdded;
                if (this.numRupsAdded >= this.rupCounterProgress) {
                    if (D) {
                        System.out.println(this.numRupsAdded + " [" + this.rupListIndices.size() + "]");
                    }
                    this.rupCounterProgress += this.rupCounterProgressIncrement;
                }
            }
            this.addRuptures(candidateRupture, candidatePairings, candidateJunctionIndexes, tests2, candidateUnique, candidateIDSet);
        }
    }

    private void computeRupList() {
        this.rupListIndices = new ArrayList<List<Integer>>();
        this.duplicateRups = 0;
        this.processedRuptures = new HashSet();
        boolean progress = false;
        int progressIncrement = 5;
        this.numRupsAdded = 0;
        List<AbstractPlausibilityFilter> laughTests = this.plausibility.getPlausibilityFilters();
        for (int s = 0; s < this.size(); ++s) {
            ArrayList<Integer> sectList = new ArrayList<Integer>();
            int sectIndex = (Integer)this.get(s);
            sectList.add(sectIndex);
            this.addRuptures(this.sectionDataList.get(sectIndex), laughTests);
            if (!D) continue;
            System.out.println(this.rupListIndices.size() + " ruptures after section " + s + " (skipped " + this.duplicateRups + " duplicates)");
        }
        if (D) {
            System.out.println("\nAdded " + this.numRupsAdded + " rups!");
        }
    }

    public void writeRuptureSectionNames(int index) {
        List<Integer> rupture = this.rupListIndices.get(index);
        System.out.println("Rutpure " + index);
        for (int i = 0; i < rupture.size(); ++i) {
            System.out.println("\t" + this.sectionDataList.get(rupture.get(i)).getName());
        }
    }

    public static double getAzimuthDifference(double azimuth1, double azimuth2) {
        double diff = azimuth2 - azimuth1;
        if (diff > 180.0) {
            return diff - 360.0;
        }
        if (diff < -180.0) {
            return diff + 360.0;
        }
        return diff;
    }

    private class UniqueRupture {
        private final List<Integer> sectIndexes;
        private final List<Integer> sortedIndexes;
        private final int lastIndex;

        public UniqueRupture(List<Integer> sectIndexes) {
            this.sectIndexes = sectIndexes;
            this.sortedIndexes = new ArrayList<Integer>(sectIndexes);
            Collections.sort(this.sortedIndexes);
            this.lastIndex = sectIndexes.get(sectIndexes.size() - 1);
        }

        public UniqueRupture takeBranch(int sectIndex) {
            ArrayList<Integer> newIndexes = new ArrayList<Integer>(this.sectIndexes);
            newIndexes.add(sectIndex);
            UniqueRupture newRup = new UniqueRupture(newIndexes);
            return newRup;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.sortedIndexes == null ? 0 : this.sortedIndexes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueRupture other = (UniqueRupture)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.sortedIndexes == null ? other.sortedIndexes != null : !this.sortedIndexes.equals(other.sortedIndexes));
        }

        private SectionCluster getEnclosingInstance() {
            return SectionCluster.this;
        }
    }

    public static interface FailureHandler {
        public void ruptureFailed(List<FaultSection> var1, boolean var2);
    }
}

