/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.griddedSeismicity.GriddedSeisUtils;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class U3InversionTargetMFDs
extends InversionTargetMFDs
implements ArchivableModule,
SubModule<FaultSystemRupSet> {
    protected static final boolean D = false;
    static final boolean GR_OFF_FAULT_IS_TAPERED = true;
    protected String debugString;
    protected double totalRegionRateMgt5;
    protected double onFaultRegionRateMgt5;
    protected double offFaultRegionRateMgt5;
    protected double mMaxOffFault;
    protected boolean applyImpliedCouplingCoeff;
    protected SpatialSeisPDF spatialSeisPDF;
    protected SpatialSeisPDF spatialSeisPDFforOnFaultRates;
    protected InversionModels inversionModel;
    protected GriddedSeisUtils gridSeisUtils;
    protected double origOnFltDefModMoRate;
    protected double offFltDefModMoRate;
    protected double aveMinSeismoMag;
    protected double roundedMmaxOnFault;
    double fractSeisInSoCal;
    protected double fractionSeisOnFault;
    protected double impliedOnFaultCouplingCoeff;
    protected double impliedTotalCouplingCoeff;
    protected double finalOffFaultCouplingCoeff;
    protected GutenbergRichterMagFreqDist totalTargetGR;
    protected SummedMagFreqDist targetOnFaultSupraSeisMFD;
    protected IncrementalMagFreqDist trulyOffFaultMFD;
    protected SubSeismoOnFaultMFDs subSeismoOnFaultMFDs;
    protected SummedMagFreqDist totalSubSeismoOnFaultMFD;
    GutenbergRichterMagFreqDist totalTargetGR_NoCal;
    GutenbergRichterMagFreqDist totalTargetGR_SoCal;
    IncrementalMagFreqDist noCalTargetSupraMFD;
    IncrementalMagFreqDist soCalTargetSupraMFD;
    List<IncrementalMagFreqDist> mfdConstraintsForNoAndSoCal;
    public static final double MIN_MAG = 0.05;
    public static final double MAX_MAG = 8.95;
    public static final int NUM_MAG = 90;
    public static final double DELTA_MAG = 0.1;
    public static final double FAULT_BUFFER = 12.0;
    private LogicTreeBranch<?> logicTreeBranch;
    private ModSectMinMags finalMinMags;
    private PolygonFaultGridAssociations polygons;

    protected U3InversionTargetMFDs() {
        super(null);
    }

    public U3InversionTargetMFDs(InversionFaultSystemRupSet invRupSet) {
        this(invRupSet, invRupSet.requireModule(LogicTreeBranch.class), invRupSet.requireModule(ModSectMinMags.class), invRupSet.requireModule(PolygonFaultGridAssociations.class));
    }

    public U3InversionTargetMFDs(FaultSystemRupSet rupSet, LogicTreeBranch<?> logicTreeBranch, ModSectMinMags finalMinMags, PolygonFaultGridAssociations polygons) {
        super(rupSet);
        this.init(rupSet, logicTreeBranch, finalMinMags, polygons);
    }

    private void init(FaultSystemRupSet rupSet, LogicTreeBranch<?> logicTreeBranch, ModSectMinMags finalMinMags, PolygonFaultGridAssociations polygons) {
        boolean noMoRateFix;
        this.polygons = polygons;
        this.logicTreeBranch = logicTreeBranch;
        this.finalMinMags = finalMinMags;
        this.inversionModel = logicTreeBranch.getValue(InversionModels.class);
        this.totalRegionRateMgt5 = logicTreeBranch.getValue(TotalMag5Rate.class).getRateMag5();
        this.mMaxOffFault = logicTreeBranch.getValue(MaxMagOffFault.class).getMaxMagOffFault();
        this.applyImpliedCouplingCoeff = logicTreeBranch.getValue(MomentRateFixes.class).isApplyCC();
        this.spatialSeisPDF = logicTreeBranch.getValue(SpatialSeisPDF.class);
        this.mMaxOffFault -= 0.05;
        boolean bl = noMoRateFix = logicTreeBranch.getValue(MomentRateFixes.class) == MomentRateFixes.NONE;
        if (this.spatialSeisPDF != SpatialSeisPDF.UCERF2 && this.spatialSeisPDF != SpatialSeisPDF.UCERF3) {
            System.out.println("WARNING: Was previously hardcoded (for unknown reasons) to force U3 or U2 spatial seismicity on faults. This has been disabled.");
        }
        this.spatialSeisPDFforOnFaultRates = this.spatialSeisPDF;
        DeformationModels dm = logicTreeBranch.getValue(DeformationModels.class);
        if (dm == DeformationModels.UCERF2_BAYAREA || dm == DeformationModels.UCERF2_NCAL) {
            throw new RuntimeException("Error - " + String.valueOf(dm) + " not yet supported by InversionMFD");
        }
        List<? extends FaultSection> faultSectionData = rupSet.getFaultSectionDataList();
        this.gridSeisUtils = new GriddedSeisUtils(faultSectionData, this.spatialSeisPDFforOnFaultRates, polygons);
        CaliforniaRegions.RELM_NOCAL_GRIDDED noCalGrid = RELM_RegionUtils.getNoCalGriddedRegionInstance();
        CaliforniaRegions.RELM_SOCAL_GRIDDED soCalGrid = RELM_RegionUtils.getSoCalGriddedRegionInstance();
        this.fractSeisInSoCal = this.spatialSeisPDFforOnFaultRates.getFractionInRegion(soCalGrid);
        this.fractionSeisOnFault = this.gridSeisUtils.pdfInPolys();
        this.onFaultRegionRateMgt5 = this.totalRegionRateMgt5 * this.fractionSeisOnFault;
        this.offFaultRegionRateMgt5 = this.totalRegionRateMgt5 - this.onFaultRegionRateMgt5;
        this.origOnFltDefModMoRate = DeformationModelsCalc.calculateTotalMomentRate(faultSectionData, true);
        FaultModels fm = logicTreeBranch.getValue(FaultModels.class);
        if (fm == null || dm == null) {
            System.err.println("ERR: non-UCERF3 deformation model encountered, can't get DM off fault moment rate. Setting to zero.");
            this.offFltDefModMoRate = 0.0;
        } else {
            this.offFltDefModMoRate = DeformationModelsCalc.calcMoRateOffFaultsForDefModel(logicTreeBranch.getValue(FaultModels.class), logicTreeBranch.getValue(DeformationModels.class));
        }
        this.totalTargetGR = new GutenbergRichterMagFreqDist(0.05, 90, 0.1);
        this.roundedMmaxOnFault = this.totalTargetGR.getX(this.totalTargetGR.getClosestXIndex(rupSet.getMaxMag()));
        this.totalTargetGR.setAllButTotMoRate(0.05, this.roundedMmaxOnFault, this.totalRegionRateMgt5 * 100000.0, 1.0);
        this.totalTargetGR_NoCal = new GutenbergRichterMagFreqDist(0.05, 90, 0.1);
        this.totalTargetGR_NoCal.setAllButTotMoRate(0.05, this.roundedMmaxOnFault, this.totalRegionRateMgt5 * (1.0 - this.fractSeisInSoCal) * 100000.0, 1.0);
        this.totalTargetGR_SoCal = new GutenbergRichterMagFreqDist(0.05, 90, 0.1);
        this.totalTargetGR_SoCal.setAllButTotMoRate(0.05, this.roundedMmaxOnFault, this.totalRegionRateMgt5 * this.fractSeisInSoCal * 100000.0, 1.0);
        double tempMag = FaultSystemRupSetCalc.getMeanMinMag(rupSet, finalMinMags, true);
        this.aveMinSeismoMag = this.totalTargetGR.getX(this.totalTargetGR.getClosestXIndex(tempMag));
        if (this.inversionModel.isCharacteristic()) {
            this.trulyOffFaultMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(this.totalTargetGR, this.onFaultRegionRateMgt5, this.aveMinSeismoMag, this.mMaxOffFault);
            this.subSeismoOnFaultMFDs = new SubSeismoOnFaultMFDs(FaultSystemRupSetCalc.getCharSubSeismoOnFaultMFD_forEachSection(rupSet, finalMinMags, this.gridSeisUtils, this.totalTargetGR));
            this.totalSubSeismoOnFaultMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            for (int m = 0; m < this.subSeismoOnFaultMFDs.size(); ++m) {
                IncrementalMagFreqDist mfd = this.subSeismoOnFaultMFDs.get(m);
                this.totalSubSeismoOnFaultMFD.addIncrementalMagFreqDist(mfd);
            }
            this.targetOnFaultSupraSeisMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            this.targetOnFaultSupraSeisMFD.addIncrementalMagFreqDist(this.totalTargetGR);
            this.targetOnFaultSupraSeisMFD.subtractIncrementalMagFreqDist(this.trulyOffFaultMFD);
            this.targetOnFaultSupraSeisMFD.subtractIncrementalMagFreqDist(this.totalSubSeismoOnFaultMFD);
            this.noCalTargetSupraMFD = new IncrementalMagFreqDist(0.05, 90, 0.1);
            this.soCalTargetSupraMFD = new IncrementalMagFreqDist(0.05, 90, 0.1);
            for (int i = 0; i < 90; ++i) {
                this.noCalTargetSupraMFD.set(i, this.targetOnFaultSupraSeisMFD.getY(i) * (1.0 - this.fractSeisInSoCal));
                this.soCalTargetSupraMFD.set(i, this.targetOnFaultSupraSeisMFD.getY(i) * this.fractSeisInSoCal);
            }
            this.impliedOnFaultCouplingCoeff = (this.targetOnFaultSupraSeisMFD.getTotalMomentRate() + this.totalSubSeismoOnFaultMFD.getTotalMomentRate()) / this.origOnFltDefModMoRate;
            this.finalOffFaultCouplingCoeff = this.trulyOffFaultMFD.getTotalMomentRate() / this.offFltDefModMoRate;
            this.impliedTotalCouplingCoeff = this.totalTargetGR.getTotalMomentRate() / (this.origOnFltDefModMoRate + this.offFltDefModMoRate);
        } else {
            SummedMagFreqDist impliedOnFault_GR_NuclMFD = FaultSystemRupSetCalc.calcImpliedGR_NucleationMFD(rupSet, 0.05, 90, 0.1);
            this.impliedOnFaultCouplingCoeff = this.onFaultRegionRateMgt5 / impliedOnFault_GR_NuclMFD.getCumRate(5.05);
            double tempCoupCoeff = 1.0;
            if (this.applyImpliedCouplingCoeff && this.impliedOnFaultCouplingCoeff < 1.0) {
                tempCoupCoeff = this.impliedOnFaultCouplingCoeff;
            }
            ArrayList<GutenbergRichterMagFreqDist> grNuclMFD_List = FaultSystemRupSetCalc.calcImpliedGR_NuclMFD_ForEachSection(rupSet, 0.05, 90, 0.1);
            ArrayList<GutenbergRichterMagFreqDist> subSeismoOnFaultMFD_List = new ArrayList<GutenbergRichterMagFreqDist>();
            this.totalSubSeismoOnFaultMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            this.targetOnFaultSupraSeisMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            this.noCalTargetSupraMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            this.soCalTargetSupraMFD = new SummedMagFreqDist(0.05, 90, 0.1);
            for (int s = 0; s < grNuclMFD_List.size(); ++s) {
                GutenbergRichterMagFreqDist grNuclMFD = grNuclMFD_List.get(s);
                double maxMagSubSeismo = InversionFaultSystemRupSet.getUpperMagForSubseismoRuptures(finalMinMags.getMinMagForSection(s));
                int minSupraMagIndex = grNuclMFD.getXIndex(maxMagSubSeismo) + 1;
                GutenbergRichterMagFreqDist subSeisGR = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, maxMagSubSeismo, 1.0, 1.0);
                double rateAtZeroMagBin = grNuclMFD.getY(0) * tempCoupCoeff;
                subSeisGR.scaleToIncrRate(0, rateAtZeroMagBin);
                subSeismoOnFaultMFD_List.add(subSeisGR);
                this.totalSubSeismoOnFaultMFD.addIncrementalMagFreqDist(subSeisGR);
                FaultTrace sectTrace = faultSectionData.get(s).getFaultSurface(1.0).getEvenlyDiscritizedUpperEdge();
                double fractSectInSoCal = RegionUtils.getFractionInside(soCalGrid, sectTrace);
                for (int i = minSupraMagIndex; i < grNuclMFD.size(); ++i) {
                    this.targetOnFaultSupraSeisMFD.add(i, grNuclMFD.getY(i) * tempCoupCoeff);
                    this.noCalTargetSupraMFD.add(i, grNuclMFD.getY(i) * tempCoupCoeff * (1.0 - fractSectInSoCal));
                    this.soCalTargetSupraMFD.add(i, grNuclMFD.getY(i) * tempCoupCoeff * fractSectInSoCal);
                }
            }
            this.subSeismoOnFaultMFDs = new SubSeismoOnFaultMFDs(subSeismoOnFaultMFD_List);
            if (noMoRateFix && this.impliedOnFaultCouplingCoeff < 1.0) {
                this.totalSubSeismoOnFaultMFD.scale(this.impliedOnFaultCouplingCoeff);
                this.targetOnFaultSupraSeisMFD = new SummedMagFreqDist(0.05, 90, 0.1);
                this.targetOnFaultSupraSeisMFD.addIncrementalMagFreqDist(this.totalTargetGR);
                this.targetOnFaultSupraSeisMFD.scaleToIncrRate(5.05, impliedOnFault_GR_NuclMFD.getY(5.05) * this.impliedOnFaultCouplingCoeff);
                this.targetOnFaultSupraSeisMFD.subtractIncrementalMagFreqDist(this.totalSubSeismoOnFaultMFD);
                this.noCalTargetSupraMFD = new SummedMagFreqDist(0.05, 90, 0.1);
                this.soCalTargetSupraMFD = new SummedMagFreqDist(0.05, 90, 0.1);
                for (int i = 0; i < this.targetOnFaultSupraSeisMFD.size(); ++i) {
                    this.noCalTargetSupraMFD.add(i, this.targetOnFaultSupraSeisMFD.getY(i) * (1.0 - this.fractSeisInSoCal));
                    this.soCalTargetSupraMFD.add(i, this.targetOnFaultSupraSeisMFD.getY(i) * this.fractSeisInSoCal);
                }
            }
            this.trulyOffFaultMFD = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 0.05, this.mMaxOffFault, 1.0, 1.0);
            this.trulyOffFaultMFD.scaleToCumRate(0, this.offFaultRegionRateMgt5 * 100000.0);
            double moRate = this.trulyOffFaultMFD.getTotalMomentRate();
            this.trulyOffFaultMFD = new TaperedGR_MagFreqDist(0.05, 90, 0.1);
            ((TaperedGR_MagFreqDist)this.trulyOffFaultMFD).setAllButCornerMag(0.05, moRate, this.offFaultRegionRateMgt5 * 100000.0, 1.0);
            this.finalOffFaultCouplingCoeff = this.trulyOffFaultMFD.getTotalMomentRate() / this.offFltDefModMoRate;
            this.impliedTotalCouplingCoeff = (this.impliedOnFaultCouplingCoeff * this.origOnFltDefModMoRate + this.finalOffFaultCouplingCoeff * this.offFltDefModMoRate) / (this.origOnFltDefModMoRate + this.offFltDefModMoRate);
        }
        this.totalTargetGR.setName("InversionTargetMFDs.totalTargetGR");
        this.totalTargetGR_NoCal.setName("InversionTargetMFDs.totalTargetGR_NoCal");
        this.totalTargetGR_SoCal.setName("InversionTargetMFDs.totalTargetGR_SoCal");
        this.targetOnFaultSupraSeisMFD.setName("InversionTargetMFDs.targetOnFaultSupraSeisMFD");
        this.trulyOffFaultMFD.setName("InversionTargetMFDs.trulyOffFaultMFD");
        this.totalSubSeismoOnFaultMFD.setName("InversionTargetMFDs.totalSubSeismoOnFaultMFD");
        this.noCalTargetSupraMFD.setName("InversionTargetMFDs.noCalTargetSupraMFD");
        this.soCalTargetSupraMFD.setName("InversionTargetMFDs.soCalTargetSupraMFD");
        this.mfdConstraintsForNoAndSoCal = new ArrayList<IncrementalMagFreqDist>();
        this.noCalTargetSupraMFD.setRegion(new Region(noCalGrid));
        this.mfdConstraintsForNoAndSoCal.add(this.noCalTargetSupraMFD);
        this.soCalTargetSupraMFD.setRegion(new Region(soCalGrid));
        this.mfdConstraintsForNoAndSoCal.add(this.soCalTargetSupraMFD);
    }

    public double getTotalRegionRateMgt5() {
        return this.totalRegionRateMgt5;
    }

    public double getMmaxOffFault() {
        return this.mMaxOffFault;
    }

    public double getFractionSeisOnFault() {
        return this.fractionSeisOnFault;
    }

    public double getImpliedOnFaultCouplingCoeff() {
        return this.impliedOnFaultCouplingCoeff;
    }

    @Override
    public IncrementalMagFreqDist getTotalOnFaultSupraSeisMFD() {
        return this.targetOnFaultSupraSeisMFD;
    }

    @Override
    public IncrementalMagFreqDist getTrulyOffFaultMFD() {
        return this.trulyOffFaultMFD;
    }

    @Override
    public SubSeismoOnFaultMFDs getOnFaultSubSeisMFDs() {
        return this.subSeismoOnFaultMFDs;
    }

    @Override
    public IncrementalMagFreqDist getTotalOnFaultSubSeisMFD() {
        return this.totalSubSeismoOnFaultMFD;
    }

    @Override
    public IncrementalMagFreqDist getTotalRegionalMFD() {
        return this.totalTargetGR;
    }

    public GutenbergRichterMagFreqDist getTotalTargetGR_NoCal() {
        return this.totalTargetGR_NoCal;
    }

    public GutenbergRichterMagFreqDist getTotalTargetGR_SoCal() {
        return this.totalTargetGR_SoCal;
    }

    public double getOrigOnFltDefModMoRate() {
        return this.origOnFltDefModMoRate;
    }

    public List<IncrementalMagFreqDist> getMFD_Constraints() {
        return this.mfdConstraintsForNoAndSoCal;
    }

    public String getPreInversionAnalysisData() {
        String str = (float)this.fractionSeisOnFault + "\t" + (float)this.fractSeisInSoCal + "\t" + (float)this.roundedMmaxOnFault + "\t" + (float)this.aveMinSeismoMag + "\t" + (float)this.origOnFltDefModMoRate + "\t" + (float)this.offFltDefModMoRate + "\t" + (float)this.impliedOnFaultCouplingCoeff + "\t" + (float)this.finalOffFaultCouplingCoeff + "\t" + (float)this.impliedTotalCouplingCoeff + "\t" + (float)this.trulyOffFaultMFD.getCumRate(5.05) + "\t" + (float)this.totalSubSeismoOnFaultMFD.getCumRate(5.05) + "\t" + (float)this.targetOnFaultSupraSeisMFD.getCumRate(5.05) + "\t" + (float)this.noCalTargetSupraMFD.getCumRate(5.05) + "\t" + (float)this.soCalTargetSupraMFD.getCumRate(5.05) + "\t" + (float)this.trulyOffFaultMFD.getTotalMomentRate() + "\t" + (float)this.totalSubSeismoOnFaultMFD.getTotalMomentRate() + "\t" + (float)this.targetOnFaultSupraSeisMFD.getTotalMomentRate() + "\t" + (float)this.noCalTargetSupraMFD.getTotalMomentRate() + "\t" + (float)this.soCalTargetSupraMFD.getTotalMomentRate();
        return str;
    }

    public String getPreInversionAnalysisDataHeader() {
        String str = "frSeisOnFlt\tfrSeisInSoCal\tMmaxOnFlt\taveSupraSeisMmin\tonFltDefModMoRate\toffFltDefModMoRate\timplOnFaultCC\tfinalOffFaultCC\timplTotalCC\ttrulyOffFltMFD_RateM5\tsubSeisOnFltMFD_RateM5\ttargetOnFtSupraSeisMFD_RateM5\tnoCalTargetSuprSeisMFD_RateM5\tsoCalTargetSuprSeisMFD_RateM5\ttrulyOffFltMFD_MoRate\tsubSeisOnFltMFD_MoRate\ttargetOnFtSupraSeisMFD_MoRate\tnoCalTargetSuprSeisMFD_MoRate\tsoCalTargetSuprSeisMFD_MoRate";
        return str;
    }

    public double getOffFaultMmaxIfOrigMoRateSatisfied() {
        double maxOffMagWithFullMoment;
        if (this.inversionModel.isCharacteristic()) {
            IncrementalMagFreqDist charOffMFD = FaultSystemRupSetCalc.getTriLinearCharOffFaultTargetMFD(this.offFltDefModMoRate, this.totalTargetGR, this.onFaultRegionRateMgt5, this.aveMinSeismoMag);
            maxOffMagWithFullMoment = charOffMFD != null ? charOffMFD.getMaxMagWithNonZeroRate() : Double.NaN;
        } else {
            GutenbergRichterMagFreqDist tempOffFaultGR = new GutenbergRichterMagFreqDist(0.005, 2000, 0.01);
            tempOffFaultGR.setAllButMagUpper(0.005, this.offFltDefModMoRate, this.offFaultRegionRateMgt5 * 100000.0, 1.0, true);
            maxOffMagWithFullMoment = tempOffFaultGR.getMagUpper();
        }
        return maxOffMagWithFullMoment;
    }

    public double getOffFaultRegionRateMgt5() {
        return this.offFaultRegionRateMgt5;
    }

    public GriddedSeisUtils getGridSeisUtils() {
        return this.gridSeisUtils;
    }

    public static GutenbergRichterMagFreqDist getTotalTargetGR_upToM9(double totalRegionRateMgt5) {
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(0.05, 90, 0.1, 1.0, 1.0);
        gr.scaleToCumRate(0, totalRegionRateMgt5 * 100000.0);
        return gr;
    }

    @Override
    public String getName() {
        return "UCERF3 Inversion Target MFDs";
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        new InversionTargetMFDs.Precomputed(this).writeToArchive(output, entryPrefix);
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"Rupture set not initialized");
        this.init(rupSet, rupSet.requireModule(U3LogicTreeBranch.class), rupSet.requireModule(ModSectMinMags.class), rupSet.requireModule(PolygonFaultGridAssociations.class));
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return InversionTargetMFDs.Precomputed.class;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkState((rupSet == null || rupSet.isEquivalentTo(newParent) ? 1 : 0) != 0);
        if (!newParent.hasModule(U3LogicTreeBranch.class)) {
            newParent.addModule(this.logicTreeBranch);
        }
        if (!newParent.hasModule(ModSectMinMags.class)) {
            newParent.addModule(this.finalMinMags);
        }
        if (!newParent.hasModule(PolygonFaultGridAssociations.class)) {
            newParent.addModule(this.polygons);
        }
        return new U3InversionTargetMFDs(newParent, this.logicTreeBranch, this.finalMinMags, this.polygons);
    }

    @Override
    public AverageableModule.AveragingAccumulator<InversionTargetMFDs> averagingAccumulator() {
        return new InversionTargetMFDs.Precomputed(this).averagingAccumulator();
    }
}

