/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_FM2pt1_Ruptures;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_FM3_Ruptures;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_Ruptures;
import scratch.UCERF3.utils.MFD_InversionConstraint;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class UCERF3InversionConfiguration
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "InversionConfiguration";
    private static double magNorm = 7.0;
    private double slipRateConstraintWt_normalized;
    private double slipRateConstraintWt_unnormalized;
    private double paleoRateConstraintWt;
    private double paleoSlipConstraintWt;
    private double magnitudeEqualityConstraintWt;
    private double magnitudeInequalityConstraintWt;
    private double rupRateConstraintWt;
    private double participationSmoothnessConstraintWt;
    private double participationConstraintMagBinSize;
    private double nucleationMFDConstraintWt;
    private double mfdSmoothnessConstraintWt;
    private double mfdSmoothnessConstraintWtForPaleoParents;
    private double rupRateSmoothingConstraintWt;
    private double minimizationConstraintWt;
    private double momentConstraintWt;
    private double parkfieldConstraintWt;
    private double[] aPrioriRupConstraint;
    private double[] initialRupModel;
    private double[] minimumRuptureRateBasis;
    private double MFDTransitionMag;
    private List<? extends IncrementalMagFreqDist> mfdEqualityConstraints;
    private List<? extends IncrementalMagFreqDist> mfdInequalityConstraints;
    private double minimumRuptureRateFraction;
    private double smoothnessWt;
    private double eventRateSmoothnessWt;
    protected static final boolean D = true;
    private boolean aPrioriConstraintForZeroRates = true;
    private double aPrioriConstraintForZeroRatesWtFactor = 0.1;
    private boolean excludeParkfieldRupsFromMfdEqualityConstraints = true;
    private String metadata;
    public static final double DEFAULT_MFD_EQUALITY_WT = 10.0;
    public static final double DEFAULT_MFD_INEQUALITY_WT = 1000.0;

    UCERF3InversionConfiguration(double slipRateConstraintWt_normalized, double slipRateConstraintWt_unnormalized, double paleoRateConstraintWt, double paleoSlipConstraintWt, double magnitudeEqualityConstraintWt, double magnitudeInequalityConstraintWt, double rupRateConstraintWt, double participationSmoothnessConstraintWt, double participationConstraintMagBinSize, double nucleationMFDConstraintWt, double mfdSmoothnessConstraintWt, double mfdSmoothnessConstraintWtForPaleoParents, double rupRateSmoothingConstraintWt, double minimizationConstraintWt, double momentConstraintWt, double parkfieldConstraintWt, double[] aPrioriRupConstraint, double[] initialRupModel, double[] minimumRuptureRateBasis, double smoothnessWt, double eventRateSmoothnessWt, double MFDTransitionMag, List<? extends IncrementalMagFreqDist> mfdEqualityConstraints, List<? extends IncrementalMagFreqDist> mfdInequalityConstraints, double minimumRuptureRateFraction, String metadata) {
        metadata = metadata == null || ((String)metadata).isEmpty() ? "" : (String)metadata + "\n";
        this.slipRateConstraintWt_normalized = slipRateConstraintWt_normalized;
        metadata = (String)metadata + "slipRateConstraintWt_normalized: " + slipRateConstraintWt_normalized;
        this.slipRateConstraintWt_unnormalized = slipRateConstraintWt_unnormalized;
        metadata = (String)metadata + "\nslipRateConstraintWt_unnormalized: " + slipRateConstraintWt_unnormalized;
        this.paleoRateConstraintWt = paleoRateConstraintWt;
        metadata = (String)metadata + "\npaleoRateConstraintWt: " + paleoRateConstraintWt;
        this.paleoSlipConstraintWt = paleoSlipConstraintWt;
        metadata = (String)metadata + "\npaleoSlipConstraintWt: " + paleoSlipConstraintWt;
        this.magnitudeEqualityConstraintWt = magnitudeEqualityConstraintWt;
        metadata = (String)metadata + "\nmagnitudeEqualityConstraintWt: " + magnitudeEqualityConstraintWt;
        this.magnitudeInequalityConstraintWt = magnitudeInequalityConstraintWt;
        metadata = (String)metadata + "\nmagnitudeInequalityConstraintWt: " + magnitudeInequalityConstraintWt;
        this.rupRateConstraintWt = rupRateConstraintWt;
        metadata = (String)metadata + "\nrupRateConstraintWt: " + rupRateConstraintWt;
        this.participationSmoothnessConstraintWt = participationSmoothnessConstraintWt;
        metadata = (String)metadata + "\nparticipationSmoothnessConstraintWt: " + participationSmoothnessConstraintWt;
        this.participationConstraintMagBinSize = participationConstraintMagBinSize;
        metadata = (String)metadata + "\nparticipationConstraintMagBinSize: " + participationConstraintMagBinSize;
        this.nucleationMFDConstraintWt = nucleationMFDConstraintWt;
        metadata = (String)metadata + "\nnucleationMFDConstraintWt: " + nucleationMFDConstraintWt;
        this.mfdSmoothnessConstraintWt = mfdSmoothnessConstraintWt;
        metadata = (String)metadata + "\nmfdSmoothnessConstraintWt: " + mfdSmoothnessConstraintWt;
        this.mfdSmoothnessConstraintWtForPaleoParents = mfdSmoothnessConstraintWtForPaleoParents;
        metadata = (String)metadata + "\nmfdSmoothnessConstraintWtForPaleoParents: " + mfdSmoothnessConstraintWtForPaleoParents;
        this.rupRateSmoothingConstraintWt = rupRateSmoothingConstraintWt;
        metadata = (String)metadata + "\nrupRateSmoothingConstraintWt: " + rupRateSmoothingConstraintWt;
        this.minimizationConstraintWt = minimizationConstraintWt;
        metadata = (String)metadata + "\nminimizationConstraintWt: " + minimizationConstraintWt;
        this.momentConstraintWt = momentConstraintWt;
        metadata = (String)metadata + "\nmomentConstraintWt: " + momentConstraintWt;
        this.parkfieldConstraintWt = parkfieldConstraintWt;
        metadata = (String)metadata + "\nparkfieldConstraintWt: " + parkfieldConstraintWt;
        this.aPrioriRupConstraint = aPrioriRupConstraint;
        this.initialRupModel = initialRupModel;
        this.minimumRuptureRateBasis = minimumRuptureRateBasis;
        this.smoothnessWt = smoothnessWt;
        metadata = (String)metadata + "\nsmoothnessWt: " + smoothnessWt;
        this.eventRateSmoothnessWt = eventRateSmoothnessWt;
        metadata = (String)metadata + "\neventRateSmoothnessWt: " + eventRateSmoothnessWt;
        this.mfdEqualityConstraints = mfdEqualityConstraints;
        this.mfdInequalityConstraints = mfdInequalityConstraints;
        this.MFDTransitionMag = MFDTransitionMag;
        this.minimumRuptureRateFraction = minimumRuptureRateFraction;
        this.metadata = metadata = (String)metadata + "\nminimumRuptureRateFraction: " + minimumRuptureRateFraction;
    }

    public static UCERF3InversionConfiguration forModel(InversionModels model, FaultSystemRupSet rupSet, FaultModels fm, InversionTargetMFDs targetMFDs) {
        double mfdEqualityConstraintWt = 10.0;
        double mfdInequalityConstraintWt = 1000.0;
        return UCERF3InversionConfiguration.forModel(model, rupSet, fm, targetMFDs, mfdEqualityConstraintWt, mfdInequalityConstraintWt);
    }

    public static UCERF3InversionConfiguration forModel(InversionModels model, FaultSystemRupSet rupSet, FaultModels fm, InversionTargetMFDs targetMFDs, double mfdEqualityConstraintWt, double mfdInequalityConstraintWt) {
        return UCERF3InversionConfiguration.forModel(model, rupSet, fm, targetMFDs, mfdEqualityConstraintWt, mfdInequalityConstraintWt, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UCERF3InversionConfiguration forModel(InversionModels model, FaultSystemRupSet rupSet, FaultModels fm, InversionTargetMFDs targetMFDs, double mfdEqualityConstraintWt, double mfdInequalityConstraintWt, CommandLine modifiers) {
        void var51_36;
        List<? extends IncrementalMagFreqDist> mfdEqualityConstraints;
        double[] initialRupModel;
        double[] minimumRuptureRateBasis;
        double minimumRuptureRateFraction;
        double[] aPrioriRupConstraint;
        double rupRateConstraintWt;
        double eventRateSmoothnessWt;
        double mfdSmoothnessConstraintWtForPaleoParents;
        double mfdSmoothnessConstraintWt;
        double nucleationMFDConstraintWt;
        double participationSmoothnessConstraintWt;
        double slipRateConstraintWt_normalized = 1.0;
        double slipRateConstraintWt_unnormalized = 100.0;
        double paleoRateConstraintWt = 1.2;
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.PALEO_WT.getArgName())) {
            paleoRateConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.PALEO_WT.getArgName()));
            System.out.println("Setting paleo constraint wt: " + paleoRateConstraintWt);
        }
        double paleoSlipConstraintWt = paleoRateConstraintWt * 0.1 / 4.0;
        double participationConstraintMagBinSize = 0.1;
        double rupRateSmoothingConstraintWt = 0.0;
        double minimizationConstraintWt = 10000.0;
        double smoothnessWt = 0.0;
        double momentConstraintWt = 0.0;
        double parkfieldConstraintWt = 1000.0;
        List<? extends IncrementalMagFreqDist> mfdConstraints = targetMFDs.getMFD_Constraints();
        double MFDTransitionMag = 7.85;
        Object metadata = "";
        IncrementalMagFreqDist targetOnFaultMFD = targetMFDs.getTotalOnFaultSupraSeisMFD();
        if (model.isConstrained()) {
            if (model == InversionModels.CHAR_CONSTRAINED) {
                participationSmoothnessConstraintWt = 0.0;
                nucleationMFDConstraintWt = 0.01;
                mfdSmoothnessConstraintWt = 0.0;
                mfdSmoothnessConstraintWtForPaleoParents = 1000.0;
                eventRateSmoothnessWt = 0.0;
                rupRateConstraintWt = 0.0;
                aPrioriRupConstraint = fm == null ? null : UCERF3InversionConfiguration.getUCERF2Solution(rupSet, fm);
                minimumRuptureRateFraction = 0.01;
                minimumRuptureRateBasis = UCERF3InversionConfiguration.adjustStartingModel(UCERF3InversionConfiguration.getSmoothStartingSolution(rupSet, targetOnFaultMFD), mfdConstraints, rupSet, true);
                initialRupModel = new double[rupSet.getNumRuptures()];
            } else {
                if (model != InversionModels.GR_CONSTRAINED) throw new IllegalStateException("Unknown inversion model: " + String.valueOf(model));
                participationSmoothnessConstraintWt = 1000.0;
                nucleationMFDConstraintWt = 0.0;
                mfdSmoothnessConstraintWt = 0.0;
                mfdSmoothnessConstraintWtForPaleoParents = 0.0;
                eventRateSmoothnessWt = 0.0;
                rupRateConstraintWt = 0.0;
                aPrioriRupConstraint = null;
                initialRupModel = UCERF3InversionConfiguration.getSmoothStartingSolution(rupSet, targetOnFaultMFD);
                minimumRuptureRateFraction = 0.01;
                minimumRuptureRateBasis = UCERF3InversionConfiguration.adjustStartingModel(initialRupModel, mfdConstraints, rupSet, true);
                if (mfdInequalityConstraintWt > 0.0 || mfdEqualityConstraintWt > 0.0) {
                    initialRupModel = UCERF3InversionConfiguration.adjustStartingModel(initialRupModel, mfdConstraints, rupSet, true);
                }
                initialRupModel = UCERF3InversionConfiguration.adjustParkfield(rupSet, initialRupModel);
                initialRupModel = UCERF3InversionConfiguration.removeRupsBelowMinMag(rupSet, initialRupModel);
            }
        } else {
            participationSmoothnessConstraintWt = 0.0;
            nucleationMFDConstraintWt = 0.0;
            mfdSmoothnessConstraintWt = 0.0;
            mfdSmoothnessConstraintWtForPaleoParents = 0.0;
            eventRateSmoothnessWt = 0.0;
            rupRateConstraintWt = 0.0;
            aPrioriRupConstraint = null;
            initialRupModel = new double[rupSet.getNumRuptures()];
            minimumRuptureRateBasis = null;
            minimumRuptureRateFraction = 0.0;
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.MFD_WT.getArgName())) {
            double d = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.MFD_WT.getArgName()));
            System.out.println("Setting MFD constraint wt: " + d);
            mfdInequalityConstraintWt *= d / mfdEqualityConstraintWt;
            mfdEqualityConstraintWt = d;
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.A_PRIORI_CONST_WT.getArgName())) {
            rupRateConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.A_PRIORI_CONST_WT.getArgName()));
            System.out.println("Setting a priori constraint wt: " + rupRateConstraintWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.WATER_LEVEL_FRACT.getArgName())) {
            minimumRuptureRateFraction = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.WATER_LEVEL_FRACT.getArgName()));
            System.out.println("Setting waterlevel fract: " + minimumRuptureRateFraction);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.PARKFIELD_WT.getArgName())) {
            parkfieldConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.PARKFIELD_WT.getArgName()));
            System.out.println("Setting parkfield constraint wt: " + parkfieldConstraintWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.AVE_SLIP_WT.getArgName())) {
            paleoSlipConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.AVE_SLIP_WT.getArgName()));
            System.out.println("Setting paleo slip constraint wt: " + paleoSlipConstraintWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.EVENT_SMOOTH_WT.getArgName())) {
            eventRateSmoothnessWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.EVENT_SMOOTH_WT.getArgName()));
            System.out.println("Setting event rate smoothness constraint wt: " + eventRateSmoothnessWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.SECTION_NUCLEATION_MFD_WT.getArgName())) {
            nucleationMFDConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.SECTION_NUCLEATION_MFD_WT.getArgName()));
            System.out.println("Setting section nucleation MFD constraint wt: " + nucleationMFDConstraintWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.MFD_TRANSITION_MAG.getArgName())) {
            MFDTransitionMag = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.MFD_TRANSITION_MAG.getArgName()));
            System.out.println("Setting MFD transition mag: " + MFDTransitionMag);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.MFD_SMOOTHNESS_WT.getArgName())) {
            mfdSmoothnessConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.MFD_SMOOTHNESS_WT.getArgName()));
            System.out.println("Setting MFD smoothness wt: " + MFDTransitionMag);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.PALEO_SECT_MFD_SMOOTH.getArgName())) {
            mfdSmoothnessConstraintWtForPaleoParents = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.PALEO_SECT_MFD_SMOOTH.getArgName()));
            System.out.println("Setting MFD smoothness for paleo sects wt: " + MFDTransitionMag);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.SLIP_WT_NORM.getArgName())) {
            slipRateConstraintWt_normalized = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.SLIP_WT_NORM.getArgName()));
            System.out.println("Setting normalized slip rate constraint wt: " + slipRateConstraintWt_normalized);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.SLIP_WT_UNNORM.getArgName())) {
            slipRateConstraintWt_unnormalized = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.SLIP_WT_UNNORM.getArgName()));
            System.out.println("Setting unnormalized slip rate constraint wt: " + slipRateConstraintWt_normalized);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.RUP_SMOOTH_WT.getArgName())) {
            rupRateSmoothingConstraintWt = Double.parseDouble(modifiers.getOptionValue(CommandLineInversionRunner.InversionOptions.RUP_SMOOTH_WT.getArgName()));
            System.out.println("Rupture rate smoothness constraint wt: " + rupRateSmoothingConstraintWt);
        }
        if (modifiers != null && modifiers.hasOption(CommandLineInversionRunner.InversionOptions.INITIAL_GR.getArgName())) {
            System.out.println("Setting initial rup model to GR model");
            initialRupModel = UCERF3InversionConfiguration.getSmoothStartingSolution(rupSet, targetOnFaultMFD);
            minimumRuptureRateFraction = 0.01;
            minimumRuptureRateBasis = UCERF3InversionConfiguration.adjustStartingModel(initialRupModel, mfdConstraints, rupSet, true);
            if (mfdInequalityConstraintWt > 0.0 || mfdEqualityConstraintWt > 0.0) {
                initialRupModel = UCERF3InversionConfiguration.adjustStartingModel(initialRupModel, mfdConstraints, rupSet, true);
            }
            initialRupModel = UCERF3InversionConfiguration.adjustParkfield(rupSet, initialRupModel);
            initialRupModel = UCERF3InversionConfiguration.removeRupsBelowMinMag(rupSet, initialRupModel);
        }
        if (mfdEqualityConstraintWt > 0.0 && mfdInequalityConstraintWt > 0.0) {
            metadata = (String)metadata + "\nMFDTransitionMag: " + MFDTransitionMag;
            mfdEqualityConstraints = UCERF3InversionConfiguration.restrictMFDConstraintMagRange(mfdConstraints, mfdConstraints.get(0).getMinX(), MFDTransitionMag);
            List<IncrementalMagFreqDist> list = UCERF3InversionConfiguration.restrictMFDConstraintMagRange(mfdConstraints, MFDTransitionMag, mfdConstraints.get(0).getMaxX());
            return new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, mfdEqualityConstraintWt, mfdInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, aPrioriRupConstraint, initialRupModel, minimumRuptureRateBasis, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, mfdEqualityConstraints, (List<? extends IncrementalMagFreqDist>)var51_36, minimumRuptureRateFraction, (String)metadata);
        } else if (mfdEqualityConstraintWt > 0.0) {
            mfdEqualityConstraints = mfdConstraints;
            ArrayList arrayList = new ArrayList();
            return new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, mfdEqualityConstraintWt, mfdInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, aPrioriRupConstraint, initialRupModel, minimumRuptureRateBasis, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, mfdEqualityConstraints, (List<? extends IncrementalMagFreqDist>)var51_36, minimumRuptureRateFraction, (String)metadata);
        } else if (mfdInequalityConstraintWt > 0.0) {
            mfdEqualityConstraints = new ArrayList<IncrementalMagFreqDist>();
            List<? extends IncrementalMagFreqDist> list = mfdConstraints;
            return new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, mfdEqualityConstraintWt, mfdInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, aPrioriRupConstraint, initialRupModel, minimumRuptureRateBasis, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, mfdEqualityConstraints, (List<? extends IncrementalMagFreqDist>)var51_36, minimumRuptureRateFraction, (String)metadata);
        } else {
            mfdEqualityConstraints = new ArrayList<IncrementalMagFreqDist>();
            ArrayList arrayList = new ArrayList();
        }
        return new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, mfdEqualityConstraintWt, mfdInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, aPrioriRupConstraint, initialRupModel, minimumRuptureRateBasis, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, mfdEqualityConstraints, (List<? extends IncrementalMagFreqDist>)var51_36, minimumRuptureRateFraction, (String)metadata);
    }

    private static double[] removeRupsBelowMinMag(FaultSystemRupSet rupSet, double[] initialRupModel) {
        for (int rup = 0; rup < rupSet.getNumRuptures(); ++rup) {
            if (!FaultSystemRupSetCalc.isRuptureBelowSectMinMag(rupSet, rup, rupSet.requireModule(ModSectMinMags.class))) continue;
            initialRupModel[rup] = 0.0;
        }
        return initialRupModel;
    }

    private static double[] adjustParkfield(FaultSystemRupSet rupSet, double[] initialRupModel) {
        int i;
        double parkfieldMeanRate = 0.04;
        int parkfieldParentSectID = 32;
        List<Integer> potentialRups = rupSet.getRupturesForParentSection(parkfieldParentSectID);
        ArrayList<Integer> parkfieldRups = new ArrayList<Integer>();
        block0: for (i = 0; i < potentialRups.size(); ++i) {
            List<Integer> sects = rupSet.getSectionsIndicesForRup(potentialRups.get(i));
            if (sects.size() < 6 || sects.size() > 8) continue;
            for (int s = 0; s < sects.size(); ++s) {
                int parent = rupSet.getFaultSectionData(sects.get(s)).getParentSectionId();
                if (parent != parkfieldParentSectID) continue block0;
            }
            parkfieldRups.add(potentialRups.get(i));
        }
        for (i = 0; i < parkfieldRups.size(); ++i) {
            initialRupModel[((Integer)parkfieldRups.get((int)i)).intValue()] = parkfieldMeanRate / (double)parkfieldRups.size();
        }
        return initialRupModel;
    }

    private static List<IncrementalMagFreqDist> restrictMFDConstraintMagRange(List<? extends IncrementalMagFreqDist> mfdConstraints, double minMag, double maxMag) {
        ArrayList<IncrementalMagFreqDist> newMFDConstraints = new ArrayList<IncrementalMagFreqDist>();
        for (int i = 0; i < mfdConstraints.size(); ++i) {
            IncrementalMagFreqDist originalMFD = mfdConstraints.get(i);
            double delta = originalMFD.getDelta();
            IncrementalMagFreqDist newMFD = new IncrementalMagFreqDist(minMag, maxMag, (int)Math.round((maxMag - minMag) / delta + 1.0));
            newMFD.setTolerance(delta / 2.0);
            for (double m = minMag; m <= maxMag; m += delta) {
                newMFD.set(m, originalMFD.getClosestYtoX(m));
            }
            newMFD.setRegion(originalMFD.getRegion());
            newMFDConstraints.add(i, newMFD);
        }
        return newMFDConstraints;
    }

    public static double[] adjustIsolatedSections(InversionFaultSystemRupSet rupSet, double[] initialRupModel) {
        int parentId;
        ArrayList<Integer> isolatedParents = new ArrayList<Integer>();
        ArrayList<String> isolatedParentNames = new ArrayList<String>();
        ArrayList<Integer> nonIsolatedParents = new ArrayList<Integer>();
        for (int sect = 0; sect < rupSet.getNumSections(); ++sect) {
            parentId = rupSet.getFaultSectionData(sect).getParentSectionId();
            List<Integer> rupsOnSect = rupSet.getRupturesForSection(sect);
            block1: for (int i = 0; i < rupsOnSect.size(); ++i) {
                int rup = rupsOnSect.get(i);
                List<Integer> sects = rupSet.getSectionsIndicesForRup(rup);
                for (int j = 0; j < sects.size(); ++j) {
                    int newSect = sects.get(j);
                    if (parentId == rupSet.getFaultSectionData(newSect).getParentSectionId()) continue;
                    if (!nonIsolatedParents.contains(parentId)) {
                        nonIsolatedParents.add(parentId);
                    }
                    if (!isolatedParents.contains(parentId)) break block1;
                    isolatedParents.remove(isolatedParents.indexOf(parentId));
                    isolatedParentNames.remove(rupSet.getFaultSectionDataList().get(newSect).getParentSectionName());
                    break block1;
                }
            }
            if (isolatedParents.contains(parentId) || nonIsolatedParents.contains(parentId)) continue;
            isolatedParents.add(parentId);
            isolatedParentNames.add(rupSet.getFaultSectionDataList().get(sect).getParentSectionName());
        }
        block3: for (int p = 0; p < isolatedParents.size(); ++p) {
            parentId = (Integer)isolatedParents.get(p);
            ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
            for (int sect = 0; sect < rupSet.getNumSections(); ++sect) {
                if (rupSet.getFaultSectionData(sect).getParentSectionId() != parentId) continue;
                sectsForParent.add(sect);
            }
            block5: for (int rup = 0; rup < rupSet.getNumRuptures(); ++rup) {
                List<Integer> sects = rupSet.getSectionsIndicesForRup(rup);
                if (sects.size() != sectsForParent.size()) continue;
                for (int sect : sects) {
                    if (sectsForParent.contains(sect)) continue;
                    continue block5;
                }
                if (initialRupModel[rup] != 0.0) continue block3;
                double avgSlipRate = 0.0;
                for (int sect : sects) {
                    if (Double.isNaN(rupSet.getSlipRateForSection(sect))) continue;
                    avgSlipRate += rupSet.getSlipRateForSection(sect);
                }
                avgSlipRate /= (double)sects.size();
                double[] rupSlip = rupSet.getSlipOnSectionsForRup(rup);
                double avgSlip = 0.0;
                for (int i = 0; i < rupSlip.length; ++i) {
                    avgSlip += rupSlip[i];
                }
                double charRupRate = avgSlipRate / (avgSlip /= (double)rupSlip.length);
                System.out.println("Adjusting starting rupture rate for isolated fault " + (String)isolatedParentNames.get(p));
                initialRupModel[rup] = charRupRate;
                continue block3;
            }
        }
        return initialRupModel;
    }

    private static double[] adjustStartingModel(double[] initialRupModel, List<? extends IncrementalMagFreqDist> mfdInequalityConstraints, FaultSystemRupSet rupSet, boolean adjustOnlyIfOverMFD) {
        double[] rupMeanMag = rupSet.getMagForAllRups();
        for (int i = 0; i < mfdInequalityConstraints.size(); ++i) {
            double[] fractRupsInside = rupSet.getFractRupsInsideRegion(mfdInequalityConstraints.get(i).getRegion(), false);
            IncrementalMagFreqDist targetMagFreqDist = mfdInequalityConstraints.get(i);
            IncrementalMagFreqDist startingModelMagFreqDist = new IncrementalMagFreqDist(targetMagFreqDist.getMinX(), targetMagFreqDist.size(), targetMagFreqDist.getDelta());
            startingModelMagFreqDist.setTolerance(0.1);
            for (int rup = 0; rup < rupSet.getNumRuptures(); ++rup) {
                double mag = rupMeanMag[rup];
                double fractRupInside = fractRupsInside[rup];
                if (!(fractRupInside > 0.0) || !(mag < 8.5)) continue;
                startingModelMagFreqDist.add(mag, fractRupInside * initialRupModel[rup]);
            }
            IncrementalMagFreqDist adjustmentRatio = new IncrementalMagFreqDist(targetMagFreqDist.getMinX(), targetMagFreqDist.size(), targetMagFreqDist.getDelta());
            for (double m = targetMagFreqDist.getMinX(); m <= targetMagFreqDist.getMaxX(); m += targetMagFreqDist.getDelta()) {
                if (!adjustOnlyIfOverMFD) {
                    adjustmentRatio.set(m, targetMagFreqDist.getClosestYtoX(m) / startingModelMagFreqDist.getClosestYtoX(m));
                    continue;
                }
                if (startingModelMagFreqDist.getClosestYtoX(m) > targetMagFreqDist.getClosestYtoX(m)) {
                    adjustmentRatio.set(m, targetMagFreqDist.getClosestYtoX(m) / startingModelMagFreqDist.getClosestYtoX(m));
                    continue;
                }
                adjustmentRatio.set(m, 1.0);
            }
            for (int rup = 0; rup < rupSet.getNumRuptures(); ++rup) {
                double mag = rupMeanMag[rup];
                if (Double.isNaN(adjustmentRatio.getClosestYtoX(mag)) || Double.isInfinite(adjustmentRatio.getClosestYtoX(mag))) continue;
                initialRupModel[rup] = initialRupModel[rup] * adjustmentRatio.getClosestYtoX(mag);
            }
        }
        return initialRupModel;
    }

    public static ArrayList<double[]> getUCERF2MagsAndrates(InversionFaultSystemRupSet faultSystemRupSet) {
        return UCERF3InversionConfiguration.getUCERF2MagsAndrates(faultSystemRupSet, faultSystemRupSet.getFaultModel());
    }

    public static synchronized ArrayList<double[]> getUCERF2MagsAndrates(FaultSystemRupSet faultSystemRupSet, FaultModels fm) {
        Preconditions.checkNotNull((Object)faultSystemRupSet, (Object)"No rupture set supplied!");
        Preconditions.checkNotNull((Object)fm, (Object)"A fault model must be specified by the rupture set in order to get a UCERF2 solution. It's possible that you're using an old rupture set that doesn't have this data embedded. In that case, regenerate your rupture set (or beg Kevin to modify it for you)");
        FindEquivUCERF2_Ruptures findUCERF2_Rups = fm == FaultModels.FM2_1 ? new FindEquivUCERF2_FM2pt1_Ruptures(faultSystemRupSet, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR) : new FindEquivUCERF2_FM3_Ruptures(faultSystemRupSet, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, fm);
        return findUCERF2_Rups.getMagsAndRatesForRuptures();
    }

    public static double[] getUCERF2Solution(FaultSystemRupSet faultSystemRupSet, FaultModels fm) {
        ArrayList<double[]> ucerf2_magsAndRates = UCERF3InversionConfiguration.getUCERF2MagsAndrates(faultSystemRupSet, fm);
        int numRuptures = faultSystemRupSet.getNumRuptures();
        double[] initial_state = new double[numRuptures];
        for (int r = 0; r < numRuptures; ++r) {
            double[] magAndRate = ucerf2_magsAndRates.get(r);
            initial_state[r] = magAndRate != null ? magAndRate[1] : 0.0;
        }
        return initial_state;
    }

    public static void setMagNorm(double magNorm) {
        UCERF3InversionConfiguration.magNorm = magNorm;
    }

    public static double[] getSmoothStartingSolution(FaultSystemRupSet faultSystemRupSet, IncrementalMagFreqDist targetMagFreqDist) {
        int rup;
        List<List<Integer>> rupList = faultSystemRupSet.getSectionIndicesForAllRups();
        double[] rupMeanMag = faultSystemRupSet.getMagForAllRups();
        double[] sectSlipRateReduced = faultSystemRupSet.getSlipRateForAllSections();
        int numRup = rupMeanMag.length;
        double[] initial_state = new double[numRup];
        double[] minimumSlipRate = new double[numRup];
        for (int rup2 = 0; rup2 < numRup; ++rup2) {
            List<Integer> sects = faultSystemRupSet.getSectionsIndicesForRup(rup2);
            minimumSlipRate[rup2] = Double.POSITIVE_INFINITY;
            for (int i = 0; i < sects.size(); ++i) {
                int sect = sects.get(i);
                if (Double.isNaN(sectSlipRateReduced[sect]) || sectSlipRateReduced[sect] == 0.0) {
                    minimumSlipRate[rup2] = 0.0;
                    continue;
                }
                if (!(sectSlipRateReduced[sect] < minimumSlipRate[rup2])) continue;
                minimumSlipRate[rup2] = sectSlipRateReduced[sect];
            }
        }
        double minMag = Math.floor(faultSystemRupSet.getMinMag() * 10.0) / 10.0;
        double maxMag = Math.ceil(faultSystemRupSet.getMaxMag() * 10.0) / 10.0;
        IncrementalMagFreqDist magHist = new IncrementalMagFreqDist(minMag, (int)Math.round((maxMag - minMag) * 10.0 + 1.0), 0.1);
        magHist.setTolerance(0.05);
        for (rup = 0; rup < numRup; ++rup) {
            if (minimumSlipRate[rup] != 0.0) {
                magHist.add(rupMeanMag[rup], minimumSlipRate[rup]);
                continue;
            }
            magHist.add(rupMeanMag[rup], 1.0E-4);
        }
        for (rup = 0; rup < numRup; ++rup) {
            initial_state[rup] = targetMagFreqDist.getClosestYtoX(rupMeanMag[rup]) * minimumSlipRate[rup] / magHist.getClosestYtoX(rupMeanMag[rup]);
            if (!Double.isNaN(initial_state[rup]) && !Double.isInfinite(initial_state[rup])) continue;
            throw new IllegalStateException("Pre-normalization initial_state[" + rup + "] = " + initial_state[rup]);
        }
        double totalEventRate = 0.0;
        for (int rup3 = 0; rup3 < numRup; ++rup3) {
            if (!(rupMeanMag[rup3] > magNorm) || !(rupMeanMag[rup3] <= magNorm + 0.1)) continue;
            totalEventRate += initial_state[rup3];
        }
        double normalization = targetMagFreqDist.getClosestYtoX(magNorm) / totalEventRate;
        if (targetMagFreqDist.getClosestYtoX(magNorm) == 0.0) {
            throw new IllegalStateException("targetMagFreqDist.getClosestY(" + magNorm + ") = 0.  Check rupSet.getInversionMFDs().getTargetOnFaultSupraSeisMFD()");
        }
        for (int rup4 = 0; rup4 < numRup; ++rup4) {
            initial_state[rup4] = initial_state[rup4] * normalization;
            if (!Double.isNaN(initial_state[rup4]) && !Double.isInfinite(initial_state[rup4])) continue;
            throw new IllegalStateException("initial_state[" + rup4 + "] = " + initial_state[rup4] + " (norm=" + normalization + ", totalEventRate=" + totalEventRate + ")");
        }
        return initial_state;
    }

    public double getSlipRateConstraintWt_normalized() {
        return this.slipRateConstraintWt_normalized;
    }

    public void setSlipRateConstraintWt_normalized(double slipRateConstraintWt_normalized) {
        this.slipRateConstraintWt_normalized = slipRateConstraintWt_normalized;
    }

    public double getSlipRateConstraintWt_unnormalized() {
        return this.slipRateConstraintWt_unnormalized;
    }

    public void setSlipRateConstraintWt_unnormalized(double slipRateConstraintWt_unnormalized) {
        this.slipRateConstraintWt_unnormalized = slipRateConstraintWt_unnormalized;
    }

    public double getPaleoRateConstraintWt() {
        return this.paleoRateConstraintWt;
    }

    public void setPaleoRateConstraintWt(double paleoRateConstraintWt) {
        this.paleoRateConstraintWt = paleoRateConstraintWt;
    }

    public double getPaleoSlipConstraintWt() {
        return this.paleoSlipConstraintWt;
    }

    public void setPaleoSlipWt(double paleoSlipConstraintWt) {
        this.paleoSlipConstraintWt = paleoSlipConstraintWt;
    }

    public double getMagnitudeEqualityConstraintWt() {
        return this.magnitudeEqualityConstraintWt;
    }

    public void setMagnitudeEqualityConstraintWt(double relativeMagnitudeEqualityConstraintWt) {
        this.magnitudeEqualityConstraintWt = relativeMagnitudeEqualityConstraintWt;
    }

    public double getMagnitudeInequalityConstraintWt() {
        return this.magnitudeInequalityConstraintWt;
    }

    public void setMagnitudeInequalityConstraintWt(double relativeMagnitudeInequalityConstraintWt) {
        this.magnitudeInequalityConstraintWt = relativeMagnitudeInequalityConstraintWt;
    }

    public double getRupRateConstraintWt() {
        return this.rupRateConstraintWt;
    }

    public void setRupRateConstraintWt(double relativeRupRateConstraintWt) {
        this.rupRateConstraintWt = relativeRupRateConstraintWt;
    }

    public double getParticipationSmoothnessConstraintWt() {
        return this.participationSmoothnessConstraintWt;
    }

    public void setParticipationSmoothnessConstraintWt(double relativeParticipationSmoothnessConstraintWt) {
        this.participationSmoothnessConstraintWt = relativeParticipationSmoothnessConstraintWt;
    }

    public double getParticipationConstraintMagBinSize() {
        return this.participationConstraintMagBinSize;
    }

    public void setParticipationConstraintMagBinSize(double participationConstraintMagBinSize) {
        this.participationConstraintMagBinSize = participationConstraintMagBinSize;
    }

    public double getMinimizationConstraintWt() {
        return this.minimizationConstraintWt;
    }

    public void setMinimizationConstraintWt(double relativeMinimizationConstraintWt) {
        this.minimizationConstraintWt = relativeMinimizationConstraintWt;
    }

    public double getMomentConstraintWt() {
        return this.momentConstraintWt;
    }

    public void setMomentConstraintWt(double relativeMomentConstraintWt) {
        this.momentConstraintWt = relativeMomentConstraintWt;
    }

    public double getParkfieldConstraintWt() {
        return this.parkfieldConstraintWt;
    }

    public void setParkfieldConstraintWt(double relativeParkfieldConstraintWt) {
        this.parkfieldConstraintWt = relativeParkfieldConstraintWt;
    }

    public double[] getA_PrioriRupConstraint() {
        return this.aPrioriRupConstraint;
    }

    public void setA_PrioriRupConstraint(double[] aPrioriRupConstraint) {
        this.aPrioriRupConstraint = aPrioriRupConstraint;
    }

    public double[] getInitialRupModel() {
        return this.initialRupModel;
    }

    public void setInitialRupModel(double[] initialRupModel) {
        this.initialRupModel = initialRupModel;
    }

    public double[] getMinimumRuptureRateBasis() {
        return this.minimumRuptureRateBasis;
    }

    public void setMinimumRuptureRateBasis(double[] minimumRuptureRateBasis) {
        this.minimumRuptureRateBasis = minimumRuptureRateBasis;
    }

    public double getSmoothnessWt() {
        return this.smoothnessWt;
    }

    public void setSmoothnessWt(double relativeSmoothnessWt) {
        this.smoothnessWt = relativeSmoothnessWt;
    }

    public double getNucleationMFDConstraintWt() {
        return this.nucleationMFDConstraintWt;
    }

    public void setNucleationMFDConstraintWt(double relativeNucleationMFDConstraintWt) {
        this.nucleationMFDConstraintWt = relativeNucleationMFDConstraintWt;
    }

    public double getMFDSmoothnessConstraintWt() {
        return this.mfdSmoothnessConstraintWt;
    }

    public void setMFDSmoothnessConstraintWt(double relativeMFDSmoothnessConstraintWt) {
        this.mfdSmoothnessConstraintWt = relativeMFDSmoothnessConstraintWt;
    }

    public double getMFDSmoothnessConstraintWtForPaleoParents() {
        return this.mfdSmoothnessConstraintWtForPaleoParents;
    }

    public void setMFDSmoothnessConstraintWtForPaleoParents(double relativeMFDSmoothnessConstraintWtForPaleoParents) {
        this.mfdSmoothnessConstraintWtForPaleoParents = relativeMFDSmoothnessConstraintWtForPaleoParents;
    }

    public List<? extends IncrementalMagFreqDist> getMfdEqualityConstraints() {
        return this.mfdEqualityConstraints;
    }

    public void setMfdEqualityConstraints(List<? extends IncrementalMagFreqDist> mfdEqualityConstraints) {
        this.mfdEqualityConstraints = mfdEqualityConstraints;
    }

    public List<? extends IncrementalMagFreqDist> getMfdInequalityConstraints() {
        return this.mfdInequalityConstraints;
    }

    public void setMfdInequalityConstraints(List<? extends IncrementalMagFreqDist> mfdInequalityConstraints) {
        this.mfdInequalityConstraints = mfdInequalityConstraints;
    }

    public double getMinimumRuptureRateFraction() {
        return this.minimumRuptureRateFraction;
    }

    public void setMinimumRuptureRateFraction(double minimumRuptureRateFraction) {
        this.minimumRuptureRateFraction = minimumRuptureRateFraction;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void updateRupSetInfoString(FaultSystemRupSet rupSet) {
        Object info = rupSet.getInfoString();
        info = (String)info + "\n\n****** Inversion Configuration Metadata ******";
        info = (String)info + "\n" + this.getMetadata();
        info = (String)info + "\n**********************************************";
        rupSet.setInfoString((String)info);
    }

    public double getEventRateSmoothnessWt() {
        return this.eventRateSmoothnessWt;
    }

    public void setEventRateSmoothnessWt(double eventRateSmoothnessWt) {
        this.eventRateSmoothnessWt = eventRateSmoothnessWt;
    }

    public double getRupRateSmoothingConstraintWt() {
        return this.rupRateSmoothingConstraintWt;
    }

    public void setRupRateSmoothingConstraintWt(double rupRateSmoothingConstraintWt) {
        this.rupRateSmoothingConstraintWt = rupRateSmoothingConstraintWt;
    }

    public double getMFDTransitionMag() {
        return this.MFDTransitionMag;
    }

    public void setMFDTransitionMag(double mFDTransitionMag) {
        this.MFDTransitionMag = mFDTransitionMag;
    }

    public boolean isAPrioriConstraintForZeroRates() {
        return this.aPrioriConstraintForZeroRates;
    }

    public void setAPrioriConstraintForZeroRates(boolean aPrioriConstraintForZeroRates) {
        this.aPrioriConstraintForZeroRates = aPrioriConstraintForZeroRates;
    }

    public double getAPrioriConstraintForZeroRatesWtFactor() {
        return this.aPrioriConstraintForZeroRatesWtFactor;
    }

    public void setAPrioriConstraintForZeroRatesWtFactor(double aPrioriConstraintForZeroRatesWtFactor) {
        this.aPrioriConstraintForZeroRatesWtFactor = aPrioriConstraintForZeroRatesWtFactor;
    }

    public boolean isExcludeParkfieldRupsFromMfdEqualityConstraints() {
        return this.excludeParkfieldRupsFromMfdEqualityConstraints;
    }

    public void setExcludeParkfieldRupsFromMfdEqualityConstraints(boolean excludeParkfieldRupsFromMfdEqualityConstraints) {
        this.excludeParkfieldRupsFromMfdEqualityConstraints = excludeParkfieldRupsFromMfdEqualityConstraints;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("slipRateConstraintWt_normalized", "" + this.slipRateConstraintWt_normalized);
        el.addAttribute("slipRateConstraintWt_unnormalized", "" + this.slipRateConstraintWt_unnormalized);
        el.addAttribute("paleoRateConstraintWt", "" + this.paleoRateConstraintWt);
        el.addAttribute("paleoSlipConstraintWt", "" + this.paleoSlipConstraintWt);
        el.addAttribute("magnitudeEqualityConstraintWt", "" + this.magnitudeEqualityConstraintWt);
        el.addAttribute("magnitudeInequalityConstraintWt", "" + this.magnitudeInequalityConstraintWt);
        el.addAttribute("rupRateConstraintWt", "" + this.rupRateConstraintWt);
        el.addAttribute("participationSmoothnessConstraintWt", "" + this.participationSmoothnessConstraintWt);
        el.addAttribute("participationConstraintMagBinSize", "" + this.participationConstraintMagBinSize);
        el.addAttribute("nucleationMFDConstraintWt", "" + this.nucleationMFDConstraintWt);
        el.addAttribute("mfdSmoothnessConstraintWt", "" + this.mfdSmoothnessConstraintWt);
        el.addAttribute("mfdSmoothnessConstraintWtForPaleoParents", "" + this.mfdSmoothnessConstraintWtForPaleoParents);
        el.addAttribute("rupRateSmoothingConstraintWt", "" + this.rupRateSmoothingConstraintWt);
        el.addAttribute("minimizationConstraintWt", "" + this.minimizationConstraintWt);
        el.addAttribute("momentConstraintWt", "" + this.momentConstraintWt);
        el.addAttribute("parkfieldConstraintWt", "" + this.parkfieldConstraintWt);
        el.addAttribute("MFDTransitionMag", "" + this.MFDTransitionMag);
        el.addAttribute("minimumRuptureRateFraction", "" + this.minimumRuptureRateFraction);
        el.addAttribute("smoothnessWt", "" + this.smoothnessWt);
        el.addAttribute("eventRateSmoothnessWt", "" + this.eventRateSmoothnessWt);
        Element equalMFDsEl = el.addElement("MFD_EqualityConstraints");
        UCERF3InversionConfiguration.mfdsToXML(equalMFDsEl, this.mfdEqualityConstraints);
        Element inequalMFDsEl = el.addElement("MFD_InequalityConstraints");
        UCERF3InversionConfiguration.mfdsToXML(inequalMFDsEl, this.mfdInequalityConstraints);
        return null;
    }

    private static void mfdsToXML(Element el, List<? extends IncrementalMagFreqDist> constraints) {
        for (int i = 0; i < constraints.size(); ++i) {
            MFD_InversionConstraint constr = new MFD_InversionConstraint(constraints.get(i));
            constr.toXMLMetadata(el);
        }
        List<Element> subEls = XMLUtils.getSubElementsList(el);
        for (int i = 0; i < subEls.size(); ++i) {
            subEls.get(i).addAttribute("index", "" + i);
        }
    }

    public static UCERF3InversionConfiguration fromXMLMetadata(Element confEl) {
        double slipRateConstraintWt_normalized = Double.parseDouble(confEl.attributeValue("slipRateConstraintWt_normalized"));
        double slipRateConstraintWt_unnormalized = Double.parseDouble(confEl.attributeValue("slipRateConstraintWt_unnormalized"));
        double paleoRateConstraintWt = Double.parseDouble(confEl.attributeValue("paleoRateConstraintWt"));
        double paleoSlipConstraintWt = Double.parseDouble(confEl.attributeValue("paleoSlipConstraintWt"));
        double magnitudeEqualityConstraintWt = Double.parseDouble(confEl.attributeValue("magnitudeEqualityConstraintWt"));
        double magnitudeInequalityConstraintWt = Double.parseDouble(confEl.attributeValue("magnitudeInequalityConstraintWt"));
        double rupRateConstraintWt = Double.parseDouble(confEl.attributeValue("rupRateConstraintWt"));
        double participationSmoothnessConstraintWt = Double.parseDouble(confEl.attributeValue("participationSmoothnessConstraintWt"));
        double participationConstraintMagBinSize = Double.parseDouble(confEl.attributeValue("participationConstraintMagBinSize"));
        double nucleationMFDConstraintWt = Double.parseDouble(confEl.attributeValue("nucleationMFDConstraintWt"));
        double mfdSmoothnessConstraintWt = Double.parseDouble(confEl.attributeValue("mfdSmoothnessConstraintWt"));
        double mfdSmoothnessConstraintWtForPaleoParents = Double.parseDouble(confEl.attributeValue("mfdSmoothnessConstraintWtForPaleoParents"));
        double rupRateSmoothingConstraintWt = Double.parseDouble(confEl.attributeValue("rupRateSmoothingConstraintWt"));
        double minimizationConstraintWt = Double.parseDouble(confEl.attributeValue("minimizationConstraintWt"));
        double momentConstraintWt = Double.parseDouble(confEl.attributeValue("momentConstraintWt"));
        double parkfieldConstraintWt = Double.parseDouble(confEl.attributeValue("parkfieldConstraintWt"));
        double MFDTransitionMag = Double.parseDouble(confEl.attributeValue("MFDTransitionMag"));
        double minimumRuptureRateFraction = Double.parseDouble(confEl.attributeValue("minimumRuptureRateFraction"));
        double smoothnessWt = Double.parseDouble(confEl.attributeValue("smoothnessWt"));
        double eventRateSmoothnessWt = Double.parseDouble(confEl.attributeValue("eventRateSmoothnessWt"));
        List<IncrementalMagFreqDist> mfdEqualityConstraints = UCERF3InversionConfiguration.mfdsFromXML(confEl.element("MFD_EqualityConstraints"));
        List<IncrementalMagFreqDist> mfdInequalityConstraints = UCERF3InversionConfiguration.mfdsFromXML(confEl.element("MFD_InequalityConstraints"));
        return new UCERF3InversionConfiguration(slipRateConstraintWt_normalized, slipRateConstraintWt_unnormalized, paleoRateConstraintWt, paleoSlipConstraintWt, magnitudeEqualityConstraintWt, magnitudeInequalityConstraintWt, rupRateConstraintWt, participationSmoothnessConstraintWt, participationConstraintMagBinSize, nucleationMFDConstraintWt, mfdSmoothnessConstraintWt, mfdSmoothnessConstraintWtForPaleoParents, rupRateSmoothingConstraintWt, minimizationConstraintWt, momentConstraintWt, parkfieldConstraintWt, null, null, null, smoothnessWt, eventRateSmoothnessWt, MFDTransitionMag, mfdEqualityConstraints, mfdInequalityConstraints, minimumRuptureRateFraction, null);
    }

    private static List<IncrementalMagFreqDist> mfdsFromXML(Element mfdsEl) {
        List<Element> mfdElList = XMLUtils.getSortedChildElements(mfdsEl, null, "index");
        ArrayList mfds = Lists.newArrayList();
        for (Element mfdEl : mfdElList) {
            MFD_InversionConstraint constr = MFD_InversionConstraint.fromXMLMetadata(mfdEl);
            mfds.add(constr.getMagFreqDist());
        }
        return mfds;
    }
}

